<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Articles extends CI_Controller
{


	public function index()
	{
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			// $this->langDirs = array( BASEPATH . 'language', APPPATH . 'language' );
		  // $lang = 'english';
		  // $data['lang'] = $lang;
		  // $this->lang->load('home_lang', $lang);
			
			$header['title'] = 'Gestion Commercial - Gestion Familles Article';
			$header['page'] = 'famillesArticles';
			$data['famillesArticles'] = $this->ArticlesModel->getFamillesArticles();
			$this->load->view('templates/header',$header);
			$this->load->view('familleArticle',$data);
			$this->load->view('templates/footer');

		}

	}

	public function filtrerArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$term = $this->input->post('term');
			$type_id = $this->input->post('type_id');
			$articles = $this->ArticlesModel->filtrerProduits($term,$type_id);
			$output = json_encode(array("session"=>true,"result"=>true,'articles' => $articles));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}

	public function getArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$article = $this->ArticlesModel->getArticle($idProp);

			if($article){

				$output = json_encode(array("session"=>true,"result"=>true,'article' => $article));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);
			}	

		}

	}




    public function printFacture($id){

      $data['facture'] = $this->ArticlesModel->getFacture($id);
      $data['total'] = 0;
      $data['totalttc'] = 0;


      foreach ($data['facture'] as $key => $produit) {

        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

      }  

      $data['totaltva'] = $data['totalttc'] - $data['total'];

      $data['totall'] = $this->getConversion($data['totalttc']);

      if(count($data['facture'])<16){
        $number = count($data['facture']);

        for ($i=$number; $i < 12; $i++) { 

          array_push($data['facture'],array('DATE'=>$data['facture'][0]['DATE'],'NUMDOC'=>$data['facture'][0]['NUMDOC'],'NOMTIER'=>$data['facture'][0]['NOMTIER'],'ADRESSE'=>$data['facture'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

        }
      }

      $html = $this->load->view('pdf/facture',$data, true);

      $this->load->library('pdf');
                          
      $this->dompdf->loadHtml($html);
                          
      $this->dompdf->setPaper('A4', 'portrait');
            
      $this->dompdf->render();

      $this->dompdf->stream("FACTURE-".$id.".pdf", array("Attachment"=>true));

  }

    public function viewBL($id){

      $data['devis'] = $this->ArticlesModel->getBonLivraison($id);
      $data['total'] = 0;
      $data['totalttc'] = 0;

      foreach ($data['devis'] as $key => $produit) {

        $data['total'] += $produit['QTE'] * $produit['PUHT'];

        $data['totalttc'] += $produit['QTE'] * $produit['PTTC'];
 
      }      

      $data['totall'] = $this->getConversion($data['total']);

      if(count($data['devis'])<16){
        $number = count($data['devis']);

        for ($i=$number; $i < 20; $i++) { 

          array_push($data['devis'],array('DATE'=>$data['devis'][0]['DATE'],'NUMDOC'=>$data['devis'][0]['NUMDOC'],'NOMTIER'=>$data['devis'][0]['NOMTIER'],'ADRESSE'=>$data['devis'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>''));

        }

      }

      $this->load->view('pdf/bonsLivraison',$data);

  }

  function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 




	public function familleFournisseur()
	{
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Familles Fournisseur';
			$header['page'] = 'famillesFournisseurs';
			$data['famillesFournisseurs'] = $this->ArticlesModel->getFamillesFournisseurs();
			$this->load->view('templates/header',$header);
			$this->load->view('familleFournisseur',$data);
			$this->load->view('templates/footer');
		}
	}

	public function familleClient()
	{
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Familles Client';
			$header['page'] = 'famillesClients';

			$data['famillesClients'] = $this->ArticlesModel->getFamillesClients();
			$this->load->view('templates/header',$header);
			$this->load->view('familleClient',$data);
			$this->load->view('templates/footer');
		}

	}

	public function marques()
	{
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Marques';
			$header['page'] = 'marques';
			$data['marques'] = $this->ArticlesModel->getMarques();
			$this->load->view('templates/header',$header);
			$this->load->view('marques',$data);
			$this->load->view('templates/footer');
		}

	}

	public function regions()
	{

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Regions';
			$header['page'] = 'regions';

			$data['regions'] = $this->ArticlesModel->getRegions();
			$this->load->view('templates/header',$header);
			$this->load->view('regions',$data);
			$this->load->view('templates/footer');

		}

	}

	public function modesPaiement()
	{

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Modes Paiement';
			$header['page'] = 'modesPaiement';
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$this->load->view('templates/header',$header);
			$this->load->view('modePaiement',$data);
			$this->load->view('templates/footer');		
		}

	}

	public function banques(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Banques';
			$header['page'] = 'banques';
			$data['banques'] = $this->ArticlesModel->getBanques();
			$this->load->view('templates/header',$header);
			$this->load->view('banques',$data);
			$this->load->view('templates/footer');			
		}
	}



	public function unites(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Unites';
			$header['page'] = 'unites';
			$data['unites'] = $this->ArticlesModel->getUnites();
			$this->load->view('templates/header',$header);
			$this->load->view('unites',$data);
			$this->load->view('templates/footer');			
		}
	}


	public function tvas(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion TVAs';
			$header['page'] = 'tvas';
			$data['tvas'] = $this->ArticlesModel->getTVAs();
			$this->load->view('templates/header',$header);
			$this->load->view('tvas',$data);
			$this->load->view('templates/footer');	

		}
	}


	public function gammes(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['proprietes'] = $this->ArticlesModel->getProprietes();
			$header['title'] = 'Gestion Commercial - Gestion Gammes';
			$header['page'] = 'gammes';
			$this->load->view('templates/header',$header);
			$this->load->view('gammes',$data);
			$this->load->view('templates/footer');
		}
	}

	public function depots(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Depots';
			$header['page'] = 'depots';
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['pays'] = $this->ArticlesModel->getPays();
			$this->load->view('templates/header',$header);
			$this->load->view('depots',$data);
			$this->load->view('templates/footer');
		}

	}

	public function tarifs(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Tarifs';
			$header['page'] = 'tarifs';
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$this->load->view('templates/header',$header);
			$this->load->view('tarifs',$data);
			$this->load->view('templates/footer');
		}
	}




	public function deleteArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeProduit($idProp,$user_id)){

				$famillesClients = $this->ArticlesModel->getProduits();

				$output = json_encode(array("session"=>true,"result"=>true,'articles' => $famillesClients,'count'=>count($famillesClients)));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}	
		}
		
	}



	public function activerArticle(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerProduit($idProp,$activer,$user_id)){

				$famillesClients = $this->ArticlesModel->getProduits();

				$output = json_encode(array("session"=>true,"result"=>true,'articles' => $famillesClients,'count'=>count($famillesClients)));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}	

		}

	}


	public function insertPropierte(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->insertPropierte($propierte,$idProp)){

				$proprietes = $this->ArticlesModel->getProprietes();

				$output =  json_encode(array("session"=>true,"result"=>true,'gammes' => $proprietes,'count'=>count($proprietes)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
					
		}


	}

	public function insertGamme(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$gamme = $this->input->post('gamme');
			$adefinir = $this->input->post('adefinir');

			if($this->ArticlesModel->insertGamme($gamme,$adefinir)){

				$proprietes = $this->ArticlesModel->getProprietes();
		
				$output =  json_encode(array("session"=>true,"result"=>true,'gammes' => $proprietes,'count'=>count($proprietes)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}

		}


	}


	public function activerGamme(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');
			if($this->ArticlesModel->activerGamme($idProp,$activer)){

				$proprietes = $this->ArticlesModel->getProprietes();
		
				$output =  json_encode(array("session"=>true,"result"=>true,'gammes' => $proprietes,'count'=>count($proprietes)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}


	public function deleteGamme(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			if($this->ArticlesModel->deleteGamme($idProp)){
				$proprietes = $this->ArticlesModel->getProprietes();

				$output =  json_encode(array("session"=>true,"result"=>true,'gammes' => $proprietes,'count'=>count($proprietes)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}

	public function updateDepot(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$propierte = $this->input->post('propierte');
			$responsable = $this->input->post('responsable');
			$tel = $this->input->post('tel');
			$ville = $this->input->post('ville');
			$pays = $this->input->post('pays');
			$adresse = $this->input->post('adresse');	
			$stockable = $this->input->post('stockable');

			if($this->ArticlesModel->updateDepot($idProp,$propierte,$responsable,$tel,$ville,$pays,$adresse,$stockable)){

				$famillesClients = $this->ArticlesModel->getDepots();

				$output =  json_encode(array("session"=>true,"result"=>true,'depots' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}
	}




	public function insertDepot(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$responsable = $this->input->post('responsable');
			$tel = $this->input->post('tel');
			$ville = $this->input->post('ville');
			$pays = $this->input->post('pays');
			$adresse = $this->input->post('adresse');	
			$stockable = $this->input->post('stockable');

			if($this->ArticlesModel->insertDepot($propierte,$responsable,$tel,$ville,$pays,$adresse,$stockable)){

				$famillesClients = $this->ArticlesModel->getDepots();

				$output =  json_encode(array("session"=>true,"result"=>true,'depots' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}
	}

	public function deleteDepot(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeDepot($idProp)){

				$famillesClients = $this->ArticlesModel->getDepots();

				$output =  json_encode(array("session"=>true,"result"=>true,'depots' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
		}
		
	}



	public function activerDepot(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerDepot($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getDepots();

				$output =  json_encode(array("session"=>true,"result"=>true,'depots' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	

		}

	}

	public function deleteTVA(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeTVA($idProp)){

				$famillesClients = $this->ArticlesModel->getTVAs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tvas' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
		}
		
	}



	public function activerTVA(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerTVA($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getTVAs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tvas' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	

		}

	}


	public function insertTVA(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$taux = $this->input->post('taux');

			if($this->ArticlesModel->insertTVA($propierte,$taux)){

				$famillesClients = $this->ArticlesModel->getTVAs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tvas' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			

		}
	}


	public function updateTVA(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');
			$taux = $this->input->post('taux');

			if($this->ArticlesModel->updateTVA($idProp,$propierte,$taux)){

				$famillesClients = $this->ArticlesModel->getTVAs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tvas' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}




	public function deleteTarif(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeTarif($idProp)){

				$famillesClients = $this->ArticlesModel->getTarifs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tarifs' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
		}
		
	}



	public function activerTarif(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerTarif($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getTarifs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tarifs' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	

		}

	}


	public function insertTarif(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertTarif($propierte)){

				$famillesClients = $this->ArticlesModel->getTarifs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tarifs' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function updateTarif(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');


			if($this->ArticlesModel->updateTarif($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getTarifs();

				$output =  json_encode(array("session"=>true,"result"=>true,'tarifs' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}













	public function deleteUnite(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeUnite($idProp)){

				$famillesClients = $this->ArticlesModel->getUnites();

				$output =  json_encode(array("session"=>true,"result"=>true,'unites' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
		}
		
	}



	public function activerUnite(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');


			if($this->ArticlesModel->masquerUnite($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getUnites();

				$output =  json_encode(array("session"=>true,"result"=>true,'unites' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	

		}

	}


	public function insertUnite(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertUnite($propierte)){

				$famillesClients = $this->ArticlesModel->getUnites();

				$output =  json_encode(array("session"=>true,"result"=>true,'unites' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function updateUnite(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');


			if($this->ArticlesModel->updateUnite($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getUnites();

				$output =  json_encode(array("session"=>true,"result"=>true,'unites' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}




















	public function deleteBanque(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeBanque($idProp)){

				$famillesClients = $this->ArticlesModel->getBanques();

				$output =  json_encode(array("session"=>true,"result"=>true,'banques' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output =  json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	
		}

	}



	public function activerBanque(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerBanque($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getBanques();

				$output = json_encode(array("session"=>true,"result"=>true,'banques' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}	

		}

	}


	public function insertBanque(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertBanque($propierte)){

				$famillesClients = $this->ArticlesModel->getBanques();

				$output = json_encode(array("session"=>true,"result"=>true,'banques' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function updateBanque(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');


			if($this->ArticlesModel->updateBanque($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getBanques();

				$output = json_encode(array("session"=>true,"result"=>true,'banques' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function deleteModePaiement(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeModePaiement($idProp)){

					$famillesClients = $this->ArticlesModel->getModesPaiements();
					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
								$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
					$output = json_encode(array("session"=>true,"result"=>false));
								$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}



	public function activerModePaiement(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerModePaiement($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getModesPaiements();
				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function insertModePaiement(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$numC = $this->input->post('numeroC');
			$codeJ = $this->input->post('codej');

			if($this->ArticlesModel->insertModePaiement($propierte,$numC,$codeJ)){

				$famillesClients = $this->ArticlesModel->getModesPaiements();
				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}

	}


	public function updateModePaiement(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');
			$numC = $this->input->post('numeroC');
			$codeJ = $this->input->post('codej');


			if($this->ArticlesModel->updateModePaiement($idProp,$propierte,$numC,$codeJ)){

					$famillesClients = $this->ArticlesModel->getModesPaiements();
					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));

						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}else{
					$output = json_encode(array("session"=>true,"result"=>false));
											$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			
		}


	}






	public function deleteRegion(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeRegion($idProp)){

				$famillesClients = $this->ArticlesModel->getRegions();

				$output = json_encode(array("session"=>true,"result"=>true,'regions' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}


	}



	public function activerRegion(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerRegion($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getRegions();

				$output = json_encode(array("session"=>true,"result"=>true,'regions' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}


	public function insertRegion(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertRegion($propierte)){

				$famillesClients = $this->ArticlesModel->getRegions();

				$output = json_encode(array("session"=>true,"result"=>true,'regions' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}


	public function updateRegion(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->updateRegion($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getRegions();

				$output = json_encode(array("session"=>true,"result"=>true,'regions' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}


	}

	public function deleteMarque(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
		
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeMarque($idProp)){
				$famillesClients = $this->ArticlesModel->getMarques();

				$output = json_encode(array("session"=>true,"result"=>true,'marques' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}



	public function activerMarque(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerMarque($idProp,$activer)){
				$famillesClients = $this->ArticlesModel->getMarques();

				$output = json_encode(array("session"=>true,"result"=>true,'marques' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			

		}


	}


	public function insertMarque(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertMarque($propierte)){

				$famillesClients = $this->ArticlesModel->getMarques();

				$output = json_encode(array("session"=>true,"result"=>true,'marques' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			

		}


	}


	public function updateMarque(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->updateMarque($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getMarques();

				$output = json_encode(array("session"=>true,"result"=>true,'marques' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}


	public function deleteFamillesFournisseur(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
									$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeFamilleFournisseur($idProp)){

				$famillesClients = $this->ArticlesModel->getFamillesFournisseurs();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}
	}



	public function activerFamillesFournisseur(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerFamilleFournisseur($idProp,$activer)){

				$famillesClients = $this->ArticlesModel->getFamillesFournisseurs();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}
	}


	public function insertFamillesFournisseur(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$propierte = $this->input->post('propierte');

			$html = '';

			if($this->ArticlesModel->insertFamilleFournisseur($propierte)){

			$famillesClients = $this->ArticlesModel->getFamillesFournisseurs();


					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
														$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}

		}


	}


	public function updateFamillesFournisseur(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->updateFamilleFournisseur($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getFamillesFournisseurs();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}


	public function activerFamilleArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerFamilleArticle($idProp,$activer)){

			$famillesClients = $this->ArticlesModel->getFamillesArticles();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}


	}

	public function deleteFamilleArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeFamilleArticle($idProp)){

				$famillesClients = $this->ArticlesModel->getFamillesArticles();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}			

		}


	}


	public function insertFamilleArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			if($this->ArticlesModel->insertFamilleArticle($propierte)){

			$famillesClients = $this->ArticlesModel->getFamillesArticles();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}


	}


	public function updateFamilleArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->updateFamilleArticle($idProp,$propierte)){

			$famillesClients = $this->ArticlesModel->getFamillesArticles();

				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}


public function deleteFamilleClient(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');

			$html = '';

			if($this->ArticlesModel->removeFamilleClient($idProp)){

			$famillesClients = $this->ArticlesModel->getFamillesClients();

					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{
					$output = json_encode(array("session"=>true,"result"=>false));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}
		}
	}



	public function activerFamilleClient(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			$html = '';

			if($this->ArticlesModel->masquerFamilleClient($idProp,$activer)){

			$famillesClients = $this->ArticlesModel->getFamillesClients();

					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{
					$output = json_encode(array("session"=>true,"result"=>false));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}
		}
	}


	public function insertFamilleClient(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');

			$html = '';

			if($this->ArticlesModel->insertFamilleClient($propierte)){

			$famillesClients = $this->ArticlesModel->getFamillesClients();


					$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{
					$output = json_encode(array("session"=>true,"result"=>false));
														$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}
		}
	}


	public function updateFamilleClient(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
												$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$propierte = $this->input->post('propierte');
			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->updateFamilleClient($idProp,$propierte)){

				$famillesClients = $this->ArticlesModel->getFamillesClients();


				$output = json_encode(array("session"=>true,"result"=>true,'familles' => $famillesClients,'count'=>count($famillesClients)));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("session"=>true,"result"=>false));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}

	}







	public function updateParametres(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateParametres($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));

			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}
		}
	}



	public function parametres(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$header['title'] = 'Gestion Commercial - Parametrages';
			$header['page'] = 'parametres';

			$data['parametres'] = $this->ArticlesModel->getParametres();
			$this->load->view('templates/header',$header);
			$this->load->view('parametrages',$data);
			$this->load->view('templates/footer');
		}



	}
	public function addBonReception(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['contres'] = $this->ArticlesModel->getContres();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduitsStock();
			$data['clients'] = $this->ArticlesModel->getFournisseurs();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Bon Reception';
			$header['page'] = 'bonsReception';

			$this->load->view('templates/header',$header);
			$this->load->view('addBonReception',$data);
			$this->load->view('templates/footer');
		}
	}
	

	public function editBonReception($id = 1){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['bonLivraison'] = $this->ArticlesModel->getBonReception($id);
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getFournisseurs();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['articles'] = $this->ArticlesModel->getProduitsStock($id);
			$header['title'] = 'Gestion Commercial - Gestion Bon Reception';
			$header['page'] = 'bonsReception';

			$this->load->view('templates/header',$header);
			$this->load->view('editBonReception',$data);
			$this->load->view('templates/footer');
		}
	}



	public function bonsCommande(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			// $data['devis'] = $this->ArticlesModel->getBonsCommande();
			// $data['tot'] = $this->ArticlesModel->getBonsCommandeTot();
			// if(count($data['tot'])>0){
			// 	$data['total'] = $data['tot'][0]['total'];
			// 	$data['nbr'] = $data['tot'][0]['nbr'];
			// }else{
			// 	$data['total'] = 0;
			// 	$data['nbr'] = 0;
			// }

			$header['title'] = 'Gestion Commercial - Gestion Bons Commande';
			$header['page'] = 'bonsCommande';

			$this->load->view('templates/header',$header);
			$this->load->view('bonsCommande');
			$this->load->view('templates/footer');
		}

	}


	public function updateBonCommande(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$idBC = $this->input->post('idBC');

			if($this->ArticlesModel->updateBonCommande($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	


	public function updateBonLivraison(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$idBL = $this->input->post('idBL');

			if($this->ArticlesModel->updateBonLivraison($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	public function updateBonReception(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$idBR = $this->input->post('idBR');

			if($this->ArticlesModel->updateBonReception($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}

		}
	}

	public function getArticlesClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 $output = json_encode(array("session"=>false));
			 $this->output->set_content_type('application/json');
		   $this->output->set_output($output);
		}else{

			$id = $this->input->post('id');
			$idTarif = $this->input->post('idTarif');
			$term = $this->input->post('term');

			$articles = $this->ArticlesModel->getProduitsStock(0,$idTarif,$term);

			$output =  json_encode(array("result"=>true,"session"=>true,'articles'=>$articles,'count'=>count($articles)));
			$this->output->set_content_type('application/json');
		  $this->output->set_output($output);

		}

	}

		public function getArticlesFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$id = $this->input->post('id');
			$term = $this->input->post('term');

			$articles = $this->ArticlesModel->getProduitsAFournisseur(0,$term);

			$output = json_encode(array("result"=>true,"session"=>true,'articles'=>$articles,'count'=>count($articles)));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}

	public function filtererArticlesClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$id = $this->input->post('id');
			$idTarif = $this->input->post('idTarif');
			$term = $this->input->post('term');

			$articles = $this->ArticlesModel->filtererProduitsStock(0,$idTarif,$term);

			$output = json_encode(array("result"=>true,"session"=>true,'articles'=>$articles,'count'=>count($articles)));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}

	public function filtererArticlesFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$id = $this->input->post('id');
			$idTarif = $this->input->post('idTarif');
			$term = $this->input->post('term');

			$articles = $this->ArticlesModel->filtererProduitsStockAchat(0,$term);

			$output = json_encode(array("result"=>true,"session"=>true,'articles'=>$articles,'count'=>count($articles)));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}


	public function avoirs(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Avoirs';
			$header['page'] = 'avoirs';
			$data['avoirs'] = $this->ArticlesModel->getAvoirs();
			$data['tot'] = $this->ArticlesModel->getAvoirsTot();
			if(count($data['tot'])>0){
				$data['total'] = $data['tot'][0]['total'];
				$data['nbr'] = $data['tot'][0]['nbr'];
			}else{
				$data['total'] = 0;
				$data['nbr'] = 0;
			}
			$sum = 0;
			$this->load->view('templates/header',$header);
			$this->load->view('avoirs',$data);
			$this->load->view('templates/footer');
		}
	}

	public function charges(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Charges';
			$header['page'] = 'charges';
			$data['charges'] = $this->ArticlesModel->getCharges();
			$data['tot'] = $this->ArticlesModel->getChargesTot();
			if(count($data['tot'])>0){
				$data['total'] = $data['tot'][0]['total'];
				$data['nbr'] = $data['tot'][0]['nbr'];
			}else{
				$data['total'] = 0;
				$data['nbr'] = 0;
			}
			$sum = 0;
			$this->load->view('templates/header',$header);
			$this->load->view('charges',$data);
			$this->load->view('templates/footer');
		}
	}

	public function avoirsFournisseur(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Avoir Fournisseur';
			$header['page'] = 'avoirFournisseur';
			$data['avoirs'] = $this->ArticlesModel->getAvoirsFournisseur();
			$data['tot'] = $this->ArticlesModel->getAvoirsFournisseurTot();
			if(count($data['tot'])>0){
				$data['total'] = $data['tot'][0]['total'];
				$data['nbr'] = $data['tot'][0]['nbr'];
			}else{
				$data['total'] = 0;
				$data['nbr'] = 0;
			}
			$sum = 0;
			$this->load->view('templates/header',$header);
			$this->load->view('avoirsFournisseur',$data);
			$this->load->view('templates/footer');
		}
	}


	public function addCharge(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getCommerciaux();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Charges';
			$header['page'] = 'charges';
			$this->load->view('templates/header',$header);
			$this->load->view('addCharge',$data);
			$this->load->view('templates/footer');

		}

	}
	public function editCharge($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['charge'] = $this->ArticlesModel->getCharge($id);
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getCommerciaux();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['articles'] = $this->ArticlesModel->getProduitsStockAvoir($id,$data['charge'][0]['CODETIER']);

			$header['title'] = 'Gestion Commercial - Gestion Charges';
			$header['page'] = 'charges';
			$this->load->view('templates/header',$header);
			$this->load->view('editCharge',$data);
			$this->load->view('templates/footer');

		}

	}
	public function addAvoir(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Avoirs';
			$header['page'] = 'avoirs';
			$this->load->view('templates/header',$header);
			$this->load->view('addAvoir',$data);
			$this->load->view('templates/footer');

		}

	}
	public function editAvoir($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['avoir'] = $this->ArticlesModel->getAvoir($id);
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['articles'] = $this->ArticlesModel->getProduitsStockAvoir($id,$data['avoir'][0]['CODETIER']);

			$header['title'] = 'Gestion Commercial - Gestion Avoirs';
			$header['page'] = 'avoirs';
			$this->load->view('templates/header',$header);
			$this->load->view('editAvoir',$data);
			$this->load->view('templates/footer');

		}

	}
	public function editAvoirFournisseur($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['facture'] = $this->ArticlesModel->getFacture($id);
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Factures';
			$header['page'] = 'Factures';
			$this->load->view('templates/header',$header);
			$this->load->view('editAvoirFournisseur',$data);
			$this->load->view('templates/footer');

		}

	}
	public function addAvoirFournisseur($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['facture'] = $this->ArticlesModel->getFacture($id);
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Factures';
			$header['page'] = 'Factures';
			$this->load->view('templates/header',$header);
			$this->load->view('addAvoirFournisseur',$data);
			$this->load->view('templates/footer');

		}

	}


	public function editFacture($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['contres'] = $this->ArticlesModel->getContres();
			$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			$data['vehicules'] = $this->ArticlesModel->getVehicules();
			$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			$data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['facture'] = $this->ArticlesModel->getFacture($id);
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Factures';
			$header['page'] = 'Factures';
			$this->load->view('templates/header',$header);
			$this->load->view('editFacture',$data);
			$this->load->view('templates/footer');

		}

	}


	public function addFacture(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$header['title'] = 'Gestion Commercial - Gestion Factures';
			$header['page'] = 'Factures';

			$this->load->view('templates/header',$header);
			$this->load->view('addFacture',$data);
			$this->load->view('templates/footer');
		}

	}
	public function getArticles(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['famillesArticles'] = $this->ArticlesModel->getFamillesArticles();

      //$data['articles'] =array();


			$header['title'] = 'Gestion Commercial - Gestion Articles';
			$header['page'] = 'Articles';


			$this->load->view('templates/header',$header);
			$this->load->view('articles',$data);
			$this->load->view('templates/footer');

		}

	}


	public function addArticle(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$this->load->helper('string');
			$data['codebar'] = random_string('numeric', 10);
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['proprietes'] = $this->ArticlesModel->getProprietesDetails();
			$data['typesArticle'] = $this->ArticlesModel->getTypesArticle();
			$data['famillesArticles'] = $this->ArticlesModel->getFamillesArticles();
			$data['pays'] = $this->ArticlesModel->getPays();
			$data['marques'] = $this->ArticlesModel->getMarques();
			$data['unites'] = $this->ArticlesModel->getUnites();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['tvas'] = $this->ArticlesModel->getTVAs();
			$header['title'] = 'Gestion Commercial - Gestion Articles';
			$header['page'] = 'Articles';

			$type = pathinfo('assets/img/placeholder.png', PATHINFO_EXTENSION);

			$data['imgdata'] = 'data:image/' . $type . ';base64,' . base64_encode(file_get_contents('assets/img/placeholder.png'));

			$this->load->view('templates/header',$header);
			$this->load->view('addArticle',$data);
			$this->load->view('templates/footer');

		}


	}

	public function insertArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertArticle($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}


	public function editArticle($id = 1){

		// $code = rand(10000, 99999);
  //       $this->load->library('zend');
  //       $this->zend->load('Zend/Barcode');
  //       $file = Zend_Barcode::render('code128', 'image', array('text'=>$code, 
  //   'barHeight'=> 74, 
  //   'factor'=>5.98,), array());
  //       imagepng($file,"barcode/{$code}.png");
  //       die;
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['article'] = $this->ArticlesModel->getProduitById($id);
			$data['codebar'] = $data['article'][0]['codeBar'];
			$data['articles'] = $this->ArticlesModel->getProduits();
			$data['proprietes'] = $this->ArticlesModel->getProprietesDetails();
			$data['typesArticle'] = $this->ArticlesModel->getTypesArticle();
			$data['famillesArticles'] = $this->ArticlesModel->getFamillesArticles();
			$data['pays'] = $this->ArticlesModel->getPays();
			$data['marques'] = $this->ArticlesModel->getMarques();
			$data['unites'] = $this->ArticlesModel->getUnites();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['tvas'] = $this->ArticlesModel->getTVAs();
			$header['title'] = 'Gestion Commercial - Gestion Articles';
			$header['page'] = 'Articles';

			//$data['imgdata'] = $data['article'][0]['urlImg'];
			$type = pathinfo($data['article'][0]['urlImg'], PATHINFO_EXTENSION);

			$data['imgdata'] = 'data:image/' . $type . ';base64,' . base64_encode(file_get_contents($data['article'][0]['urlImg']));



			$this->load->view('templates/header',$header);
			$this->load->view('editArticle',$data);
			$this->load->view('templates/footer');
		}

	}

	public function updateArticle(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$idProduit = $this->input->post('idProduit');

			if($this->ArticlesModel->updateArticle($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}

		}
	}
	public function clients(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['clients'] = $this->ArticlesModel->getClients();
			$header['title'] = 'Gestion Commercial - Gestion Clients';
			$header['page'] = 'Clients';
			$this->load->view('templates/header',$header);
			$this->load->view('clients',$data);
			$this->load->view('templates/footer');

		}
	}


    public function setPassword(){

    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->setPasswordCommercial($json,$user_id)){

				$commerciaux = $this->ArticlesModel->getCommerciaux();

				$output = json_encode(array("session"=>true,"result"=>true,'commerciaux'=>$commerciaux,'count'=>count($commerciaux)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}

		}



    }

	public function deleteCommercial(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeCommercial($idProp,$user_id)){

				$commerciaux = $this->ArticlesModel->getCommerciaux();

				$output = json_encode(array("session"=>true,"result"=>true,'commerciaux'=>$commerciaux,'count'=>count($commerciaux)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}

		}


	}



	public function activerCommercial(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerCommercial($idProp,$activer,$user_id)){

				$commerciaux = $this->ArticlesModel->getCommerciaux();

				$output = json_encode(array("session"=>true,"result"=>true,'commerciaux'=>$commerciaux,'count'=>count($commerciaux)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{
				$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
			}

		}


	}












	public function editCommercial($id = 1){


		$data['commercial'] = $this->ArticlesModel->getCommercialById($id);

		$data['regions'] = $this->ArticlesModel->getRegions();


		$this->load->view('templates/header');
		$this->load->view('editCommercial',$data);
		$this->load->view('templates/footer');
	}



	public function addCommercial(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$header['title'] = 'Gestion Commercial - Gestion Commerciaux';
			$header['page'] = 'Commerciaux';

			$this->load->view('templates/header',$header);
			$this->load->view('addCommercial');
			$this->load->view('templates/footer');

		}
		
	}



	public function commerciaux(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$header['title'] = 'Gestion Commercial - Gestion Commerciaux';
			$header['page'] = 'Commerciaux';
			$data['commerciaux'] = $this->ArticlesModel->getCommerciaux();
			$this->load->view('templates/header',$header);
			$this->load->view('commerciaux',$data);
			$this->load->view('templates/footer');

		}

	}


	public function addClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['famillesClients'] = $this->ArticlesModel->getFamillesClients();
			$data['categoriesClient'] = $this->ArticlesModel->getCategoriesClient();
			$data['commerciaux'] = $this->ArticlesModel->getCommerciaux();
			$data['regions'] = $this->ArticlesModel->getRegions();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['delaisPaiment'] = $this->ArticlesModel->getDelaisPaiements();
			$data['pays'] = $this->ArticlesModel->getPays();

			$header['title'] = 'Gestion Commercial - Gestion Clients';
			$header['page'] = 'Clients';
			$this->load->view('templates/header',$header);
			$this->load->view('addClient',$data);
			$this->load->view('templates/footer');			
		}


	}

	public function insertClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertClient($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}

	public function activerFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerFournisseur($idProp,$activer,$user_id)){

				$fournisseurs = $this->ArticlesModel->getFournisseurs();

				$output = json_encode(array("result"=>true,"session"=>true,"fournisseurs"=>$fournisseurs));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}

	public function deleteFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeFournisseur($idProp,$user_id)){

				$fournisseurs  = $this->ArticlesModel->getFournisseurs();

				$output = json_encode(array("result"=>true,"session"=>true,"fournisseurs"=>$fournisseurs));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}

	public function activerClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');
			$activer = $this->input->post('activer');

			if($this->ArticlesModel->masquerClient($idProp,$activer,$user_id)){

				$clients = $this->ArticlesModel->getClients();

				$output = json_encode(array("result"=>true,"session"=>true,"clients"=>$clients));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}

	public function deleteClient(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$idProp = $this->input->post('idProp');

			if($this->ArticlesModel->removeClient($idProp,$user_id)){

				$clients  = $this->ArticlesModel->getClients();

				$output = json_encode(array("result"=>true,"session"=>true,"clients"=>$clients));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}



	public function updateCommercial(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateCommercial($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}


	public function insertCommercial(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertCommercial($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}


	public function editClient($id = 1){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['client'] = $this->ArticlesModel->getClientById($id);
			$data['categoriesClient'] = $this->ArticlesModel->getCategoriesClient();
			$data['famillesClients'] = $this->ArticlesModel->getFamillesClients();
			$data['commerciaux'] = $this->ArticlesModel->getCommerciaux();
			$data['regions'] = $this->ArticlesModel->getRegions();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['delaisPaiment'] = $this->ArticlesModel->getDelaisPaiements();
			$data['pays'] = $this->ArticlesModel->getPays();

			$header['title'] = 'Gestion Commercial - Gestion Clients';
			$header['page'] = 'Clients';
			$this->load->view('templates/header',$header);
			$this->load->view('editClient',$data);
			$this->load->view('templates/footer');
		}

	}

	public function editFournisseur($id = 1){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['fournisseur'] = $this->ArticlesModel->getFournisseurById($id);
			$data['familleFournisseurs'] = $this->ArticlesModel->getFamillesFournisseurs();
			$data['delaisPaiment'] = $this->ArticlesModel->getDelaisPaiements();
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['pays'] = $this->ArticlesModel->getPays();

			$header['title'] = 'Gestion Commercial - Gestion Fournisseur';
			$header['page'] = 'Fournisseur';
			$this->load->view('templates/header',$header);
			$this->load->view('editFournisseur',$data);
			$this->load->view('templates/footer');			
		}

	}

	public function addFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['familleFournisseurs'] = $this->ArticlesModel->getFamillesFournisseurs();
			$data['delaisPaiment'] = $this->ArticlesModel->getDelaisPaiements();
			$data['tarifs'] = $this->ArticlesModel->getTarifs();
			$data['pays'] = $this->ArticlesModel->getPays();

			$header['title'] = 'Gestion Commercial - Gestion Fournisseur';
			$header['page'] = 'Fournisseur';
			$this->load->view('templates/header',$header);
			$this->load->view('addFournisseur',$data);
			$this->load->view('templates/footer');

		}
	}

	public function fournisseurs()
	{

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$data['fournisseurs'] = $this->ArticlesModel->getFournisseurs();
			$header['title'] = 'Gestion Commercial - Gestion Fournisseur';
			$header['page'] = 'Fournisseur';
			$this->load->view('templates/header',$header);
			$this->load->view('fournisseurs',$data);
			$this->load->view('templates/footer');

		}
	}

	public function updateClient(){


		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateClient($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}

	}

	public function insertFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertFournisseur($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	public function updateFournisseur(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateFournisseur($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	public function insertAvoir(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertAvoir($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}

	public function insertCharges(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertCharges($json,$user_id)){

				$output =  json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output =  json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}




	public function insertAvoirF(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output =  json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertAvoirF($json,$user_id)){

				$output =  json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output =  json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	public function updateAvoir(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output =  json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateAvoir($json,$user_id)){

				$output =  json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output =  json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}

	public function updateAvoirF(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output =  json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateAvoirF($json,$user_id)){

				$output =  json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output =  json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}


	

















































	public function test(){

		$result = $this->ArticlesModel->facturerBonLivraison(10660);
		var_dump($result);

	}

	public function deleteVehicule(){

		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->removeVehicule($idProp)){

			$vehicules = $this->ArticlesModel->getVehicules();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Vehicules.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter une Vehicule</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idVehicule'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');">'.$vehicule['immatriculation'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
				$this->output->set_content_type('application/json');
      $this->output->set_output($output);



		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}



	public function activerVehicule(){

		$idProp = $this->input->post('idProp');
		$activer = $this->input->post('activer');

		$html = '';

		if($this->ArticlesModel->masquerVehicule($idProp,$activer)){

			$vehicules = $this->ArticlesModel->getVehicules();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Vehicules.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter une Vehicule</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idVehicule'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');">'.$vehicule['immatriculation'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}


	public function insertVehicule(){

		$propierte = $this->input->post('propierte');

		$html = '';

		if($this->ArticlesModel->insertVehicule($propierte)){
			$vehicules = $this->ArticlesModel->getVehicules();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Vehicules.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter une Vehicule</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idVehicule'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');">'.$vehicule['immatriculation'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}
			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}


	public function updateVehicule(){

		$propierte = $this->input->post('propierte');
		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->updateVehicule($idProp,$propierte)){

			$vehicules = $this->ArticlesModel->getVehicules();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Vehicules.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter une Vehicule</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idVehicule'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');">'.$vehicule['immatriculation'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['immatriculation'].'\','.$vehicule['idVehicule'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}

	}


	public function vehicules()
	{

		$data['vehicules'] = $this->ArticlesModel->getVehicules();
		$this->load->view('templates/header');
		$this->load->view('vehicules',$data);
		$this->load->view('templates/footer');

	}

	public function deleteSuperviseur(){

		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->removeSuperviseur($idProp)){

			$vehicules = $this->ArticlesModel->getSuperviseurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Superviseurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Superviseur</button> </div>';
            }

            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idSuperviseur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');">'.$vehicule['superviseur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';

			}

			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function activerSuperviseur(){

		$idProp = $this->input->post('idProp');
		$activer = $this->input->post('activer');

		$html = '';

		if($this->ArticlesModel->masquerSuperviseur($idProp,$activer)){

			$vehicules = $this->ArticlesModel->getSuperviseurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Superviseurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Superviseur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idSuperviseur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');">'.$vehicule['superviseur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function insertSuperviseur(){

		$propierte = $this->input->post('propierte');

		$html = '';

		if($this->ArticlesModel->insertSuperviseur($propierte)){
			$vehicules = $this->ArticlesModel->getSuperviseurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Superviseurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Superviseur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idSuperviseur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');">'.$vehicule['superviseur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}
			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function updateSuperviseur(){

		$propierte = $this->input->post('propierte');
		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->updateSuperviseur($idProp,$propierte)){

			$vehicules = $this->ArticlesModel->getSuperviseurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Superviseurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Superviseur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idSuperviseur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');">'.$vehicule['superviseur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['superviseur'].'\','.$vehicule['idSuperviseur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}


	public function superviseurs()
	{

		$data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
		$this->load->view('templates/header');
		$this->load->view('superviseurs',$data);
		$this->load->view('templates/footer');

	}

	public function deletePreparateur(){

		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->removePreparateur($idProp)){

			$vehicules = $this->ArticlesModel->getPreparateurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Preparateurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Preparateur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idPreparateur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');">'.$vehicule['preparateur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);




		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function activerPreparateur(){

		$idProp = $this->input->post('idProp');
		$activer = $this->input->post('activer');

		$html = '';

		if($this->ArticlesModel->masquerPreparateur($idProp,$activer)){

			$vehicules = $this->ArticlesModel->getPreparateurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Preparateurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Preparateur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idPreparateur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');">'.$vehicule['preparateur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function insertPreparateur(){

		$propierte = $this->input->post('propierte');

		$html = '';

		if($this->ArticlesModel->insertPreparateur($propierte)){
			$vehicules = $this->ArticlesModel->getPreparateurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Preparateurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Preparateur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idPreparateur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');">'.$vehicule['preparateur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}
			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function updatePreparateur(){

		$propierte = $this->input->post('propierte');
		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->updatePreparateur($idProp,$propierte)){

			$vehicules = $this->ArticlesModel->getPreparateurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Preparateurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Preparateur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idPreparateur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');">'.$vehicule['preparateur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['preparateur'].'\','.$vehicule['idPreparateur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function preparateurs()
	{

		$data['preparateurs'] = $this->ArticlesModel->getPreparateurs();
		$this->load->view('templates/header');
		$this->load->view('preparateurs',$data);
		$this->load->view('templates/footer');

	}

	public function deleteExpediteur(){

		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->removeExpediteur($idProp)){

			$vehicules = $this->ArticlesModel->getExpediteurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Expediteurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Expediteur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idExpediteur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');">'.$vehicule['expediteur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);




		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}



	public function activerExpediteur(){

		$idProp = $this->input->post('idProp');
		$activer = $this->input->post('activer');

		$html = '';

		if($this->ArticlesModel->masquerExpediteur($idProp,$activer)){

			$vehicules = $this->ArticlesModel->getExpediteurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Expediteurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Expediteur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idExpediteur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');">'.$vehicule['expediteur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}


	public function insertExpediteur(){

		$propierte = $this->input->post('propierte');

		$html = '';

		if($this->ArticlesModel->insertExpediteur($propierte)){
			$vehicules = $this->ArticlesModel->getExpediteurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Expediteurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Expediteur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idExpediteur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');">'.$vehicule['expediteur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}
			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}


	public function updateExpediteur(){

		$propierte = $this->input->post('propierte');
		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->updateExpediteur($idProp,$propierte)){

			$vehicules = $this->ArticlesModel->getExpediteurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Expediteurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Expediteur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idExpediteur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');">'.$vehicule['expediteur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['expediteur'].'\','.$vehicule['idExpediteur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}

	}


	public function expediteurs()
	{

		$data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
		$this->load->view('templates/header');
		$this->load->view('expediteurs',$data);
		$this->load->view('templates/footer');

	}


	public function deleteChauffeur(){

		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->removeChauffeur($idProp)){

			$vehicules = $this->ArticlesModel->getChauffeurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Chauffeurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Chauffeur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idChauffeur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');">'.$vehicule['chauffeur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));




		}else{
			$output = json_encode(array("result"=>false));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}
	}

	public function activerChauffeur(){

		$idProp = $this->input->post('idProp');
		$activer = $this->input->post('activer');

		$html = '';

		if($this->ArticlesModel->masquerChauffeur($idProp,$activer)){

			$vehicules = $this->ArticlesModel->getChauffeurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Chauffeurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Chauffeur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idChauffeur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');">'.$vehicule['chauffeur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));

		}else{
			$output = json_encode(array("result"=>false));
		}
	}

	public function insertChauffeur(){

		$propierte = $this->input->post('propierte');

		$html = '';

		if($this->ArticlesModel->insertChauffeur($propierte)){
			$vehicules = $this->ArticlesModel->getChauffeurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Chauffeurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Chauffeur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idChauffeur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');">'.$vehicule['chauffeur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}
			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));

		}else{
			$output = json_encode(array("result"=>false));
		}
	}

	public function updateChauffeur(){

		$propierte = $this->input->post('propierte');
		$idProp = $this->input->post('idProp');

		$html = '';

		if($this->ArticlesModel->updateChauffeur($idProp,$propierte)){

			$vehicules = $this->ArticlesModel->getChauffeurs();

			$html .='<div class="col-12 text-center" id="info-row-hexa">';

             if (count($vehicules)==0){

              $html .='<div class="info-row-hexa"> <i class="fa fa-layer-group fa-icon-info-hexa"></i> <span  class="gra-text-info-hexa">Chauffeurs.</span> <span  class="sub-text-info-hexa">Créez des bons de livraison avec des articles, des clients et des prix pour accelerer vos ventes.</span> <button class="btn top-btn-hexa" onclick="add()">Ajouter un Chauffeur</button> </div>';
            }


            $html .='</div>';

		    foreach ($vehicules as $key => $vehicule){

	          $html .='<div id="table-row-'.$key.'" class="table-row-hexa'; if ($key>50){ $html .=' table-row-hide-hexa '; } if (!$vehicule['active']){ $html .=' row-desactiver-hexa';
	          }

	           $html .=' row">
	            <div class="col-3 col-md-1 text-center hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" style="color:#9EA6B7">'.$vehicule['idChauffeur'].'</div>
	            <div class="col-8 col-md-10 text-client-hexa hexa-row"  onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');">'.$vehicule['chauffeur'].'</div> 
	            <div onclick="getOperation(\''.$vehicule['chauffeur'].'\','.$vehicule['idChauffeur'].','.$vehicule['active'].');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	              <i class="fa fa-ellipsis-v"></i>
	            </div>
	          </div> ';


			}


			$output = json_encode(array("result"=>true,'html' => $html,'count'=>count($vehicules)));

		}else{
			$output = json_encode(array("result"=>false));
		}
	}


	public function chauffeurs()
	{

		$data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
		$this->load->view('templates/header');
		$this->load->view('chauffeurs',$data);
		$this->load->view('templates/footer');

	}










































	




























	public function getPropierte(){


		$html = '<table id="list-properties"width="100%"><tr><td> <div class="row"> <div class="col-12 col-md-12 input-group  md-form form-sm form-2"> <div class="input-group-append"> <span onclick="getDatef()" class="input-group-text lime lighten-2 basic-text1"><i class="fas fa-see fa-search" aria-hidden="true"></i></span> </div> <input  onkeyup="searchProperty(this)" id="TextFieldsearchP" type="text" class="form-control input-hexa input-search" placeholder="Rechercher"> </div> </div> </tr>';
		$idProp = $this->input->post('idProp');
		$proprietes = $this->ArticlesModel->getPropierteById($idProp);
		$odd = true;

		foreach ($proprietes as $key => $propriete) { 
			$class="";
			if($odd){
				$odd = false;
				$class="odd-hexa";
			}else{
				$odd = true;
			}
			if($key>10){		
				$html .='<tr class="elem-class" style="display:none;"><td class="text-center '.$class.'" style="border: 1px solid #C3CAD8;padding:6px;"><span style="font-size:0.8rem;font-weight:500">'.$propriete['detailPropriete'].'</span></td></tr>';
			}else{
				$html .='<tr class="elem-class"><td class="text-center '.$class.'" style="border: 1px solid #C3CAD8;padding:6px;"><span style="font-size:0.8rem;font-weight:500">'.$propriete['detailPropriete'].'</span></td></tr>';
			}
			
		}

		$html .= '<table>';

		$output = json_encode(array('html' => $html,'count'=>count($proprietes)));

	}


	public function addGamme(){
		
		$this->load->view('templates/header');
		$this->load->view('addGamme');
		$this->load->view('templates/footer');

	}

	public function editGamme($id = 1){

		$data['propriete'] = $this->ArticlesModel->getPropriete($id);
		$this->load->view('templates/header');
		$this->load->view('editGamme',$data);
		$this->load->view('templates/footer');

	}

	



	public function updateGamme(){


		$idGamme = $this->input->post('idProp');
		$gamme = $this->input->post('gamme');
		$adefinir = $this->input->post('adefinir');

		if($this->ArticlesModel->updateGamme($idGamme,$gamme,$adefinir)){

			$output = json_encode(array("result"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{
			$output = json_encode(array("result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}

	}







	public function getDimensions($serie){


	}

	public function getSeries(){


	}


	public function getClientsDoc(){

			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
					$output = json_encode(array("session"=>false));
					$this->output->set_content_type('application/json');
		      $this->output->set_output($output);
			}else{

				$clients = $this->ArticlesModel->getClientsDoc();

				$output = json_encode(array("session"=>true,"result"=>true,'clients'=>$clients,'count'=>count($clients)));
				$this->output->set_content_type('application/json');
		     $this->output->set_output($output);

			}

	}

	public function getFournisseursDoc(){

			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
					$output = json_encode(array("session"=>false));
					$this->output->set_content_type('application/json');
		      $this->output->set_output($output);
			}else{

				$clients = $this->ArticlesModel->getFournisseursDoc();

				$output = json_encode(array("session"=>true,"result"=>true,'clients'=>$clients,'count'=>count($clients)));
				$this->output->set_content_type('application/json');
		     $this->output->set_output($output);

			}

	}

	








	public function addAvoirClient (){
				$data['depots'] = $this->ArticlesModel->getDepots();
		$data['nSeries'] = $this->ArticlesModel->getSeries();
		$data['dimesions'] = $this->ArticlesModel->getDimensions();
		$data['articles'] = $this->ArticlesModel->getProduits();
		$data['clients'] = $this->ArticlesModel->getClients();
		$data['parametres'] = $this->ArticlesModel->getParametres();
		$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
		$this->load->view('templates/header');
		$this->load->view('addA
			voirClient',$data);
		$this->load->view('templates/footer');

	}


	public function addTarif(){

		$tarif = $this->input->post('tarif');

		if(trim($tarif)!=''){

			if($this->ArticlesModel->insertTarif($tarif)){

				$output = json_encode(array("result"=>true));

											$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false));
											$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}else{

			$output = json_encode(array("result"=>false));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}

	}




	public function searchArticle(){

    // $id = $this->session->userdata('id');
    // if(!$id){
    //     $results = array('status'=>true,'session'=>false);
    //     echo json_encode(( $this->utf8ize( $results ) ));
    // }else{

      $filtres = $this->input->post('search');

      $articles = $this->ArticlesModel->searchArticle($filtres);

      // $results = $this->filterJson($reservations,$filtres);

      $html= "";


      	foreach ($articles as $key => $article){


	    $html .= '<div class="table-row-hexa row">
	      <div class="col-3 col-md-1 text-center hexa-row"  onclick="modifAll('.$article['idProduit'].');" style="color:#9EA6B7">'.$article['idProduit'].'</div>
	    	<div class="col-8 col-md-3 text-client-hexa hexa-row"  onclick="modifAll('.$article['idProduit'].');">'.$article['DESIGNAT'].'</div> 
	    	<div class="col-md-1 text-right hexa-row d-none d-md-block"  onclick="modifAll('.$article['idProduit'].');">'.number_format($article['PMP'],2,'.','').'</div>
	    	<div class="col-md-1 text-right hexa-row d-none d-md-block"  onclick="modifAll('.$article['idProduit'].');">'.number_format($article['DERPAH'],2,'.','').'</div>
	    	<div class="col-md-2 text-right hexa-row d-none d-md-block"  onclick="modifAll('.$article['idProduit'].');">'.number_format($article['PAHT'],2,'.','').'</div>
	    	<div class="col-md-2 text-right hexa-row d-none d-md-block"  onclick="modifAll('.$article['idProduit'].');">'.number_format($article['PVHT'],2,'.','').'</div>
	    	<div class="col-md-1 text-center hexa-row d-none d-md-block"  onclick="modifAll('.$article['idProduit'].');">'.date("d/m/Y", strtotime($article['dateCreation'])).'</div>
	        <div onclick="getOperation(\''.$article['DESIGNAT'].'\');" class="col-1 col-md-1 text-right hexa-row" style="color:#9EA6B7;padding-right:0.7rem;">
	        		<i class="fa fa-ellipsis-v"></i>
	        </div>
	    </div>';




		}
      echo json_encode(( $this->utf8ize( array('html'=>$html) ) ));

    // }
  }

	public function getProduit(){


		$id = $this->input->post("id");

		$article = $this->ArticlesModel->getProduitById($id);
		$famillesArticles = $this->ArticlesModel->getFamillesArticles();
		$marques = $this->ArticlesModel->getMarques();
		$unites = $this->ArticlesModel->getUnites();
		$depots = $this->ArticlesModel->getDepots();
		$tarifs = $this->ArticlesModel->getTarifs();
		$tvas = $this->ArticlesModel->getTVAs();

		foreach ($article as $key => $articl) {

            $html = '<div id="overlay"> <div class="conatiner"> <div id="center_middle" class="text-center"> <span class="spinner"></span> </div> </div> </div> <nav> <div class="nav nav-tabs" id="nav-tab" role="tablist"> <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Proprietes</a> <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false">Tarifs</a> <a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact" role="tab" aria-controls="nav-contact" aria-selected="false">Suivi</a> </div> </nav> <div class="tab-content" id="nav-tabContent"> <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab"> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Famille article </label> <div class="col-sm-4"> <select class="selectpicker form-control"  data-dropup-auto="false" data-size="5">'; 

            foreach ($famillesArticles as $key => $famillesArticle){ 
            	$html .= '<option value="'.$famillesArticle['idFA'].'">'.$famillesArticle['familleArticle'].'</option>'; 
            }
            	 $html .= '</select> </div> <label class="col-sm-2 col-form-label smaller" for=""> Pois </label> <div class="col-sm-4"> <input class="form-control" placeholder="Pois "> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Type </label> <div class="col-sm-4"> <input class="form-control" placeholder="Type "> </div> <label class="col-sm-2 col-form-label smaller" for=""> Paye origine </label> <div class="col-sm-4"> <input class="form-control" placeholder="Paye origine "> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Dimension </label> <div class="col-sm-4"> <input class="form-control" placeholder="Dimension "> </div> <label class="col-sm-2 col-form-label smaller" for=""> Nº serie </label> <div class="col-sm-4"> <input class="form-control" placeholder="Nº serie "> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Unite </label> <div class="col-sm-4"> <select class="selectpicker form-control"  data-dropup-auto="false" data-size="5">'; 

            	 foreach ($unites as $key => $unite){
            	 	$html .= '<option value="'.$unite['idU'].'">'.$unite['unite'].'</option>'; } $html .= '</select> </div> <label class="col-sm-2 col-form-label smaller" for=""> Marque </label> <div class="col-sm-4"> <select class="selectpicker form-control"  data-dropup-auto="false" data-size="5">'; 
            	 	foreach ($marques as $key => $marque){
            	 		$html .= '<option value="'.$marque['idM'].'" >'.$marque['marque'].'</option>'; 
					} $html .= '</select> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Stockable </label> <div class="col-sm-10"> <label class="radio-inline col-sm-2 smaller"> <input type="radio" name="clouds" id="Clear" value="clear" checked> Oui </label> <label class="radio-inline col-sm-2 smaller"> <input type="radio" name="clouds" id="Cloudy" value="cloudy"> Non </label> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> Stock Minimum </label> <div class="col-sm-4"> <input class="form-control" placeholder=" Stock Minimum "> </div> <label class="col-sm-2 col-form-label smaller" for=""> Stock Maximum </label> <div class="col-sm-4"> <input class="form-control" placeholder=" Stock Maximum "> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> PA HT </label> <div class="col-sm-2"> <input class="form-control" placeholder="0 "> </div> <label class="col-sm-2 col-form-label smaller" for=""> TVA </label> <div class="col-sm-2"> <select class="selectpicker form-control"  data-dropup-auto="false" data-size="5">'; foreach ($tvas as $key => $tva){$html .= '<option value="'.$tva['idTVA'].'">'.$tva['tva'].'</option>'; } $html .= '</select> </div> <label class="col-sm-2 col-form-label smaller" for=""> PA TTC </label> <div class="col-sm-2"> <input class="form-control" placeholder="0 "> </div> </div> <div class="form-group row"> <label class="col-sm-2 col-form-label smaller" for=""> PV HT </label> <div class="col-sm-2"> <input class="form-control" placeholder="0 "> </div> <label class="col-sm-2 col-form-label smaller" for=""> Marge </label> <div class="col-sm-2"> <input class="form-control" placeholder="0 "> </div> <label class="col-sm-2 col-form-label smaller" for=""> PV TTC </label> <div class="col-sm-2"> <input class="form-control" placeholder="0 "> </div> </div> </div> <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab"> <table class="" width="100%"> <thead> <th></th> <th>HT</th> <th>TTC</th> </thead> <tbody>'; foreach ($tarifs as $key => $tarif){$html .= '<tr> <td>'.$tarif['tarif'].'</td> <td><input style="text-align:right;" type="text" name="" placeholder="0"></td> <td><input style="text-align:right;" type="text" name="" placeholder="0"></td> </tr>'; } $html .= '</tbody> </table> </div> <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab"> <table class="" width="100%"> <thead> <th></th> <th>Qte Initiale</th> <th>Qte Inventaire</th> <th>Qte en Stock</th> </thead> <tbody>'; foreach ($depots as $key => $depot){$html .= '<tr> <td>'.$depot['depot'].'</td> <td><input style="text-align:right;" type="text" name="" placeholder="0"></td> <td><input style="text-align:right;" type="text" name="" placeholder="0"></td> <td><input style="text-align:right;" type="text" name="" placeholder="0"></td> </tr>'; } $html .= '</tbody> </table> </div>'; 

            $results = array("html"=>$html,"status"=>true);
          	echo json_encode(( $this->utf8ize( $results ) ));

		}


	}





	public function getFamilleFournisseur(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getFamilleFournisseurById($id);
		foreach ($fournisseur as $key => $fournisseu) {
			$html = '<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Famille Fournisseurs </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Famille Fournisseurs" value="'.$fournisseu['familleFournisseur'].'">
                    </div>
                  </div>
            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}

	public function getFamilleClient(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getFamilleClientById($id);
		foreach ($fournisseur as $key => $fournisseu) {

			$html = '<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Famille Client </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Famille Client" value="'.$fournisseu['familleClient'].'">
                    </div>
                  </div>
            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}

	public function getFamilleArticle(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getFamilleArticleById($id);
		foreach ($fournisseur as $key => $fournisseu) {

			$html ='<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Famille Article </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Famille Article" value="'.$fournisseu['familleArticle'].'">
                    </div>
                  </div>
            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}
	public function getMarque(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getMarqueById($id);
		foreach ($fournisseur as $key => $fournisseu) {

			$html ='<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Marque </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Marque " value="'.$fournisseu['marque'].'">
                    </div>
                  </div>
            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}
	public function getRegion(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getRegionById($id);
		foreach ($fournisseur as $key => $fournisseu) {

			$html ='<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Region </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Region " value="'.$fournisseu['region'].'">
                    </div>
                  </div>
            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));

		}

	}
		public function getModePaiement(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getModePaiementById($id);
		foreach ($fournisseur as $key => $fournisseu) {

			$html ='<form>
                 <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Mode Paiement </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Mode Paiement " value="'.$fournisseu['modePaiement'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Numero Compte </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Numero Compte " value="'.$fournisseu['numCompte'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Code Journal </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Code Journal " value="'.$fournisseu['codeJournal'].'">
                    </div>
                  </div>

            </form>';

			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}

	}







	public function getFournisseur(){

		$id = $this->input->post('id');
		$fournisseur = $this->ArticlesModel->getFournisseurById($id);
		foreach ($fournisseur as $key => $fournisseu) {
			$html = '<form>

							<div class="form-group row">
								<label class="col-sm-4 col-form-label smaller" for=""> Nom < R.S. ></label>
								<div class="col-sm-8">
									<input class="form-control" placeholder="Nom < R.S.>" value="'.$fournisseu['raisonSociale'].'">
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6">
									<div class="form-group row">
										<label class="col-sm-4 col-form-label smaller" for=""> Famille fournissuer</label>
										<div class="col-sm-8">
											<select class="form-control"><option>Famille fournissuer</option><option>New York</option><option>California</option><option>Boston</option><option>Texas</option><option>Colorado</option></select>
										</div>
									</div>
								</div>
								<div class="col-sm-6">
									<div class="form-group row">
										<label class="col-sm-4 col-form-label smaller" for=""> Compte comptabilité</label>
										<div class="col-sm-8">
											<input class="form-control" placeholder="Compte comptabilité">
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6">

									<fieldset class="form-group">
										<legend>
											<span>Facturation</span>
										</legend>									
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Delais paiement</label>
											<div class="col-sm-8">
												<select class="form-control"><option>Select State</option><option>New York</option><option>California</option><option>Boston</option><option>Texas</option><option>Colorado</option></select>
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller">Adresse</label>
											<div class="col-sm-8">
												<textarea class="form-control" rows="2" placeholder="Adresse">'.$fournisseu['adresseF'].'</textarea>
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Code postal</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Code postal" value="'.$fournisseu['codePostalF'].'">
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Ville</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Ville" value="'.$fournisseu['villeF'].'">
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Pays</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Pays" value="'.$fournisseu['PaysF'].'">
											</div>
										</div>
									</fieldset>	


								</div>
								<div class="col-sm-6">

									<fieldset class="form-group">
										<legend>
											<span>Livraison</span>
										</legend>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller">Adresse</label>
											<div class="col-sm-8">
												<textarea class="form-control" rows="2" placeholder="Adresse">'.$fournisseu['adresseL'].'</textarea>
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Code postal</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Code postal" value="'.$fournisseu['codePostalL'].'">
											</div>
										</div>
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Ville</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Ville" value="'.$fournisseu['villeL'].'">
											</div>
										</div>
									</fieldset>

								</div>
							</div>

							<hr>
							<div class="row">
									<div class="col-sm-4">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Tel 1</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Tel 1" value="'.$fournisseu['tel1'].'">
											</div>
										</div>
									</div>
									<div class="col-sm-4">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Tel 2</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Tel 2" value="'.$fournisseu['tel2'].'">
											</div>
										</div>
									</div>
									<div class="col-sm-4">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Fax</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Fax" value="'.$fournisseu['fax'].'">
											</div>
										</div>
									</div>
							</div>
							<div class="row">
									<div class="col-sm-6">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Email</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Email" value="'.$fournisseu['email'].'">
											</div>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Site Web</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="Site Web" value="'.$fournisseu['siteWeb'].'">
											</div>
										</div>
									</div>
							</div>
							<hr>
							<div class="row">
									<div class="col-sm-6">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Chiffre d\'affaire</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="0" value="'.$fournisseu['chiffreAffaires'].'">
											</div>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group row">
											<label class="col-sm-4 col-form-label smaller" for=""> Solde</label>
											<div class="col-sm-8">
												<input class="form-control" placeholder="0" value="'.$fournisseu['solde'].'">
											</div>
										</div>
									</div>
							</div>
						</form>';


						$output = json_encode(array("html"=>$html,"status"=>true));
													$this->output->set_content_type('application/json');
      $this->output->set_output($output);


		}
	}

	public function getClient(){

		$id = $this->input->post('id');
		$client = $this->ArticlesModel->getClientById($id);

		$famillesClients = $this->ArticlesModel->getFamillesClients();

		$commerciaux = $this->ArticlesModel->getCommerciaux();

		$regions = $this->ArticlesModel->getRegions();

		$modesPaiement = $this->ArticlesModel->getModesPaiements();

		$delaisPaiment = $this->ArticlesModel->getDelaisPaiements();


		foreach ($client as $key => $clien) {
			
			$html = '<form>

            <div class="row">
              <div class="col-sm-4">
                <fieldset class="form-group">               
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Nom < R.S. ></label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Nom < R.S. >" value="'.$clien['raisonSociale'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller">Tel 1</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Tel 1" value="'.$clien['tel1'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Tel 2</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Tel 2"  value="'.$clien['tel2'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Email</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Email"  value="'.$clien['email'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Responsible</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Responsible" value="'.$clien['responsable'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Notre commercial</label>
                    <div class="col-sm-8">
                      <select class="form-control">';

                      foreach ($commerciaux as $key => $commercial) {
                      	$html .= '<option value="'.$commercial['idC'].'" ';

                      	if ($commercial['idC'] == $clien['idC']) {
                      		$html .= ' selected ';
                      	}

                      	$html .= '>'.$commercial['nom'].'</option>';
                      }

                      $html .= '</select>

                    </div>
                  </div>
                </fieldset> 
              </div>

              <div class="col-sm-4">
                <fieldset class="form-group">     
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Categorie</label>
                    <div class="col-sm-8">
                      <select class="form-control"><option>Solvable</option><option>New York</option><option>California</option><option>Boston</option><option>Texas</option><option>Colorado</option></select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Fax</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" fax"  value="'.$clien['fax'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Web</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" site web"  value="'.$clien['siteWeb'].'">
                    </div>
                  </div>
                </fieldset> 
              </div>



              <div class="col-sm-4">
                <fieldset class="form-group">     
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Famille</label>
                    <div class="col-sm-8">
                      <select class="form-control">';

                      foreach ($famillesClients as $key => $famille) {
                      	$html .= '<option value="'.$famille['idFC'].'" ';

                      	if ($famille['idFC'] == $clien['idFC']) {
                      		$html .= ' selected ';
                      	}

                      	$html .= '>'.$famille['familleClient'].'</option>';
                      }

                      $html .= '</select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Region</label>
                    <div class="col-sm-8">
                      <select class="form-control">';

                      foreach ($regions as $key => $region) {
                      	$html .= '<option value="'.$region['idR'].'" ';

                      	if ($region['idR'] == $clien['idR']) {
                      		$html .= ' selected ';
                      	}

                      	$html .= '>'.$region['region'].'</option>';
                      }

                      $html .= '</select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Delais de paiement</label>
                    <div class="col-sm-8">
                      <select class="form-control">';

                      foreach ($delaisPaiment as $key => $delaiPaiment) {
                      	$html .= '<option value="'.$delaiPaiment['idDP'].'" ';

                      	if ($delaiPaiment['idDP'] == $clien['idDP']) {
                      		$html .= ' selected ';
                      	}

                      	$html .= '>'.$delaiPaiment['delaisPaiement'].'</option>';
                      }

                      $html .= '</select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Mode paiement</label>
                    <div class="col-sm-8">
                      <select class="form-control">';

                      foreach ($modesPaiement as $key => $modePaiement) {
                      	$html .= '<option value="'.$modePaiement['idMP'].'" ';

                      	if ($modePaiement['idMP'] == $clien['idMP']) {
                      		$html .= ' selected ';
                      	}

                      	$html .= '>'.$modePaiement['modePaiement'].'</option>';
                      }

                      $html .= '</select>
                    </div>
                  </div>
                </fieldset> 
              </div>
            </div>

            <hr>

            <div class="row">
              <div class="col-sm-6">
                <fieldset class="form-group">   
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Adresse</label>
                    <div class="col-sm-8">
                      <textarea class="form-control" rows="3" placeholder="Adresse">'.$clien['adresse'].'</textarea>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Code postal</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" tel 2">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Ville</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" tel 2">
                    </div>
                  </div>
                </fieldset>
              </div>
              <div class="col-sm-6">
                <fieldset class="form-group">   
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> id Fiscal</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="id Fiscal"   value="'.$clien['idFiscal'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Patente</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" patente"   value="'.$clien['Patente'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> CNSS</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" cnss"  value="'.$clien['CNSS'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> R.C.</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" RC"  value="'.$clien['RC'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> I.C.E</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder=" ICE"  value="'.$clien['ICE'].'">
                    </div>
                  </div>

                </fieldset>
              </div>
            </div>

            <hr>

            <div class="row">
              <div class="col-sm-6">

                <fieldset class="form-group">  





                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller">Respnsable</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Respnsable" value="'.$clien['responsable'].'">
                    </div>
                    <label class="col-sm-2 col-form-label smaller">Tel</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Tel" value="'.$clien['TelResp'].'">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller">2eme respnsable</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="2eme respnsable" value="'.$clien['NomResp2'].'">
                    </div>
                    <label class="col-sm-2 col-form-label smaller">Tel</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Tel" value="'.$clien['TelResp2'].'">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller">Respnsable commercial</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Respnsable commercial" value="'.$clien['NomRespCom'].'">
                    </div>
                    <label class="col-sm-2 col-form-label smaller">Tel</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Tel" value="'.$clien['TelRespCom'].'">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller" for=""> Imapayes</label>
                    <div class="col-sm-10">
                      <textarea class="form-control" rows="2" placeholder="Impayes">'.$clien['Impayes'].'</textarea>
                    </div>
                  </div>
                </fieldset> 
              </div>
              <div class="col-sm-6">

                <fieldset class="form-group">
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller">Observation</label>
                    <div class="col-sm-8">
                      <textarea class="form-control" rows="6" placeholder="Observation">'.$clien['Observation'].'</textarea>
                    </div>
                  </div>
                </fieldset>

              </div>
            </div>

                <fieldset class="form-group">
                  <legend>
                    <span>Chef de park</span>
                  </legend>
                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller">Nom</label>
                    <div class="col-sm-10">
                      <input class="form-control" placeholder="Nom"  value="'.$clien['NomChef'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-2 col-form-label smaller" for=""> Tel</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Tel"  value="'.$clien['TelChef'].'">
                    </div>
                    <label class="col-sm-2 col-form-label smaller" for=""> Email</label>
                    <div class="col-sm-4">
                      <input class="form-control" placeholder="Email"  value="'.$clien['EmailChef'].'">
                    </div>
                  </div>
                </fieldset>

            <hr>
            <div class="row">

              <div class="col-4">
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label smaller">Credit maximum</label>
                    <div class="col-sm-9">
                      <input class="form-control" placeholder="Credit maximum" value="'.$clien['creditMax'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label smaller">Chiffre d\'affaires</label>
                    <div class="col-sm-9">
                      <input class="form-control" placeholder="Chiffre d\'affaires" value="'.$clien['CHAFF'].'">
                    </div>
                  </div>

                
              </div>
              <div class="col-4">
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label smaller">Objectif</label>
                    <div class="col-sm-9">
                      <input class="form-control" placeholder="Objectif" value="'.$clien['Objectif'].'">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label smaller">Solde</label>
                    <div class="col-sm-9">
                      <input class="form-control" placeholder="Solde" value="'.$clien['solde'].'">
                    </div>
                  </div>

                
              </div>
              <div class="col-2">
                  <div class="form-group row">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" type="checkbox"';

                          if($clien['CPTBLOQ']){
                          	$html .= ' checked ';
                          } 
                          $html .= '>Compte bloque
                        </label>
                      </div>
                  </div>
                  <div class="form-group row">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" type="checkbox"';

                          if($clien['Debloque']){
                          	$html .= ' checked ';
                          } 
                          
                          $html .= '>Compte debloque
                        </label>
                      </div>
                  </div>
                
              </div>
              <div class="col-2">
                  <div class="form-group row">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" type="checkbox"';

						  if($clien['Assure']){
                          	$html .= ' checked ';
                          } 

                          $html .= '>Client assure?
                        </label>
                      </div>
                  </div>
              </div>   

            </div>
          </form>';



			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);


		}
	}

	public function getCommercial(){

		$id = $this->input->post('id');

		$commercial = $this->ArticlesModel->getCommercialById($id);

		foreach ($commercial as $key => $commercia) {

          $html = '<form>
                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Nom </label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Nom " value="'.$commercia['nom'].'">
                    </div>
                  </div>

                    <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Tel 1</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Tel" value="'.$commercia['tel1'].'">
                    </div>
                  </div>        

                       <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Tel 2</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Tel 2" value="'.$commercia['tel2'].'">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Email</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Email" value="'.$commercia['email'].'">
                    </div>
                  </div>                  

                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Adresse</label>
                    <div class="col-sm-8">
                       <textarea class="form-control" rows="2" placeholder="Adresse">'.$commercia['adresse'].'</textarea>
                    </div>
                  </div>


                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Code postal</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Code postal" value="'.$commercia['codePostal'].'">
                    </div>
                  </div>



                  <div class="form-group row">
                    <label class="col-sm-4 col-form-label smaller" for=""> Ville</label>
                    <div class="col-sm-8">
                      <input class="form-control" placeholder="Ville" value="'.$commercia['ville'].'">
                    </div>
                  </div>


          </form>';


			$output = json_encode(array("html"=>$html,"status"=>true));
										$this->output->set_content_type('application/json');
      $this->output->set_output($output);

		}
	}

  private function utf8ize( $mixed ) {
      if (is_array($mixed)) {
          foreach ($mixed as $key => $value) {
              $mixed[$key] = $this->utf8ize($value);
          }
      } elseif (is_string($mixed)) {
          return mb_convert_encoding($mixed, "UTF-8", "UTF-8");
      }
      return $mixed;
  }

function NumberToLetter( $nombre, $U = null, $D = null){

    $toLetter = [
        0 => "zéro",
        1 => "un",
        2 => "deux",
        3 => "trois",
        4 => "quatre",
        5 => "cinq",
        6 => "six",
        7 => "sept",
        8 => "huit",
        9 => "neuf",
        10 => "dix",
        11 => "onze",
        12 => "douze",
        13 => "treize",
        14 => "quatorze",
        15 => "quinze",
        16 => "seize",
        17 => "dix-sept",
        18 => "dix-huit",
        19 => "dix-neuf",
        20 => "vingt",
        30 => "trente",
        40 => "quarante",
        50 => "cinquante",
        60 => "soixante",
        70 => "soixante-dix",
        80 => "quatre-vingt",
        90 => "quatre-vingt-dix",
    ];
    
    global $toLetter;
    $numberToLetter='';
    $nombre = strtr((string)$nombre, [" "=>""]);
    $nb = floatval($nombre);

    if( strlen($nombre) > 15 ) return "dépassement de capacité";
    if( !is_numeric($nombre) ) return "Nombre non valide";
  if( ceil($nb) != $nb ){
        $nb = explode('.',$nombre);
        return NumberToLetter($nb[0]) . ($U ? " $U et " : " virgule ") . NumberToLetter($nb[1]) . ($D ? " $D" : "");
    }

  $n = strlen($nombre);
  switch( $n ){
        case 1:
            $numberToLetter = $toLetter[$nb];
            break;
        case 2:
            if(  $nb > 19  ){
                $quotient = floor($nb / 10);
                $reste = $nb % 10;
                if(  $nb < 71 || ($nb > 79 && $nb < 91)  ){
                    if(  $reste == 0  ) $numberToLetter = $toLetter[$quotient * 10];
                    if(  $reste == 1  ) $numberToLetter = $toLetter[$quotient * 10] . "-et-" . $toLetter[$reste];
                    if(  $reste > 1   ) $numberToLetter = $toLetter[$quotient * 10] . "-" . $toLetter[$reste];
                }else $numberToLetter = $toLetter[($quotient - 1) * 10] . "-" . $toLetter[10 + $reste];
            }else $numberToLetter = $toLetter[$nb];
            break;

        case 3:
            $quotient = floor($nb / 100);
            $reste = $nb % 100;
            if(  $quotient == 1 && $reste == 0   ) $numberToLetter = "cent";
            if(  $quotient == 1 && $reste != 0   ) $numberToLetter = "cent" . " " . NumberToLetter($reste);
            if(  $quotient > 1 && $reste == 0    ) $numberToLetter = $toLetter[$quotient] . " cents";
            if(  $quotient > 1 && $reste != 0    ) $numberToLetter = $toLetter[$quotient] . " cent " . NumberToLetter($reste);
            break;
        case 4 :
        case 5 :
        case 6 :
            $quotient = floor($nb / 1000);
            $reste = $nb - $quotient * 1000;
            if(  $quotient == 1 && $reste == 0   ) $numberToLetter = "mille";
            if(  $quotient == 1 && $reste != 0   ) $numberToLetter = "mille" . " " . NumberToLetter($reste);
            if(  $quotient > 1 && $reste == 0    ) $numberToLetter = NumberToLetter($quotient) . " mille";
            if(  $quotient > 1 && $reste != 0    ) $numberToLetter = NumberToLetter($quotient) . " mille " . NumberToLetter($reste);
            break;
        case 7:
        case 8:
        case 9:
            $quotient = floor($nb / 1000000);
            $reste = $nb % 1000000;
            if(  $quotient == 1 && $reste == 0  ) $numberToLetter = "un million";
            if(  $quotient == 1 && $reste != 0  ) $numberToLetter = "un million" . " " . NumberToLetter($reste);
            if(  $quotient > 1 && $reste == 0   ) $numberToLetter = NumberToLetter($quotient) . " millions";
            if(  $quotient > 1 && $reste != 0   ) $numberToLetter = NumberToLetter($quotient) . " millions " . NumberToLetter($reste);
            break;
        case 10:
        case 11:
        case 12:
            $quotient = floor($nb / 1000000000);
            $reste = $nb - $quotient * 1000000000;
            if(  $quotient == 1 && $reste == 0  ) $numberToLetter = "un milliard";
            if(  $quotient == 1 && $reste != 0  ) $numberToLetter = "un milliard" . " " . NumberToLetter($reste);
            if(  $quotient > 1 && $reste == 0   ) $numberToLetter = NumberToLetter($quotient) . " milliards";
            if(  $quotient > 1 && $reste != 0   ) $numberToLetter = NumberToLetter($quotient) . " milliards " . NumberToLetter($reste);
            break;
        case 13:
        case 14:
        case 15:
            $quotient = floor($nb / 1000000000000);
            $reste = $nb - $quotient * 1000000000000;
            if(  $quotient == 1 && $reste == 0  ) $numberToLetter = "un billion";
            if(  $quotient == 1 && $reste != 0  ) $numberToLetter = "un billion" . " " . NumberToLetter($reste);
            if(  $quotient > 1 && $reste == 0   ) $numberToLetter = NumberToLetter($quotient) . " billions";
            if(  $quotient > 1 && $reste != 0   ) $numberToLetter = NumberToLetter($quotient) . " billions " . NumberToLetter($reste);
            break;
    }
  /*respect de l'accord de quatre-vingt*/
    if( substr($numberToLetter, strlen($numberToLetter)-12, 12 ) == "quatre-vingt" ) $numberToLetter .= "s";

    return $numberToLetter;
}
}