<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class BonsCommande extends CI_Controller
{

	public function addBonCommande(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			// $data['depots'] = $this->ArticlesModel->getDepots();
			// $data['contres'] = $this->ArticlesModel->getContres();
			// $data['nSeries'] = $this->ArticlesModel->getSeries();
			// $data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduitsStock();
			// $data['clients'] = $this->ArticlesModel->getFournisseurs();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();



			$header['title'] = 'Gestion Commercial - Gestion Bon Commande';
			$header['page'] = 'bonsCommande';
			$this->load->view('templates/header',$header);
			$this->load->view('addBonCommande',$data);
			$this->load->view('templates/footer');			
		}
	}

	public function editBonCommande ($id){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['devis'] = $this->ArticlesModel->getBonCommande($id);
			// $data['nSeries'] = $this->ArticlesModel->getSeries();
			// $data['contres'] = $this->ArticlesModel->getContres();
			// $data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduits();
			// $data['clients'] = $this->ArticlesModel->getFournisseurs();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['articles'] = $this->ArticlesModel->getProduitsBC($id);

			$header['title'] = 'Gestion Commercial - Gestion Bon Commande';
			$header['page'] = 'bonsCommande';
			$this->load->view('templates/header',$header);
			$this->load->view('editBonCommande',$data);
			$this->load->view('templates/footer');
		}

	}

	public function getBonsCommandeDetails(){


		$user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

          $id = $this->input->post('id');

          $bc= $this->FacturesModel->getBonsCommandeDetails($id);

          $output = json_encode(array("result"=>true,"session"=>true,"bc"=>$bc));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

	}

	public function getBonsCommande(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $bcs= $this->FacturesModel->getBonsCommande($dateCaisse,$dateCaisse1);
          $output = json_encode(array("result"=>true,"session"=>true,"bcs"=>$bcs));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
  	}


	public function insertBonCommande(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      		$this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->FacturesModel->insertBonCommande($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      			$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      			$this->output->set_output($output);

			}
		}

	}

	  public function validerBonCommande(){


		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
        $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$num = $this->FacturesModel->validerBonCommande($json,$user_id);

			if($num){
				$bcs= $this->FacturesModel->getBonsCommande();
				$output = json_encode(array("result"=>true,"session"=>true,"bcs"=>$bcs,"num"=>$num));
				$this->output->set_content_type('application/json');
        		$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
        		$this->output->set_output($output);

			}
		}	
	}



  public function printBonCommande($id){

  	    $user_id = $this->session->userdata('idUtilisateur');
	    $nomu = $this->session->userdata('nomUtilisateur');
	    if(!$user_id){
	        $this->load->view('login');
	    }else{

		  $data['devis'] = $this->FacturesModel->getBonCommande($id);
	      $data['total'] = 0;
	      $data['totalttc'] = 0;


	      foreach ($data['devis'] as $key => $produit) {

	        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
	      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

	      }  

	      $data['totaltva'] = $data['totalttc'] - $data['total'];

	      $data['totall'] = $this->getConversion($data['totalttc']);

	      if(count($data['devis'])<16){
	        $number = count($data['devis']);

	        for ($i=$number; $i < 12; $i++) { 

	          array_push($data['devis'],array('DATE'=>$data['devis'][0]['DATE'],'NUMDOC'=>$data['devis'][0]['NUMDOC'],'NOMTIER'=>$data['devis'][0]['NOMTIER'],'ADRESSE'=>$data['devis'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

	        }
	      }
	      $html = $this->load->view('pdf/bonsCommande',$data, true);

	      // Load pdf library
	      $this->load->library('pdf');
	                          
	      // Load HTML content
	      $this->dompdf->loadHtml($html);
	                          
	      // (Optional) Setup the paper size and orientation
	      $this->dompdf->setPaper('A4', 'portrait');
	            
	      // Render the HTML as PDF
	      $this->dompdf->render();

	      $this->dompdf->stream("BC-".$id.".pdf", array("Attachment"=>true));

	    }

    
  }
   private function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 



}