<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class BonsLivraison extends CI_Controller
{

	public function addBonLivraison (){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			// $data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
			// $data['vehicules'] = $this->ArticlesModel->getVehicules();
			// $data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
			// $data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
			// $data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['contres'] = $this->ArticlesModel->getContres();
			// $data['nSeries'] = $this->ArticlesModel->getSeries();
			// $data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduitsStock();
			// $data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Bon Livraison';
			$header['page'] = 'BonLivraison';

			$this->load->view('templates/header',$header);
			$this->load->view('addBonLivraison',$data);
			$this->load->view('templates/footer');
		}
	}

	public function updateBonLivraison(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$idBL = $this->input->post('idBL');

			if($this->FacturesModel->updateBonLivraison($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}

		}
	}
	
	

	public function editBonLivraison($id = 1){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['bonLivraison'] = $this->ArticlesModel->getBonLivraison($id);
			if(count($data['bonLivraison'])>0){
				;
				$data['contres'] = $this->ArticlesModel->getContres();
				$data['client'] = $this->ArticlesModel->getClient($data['bonLivraison'][0]['CODETIER']);
				// $data['chauffeurs'] = $this->ArticlesModel->getChauffeurs();
				// $data['vehicules'] = $this->ArticlesModel->getVehicules();
				// $data['superviseurs'] = $this->ArticlesModel->getSuperviseurs();
				// $data['preperateurs'] = $this->ArticlesModel->getPreparateurs();
				// $data['expediteurs'] = $this->ArticlesModel->getExpediteurs();
				$data['depots'] = $this->ArticlesModel->getDepots();
				// $data['nSeries'] = $this->ArticlesModel->getSeries();
				// $data['dimesions'] = $this->ArticlesModel->getDimensions();
				// $data['articles'] = $this->ArticlesModel->getProduits();
				// $data['clients'] = $this->ArticlesModel->getClients();
				$data['parametres'] = $this->ArticlesModel->getParametres();
				$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
				// $data['articles'] = $this->ArticlesModel->getProduitsStock($id);
				$header['title'] = 'Gestion Commercial - Gestion Bon Livraison';
				$header['page'] = 'BonLivraison';

				$this->load->view('templates/header',$header);
				$this->load->view('editBonLivraison',$data);
				$this->load->view('templates/footer');
			}else{
				$this->bonsLivraison();
			}

		}
	}

	public function index(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			$header['title'] = 'Gestion Commercial - Gestion Bon Livraison';
			$header['page'] = 'BonLivraison';

			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['banques'] = $this->ArticlesModel->getBanques();

			$this->load->view('templates/header',$header);
			$this->load->view('bonsLivraison',$data);
			$this->load->view('templates/footer');
		}

	}


	public function testDashboard(){


		$this->load->view('chambres');

	}


	public function getBonLivraisonDetails(){

		    $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $id = $this->input->post('id');

          $bonLivraison = $this->FacturesModel->getBonLivraisonDetails($id);
          $modesPaiement =$this->ArticlesModel->getModesPaiements();
          $banques = $this->ArticlesModel->getBanques();

          $output = json_encode(array("result"=>true,"session"=>true,"bonLivraison"=>$bonLivraison,"modesPaiement"=>$modesPaiement,"banques"=>$banques));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

	}

	public function getBonsLivraison(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $bls= $this->FacturesModel->getBonsLivraison($dateCaisse,$dateCaisse1);


          $output = json_encode(array("session"=>true,"bls"=>$bls));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
  }

	public function facturerBonLivraison(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      		$this->output->set_output($output);
		}else{

			$id = $this->input->post('id');

			$num = $this->FacturesModel->facturerBonLivraison($id,$user_id);

			if($num){

        $bls = $this->FacturesModel->getBonsLivraison();

        $output = json_encode(array("result"=>true,"session"=>true,"bls"=>$bls,"num"=>$num));

				// $output = json_encode(array("result"=>true,"session"=>true,'id'=>$num,'BLs'=>$BLs,'total'=>$total,'nbr'=>$nbr));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}

		}

	}

	public function facturerGroupeBonLivraison(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
            $this->output->set_output($output);
		}else{

			$ids = $this->input->post('Factures');

			$num = $this->FacturesModel->facturerGroupeBonLivraison($ids,$user_id);

			if($num>0){

        $bls = $this->FacturesModel->getBonsLivraison();

        $output = json_encode(array("result"=>true,"session"=>true,"bls"=>$bls,"num"=>$num));

				// $output = json_encode(array("result"=>true,"session"=>true,'id'=>$num,'BLs'=>$BLs,'total'=>$total,'nbr'=>$nbr));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      			$this->output->set_output($output);

			}

		}

	}

	public function reglerBonLivraison(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
      $output = json_encode(array("session"=>false));
      $this->output->set_content_type('application/json');
      $this->output->set_output($output);
    }else{

      $json = $this->input->post('json');

      if($this->FacturesModel->reglerBonLivraison($json,$user_id)){
        $bls= $this->FacturesModel->getBonsLivraison();
        $output = json_encode(array("result"=>true,"session"=>true,'bls'=>$bls));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }else{

        $output = json_encode(array("result"=>false,"session"=>true));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }
    }
  }

    public function printBL($id){

	    $user_id = $this->session->userdata('idUtilisateur');
	    $nomu = $this->session->userdata('nomUtilisateur');
	    if(!$user_id){
	    	$this->load->view('login');
	    }else{
	      $data['bl'] = $this->ArticlesModel->getBonLivraison($id);

	      $this->FacturesModel->insertActivity($user_id,$id,$data['bl'][0]['NUMDOC'],42,'');

	      $data['total'] = 0;
	      $data['totalttc'] = 0;

	      foreach ($data['bl'] as $key => $produit) {

	        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
	      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

	      }  

	      $data['totaltva'] = $data['totalttc'] - $data['total'];

	      $data['totall'] = $this->getConversion($data['totalttc']);

	      if(count($data['bl'])<16){
	        $number = count($data['bl']);

	        for ($i=$number; $i < 10; $i++) { 

	          array_push($data['bl'],array('ICE'=>$data['bl'][0]['ICE'],'DATE'=>$data['bl'][0]['DATE'],'NUMDOC'=>$data['bl'][0]['NUMDOC'],'NOMTIER'=>$data['bl'][0]['NOMTIER'],'ADRESSE'=>$data['bl'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

	        }
	      }

	      $html = $this->load->view('pdf/bonsLivraison',$data, true);

	      // Load pdf library
	      $this->load->library('pdf');
	                          
	      // Load HTML content
	      $this->dompdf->loadHtml($html);
	                          
	      // (Optional) Setup the paper size and orientation
	      $this->dompdf->setPaper('A4', 'portrait');
	            
	      // Render the HTML as PDF
	      $this->dompdf->render();

	      //$this->dompdf->stream("BL-".$id.".pdf", array("Attachment"=>true));

	      $this->dompdf->stream("BL-".$id.".pdf", array("Attachment"=>false));

	    }


  }

  public function insertBonLivraison(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->FacturesModel->insertBonLivraison($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
							$this->output->set_content_type('application/json');
      $this->output->set_output($output);

			}
		}
	}
   private function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 



}