<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class BonsReception extends CI_Controller
{

	public function index(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['banques'] = $this->ArticlesModel->getBanques();


			$header['title'] = 'Gestion Commercial - Gestion Bons Reception';
			$header['page'] = 'bonsReception';

			$this->load->view('templates/header',$header);
			$this->load->view('bonsReception',$data);
			$this->load->view('templates/footer');
		}

	}

	public function reglerBonReception(){

		$user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
      $output = json_encode(array("session"=>false));
      $this->output->set_content_type('application/json');
      $this->output->set_output($output);
    }else{

      $json = $this->input->post('json');

      if($this->FacturesModel->reglerBonReception($json,$user_id)){
        $bls= $this->FacturesModel->getBonsReception();
        $output = json_encode(array("result"=>true,"session"=>true,'bls'=>$bls));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }else{

        $output = json_encode(array("result"=>false,"session"=>true));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }
    }
	}

	public function facturerBonReception(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$id = $this->input->post('id');
			$num = $this->FacturesModel->facturerBonReception($id,$user_id);

			if($num){
				$bls= $this->FacturesModel->getBonsReception();
				$output = json_encode(array("result"=>true,"session"=>true,'id'=>$num,'bls'=>$bls,'num'=>$num));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}

		}

	}




	public function getBonsReception(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $bls= $this->FacturesModel->getBonsReception($dateCaisse,$dateCaisse1);


          $output = json_encode(array("session"=>true,"bls"=>$bls));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
  }

  	public function insertBonReception(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
						$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->FacturesModel->insertBonReception($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}
		}
	}

   public function printBR($id){

	    $user_id = $this->session->userdata('idUtilisateur');
	    $nomu = $this->session->userdata('nomUtilisateur');
	    if(!$user_id){
	    	$this->load->view('login');
	    }else{
	      $data['bl'] = $this->ArticlesModel->getBonReception($id);

	      $this->FacturesModel->insertActivity($user_id,$id,$data['bl'][0]['NUMDOC'],43,'');

	      $data['total'] = 0;
	      $data['totalttc'] = 0;

	      foreach ($data['bl'] as $key => $produit) {

	        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
	      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

	      }  

	      $data['totaltva'] = $data['totalttc'] - $data['total'];

	      $data['totall'] = $this->getConversion($data['totalttc']);

	      if(count($data['bl'])<16){
	        $number = count($data['bl']);

	        for ($i=$number; $i < 12; $i++) { 

	          array_push($data['bl'],array('DATE'=>$data['bl'][0]['DATE'],'NUMDOC'=>$data['bl'][0]['NUMDOC'],'NOMTIER'=>$data['bl'][0]['NOMTIER'],'ADRESSE'=>$data['bl'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

	        }
	      }

	      $html = $this->load->view('pdf/bonsReception',$data, true);

	      // Load pdf library
	      $this->load->library('pdf');
	                          
	      // Load HTML content
	      $this->dompdf->loadHtml($html);
	                          
	      // (Optional) Setup the paper size and orientation
	      $this->dompdf->setPaper('A4', 'portrait');
	            
	      // Render the HTML as PDF
	      $this->dompdf->render();

	      $this->dompdf->stream("BR-".$id.".pdf", array("Attachment"=>true));

	    }


  }

  public function getBonReceptionDetails(){

		    $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $id = $this->input->post('id');

          $bonLivraison = $this->FacturesModel->getBonReceptionDetails($id);
          $modesPaiement =$this->ArticlesModel->getModesPaiements();
          $banques = $this->ArticlesModel->getBanques();

          $output = json_encode(array("result"=>true,"session"=>true,"bonLivraison"=>$bonLivraison,"modesPaiement"=>$modesPaiement,"banques"=>$banques));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

	}

   private function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 




}