<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Clients extends CI_Controller
{

  public function index(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
        $this->load->view('login');
    }else{

      $data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
      $data['banques'] = $this->ArticlesModel->getBanques();
      $data['clients'] = $this->ClientsModel->getClients();
      $header['title'] = 'Gestion Commercial - Gestion Clients';
      $header['page'] = 'Clients';
      $this->load->view('templates/header',$header);
      $this->load->view('clients',$data);
      $this->load->view('templates/footer');

    }
  }


  public function facturesParClient(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
        $this->load->view('login');
    }else{

      $header['title'] = 'Gestion Commercial - Gestion Clients';
      $header['page'] = 'Clients';
      $this->load->view('templates/header',$header);
      $this->load->view('listeFacturesClients');
      $this->load->view('templates/footer');

    }
  }

  public function reglerFacture(){

      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $output = json_encode(array("session"=>false));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);
      }else{

        $json = $this->input->post('json');

        if($this->FacturesModel->reglerFacture($json,$user_id)){
          $clients = $this->ClientsModel->getClients();
          $output = json_encode(array("result"=>true,"session"=>true,'clients'=>$clients));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }else{

          $output = json_encode(array("result"=>false,"session"=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
      }
    }


    public function printReleveClient($id){
      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $this->load->view('login');
      }else{
        $data['client'] = $this->ClientsModel->getClient($id);
        $this->FacturesModel->insertActivity($user_id,$id,'',51,'');

        // var_dump($data["client"]["client"]->idCli);die;

        // $data['total'] = 0;
        // $data['totalttc'] = 0;


        // foreach ($data['facture'] as $key => $produit) {

        //   $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
        //   $data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

        // }  

        // $data['totaltva'] = $data['totalttc'] - $data['total'];

        // $data['totall'] = $this->getConversion($data['totalttc']);

        // if(count($data['facture'])<16){
        //   $number = count($data['facture']);

        //   for ($i=$number; $i < 12; $i++) { 

        //     array_push($data['facture'],array('DATE'=>$data['facture'][0]['DATE'],'NUMDOC'=>$data['facture'][0]['NUMDOC'],'NOMTIER'=>$data['facture'][0]['NOMTIER'],'ADRESSE'=>$data['facture'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

        //   }
        // }

        $html = $this->load->view('pdf/releveClient',$data, true);

        $this->load->library('pdf');
                            
        $this->dompdf->loadHtml($html);
                            
        $this->dompdf->setPaper('A4', 'portrait');
              
        $this->dompdf->render();

        $this->dompdf->stream("CLIENT-".$id.".pdf", array("Attachment"=>true));

      }
    }




  public function getClient(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
      $output = json_encode(array("session"=>false));
      $this->output->set_content_type('application/json');
      $this->output->set_output($output);
    }else{

      $idProp = $this->input->post('idProp');
      $client = $this->ClientsModel->getClient($idProp);

      if($client){

        $output = json_encode(array("session"=>true,"result"=>true,'client' => $client));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }else{
        $output = json_encode(array("session"=>true,"result"=>false));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);
      } 

    }

  }


  private function utf8ize( $mixed ) {
      if (is_array($mixed)) {
          foreach ($mixed as $key => $value) {
              $mixed[$key] = $this->utf8ize($value);
          }
      } elseif (is_string($mixed)) {
          return mb_convert_encoding($mixed, "UTF-8", "UTF-8");
      }
      return $mixed;
  }

}