<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Devis extends CI_Controller
{

		public function index(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$header['title'] = 'Gestion Commercial - Gestion Devis';
			$header['page'] = 'Devis';
			$this->load->view('templates/header',$header);
			$this->load->view('devis');
			$this->load->view('templates/footer');	
					
		}
	}




	public function addDevis (){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['depots'] = $this->ArticlesModel->getDepots();
			$data['contres'] = $this->ArticlesModel->getContres();
			$data['nSeries'] = $this->ArticlesModel->getSeries();
			$data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduitsStock();
			//$data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();

			$header['title'] = 'Gestion Commercial - Gestion Devis';
			$header['page'] = 'Devis';
			$this->load->view('templates/header',$header);
			$this->load->view('addDevis',$data);
			$this->load->view('templates/footer');			
		}
	}
	public function insertDevis(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			$output = json_encode(array("session"=>false));
			$this->output->set_content_type('application/json');
      $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->insertDevis($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);
			}

		}
	}

		public function editDevis ($id){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{

			$data['devis'] = $this->ArticlesModel->getDevi($id);
			
			$data['client'] = $this->ArticlesModel->getClient($data['devis'][0]['CODETIER']);

			// $data['nSeries'] = $this->ArticlesModel->getSeries();
			// $data['contres'] = $this->ArticlesModel->getContres();
			// $data['dimesions'] = $this->ArticlesModel->getDimensions();
			//$data['articles'] = $this->ArticlesModel->getProduits();
			// $data['clients'] = $this->ArticlesModel->getClients();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			// $data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			// $data['articles'] = $this->ArticlesModel->getProduitsStockDevis($id,$data['devis'][0]['CODETIER']);



			$header['title'] = 'Gestion Commercial - Gestion Devis';
			$header['page'] = 'Devis';
			$this->load->view('templates/header',$header);
			$this->load->view('editDevis',$data);
			$this->load->view('templates/footer');
		}

	}

	
	public function updateDevis(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
      	$this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->ArticlesModel->updateDevis($json,$user_id)){

				$output = json_encode(array("result"=>true,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
      	$this->output->set_output($output);

			}

		}
	}


	public function getDevisDetails(){


		    $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

          $id = $this->input->post('id');

          $devi= $this->FacturesModel->getDevisDetails($id);

          $output = json_encode(array("result"=>true,"session"=>true,"devi"=>$devi));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

	}

	public function getDevis(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $devis= $this->FacturesModel->getDevis($dateCaisse,$dateCaisse1);
          $output = json_encode(array("result"=>true,"session"=>true,"devis"=>$devis));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
  	}

  public function validerDevis(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
        $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');
			$num = $this->FacturesModel->validerDevis($json,$user_id);

			if($num){
				$devis= $this->FacturesModel->getDevis();
				$output = json_encode(array("result"=>true,"session"=>true,"devis"=>$devis,"num"=>$num));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);

			}
		}	
	}

	public function confirmerDevis(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $output = json_encode(array("session"=>false));
			  $this->output->set_content_type('application/json');
        $this->output->set_output($output);
		}else{

			$json = $this->input->post('json');

			if($this->FacturesModel->confirmerDevis($json,$user_id)){

				$devis= $this->FacturesModel->getDevis();
				$output = json_encode(array("result"=>true,"session"=>true,"devis"=>$devis));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);

			}else{

				$output = json_encode(array("result"=>false,"session"=>true));
				$this->output->set_content_type('application/json');
        $this->output->set_output($output);

			}

		}
	}
	  public function printDevis($id){

	  	  $user_id = $this->session->userdata('idUtilisateur');
	      $nomu = $this->session->userdata('nomUtilisateur');
	      if(!$user_id){
	        $this->load->view('login');
	      }else{
		      $data['devis'] = $this->ArticlesModel->getDevi($id);
		      $data['total'] = 0;
		      $data['totalttc'] = 0;


		      foreach ($data['devis'] as $key => $produit) {

		        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
		      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

		      }  

		      $data['totaltva'] = $data['totalttc'] - $data['total'];

		      $data['totall'] = $this->getConversion($data['totalttc']);

		      if(count($data['devis'])<16){
		        $number = count($data['devis']);

		        for ($i=$number; $i < 10; $i++) { 

		          array_push($data['devis'],array('DATE'=>$data['devis'][0]['DATE'],'NUMDOC'=>$data['devis'][0]['NUMDOC'],'NOMTIER'=>$data['devis'][0]['NOMTIER'],'ADRESSE'=>$data['devis'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

		        }


		      }
		      $html = $this->load->view('pdf/devis',$data, true);

		      // Load pdf library
		      $this->load->library('pdf');
		                          
		      // Load HTML content
		      $this->dompdf->loadHtml($html);
		                          
		      // (Optional) Setup the paper size and orientation
		      $this->dompdf->setPaper('A4', 'portrait');
		            
		      // Render the HTML as PDF
		      $this->dompdf->render();

		      $this->dompdf->stream("Devis-".$id.".pdf", array("Attachment"=>false));
		      //$this->dompdf->stream("Devis-".$id.".pdf");

	      }
	  }
	    public function viewDevis($id){

	  	  $user_id = $this->session->userdata('idUtilisateur');
	      $nomu = $this->session->userdata('nomUtilisateur');
	      if(!$user_id){
	        $this->load->view('login');
	      }else{
		      $data['devis'] = $this->ArticlesModel->getDevi($id);
		      $data['total'] = 0;
		      $data['totalttc'] = 0;


		      foreach ($data['devis'] as $key => $produit) {

		        $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
		      	$data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

		      }  

		      $data['totaltva'] = $data['totalttc'] - $data['total'];

		      $data['totall'] = $this->getConversion($data['totalttc']);

		      if(count($data['devis'])<16){
		        $number = count($data['devis']);

		        for ($i=$number; $i < 12; $i++) { 

		          array_push($data['devis'],array('DATE'=>$data['devis'][0]['DATE'],'NUMDOC'=>$data['devis'][0]['NUMDOC'],'NOMTIER'=>$data['devis'][0]['NOMTIER'],'ADRESSE'=>$data['devis'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

		        }
		      }
		      $html = $this->load->view('pdf/devis',$data);

	      }
	  }
   private function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 





}