<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

//use thiagoalessio\TesseractOCR\TesseractOCR;

class Factures extends CI_Controller
{


    public function printFacturetest(){


        $data = array();

        $html = $this->load->view('pdf/testfacture',$data, true);

        $this->load->library('pdf');
                            
        $this->dompdf->loadHtml($html);
                            
        $this->dompdf->setPaper('A4', 'portrait');
              
        $this->dompdf->render();

        $this->dompdf->stream("FACTURE.pdf", array("Attachment"=>false));

      
    }


    public function annulerFacture(){

        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

          $id = $this->input->post('id');

          $facture = $this->FacturesModel->annulerFacture($id,$user_id);

          $output = json_encode(array("result"=>true,"session"=>true));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

    }



  public function test(){


    // set_time_limit(0);
    // ini_set('max_execution_time', 0); 

    // // use thiagoalessio\TesseractOCR\TesseractOCR;

    // // echo (new TesseractOCR('./assets/img/idtest.jpg'))
    // //     ->allowlist(range('A', 'Z'))
    // //     ->run();


    // $ocr = new TesseractOCR("./assets/img/idtest.jpg");
    // $content = $ocr->run();
    // echo $content;

  }

  public function facturesFournisseur(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
        $this->load->view('login');
    }else{

      $data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
      $data['banques'] = $this->ArticlesModel->getBanques();

      $header['title'] = 'Gestion Commercial - Gestion Factures Fournisseur';
      $header['page'] = 'facturesFournisseur';

      $this->load->view('templates/header',$header);
      $this->load->view('facturesFournisseur',$data);
      $this->load->view('templates/footer');
    }

  }

  public function index(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
        $this->load->view('login');
    }else{
      $data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
      $data['banques'] = $this->ArticlesModel->getBanques();

      $header['title'] = 'Gestion Commercial - Gestion Factures';
      $header['page'] = 'Factures';
      $this->load->view('templates/header',$header);
      $this->load->view('factures',$data);
      $this->load->view('templates/footer');
    }

  }



  public function getFactureDetails(){

        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

           $id = $this->input->post('id');

          $facture= $this->FacturesModel->getFactureDetails($id);
          $modesPaiement =$this->ArticlesModel->getModesPaiements();
          $banques = $this->ArticlesModel->getBanques();

          $output = json_encode(array("result"=>true,"session"=>true,"facture"=>$facture,"modesPaiement"=>$modesPaiement,"banques"=>$banques));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

  }

  public function getFactureFournisseurDetails(){

        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

           $id = $this->input->post('id');

          $facture= $this->FacturesModel->getFactureFournisseurDetails($id);
          $modesPaiement =$this->ArticlesModel->getModesPaiements();
          $banques = $this->ArticlesModel->getBanques();

          $output = json_encode(array("result"=>true,"session"=>true,"facture"=>$facture,"modesPaiement"=>$modesPaiement,"banques"=>$banques));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

  }
  public function getFacturesClient(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
      $output = json_encode(array("session"=>false));
      $this->output->set_content_type('application/json');
      $this->output->set_output($output);
    }else{

      $idClient = $this->input->post('idClient');
      $factures = $this->FacturesModel->getFacturesClient($idClient);
      $bonsLivraison = $this->FacturesModel->getBonsLivraisonClient($idClient);
      $avoirs = $this->FacturesModel->getAvoirsClient($idClient);
      $factures = array_merge($factures,$bonsLivraison);
      $output = json_encode(array("result"=>true,"session"=>true,'factures'=>$factures,'avoirs'=>$avoirs));
      $this->output->set_content_type('application/json');
      $this->output->set_output($output);

    }
  }

  public function getFacturesFournisseur(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             print json_encode(array("session"=>false));
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $factures= $this->FacturesModel->getFacturesFournisseur($dateCaisse,$dateCaisse1);
          $output = json_encode(array("session"=>true,"factures"=>$factures));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

  }


	public function getFactures(){
        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             print json_encode(array("session"=>false));
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $factures= $this->FacturesModel->getFactures($dateCaisse,$dateCaisse1);
          $output = json_encode(array("session"=>true,"factures"=>$factures));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
  	}

    public function reglerFactureFournisseur(){

      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $output = json_encode(array("session"=>false));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);
      }else{

        $json = $this->input->post('json');

        if($this->FacturesModel->reglerFactureFournisseur($json,$user_id)){
          $factures = $this->FacturesModel->getFacturesFournisseur();
          $output = json_encode(array("result"=>true,"session"=>true,'factures'=>$factures));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }else{

          $output = json_encode(array("result"=>false,"session"=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
      }
    }

  public function reglerFacture(){

      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $output = json_encode(array("session"=>false));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);
      }else{

        $json = $this->input->post('json');

        if($this->FacturesModel->reglerFacture($json,$user_id)){
          $factures = $this->FacturesModel->getFactures();
          $output = json_encode(array("result"=>true,"session"=>true,'factures'=>$factures));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }else{

          $output = json_encode(array("result"=>false,"session"=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
      }
    }


  public function updateFacture(){

    $user_id = $this->session->userdata('idUtilisateur');
    $nomu = $this->session->userdata('nomUtilisateur');
    if(!$user_id){
        $output = json_encode(array("session"=>false));
              $this->output->set_content_type('application/json');
      $this->output->set_output($output);
    }else{

      $json = $this->input->post('json');
      $idFacture = $this->input->post('idFacture');

      if($this->FacturesModel->updateFacture($json,$user_id)){

        $output = json_encode(array("result"=>true,"session"=>true));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }else{

        $output = json_encode(array("result"=>false,"session"=>true));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);

      }

    }
  }
    public function printFacture($id){
      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $this->load->view('login');
      }else{
        $data['facture'] = $this->ArticlesModel->getFacture($id);
        $this->FacturesModel->insertActivity($user_id,$id,$data['facture'][0]['NUMDOC'],45,'');

        $data['total'] = 0;
        $data['totalttc'] = 0;


        foreach ($data['facture'] as $key => $produit) {

          $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
          $data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

        }  

        $data['totaltva'] = $data['totalttc'] - $data['total'];

        $data['totall'] = $this->getConversion($data['totalttc']);

        if(count($data['facture'])<16){
          $number = count($data['facture']);

          for ($i=$number; $i < 10; $i++) { 

            array_push($data['facture'],array('ICE'=>$data['facture'][0]['ICE'],'DATE'=>$data['facture'][0]['DATE'],'NUMDOC'=>$data['facture'][0]['NUMDOC'],'NOMTIER'=>$data['facture'][0]['NOMTIER'],'ADRESSE'=>$data['facture'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

          }
        }

        $html = $this->load->view('pdf/facture',$data, true);

        $this->load->library('pdf');
                            
        $this->dompdf->loadHtml($html);
                            
        $this->dompdf->setPaper('A4', 'portrait');
              
        $this->dompdf->render();

        $this->dompdf->stream("FACTURE-".$id.".pdf", array("Attachment"=>false));

      }
    }

    public function printFactureFournisseur($id){
      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $this->load->view('login');
      }else{
        $data['facture'] = $this->FacturesModel->getFactureFournisseur($id);
        $this->FacturesModel->insertActivity($user_id,$id,$data['facture'][0]['NUMDOC'],48,'');

        $data['total'] = 0;
        $data['totalttc'] = 0;


        foreach ($data['facture'] as $key => $produit) {

          $data['total'] += ($produit['PUHT']*$produit['QTE'])-($produit['PUHT']*$produit['QTE']) * (($produit['REMISE']/100));
          $data['totalttc'] +=($produit['PTTC']*$produit['QTE'])-($produit['PTTC']*$produit['QTE']) * (($produit['REMISE']/100));

        }  

        $data['totaltva'] = $data['totalttc'] - $data['total'];

        $data['totall'] = $this->getConversion($data['totalttc']);

        if(count($data['facture'])<16){
          $number = count($data['facture']);

          for ($i=$number; $i < 10; $i++) { 

            array_push($data['facture'],array('DATE'=>$data['facture'][0]['DATE'],'NUMDOC'=>$data['facture'][0]['NUMDOC'],'NOMTIER'=>$data['facture'][0]['NOMTIER'],'ADRESSE'=>$data['facture'][0]['ADRESSE'],'DESIGNAT'=>'','QTE'=>'','PUHT'=>'','REMISE'=>'','CODETVA'=>'','COMMENT'=>''));

          }
        }

        $html = $this->load->view('pdf/factureFournisseur',$data, false);

        $this->load->library('pdf');
                            
        $this->dompdf->loadHtml($html);
                            
        $this->dompdf->setPaper('A4', 'portrait');
              
        $this->dompdf->render();

        $this->dompdf->stream("FACTURE-".$id.".pdf", array("Attachment"=>true));

      }

  }

  private function getConversion($nombre,$chaine_euro = 'dirham',$chaine_cts = 'centime'){

    $this->load->library('Numbers');

    $chaine_retour = '';
    //deccouper si decimale

    if( $nombre == 0 )return( '' );

    $pos = strpos( $nombre, '.' );
    if( !$pos ){

      $pos = strpos( $nombre, ',' );

    }

    if( $pos ){

      $entier = substr( $nombre, 0, $pos );
      $decimale = substr( $nombre, $pos+1, strlen( $nombre ) - strlen( $entier ) );

      if( $entier > 1 )$chaine_euro .= 's';

      if( $decimale > 1 )$chaine_cts .= 's';

      $chaine_retour = $this->Numbers->Conversion( $entier ). $chaine_euro .' et ' . $this->Numbers->Conversion( $decimale ). $chaine_cts;

    }else{

      if( $nombre > 1 )$chaine_euro .= 's';
      $chaine_retour = $this->Numbers->Conversion( $nombre ). $chaine_euro;

    }

    return( $chaine_retour );
  } 



}