<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller
{
	public function index()
	{

        $user_id = $this->session->userdata('idUtilisateur');
        $nomu = $this->session->userdata('nomUtilisateur');
        if(!$user_id){
              $this->load->view('login');
        }else{
            
            $data['clients'] = $this->ArticlesModel->getClients();
            $data['articles'] = $this->ArticlesModel->getProduits();
            $data['commerciaux'] = $this->ArticlesModel->getCommerciaux();


            $header['title'] = 'Gestion Commercial - Tableau de bord';
            $header['page'] = 'Dashboard';
            $this->load->view('templates/header',$header);
            $this->load->view('home',$data);
            $this->load->view('templates/footer');  
        }

	}

  public function getData(){

        $user_id = $this->session->userdata('idUtilisateur');
        $nomu = $this->session->userdata('nomUtilisateur');
        if(!$user_id){
          $output = json_encode(array('session'=>false));
          
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);
        }else{

          $year = date("Y");

          $cam = array();
          $cam1 = array();
          $ca = 0;

          $articles = $this->ArticlesModel->getTotalArticles();
          $reptureArticles = $this->ArticlesModel->getReptureArticles();
          $stockBasArticles = $this->ArticlesModel->getStockBasArticles();
          $CAMs = $this->ArticlesModel->getCAMonths($year); 
          foreach ($CAMs as $key => $CAM) {
             array_push($cam,(double)$CAM['expense']);
             $ca += (double)$CAM['expense'];

          } 
          $CAM1s = $this->ArticlesModel->getCAMonths($year-1);
          foreach ($CAM1s as $key => $CAM1) {
             array_push($cam1,(double)$CAM1['expense']);
             $ca += (double)$CAM1['expense'];
          } 

          $topArticles = $this->ArticlesModel->TopArticles();
          $topClients = $this->ArticlesModel->TopClients();
          $commerciaux = $this->ArticlesModel->commerciaux($ca);


          $output = json_encode(array('year'=>$year,'year1'=>$year-1,'topArticles'=>$topArticles,'topClients'=>$topClients,'articles'=>$articles,'commerciaux'=>$commerciaux,'reptureArticles'=>$reptureArticles,'stockBasArticles'=>$stockBasArticles,'CAM'=>$cam,'CAM1'=>$cam1,'session'=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);
 
        }


  }





}
?>