<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Logs extends CI_Controller
{
	public function index()
	{
      	$user_id = $this->session->userdata('idUtilisateur');
		if(!$user_id){
			 $this->load->view('pages/login');
		}else{
			//data['logs'] = $this->LogsModel->getLogs();
			$data['types'] = $this->LogsModel->getTypes();
			$data['operations'] = $this->LogsModel->getOperations();
			$data['utilisateurs'] = $this->LogsModel->getUtilisateurs();
			$this->load->view('templates/header');
			$this->load->view('logs',$data);
			$this->load->view('templates/footer');
		}
	}
	public function getLogs()
	{
      	$user_id = $this->session->userdata('idUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{

			$type= $this->input->post('type');
			$operation = $this->input->post('operation');
			$utilisateur = $this->input->post('utilisateur');
			$date = $this->input->post('date');

            $logs = $this->LogsModel->getLogs($type,$operation,$utilisateur,$date);
			foreach ($logs as $log) : ?>              
                  <tr>
                    <td><?php echo $log['idLog']; ?></td>
                    <?php if ($log['operation'] == 'Creation'): ?>
                        <td><span style="font-size: 100%;" class="label label-success"><?php echo $log['operation']; ?></span></td>
                    <?php elseif ($log['operation'] == 'Suppression') : ?>
                        <td><span  style="font-size: 100%;" class="label label-warning"><?php echo $log['operation']; ?></span></td>
                    <?php elseif ($log['operation'] == 'Modification') : ?>
                        <td><span  style="font-size: 100%;" class="label label-info"><?php echo $log['operation']; ?></span></td>
                    <?php elseif ($log['operation'] == 'Annulation') : ?>
                        <td><span  style="font-size: 100%;" class="label label-danger"><?php echo $log['operation']; ?></span></td>
                    <?php else : ?>
                        <td><span  style="font-size: 100%;" class="label label-default"><?php echo $log['operation']; ?></span></td>
                    <?php endif ?>


                    <td><?php echo $log['type']; ?></td>
                    <td><?php echo $log['description']; ?></td>
                    <td><?php echo $log['Utilisateur']; ?></td>
                    <td><?php echo $log['dateCreation']; ?></td>
                  </tr>
           <?php  endforeach; 
			

		}
	}

	public function downloadCSV()
	{
      	$user_id = $this->session->userdata('idUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			$type= $this->input->get('type');
			$operation = $this->input->get('operation');
			$utilisateur = $this->input->get('utilisateur');
			$date = $this->input->get('date');
			$this->LogsModel->csv($type,$operation,$utilisateur,$date);
		}
	}



	public function downloadEXCEL()
	{

	    $this->load->library("excel");
	  	$type= $this->input->get('type');
		$operation = $this->input->get('operation');
		$utilisateur = $this->input->get('utilisateur');
		$date = $this->input->get('date');
	  $object = new PHPExcel();

	  $object->setActiveSheetIndex(0);

	  $table_columns = array("id", "Operation", "Type", "Description", "Utilisateur",  "Date");
	  $column = 0;

	  foreach($table_columns as $field)
	  {
	   $object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
	   $column++;
	  }

	  $employee_data = $this->LogsModel->getLogsXsl($type,$operation,$utilisateur,$date);
	  $excel_row = 2;

	  foreach($employee_data as $row)
	  {
	   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row['idLog']);
	   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row['operation']);
	   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row['type']);
	   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row['description']);
	   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row['Utilisateur']);
	   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row['dateCreation']);
	   
	   $excel_row++;
	  }

	  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	  header('Content-Type: application/vnd.ms-excel');
	  header('Content-Disposition: attachment;filename="Logs.xls"');
	  $object_writer->save('php://output');
	 }




}
?>