<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Partenaires extends CI_Controller
{

	public function index()
	{
		    $user_id = $this->session->userdata('idUtilisateur');
			if(!$user_id){
			  $this->load->view('login');
			  //echo'LogOut';
			}else{
				$data['partenaires'] = $this->PartenairesModel->getPartenaires();
				$data['quarties'] = $this->ClientsModel->getQuartiers();

			    $this->load->view('templates/header');
				$this->load->view('partenaires',$data);
				$this->load->view('templates/footer');
			}
	}

	public function add(){

			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
			  $this->load->view('login');
			}else{
				$nom = $this->input->post('name');
				$tel = $this->input->post('tel');
				$adresse = $this->input->post('adresse');
				$quar = $this->input->post('quar');
				if($this->PartenairesModel->insert($nom,$tel,$adresse,$quar)){
                    $this->LogsModel->insertLog('Creation','Partenaire',$nomu.' a cree le partenaire '.$nom,$user_id);
					redirect(base_url().'partenaires');
				}
			    
			}
	}

	public function setCarte($id){
			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
			  $this->load->view('login');
			}else{

				$data['categories'] = $this->CategoriesModel->getCategories();
                $data['prestations'] = $this->PartenairesModel->getPartenairePrestation($id);
				$data['Imprimantes'] = $this->ImprimantesModel->getImprimantes();
				$data['Unites'] = $this->UnitesModel->getUnites();
				$data['Tailles'] = $this->TaillesModel->getTailles();
				$data['typesPrestation'] = $this->PrestationsModel->getTypesPrestation();
				$data['idPartenaire'] = $id;

			    $this->load->view('templates/header');
				$this->load->view('createCarte',$data);
				$this->load->view('templates/footer');

			}
	}

	public function addCarte($id){

			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
			   echo'LogOut';
			}else{

				$items = $this->input->post('items');
				if($this->PartenairesModel->insertCarte($id,$items)){
					echo 'Created';

				}
			}
      

	}

	public function delete($id){

			$user_id = $this->session->userdata('idUtilisateur');
			$nomu = $this->session->userdata('nomUtilisateur');
			if(!$user_id){
			   echo'LogOut';
			}else{

				if($this->PartenairesModel->delete($id)){
					echo 'Deleted';

				}
			}

	}
}