<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Planning extends CI_Controller
{


	public function index()
	{

	    $id = $this->session->userdata('id');
	    if(!$id){
	      $this->load->view('login');
	    }else{
				setlocale(LC_TIME, "fr_FR");  

				$cloture = $this->HotelModel->getCloture();
				$dateCloture = $cloture->dateCloture;	

				$data['date'] = $dateCloture;

				$dated = date('Y-m-d', strtotime(date('Y-m-d',strtotime($dateCloture)) . ' -1 day'));
				$datef = date('Y-m-d', strtotime(date('Y-m-d',strtotime($dateCloture)) . ' +13 day'));

				$data['datef'] = $dated;
				$data['dated'] = $datef;
				$data['peroid'] = utf8_encode(strftime('%d %b %Y',strtotime($dated)).' - '.strftime('%d %b %Y',strtotime($datef)));

				$data['rooms'] = $this->ReservationsModel->getRoomReservation($dated,$datef);
				$data['reservations'] = $this->ReservationsModel->getRoomReservationsAll();


				$html = $this->generatePlanning1($dated,$datef,$dateCloture);

				$data['plan'] = $html;
				$footer['title'] = 'Planning';

				$header['hotel'] = $this->session->userdata('hotel');

      			$header['nom'] = $this->session->userdata('nom');

				$header['title'] ="Planning";
				$header['page'] ="Planning";
				$header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

				$this->load->view('templates/header',$header);
				$this->load->view('planning',$data);
				$this->load->view('templates/footer',$footer);
		}
	}

	public function createPlanning(){

		$id = $this->session->userdata('id');
	    if(!$id){
	        $results = array('status'=>true,'session'=>false);
        	echo json_encode(( $this->utf8ize( $results ) ));
	    }else{

			setlocale(LC_TIME, "fr_FR");

			$cloture = $this->HotelModel->getCloture();
			$dateCloture = $cloture->dateCloture;	

			$dated = $this->input->post('datea');
			$datef = $this->input->post('dated');
			$operation = $this->input->post('operation');
			$value = $this->input->post('value');
			if($operation == 1){
				$dated = date('Y-m-d', strtotime($dated . ' +'.$value.' day'));
				$datef = date('Y-m-d', strtotime($datef . ' +'.$value.' day'));


			}elseif($operation == 10){

			}else{
				$dated = date('Y-m-d', strtotime($dated . ' -'.$value.' day'));
				$datef = date('Y-m-d', strtotime($datef . ' -'.$value.' day'));
			}

			$html  = $this->generatePlanning1($dated,$datef,$dateCloture);
			
			$peroid = utf8_encode(strftime('%d %b %Y',strtotime($dated)).' - '.strftime('%d %b %Y',strtotime($datef)));

			print json_encode(array('status'=>true,'session'=>true,'html'=>$html,'dated'=>$dated,'datef'=>$datef,'peroid'=>$peroid));
		}


	}
	private function generatePlanning1($dated,$datef,$dateCloture){


		$rooms = $this->ReservationsModel->getRoomReservation($dated,$datef);
		$reservations = $this->ReservationsModel->getRoomReservationDates($dated,$datef);

		$disponibilites = $this->getDisponibilites($rooms,$reservations,$dated,$datef);

		$begin = new DateTime($dated);
		$end = new DateTime($datef);
		$end = $end->modify( '+1 day' ); 
		$interval = new DateInterval('P1D');
		$daterange = new DatePeriod($begin, $interval ,$end);
		$idch = 0;
		$idchbre = 0;
		$plan = array();
		$html ='<table id="planningContent" class="table planning"><thead ><th colspan="4" style="border: 1px solid #ECECED;"></th>';
		foreach($daterange as $date){
			if($this->istoday($date->format('Y-m-d'),$dateCloture)){
				$html .='<th class="text-center date-cell today" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}else{
				$html .='<th class="text-center date-cell" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}
		}
        $html .='</thead><tbody>';
		foreach ($rooms as $key => $room) {
			// if($idch != $room['idTypeChambres']){
			// 	$idch = $room['idTypeChambres'];
			// 	$html .='<tr class="header"><td colspan="3" class="type-ch bg-alter-ch">'.$room['nomTypeChambres'].'</td><td onclick="collapse(this)" style="padding-top: 5px;" class="between-left operation-icon bg-alter-ch"><i  class="fa fa-chevron-down clickable"></i></td>';
	  //           foreach($daterange as $date){

	  //           	$dispo = $room['capacite'] - $disponibilites[$room['idTypeChambres']][$date->format('Y-m-d')];
	  //           	$dispoClass="";
	  //           	if($dispo>1){
			// 			$dispoClass="positive-text";
	  //           	}else{
			// 			$dispoClass="negative-text";
	  //           	}
	  //           	if($this->istoday($date->format('Y-m-d'),$dateCloture)){
			// 			$html .='<td class="text-center dispo-cell bg-alter-ch line-today" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	  //           	}else if($this->isyesterday($date->format('Y-m-d'),$dateCloture)){
			// 			$html .='<td class="text-center dispo-cell bg-alter-ch line-today-right" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	  //           	}else{
	  //           		$html .='<td class="text-center dispo-cell bg-alter-ch" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';	
	  //           	}    
	  //           }
	  //           $html .='</tr>';
			// }
			if($idchbre != $room['idChambres']){
				$idchbre = $room['idChambres'];
				$html .='<tr><td colspan="3" style="border: 1px solid #ECECED;border-right: none;"><i class="fa fa-square etat-chambre clickablee"></i> <span class="chambre-nom">'.$room['nomChambre'].'</span></td><td class="between-left operation-icon"><i class="fa fa-ellipsis-h clickable"></i></td>';
				$datee = $dated;
				$last_checkout = false;
				while (strtotime($datee) <= strtotime($datef)) {
					if($datee>$dated){
						$last_checkout = false;
					}					
					$rr = $this->searchBook($reservations,$room['idTypeChambres'],$datee,$plan,$dated,$datef,$room['idChambres'],$last_checkout);
					if($rr){
							if($dated == $rr['dateAu']){
								$last_checkout = true;
							}

							if($rr['idChambres'] == $idchbre){
									
									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;

									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
						            	if(!$last_checkout){
							            	if($this->isweekend($datee,"saturday","sunday")){	
												$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
											}else{
												$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
											}
						            	}
										
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}


									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}


									if($colspan>30){
										$colspan = 30;
									}


									if($rr['isCheckout']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-red" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else if($rr['isCheckin']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-orange" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else{
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-green" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}


									



									$datee = date ("Y-m-d", strtotime("+".intval($nuites)." day", strtotime($datee)));





							}else{

									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;
									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
									 	if(!$last_checkout){
											if($this->isweekend($datee,"saturday","sunday")){	
												$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
											}else{
												$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
											}
						            	}
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}

									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}
									if($colspan>30){
										$colspan = 30;
									}




									if($rr['dateDu'] == $datef){
										$colspan = 1;
									}
									
									$html .='<td colspan="'.round($colspan).'" class="cell-filled" > <div class="wrapper-reservation bg-blue-marine" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"> <img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div> </div> </td>';




									$datee = date ("Y-m-d", strtotime("+".round($nuites) ." day", strtotime($datee)));
										


									

							}

					}else{

							$today = '';

							if($this->istoday($datee,$dateCloture)){
								$today =' line-today';
			            	}else if($this->isyesterday($datee,$dateCloture)){
								$today =' line-today-right';
			            	}



							if($datee == $dated){
								if(!$last_checkout){
									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								}
								


									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'" ></td>';
									}
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								


							}else if($datee == $datef){

								if($this->isweekend($datee,"saturday","sunday")){	
									$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'"></td>';
								}else{
									$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
								}
							}else{
								

									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
									}
								
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'"></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								
							}
							$datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee)));
							
					}
				}
				$html .='</tr>';    
			}
			
		}

        $html .='</tbody></table>';
		

        return $html;

	}

	private function generatePlanning2($dated,$datef,$dateCloture){


		$rooms = $this->ReservationsModel->getRoomReservation($dated,$datef);
		$reservations = $this->ReservationsModel->getRoomReservationDates($dated,$datef);

		$disponibilites = $this->getDisponibilites($rooms,$reservations,$dated,$datef);

		$begin = new DateTime($dated);
		$end = new DateTime($datef);
		$end = $end->modify( '+1 day' ); 
		$interval = new DateInterval('P1D');
		$daterange = new DatePeriod($begin, $interval ,$end);
		$idch = 0;
		$idchbre = 0;
		$plan = array();
		$html ='<table class="table planning"><thead><th colspan="4" style="border: 1px solid #ECECED;"></th>';
		foreach($daterange as $date){
			if($this->istoday($date->format('Y-m-d'),$dateCloture)){
				$html .='<th class="text-center date-cell today" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}else{
				$html .='<th class="text-center date-cell" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}
		}
        $html .='</thead><tbody>';
		foreach ($rooms as $key => $room) {
			if($idch != $room['idTypeChambres']){
				$idch = $room['idTypeChambres'];
				$html .='<tr class="header"><td colspan="3" class="type-ch bg-alter-ch">'.$room['nomTypeChambres'].'</td><td onclick="collapse(this)" style="padding-top: 5px;" class="between-left operation-icon bg-alter-ch"><i  class="fa fa-chevron-down clickable"></i></td>';
	            foreach($daterange as $date){

	            	$dispo = $room['capacite'] - $disponibilites[$room['idTypeChambres']][$date->format('Y-m-d')];
	            	$dispoClass="";
	            	if($dispo>1){
						$dispoClass="positive-text";
	            	}else{
						$dispoClass="negative-text";
	            	}
	            	if($this->istoday($date->format('Y-m-d'),$dateCloture)){
						$html .='<td class="text-center dispo-cell bg-alter-ch line-today" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	            	}else if($this->isyesterday($date->format('Y-m-d'),$dateCloture)){
						$html .='<td class="text-center dispo-cell bg-alter-ch line-today-right" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	            	}else{
	            		$html .='<td class="text-center dispo-cell bg-alter-ch" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';	
	            	}    
	            }
	            $html .='</tr>';
			}
			if($idchbre != $room['idChambres']){
				$idchbre = $room['idChambres'];
				$html .='<tr><td colspan="3" style="border: 1px solid #ECECED;border-right: none;"><i class="fa fa-square etat-chambre clickablee"></i> <span class="chambre-nom">'.$room['nomChambre'].'</span></td><td class="between-left operation-icon"><i class="fa fa-ellipsis-h clickable"></i></td>';
				$datee = $dated;
				
				while (strtotime($datee) <= strtotime($datef)) {
					$last_checkout = false;
					$rr = $this->searchBook($reservations,$room['idTypeChambres'],$datee,$plan,$dated,$datef,$room['idChambres']);
					if($rr){

							if($rr['idChambres'] == $idchbre){
									$last_checkout = true;
									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;
									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
										if($this->isweekend($datee,"saturday","sunday")){	
											$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
										}else{
											$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
										}
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}


									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}


									if($colspan>30){
										$colspan = 30;
									}


									if($rr['isCheckout']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-red" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else if($rr['isCheckin']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-orange" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else{
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-green" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}


									



									$datee = date ("Y-m-d", strtotime("+".intval($nuites)." day", strtotime($datee)));





							}else{

									$last_checkout = true;
									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;
									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
										if($this->isweekend($datee,"saturday","sunday")){	
											$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
										}else{
											$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
										}
									 	
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}

									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}
									if($colspan>30){
										$colspan = 30;
									}




									if($rr['dateDu'] == $datef){
										$colspan = 1;
									}
									
									$html .='<td colspan="'.round($colspan).'" class="cell-filled" > <div class="wrapper-reservation bg-blue-marine" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div> </div> </td>'; 
									$datee = date ("Y-m-d", strtotime("+".round($nuites) ." day", strtotime($datee)));
										


									

							}

						}else{

							$today = '';

							if($this->istoday($datee,$dateCloture)){
								$today =' line-today';
			            	}else if($this->isyesterday($datee,$dateCloture)){
								$today =' line-today-right';
			            	}



							if($datee == $dated){
								//if(!$last_checkout){
									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								//}
								


									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'" ></td>';
									}
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								


							}else if($datee == $datef){

								if($this->isweekend($datee,"saturday","sunday")){	
									$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'"></td>';
								}else{
									$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
								}
							}else{
								

									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
									}
								
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'"></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								
							}
							$datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee)));
							
						}
				}
				$html .='</tr>';    
			}
			
		}

        $html .='</tbody></table>';
		

        return $html;

	}



	private function generatePlanning($dated,$datef,$dateCloture){


		$rooms = $this->ReservationsModel->getRoomReservation($dated,$datef);
		$reservations = $this->ReservationsModel->getRoomReservationDates($dated,$datef);

		$disponibilites = $this->getDisponibilites($rooms,$reservations,$dated,$datef);

		$begin = new DateTime($dated);
		$end = new DateTime($datef);
		$end = $end->modify( '+1 day' ); 
		$interval = new DateInterval('P1D');
		$daterange = new DatePeriod($begin, $interval ,$end);
		$idch = 0;
		$idchbre = 0;
		$plan = array();
		$html ='<table class="table planning"><thead><th colspan="4" style="border: 1px solid #ECECED;"></th>';
		foreach($daterange as $date){
			if($this->istoday($date->format('Y-m-d'),$dateCloture)){
				$html .='<th class="text-center date-cell today" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}else{
				$html .='<th class="text-center date-cell" colspan="2"><div class="mois">'.$this->getDayName($date->format("l")).'</div><div class="day">'.$date->format("d").'</div></th>';
			}
		}
        $html .='</thead><tbody>';
		foreach ($rooms as $key => $room) {
			if($idch != $room['idTypeChambres']){
				$idch = $room['idTypeChambres'];
				$html .='<tr class="header"><td colspan="3" class="type-ch bg-alter-ch">'.$room['nomTypeChambres'].'</td><td onclick="collapse(this)" style="padding-top: 5px;" class="between-left operation-icon bg-alter-ch"><i  class="fa fa-chevron-down clickable"></i></td>';
	            foreach($daterange as $date){

	            	$dispo = $room['capacite'] - $disponibilites[$room['idTypeChambres']][$date->format('Y-m-d')];
	            	$dispoClass="";
	            	if($dispo>1){
						$dispoClass="positive-text";
	            	}else{
						$dispoClass="negative-text";
	            	}
	            	if($this->istoday($date->format('Y-m-d'),$dateCloture)){
						$html .='<td class="text-center dispo-cell bg-alter-ch line-today" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	            	}else if($this->isyesterday($date->format('Y-m-d'),$dateCloture)){
						$html .='<td class="text-center dispo-cell bg-alter-ch line-today-right" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';
	            	}else{
	            		$html .='<td class="text-center dispo-cell bg-alter-ch" colspan="2"><span class="dispo '.$dispoClass.'">'.$dispo.'</span></td>';	
	            	}    
	            }
	            $html .='</tr>';
			}
			if($idchbre != $room['idChambres']){
				$idchbre = $room['idChambres'];
				$html .='<tr><td colspan="3" style="border: 1px solid #ECECED;border-right: none;"><i class="fa fa-square etat-chambre clickablee"></i> <span class="chambre-nom">'.$room['nomChambre'].'</span></td><td class="between-left operation-icon"><i class="fa fa-ellipsis-h clickable"></i></td>';
				$datee = $dated;
				
				while (strtotime($datee) <= strtotime($datef)) {
					$last_checkout = false;
					$rr = $this->searchBook($reservations,$room['idTypeChambres'],$datee,$plan,$dated,$datef,$room['idChambres']);
					if($rr){

							if($rr['idChambres'] == $idchbre){
									$last_checkout = true;
									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;
									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
										if($this->isweekend($datee,"saturday","sunday")){	
											$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
										}else{
											$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
										}
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}


									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}


									if($colspan>30){
										$colspan = 30;
									}


									if($rr['isCheckout']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-red" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else if($rr['isCheckin']){
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-orange" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}else{
										$html .='<td colspan="'.$colspan.'" class="cell-filled" ><div class="wrapper-reservation bg-green" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div></div></td>';
									}


									



									$datee = date ("Y-m-d", strtotime("+".intval($nuites)." day", strtotime($datee)));





							}else{

									$last_checkout = true;
									$plan[] = $rr['idCR'];
									$nuites = $rr['nuites'];

									$colspan = ($rr['nuites'] * 2) ;
									if($dated > $rr['dateDu']){
									 	$colspan +=1;
									}else if($dated == $rr['dateDu']){
										$today = '';

										if($this->istoday($datee,$dateCloture)){
											$today =' line-today';
						            	}else if($this->isyesterday($datee,$dateCloture)){
											$today =' line-today-right';
						            	}
										if($this->isweekend($datee,"saturday","sunday")){	
											$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
										}else{
											$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
										}
									 	
									}
									if($datef < $rr['dateAu']){
									 	$nuites +=2; 
									 	$colspan +=1;
									}

									if($rr['dateAu']>$datef){
										if($rr['dateDu'] == $datef){
											$colspan = 1;
										}else{
											$dateOne = new DateTime($rr['dateDu']);
											$dateTwo = new DateTime($datef);
											$colspan = ($dateTwo->diff($dateOne)->format("%a")*2)+1;
										}
									}
									if($colspan>30){
										$colspan = 30;
									}




									if($rr['dateDu'] == $datef){
										$colspan = 1;
									}
									
									$html .='<td colspan="'.round($colspan).'" class="cell-filled" > <div class="wrapper-reservation bg-blue-marine" onclick="detailsReservation('.$rr['idReservation'].')"> <div> <p class="reservation"><img style="height:10px;width:10px;vertical-align: initial;" src="'.base_url().'/assets/otas/'.$rr['channel'].'.png">'.$rr['client'].'</p> <p class="checkinout">'.date("m/d",strtotime($rr['dateDu'])).'&rarr;'.date("m/d",strtotime($rr['dateAu'])).'</p> </div> </div> </td>'; 
									$datee = date ("Y-m-d", strtotime("+".round($nuites) ." day", strtotime($datee)));
										


									

							}

						}else{

							$today = '';

							if($this->istoday($datee,$dateCloture)){
								$today =' line-today';
			            	}else if($this->isyesterday($datee,$dateCloture)){
								$today =' line-today-right';
			            	}



							if($datee == $dated){
								//if(!$last_checkout){
									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								//}
								


									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'" ></td>';
									}
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								


							}else if($datee == $datef){

								if($this->isweekend($datee,"saturday","sunday")){	
									$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'"></td>';
								}else{
									$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
								}
							}else{
								

									if($this->isweekend($datee,"saturday","sunday")){	
										$html .='<td class="text-center cell-vide between-left bg-alter-left'.$today.'" ></td>';
									}else{
										$html .='<td class="text-center cell-vide between-left'.$today.'"></td>';
									}
								
									if($this->isweekend($datee,"friday","saturday")){	
										$html .='<td class="text-center cell-vide between-right bg-alter-right'.$today.'"></td>';
									}else{
										$html .='<td class="text-center cell-vide between-right'.$today.'" ></td>';
									}
								
							}
							$datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee)));
							
						}
				}
				$html .='</tr>';    
			}
			
		}

        $html .='</tbody></table>';
		

        return $html;

	}


	private function getDisponibilitesDates($rooms,$chambre,$date,$plan,$dated,$datef,$idc){

				setlocale(LC_TIME, "fr_FR");  

				$cloture = $this->HotelModel->getCloture();
				$dateCloture = $cloture->dateCloture;	

				$data['date'] = $dateCloture;

				$dated = date('Y-m-d', strtotime(date('Y-m-d',strtotime($dateCloture)) . ' -1 day'));
				$datef = date('Y-m-d', strtotime(date('Y-m-d',strtotime($dateCloture)) . ' +13 day'));

				$data['datef'] = $dated;
				$data['dated'] = $datef;
				$data['peroid'] = utf8_encode(strftime('%d %b %Y',strtotime($dated)).' - '.strftime('%d %b %Y',strtotime($datef)));

				$html = $this->generatePlanning($dated,$datef);

				$data['plan'] = $html;
				$footer['title'] = 'Planning';

				$header['hotel'] = $this->session->userdata('hotel');

      			$header['nom'] = $this->session->userdata('nom');

				$header['title'] = "Planning";
				$header['page'] = "Planning";
				$header['date'] = ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

				$this->load->view('templates/header',$header);
				$this->load->view('planning',$data);
				$this->load->view('templates/footer',$footer);


	}


	private function beginSearchBook($rooms,$chambre,$date,$plan,$dated,$datef,$idc){

		foreach ($rooms as $key => $room) { 
			if(!in_array($room['idCR'], $plan)){
			if(($room['idChambres'] == $idc && $dated == $room['dateAu'] && $dated == $date) ){

					return $room;

			}

			if(($room['idTypeChambres'] == $chambre && $room['idChambres'] == 0 && $dated == $room['dateAu'] && $dated == $date) ){

				 	foreach ($rooms as $key => $room1) {


				 		if($room1['idChambres'] == $idc && $room['dateAu'] > $room1['dateDu'] && $room['dateDu'] < $room1['dateAu']){

				 			if($room1['dateDu']<$dated){
									if($date != $room1['dateDu']){

											$start_date = strtotime($date); 
											$end_date = strtotime($room1['dateAu']); 
											$room1['nuites']	= ($end_date - $start_date)/60/60/24;

									}
									if($datef < $room1['dateAu']){

											$start_date = strtotime($room1['dateDu']); 
											$end_date = strtotime($datef); 
											$room1['nuites']	= ($end_date - $start_date)/60/60/24; 

									}

									return  $room1;

				 			}else{

								if($date == $room1['dateDu']){
					 				//echo $room1['client'].' - '.$room1['dateDu'].' - '.$room1['dateAu'].'<br>';
					 				return  $room1;
					 			}else{
					 				return false;
								}

				 			}
				 		}

				 	}
					return $room;

				}
			}}
			return false;
	}


	private function getDisponibilites($rooms,$reservations,$dated,$datef){

        
        $disponibilites = array();
        $idch = 0;
        foreach ($rooms as $key => $room) {

        	if($idch != $room['idTypeChambres']){

        		$idch = $room['idTypeChambres'];

	            $datee = $dated;

		        while (strtotime($datee) <= strtotime($datef)) {

		       		if (!isset($disponibilites[$room['idTypeChambres']][$datee])) {
		       			$disponibilites[$room['idTypeChambres']][$datee] = 0;
		       		}

		       		foreach ($reservations as $key => $reservation) {
		       			if($reservation['idTypeChambres'] == $room['idTypeChambres']  && $reservation['dateDu'] <= $datee && $reservation['dateAu'] > $datee){

		       				$disponibilites[$room['idTypeChambres']][$datee] += 1;

		       			}
		       		}

		       		$datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee)));
		        }
		    }

        }

		return $disponibilites;

	}


	private function searchBook($rooms,$chambre,$date,$plan,$dated,$datef,$idc,$last_checkout){

		foreach ($rooms as $key => $room) {




			if(!in_array($room['idCR'], $plan)){

				if($dated == $date){
					if($room['idChambres'] == $idc && $dated == $room['dateAu'] && !$last_checkout){
						$room['nuites']	= 0 ;
						return $room;

					}elseif($room['idTypeChambres'] == $chambre  && $room['idChambres'] == 0 && $dated == $room['dateAu'] && !$last_checkout){
						$room['nuites']	= 0 ;
						return $room;
					}
				}

				if(($room['idChambres'] == $idc && $date == $room['dateDu'])  ||  ($room['idChambres'] == $idc && $dated > $room['dateDu']) && $dated < $room['dateAu'] &&  $dated == $date && !$last_checkout ){

					if($date != $room['dateDu']){

							$start_date = strtotime($date); 
							$end_date = strtotime($room['dateAu']);
							$room['nuites']	= ($end_date - $start_date)/60/60/24;

					}
					if($datef < $room['dateAu']){

							$start_date = strtotime($room['dateDu']); 
							$end_date = strtotime($datef); 
							$room['nuites']	= ($end_date - $start_date)/60/60/24; 

					}
					return $room;

				}

				if(($room['idTypeChambres'] == $chambre  && $room['idChambres'] == 0 && $date == $room['dateDu']) || 

				 ($room['idTypeChambres'] == $chambre  && $room['idChambres'] == 0 && $dated > $room['dateDu']) && $dated < $room['dateAu'] &&  $dated == $date && !$last_checkout  ){


				 	foreach ($rooms as $key => $room1) {


				 		if($room1['idChambres'] == $idc && $room['dateAu'] > $room1['dateDu'] && $room['dateDu'] < $room1['dateAu']){

				 			if($room1['dateDu']<$dated){
									if($date != $room1['dateDu']){

											$start_date = strtotime($date); 
											$end_date = strtotime($room1['dateAu']); 
											$room1['nuites']	= ($end_date - $start_date)/60/60/24;

									}
									if($datef < $room1['dateAu']){

											$start_date = strtotime($room1['dateDu']); 
											$end_date = strtotime($datef); 
											$room1['nuites']	= ($end_date - $start_date)/60/60/24; 

									}

									return  $room1;

				 			}else{

								if($date == $room1['dateDu']){
					 				//echo $room1['client'].' - '.$room1['dateDu'].' - '.$room1['dateAu'].'<br>';
					 				return  $room1;
					 			}else{
					 				return false;
								}

				 			}
				 		}

				 	}

					if($date != $room['dateDu']){

							$start_date = strtotime($date); 
							$end_date = strtotime($room['dateAu']); 
							$room['nuites']	= ($end_date - $start_date)/60/60/24;

					}
					if($datef < $room['dateAu']){

							$start_date = strtotime($room['dateDu']); 
							$end_date = strtotime($datef); 
							$room['nuites']	= ($end_date - $start_date)/60/60/24; 

					}
				 	return $room;
				
				 }


			}



         }
		return false;
	}

	private function getDayName($day){

		switch ($day) {

			case 'Monday':
				return 'Lun';
			case 'Tuesday':
				return 'Mar';
			case 'Wednesday':
				return 'Mer';
			case 'Thursday':
				return 'Jeu';
			case 'Friday':
				return 'Ven';
			case 'Saturday':
				return 'Sam';
			case 'Sunday':
				return 'Dim';

		}
	}


	private function isweekend($date,$date1,$date2){
	    $date = strtotime($date);
	    $date = date("l", $date);
	    $date = strtolower($date);
	    if($date == $date1 || $date == $date2) {
	        return true;
	    } else {
	        return false;
	    }
	}

	private function istoday($date,$dateCloture){

		// $today = new DateTime($dateCloture);
  //       $today->setTimezone(new DateTimeZone('Africa/Casablanca'));	  

	    if($date == $dateCloture) {
	        return true;
	    } else {
	        return false;
	    }
	}
	private function isyesterday($date,$dateCloture){	
		// $today = new DateTime(date('Y-m-d H:m:s',strtotime(date('Y-m-d H:m:s') . ' -1 day')));
  //       $today->setTimezone(new DateTimeZone('Africa/Casablanca'));


        $dateCl = date('Y-m-d',strtotime($dateCloture.' -1 day'));

	    if($date == $dateCl) {
	        return true;
	    } else {
	        return false;
	    }
	}
	

}