<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Produits extends CI_Controller
{
	public function index(){
      	$user_id = $this->session->userdata('idUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			if ($this->session->userdata('backOffice')) {
				$data['categories'] = $this->CategoriesModel->getCategories();
				$data['prestations'] = $this->PrestationsModel->getStockPrestation();
				$data['Imprimantes'] = $this->ImprimantesModel->getImprimantes();
				$data['Unites'] = $this->UnitesModel->getUnites();
				$data['Tailles'] = $this->TaillesModel->getTailles();
				$data['typesPrestation'] = $this->PrestationsModel->getTypesPrestation();
				$this->load->view('templates/header');
				$this->load->view('produits',$data);
				$this->load->view('templates/footer');
			}
		}
	}


	public function getDetailsArticle($id){
		$imprimantes = $this->ImprimantesModel->getImprimantes();
		$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
		$combinaisons = $this->PrestationsModel->getCombo($id);
		$Accomps = $this->AccompagnementsModel->getAccompagnements();
		print json_encode(array('prestation'=>$prestations,'imprimantes'=>$imprimantes,'attributs'=>$Accomps,'combinaisons'=>$combinaisons));
	}

	public function getDetailsArticleT($id){
		$imprimantes = $this->ImprimantesModel->getImprimantes();
		$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
		$tailles = $this->PrestationsModel->getTailles($id);
		$Accomps = $this->AccompagnementsModel->getAccompagnements();
		print json_encode(array('prestation'=>$prestations,'imprimantes'=>$imprimantes,'attributs'=>$Accomps,'tailles'=>$tailles));
	}

	public function getDetailsArticleC($id){
		$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
		$categories = $this->CategoriesModel->getFormuleCategories($id);
		$Accomps = $this->AccompagnementsModel->getAccompagnements();
		print json_encode(array('prestation'=>$prestations,'attributs'=>$Accomps,'categories'=>$categories));
	}

	public function getDetailsArticleR($id){
		$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
		$rations = $this->PrestationsModel->getRations($id);
		print json_encode(array('prestation'=>$prestations,'rations'=>$rations));
	}

	public function getPrestationsT($id){
		$prestations = $this->PrestationsModel->getStockPrestationT($id);
		print json_encode(array('prestations'=>$prestations));
	}

	public function getPrestationsC($id){
		$prestations = $this->PrestationsModel->getStockPrestationC($id);
		print json_encode(array('prestations'=>$prestations));
	}

	public function getPrestations(){
		$prestations = $this->PrestationsModel->getStockPrestationM();
		print json_encode(array('prestations'=>$prestations));
	}

	public function delete($idPrestation){
      	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			if ($this->session->userdata('backOffice')) {
				$resultats = $this->PrestationsModel->removePrestation($idPrestation);
				if($resultats['result']){
					if($this->LogsModel->insertLog('Suppression','Prestations',$nomu.' a supprimer la Prestation id('.$idPrestation.')',$user_id)){
						echo true;
					}
				}else if(!$resultats['result']){
					echo '<div class="text-center" ><ul>';
					foreach ($resultats['Prestations'] as $pretation) {
						echo '<li><h2>'.$pretation['libelle'].'</h2></li>';
					}
					echo '</ul></div>';

				}
			}
		}
	}

	public function edit(){
      	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			if ($this->session->userdata('backOffice')) {

				$idPrestation = $this->uri->segment(3);
				$data['categories'] = $this->CategoriesModel->getCategories();
				$data['Prestations'] = $this->PrestationsModel->getPrestation($idPrestation);
				$data['Imprimantes'] = $this->ImprimantesModel->getImprimantes();
				$data['Unites'] = $this->UnitesModel->getUnites();
				$data['Tailles'] = $this->TaillesModel->getTailles();
				$data['typesPrestation'] = $this->PrestationsModel->getTypesPrestation();
				$data['PAccomps'] = $this->PrestationsModel->getAccopaP($idPrestation);
				$data['PTailles'] = $this->PrestationsModel->getTP($idPrestation);
				$data['Accomps'] = $this->AccompagnementsModel->getAccompagnements();
		
				$this->load->view('templates/header');
				$this->load->view('editProduit',$data);
				$this->load->view('templates/footer');

			}


		}
	}

	public function modifier(){
		$user_id = $this->session->userdata('idUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			if ($this->session->userdata('backOffice')) {

						$config['upload_path'] = 'assets/uploads/';
						$config['allowed_types'] = 'gif|jpg|png|jpeg';
						$config['max_width'] = 0;
						$config['max_height'] = 0;
						$config['max_size'] = 0;
						$this->load->library('upload', $config);
						$this->upload->do_upload();
						$name = $this->input->post('name');
						$type = $this->input->post('type');
						$color = $this->input->post('color');
						$idP = $this->input->post('idP');
						$unite = $this->input->post('unite');
						$imprimante = $this->input->post('imprimant');
						$descri = $this->input->post('descri');
						$config['encrypt_name'] = TRUE;
					    $upload_data = array('upload_data' => $this->upload->data());
					    $img_url = $upload_data['upload_data']['file_name'];
						// if ($img_url == '') {
						// 	$img_url = 'noproduct.png';
						// }

					    $categorie = $this->input->post('category');
					    $price = $this->input->post('price');
					    $accs = $this->input->post('accs');
					    $tais = $this->input->post('tais');
					    if($this->PrestationsModel->editPrestation($name,$color,$categorie,$price,$img_url,$type,$imprimante,$unite,$idP,$descri)){
					    	if($this->PrestationsModel->deleteAccopaP($idP)){
					    		if (count($accs)>0) {
					    			foreach ($accs as $acc) {
								    	$this->PrestationsModel->insertAccopaP($acc,$idP);
								    }
					    		}
							    redirect('produits', 'refresh');
					    	}

					    }

				}
			}
	}

	public function ajouter(){
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 $this->load->view('login');
		}else{
			$config['upload_path'] = 'assets/uploads/';
			$config['allowed_types'] = 'gif|jpg|png|jpeg';
			$config['max_width'] = 0;
			$config['max_height'] = 0;
			$config['max_size'] = 0;
			$this->load->library('upload', $config);
			// if (!$this->upload->do_upload()) {
			//     $error = array('error' => $this->upload->display_errors());
			//     print_r(json_encode($error));
			// } else {   }
			    $this->upload->do_upload();
				$name = $this->input->post('name');
				$type = $this->input->post('type');
		        $qte = $this->input->post('qte');
		        $color = $this->input->post('color');
		        $unite = $this->input->post('unite');
		        $descri = $this->input->post('descri');
		        $imprimante = $this->input->post('imprimant');
				$config['encrypt_name'] = TRUE;
			    $upload_data = array('upload_data' => $this->upload->data());
			    $img_url = $upload_data['upload_data']['file_name'];
			    if ($img_url == '') {
			    	$img_url = 'noproduct.png';
			    }
			    $categorie = $this->input->post('category');
			    $price = $this->input->post('price');
			    $rationner = $this->input->post('rationner');
			    
			    $id = $this->PrestationsModel->addPrestations($name,$qte,$color,$categorie,$price,$img_url,$type,$imprimante,$unite,($rationner=='rationner') ? 1 : 0,$descri);
			    if($id > 0){
			    	if($this->LogsModel->insertLog('Creation','Prestations',$nomu.' a ajouter la Prestation id('.$id.')',$user_id)){
					    if($type == 0){
							echo '<div class="col-md-12"><table class="table table-striped"><thead><tr><th width="40%">Entrepôts</th><th width="30%">Quantité</th><th width="30%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>Stock</td><td><input type="number" id="quantityw" warehouse-id="1" value="0"></td><td><input type="number" id="price" value="" disabled="true"></td></tr></tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">';
						}elseif($type == 2){
							echo '<div class="form-group"><label for="add_cat">Produit</label><input type="text"  class="form-control input-lg" id="add_cat"></div><br><br><table id="Combocat" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-6">Categorie</th><th class=" col-xs-3 text-center">Taille</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody></tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">';

						}elseif($type == 1 || $type == 4 || $type == 7){
							echo '<div class="form-group"><label for="add_item">Produit</label><input type="text"  class="form-control" id="add_item"></div><br><br><br><table id="Comboprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-9">Produit</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody></tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">';
						}elseif($type == 5){
							$tailles = $this->input->post('taille');
							if (count($tailles)>0) {
								foreach ($tailles as $taille) {
									$Tais = $this->TaillesModel->getTaille($taille);
									foreach ($Tais as $Tai) {
										echo '<div class="input-group form-group">
			                					<span class="input-group-addon btn-lib" id="basic-addon1">'.$Tai['libelleTaille'].'</span>
			                					<input type="text" class="form-control add_size" data-id="'.$Tai['idTaille'].'" aria-describedby="basic-addon1"></div>';
									}
								}
								echo '<input type="hidden" id="prodctID" value="'.$id.'">';
			                    echo '<script type="text/javascript">$(".add_size").autocomplete({source: "Produits/suggestTailles",minLength: 1,autoFocus: false,delay: 200,select: function( event, ui ) {event.preventDefault();if (ui.item.id !== 0) {var row = add_taille($(this).data("id"),ui.item);if (row) {$(this).val(ui.item.name);$(this).css("color","#fff");$(this).css("background-color","#349b63");}} else {alert("pas de correspondance trouvée");return false;}},search: function( event, ui ) {$(this).css("color","#34495e");$(this).css("background-color","#fff");},response: function (event, ui) {if ($(this).val().length >= 16 && ui.content[0].id == 0) {alert("pas de correspondance trouvée");$(this).focus();$(this).val("");}else if (ui.content.length == 1 && ui.content[0].id != 0) {ui.item = ui.content[0];$(this).data("ui-autocomplete")._trigger("select", "autocompleteselect", ui);$(this).autocomplete("close");$(this).removeClass("ui-autocomplete-loading");}else if (ui.content.length == 1 && ui.content[0].id == 0) {alert("pas de correspondance trouvée");$(this).focus();$(this).val("");}}});function add_taille($idt,item, noitem) {if (item == null && noitem == null) {return false;}if(noitem != 1) {var item_id = 0;$.each(items, function(i){if(items[i].item_id == item.id) {items[i].quantity = (parseFloat(items[i].quantity) + 1);item_id = item.id;return false;}});if(item_id == 0) {item.qty = 1;vitems.push({"item_id": item.id,"taille": $idt,"code": item.code,"name": item.name});}}return true; }</script>';
							}
						}else if($type == 6 || $type == 8){

						}else if($type == 3){
							print json_encode(array('rationner'=>$rationner,'html'=>'<div class="form-group"><label for="add_rat">Rationnement</label><input type="text"  class="form-control" id="add_rat"></div><br><br><table id="Ratprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-9">Type Rationnement</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">'));
							//'<div class="form-group"><label for="add_rat">Rationnement</label><input type="text"  class="form-control" id="add_rat"></div><br><br><table id="Ratprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-9">Type Rationnement</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">'


						}
					 }
			    }
		}    
	}

	public function modifTailles($id){

		$Tais = $this->TaillesModel->getTailles();
		foreach ($Tais as $Tai) {
			echo '<div class="input-group form-group"><span class="input-group-addon btn-lib" id="basic-addon1">'.$Tai['libelleTaille'].'</span><input type="text" class="form-control add_size" data-id="'.$Tai['idTaille'].'" aria-describedby="basic-addon1"></div>';
		}
		echo '<input type="hidden" id="prodctID" value="'.$id.'">';
		echo '<script type="text/javascript">$(".add_size").autocomplete({source: "Produits/suggestTailles",minLength: 1,autoFocus: false,delay: 200,select: function( event, ui ) {event.preventDefault();if (ui.item.id !== 0) {var row = add_taille($(this).data("id"),ui.item);if (row) {$(this).val(ui.item.name);$(this).css("color","#fff");$(this).css("background-color","#349b63");}} else {alert("pas de correspondance trouvée");return false;}},search: function( event, ui ) {$(this).css("color","#34495e");$(this).css("background-color","#fff");},response: function (event, ui) {if ($(this).val().length >= 16 && ui.content[0].id == 0) {alert("pas de correspondance trouvée");$(this).focus();$(this).val("");}else if (ui.content.length == 1 && ui.content[0].id != 0) {ui.item = ui.content[0];$(this).data("ui-autocomplete")._trigger("select", "autocompleteselect", ui);$(this).autocomplete("close");$(this).removeClass("ui-autocomplete-loading");}else if (ui.content.length == 1 && ui.content[0].id == 0) {alert("pas de correspondance trouvée");$(this).focus();$(this).val("");}}});function add_taille($idt,item, noitem) {if (item == null && noitem == null) {return false;}if(noitem != 1) {var item_id = 0;$.each(items, function(i){if(items[i].item_id == item.id) {items[i].quantity = (parseFloat(items[i].quantity) + 1);item_id = item.id;return false;}});if(item_id == 0) {item.qty = 1;vitems.push({"item_id": item.id,"taille": $idt,"code": item.code,"name": item.name});}}return true; }</script>';
	}

    public function addTailles(){
    	$id = $this->input->post('productID');
		$items = $this->input->post('items');
		$this->PrestationsModel->removeTailleP($id,$items);
		foreach ($items as $item) {
			$this->PrestationsModel->addTaillePrestations($id,$item["taille"],$item["item_id"]);
		}
    }

    public function suggest(){
    	$term = $_GET['term']; 
    	$data = $this->PrestationsModel->getSPrestations($term); 
    	$villes = array();
        foreach ($data as $ville) : 
        $villes[] = array('id' => $ville['idPrestation'],'label' => $ville['libellePrestation'],'type' => $ville['idR'],'qte' => $ville['qte']);
         endforeach; 
        echo json_encode($villes);
    }

    public function suggestR(){
    	$term = $_GET['term']; 
    	$data = $this->PrestationsModel->getSPrestationsR($term); 
    	$villes = array();
        foreach ($data as $ville) : 
        $villes[] = array('id' => $ville['idPrestation'],'label' => $ville['libellePrestation'],'type' => $ville['idR'],'qte' => $ville['qte']);
         endforeach; 
        echo json_encode($villes);
    }

    public function suggestCategorie(){
    	$term = $this->input->post('term'); 
    	$id = $this->input->post('id'); 
    	$data = $this->PrestationsModel->getSFPrestations($term,$id); 
    	$villes = array();
        foreach ($data as $ville) : 
        $villes[] = array('id' => $ville['idPrestation'],'label' => $ville['libellePrestation'],'type' => $ville['idPrestation'],'qte' => $ville['qte']);
         endforeach; 
        echo json_encode($villes);
    }

    public function suggestTailles(){
    	$term = $_GET['term']; 
    	$data = $this->PrestationsModel->getTTPrestations($term); 
    	$villes = array();
        foreach ($data as $ville) : 
        $villes[] = array('id' => $ville['idPrestation'],'label' => $ville['libellePrestation'],'name' => $ville['libellePrestation'],'code' => $ville['idPrestation'],'cost' => $ville['prix']);
         endforeach; 
        echo json_encode($villes);
    }

    public function addcombo($id){

    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{
			$items = $this->input->post('items');
			$result = $this->PrestationsModel->updateComboPrestations($id,$items);
			if($result == 'Success'){
				if($this->LogsModel->insertLog('Modification','Prestations',$nomu.' a modifier la combinaison de Prestation id('.$id.')',$user_id)){
                     echo 'Success';
				}
			}else if($result == 'error'){
                echo 'error';
			}
		}
    }

    public function addformule(){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{

			$id = $this->input->post('productID');
			$items = $this->input->post('items');
			if (count($items)>0) {
				if(!$this->CategoriesModel->addFormCategorie($id,$items)){
		            echo 'error';
				}else{
					echo $this->LogsModel->insertLog('Modification','Prestations',$nomu.' a modifier la formule de Prestation id('.$id.')',$user_id);
				}
					
			}
		}
    }

    public function modifyStock($idProduit){
		$produit = $this->PrestationsModel->getPrestation($idProduit);
		$rations = $this->PrestationsModel->getRations($idProduit);
		echo '<h3 class="text-center" style="font-weight: 800!important;text-transform: uppercase;">'.$produit[0]['libellePrestation'].' ('.$produit[0]['idPrestation'].')</h3>';
		if($produit[0]['isRationner']){
			
			 // if (count($last)>0) {
				// echo'<table class="table table-striped" width="100%"><thead><tr><th width="40%">Ingredians</th><th width="20%">Qte</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].' (<span class="text-danger">'.$last[0]['dateCreation'].'</span>) </td><td><input id="quantity" min="1" value="'.$last[0]['qte'].'"  step="0.01" data-fix="'.$last[0]['idStock'].'" type="number" disabled> '.$produit[0]['symboleUnite'].'</td><td><input id="prix" min="1" value="'.$last[0]['prix'].'"  step="1"  type="number" disabled> MAD</td></tr>';
			 // }else{
			 echo'<table class="table table-striped" width="100%"><thead><tr><th width="30%">Ingredians</th><th width="20%">Qte</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].'</td><td><input style="width:70%;" id="quantity" min="1" value="0" data-fix="0" step="0.01" type="number"> '.$produit[0]['symboleUnite'].'</td><td><input id="prix"style="width:70%; min="1" value="0" step="1" type="number"> MAD</td></tr>';
			 // }
			 
            if (count($rations)>0) {
				echo '<tr  colspan="2"><td colspan="2"></br></br></br></td></tr></thead><tbody class="ratslist">';
	            foreach ($rations as $ration) {
	            	echo '<tr><td colspan="2">'.$ration['libelleRationnement'].' ('.$ration['qteRation'].' '.$produit[0]['symboleUnite'].')</td><td colspan="2"><input id="rat-'.$ration['idRationnement'].'" min="1" value="0" step="1" type="number" class="pull-right"></td></tr>';
	            }
	            echo '</tbody>';
            }
           echo'</tbody></table><input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
		}else{
			if($produit[0]['idTypePrestation'] == 7){
				echo'<table class="table table-striped" width="100%"><thead><tr><th width="60%">Produit</th><th width="40%">Quantite</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].'</td><td><input id="quantity" min="1" value="0"  step="0.01" data-fix="0" type="number"> '.$produit[0]['symboleUnite'].'</td></tr> </tbody></table><input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
			}else{
				echo'<table class="table table-striped" width="100%"><thead><tr><th width="30%">Produit</th><th width="20%">Qte</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].'</td><td><input id="quantity" min="1" value="0"  step="0.01" data-fix="0" type="number"> '.$produit[0]['symboleUnite'].'</td><td><input id="prix" min="1" value="0"  step="1" data-fix="0" type="number"> MAD</td></tr> </tbody></table><input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
			}
			echo '<input id="idtype" value="'.$produit[0]['idTypePrestation'].'" type="hidden">';
		}
    }


    public function modifyinv($id){
		$produit = $this->PrestationsModel->getShowPrestation($id);
		if ($produit[0]['isRationner'] > 0) {
			$rations = $this->PrestationsModel->getRations($id);
			$ivens = $this->PrestationsModel->getInventaires($id);
			if (count($rations)>0) {
				echo '<div  id="inventa" >';
				foreach ($rations as $ration) {
					echo '<div class="form-group "><label for="inven">Quantite Reel ('.$ration['libelleRationnement'].')</label><input id="inven" data-id="'.$ration['idRationnement'].'" name="inven[]" class="form-control add_size input-lg invv" type="number" ></div>';
					echo'<input id="prodctID" value="'.$ration['idRationnement'].'" type="hidden">';
				}
				echo '</div>';	
				if (count($ivens)>0) {
			        echo '<div class="row"><div class="col-md-12"><h1>Archive</h1></div><div class="col-md-12"><table class="table  table-striped table-hover"><thead><tr><th class="col-xs-6">Libelle</th><th class="col-xs-3  text-center">Quantite Reel</th><th class="col-xs-3 text-center">Quantite Theorique</th></tr></thead><tbody>';        
				    foreach ($ivens as $iven) {
				        echo '<tr><td>'.$iven['libelleRationnement'].' ('.$iven['dateCreation'].')</td><td class="text-center"><b>'.$iven['qteReel'].' '.$produit[0]['symboleUnite'].'</b></td><td class="text-center">'.$iven['qteAuto'].' '.$produit[0]['symboleUnite'].'</td></td></tr>';
				    }
				    echo '</tbody></table></div></div>';
		        }
			}	
		}else{
			$ivens = $this->PrestationsModel->getInventaires($id);
			echo '<div  id="inventa" >';
			echo '<div id="inventa" class="form-group"><label for="inven">Quantite Reel</label><input id="inven" name="inven[]" class="form-control add_size input-lg invv" data-id="0" type="number" ></div>';
			echo'<input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
			echo '</div>';
			if (count($ivens)>0) {
		        echo '<div class="row"><div class="col-md-12"><h1>Archive</h1></div><div class="col-md-12"><table class="table  table-striped table-hover"><thead><tr><th class="col-xs-6">Libelle</th><th class="col-xs-3  text-center">Quantite Reel</th><th class="col-xs-3 text-center">Quantite Theorique</th></tr></thead><tbody>';        
			    foreach ($ivens as $iven) {
			        echo '<tr><td>'.$produit[0]['libellePrestation'].' ('.$iven['dateCreation'].')</td><td class="text-center"><b>'.$iven['qteReel'].' '.$produit[0]['symboleUnite'].'</b></td><td class="text-center">'.$iven['qteAuto'].' '.$produit[0]['symboleUnite'].'</td></td></tr>';
			    }
			    echo '</tbody></table></div></div>';
	        }
		}
    }

    public function Viewproduct($id){
		$produit = $this->PrestationsModel->getShowPrestation($id);
		$societe = $this->SocieteModel->getSociete();
		if ($produit[0]['idTypePrestation'] == 1 || $produit[0]['idTypePrestation'] == 4 || $produit[0]['idTypePrestation'] == 2 || $produit[0]['idTypePrestation'] == 7){
			$combinaisons = $this->PrestationsModel->getCombo($id);
		}else if($produit[0]['idTypePrestation'] == 5){
			$combinaisons = $this->PrestationsModel->getTailles($id);
			//var_dump($combinaisons);
		}
    	echo '<div class="col-md-6"><div class="media"><div class="media-left"><img class="media-object img-rounded" src="'.base_url().'assets/uploads/'.$produit[0]['image'].'" alt="image" width="200px"></div><div class="media-body"><h1 class="media-heading">'.$produit[0]['libellePrestation'].'</h1>';
		if ($produit[0]['idTypePrestation'] != 3) {
			echo '<b>Categorie :</b> '.$produit[0]['libelleCategorie'].' <br><b>Tax (%) :</b> '.$societe[0]['tax'].'% inclue <br><b>Prix :</b> '.$produit[0]['prix'].' MAD<br></div></div></div><div class="col-md-6">';
		}else{
			echo '<b></b><br><b></b><br><b></b><br></div></div></div><div class="col-md-6">';
		}
        if ($produit[0]['idTypePrestation'] == 1 || $produit[0]['idTypePrestation'] == 4 || $produit[0]['idTypePrestation'] == 7){ 
        	echo '<table class="table"><thead><tr><th width="40%">Produit</th><th width="20%">Qte</th></tr></thead><tbody class="itemslist">';
        	if (count($combinaisons)>0) {
          	foreach ($combinaisons as $combinaison) {
	          		if($combinaison['idRatio'] > 0){
	                	$ratio = $this->PrestationsModel->getRation($combinaison['idRatio']);
	                	if (count($ratio)>0) {
	                		echo '<tr><td>'.$ratio[0]['libelleRationnement'].'</td><td><b>'.$ratio[0]['qte'].'</b></td></tr>';
	                	}
	                }else{
	                	echo '<tr><td>'.$combinaison['pp'].'</td><td><b>'.$combinaison['qtep'].' '.$combinaison['sym'].'</b></td></tr>';
	                }
          			
          		}

          	}
        }else if($produit[0]['idTypePrestation'] == 2){
            echo '<table class="table"><thead><tr><th width="40%">Categorie</th><th width="20%">Qte</th></tr></thead><tbody class="itemslist">';
            $categories = $this->CategoriesModel->getFormuleCategories($id);
          	foreach ($categories as $categorie) {
                	echo '<tr><td>'.$categorie['libelleCategorie'].'</td><td><b>'.$categorie['qte'] .'</b></td></tr>';
          	}


        }else if($produit[0]['idTypePrestation'] == 5){
        	echo '<table class="table"><thead><tr><th width="40%">Ingredients</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist">';
        	foreach ($combinaisons as $combinaison) {
          		echo '<tr><td>'.$combinaison['pp'].'</td><td><b>'.$combinaison['prixp'].' MAD</b></td></tr>';
          	}
        }else{
        	echo '<table class="table"><thead><tr><th width="40%">Stock</th><th width="20%" class="text-center">Qte</th></tr></thead><tbody class="itemslist">';
        	if ($produit[0]['isRationner']) {
                $rations = $this->PrestationsModel->getRations($produit[0]['idPrestation']);
        		foreach ($rations as $ration) {
        			echo '<tr><td>'.$ration['libelleRationnement'].' ('.$ration['qteRation'].$produit[0]['symboleUnite'].')</td><td class="text-center"><b>'.$ration['qte'].'</b></td></tr>';
        		}
        	}else{
        		echo '<tr><td>'.$produit[0]['libellePrestation'].'</td><td class="text-center"><b>'.$produit[0]['qte'].'</b></td></tr>';
        	}
          	
        }
        echo '</tbody></table></div>';
        if ($produit[0]['idTypePrestation'] == 1 || $produit[0]['idTypePrestation'] == 4 || $produit[0]['idTypePrestation'] == 7){
	      	echo '<div class="row"><div class="col-md-12"><h1>Combinations</h1></div><div class="col-md-12"><table class="table"><thead><tr><th class="col-xs-9">Libelle</th><th class="col-xs-2  text-center">Quantite</th></tr></thead><tbody>';
	      	foreach ($combinaisons as $combinaison) {
	      		if($combinaison['idRatio'] > 0){
                	$ratio = $this->PrestationsModel->getRation($combinaison['idRatio']);
                	if (count($ratio)>0) {
                		echo ' <tr><td><a href="javascript:void(0)" onclick="modifystock('.$combinaison['idp'].')">'.$ratio[0]['libelleRationnement'].' ('.$ratio[0]['qteRation'].$combinaison['sym'].')</a></td><td class="text-center"><b>'.$combinaison['qtec'].'</b></td></tr>';
                	}

                }else{
                	echo ' <tr><td><a href="javascript:void(0)" onclick="modifystock('.$combinaison['idp'].')">'.$combinaison['pp'].'</a></td><td class="text-center"><b>'.$combinaison['qtec'].' '.$combinaison['sym'].'</b></td></tr>';
                }
	      	}
        	echo '</tbody></table></div></div><button type="submit" class="btn btn-add col-md-12" style="margin-bottom:0" onclick="modifycombo('.$id.')">Modifier Combinaisons</button>';
        }else if($produit[0]['idTypePrestation'] == 5){
        	echo '<div class="row"><div class="col-md-12"><h1>Tailles</h1></div><div class="col-md-12"><table class="table"><thead><tr><th class="col-xs-9">Libelle</th><th class="col-xs-2 text-center">Prix</th></tr></thead><tbody>';
	      	foreach ($combinaisons as $combinaison) {
	           echo ' <tr><td><a href="javascript:void(0)" onclick="modifystock('.$combinaison['idp'].')">'.$combinaison['pp'].'</a></td><td class="text-center"><b>'.$combinaison['prixp'].' MAD</b></td></tr>';
	      	}
        	echo '</tbody></table></div></div><button type="submit" class="btn btn-add col-md-12" style="margin-bottom:0" onclick="modifyTaille('.$id.')">Modifier Tailles</button>';
        }else if($produit[0]['idTypePrestation'] == 3 || $produit[0]['idTypePrestation'] == 0){
        	$stocks = $this->PrestationsModel->getLastStock($produit[0]['idPrestation']);
        	if (count($stocks)>0) {
	        	echo '<div class="row"><div class="col-md-12"><h1>Entrees Stock</h1></div><div class="col-md-12"><table class="table  table-striped table-hover"><thead><tr><th class="col-xs-6">Libelle</th><th class="col-xs-2  text-center">Quantite</th><th class="col-xs-2  text-center">Prix</th><th class="col-xs-2  text-center">Actions</th></tr></thead><tbody>';
		      	foreach ($stocks as $stock) {
		           echo ' <tr><td>'.$produit[0]['libellePrestation'].' ('.$stock['dateCreation'].')</td><td class="text-center"><b>'.$stock['qte'].' '.$produit[0]['symboleUnite'].'</b></td><td class="text-center">'.$stock['prix'].' MAD</td></td><td  class="text-center"><a class="btn btn-default" href="javascript:void(0)" onclick="modstock('.$stock['idStock'].','.$produit[0]['idPrestation'].')"><i class="fa fa-sliders-h" data-toggle="tooltip" data-placement="top"  title="Modifier Stock"></i></a></td></tr>';
		      	}
				echo '</tbody></table></div></div>';

        	}

        }else if($produit[0]['idTypePrestation'] == 2){
        	$categories = $this->CategoriesModel->getFormuleCategories($id);
	      	echo '<div class="row"><div class="col-md-12"><h1>Categories</h1></div><div class="col-md-12"><table class="table"><thead><tr><th class="col-xs-9">Libelle</th><th class="col-xs-2  text-center">Quantite</th></tr></thead><tbody>';
	      	foreach ($categories as $categorie) {
                	echo ' <tr><td><a href="javascript:void(0)" >'.$categorie['libelleCategorie'].'</a></td><td class="text-center"><b>'.$categorie['qte'] .'</b></td></tr>';
	      	}
        	echo '</tbody></table></div></div><button type="submit" class="btn btn-add col-md-12" style="margin-bottom:0" onclick="modifyformule('.$id.')">Modifier Formule</button>';

        }
        if ($produit[0]['isRationner']) {
			echo '<button type="submit" class="btn btn-add col-md-12" style="margin-bottom:0" onclick="modifyRas('.$id.')">Modifier Rations</button>';
        }
    }


    public function modStock($id,$idp){
		$produit = $this->PrestationsModel->getPrestation($idp);
		$rations = $this->PrestationsModel->getRations($idp);
		$last = $this->PrestationsModel->getSS($id);
		// echo '<h3 class="text-center" style="font-weight: 800!important;text-transform: uppercase;">'.$produit[0]['libellePrestation'].' ('.$produit[0]['idPrestation'].')</h3>';
		if($produit[0]['isRationner']){
			
			echo'<table class="table table-striped" width="100%"><thead><tr><th width="40%">Ingredians</th><th width="20%">Qte</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].' (<span class="text-danger">'.$last[0]['dateCreation'].'</span>) </td><td><input id="quantity" min="1" value="'.$last[0]['qte'].'"  step="0.01" data-fix="'.$last[0]['idStock'].'" type="number" disabled> '.$produit[0]['symboleUnite'].'</td><td>';
			if ($last[0]['prix']>0) {
				'<input id="prix" min="1" value="'.$last[0]['prix'].'"  step="1"  type="number" disabled> MAD</td></tr>';
			}else{'<input id="prix" min="1" value="'.$last[0]['prix'].'"  step="1"  type="number" > MAD</td></tr>';

			}


			
			 
            if (count($rations)>0) {
            	if($last[0]['isRationner']){
	            	echo '<tr  colspan="2"><td colspan="2"></br></br></br></td></tr></thead><tbody class="ratslist">';
		            foreach ($rations as $ration) {
		            	$lastRatio = $this->PrestationsModel->getSSS($id,$ration['idRationnement']);
		            	if(count($lastRatio)>0){
		            		echo '<tr><td colspan="2">'.$ration['libelleRationnement'].' ('.$ration['qteRation'].' '.$produit[0]['symboleUnite'].')</td><td colspan="2"><input id="rat-'.$ration['idRationnement'].'" min="1" value="'.$lastRatio[0]['qte'].'" type="number" disabled class="pull-right"></td></tr>';
		            	}
		            }
		            echo '</tbody>';
            	}else{
	            	echo '<tr  colspan="2"><td colspan="2"></br></br></br></td></tr></thead><tbody class="ratslist">';
		            foreach ($rations as $ration) {
		            	echo '<tr><td colspan="2">'.$ration['libelleRationnement'].' ('.$ration['qteRation'].' '.$produit[0]['symboleUnite'].')</td><td colspan="2"><input id="rat-'.$ration['idRationnement'].'" min="1" value="0" step="1" type="number" class="pull-right"></td></tr>';
		            }
		            echo '</tbody>';
            	}

            }
           echo'</tbody></table><input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
		}else{
			echo'<table class="table table-striped" width="100%"><thead><tr><th width="40%">Produit</th><th width="20%">Qte</th><th width="20%">Prix</th></tr></thead><tbody class="itemslist"><tr><td>'.$produit[0]['libellePrestation'].' (<span class="text-danger">'.$last[0]['dateCreation'].'</span>) </td><td><input id="quantity" min="1" value="'.$last[0]['qte'].'" style="width:70%" step="0.01" data-fix="'.$last[0]['idStock'].'" type="number" disabled> '.$produit[0]['symboleUnite'].'</td><td><input id="prix" min="1" value="'.$last[0]['prix'].'"  step="1"  style="width:70%" type="number" disabled> MAD</td></tr></tbody></table><input id="prodctID" value="'.$produit[0]['idPrestation'].'" type="hidden">';
		}
    }
    

	public function modifycombo(){
	    $user_id = $this->session->userdata('idUtilisateur');
	    $nomu = $this->session->userdata('nomUtilisateur');
	    if(!$user_id){
				echo 'LogOut';
		}else{
				$id = $this->input->post('id');
				$combos = $this->PrestationsModel->getCombo($id);
				$html = '<div class="form-group"><label for="add_item">Produit</label><input type="text"  class="form-control" id="add_item"></div><br><br><table id="Comboprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-9">Produit</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody>';
				foreach ($combos as $combo) {
					if($combo['idRatio'] == 0){
						$html .= '<tr id="rowid_'.$combo['idp'].'" class="item_'.$combo['idp'].'"><td>'.$combo['pp'].'('.$combo['idp'].')</td><td><input class="form-control text-center" name="quantity" type="text" value="'.$combo['qtec'].'" id="quantit"  onkeyup="qteCom(this,'.$combo['idp'].');"></td><td class="text-center"><div class="btn-group"><a id="'.$combo['idp'].'" class="btn btn-default deltCo" href="javascript:void(0)"><i class="fa fa-trash-alt"></i></a></div></td></tr>';
					}else{
						$html .= '<tr id="rowid_'.$combo['idp'].'" class="item_'.$combo['idp'].'"><td>'.$combo['libelleRationnement'].'('.$combo['idp'].')</td><td><input class="form-control text-center" name="quantity" type="text" value="'.$combo['qtec'].'" id="quantit"  onkeyup="qteCom(this,'.$combo['idp'].');"></td><td class="text-center"><div class="btn-group"><a id="'.$combo['idp'].'" class="btn btn-default deltCo" href="javascript:void(0)"><i class="fa fa-trash-alt"></i></a></div></td></tr>';
					}
					
				}
                $html .= '</tbody></table>';
                $html .= '<input type="hidden" id="prodctID" value="'.$id.'">';
				print json_encode(array("combos"=>$combos,"html"=>$html));

		}
	}


	public function modifyformule($id){
	    $user_id = $this->session->userdata('idUtilisateur');
	    $nomu = $this->session->userdata('nomUtilisateur');
	    if(!$user_id){
				 $this->load->view('login');
		}else{
				$id = $this->input->post('id');
				$tailles = $this->TaillesModel->getTailles();
				$categories = $this->CategoriesModel->getFormuleCategories($id);
				$html = '<div class="form-group"><label for="add_cat">Produit</label><input type="text"  class="form-control input-lg" id="add_cat"></div><br><br><table id="Combocat" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-6">Categorie</th><th class=" col-xs-3 text-center">Taille</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody>';
				foreach ($categories as $categorie) {
					$html .= '<tr id="rowid_'.$categorie['idCategorie'].'" class="item_'.$categorie['idCategorie'].'">

					<td>'.$categorie['libelleCategorie'].'('.$categorie['idCategorie'].')</td>

					<td><select class="form-control text-center" onchange="tailleCat(this,'.$categorie['idCategorie'].')">

					<option  id="0" ';
						if ($categorie['idTaille'] == 0) {
							$html .= ' selected ';
						}
					$html .= '>toutes les tailles</option>';

					foreach ($tailles as $taille) {
						$html .= '<option id="'.$taille['idTaille'].'" ';
						if ($taille['idTaille'] == $categorie['idTaille']) {
							$html .= ' selected ';
						}
						$html .= ' >'.$taille['libelleTaille'].'</option>';
					}

					$html .= '<select></td>

					<td><input class="form-control text-center" name="quantity" type="text" value="'.$categorie['qte'].'" id="quantitcat" onkeyup="qteCat(this,'.$categorie['idCategorie'].');"></td>

				
					<td class="text-center"><div class="btn-group"><a id="'.$categorie['idCategorie'].'" class="btn btn-default deltCat" href="javascript:void(0)"><i class="fa fa-trash-alt"></i></a></div></td></tr>';
				}
                $html .= '</tbody></table>';
                $html .= '<input type="hidden" id="prodctID" value="'.$id.'">';
				print json_encode(array("cats"=>$categories,"html"=>$html));

		}
	}

  	public function updatestock(){

      	$user_id = $this->session->userdata('idUtilisateur');
      	$nomu = $this->session->userdata('nomUtilisateur');

		if(!$user_id){
			 echo'LogOut';
		}else{
		  	$id = $this->input->post('id');
			$qte = $this->input->post('qte');
			$fix = $this->input->post('fix');
			$prix = $this->input->post('prix');
			$rationnee = $this->input->post('ratione');
			
			if ($fix == 0) {
				
				if ($qte>0) {
					
					if ($rationnee == 1) {
						
						$lid = $this->PrestationsModel->stockPrestation($id,$qte,0,$prix,1,$user_id);
					}else{
						$lid = $this->PrestationsModel->stockPrestation($id,$qte,0,$prix,0,$user_id);
					}
					if($lid>0){
						if ($rationnee == 1) {
							$items = $this->input->post('items');
							if (count($items)>0) {
								foreach ($items as $item) {
									if ($item['libelle'] > 0) {
										$this->PrestationsModel->updateRationnement($item['id'],$item['libelle'],$lid);
									}	
								}
							}	
						}
					   if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
					   		echo true;
					   }
					}
				}




			}else{
				if ($rationnee == 1) {
					$items = $this->input->post('items');
					if (count($items)>0) {
						foreach ($items as $item) {
							if ($item['libelle'] > 0) {
								$this->PrestationsModel->updateRationnement($item['id'],$item['libelle'],$fix);
							}	
						}
					}
				}
				if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
							echo true;
					   }
			}
		}
  	}
  
    public function addRatio($id){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{
			$items = $this->input->post('items');
			$result = $this->PrestationsModel->updateRatioPrestations($id,$items);
			if($result['result'] == 'Success'){
				if($this->LogsModel->insertLog('Modification','Prestations',$nomu.' a modifier la ration de Prestation id('.$id.')',$user_id)){
                     echo 'Success';
				}
			}else if($result['result'] == 'Block'){
				echo $result['list'];
			}else{
				echo 'error';
			}
		}
    }

    public function updateInv($id){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');

		if(!$user_id){
			 print json_encode(array('result'=>'LogOut'));
		}else{

			$results = array();
			$items = $this->input->post('items');
			if (count($items)>0) {
				foreach ($items as $item) {
					$qte = $item['qte'];
			        $justification = $item['justification'];
			        $just = $item['just'];
			        $ratio = $item['idRation'];
			        $data = $this->PrestationsModel->addInventaire($id,$qte,$justification,$just,$user_id,$ratio);
			    	if($data['qteReel']!= $data['qteAuto']){
						array_push($results,array('qte'=>$data['qteReel'],'qteAuto'=>$data['qteAuto'],'id'=>$id,'idRation'=>$data['idRation'],'libelle'=>$data['libelle'],'idPrestation'=>$data['idPrestation']));
					}
				}
			}
			//print_r($results);
			if (count($results)>0) {
				print json_encode(array('result'=>'just','inventaires'=>$results));
			}else{
                print json_encode(array('result'=>'close'));
			}

		}
    }

    public function setDisponibilite($id,$dispo){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{
			if ($dispo == 1) {
				echo $this->PrestationsModel->indisponible($id);
			}else{
				echo $this->PrestationsModel->disponible($id);
			}

		}

    }


    public function blockListFormule($id){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{
		$blacks = $this->PrestationsModel->getBBB($id);
         $html = '<div class="form-group"><label for="add_block">Produit</label><input type="text"  class="form-control input-lg" id="add_block"></div><br><br><table id="Blockl" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-10">Produit</th><th class=" col-xs-2 text-center">Actions</th></tr></thead><tbody>';

        foreach ($blacks as $black) {
		    $html .= '<tr id="rowid_'.$black['idp'].'" class="item_'.$black['idp'].'"><td>'.$black['pp'].'('.$black['idp'].')</td><td class="text-center"><div class="btn-group"><a id="'.$black['idp'].'" class="btn btn-default delt" href="javascript:void(0)"><i class="fa fa-trash-alt"></i></a></div></td></tr>';
		}
        $html .= '</tbody></table>';
        $html .= '<input type="hidden" id="prodctID" value="'.$id.'">';



			print json_encode(array('html'=>$html,'blacks'=>$blacks));


		}

    }

    public function addBlock(){

    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 echo'LogOut';
		}else{

			$id = $this->input->post('productID');
			$items = $this->input->post('items');
			$this->PrestationsModel->removeBList($id,$items);
			foreach ($items as $item) {
				$this->PrestationsModel->addBList($id,$item["item_id"]);
			}
			echo true;
		}
    }


    public function modifRation($id){
    	$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			 print json_encode(array('html'=>'LogOut'));
		}else{
			$html = '';
			$rations = $this->PrestationsModel->getRations($id);
            $produit = $this->PrestationsModel->getPrestation($id);
			//$html .=  '<div class="form-group"><label for="add_rat">Type Rationnement</label><div class="input-group"><input type="text" class="form-control" id="add_rat"><span class="input-group-btn"><button class="btn btn-primary" type="button" id="addR">Ajouter</button></span></div><br><br><br><table id="Ratprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-8">Type Rationnement</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-2 text-center">Actions</th></tr></thead><tbody>';

			$html .= '<div class="form-group"><label for="add_rat">Rationnement</label><input type="text"  class="form-control" id="add_rat"></div><br><br><table id="Ratprd" class="table items table-striped table-bordered table-condensed table-hover"><thead><tr><th class="col-xs-9">Type Rationnement</th><th class="col-xs-2 text-center">Qte</th><th class=" col-xs-1 text-center">Actions</th></tr></thead><tbody>';
			if (count($rations)>0) {
				foreach ($rations as $ration) {


					$html .=  '<tr id="rowid_'.$ration['idPrestaRation'].'" class="item_'.$ration['idPrestaRation'].'"><td>'.$ration['libelleRationnement'].'</td><td><input class="form-control text-center" name="qte" type="text" value="'.$ration['qteRation'].'" item-id="'.$ration['idPrestaRation'].'" id="qte"  onkeyup="qteRat(this,';
					$html .= "'".$ration['idPrestaRation']."'";
					$html .= ');"></td><td class="text-center"><div class="btn-group"><a id="'.$ration['idPrestaRation'].'" class="btn btn-default deltR" href="javascript:void(0)"><i class="fa fa-trash-alt"></i></a></div></td></tr>';
					
				}
			}

			$html .= '</tbody></table></div><input type="hidden" id="prodctID" value="'.$id.'">';
			print json_encode(array('html'=>$html ,'rations'=>$rations));


		}


    }


    public function inventJust($id){

    	$items = $this->input->post('items');
    	echo   '<div class="just panel panel-default">';
    	foreach ($items as $item) {
            echo   '<div class="panel-heading" style="background-color: #0d47a1;color: #fff"><h2 class="panel-title text-center">'.$item['libelle'].'  ( Quantité Theorique : '.$item['qteAuto'].')</h2></div>
    					<div class="panel-body"><div class="form-group">
    						<label class="col-md-12 control-label" for="IsSmallBusiness" style="padding-left: 0px;">Justification </label>
    						<div class="col-md-12 text-center">
    							<label class="radio-inline">
    								<input checked="checked" name="justi'.$item['idRation'].'" type="radio" value="1">Brulee
    							</label>
    							<label class="radio-inline">
    								<input name="justi'.$item['idRation'].'" type="radio" value="4">Cassee
    							</label>
    							<label class="radio-inline">
    								<input name="justi'.$item['idRation'].'" type="radio" value="2">Erreur humaine
    							</label>
    							<label class="radio-inline">
    								<input name="justi'.$item['idRation'].'" type="radio" value="3">Autres
    							</label>
    						</div>
    					</div>
    					<div class="col-md-12"><br>
    						<textarea class="form-control justfi" name="just'.$item['idRation'].'"></textarea>
    					</div></div>';
    				
    	}
		echo '</div></div>';
    }



    public function updatestockC(){

      	$user_id = $this->session->userdata('idUtilisateur');
      	$nomu = $this->session->userdata('nomUtilisateur');

		if(!$user_id){
			 echo'LogOut';
		}else{
		  	$id = $this->input->post('id');
			$qte = $this->input->post('qte');
			$fix = $this->input->post('fix');
			$prix = $this->input->post('prix');
			$rationnee = $this->input->post('ratione');
            $result = $this->PrestationsModel->updateStockC($id,$qte,$user_id);
            if($result === 'Stock'){
                echo 'Stock';
            }else if($result){
				if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
					echo true;
				}
            }
			






			
		/*	if ($fix == 0) {
				
				if ($qte>0) {
					
					if ($rationnee == 1) {
						
						$lid = $this->PrestationsModel->stockPrestation($id,$qte,0,$prix,1,$user_id);
					}else{
						$lid = $this->PrestationsModel->stockPrestation($id,$qte,0,$prix,0,$user_id);
					}
					if($lid>0){
						if ($rationnee == 1) {
							$items = $this->input->post('items');
							if (count($items)>0) {
								foreach ($items as $item) {
									if ($item['libelle'] > 0) {
										$this->PrestationsModel->updateRationnement($item['id'],$item['libelle'],$lid);
									}	
								}
							}	
						}
					   if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
					   		echo true;
					   }
					}
				}




			}else{
				if ($rationnee == 1) {
					$items = $this->input->post('items');
					if (count($items)>0) {
						foreach ($items as $item) {
							if ($item['libelle'] > 0) {
								$this->PrestationsModel->updateRationnement($item['id'],$item['libelle'],$fix);
							}	
						}
					}
				}
				if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
							echo true;
			    }
			}*/







		}

    }
    









  	public function updatestockMOBILE($user_id,$nomu,$id,$qte,$prix,$ratio){
			
		$lid = $this->PrestationsModel->stockPrestation($id,$qte,$ratio,$prix,0,$user_id);
		if($lid>0){

				if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier quantite en stock de Prestation id('.$id.') par ajouter '.$qte,$user_id)){
					$prestations = $this->PrestationsModel->getStockPrestationT($id);
					$imprimantes = $this->ImprimantesModel->getImprimantes();
					$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
					$combinaisons = $this->PrestationsModel->getCombo($id);
					$Accomps = $this->AccompagnementsModel->getAccompagnements();
					print json_encode(array('status'=>true,'prestation'=>$prestations,'imprimantes'=>$imprimantes,'attributs'=>$Accomps,'combinaisons'=>$combinaisons));
			}
		}
  	}


  	public function updateInvMOBILE($user_id,$id,$qte,$justification,$ratio){

        $results = array();
		$just = $this->input->post('justification');
		$nomu = $this->input->post('nomu');
		$data = $this->PrestationsModel->addInventaire($id,$qte,$justification,$just,$user_id,$ratio);
	    if($data['qteReel']!= $data['qteAuto']){
	    	array_push($results,array('result'=>'just','qte'=>$data['qteReel'],'qteAuto'=>$data['qteAuto'],'id'=>$id,'idRation'=>$data['idRation'],'libelle'=>$data['libelle'],'idPrestation'=>$data['idPrestation']));
		}
		$prestations = $this->PrestationsModel->getPrestationMOBILE($id);
		if (count($results)>0) {
			print json_encode(array('result'=>'just','qte'=>$data['qteReel'],'qteAuto'=>$data['qteAuto'],'id'=>$id,'idRation'=>$data['idRation'],'libelle'=>$data['libelle'],'idPrestation'=>$data['idPrestation'],'prestation'=>$prestations));
		}else{
            print json_encode(array('result'=>'close','prestation'=>$prestations));
		}
    }


    public function getPrestationsN(){
		$prestations = $this->PrestationsModel->getStockPrestationN();
		print json_encode(array('prestations'=>$prestations));
	}

	public function getInventairesMOBILE($id){
		$ivens = $this->PrestationsModel->getInventaires($id);
		print json_encode(array('inventaires'=>$ivens));
	}

	public function getStocksMOBILE($id){
		$stocks = $this->PrestationsModel->getLastStockM($id);
		print json_encode(array('stocks'=>$stocks));
	}


	public function setStockRMOBILE($user_id,$nomu,$idp){
		$items = $this->input->post('items');
		$items = json_decode(trim(file_get_contents('php://input')), true);
		if (count($items)>0) {
			foreach ($items as $item) {
				$this->PrestationsModel->updateRationnement($item['id'],$item['qte'],$item['idS']);
				if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a determiner quantite en stock de Ration id('.$item['id'].')',$user_id)){
					$stocks = $this->PrestationsModel->getLastStockM($idp);
		            print json_encode(array('stocks'=>$stocks));
		        }
			}
		}	
	}

	public function updatepstockMOBILE($user_id,$nomu,$id,$prix,$idp){
		$result = $this->PrestationsModel->stockMPPrestation($id,$prix);
		if($result){
			if($this->LogsModel->insertLog('Modification','Stock',$nomu.' a modifier prix dune entree stock de Prestation id('.$id.')',$user_id)){
				 $stocks = $this->PrestationsModel->getLastStockM($idp);
		         print json_encode(array('stocks'=>$stocks));

			}
		}


	}

	






}
?>