<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Reglements extends CI_Controller
{

	public function index(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Reglements';
			$header['page'] = 'reglements';
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['banques'] = $this->ArticlesModel->getBanques();
			//$data['reglements'] = $this->FacturesModel->getReglements();
			$this->load->view('templates/header',$header);
			$this->load->view('reglements',$data);
			$this->load->view('templates/footer');

		}

	}

	public function fournisseurs(){

		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Reglements Fournisseur';
			$header['page'] = 'reglementsf';
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['banques'] = $this->ArticlesModel->getBanques();
			//$data['reglements'] = $this->FacturesModel->getReglements();
			$this->load->view('templates/header',$header);
			$this->load->view('reglementsF',$data);
			$this->load->view('templates/footer');

		}

	}

	  public function reglerFactures(){

      $user_id = $this->session->userdata('idUtilisateur');
      $nomu = $this->session->userdata('nomUtilisateur');
      if(!$user_id){
        $output = json_encode(array("session"=>false));
        $this->output->set_content_type('application/json');
        $this->output->set_output($output);
      }else{

        $json = $this->input->post('json');

        if($this->FacturesModel->reglerFactures($json,$user_id)){
          $output = json_encode(array("result"=>true,"session"=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }else{

          $output = json_encode(array("result"=>false,"session"=>true));
          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
      }
    }

	public function addReglement(){
		
		$user_id = $this->session->userdata('idUtilisateur');
		$nomu = $this->session->userdata('nomUtilisateur');
		if(!$user_id){
			  $this->load->view('login');
		}else{
			
			$header['title'] = 'Gestion Commercial - Gestion Reglements';
			$header['page'] = 'reglements';
			$data['modesPaiement'] = $this->ArticlesModel->getModesPaiements();
			$data['banques'] = $this->ArticlesModel->getBanques();
			$data['parametres'] = $this->ArticlesModel->getParametres();
			//$data['reglements'] = $this->FacturesModel->getReglements();
			$this->load->view('templates/header',$header);
			$this->load->view('addReglement',$data);
			$this->load->view('templates/footer');

		}


	}

	public function getReglements(){

		$user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $reglements= $this->FacturesModel->getReglements($dateCaisse,$dateCaisse1);

          $output = json_encode(array("session"=>true,"reglements"=>$reglements));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
	}


  public function getReglementDetails(){

        $user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
        }else{

           $id = $this->input->post('id');

          $reglement= $this->FacturesModel->getReglementDetails($id);

          $output = json_encode(array("result"=>true,"session"=>true,"reglement"=>$reglement));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }

  }

	public function getReglementsF(){

		$user_id = $this->session->userdata('idUtilisateur');
        if(!$user_id){
             $output = json_encode(array("session"=>false));
             $this->output->set_content_type('application/json');
          	$this->output->set_output($output);
        }else{

          $dateCaisse = $this->input->post('dated');
          $dateCaisse1 = $this->input->post('datef');

          $reglements= $this->FacturesModel->getReglementsF($dateCaisse,$dateCaisse1);


          $output = json_encode(array("session"=>true,"reglements"=>$reglements));

          $this->output->set_content_type('application/json');
          $this->output->set_output($output);

        }
	}
	private function utf8ize( $mixed ) {
	    if (is_array($mixed)) {
	        foreach ($mixed as $key => $value) {
	            $mixed[$key] = $this->utf8ize($value);
	        }
	    } elseif (is_string($mixed)) {
	        return mb_convert_encoding($mixed, "UTF-8", "UTF-8");
	    }
	    return $mixed;
	}

}