<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Reservations extends CI_Controller
{
  public function index()
  {

    $id = $this->session->userdata('id');
    if(!$id){
      $this->load->view('login');
    }else{
      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture; 

      $this->hashids->setSalt('Hexa2K20Pms');
      $this->hashids->setMinHashLength(32);

      $dated = date('Y-m-d',strtotime($dateCloture));
      $datef = date('Y-m-d',strtotime($dateCloture));
      //$datef = date('Y-m-d', strtotime(date('Y-m-d',strtotime($dateCloture)) . ' +1 day'));

      $data['clients'] = $this->ReservationsModel->getCardex();
      $data['channels'] = $this->ClientsModel->getClients();

      if(count($data['channels'])>0){

        $data['pensions'] = $this->TarifsModel->getTarifChannel($data['channels'][0]['idChannel']);

      }
      $data['chambres'] = $this->ChambresModel->getTypesChambres();

      $data['reservations'] = $this->ReservationsModel->getReservationsInhouse($dated,$datef);

      $footer['title'] = 'Reservations';

      $header['title'] ="Reservations";

      $header['page'] ="Reservations";

      $header['hotel'] = $this->session->userdata('hotel');

      $header['nom'] = $this->session->userdata('nom');

      $header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

      $data['dateC'] = $dateCloture;

      $this->load->view('templates/header',$header);
      $this->load->view('reservations',$data);
      $this->load->view('templates/footer',$footer);
    }
  }

  public function printFacturePDF($idFacture){
      // $id = $this->session->userdata('id');
      // if(!$id){
      //     $results = array('status'=>true,'session'=>false);
      //     echo json_encode(( $this->utf8ize( $results ) ));
      // }else{



          $data['facture'] = $this->ReservationsModel->getFactureDetailsProv($idFacture);
          $data['reglemnts'] = $this->ReservationsModel->getReglements($idFacture);

          // $data['total'] = 0;
          // $data['totalSej'] = 0;
          // $data['totalHT'] = 0;
          // $data['totalTVA'] = 0;
          // foreach ($data['facture'][0]['details'] as $key => $detail) {
          //     $data['total'] +=$detail['prix'];
          //     if($detail['idExtra'] == 26){
          //       $data['totalSej'] +=$detail['prix'];
          //     }
          // }

          // $data['totalTVA'] = (10/100) * $data['total'];

          // $data['totalHT'] = $data['total'] - $data['totalTVA'];


          $data['total'] = 0;
          $data['totalSej'] = 0;
          $data['totalHT'] = 0;
          $data['totalTVA'] = 0;

          if(count($data['facture'])>0){

            foreach ($data['facture'][0]['details'] as $key => $detail) {
                $sj_pax = 0;

                if($detail['type'] == 1){


                  $totalCh = $this->ReglementsModel->getFactureChambre($detail['id'],$detail['pax'],$detail['nuites'],$data['facture'][0]['changeRate']);

                  if($idFacture == $detail['idFactureP']){

                    $data['total'] += $detail['prix'];

                  }

                  if($idFacture == $detail['taxIdFactureP']){

                    $taxSejourRoom = (11 * $totalCh['sj_pax'])*$data['facture'][0]['changeRate'];

                    $data['totalSej'] +=$taxSejourRoom;

                    $data['total'] +=$taxSejourRoom;

                    $data['facture'][0]['details'][$key]['tax'] = array('prix'=>$taxSejourRoom,'date'=>$detail['date'],'extra'=>'taxe TPT + TS','pax'=>$totalCh['sj_pax']);

                  }

                }else{

                  $data['total'] +=$detail['prix']*$detail['pax'];

                }
            }
            $data['totalTVA'] = $data['total'] * 0.10;
            $data['totalHT'] = $data['total'] - $data['totalTVA'];            
          }
          


          //  $font = $this->dompdf->getFontMetrics()->get_font("lato-semibolditalic");

          // $this->dompdf->getCanvas()->page_text(35, 800, "RESIDENCE HOTEL EZZAHIA ".date('d/m/Y'), $font, 8, array(0,0,0));
          
          // $this->dompdf->getCanvas()->page_text(545, 800,"{PAGE_NUM}/{PAGE_COUNT}", $font, 8, array(0,0,0));


          $html = $this->load->view('facturePDF',$data, true);

          // Load pdf library
          $this->load->library('pdf');
                          
          // Load HTML content
          $this->dompdf->loadHtml($html);
                          
          // (Optional) Setup the paper size and orientation
          $this->dompdf->setPaper('A4', 'portrait');


                          
          // Render the HTML as PDF
          $this->dompdf->render();
                          
          // Output the generated PDF (1 = download and 0 = preview)
          $this->dompdf->stream("Facture.pdf", array("Attachment"=>0));

      // }

  }


  public function setEditFacture(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{

        $idReservation = $this->input->post('idReservation');
        $idFacture = $this->input->post('idFacture');
        $reglements = $this->input->post('reglement');
        $ice = $this->input->post('ice');
        $nom = $this->input->post('nom');
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 

        if($this->ReglementsModel->updateFacture($idReservation,$idFacture,$dateCloture,$id,$reglements,$ice,$nom)){
          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));
        }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        } 

      }
  }

  public function affecterRoom(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idCR = $this->input->post('idCR');

        $modal = $this->input->post('modal');

        $html ='';
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 

        $chambres = $this->ReservationsModel->getChambresDelogerType($idCR);
        $y = 0;

        if($chambres){

          if (count($chambres)>0) {
                $idch = 0;  

                $html .= '<div class="container-fluid">
                    <div class="col-12">
                      <div class="row">

                          <div id="title_content_layer" class="col-12">

                            <span style="font-style:italic;font-size:130%;font-weight:800">Affecter Chambre </span>

                          </div>
                          <div id="body_content_layer" class="col-12"><div class="row">';
                foreach ($chambres as $key => $chambreLibre){
                  $y++;


                  $html .= '<div class="col-2 col-md-1 text-center"> ';
                  if ($chambreLibre['idReservation']){

                    if ($chambreLibre['checkout'] == $dateCloture){

                      $html .= '<div class="hexa-box hexa-box-checkout"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item">#'.$chambreLibre['idReservation'].'</span> </div>';
                    }else{ 

                      $html .= '<div class="hexa-box hexa-box-checkin"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item">#'.$chambreLibre['idReservation'].'</span> </div>'; 
                    } 
                  }else{

                    if($modal){

                          $html .= '<div class="hexa-box hexa-box-open" onclick="checkingAffectRoomModel('. $idReservation.','.$idCR.','.$chambreLibre['idChambres'].');"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item"></span> </div>'; 
                    }else{

                          $html .= '<div class="hexa-box hexa-box-open" onclick="checkingAffectRoom('. $idReservation.','.$idCR.','.$chambreLibre['idChambres'].');"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item"></span> </div>'; 
                    }


                  


                  }


                      $html .= '</div>'; 
                }
                if($y<60){
                  for ($i=$y; $i < 60; $i++) { 
                      $html .= '<div class="col-1 text-center"><div class="hexa-box hexa-box"></div></div>'; 
                  }
                }

            // $html .= '<div class="col-12" style="padding-top:10px"> <div class="form-row"> <div class="form-group col-md-12"> <button type="button" onclick="retourAffectRoom()" class="btn btn-info hexa-btn-op-mod float-left">Retour </button> </div> </div> </div>';



                        $html .= ' </div></div>
                          <div id="buttons_content_layer" class="col-12">';

                            $html .='<button type="button" onclick="retourAffectRoom()" class="btn btn-danger hexa-btn-op-retour float-left"> Retour </button>
                          </div>


                      </div>
                    </div>
                  </div>';



          }





        }

        if($chambres){

          $results = array('status'=>true,'session'=>true,'html'=>$html);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

        }

      }
  }


  public function getRoomDelogerRoom(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idCR = $this->input->post('idCR');
        $modal = $this->input->post('modal');

        $html ='';

        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 

        $chambres = $this->ReservationsModel->getChambresDelogerType($idCR);
        $y = 0;

        if($chambres){

          if (count($chambres)>0) {
                $idch = 0;  
                //var_dump($chambres);
                // $html .= '<div style="min-height:20vh" class="row">';
                                $html .= '<div class="container-fluid">
                    <div class="col-12">
                      <div class="row">

                          <div id="title_content_layer" class="col-12">

                            <span style="font-style:italic;font-size:130%;font-weight:800">Deloger Chambre </span>

                          </div>
                          <div id="body_content_layer" class="col-12"><div class="row">';

                foreach ($chambres as $key => $chambreLibre){
                  $y++;


                  $html .= '<div class="col-2 col-md-1 text-center"> ';
                  if ($chambreLibre['idReservation']){

                    if ($chambreLibre['checkout'] == $dateCloture){

                      $html .= '<div class="hexa-box hexa-box-checkout"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item">#'.$chambreLibre['idReservation'].'</span> </div>';
                    }else{ 

                      $html .= '<div class="hexa-box hexa-box-checkin"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item">#'.$chambreLibre['idReservation'].'</span> </div>'; 
                    } 
                  }else{

                    if($modal){
                      $html .= '<div class="hexa-box hexa-box-open" onclick="setDelogementModal('. $idReservation.','.$idCR.','.$chambreLibre['idChambres'].');"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item"></span> </div>'; 
                    }else{
                      $html .= '<div class="hexa-box hexa-box-open" onclick="setDelogement('. $idReservation.','.$idCR.','.$chambreLibre['idChambres'].');"> <span class="hexa-item-c">'.$chambreLibre['codeChambre'].'</span> <span class="hexa-item-m">'.$chambreLibre['nomChambre'].'</span> <span class="hexa-item"></span> </div>'; 
                    }

                   
                    }


                      $html .= '</div>'; 
                  }
                  if($y<60){
                    for ($i=$y; $i < 60; $i++) { 
                      $html .= '<div class="col-1 text-center"><div class="hexa-box hexa-box"></div></div>'; 
                    }
                    

                  }

                // $html .= '<div class="col-12" style="padding-top:10px"> <div class="form-row"> <div class="form-group col-md-12"> <button type="button" onclick="retourAffectRoom()" class="btn btn-info hexa-btn-op-mod float-left">Retour </button> </div> </div> </div>';    
                                          $html .= ' </div></div>
                          <div id="buttons_content_layer" class="col-12">';

                            $html .='<button type="button" onclick="retourAffectRoom()" class="btn btn-danger hexa-btn-op-retour float-left"> Retour </button>
                          </div>


                      </div>
                    </div>
                  </div>';
          }

        }

        if($chambres){

          $results = array('status'=>true,'session'=>true,'html'=>$html);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

        }

      }
  }


  public function getUpdateRoom(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idCR = $this->input->post('idCR');

        $modal = $this->input->post('modal');

        $html ='';

        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 

        $chambreCR =  $this->ReservationsModel->getReservationRoom($idCR);

        if(count($chambreCR)>0){

          $mod_pensions = $this->TarifsModel->getTarifChannelCode($chambreCR[0]['channel']);

          $mod_chambres = $this->ChambresModel->getTypesChambres();

          $html .='<div class="container-fluid">
                    <div class="col-12">
                      <div class="row">

                          <div id="title_content_layer" class="col-12">

                            <span style="font-style:italic;font-size:130%;font-weight:800">Modifier Chambre </span>

                          </div>
                          <div id="body_content_layer" class="col-12">

                           <div class="form-group row"> 

                            <label class="col-sm-1 col-form-label form-input" for="res_ch_mod_checkin">Arrivee</label> 

                              <div class="col-sm-3 input-group  md-form form-sm form-2"> 

                                  <input type="text" class="date-hexa datepicker form-control" id="res_ch_mod_checkin" /> 
                                      <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> 

                                      </div> 
                              </div> 


                            <label class="col-sm-1 col-form-label form-input" for="res_ch_typch">Chambre</label> 

                              <div class="col-sm-3 input-group  md-form form-sm form-2"> <select id="res_ch_typch" class="selectpicker form-controll form-input">';

                                    foreach ($mod_chambres as $key => $chambre){
                                      $html .='<option value="'.$chambre['idTypeChambres'].'"';

                                      if($chambre['idTypeChambres'] == $chambreCR[0]['idTypeChambres']){
                                          $html .='  selected';
                                      }

                                      $html .=' >'.$chambre['nomTypeChambres'].'</option>'; 
                                    }

                                    $html .='</select> 
                              </div> 

                            <label class="col-sm-1 col-form-label form-input" for="res_ch_mod_adult">Adult</label> 

                            <div class="col-sm-3 input-group  md-form form-sm form-2"> 

                            <select id="res_ch_mod_adult" class="selectpicker form-controll form-input">';

                                    for ($i = 1; $i < 7; $i++) {

                                        $html .='<option'; 
                                        if ($i == $chambreCR[0]['totalAdult']) {
                                            $html .=' selected ';
                                        }
                                        $html .='>'.$i.'</option>';
                                        
                                    }

                                    $html .='</select> 
                              </div> 

                          </div> 

                          <div class="form-group row"> 

                            <label class="col-sm-1 col-form-label form-input" for="res_ch_mod_checkout">Depart</label> 

                            <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                <input type="text" class="date-hexa datepicker form-control" id="res_ch_mod_checkout" /> 

                                <div class="input-group-append"> 
                                    <span class="input-group-text lime lighten-2" id="basic-text1"> 
                                        <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> 
                                    </span> 
                                </div> 

                            </div> 

                            <label class="col-sm-1 col-form-label form-input" for="res_ch_pension_res">Pension</label> 

                            <div class="col-sm-3 input-group  md-form form-sm form-2"> 

                              <select  id="res_ch_pension_res" class="selectpicker form-controll form-input" >';

                                    foreach ($mod_pensions as $key => $tarif){

                                        if ($tarif['remboursale']){

                                           $cond = 'REM'; 
                                         }else{

                                           $cond = 'NRF';

                                         } 

                                         $html .='<option value="'.$tarif['idDetTar'].'">'.$tarif['codeTarif'] .' '. $tarif['codePension'] . ' ' . $cond .'</option>';
                                         }

                                        $html .='</select> 
                            </div> 

                            <label class="col-sm-1 col-form-label form-input" for="res_ch_mod_enfant">Enfant</label> 

                              <div class="col-sm-3 input-group  md-form form-sm form-2"> 

                                  <select id="res_ch_mod_enfant" class="selectpicker form-controll form-input"  data-size="4">';

                                    for ($i = 0; $i < 7; $i++) {

                                        $html .='<option'; 
                                        if ($i == $chambreCR[0]['totalEnfant']) {
                                            $html .=' selected ';
                                        }
                                        $html .='>'.$i.'</option>';
                                        
                                    }


                         $html .=' </select></div></div>


                         </div>
                          <div id="buttons_content_layer" class="col-12">';

                              if ($modal) {
                                   $html .='<button type="button" onclick="modifierRoomReservationPModal(this,'.$idCR.','.$idReservation.')" class="btn btn-success hexa-btn-op-mod float-right"> Modifier </button>';
                              }else{
                                  $html .='<button type="button" onclick="modifierRoomReservationP(this,'.$idCR.','.$idReservation.')" class="btn btn-success hexa-btn-op-mod float-right"> Modifier </button>';
                              }

                            $html .='<button type="button" onclick="retourAffectRoom()" class="btn btn-danger hexa-btn-op-retour float-left"> Retour </button>
                          </div>


                      </div>
                    </div>
                  </div>';

          $results = array('status'=>true,'session'=>true,'html'=>$html,'checkin'=>true,'checkout'=>true,'dateDu'=>$chambreCR[0]['dateDu'],'dateAu'=>$chambreCR[0]['dateAu']);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

        }

      }
  }


  public function supprimerFacture(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idFacture = $this->input->post('idFacture');

        if($this->ReglementsModel->supprimerFacture($idFacture,$idReservation,$id)){

          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        }
      }
  }

  public function supprimerReglement(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idReglement = $this->input->post('idReglement');

        if($this->ReglementsModel->supprimerReglement($idReglement,$idReservation,$id)){

          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

        }

      }
  }


  public function modifierReglement(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $idReservation = $this->input->post('idReservation');

        $idReglement = $this->input->post('idReglement');

        $prix = $this->input->post('prix');

        $mdp = $this->input->post('mdp');

        if($this->ReservationsModel->modifierReglement($idReglement,$idReservation,$id,$prix,$mdp)){

          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

        }

      }
  }

  public function addRoomForm(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{

        $idReservation = $this->input->post('idReservation');

        $modal = $this->input->post('modal');

        $reservation = $this->ReservationsModel->getReservation($idReservation);

        if($reservation){

          $mod_pensions = $this->TarifsModel->getTarifChannelCode($reservation->channel);

          $mod_chambres = $this->ChambresModel->getTypesChambres();

          $html = '<div class="container-fluid"> <div class="col-12"> <div class="row"> <div id="title_content_layer" class="col-12"> <span style="font-style:italic;font-size:130%;font-weight:800">Ajouter une chambre </span> </div> <div id="body_content_layer" class="col-12"><div class="form-group row"> <label class="col-sm-1 col-form-label form-input" for="res_ch_checkin">Arrivee</label> <div class="col-sm-3 input-group  md-form form-sm form-2"> <input type="text" class="date-hexa datepicker form-control" id="res_ch_checkin" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> <label class="col-sm-1 col-form-label form-input" for="res_ch_typch">Chambre</label> <div class="col-sm-3 input-group  md-form form-sm form-2"> <select id="res_ch_typch" class="selectpicker form-controll form-input">';

          foreach ($mod_chambres as $key => $chambre){ 
            $html .= '<option value="'.$chambre['idTypeChambres'].'">'.$chambre['nomTypeChambres'].'</option>';
          }

          $html .= '</select> </div> <label class="col-sm-1 col-form-label form-input" for="adult_res">Adult</label> <div class="col-sm-3 input-group  md-form form-sm form-2"> <select id="adult_res" class="selectpicker form-controll form-input"><option>1</option> <option>2</option> <option>3</option> <option>4</option> <option>5</option> <option>6</option></select> </div> </div> <div class="form-group row"> <label class="col-sm-1 col-form-label form-input" for="res_ch_checkout">Depart</label> <div class="col-sm-3 input-group  md-form form-sm form-2"> <input type="text" class="date-hexa datepicker form-control" id="res_ch_checkout" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> <label class="col-sm-1 col-form-label form-input" for="res_ch_pension_res">Pension</label> <div class="col-sm-3 input-group  md-form form-sm form-2"> <select  id="res_ch_pension_res" class="selectpicker form-controll form-input" >';

          foreach ($mod_pensions as $key => $tarif){ 
            if ($tarif['remboursale']){
              $cond = 'REM'; 
            }else{
              $cond = 'NRF';
            } 
            $html .= '<option value="'.$tarif['idDetTar'].'">'.$tarif['codeTarif'] .' '. $tarif['codePension'] . ' ' . $cond.'</option>'; 
          }


          $html .= '</select> </div> <label class="col-sm-1 col-form-label form-input" for="enfant_res">Enfant</label> <div class="col-sm-3 input-group md-form form-sm form-2"> <select id="enfant_res" class="selectpicker form-controll form-input"  data-size="4"><option value="0">0</option><option>1</option> <option>2</option> <option>3</option> <option>4</option></select> </div> </div></div> <div id="buttons_content_layer" class="col-12">';
          if($modal){
            $html .= '<button type="button" onclick="ajouterResRoomPModal('.$reservation->idReservation .')" class="btn btn-success hexa-btn-op-mod float-right"> Ajouter </button>';
          }else{
            $html .= '<button type="button" onclick="ajouterResRoomP('.$reservation->idReservation .')" class="btn btn-success hexa-btn-op-mod float-right"> Ajouter </button>';
          }

          $html .='<button type="button" onclick="annulerResCh()" class="btn btn-danger hexa-btn-op-retour float-left"> Retour </button> </div> </div> </div> </div>';


          $results = array('status'=>true,'session'=>true,'html'=>$html,'checkin'=>$reservation->dateDu,'checkout'=>$reservation->dateAu);

          echo json_encode(( $this->utf8ize( $results ) ));              


        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        }


      }
  }

  public function addExtraForm(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{



        $idReservation = $this->input->post('idReservation');

        $modal = $this->input->post('modal');

        $Aextras = $this->ExtrasModel->getExtras();

        $reservation = $this->ReservationsModel->getReservation($idReservation);

        if($reservation){

            $html ='<div class="container-fluid"> <div class="row"> <div class="col-12" style="margin-bottom: 0.75rem !important"> <span style="font-style:italic;font-size:130%;font-weight:800">Extra sur Reservation </span> </div> <div class="col-12"> <div class="form-group row"> <label  class="col-sm-1 col-form-label form-input" for="res_ch_ext">Extra</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_ch_ext" class="selectpicker form-controll form-input" data-size="4"  data-live-search="true">';

              foreach ($Aextras as $key => $extraa){
                $html .='<option value="'. $extraa['idExtra'] .'">'. $extraa['extra'].'</option>';
              }


            $html .='</select> </div> <label  class="col-sm-1 col-form-label form-input" for="res_per_ext">Personnes</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_per_ext" class="selectpicker form-controll form-input"   data-size="4">';


                for ($i=1; $i < ($reservation->total_guests+1); $i++){

                  $html .='<option value="'.$i.'">'.$i.'</option>';
                }

               $html .='</select></div> </div> <div class="form-group row"> <label  class="col-sm-1 col-form-label form-input" for="res_dates_ext">Dates</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_dates_ext" class="selectpicker form-controll form-input" data-size="4" multiple title="Dates Extra..." multiple>';


                $datee = $reservation->dateDu; 

                while (strtotime($datee) <= strtotime("-1 day", strtotime($reservation->dateAu))) {

                  $html .='<option value="'.$datee.'">'.$datee.'</option>';

                  $datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee))); 

                } 


              $html .='</select>  </div> <label  class="col-sm-1 col-form-label form-input" for="res_prix_ext">Prix Unitaire</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <input type="text" name="res_prix_ext" placeholder="Entrer le prix unitaire.." id="res_prix_ext" class="form-control form-input"> </div> </div> <div class="form-row"  style="padding-top:20px"> <div class="form-group col-md-12">'; 

               if($modal){

                    $html .='<button type="button" id="hexa-btn-extra" onclick="confirmerExtraRoomModal('.$reservation->idReservation.')" class="btn btn-success hexa-btn-op-retour float-right">Ajouter</button> '; 

               }else{
                
                    $html .='<button type="button" id="hexa-btn-extra" onclick="confirmerExtraRoom('.$reservation->idReservation.')" class="btn btn-success hexa-btn-op-retour float-right">Ajouter</button> '; 
               }




              $html .='<button type="button" onclick="retourExtraRoom()" class="btn btn-info hexa-btn-op-retour float-left">Retour </button> </div> </div> </div></div> </div>'; 

          $results = array('status'=>true,'session'=>true,'html'=>$html);

          echo json_encode(( $this->utf8ize( $results ) ));              


        }else{

          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        }









      }

  }
  public function addExtraFormRoom(){
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{

        $idReservation = $this->input->post('idReservation');



        $reservation = $this->ReservationsModel->getReservation($idReservation);

        if($reservation){


          $idCR = $this->input->post('idCR');
          $modal = $this->input->post('modal');

          $chambres = $this->ReservationsModel->getReservationRoomsL($idReservation);
          $Aextras = $this->ExtrasModel->getExtras();

          $html ='<div class="container-fluid"> <div class="row"> <div class="col-12" style="margin-bottom: 0.75rem !important"> <span style="font-style:italic;font-size:130%;font-weight:800">Extra sur chambre </span> </div> <div class="col-12"> <div class="form-group row"> <label  class="col-sm-1 col-form-label form-input" for="res_ch_ext">Extra</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_ch_ext" class="selectpicker form-controll form-input" data-size="4"  data-live-search="true"> ';

            foreach ($Aextras as $key => $extraa){
              $html .='<option value="'. $extraa['idExtra'] .'">'. $extraa['extra'].'</option>';
            }


          $html .='</select> </div> <label  class="col-sm-1 col-form-label form-input" for="res_per_ext">Personnes</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_per_ext" class="selectpicker form-controll form-input"   data-size="4"> ';


            for ($i=1; $i < ($reservation->total_guests+1); $i++){

              $html .='<option value="'.$i.'">'.$i.'</option>';
            }

           $html .='</select></div> </div> <div class="form-group row"> <label  class="col-sm-1 col-form-label form-input" for="res_dates_ext">Dates</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_dates_ext" class="selectpicker form-controll form-input" data-size="4" multiple title="Dates Extra..." multiple>';


            $datee = $reservation->dateDu; 

            while (strtotime($datee) <= strtotime("-1 day", strtotime($reservation->dateAu))) {

              $html .='<option value="'.$datee.'">'.$datee.'</option>';

              $datee = date ("Y-m-d", strtotime("+1 day", strtotime($datee))); 

            } 


            $html .='</select> </div> <label  class="col-sm-1 col-form-label form-input" for="res_prix_ext">Prix Unitaire</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <input type="text" name="res_prix_ext" placeholder="Entrer le prix unitaire.." id="res_prix_ext" class="form-control form-input"> </div> </div> <div class="form-group row"> <label  class="col-sm-1 col-form-label form-input" for="res_ch_ch">Chambre</label> <div class="col-sm-5 input-group  md-form form-sm form-2"> <select id="res_ch_ch" class="selectpicker form-controll form-input" data-size="4">';

           foreach ($chambres as $key => $chambre){ 

            $html .='<option value="'.$chambre['idCR'].'">'.  $chambre['nomTypeChambres'].'</option>';

           }


            $html .='</select> </div> </div> <div class="form-row" style="padding-top:20px"> <div class="form-group col-md-12">';

           if($modal){

            $html .='<button type="button" id="hexa-btn-extra" onclick="confirmerExtraRoomPModal('.$idReservation.','.$idCR.')" class="btn btn-success hexa-btn-op-retour float-right">Ajouter</button>';

           }else{

            $html .='<button type="button" id="hexa-btn-extra" onclick="confirmerExtraRoomP('.$idReservation.','.$idCR.')" class="btn btn-success hexa-btn-op-retour float-right">Ajouter</button>';
           }





         $html .='<button type="button" onclick="retourExtraRoom()" class="btn btn-info hexa-btn-op-retour float-left">Retour </button> </div> </div> </div></div></div>';


            $results = array('status'=>true,'session'=>true,'html'=>$html);

            echo json_encode(( $this->utf8ize( $results ) ));          


        }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
          
        }




      }   
  }


  public function editFacturer(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $idFacture = $this->input->post('idFacture');

      $factures = $this->ReservationsModel->getFacture($idFacture);

      $modePaiements = $this->ReservationsModel->getModePaiements();

      $factureChambre=false;

      $factureExtra=false;

      $html='';

      if(count($factures)>0){

        foreach ($factures as $key => $facture) {

          $extras = $this->ReservationsModel->getExtraChambre($facture['idFacture']);
          $chambres = $this->ReservationsModel->getReservationRoomsL($facture['idFacture']);

                                                                  
          $html.='<table id="TableRegll" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;"><tr onclick="factureMAster(this)" class="hexa_row_reg active-reg" style="background: #F6FAFB;"><td width="5%"><i class="fa fa-check-square"></i></td><td colspan="4">Facture Master</td></tr></table> ';
                                    
                                     

           if (count($chambres)>0){
                $html.='<table id="TableRegllll" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;"> <tr onclick="allRoom(this)" class="hexa_row_reg" style="background: #F6FAFB;"><td width="5%"><i class="far fa-square"></i></td><td colspan="4">Facture Chambres</td></tr> </table> <table id="TableRegl" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;"> <thead class="hexa-header-reservation"> <th></th> <th>Prestation</th> <th>Date</th> <th class="text-center">Total</th> <th class="text-center">Etat</th> </thead> <tbody>'; 

                foreach ($chambres as $indexCh => $chambre){
                      if ($chambre['idFactureP']==0){
                        $html.='<tr onclick="selectRoom(this,'. $chambre['idCR'] .')" class="hexa_row_reg" > <td width="5%"><i class="far fa-square"></i></td> <td width="35%">'. $chambre['nomTypeChambres'] .'</td> <td width="15%">'. strftime("%d/%m/%G", strtotime($dateCloture)) .'</td> <td width="10%" class="text-right">'. number_format($chambre['prix'] * 1/$reservation->changeRate ,2,'.','') .'</td> <td width="10%" class="text-center"><span style="color:#f94144;font-weight: 700!important;">Non réglé</span></td> </tr> '; }
                   }
                  $html.='</tbody></table>';
                   
                 } 
                if (count($extras)>0){
                    $html.='<table id="TableReglll" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;"> <tr onclick="allExtra(this)" class="hexa_row_reg"  style="background: #F6FAFB;"><td width="5%"><i class="far fa-square"></i></td><td colspan="4">Facture Extras</td></tr> </table> <table id="TableRegle" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;"> <thead class="hexa-header-reservation"> <th></th> <th>Prestation</th> <th>Date</th> <th class="text-center">Total</th> <th class="text-center">Etat</th> </thead> <tbody>'; 
                    foreach ($extras as $indexCh => $extra){
                      if ($extra['idFactureP']==0){
                          $html.=' <tr onclick="selectExtra(this,'. $extra['idExtraRes'].')" class="hexa_row_reg"> <td width="5%"><i class="far fa-square"></i></td> <td width="35%">'.  $extra['extraReservation'] .'</td> <td width="15%">'. strftime("%d/%m/%G", strtotime($dateCloture)).'</td> <td class="text-right" width="10%">'.  number_format($extra['prix'] * 1/$reservation->changeRate ,2,'.','').'></td> <td class="text-center" width="10%"><span style="color:#f94144;font-weight: 700!important;">Non réglé</span></td> </tr> '; }
                      }                  
                }

            $html.='</tbody> </table> <div class="form-row" style="margin-top: 0.75rem !important;"> <div class="form-group col-md-12"> <button type="button" onclick="modifierFacture(<?php echo $reservation->idReservation ?>)" class="btn btn-success hexa-btn-op-mod float-right">Ajouter</button> <button type="button" onclick="retourCreatFacture()" class="btn btn-info  hexa-btn-op-mod float-right">Retour </button> </div> </div> ';

      }



        $results = array('status'=>true,'session'=>true,'html'=>$html);

        echo json_encode(( $this->utf8ize( $results ) ));


    }else{
        $results = array('status'=>false,'session'=>true);
        echo json_encode(( $this->utf8ize( $results ) ));
      }




















    } 

  }

  public function searchReservation(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $filtres = $this->input->post('search');

      $reservations = $this->ReservationsModel->getSearchReservations($filtres);
      $results = $this->filterJson($reservations,$filtres);
      echo json_encode(( $this->utf8ize( $results ) ));

    }

  }

  public function filtrerReservations()
  {

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $dated = $this->input->post('dated');
      $datef = $this->input->post('datea');
      $filtres = $this->input->post('filtres');
      switch ($filtres) {
        case 1:
          $reservations = $this->ReservationsModel->getReservationsInhouse($dated,$datef);
          $results = $this->filterJson($reservations);
          echo json_encode(( $this->utf8ize( $results ) ));

          break;
        case 2:
          $reservations = $this->ReservationsModel->getReservationsAnnulee($dated,$datef);
          $results = $this->filterJson($reservations);
          echo json_encode(( $this->utf8ize( $results ) ));

          break;
        case 3:

            $reservations = $this->ReservationsModel->getReservationsNoShow($dated,$datef);
            $results = $this->filterJson($reservations);
            echo json_encode(( $this->utf8ize( $results ) ));
          break;
        case 4:
            $reservations = $this->ReservationsModel->getReservationsCheckIN($dated,$datef);
            $results = $this->filterJson($reservations);
            echo json_encode(( $this->utf8ize( $results ) ));
          break;
        case 5:
            $reservations = $this->ReservationsModel->getReservationsCheckOUT($dated,$datef);
            $results = $this->filterJson($reservations);
            echo json_encode(( $this->utf8ize( $results ) ));
          break;
        case 6:
            $reservations = $this->ReservationsModel->getReservationsNoCheckIN($dated,$datef);
            $results = $this->filterJson($reservations);
            echo json_encode(( $this->utf8ize( $results ) ));
          break;
        case 7:
            $reservations = $this->ReservationsModel->getReservationsNotCheckOUT($dated,$datef);
            $results = $this->filterJson($reservations);
            echo json_encode(( $this->utf8ize( $results ) ));

          break;
        default:

          $reservations = $this->ReservationsModel->getReservationsALL($dated,$datef);
          $results = $this->filterJson($reservations);
          echo json_encode(( $this->utf8ize( $results ) ));
          break;
      }

    }
  }

  public function createFacture(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $res = false;

      $idReservation = $this->input->post('idReservation');
      $reglements = $this->input->post('reglement');
      $ice = $this->input->post('ice');
      $nom = $this->input->post('nom');
      $model = $this->input->post('model');
      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture; 
      if(!isset($reglements)){

        $res = $this->ReglementsModel->createFactureMaster($idReservation,$dateCloture,$id,$ice,$nom);

      }else{
        if(count($reglements)>0){
          $res = $this->ReglementsModel->createFacture($idReservation,$dateCloture,$id,$reglements,$ice,$nom);
        }
      }
      if($res){
        if($model){
          $results = $this->getContentReservation($idReservation);
        }else{
          $results = $this->contentReservationP($idReservation);
        }
        
        echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $results = array('status'=>false,'session'=>true);
        echo json_encode(( $this->utf8ize( $results ) ));
      } 
    }
  }


  public function reglerFactureContent(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $res = false;

      $idReservation = $this->input->post('idReservation');
      $total = $this->input->post('total');
      $idFacture = $this->input->post('idFacture');
      $modal = $this->input->post('modal');

      $modePaiements = $this->ReservationsModel->getModePaiements();

      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture; 

      $html = '<div class="container-fluid"> <div class="col-12"> <div class="row"> <div id="title_content_layer" class="col-12"> <span style="font-style:italic;font-size:130%;font-weight:800">Regler une Facture </span> </div> <div id="body_content_layer" class="col-12"> <div class="form-group row"> <label for="mod_client" class="col-sm-2 col-form-label form-input">Mode paiement</label> <div class="col-sm-4 input-group  md-form form-sm form-2"> <select data-size="4" class="selectpicker form-control" id="PaimenetMet">'; 
        foreach ($modePaiements as $key => $modePaiement) {

            $html .= '<option value="'.$modePaiement['idModePaimenet'].'">'.$modePaiement['modePaiement'].'</option>';
            
        }


      $html .= '</select> </div> <label for="reg_tot" class="col-sm-2 col-form-label form-input">Total a regler</label> <div class="col-sm-4 input-group md-form form-sm form-2"> <input id="reg_tot" class="hexa-autoc form-control" style="font-style:italic;font-weight:800;font-size:14px;text-align:center" value="'.$total.'"> </div>   </div> </div> <div id="buttons_content_layer" class="col-12">';
      if($modal){
        $html .= '<button type="button" onclick="reglerFactureModel('.$idReservation.','.$idFacture.')" class="btn btn-success hexa-btn-op-mod float-right">Regler</button>';
      }else{
        $html .= '<div class="col-12" > <button type="button" onclick="reglerFacture('.$idReservation.','.$idFacture.')" class="btn btn-success hexa-btn-op-mod float-right">Regler</button>';
      }

      $html .='<button type="button" onclick="retourReglerFacture()" class="btn btn-danger hexa-btn-op-retour float-left"> Retour </button> </div> </div> </div>';


        $results = array('status'=>true,'session'=>true,'html'=>$html);

        
        echo json_encode(( $this->utf8ize( $results ) ));



    }
  }

  public function reglerFacture(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture;       

      $idReservation = $this->input->post('idReservation');

      $idFacture = $this->input->post('idFacture');
      $total = $this->input->post('total');
      $PaimenetMet = $this->input->post('PaimenetMet');
      $modal = $this->input->post('modal');

      if($this->ReglementsModel->insert($idReservation,$id,$total,$dateCloture,$idFacture,$PaimenetMet)){
        if($modal){
          $results = $this->getContentReservation($idReservation);
        }else{
          $results = $this->contentReservationP($idReservation);
        }
        

        echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $results = array('status'=>false,'session'=>true);
        echo json_encode(( $this->utf8ize( $results ) ));
      } 
    }
  }

  public function detailsReservation($idReservation)
  {

    $id = $this->session->userdata('id');
    if(!$id){
      $this->load->view('login');
    }else{

        $this->hashids->setSalt('Hexa2K20Pms');
        $this->hashids->setMinHashLength(32);

        $res = $this->hashids->decode($idReservation);

        if(count($res)==0){ $this->index(); return;}
        $idReservation = $res[0];

        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 
        $data['dateCloture'] = $dateCloture; 

        $data['reservation'] = $this->ReservationsModel->getReservation($idReservation);

        if($data['reservation']){

            $data['factureChambre']=false;

            $data['factureExtra']=false;

            $data['client'] = $this->ReservationsModel->getReservationClient($data['reservation']->idCardex);

            $data['channel'] = $this->ChannelsModel->getChannel($data['reservation']->channel);

            $data['totalRegle'] = $this->ReservationsModel->getFacturesRegele($idReservation);

            $data['chambresr'] = $this->ReservationsModel->getReservationRoomsR($idReservation);

            $data['chambres'] = $this->ReservationsModel->getReservationRoomsL($idReservation);

            $data['extras'] = $this->ReservationsModel->getExtraChambre($idReservation);

            foreach ($data['extras'] as $key => $extra) {
              if($extra['idDeduction']>0){
                if($extra['idFactureP']==0){
                  $data['factureExtra']=true;
                }
              }
              $data['extras'][$key]['dates'] = $this->ReservationsModel->getDatesExtraChambre($extra['idExtraRes']);
            }

            //$data['reglements'] = $this->ReglementsModel->getReglement($idReservation);

            $data['pays'] = $this->ReservationsModel->getPays($data['client']->idPays);

            $data['codePays'] = $data['client']->idPays;

            $data['payys'] = $this->HotelModel->getPays();

            $data['tarifs'] = $this->TarifsModel->getTarifUnique();

            $data['tchambres'] = $this->ChambresModel->getTypesChambres();

            $data['Aextras'] = $this->ExtrasModel->getExtras();

            $data['modePaiements'] = $this->ReservationsModel->getModePaiements();

            $data['taxes'] = $this->HotelModel->getTaxes();

            $data['date'] = new DateTime($data['reservation']->completedAt);

            $data['pensions'] = $this->PensionsModel->getPensions();

            $data['mod_pensions'] = $this->TarifsModel->getTarifChannelCode($data['reservation']->channel);

            $data['mod_chambres'] = $this->ChambresModel->getTypesChambres();

            $data['clients'] = $this->ReservationsModel->getCardex();

            $data['channels'] = $this->ClientsModel->getClients();



            //$data['chambresLibre'] = $this->ChambresModel->getChambresTypeChambre();

            $data['chambresLibre'] = $this->ChambresModel->getChambresTypeChambreDates($dateCloture,$data['reservation']->dateAu);

            $data['date']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $data['today'] = new DateTime(date('Y-m-d H:m:s'));

            $data['today']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $checkin = true;

            $data['dateDu'] = false;

            $data['dateAu'] = false;

            $footer['title'] = 'Reservations';

            $header['title'] ="Reservations";

            $header['page'] ="Reservations";

            $header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

            $data['dateC'] = $dateCloture;

            $footer['title'] = 'Reservations';

            $header['hotel'] = $this->session->userdata('hotel');

            $header['nom'] = $this->session->userdata('nom');

            $data['date']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $data['today'] = new DateTime(date('Y-m-d H:m:s'));
            $data['today']->setTimezone(new DateTimeZone('Africa/Casablanca'));
            
            $data['closed'] = true;


            $updatedAt = new DateTime($data['reservation']->updatedAt);
            $updatedAt->setTimezone(new DateTimeZone('Africa/Casablanca')); 
            setlocale(LC_TIME, "fr_FR");
            $data['updatedAt'] = utf8_encode(strftime("%A %d %B %G",strtotime($updatedAt->format('d-m-Y')))).' '.$updatedAt->format('H:i');

            foreach ($data['chambresr'] as $key => $chambre) {

              if(!$chambre['isCanceled']){

                if(!$chambre['isCheckout'] && !$chambre['isNoshow']){

                  $data['closed'] = false;

                }                

              }

            }

            $data['checkin'] = false;
            $data['checking'] = true;
            $lastElementKey = count($data['chambres'])-1;

            foreach ($data['chambres'] as $key => $chambre) {

              if($chambre['idFactureP']==0){
                $data['factureChambre']=true;
              }

              $data['chambres'][$key]['dates']   = $this->ReservationsModel->getDatesChambreRes($chambre['idCR']);

              if($data['chambres'][0]['dateDu'] != $chambre['dateDu']){

                $data['checking'] = false;

              }

              if(!$chambre['isCheckin']){

                $data['checkin'] = true;

              }
  
              if($key == $lastElementKey) break;

              if(!$chambre['isCanceled']){

                if($chambre['dateDu'] != $data['chambres'][$key+1]['dateDu']){

                    $data['dateDu'] = true;

                }
                if($chambre['dateAu'] != $data['chambres'][$key+1]['dateAu']){

                    $data['dateAu'] = true;

                }

              }

            }

            $data['activites'] = $this->ReservationsModel->getActiviteReservation($idReservation);

            $data['factures'] = $this->ReservationsModel->getFactures($idReservation);
            foreach ($data['factures'] as $key => $facture) {

              $data['factures'][$key]['modePaiement'] =$this->ReservationsModel->getReglements($facture['idFacture']);
            }
            

            $this->load->view('templates/header',$header);
            $this->load->view('detailsReservation',$data);
            $this->load->view('templates/footer',$footer);

        }else{

          $this->index();

        }
    }
  }

  public function printListReservation($filtres,$dated,$datef)
  {

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $data['dated']=$dated;
        $data['datea']=$datef;
        

      switch ($filtres) {
        case 1:
          $data['reservations']= $this->ReservationsModel->getReservationsInhouse($dated,$datef);
          $data['type']='In House';
          break;
        case 2:
          $data['reservations'] = $this->ReservationsModel->getReservationsAnnulee($dated,$datef);
          $data['type']='Annulee';
          break;
        case 3:
            $data['reservations'] = $this->ReservationsModel->getReservationsNoShow($dated,$datef);
            $data['type']='NoShow';
          break;
        case 4:
            $data['reservations'] = $this->ReservationsModel->getReservationsCheckIN($dated,$datef);
            $data['type']='Checkin';
          break;
        case 5:
            $data['reservations'] = $this->ReservationsModel->getReservationsCheckOUT($dated,$datef);
            $data['type']='Checkout';
          break;
        case 6:
            $data['reservations'] = $this->ReservationsModel->getReservationsNoCheckIN($dated,$datef);
            $data['type']='No Checkin';
          break;
        case 7:
            $data['reservations'] = $this->ReservationsModel->getReservationsNotCheckOUT($dated,$datef);
            $data['type']='No Checkout';
          break;
        default:
          $data['reservations'] = $this->ReservationsModel->getReservationsALL($dated,$datef);
          $data['type']='';
          break;
      }
      $html = $this->load->view('pdfListReservations',$data, true);

      $this->load->library('pdf');
                          
      $this->dompdf->loadHtml($html);
                          
      $this->dompdf->setPaper('A4', 'portrait');

                          
      $this->dompdf->render();

      $font = $this->dompdf->getFontMetrics()->get_font("lato-semibolditalic");

      $this->dompdf->getCanvas()->page_text(35, 800, "RESIDENCE HOTEL EZZAHIA ".date('d/m/Y'), $font, 8, array(0,0,0));
      
      $this->dompdf->getCanvas()->page_text(545, 800,"{PAGE_NUM}/{PAGE_COUNT}", $font, 8, array(0,0,0));


      $this->dompdf->stream("Reservation.pdf", array("Attachment"=>0));


    }
  }

  public function printReservation($idReservation = 0)
  {

    $id = $this->session->userdata('id');
    if(!$id){
      $this->load->view('login');
    }else{


        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 
        $data['dateCloture'] = $dateCloture; 

        $data['reservation'] = $this->ReservationsModel->getReservation($idReservation);


        if($data['reservation']){

            $data['client'] = $this->ReservationsModel->getReservationClient($data['reservation']->idCardex);

            $data['chambres'] = $this->ReservationsModel->getReservationRoomsL($idReservation);

            foreach ($data['chambres'] as $key => $ch) {
                
                $dates = $this->ReservationsModel->getDatesChambreRes($ch['idCR']);
                $data['chambres'][$key]['dates'] = $dates;
            }
            $data['extras'] = $this->ReservationsModel->getExtraChambre($idReservation);

            foreach ($data['extras'] as $key => $extra) {
              $data['extras'][$key]['dates'] = $this->ReservationsModel->getDatesExtraChambre($extra['idExtraRes']);
            }

            $data['chambresr'] = $this->ReservationsModel->getReservationRoomsR($idReservation);
            
            //$data['reglements'] = $this->ReglementsModel->getReglement($idReservation);

            $data['pays'] = $this->ReservationsModel->getPays($data['client']->idPays);

            $data['codePays'] = $data['client']->idPays;

            $data['payys'] = $this->HotelModel->getPays();

            $data['tarifs'] = $this->TarifsModel->getTarifUnique();

            $data['tchambres'] = $this->ChambresModel->getTypesChambres();

            $data['Aextras'] = $this->ExtrasModel->getExtras();

            $data['modePaiements'] = $this->ReservationsModel->getModePaiements();

            $data['taxes'] = $this->HotelModel->getTaxes();

            $data['date'] = new DateTime($data['reservation']->completedAt);

            $data['pensions'] = $this->PensionsModel->getPensions();

            $data['clients'] = $this->ReservationsModel->getCardex();

            $data['channels'] = $this->ClientsModel->getClients();


            $data['date']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $data['today'] = new DateTime(date('Y-m-d H:m:s'));

            $data['today']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $checkin = true;

            foreach ($data['chambresr'] as $key => $chambre) {

              if($chambre['idChambres'] == 0){

                $checkin = false;

              }
            }

            $footer['title'] = 'Reservations';

            $header['title'] ="Reservations";

            $header['page'] ="Reservations";

            $header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

            $data['dateC'] = $dateCloture;

            $footer['title'] = 'Reservations';

            $header['hotel'] = $this->session->userdata('agence');

            $header['nom'] = $this->session->userdata('nom');

            $data['date']->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $data['today'] = new DateTime(date('Y-m-d H:m:s'));
            $data['today']->setTimezone(new DateTimeZone('Africa/Casablanca'));
            $data['checkin'] = true;
            $data['closed'] = true;
            $chambresr = $this->ReservationsModel->getReservationRoomsR($idReservation);
            foreach ($chambresr as $key => $chambre) {

              if($chambre['idChambres'] == 0){

                $data['checkin'] = false;

              }
              if(!$chambre['isCheckout'] && !$chambre['isNoshow']){

                $data['closed'] = false;

              }

            }


          $html = $this->load->view('pdfReservation',$data, true);

          // Load pdf library
          $this->load->library('pdf');
                          
          // Load HTML content
          $this->dompdf->loadHtml($html);
                          
          // (Optional) Setup the paper size and orientation
          $this->dompdf->setPaper('A4', 'portrait');
                          
          // Render the HTML as PDF
          $this->dompdf->render();
                          
          // Output the generated PDF (1 = download and 0 = preview)
          $this->dompdf->stream("Reservation.pdf", array("Attachment"=>0));


      }else{

          $this->index();

      }
    }
  }

  public function setCheckinRoom()
  {
      $id = $this->session->userdata('id');
      if(!$id){
          $results = array('status'=>true,'session'=>false);
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{

          $idReservation = $this->input->post('idReservation');
          $idCR = $this->input->post('idCR');
          $idChambre = $this->input->post('idChambre');
          $modal = $this->input->post('modal');

          if($this->ReservationsModel->setCheckinAffectation($idReservation,$idCR,$idChambre,$id)){
            if($modal){

              $results = $this->getContentReservation($idReservation);

            }else{
              $results = $this->contentReservationP($idReservation);
            }
            
            echo json_encode(( $this->utf8ize( $results ) ));
          }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
          } 
      }
  }

  public  function delogerRoomP()
  {
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $idReservation = $this->input->post('idReservation');
        $idCR = $this->input->post('idCR');
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 
        $date = date('Y-m-d',strtotime($dateCloture));
        $ch = $this->input->post('ch');
        $modal = $this->input->post('modal');

        if($this->ReservationsModel->setDelogerRoom($idReservation,$idCR,$date,$ch,$id)){
          if($modal){

            $results = $this->getContentReservation($idReservation);

          }else{
            $results = $this->contentReservationP($idReservation);
          }
          
          echo json_encode(( $this->utf8ize( $results ) ));
        }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        } 
    }
  }

  private function highlightWords($text, $word){
    $text = preg_replace('#'. preg_quote($word) .'#i', '<span style="font-weight:800;color:#dd0606">\\0</span>', $text);
    return $text;
  }

  private function filterJson($reservations,$highlight = '')
  {
      $data_reservation = array();
      $cloture = $this->HotelModel->getCloture();
      $dateC = $cloture->dateCloture; 
      foreach ($reservations as $key => $reservation) {
        $dateDu = new DateTime($reservation['dateDu']);
        $dateAu = new DateTime($reservation['dateAu']);
        $date = new DateTime($reservation['updatedAt']);
        $date->setTimezone(new DateTimeZone('Africa/Casablanca')); 
        setlocale(LC_TIME, "fr_FR");
        $this->hashids->setSalt('Hexa2K20Pms');
        $this->hashids->setMinHashLength(32);


        if ($reservation['isNoshow']){
          $etat = '<span class="noshow">'.$this->getEtatList('noshow').'</span>';
        } elseif($reservation['isCheckout']){
          $etat = '<span class="checkout">'.$this->getEtatList('checkout').'</span>';
        } elseif($reservation['isCheckin']){
          $etat = '<span class="checkin">'.$this->getEtatList('checkin').'</span>';
        }else{
          $etat = '<span class="'. $reservation['etat'] .'">'.$this->getEtatList($reservation['etat']).'</span>';
        }

        $operations = '<a class="hexa_link" href="'.base_url().'details/'.$this->hashids->encode($reservation['idReservation']).'"  target="_blank"> <span onclick="" class="fa-stack operationCh"> <i class="fas fa-square fa-stack-2x clickable"></i> <i data-toggle="tooltip" data-placement="top" title="Details reservation"  class="fa fa-external-link-alt fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span> </a>';
        if (!$reservation['isCanceled']) {
          if(!$reservation['isCheckout']){
            if (!$reservation['isNoshow']){
              if ($dateC == $reservation['dateAu']){
                if (number_format(($reservation['taxTotal']+$reservation['totalHT']),2) == number_format($reservation['totalPaye'],2)){

                  $operations .= '<span  onclick="detailsReservation('.$reservation['idReservation'].')" class="fa-stack operationCh"> <i class="fas fa-square fa-stack-2x clickable"></i> <i data-toggle="tooltip" data-placement="top" title="Checkout" class="fa fa-arrow-up fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span>';

                }else{

                  $operations .= '<span onclick="detailsReservation('.$reservation['idReservation'].')" class="fa-stack operationCh"> <i class="fas fa-square fa-stack-2x clickable"></i> <i data-toggle="tooltip" data-placement="top" title="Facture" class="fa fa-receipt fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span>';

                }
              }
            }
          }          
        }



        if (!$reservation['isCanceled']) {
          if(!$reservation['isCheckin']){
            if (!$reservation['isNoshow']){
              if ($dateC == $reservation['dateDu']){

                $operations .= '<span  onclick="detailsReservation('.$reservation['idReservation'].')" class="fa-stack operationCh"> <i class="fas fa-square fa-stack-2x clickable"></i> <i data-toggle="tooltip" data-placement="top" title="Checkin" class="fa fa-arrow-down fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span>';
                      
              }
            }
          } 
        }
        array_push($data_reservation,array('param1'=>$etat, 'param2'=>'<span class="hexa-nom-client">'.$this->highlightWords($reservation['client'], $highlight).'</span>', 'param3'=>'<span class="channel">'.$reservation['channel'].'</span> <span class="idRes">#'.$this->highlightWords($reservation['providerId'], $highlight) .'</span>', 'param4'=>'<span class="hexa-date-check">'.$dateDu->format('d/m/Y').'</span>', 'param5'=>'<span class="hexa-date-check">'.$dateAu->format('d/m/Y').'</span>', 'param6'=>number_format(($reservation['taxTotal']+$reservation['totalHT']) * 1/$reservation['changeRate'],2), 'param7'=>number_format($reservation['totalPaye'] * 1/$reservation['changeRate'],2), 'param8'=>'<span class="hexa-date-reserver">'.utf8_encode(strftime("%d %B %G",strtotime($date->format('d-m-Y')))).' '.$date->format('H:i').'</span>', 'param9'=>$operations)); 
      }
      return $results = array('status'=>true,'session'=>true,'data'=>$data_reservation);
  }

  public function addReservation(){

    $id = $this->session->userdata('id');
    if(!$id){
        $this->load->view('login');
    }else{

      $cloture = $this->HotelModel->getCloture();
      
      $dateCloture = $cloture->dateCloture; 

      $date = date('Y-m-d',strtotime($dateCloture));

      $data['clients'] = $this->ReservationsModel->getRCardex();

      $data['channels'] = $this->ClientsModel->getClients();

      $data['pays'] = $this->HotelModel->getPays();

      foreach ($data['channels'] as $key => $channel) {

         $data['channels'][$key]['tarifs'] = $this->TarifsModel->getTarifsChannel($channel['idChannel']);

         $data['channels'][$key]['chambres'] = $this->ChambresModel->getChannelsTypeChambres($channel['idChannel']);

      }

      $data['tarifs'] = $this->TarifsModel->getTarifUnique();

      $data['chambres'] = $this->ChambresModel->getTypesChambres();

      $data['Aextras'] = $this->ExtrasModel->getExtras();

      $data['modePaiements'] = $this->ReservationsModel->getModePaiements();

      $data['taxes'] = $this->HotelModel->getTaxes();

      $footer['title'] = 'Reservations';

      $header['title'] ="Reservations";

      $header['page'] ="Reservations";

      $header['hotel'] = $this->session->userdata('hotel');

      $header['nom'] = $this->session->userdata('nom');

      $header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

      $data['dateC'] = $dateCloture;

      $this->load->view('templates/header',$header);
      $this->load->view('createReservation',$data);
      $this->load->view('templates/footer',$footer);

    }
  }

  public function editRoomPension(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $idReservation = $this->input->post('idReservation');
        $idCR = $this->input->post('idCR');
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 
        $date = date('Y-m-d',strtotime($dateCloture));

        $idPen = $this->input->post('idPen');
        $prix = $this->input->post('prix');
        $var = $this->input->post('date');

        $date = str_replace('/', '-', $var);
        $date = date('Y-m-d', strtotime($date));

        $updatedAt = date('Y-m-d H:i:sa'); 

        if($this->ReservationsModel->seteditRoomPension($idReservation,$idCR,$date,$idPen,$prix,$updatedAt,$id)){
          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));
        }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        } 
    }  
  }

  public function editRoomPensionDate(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $idReservation = $this->input->post('idReservation');
        $idCR = $this->input->post('idCR');
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 
        $date = date('Y-m-d',strtotime($dateCloture));

        $idPen = $this->input->post('idPen');
        $prix = $this->input->post('prix');
        $var = $this->input->post('date');

        $date = str_replace('/', '-', $var);
        $date = date('Y-m-d', strtotime($date));

        $updatedAt = date('Y-m-d H:i:sa'); 

        if($this->ReservationsModel->seteditRoomPensionDate($idReservation,$idCR,$date,$idPen,$prix,$updatedAt,$id)){
          $results = $this->contentReservationP($idReservation);
          echo json_encode(( $this->utf8ize( $results ) ));
        }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
        } 
    }  
  }

  public function addNewReservationPMS(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $dateReserve = date('Y-m-d H:i:sa');

        $cancel_reason = '';

        $channel = $this->input->post('codeAgence');
        $channel_display = $this->input->post('agence');


        $checkin_date = $this->input->post('dateDu');
        $checkout_date = $this->input->post('dateAu');

        // $provider_number = $this->input->post('ref');
        // $bonc = $this->input->post('bonc');
        $note = $this->input->post('notes');
        $nom = $this->input->post('res_client');
        $tel = $this->input->post('tel');
        $rooms = $this->input->post('rooms');

        $total = 0;
        $totalch = 0;

        $data_cli = $this->input->post('data_cli'); 
        $email = $this->input->post('email');
        $adresse = $this->input->post('adresse');
        $ville = $this->input->post('ville');
        $idPays = $this->input->post('nationalite');

        $payment = 'not_provided';

        $reason = 'confirm';
        $state = 'confirmed';
        $modified = false;
        $currency = 'MAD';
        $paid_amount = 0;

        $sub_total = $total;
        $tax_total = 0;
        $adjustments_total = 0;
        $extras_total = 0;

        $adult = 0;
        $enfant = 0;
        $total_guests = 0;

        $provider_number = 'hexa-'.time();

        if(isset($rooms)==0){ print json_encode(array('status'=>false,'session'=>true)); return;}

        if(count($rooms)==0){ print json_encode(array('status'=>false,'session'=>true)); return;}


        foreach ($rooms as $key => $room) {


          $earlier = new DateTime($checkin_date);
          $later = new DateTime($checkout_date);


          $nights = $later->diff($earlier)->format("%a");

          $nightss = (int)$later->diff($earlier)->format("%r%a");

          if($nightss>=0){ print json_encode(array('status'=>true,'session'=>true,'dates'=>false)); return; }

          $adult += $room['adult_res'];
          $enfant += $room['child_res'];
          $total_guests += $adult +  $enfant;
          $res_tar = $room['pension_res'];
          $res_ch = $room['chambre_res'];
          $rooms[$key]['nights'] = $nights;
          $dates = $this->TarifsModel->getDatesPrixTarif($res_tar,$res_ch,$checkin_date,$checkout_date);


          if(count($dates)==0){ print json_encode(array('status'=>true,'session'=>true,'dates'=>true,'disponibilite'=>false)); return;}

          if(count($dates)<$nights){ print json_encode(array('status'=>true,'session'=>true,'dates'=>true,'disponibilite'=>false)); return; }

          $rooms[$key]['totalch'] = 0;
          $rooms[$key]['dates'] = $dates;

          foreach ($dates as $keyy => $date) {
            //echo $date['date'].' : '.$date['prix'].' : '.$date['idChannelTarif'];

            if($room['prix_res']>0){
                $rooms[$key]['dates'][$keyy]['prix'] = $room['prix_res'];
                $total +=  $room['prix_res'];
                $rooms[$key]['totalch'] +=  $room['prix_res'];
            }else{
                $total +=  $date['prix'];
                $rooms[$key]['totalch'] +=  $date['prix'];
                    
            }

            $rooms[$key]['idChanTarif'] = $date['idChannelTarif'];   
            
          }

        }
        // echo 'dadac';
        // print json_encode($rooms);
        // die;

        $total_rooms = count($rooms);

        // $idCardex = $this->ReservationsModel->insertCardex($adresse,$ville,$idPays,$email,$tel,$nom);
        $result = $this->ReservationsModel->insertReservation($provider_number,$provider_number, $channel,$channel_display,$reason,$state,$modified,$nom,$cancel_reason,$sub_total,$extras_total,$adjustments_total,$tax_total,$total,$currency,$note,$checkin_date,$checkout_date,$payment,$paid_amount,$dateReserve,$dateReserve,0,$total_guests,$total_rooms,'','','PMS',$rooms,$tel,$adresse,$ville,$idPays,$email,$id);

        if($result['status']){

          print json_encode(array('status'=>true,'session'=>true,'dates'=>true,'disponibilite'=>true,'idReservation'=>$result['idReservation']));

        }else{

          print json_encode(array('status'=>false,'session'=>true,'dates'=>true,'disponibilite'=>true));

        }

      }
    }


  public function process(){

      // This script will write numbers from 1 to 100 into file (whatever happens)
      // And sends continuously info to user
      // $fp = fopen( '/tmp/output.txt', 'w') or die('Failed to open');
      // set_time_limit( 120);
      // ignore_user_abort(true);

      // for( $i = 0; $i < 100; $i++){
      // ob_start();
      // session_start();
      // session_write_close();
      // $output = array();
      // for( $i = 0; $i < 100; $i++){
      //   $output['progress'] = 'vfsvs';
      //   sleep(2);
      // }
      // // $this->session->set_userdata('progress', 'administrateur');
      // echo json_encode($output);  
                // echo str_repeat( ' ', 2048);
                // flush();
                // ob_flush();
                // // sleep(1);
                // fwrite( $fp, "$i\n");
            // }

      // fclose( $fp);

     // header('Content-Type: text/html; charset=UTF-8');
     //  if (ob_get_level() == 0) ob_start();
     //  for ($i = 0; $i<10; $i++){
     //    echo "<br> Line to show.";
     //    echo str_pad('',4096)."\n";
     //    ob_flush();
     //    flush();
     //    sleep(2);
     //  }
     //  echo "Done.";
     //  ob_end_flush();
      header('Content-Type: text/event-stream');
      header('Cache-Control: no-cache'); 




      //LONG RUNNING TASK
       for($i = 1; $i <= 10; $i++) {
          $this->send_message($i, 'on iteration ' . $i . ' of 10' , $i*10); 

          sleep(1);
       }

      $this->send_message('CLOSE', 'Process complete');
  }

  private function send_message($id, $message, $progress) {
        $d = array('message' => $message , 'progress' => $progress); //prepare json

        echo "id: $id" . PHP_EOL;
        echo "data: " . json_encode($d) . PHP_EOL;
        echo PHP_EOL;

       ob_flush();
       flush();
  }


  public function addReservationExtraRoom(){
        $id = $this->session->userdata('id');
        if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
        }else{

          $idReservation = $this->input->post('idReservation'); 
          $idCR = $this->input->post('idCR'); 

          $idExtra = $this->input->post('idExtra'); 
          $personnes = $this->input->post('personnes'); 
          $prix = $this->input->post('prix'); 
          $dates = $this->input->post('dates');
          $updatedAt = date('Y-m-d H:i:sa'); 
          $modal = $this->input->post('modal');


          if($this->ReservationsModel->insertExtraReservationRoom($idReservation,$idCR,$idExtra,$personnes,$prix,$dates,$updatedAt,$id)){
            
            if($modal){
              $results = $this->getContentReservation($idReservation);

            }else{
              $results = $this->contentReservationP($idReservation);
            }
            echo json_encode(( $this->utf8ize( $results ) ));
          }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
          } 


        }
  }

  public function addReservationExtra(){
        $id = $this->session->userdata('id');
        if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
        }else{


          $idReservation = $this->input->post('idReservation'); 
          $idExtra = $this->input->post('idExtra'); 
          $personnes = $this->input->post('personnes'); 
          $prix = $this->input->post('prix'); 
          $dates = $this->input->post('dates');
          $updatedAt = date('Y-m-d H:i:sa'); 
          $modal = $this->input->post('modal');


          if($this->ReservationsModel->insertExtraReservation($idReservation,$idExtra,$personnes,$prix,$dates,$updatedAt,$id)){
            if($modal){
              $results = $this->getContentReservation($idReservation);

            }else{
              $results = $this->contentReservationP($idReservation);
            }
            echo json_encode(( $this->utf8ize( $results ) ));
          }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
          } 


        }
  }


  public function addRoomReservationExtra(){
        $id = $this->session->userdata('id');
        if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
        }else{

          $idReservation = $this->input->post('idReservation'); 
          $idCR = $this->input->post('idCR'); 
          $idExtra = $this->input->post('idExtra'); 
          $personnes = $this->input->post('personnes'); 
          $prix = $this->input->post('prix'); 
          $dates = $this->input->post('dates'); 
          $updatedAt = date('Y-m-d H:i:sa');


          if($this->ReservationsModel->insertExtraRoomReservation($idReservation,$idCR,$idExtra,$personnes,$prix,$dates,$updatedAt)){
            $results = $this->getContentReservation($idReservation);
            echo json_encode(( $this->utf8ize( $results ) ));
          }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
          } 


        }
  }
    

  public function addRoomReservation(){

      $id = $this->session->userdata('id');
      if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
      }else{

        $updatedAt = date('Y-m-d H:i:sa');

        $checkin_date = $this->input->post('dateDu');
        $checkout_date = $this->input->post('dateAu');
        // die;
        //$idCR = $this->input->post('idCR');

        $idReservation = $this->input->post('idReservation');

        $modal = $this->input->post('modal');

        $res_ch = $this->input->post('typeChambre');

        $res_tar = $this->input->post('pension');

        $adult = $this->input->post('totalAdult');

        $child = $this->input->post('totalEnfant');

        $room = $this->ReservationsModel->getReservationD($idReservation);

        if(count($room)==0){ print json_encode(array('status'=>false,'session'=>true)); return;}

        $earlier = new DateTime($checkin_date);
        $later = new DateTime($checkout_date);


        $nights = $later->diff($earlier)->format("%a");

        $nights = $nights;
        $dates = $this->TarifsModel->getDatesPrixTarif($res_tar,$res_ch,$checkin_date,$checkout_date);

        if(count($dates)==0){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return;}

        if(count($dates)<$nights){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return; }
        $totalch = 0;
        $room[0]['dates'] = $dates;

        foreach ($dates as $keyy => $date) {

          $room[0]['dates'][$keyy]['prix'] =  $date['prix']*$room[0]['changeRate'];

          $totalch +=  $date['prix'];
          $idChanTarif = $date['idChannelTarif'];

        }

        if($checkout_date>$room[0]['dateAu']){

          $dateAu = $checkout_date;

        }else{
          $dateAu = $room[0]['dateAu'];
        }

        if($checkin_date<$room[0]['dateDu']){
          $dateDu = $checkin_date;

        }else{
          $dateDu = $room[0]['dateDu'];
        }

        $client = $room[0]['client'];

        $isCheckin = false;

        $idChambres = 0;

        $total = $room[0]['Total'] + $totalch;
        $sousTotal = $room[0]['sousTotal'] + $totalch;

        $providerId = $room[0]['providerId'];

        $prix = $totalch;


        $total_guests = $room[0]['total_guests']+$adult+$child;
        $total_rooms = $room[0]['total_rooms']+1;

        if($this->ReservationsModel->isertRoomToReservation($idReservation,'modify','confirmed',true,$sousTotal,$total,$dateDu,$dateAu,$updatedAt,$dates,$adult,$child,$totalch,$nights,$idChanTarif,$client,$isCheckin,$prix,$idChambres,$providerId,$checkin_date,$checkout_date,$total_guests,$total_rooms,$id)){

           setlocale(LC_TIME, "fr_FR"); 

          if($modal){

            $results = $this->getContentReservation($idReservation);

          }else{
            $results = $this->contentReservationP($idReservation);
          }
           echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          print json_encode(array('status'=>false,'session'=>true,'disponibilite'=>true));

        }

    }

  }

  public function updateNewRoomReservation(){

      $id = $this->session->userdata('id');
      if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
      }else{

        $updatedAt = date('Y-m-d H:i:sa');

        $checkin_date = $this->input->post('dateDu');
        $checkout_date = $this->input->post('dateAu');
        $idCR = $this->input->post('idCR');
        $adults = $this->input->post('adults');
        $enfants = $this->input->post('enfants');

        $idReservation = $this->input->post('idReservation');

        $modal = $this->input->post('modal');

        $rooms = $this->ReservationsModel->getRoomReservationD($idCR);

        if(count($rooms)==0){ print json_encode(array('status'=>false,'session'=>true)); return;}

        $res_ch = $rooms[0]['idTypeChambres'];
        $res_tar = $rooms[0]['idDetTar'];

        $rooms[0]['adult'] = $adults;
        $rooms[0]['child'] = $enfants;


        $adult = $adults;

        $child = $enfants;

        $earlier = new DateTime($checkin_date);
        $later = new DateTime($checkout_date);


        $nights = $later->diff($earlier)->format("%a");

        $nights = $nights;
        $dates = $this->TarifsModel->getDatesPrixTarif($res_tar,$res_ch,$checkin_date,$checkout_date);

        if(count($dates)==0){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return;}

        if(count($dates)<$nights){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return; }
        $totalch = 0;
        

        foreach ($dates as $keyy => $date) {

          $rooms[0]['dates'][$keyy]['prix'] =  $date['prix']*$rooms[0]['changeRate'];

          $totalch +=  $date['prix'];
          $rooms[0]['idChanTarif'] = $date['idChannelTarif'];

        }


        $dateAu = ($checkout_date>$rooms[0]['dateAu']) ? $checkout_date : $rooms[0]['dateAu'];

        $dateDu = ($checkin_date<$rooms[0]['dateDu']) ? $checkin_date : $rooms[0]['dateDu'];



        $client = $rooms[0]['client'];

        $isCheckin = $rooms[0]['isCheckin'];

        $idChambres = $rooms[0]['idChambres'];

        $total = $rooms[0]['Total'] - $rooms[0]['prix'];
        $sousTotal = $rooms[0]['sousTotal'] - $rooms[0]['prix'];

        $total = $total + $totalch;
        $sousTotal = $sousTotal + $totalch;

        $providerId = $rooms[0]['providerId'];

        $rooms[0]['dates'] = $dates;

        $rooms[0]['dateDu'] = $dateDu;
        $rooms[0]['dateAu'] = $dateAu;  

        $rooms[0]['nights'] = $nights; 
        $rooms[0]['totalch'] = $totalch;   


        if($this->ReservationsModel->updateRoomDate($idReservation,$idCR,'modify','confirmed',true,$sousTotal,$total,$dateDu,$dateAu,$updatedAt,$client,$rooms,$checkin_date,$checkout_date,$id)){

           setlocale(LC_TIME, "fr_FR"); 

           if($modal){
              $results = $this->getContentReservation($idReservation);
           }else{

              $results = $this->contentReservationP($idReservation);

           }

           
           echo json_encode(( $this->utf8ize( $results ) ));

        }else{

          print json_encode(array('status'=>false,'session'=>true,'disponibilite'=>true));

        }

    }

  }

  public function updateRReservation(){

        $id = $this->session->userdata('id');
        if(!$id){
            $results = array('status'=>true,'session'=>false);
            echo json_encode(( $this->utf8ize( $results ) ));
        }else{

          $updatedAt = date('Y-m-d H:i:sa');

          $idReservation = $this->input->post('idReservation');

          $checkin_date = $this->input->post('dateDu');
          $checkout_date = $this->input->post('dateAu');

          $res_client = $this->input->post('res_client');

          $data_cli = $this->input->post('data_cli');
          $tel = $this->input->post('tel');
          $email = $this->input->post('email');
          $adresse = $this->input->post('adresse');
          $ville = $this->input->post('ville');
          $nationalite = $this->input->post('nationalite');
          $notes = $this->input->post('notes');

          $rooms = $this->ReservationsModel->getRoomReservationALL($idReservation);

          if(count($rooms)==0){ print json_encode(array('status'=>false,'session'=>true)); return;}


            $sousTotal = 0;
            $total = 0;

          if(($checkin_date != $rooms[0]['dateDu']) || ($checkout_date  != $rooms[0]['dateAu'] )){

            $earlier = new DateTime($checkin_date);

            $later = new DateTime($checkout_date);

            $nights = $later->diff($earlier)->format("%a");

            foreach ($rooms as $key => $room) {

              $rooms[$key]['nights'] = $nights;

              $dates = $this->TarifsModel->getDatesPrixTarif($room['idDetTar'],$room['idTypeChambres'],$checkin_date,$checkout_date);

              if(count($dates)==0){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return;}

              if(count($dates)<$nights){ print json_encode(array('status'=>true,'session'=>true,'disponibilite'=>false)); return; }

              $totalch = 0;
              

              foreach ($dates as $keyy => $date) {

                $totalch +=  $date['prix'];
                $idChanTarif = $date['idChannelTarif'];
                $rooms[$key]['idChannelTarif'] = $date['idChannelTarif'];

              } 

              $rooms[$key]['dates'] = $dates;

              $rooms[$key]['dateDu'] = $checkin_date;
              $rooms[$key]['dateAu']=$checkout_date;

              $total = $total + $totalch;

              $sousTotal = $sousTotal + $totalch;

              $rooms[$key]['totalch'] = $totalch;      

            }

          }else{
            $rooms=array();
          }



          if($this->ReservationsModel->updateReservation($idReservation,'modify','confirmed',true,$sousTotal,$total,$checkin_date,$checkout_date ,$updatedAt,$rooms,$res_client ,$data_cli ,$tel ,$email ,$adresse ,$ville ,$nationalite ,$notes,$id)){
             setlocale(LC_TIME, "fr_FR"); 

             $results = $this->contentReservationP($idReservation);
             echo json_encode(( $this->utf8ize( $results ) ));

          }else{

            print json_encode(array('status'=>false,'session'=>true,'disponibilite'=>true));

          }

      }
  }


  private function getContentReservation($idReservation){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

          $cloture = $this->HotelModel->getCloture();

          $dateCloture = $cloture->dateCloture; 

          $reservation = $this->ReservationsModel->getReservation($idReservation);

          if($reservation){

            $client = $this->ReservationsModel->getReservationClient($reservation->idCardex);

            $chambres = $this->ReservationsModel->getReservationRoomsL($idReservation);

            $factureChambre=false;

            $factureExtra=false;

            $totalRegle = $this->ReservationsModel->getFacturesRegele($idReservation);

            $extras = $this->ReservationsModel->getExtraChambre($idReservation);

            foreach ($extras as $key => $extra) {
              if($extra['idFactureP']==0){
                $factureExtra=true;
              }              
              $extras[$key]['dates'] = $this->ReservationsModel->getDatesExtraChambre($extra['idExtraRes']);
            }

            $chambresr = $this->ReservationsModel->getReservationRoomsR($idReservation);

            //$reglements = $this->ReglementsModel->getReglement($idReservation);

            $pays = $this->ReservationsModel->getPays($client->idPays);

            $tarifs = $this->TarifsModel->getTarifUnique();

            $tchambres = $this->ChambresModel->getTypesChambres();

            $Aextras = $this->ExtrasModel->getExtras();

            $modePaiements = $this->ReservationsModel->getModePaiements();

            $chambreLibres = $this->ReservationsModel->getTousChambresLibre($dateCloture,$reservation->dateAu);

            $taxes = $this->HotelModel->getTaxes();

            $date = new DateTime($reservation->completedAt);

            $pensions = $this->PensionsModel->getPensions();

            $date->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $today = new DateTime(date('Y-m-d H:m:s'));
            $today->setTimezone(new DateTimeZone('Africa/Casablanca'));
            $checkin = true;
            $closed = true;
            foreach ($chambresr as $key => $chambre) {

              if($chambre['idChambres'] == 0){

                $checkin = false;

              }
              if(!$chambre['isCheckout'] && !$chambre['isNoshow']){

                $closed = false;

              }
            }
            $updatedAt = new DateTime($reservation->updatedAt);
            $updatedAt->setTimezone(new DateTimeZone('Africa/Casablanca')); 
            setlocale(LC_TIME, "fr_FR");
            $updatedAt = utf8_encode(strftime("%A %d %B %G",strtotime($updatedAt->format('d-m-Y')))).' '.$updatedAt->format('H:i');

            $checkin = false;
            $checking = true;
            $lastElementKey = count($chambres)-1;

            foreach ($chambres as $key => $chambre) {

              if($chambre['idFactureP']==0){
                $factureChambre=true;
              }

              $chambres[$key]['dates']   = $this->ReservationsModel->getDatesChambreRes($chambre['idCR']);

              if($chambres[0]['dateDu'] != $chambre['dateDu']){

                $checking = false;

              }

              if(!$chambre['isCheckin']){

                $checkin = true;

              }
  
              if($key == $lastElementKey) break;

              if(!$chambre['isCanceled']){

                if($chambre['dateDu'] != $chambres[$key+1]['dateDu']){

                    $dateDu = true;

                }
                if($chambre['dateAu'] != $chambres[$key+1]['dateAu']){

                    $dateAu = true;

                }

              }

            }

          $activites = $this->ReservationsModel->getActiviteReservation($idReservation);
          $factures = $this->ReservationsModel->getFactures($idReservation);

          foreach ($factures as $key => $facture) {

              $factures[$key]['modePaiement'] =$this->ReservationsModel->getReglements($facture['idFacture']);
              
          }

            $html_reservation ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-size: 24px;color: #011F28;font-weight: 800;font-style:italic;">#'.$reservation->idReservation.'</span> </div> <div class="col-1 title-close text-right"> <button style="font-size:24px;padding-right:4px" type="button" class="close" data-dismiss="modal" aria-label="Close"><i  style="font-size:24px;" class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6" style=";line-height: 2px"> <span style="color:#8A8E94;font-size:14px">'.$reservation->channelDisplay.'</span> </div> <div class="col-6 float-right"> </div>
            <div class="col-6 hexa-margin-25"> 

                <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>

            </div> 
            <div id="buttonGroupOp" class="col-6" style="padding-bottom: 10px;padding-top: 10px"> <div class="form-row float-right">';





              if (!$reservation->isCanceled && !$closed) {

                if(!$reservation->isCheckout){

                  $html_reservation .='<button type="button" onclick="editReservation(this,'.$reservation->idReservation.')" class="btn btn-info float-right btn-reservation-modal"><i class="fa fa-pen" style="font-size: 12px"></i> Modifier</button>';
                  $html_reservation .='<button type="button" onclick="cancelReservation('.$reservation->idReservation.')" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-times" style="font-size: 12px"></i> Annuler</button>'; 
                }          
              }



              $html_reservation .= '<a target=”_blank” href="'.base_url().'imprimer/'.$reservation->idReservation.'">
                                                <button type="button" class="btn btn-secondary float-right btn-reservation-modal"> <i class="fa fa-print" style="font-size: 10px"></i> Imprimer </button></a> </div> </div> </div> </div> <div  class="hexa-hide" id="ReservationConfirmCancel"></div>


                    <div id="body-reservation" >
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Etat <span class="text-labb">'.$this->getEtat($reservation->etat).'</span></span> 
                                                <span class="title-lab">Arrivee <span class="text-labb">
                                                        '.utf8_encode(strftime("%d %B %G", strtotime($reservation->dateDu))).'</span></span> 
                                                <span class="title-lab">Depart <span class="text-labb">
                                                        '.utf8_encode(strftime("%d %B %G", strtotime($reservation->dateAu))).'</span></span> 
                                                <span class="title-lab">Nombre de chambre <span class="text-labb">
                                                        '.$reservation->total_rooms.'</span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Source <span class="text-labb">
                                                        '.$reservation->channelDisplay.'</span></span> 
                                                <span class="title-lab">Référence <span class="text-labb">#'.$reservation->providerId.'</span></span> 
                                                <span class="title-lab">Type <span class="text-labb">Internet</span></span> 
                                                <span class="title-lab">Nombre de pax <span class="text-labb">
                                                        '.$reservation->total_guests.'</span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Client <span class="text-labb">
                                                        '.$client->nom.'</span></span> 
                                                <span class="title-lab">Telephone <span class="text-labb">
                                                        '.$client->tel.'</span></span> 
                                                <span class="title-lab">Email <span class="text-labb">
                                                        '.$client->email.'</span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Pays <span class="text-labb">
                                                        '.$pays.'</span></span> 
                                                <span class="title-lab">Ville <span class="text-labb">
                                                        '.$client->ville.'</span></span> 
                                                <span class="title-lab">Adresse <span class="text-labb">
                                                        '.$client->Adresse.'</span></span> 
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-12"> 
                                                <span class="title-lab">Remarques</span>
                                                <p class="text-remar">
                                                    '.$reservation->note.'
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>';







                $html_chambres ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-size: 24px;color: #011F28;font-weight: 800;font-style:italic;">#'.$reservation->idReservation.'</span> </div> <div class="col-1 title-close text-right"> <button style="font-size:24px;padding-right:4px" type="button" class="close" data-dismiss="modal" aria-label="Close"><i  style="font-size:24px;" class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6" style=";line-height: 2px"> <span style="color:#8A8E94;font-size:14px">'.$reservation->channelDisplay.'</span> </div> <div class="col-6 float-right"> </div>
            <div class="col-6 hexa-margin-25"> 

                <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>

            </div> 



             <div class="col-6" id="buttonGroupOpR" style="padding-bottom: 10px;padding-top: 10px"> <div class="form-row  float-right">';
                if((!$reservation->isCanceled) && (!$reservation->isNoshow) && (!$closed)) {
                    if(!$reservation->isCheckout){

                        $html_chambres .= '<button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChFormModal(this,'.$reservation->idReservation.')"><i class="fa fa-plus hexa-fs10"></i> Ajouter une chambre</button>';

                    }
                }

                $html_chambres .='</div></div></div></div>';
                            if (count($chambres) > 0){



                $html_chambres .= '<div class="body-content col-12 position-relative">

                                  <div class="form-row hexa-hide" id="formGroupCh"></div>

                                   <div class="row hexa-hide" id="affecterRoom"></div>';

                                    $html_chambres .= '<table id="TableRooms" width="100%" class="table" style="overflow: hidden !important">
                                        <thead class="hexa-header-reservation">
                                            <th width="20%">Type</th>
                                            <th width="5%"></th>
                                            <th class="text-center" width="10%">Chambre</th>
                                            <th class="text-center" width="10%">Etat</th>
                                            <th width="20%">Arrivee</th>
                                            <th width="10%">Pax</th>
                                            <th class="text-center" width="15%">Actions</th>
                                        </thead>
                                        <tbody>';
                                        foreach ($chambres as $indexCh => $chambre){

                                            $ch_number = '#';
                                            $html_chambres .= '<tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab">
                                                    '. $chambre['nomTypeChambres'].'</span><span class="text-labbb">
                                                    '. $chambre['pension'].'</span></td>

                                                <td  class="text-right">';

                                                if (count($chambre['dates']) > 0 && !$chambre['isCheckout']){

                                                  $html_chambres .= '<i class="fa fa-caret-down" for="ch'. $chambre['idCR'].'" data-toggle="collapse" href="#ch'. $chambre['idCR'].'" aria-expanded="true" aria-controls="ch'. $chambre['idCR'].'"></i>';
                                                }

                                                

                                                $html_chambres .= '</td><td class="ty-chambre text-center hexa-td">';

                                                    if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])){
                                                      if ($chambre['idChambres'] == 0){

                                                        $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'. $ch_number.'</span>';
                                                      
                                                      }else{
                                                          $ch_number = $chambre['nomChambre'];
                                                          $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'. $ch_number.'</span>';
                                                      }
                                                    }else{
                                                        $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'. $ch_number.'</span>';
                                                    } 
                                               $html_chambres .= '</td>
                                                <td class="ty-chambre text-center hexa-td">
                                                    <span class="text-lab ">';
                                                          if ($chambre['isNoshow']){
                                                            $ett =  $this->getEtatCh('noshow');
                                                          }elseif($chambre['isCheckout']){
                                                            $ett =  $this->getEtatCh('checkout');
                                                          }elseif($chambre['isCheckin']){
                                                            $ett =  $this->getEtatCh('checkin');
                                                          }else{
                                                            $ett =  $this->getEtatCh($chambre['etat']);
                                                          }
                                                    $html_chambres .= $ett.'

                                                    </span>
                                                </td>

                                                <td class="hexa-td"><span class="text-lab">
                                                        '. utf8_encode(strftime("%d %b", strtotime($chambre['dateDu']))) . ' - ' . utf8_encode(strftime("%d %b %G", strtotime($chambre['dateAu']))).'</span><span class="text-labbb">
                                                        '. $chambre['nuites'].' nuits</span></td>
                                                <td class="hexa-td">
                                                    <span class="text-lab">'. $chambre['totalAdult'].' Adult</span>
                                                    <span class="text-labbb">'. $chambre['totalEnfant'].' Enfant</span>
                                                </td>
                                                <td class="text-center hexa-td">';
                                                    if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])){
                                                        if (!$chambre['isCheckin']){
                                                          if ($chambre['dateDu'] == $dateCloture){
                                                                $html_chambres .= '<span onClick="checkinRoomPModel(this,'. $reservation->idReservation.','. $chambre['idCR'].')" class="fa-stack operationCh">
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-arrow-down fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span>'; 
                                                            }

                                                            $html_chambres .= '<span onclick="editRoomReservationP(this,'. $reservation->idReservation.','. $chambre['idCR'].',\''. $chambre['dateDu'] .'\',\''. $chambre['dateAu'] .'\',false,'.$chambre['totalAdult'].','.$chambre['totalEnfant'].')" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 11px"></i>
                                                            </span>
                                                            <span onclick="cancelRoomP('. $reservation->idReservation .','. $chambre['idCR'].')" class="fa-stack operationCh">
                                                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                <i class="fa fa-times fa-stack-1x fa-inverse action" style="font-size: 14px"></i>
                                                            </span>';
                                                        }elseif(!$chambre['isCheckout']){
                                                          if($dateCloture < $chambre['dateAu']){
                                                            $html_chambres .= '<span onclick="delogerRoomPModal(this,'. $reservation->idReservation.','. $chambre['idCR'].')" class="fa-stack operationCh">
                                                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                <i class="fa fa-exchange-alt fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                            </span>';
                                                          }
                                                            
                                                          $html_chambres .= '<span onclick="editRoomReservationP(this,'. $reservation->idReservation.','. $chambre['idCR'].',\''. $chambre['dateDu'] .'\',\''. $chambre['dateAu'] .'\',false,'.$chambre['totalAdult'].','.$chambre['totalEnfant'].')" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 11px"></i>
                                                            </span>';
                                                            if ($chambre['prix'] == $chambre['totalRegle']){
                                                                $html_chambres .= '<span onclick="checkoutPModel(this,'. $reservation->idReservation.','. $chambre['idCR'].')" class="fa-stack operationCh" > <i class="fas fa-square fa-stack-2x clickable"></i> <i class="fa fa-arrow-up fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span>'; 
                                                            }
                                                            

                                                        }

                                                    }
                                                $html_chambres .= '</td>
                                            </tr>';
                                            if (count($chambre['dates']) > 0 && !$chambre['isCheckout']){
                                                $html_chambres .= '<tr id="ch'. $chambre['idCR'].'" class="collapse" >
                                                <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="6">
                                                    <div class="scrollmenu">';
                                                        $chtotal = 0; 

                                                        foreach ($chambre['dates'] as $key => $dateR){
                                                          if ($dateR['date'] < $dateCloture || $chambre['isCanceled'] || $reservation->isCanceled || $reservation->isNoshow  || $chambre['isNoshow']){
                                                            $html_chambres .= '<div class="text-con old-room" style="width: 100px;"><span class="text-datee text-center" style="color:#948994!important">
                                                                    '. strftime("%d/%m/%G", strtotime($dateR['date'])).'</span>
                                                                <span class="text-prix text-center">
                                                                    '. number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '').'</span></div>';
                                                          
                                                        }else{

                                                          $html_chambres .= '<div onclick="editRoomDatePension('. $dateR['idDCR'] .', '. $dateR['idCR'] .', '. $reservation->idReservation .', '. $dateR['idPension'] .', '. number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '') .', \''. $dateR['date'].'\', \''. $chambre['nomTypeChambres'] .'\', \''. $chambre['pension'] .'\', \''. $ch_number .'\', \''. htmlspecialchars($ett) .'\', \''. strftime("%d %b", strtotime($chambre['dateDu'])) . ' - ' . strftime("%d %b %G", strtotime($chambre['dateAu'])) .'\', \''. $chambre['nuites'] .' nuits\''.', \''. $chambre['totalAdult'] .', Adult\''.', \''. $chambre['totalEnfant'] .' Enfant'.'\')"class="text-con" style="width: 100px;"><span class="text-datee text-center"> '. strftime("%d/%m/%G", strtotime($dateR['date'])) .'</span> <span class="text-prix text-center"> '. number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '') .'</span></div>'; 
                                                        }
                                                        $chtotal += $dateR['prix'];
                                                      }
                                                    $html_chambres .= '</div>
                                                </td>
                                                <td class="hexa-ch-total-td">
                                                    <span class="text-center hexa-ch-total">Total
                                                    </span>
                                                    <span class="text-center hexa-ch-total">
                                                        '. number_format($chtotal * 1 / $reservation->changeRate, 2, '.', '') .'
                                                    </span>
                                                </td>
                                            </tr>';
                                            }
                                          }
                $html_chambres .='</tbody></table>';



                $html_chambres .='<div class="form-row hexa-hide" id="RoomEditor"></div>

                                <div class="row hexa-hide" id="delogerRoom"></div> 
                                <div class="row hexa-hide" id="editChambrePension">
                                    <div class="col-12">
                                            <table width="100%" class="table">
                                                <thead class="hexa-header-reservation">
                                                    <th width="35%">Type</th>
                                                    <th class="text-center" width="10%">Chambre</th>
                                                    <th class="text-center" width="10%">Etat</th>
                                                    <th width="15%">Arrivee</th>
                                                    <th width="10%">Pax</th>
                                                    <th class="text-center" width="10%">Actions</th>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td class="ty-chambre hexa-td"><span class="text-lab" id="txt_ch_mod"></span><span class="text-labbb" id="txt_pen_mod"></span></td>
                                                        <td class="ty-chambre text-center hexa-td" id="txt_ch_sel_mod"></td>
                                                        <td class="ty-chambre text-center hexa-td">
                                                            <span class="text-lab" id="txt_ch_etat_mod">
                                                            </span>
                                                        </td>

                                                        <td class="hexa-td"><span class="text-lab" id="txt_ch_dates_mod"></span><span class="text-labbb" id="txt_ch_nuit_mod"></span></td>
                                                        <td class="hexa-td">
                                                            <span class="text-lab" id="txt_ch_adult_mod"></span>
                                                            <span class="text-labbb" id="txt_ch_child_mod"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="6" style="background:#F6FAFB;">
                                                            <div id="room-pension-content" class="row" style="padding-top:15px;padding-bottom:15px">
                                                            </div>
                                                        </td>
                                                    
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <div class="form-row"> 
                                                <div class="form-group col-md-12">
                                                    <button type="button" onclick="appliquerEditRoomSejour()" class="btn btn-success btn-reservation-modal float-right">Appliquer sur le sejour</button>
                                                    <button type="button" onclick="appliquerEditRoom()" class="btn btn-success btn-reservation-modal float-right">Appliquer</button>
                                                    <button type="button" onclick="retourEditRoomDatePension()" class="btn btn-info btn-reservation-modal float-left">Retour </button> 
                                                </div>
                                            </div>
                                    </div>
                                </div>'; 
              }


              $html_extras ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-size: 24px;color: #011F28;font-weight: 800;font-style:italic;">#'.$reservation->idReservation.'</span> </div> <div class="col-1 title-close text-right"> <button style="font-size:24px;padding-right:4px" type="button" class="close" data-dismiss="modal" aria-label="Close"><i  style="font-size:24px;" class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6" style=";line-height: 2px"> <span style="color:#8A8E94;font-size:14px">'.$reservation->channelDisplay.'</span> </div> <div class="col-6 float-right"> </div> <div class="col-6 hexa-margin-25"> <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span> </div>





              <div class="col-12 col-md-6" id="buttonGroupOpEx" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">';
                                        if (!$reservation->isCanceled  && !$reservation->isNoshow && !$reservation->isCheckout){
                                          if (count($chambres)>0){
                                            $html_extras .= '<button type="button" id="btn-ajouterchch" class="btn btn-secondary float-right btn-reservation-modal" onclick="ajouterChExFormRoomModal(this,'.$reservation->idReservation.','.$chambres[0]['idCR'].')"><i class="fa fa-plus hexa-fs10"></i> Extra chambre</button>';
                                          }
                                            $html_extras .= '<button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChExFormModal(this,'.$reservation->idReservation.')"><i class="fa fa-plus hexa-fs10"></i> Extra reservation</button>';

                                        }
                                        $html_extras .= '</div>
                                    </div>
                                  </div> 
                                </div>

                                    <div class="body-content col-12 position-relative">
                                      <div id="formReservationEx" class="hexa-hide"></div>';

              $totalextra = 0;
              if(count($extras)>0){


                            
                                $html_extras .= '<table id="TableExtra" width="100%" class="table" style="overflow: hidden !important">
                                    <thead class="hexa-header-reservation">
                                        <th width="25%">Extra</th>
                                        <th width="5%"></th>
                                        <th class="text-center" width="10%">Type</th>
                                        <th class="text-center" width="10%">Personnes</th>
                                        <th class="text-center" width="10%">Dates</th>
                                        <th class="text-center" width="20%">Total</th>
                                        <th class="text-center" width="10%">Actions</th>
                                    </thead>
                                    <tbody>';
                                        foreach ($extras as $key => $extra){

                                          $totalextra +=$extra['prix'];

                                            $html_extras .= '<tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab">'.$extra['extraReservation'].'</span><span class="text-labbbb">';

                                                $type = ($extra['idDeduction']) ? 'Prestation' : 'Deduction' ;


                                                $html_extras .= $type.'</span>
                                                </td>
                                                <td  class="text-right">';
                                                if (count($extra['dates']) > 1){

                                                  $html_extras .= '<i class="fa fa-caret-down" for="ex'. $extra['idExtraRes'].'" data-toggle="collapse" href="#ex'. $extra['idExtraRes'].'" aria-expanded="true" aria-controls="ex'. $extra['idExtraRes'].'"></i>';

                                                
                                                }

                                                $html_extras .='</td><td class="ty-chambre hexa-td text-center"><span class="text-lab">';

                                                $retVal = ($extra['isReservation']) ? 'Reservation' : 'Chambre';
                                                $pax = (count($extra['dates'])>0) ? $extra['dates'][0]['pax'] : 'N/A';
                                                $date = (count($extra['dates'])>0) ? $extra['dates'][0]['date'] : 'N/A';

                                                $html_extras .= $retVal.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.$pax.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.$date.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.number_format($extra['prix']* 1 / $reservation->changeRate, 2, '.', '').'</span></td>
                                                <td></td>

                                            </tr>';
                                            if (count($extra['dates']) > 1){



                                                $html_extras .= '<tr id="ex'. $extra['idExtraRes'].'" class="collapse" >
                                                   <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="6">
                                                        <div class="scrollmenu">';
                                                            $extotal = 0; foreach ($extra['dates'] as $key => $dateE){ $extotal+=$dateE['prix'];

                                                                $html_extras .= '<div class="text-con old-room" style="width: 100px;background-color: #BBDDC1 !important;border: 1px solid #366D41;"><span class="text-datee text-center" style="color:#366D41!important">
                                                                        '.strftime("%d/%m/%G", strtotime($dateE['date'])).'</span>
                                                                    <span class="text-prix text-center">
                                                                        '.number_format($dateE['prix'] * 1 / $reservation->changeRate, 2, '.', '').'</span>
                                                                </div>';

                                                            }

                                                        $html_extras .= '</div>  
                                                    </td>
                                                    <td class="hexa-ch-total-td">
                                                        <span class="text-center hexa-ch-total">Total
                                                        </span>
                                                        <span class="text-center hexa-ch-total">
                                                            '.number_format($extotal * 1 / $reservation->changeRate, 2, '.', '').'
                                                        </span>
                                                    </td>
                                                </tr>';

                                                
                                            }
                                            
                                        }
                                    $html_extras .= '</tbody>
                                </table>';
                                }
                                $html_extras .= '

                            </div>';


                          
                $html_reglment ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-size: 24px;color: #011F28;font-weight: 800;font-style:italic;">#'.$reservation->idReservation.'</span> </div> <div class="col-1 title-close text-right"> <button style="font-size:24px;padding-right:4px" type="button" class="close" data-dismiss="modal" aria-label="Close"><i  style="font-size:24px;" class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6" style=";line-height: 2px"> <span style="color:#8A8E94;font-size:14px">'.$reservation->channelDisplay.'</span> </div> <div class="col-6 float-right"> </div> <div class="col-6 hexa-margin-25"> <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span> </div> ';
                          
                            
                            $html_reglment .='<div id="buttonGroupOpFact" class="col-6" style="padding-bottom: 10px;padding-top: 10px">
                                <div class="form-row float-right">';
                                              if (!$reservation->isCanceled){
                                                if (!$reservation->isCheckout){
                                                    if (($reservation->totalHT + $reservation->taxTotal) != $totalRegle){
                                                        if ($factureChambre || $factureExtra){
                                                            $html_reglment .= '<button type="button" onclick="createFactureModel(this,'.$reservation->idReservation.')" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-plus hexa-fs10" style="font-size: 12px"></i> Ajouter une facture</button>';
                                                        }
                                                    }else{
                                                        $html_reglment .= '<span class="hexa-text-paye">Reglée</span>';
                                                    }
                                                
                                               }
                                            }
                                            

                                $html_reglment .='</div> </div> </div> </div> </div> ';





                        $total = 0;
                        $totaltax = 0;
                        $totEX= 0;
                        $enf = 0;







                      if(count($chambres)>0){
                          $html_reglment .='<div class="body-content col-12 position-relative">
                                <div id="payFacture"></div>';                          



                          if (count($factures)>0){
                                
                                    $html_reglment .= '<table id="TableFactures" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0!important;">
                                            <thead class="hexa-header-reservation">

                                               <th>Facture</th> 
                                               <th class="text-center">Date</th>
                                               <th class="text-center">Payé</th> 
                                               <th class="text-center">Reste</th> 
                                               <th class="text-center">Total</th> 
                                               <th class="text-center">Actions</th> 
                                            </thead>
                                            <tbody>';
                                                foreach ($factures as $inde => $facture){
                                                    $html_reglment .= '<tr>
                                                    <td class="ty-chambre hexa-td" width="25%"><span class="text-lab">'.$facture['nom'].'</span></td>
                                                    <td class="ty-chambre hexa-td text-center" width="15%"><span class="text-lab">'.strftime("%d/%m/%G", strtotime($facture['dateFacture'])).'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format($facture['totalRegle'] * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format(($facture['total']-$facture['totalRegle']) * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format($facture['total'] * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                                
                                                    <td class="ty-chambre hexa-td text-center">';
                                                  if ($facture['total'] != $facture['totalRegle']){
                                                        $html_reglment .= '<span data-toggle="tooltip" data-placement="top" title="Regler la facture"  class="fa-stack operationCh" onclick="payFactureTextModal('.$reservation->idReservation.','.$facture['idFacture'].',\''.number_format(($facture['total']-$facture['totalRegle'])  * 1/$reservation->changeRate ,2,'.','').'\')" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-check fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span>';
                                                  }
                                                  if (count($facture['modePaiement'])>0){
                                                        $html_reglment .= '<span data-toggle="tooltip" data-placement="top" title="Modifier reglement" onclick="modifierFacture('.$facture['idFacture'].');"  class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-dollar-sign fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span> ';
                                                  }
                                                        $html_reglment .= '<span data-toggle="tooltip" data-placement="top" title="Details Facture"  class="fa-stack operationCh" onclick="editFacture('.$reservation->idReservation.','.$facture['idFacture'].')" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-receipt fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span>
                                                        <a href="'.base_url().'facture/'.$facture['idFacture'].'" target="_blank">
                                                        <span data-toggle="tooltip" data-placement="top" title="Imprimer Facture" class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-print fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span></a>
                                                    </td>
                                                </tr> ';                       
                                                }
                                            $html_reglment .= '</tbody>    
                                    </table>'; 
                                    
                                }
                            $html_reglment .= '<div id="createFacture" class="hexa-hide"></div>';


                          $html_historiques ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-size: 24px;color: #011F28;font-weight: 800;font-style:italic;">#'.$reservation->idReservation.'</span> </div> <div class="col-1 title-close text-right"> <button style="font-size:24px;padding-right:4px" type="button" class="close" data-dismiss="modal" aria-label="Close"><i  style="font-size:24px;" class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6" style=";line-height: 2px"> <span style="color:#8A8E94;font-size:14px">'.$reservation->channelDisplay.'</span> </div> <div class="col-6 float-right"> </div> <div class="col-6 hexa-margin-25"> <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span> </div>




                          <div class="col-6" style="padding-bottom: 10px;padding-top: 10px"> <div class="form-row  float-right">';
                           $html_historiques .='</div> </div> </div> </div>';


                               $html_historiques .= '<div class="col-12">
                                    <div class="timeline block mb-4">';
                                      foreach ($activites as $key => $activity){
                                                $text = $activity['nomUtilisateur'].' '.$activity['description'];

                                                $date = new DateTime($activity['dateCreation']);
                                                $date->setTimezone(new DateTimeZone('Africa/Casablanca')); 
                                                setlocale(LC_TIME, "fr_FR");
                                                $dateC =  utf8_encode(strftime("%d %B %G",strtotime($date->format('d-m-Y')))).' '.$date->format('H:i'); 
                                          

                                            $html_historiques .= '<div class="tl-item">
                                                <div class="tl-dot b-primary"></div>
                                                <div class="tl-content">
                                                    <div class="hexa-text-tl">'.$text.'</div>
                                                    <div class="tl-date text-muted mt-1">'.$dateC.'</div>
                                                </div>
                                            </div>'; 
                                        }
                                    $html_historiques .= '</div></div>';
                      }

  
 

                 

              return array('status'=>true,'session'=>true,'reservation'=>$html_reservation,'extras'=>$html_extras,'chambres'=>$html_chambres,'reglment'=>$html_reglment,'historiques'=>$html_historiques,'etat'=>$reservation->etat,'total'=>number_format(($reservation->totalHT + $reservation->taxTotal)* 1/$reservation->changeRate,2,'.',''),'piad'=>number_format($reservation->totalPaye* 1/$reservation->changeRate,2,'.',''),'extratotal'=>number_format($totalextra* 1/$reservation->changeRate,2,'.',''),'chtotal'=>number_format(($reservation->Total-$totalextra)* 1/$reservation->changeRate,2,'.',''),'resttotal'=>number_format((($reservation->totalHT + $reservation->taxTotal)-$reservation->totalPaye) * 1/$reservation->changeRate,2,'.',''),'tarifs'=>$tarifs,'tchambres'=>$tchambres,'pensions'=>$pensions,'chl'=>$chambreLibres);
            }else{

              return array('status'=>false,'session'=>true);
              

            }

    }


  }
  public function contentReservationP($idReservation){


        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 


        $reservation = $this->ReservationsModel->getReservation($idReservation);

        if($reservation){

            $client = $this->ReservationsModel->getReservationClient($reservation->idCardex);

            $chambresr = $this->ReservationsModel->getReservationRoomsR($idReservation);

            $chambres = $this->ReservationsModel->getReservationRoomsL($idReservation);

            $factureChambre=false;

            $factureExtra=false;

            $totalRegle = $this->ReservationsModel->getFacturesRegele($idReservation);

            $extras = $this->ReservationsModel->getExtraChambre($idReservation);

            foreach ($extras as $key => $extra) {
              if($extra['idFactureP']==0){
                $factureExtra=true;
              }              
              $extras[$key]['dates'] = $this->ReservationsModel->getDatesExtraChambre($extra['idExtraRes']);
            }
            //$reglements = $this->ReglementsModel->getReglement($idReservation);

            $pays = $this->ReservationsModel->getPays($client->idPays);

            $codePays = $client->idPays;

            $payys = $this->HotelModel->getPays();

            $tarifs = $this->TarifsModel->getTarifUnique();

            $tchambres = $this->ChambresModel->getTypesChambres();

            $Aextras = $this->ExtrasModel->getExtras();

            $modePaiements = $this->ReservationsModel->getModePaiements();

            $taxes = $this->HotelModel->getTaxes();

            $date = new DateTime($reservation->completedAt);

            $dpensions = $this->PensionsModel->getPensions();

            $mod_pensions = $this->TarifsModel->getTarifChannelCode($reservation->channel);

            $mod_chambres = $this->ChambresModel->getTypesChambres();

            $clients = $this->ReservationsModel->getCardex();

            $channels = $this->ClientsModel->getClients();

            //$data['chambresLibre'] = $this->ChambresModel->getChambresTypeChambre();

            $chambresLibre = $this->ChambresModel->getChambresTypeChambreDates($dateCloture,$reservation->dateAu);

            $date->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $today = new DateTime(date('Y-m-d H:m:s'));

            $today->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $checkin = true;

            $dateDu = false;

            $dateAu = false;

            $dateC = $dateCloture;

            $date->setTimezone(new DateTimeZone('Africa/Casablanca'));

            $today = new DateTime(date('Y-m-d H:m:s'));
            $today->setTimezone(new DateTimeZone('Africa/Casablanca'));
            
            $closed = true;


            $updatedAt = new DateTime($reservation->updatedAt);
            $updatedAt->setTimezone(new DateTimeZone('Africa/Casablanca')); 
            setlocale(LC_TIME, "fr_FR");
            $updatedAt = utf8_encode(strftime("%A %d %B %G",strtotime($updatedAt->format('d-m-Y')))).' '.$updatedAt->format('H:i');

            foreach ($chambresr as $key => $chambre) {

              if(!$chambre['isCanceled']){

                if(!$chambre['isCheckout'] && !$chambre['isNoshow']){

                  $closed = false;

                }                

              }

            }

            $checkin = false;
            $checking = true;
            $lastElementKey = count($chambres)-1;

            foreach ($chambres as $key => $chambre) {

              if($chambre['idFactureP']==0){
                $factureChambre=true;
              }

              $chambres[$key]['dates']   = $this->ReservationsModel->getDatesChambreRes($chambre['idCR']);

              if($chambres[0]['dateDu'] != $chambre['dateDu']){

                $checking = false;

              }

              if(!$chambre['isCheckin']){

                $checkin = true;

              }
  
              if($key == $lastElementKey) break;

              if(!$chambre['isCanceled']){

                if($chambre['dateDu'] != $chambres[$key+1]['dateDu']){

                    $dateDu = true;

                }
                if($chambre['dateAu'] != $chambres[$key+1]['dateAu']){

                    $dateAu = true;

                }

              }

            }

          $activites = $this->ReservationsModel->getActiviteReservation($idReservation);
          $factures = $this->ReservationsModel->getFactures($idReservation);

          foreach ($factures as $key => $facture) {

              $factures[$key]['modePaiement'] =$this->ReservationsModel->getReglements($facture['idFacture']);

          }


            $html_reservation = '<div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> 
                                        <span class="hexa-providerId">#'.$reservation->idReservation.'</span> 
                                    </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right hexa-total-resa">'.number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '').'</span>  </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            '.$reservation->channelDisplay.'</span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right"> | Reste : '.number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '').'</span><span style="font-style:italic" class="float-right"> Payé : '.number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '').'</span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25">
                                        <span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOp" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">';
                                            if (!$reservation->isCanceled  && !$reservation->isNoshow && !$reservation->isCheckin){
                                              if (!$reservation->isCheckout){
                                                $html_reservation .= '<button type="button" onclick="editReservationP(this,'.$reservation->idReservation.',\''.$reservation->dateDu.'\',\''.$reservation->dateAu.'\',\''.$codePays.'\')" class="btn btn-info float-right btn-reservation-modal"><i class="fa fa-pen" style="font-size: 12px"></i> Modifier</button>

                                                <button type="button" onclick="cancelReservationP('.$reservation->idReservation.')" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-times" style="font-size: 12px"></i> Annuler</button>';

                                              }
                                            }
                                            $html_reservation .= '<a target=”_blank” href="'.base_url().'imprimer/'.$reservation->idReservation.'">
                                                <button type="button" class="btn btn-secondary float-right btn-reservation-modal">
                                                <i class="fa fa-print" style="font-size: 10px"></i> Imprimer </button></a>
                                        </div>
                                    </div>
                                </div>
                            </div> 

                            <div class="body-content">
                                
                                <div id="body-reservation" >
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Etat <span class="text-labb">'.$this->getEtat($reservation->etat).'</span></span> 
                                                <span class="title-lab">Arrivee <span class="text-labb">
                                                        '.utf8_encode(strftime("%d %B %G", strtotime($reservation->dateDu))).'</span></span> 
                                                <span class="title-lab">Depart <span class="text-labb">
                                                        '.utf8_encode(strftime("%d %B %G", strtotime($reservation->dateAu))).'</span></span> 
                                                <span class="title-lab">Nombre de chambre <span class="text-labb">
                                                        '.$reservation->total_rooms.'</span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Source <span class="text-labb">
                                                        '.$reservation->channelDisplay.'</span></span> 
                                                <span class="title-lab">Référence <span class="text-labb">#'.$reservation->providerId.'</span></span> 
                                                <span class="title-lab">Type <span class="text-labb">Internet</span></span> 
                                                <span class="title-lab">Nombre de pax <span class="text-labb">
                                                        '.$reservation->total_guests.'</span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Client <span class="text-labb">
                                                        '.$client->nom.'</span></span> 
                                                <span class="title-lab">Telephone <span class="text-labb">
                                                        '.$client->tel.'</span></span> 
                                                <span class="title-lab">Email <span class="text-labb">
                                                        '.$client->email.'</span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Pays <span class="text-labb">
                                                        '.$pays.'</span></span> 
                                                <span class="title-lab">Ville <span class="text-labb">
                                                        '.$client->ville.'</span></span> 
                                                <span class="title-lab">Adresse <span class="text-labb">
                                                        '.$client->Adresse.'</span></span> 
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-12"> 
                                                <span class="title-lab">Remarques</span>
                                                <p class="text-remar">
                                                    '.$reservation->note.'
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="hexa-hide" id="ReservationEditor">
                                    <div class="col-12">
                                       <div class="form-group row">
                                        <label for="mod_checkin" class="col-sm-1 col-form-label form-input">Arrivee </label>

                                                <div class="col-sm-3 input-group  md-form form-sm form-2">
                                                    <input type="text" class="date-hexa datepicker form-control" id="mod_checkin" ';

                                                    if ($dateAu || $dateDu){ $html_reservation .= ' disabled '; } $html_reservation .= '/> 
                                                    <div class="input-group-append"> 
                                                        <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> 
                                                    </div> 
                                                </div> 
                                
                                                <label for="mod_checkout" class="col-sm-1 col-form-label  form-input">Depart </label>
                                                    <div class="col-sm-3 input-group  md-form form-sm form-2">
                                                        <input type="text" class="date-hexa datepicker form-control" id="mod_checkout" '; 

                                                        if ($dateAu || $dateDu){ $html_reservation .= ' disabled '; } $html_reservation .= '/> 
                                                        <div class="input-group-append"> 
                                                            <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> 
                                                        </div> 
                                                    </div> 
                                                <label for="mod_channnel" class="col-sm-1 col-form-label form-input">Client</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input id="mod_channnel"  class="hexa-autoc form-control"  value="'.$reservation->channel.'" disabled> 
                                                </div> 

                                        </div>

                                        <hr>

                                        <div class="form-group row">
           
                                            <label for="mod_client" class="col-sm-1 col-form-label form-input">Client\Groupe</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input data-cli="'.$client->idCardex.'" id="mod_client"  class="hexa-autoc form-control"  value="'.$client->nom.'"> 
                                                </div> 

                                                <label for="mod_tel" class="col-sm-1 col-form-label form-input">Tel</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_tel"  class="hexa-autoc form-control"  value="'.$client->tel.'"> 
                                                </div>
                                                <label for="mod_email" class="col-sm-1 col-form-label form-input">Email</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_email"  class="hexa-autoc form-control" value="'.$client->email.'"> 
                                                </div>
                                        </div>

                                        <div class="form-group row">
           
                                                <label for="mod_adresse" class="col-sm-1 col-form-label form-input">Adresse</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input id="mod_adresse"  class="hexa-autoc form-control" value="'.$client->Adresse.'">
                                                </div> 

                                                <label for="mod_ville" class="col-sm-1 col-form-label form-input">Ville</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_ville"  class="hexa-autoc form-control"  value="'.$client->ville.'"> 
                                                </div>
                                                <label for="mod_nationalite" class="col-sm-1 col-form-label form-input">Nationalite</label>
                                                <div class="col-sm-3 input-group md-form form-sm form-2">  
                                                    <select data-size="6" id="mod_nationalite" class="selectpicker form-control form-input"> </select>
                                                </div>
                                        </div>

                                        <hr>

                                        <div class="form-group row">
                                            <label for="mod_notes" class="col-sm-1 col-form-label form-input">Remarques</label>
                                            <div class="col-sm-11 input-group  md-form form-sm form-2">  
                                                <textarea id="mod_notes" class="form-control">'.$reservation->note.'</textarea>
                                            </div>  
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <button onclick="updateReservationP('.$reservation->idReservation.');" type="button" class="btn btn-success float-right hexa-btn-op-mod"> Modifier</button>

                                                <button onclick="anuulerModification();" type="button" class="btn btn-info float-left hexa-btn-op-retour"> Retour </button>
                                             </div>
                                         </div>
                                    </div>
                                </div>
                                <div  class="hexa-hide" id="ReservationConfirmCancel"></div>

                            </div>';





                            $html_chambres = '<div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#'.$reservation->idReservation.'</span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right" style="font-size: 28px;color: #011F28;font-weight: 700;font-style:italic">'.number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '').'</span>  
                                    </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            '.$reservation->channelDisplay.'</span> </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : '.number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '').'</span>
                                        <span style="font-style:italic" class="float-right">Payé : '.number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '').'</span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOpR"  style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row  float-right">';

                                          if ((!$reservation->isCanceled) && (!$reservation->isNoshow) && (!$closed)){
                                            if (!$reservation->isCheckout){

                                                    $html_chambres .= '<button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChForm(this,'.$reservation->idReservation.')"><i class="fa fa-plus hexa-fs10"></i> Ajouter une chambre</button>';
                                                }
                                          }

                                        $html_chambres .= '</div>
                                    </div>
                                </div>
                            </div>

                            <div class="body-content col-12">
                                <table id="TableRooms" width="100%" class="table">
                                        <thead class="hexa-header-reservation">
                                            <th width="35%">Type</th>
                                            <th class="text-center" width="10%">Chambre</th>
                                            <th class="text-center" width="10%">Etat</th>
                                            <th width="15%">Arrivee</th>
                                            <th width="10%">Pax</th>
                                            <th class="text-center" width="10%">Actions</th>
                                        </thead>
                                        <tbody>';
                                  foreach ($chambres as $indexCh => $chambre){ $ch_number = '#';
                                            $html_chambres .= '<tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab">
                                                    '.$chambre['nomTypeChambres'].'</span><span class="text-labbb">
                                                    '.$chambre['pension'].'</span></td>
                                                <td class="ty-chambre text-center hexa-td">';

                                                   if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])){
                                                      if ($chambre['idChambres'] == 0){
                                                        $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'.$ch_number.'</span>';
                                                      
                                                      }else{
                                                          $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'; 

                                                          $ch_number = $chambre['nomChambre'];
                                                          $html_chambres .=$ch_number.'</span>';
                                                      }
                                                    }else{
                                                        $html_chambres .= '<span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;">'.$ch_number.'</span>';
                                                    }  
                                                $html_chambres .= '</td>


                                                <td class="ty-chambre text-center hexa-td">
                                                    <span class="text-lab ">';

                                                          if ($chambre['isNoshow']){
                                                            $ett =  $this->getEtatCh('noshow');
                                                          }elseif($chambre['isCheckout']){
                                                            $ett =  $this->getEtatCh('checkout');
                                                          }elseif($chambre['isCheckin']){
                                                            $ett =  $this->getEtatCh('checkin');
                                                          }else{
                                                            $ett =  $this->getEtatCh($chambre['etat']);
                                                          }
                                                    $html_chambres .= $ett.'
                                                    </span>
                                                </td>
                                                <td class="hexa-td"><span class="text-lab">
                                                        '.utf8_encode(strftime("%d %b", strtotime($chambre['dateDu']))) . ' - ' . utf8_encode(strftime("%d %b %G", strtotime($chambre['dateAu']))).'</span><span class="text-labbb">
                                                        '.$chambre['nuites'].' nuits</span></td>
                                                <td class="hexa-td">
                                                    <span class="text-lab">'.$chambre['totalAdult'].' Adult</span>
                                                    <span class="text-labbb">'.$chambre['totalEnfant'].' Enfant</span>
                                                </td>
                                                <td class="text-center hexa-td">';
                                                    if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])){
                                                        if (!$chambre['isCheckin']){
                                                            if ($chambre['dateDu'] == $dateCloture){
                                                                $html_chambres .= '<span data-toggle="tooltip" data-placement="top" title="Check in" onClick="checkinRoomP(this,'.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh">
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-arrow-down fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span>';
                                                            }
                                                            $html_chambres .= '<span data-toggle="tooltip" data-placement="top" title="Modifier" onclick="editRoomReservationP(this,'.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 11px"></i>
                                                            </span>
                                                            <span data-toggle="tooltip" data-placement="top" title="Annuler chambre" onclick="cancelRoomP('.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh">
                                                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                <i class="fa fa-times fa-stack-1x fa-inverse action" style="font-size: 14px"></i>
                                                            </span>';
                                                        }elseif(!$chambre['isCheckout']){
                                                            if($dateCloture < $chambre['dateAu']){
                                                                $html_chambres .= '<span data-toggle="tooltip" data-placement="top" title="Deloger chambre" onclick="delogerRoomP(this,'.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh">
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-exchange-alt fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span>';
                                                            }
                                                            $html_chambres .= '<span data-toggle="tooltip" data-placement="top" title="Modifier chambre" onclick="editRoomReservationP(this,'.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 11px"></i>
                                                            </span>';
                                                            if ($chambre['prix'] == $chambre['totalRegle']){
                                                              $html_chambres .= '<span data-toggle="tooltip" data-placement="top" title="Checkout" onclick="checkoutP(this,'.$reservation->idReservation.','.$chambre['idCR'].')" class="fa-stack operationCh" > <i class="fas fa-square fa-stack-2x clickable"></i> <i class="fa fa-arrow-up fa-stack-1x fa-inverse action" style="font-size: 12px"></i> </span>'; 
                                                            }
                                                            

                                                        }

                                                   }
                                      $html_chambres .= '</td>
                                            </tr>';
                                            if (count($chambre['dates']) > 0 && !$chambre['isCheckout']){
                                            $html_chambres .= '<tr>
                                                <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="5">
                                                    <div class="scrollmenu">';
                                                        $chtotal = 0; 
                                                        foreach ($chambre['dates'] as $key => $dateR){
                                                          if ($dateR['date'] < $dateCloture || $chambre['isCanceled'] || $reservation->isCanceled || $reservation->isNoshow  || $chambre['isNoshow']){
                                                            $html_chambres .= '<div class="text-con old-room" style="width: 100px;"><span class="text-datee text-center" style="color:#948994!important">
                                                                    '.strftime("%d/%m/%G", strtotime($dateR['date'])).'</span>
                                                                <span class="text-prix text-center">
                                                                    '.$dateR['codePension'].'</span>
                                                                <span class="text-prix text-center">
                                                                    '.number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '').'</span></div>';
                                                          }else{
                                                            $html_chambres .= '<div onclick="editRoomDatePension('.$dateR['idDCR'].', '.$dateR['idCR'].', '.$reservation->idReservation.', '.$dateR['idPension'].', '.number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '').', \''.$dateR['date'].'\', \''.$chambre['nomTypeChambres'].'\', \''.$chambre['pension'].'\', \''.$ch_number.'\', \''.htmlspecialchars($ett).'\', \''.strftime("%d %b", strtotime($chambre['dateDu'])) . ' - ' . strftime("%d %b %G", strtotime($chambre['dateAu'])).'\', \''.$chambre['nuites'].' nuits \', \''.$chambre['totalAdult'].' Adult\', \''.$chambre['totalEnfant'].' Enfant\')" class="text-con" style="width: 100px;"><span class="text-datee text-center"> '.strftime("%d/%m/%G", strtotime($dateR['date'])).'</span>
                                                                    <span class="text-prix text-center">
                                                                    '.$dateR['codePension'].'</span>
                                                                    <span class="text-prix text-center">
                                                                    '.number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '').'</span></div>';
                                                          }

                                                           $chtotal += $dateR['prix'];
                                                        }
                                                    $html_chambres .= '</div>
                                                </td>
                                                <td class="hexa-ch-total-td">
                                                    <span class="text-center hexa-ch-total">Total
                                                    </span>
                                                    <span class="text-center hexa-ch-total">
                                                        '.number_format($chtotal * 1 / $reservation->changeRate, 2, '.', '').'
                                                    </span>
                                                </td>
                                            </tr>';
                                            }
                                            }

                        $html_chambres .= '</tbody>
                                </table>

                                <div class="form-row hexa-hide" id="formGroupCh"></div>

                                <div class="form-row hexa-hide" id="RoomEditor"></div>

                                <div class="row hexa-hide" id="affecterRoom" ></div> 
                                <div class="row hexa-hide" id="delogerRoom"></div> 
                                <div class="row hexa-hide" id="editChambrePension">
                                    <div class="col-12">
                                            <table width="100%" class="table">
                                                <thead class="hexa-header-reservation">
                                                    <th width="35%">Type</th>
                                                    <th class="text-center" width="10%">Chambre</th>
                                                    <th class="text-center" width="10%">Etat</th>
                                                    <th width="15%">Arrivee</th>
                                                    <th width="10%">Pax</th>
                                                    <th class="text-center" width="10%">Actions</th>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td class="ty-chambre hexa-td"><span class="text-lab" id="txt_ch_mod"></span><span class="text-labbb" id="txt_pen_mod"></span></td>
                                                        <td class="ty-chambre text-center hexa-td" id="txt_ch_sel_mod"></td>
                                                        <td class="ty-chambre text-center hexa-td">
                                                            <span class="text-lab" id="txt_ch_etat_mod">
                                                            </span>
                                                        </td>

                                                        <td class="hexa-td"><span class="text-lab" id="txt_ch_dates_mod"></span><span class="text-labbb" id="txt_ch_nuit_mod"></span></td>
                                                        <td class="hexa-td">
                                                            <span class="text-lab" id="txt_ch_adult_mod"></span>
                                                            <span class="text-labbb" id="txt_ch_child_mod"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="6" style="background:#F6FAFB;">
                                                            <div id="room-pension-content" class="row" style="padding-top:15px;padding-bottom:15px">
                                                            </div>
                                                        </td>
                                                    
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <div class="form-row"> 
                                                <div class="form-group col-md-12">
                                                    <button type="button" onclick="appliquerEditRoomSejour()" class="btn btn-success btn-reservation-modal float-right">Appliquer sur le sejour</button>
                                                    <button type="button" onclick="appliquerEditRoom()" class="btn btn-success btn-reservation-modal float-right">Appliquer</button>
                                                    <button type="button" onclick="retourEditRoomDatePension()" class="btn btn-info btn-reservation-modal float-left">Retour </button> 
                                                </div>
                                            </div>
                                    </div>
                                </div>
                            
                            </div>';












                       $html_extras = '<div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#'.$reservation->idReservation.'</span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right" style="font-size: 28px;color: #011F28;font-weight: 700;font-style:italic">'.number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '').'</span>  
                                    </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            '.$reservation->channelDisplay.'</span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : '.number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '').'</span><span style="font-style:italic" class="float-right"> Payé : '.number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '').'</span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOpEx" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">';
                                        if (!$reservation->isCanceled  && !$reservation->isNoshow && !$reservation->isCheckout){
                                          if (count($chambres)>0){
                                            $html_extras .= '<button type="button" id="btn-ajouterchch" class="btn btn-secondary float-right btn-reservation-modal" onclick="ajouterChExFormRoom(this,'.$reservation->idReservation.','.$chambres[0]['idCR'].')"><i class="fa fa-plus hexa-fs10"></i> Extra chambre</button>';
                                          }
                                            $html_extras .= '<button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChExForm(this,'.$reservation->idReservation.')"><i class="fa fa-plus hexa-fs10"></i> Extra reservation</button>';

                                        }
                                        $html_extras .= '</div>
                                    </div>
                                </div>
                            </div>

                            <div class="body-content col-12">';
                                
                                if (count($extras)>0){
                            
                                $html_extras .= '<table id="TableExtra" width="100%" class="table" style="overflow: hidden !important">
                                    <thead class="hexa-header-reservation">
                                        <th width="30%">Extra</th>
                                        <th class="text-center" width="10%">Type</th>
                                        <th class="text-center" width="10%">Personnes</th>
                                        <th class="text-center" width="10%">Dates</th>
                                        <th class="text-center" width="20%">Total</th>
                                        <th class="text-center" width="10%">Actions</th>
                                    </thead>
                                    <tbody>';
                                        foreach ($extras as $key => $extra){

                                            $html_extras .= '<tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab">'.$extra['extraReservation'].'</span><span class="text-labbbb">';

                                                $type = ($extra['idDeduction']) ? 'Prestation' : 'Deduction' ;


                                                $html_extras .= $type.'</span>
                                                </td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">';

                                                $retVal = ($extra['isReservation']) ? 'Reservation' : 'Chambre';
                                                $pax = (count($extra['dates'])>0) ? $extra['dates'][0]['pax'] : 'N/A';
                                                $date = (count($extra['dates'])>0) ? $extra['dates'][0]['date'] : 'N/A';

                                                $html_extras .= $retVal.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.$pax.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.$date.'</span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab">'.number_format($extra['prix']* 1 / $reservation->changeRate, 2, '.', '').'</span></td>
                                                <td></td>

                                            </tr>';
                                            if (count($extra['dates']) > 1){



                                                $html_extras .= '<tr>
                                                   <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="5">
                                                        <div class="scrollmenu">';
                                                            $extotal = 0; foreach ($extra['dates'] as $key => $dateE){ $extotal+=$dateE['prix'];

                                                                $html_extras .= '<div class="text-con old-room" style="width: 100px;background-color: #BBDDC1 !important;border: 1px solid #366D41;"><span class="text-datee text-center" style="color:#366D41!important">
                                                                        '.strftime("%d/%m/%G", strtotime($dateE['date'])).'</span>
                                                                    <span class="text-prix text-center">
                                                                        '.number_format($dateE['prix'] * 1 / $reservation->changeRate, 2, '.', '').'</span>
                                                                </div>';

                                                            }

                                                        $html_extras .= '</div>  
                                                    </td>
                                                    <td class="hexa-ch-total-td">
                                                        <span class="text-center hexa-ch-total">Total
                                                        </span>
                                                        <span class="text-center hexa-ch-total">
                                                            '.number_format($extotal * 1 / $reservation->changeRate, 2, '.', '').'
                                                        </span>
                                                    </td>
                                                </tr>';

                                                
                                            }
                                            
                                        }
                                    $html_extras .= '</tbody>
                                </table>';
                                }
                                $html_extras .= '<div id="formReservationEx" class="hexa-hide"></div>

                            </div>';










                        $html_reglement = '<div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#'.$reservation->idReservation.'</span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right" id="hexa-text-regl">'.number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '').'</span>  
                                    </div>
                                    <div class="col-6"><span style="color:#8A8E94;font-style:italic">
                                            '.$reservation->channelDisplay.'</span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : '.number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '').'</span><span style="font-style:italic" class="float-right"> Payé : '.number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '').'</span> 
                                    </div>

                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>
                                    </div>

                                    <div class="col-12 col-md-6" id="buttonGroupOpFact" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">';

                                             if (!$reservation->isCanceled){
                                                if (!$reservation->isCheckout){
                                                    if (($reservation->totalHT + $reservation->taxTotal) != $totalRegle){
                                                        if ($factureChambre || $factureExtra){
                                                            $html_reglement .= '<button type="button" onclick="createFacture(this,'.$reservation->idReservation.')" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-plus hexa-fs10" style="font-size: 12px"></i> Ajouter une facture</button>';
                                                        }
                                                    }else{
                                                        $html_reglement .= '<span class="hexa-text-paye">Reglée</span>';
                                                    }
                                                
                                               }
                                            }

                                        $html_reglement .= '</div>
                                    </div>
                                </div>
                            </div> 

                            <div class="body-content col-12 position-relative">
                                <div id="payFacture"></div>';
                             if (count($factures)>0){

                                $html_reglement .= '<table id="TableFactures" width="100%" class="table" style="margin-bottom: 0!important;">
                                            <thead class="hexa-header-reservation">
                                                <th>Facture</th> 
                                                <th class="text-center">Date</th>
                                                <th class="text-center">Payé</th> 
                                                <th class="text-center">Reste</th> 
                                                <th class="text-center">Total</th> 
                                                <th class="text-center">Actions</th> 
                                            </thead>
                                            <tbody>';
                                            foreach ($factures as $inde => $facture){


                                                $html_reglement .= '<tr>
                                                    <td class="ty-chambre hexa-td" width="25%"><span class="text-lab">'.$facture['nom'].'</span></td>
                                                    <td class="ty-chambre hexa-td text-center" width="15%"><span class="text-lab">'.strftime("%d/%m/%G", strtotime($facture['dateFacture'])).'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format($facture['totalRegle'] * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format(($facture['total']-$facture['totalRegle']) * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab">'.number_format($facture['total'] * 1/$reservation->changeRate ,2,'.','').'</span></td>
                                                                
                                                    <td class="ty-chambre hexa-td text-center">';
                                                    if ($facture['total'] != $facture['totalRegle']){
                                                        $html_reglement .= '<span data-toggle="tooltip" data-placement="top" title="Regler la facture"  class="fa-stack operationCh" onclick="payFactureText('.$reservation->idReservation.','.$facture['idFacture'].',\''.number_format(($facture['total']-$facture['totalRegle'])  * 1/$reservation->changeRate ,2,'.','').'\')" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-check fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span>';
                                                    }
                                                    if (count($facture['modePaiement'])>0){
                                                        $html_reglement .= '<span data-toggle="tooltip" data-placement="top" title="Modifier reglement" onclick="modifierFacture('.$facture['idFacture'].');"  class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-dollar-sign fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span>';
                                                    }
                                                        $html_reglement .= '<span data-toggle="tooltip" data-placement="top" title="Details Facture"  class="fa-stack operationCh" onclick="editFacture('.$reservation->idReservation.','.$facture['idFacture'].')" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-receipt fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span>
                                                        <a href="'.base_url().'facture/'.$facture['idFacture'].'" target="_blank">
                                                        <span data-toggle="tooltip" data-placement="top" title="Imprimer Facture" class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-print fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                        </span></a>
                                                    </td>
                                                </tr> ';                         
                                                }
                                            $html_reglement .= '</tbody>    
                                </table>  ';
                                }  
                                $html_reglement .= '<div id="createFacture" class="hexa-hide"></div> </div>';






                        $html_historiques = '
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#'.$reservation->idReservation.'</span> </div>

                                    <div class="col-6 float-right"><span class="float-right"  id="hexa-text-regl">'.number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '').'</span>  </div>
                                    <div class="col-6"><span style="color:#8A8E94;font-style:italic">
                                            '.$reservation->channelDisplay.'</span> </div>
                                    <div class="col-6 float-right"><span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : '.number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '').'</span><span style="font-style:italic" class="float-right"> Payé : '.number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '').'</span> </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  '.$updatedAt.'</span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOp" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">
                                        </div>
                                    </div>
                                </div>
                            </div> 
                        

                            <div class="body-content">
                                <div class="col-12">
                                    <div class="timeline block mb-4">';
                                        foreach ($activites as $key => $activity){
                                                $text = $activity['nomUtilisateur'].' '.$activity['description'];

                                                $date = new DateTime($activity['dateCreation']);
                                                $date->setTimezone(new DateTimeZone('Africa/Casablanca')); 
                                                setlocale(LC_TIME, "fr_FR");
                                                $dateC =  strftime("%d %B %G",strtotime($date->format('d-m-Y'))).' '.$date->format('H:i'); 
                                           

                                            $html_historiques .= '<div class="tl-item">
                                                <div class="tl-dot b-primary"></div>
                                                <div class="tl-content">
                                                    <div class="hexa-text-tl">'.$text.'</div>
                                                    <div class="tl-date text-muted mt-1">'.$dateC.'</div>
                                                </div>
                                            </div>';  
                                        }
                                    $html_historiques .= '</div>         
                                </div>

                            </div>';
                        




         return array('status'=>true,'session'=>true,'reservation'=>$html_reservation,'extras'=>$html_extras,'chambres'=>$html_chambres,'reglment'=>$html_reglement,'historiq'=>$html_historiques);

      }else{

          return array('status'=>false,'session'=>true);

      }

  }

  public function cancelReservation(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $canceledAt = date('Y-m-d H:i:sa');

      $idReservation = $this->input->post('idReservation');
      $raison = $this->input->post('raison');

      if($this->ReservationsModel->cancel($idReservation,$canceledAt,$raison,$id)){
        $results = $this->contentReservationP($idReservation);
        echo json_encode(( $this->utf8ize( $results ) ));
      }else{
        $results = array('status'=>false,'session'=>true);
        echo json_encode(( $this->utf8ize( $results ) ));
      }

    }

  }




























































  public function createRoom(){


    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $dateDu = $this->input->post('datDu');
        $dateAu = $this->input->post('dateAu');
        $pension = $this->input->post('pension');
        $typeChambre = $this->input->post('typeChambre');
        $totalAdult = $this->input->post('totalAdult');
        $totalEnfant = $this->input->post('totalEnfant');
        $qte = $this->input->post('qte');
        $idReservation = $this->input->post('idReservation');
        $providerId = $this->input->post('providerId');
        $totalPax = $totalAdult + $totalEnfant;

        $earlier = new DateTime($dateDu);
        $later = new DateTime($dateAu);

        $nights = $later->diff($earlier)->format("%a");

        $dates = $this->TarifsModel->getDatesPrixTarif($pension,$typeChambre,$dateDu,$dateAu);
        $tot = 0;

        if(count($dates)==0){
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
          return null;
        }

        if(count($dates)<$nights){
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
          return null;
        }

        foreach ($dates as $key => $date) {
          $tot += $date['prix'];
          $idChanTarif = $date['idChannelTarif'];
        }

        for ($i=0; $i < $qte; $i++) { 
      
           $room = array("etat"=>'confirm',"dateDu"=>$dateDu,"dateAu"=>$dateAu,"idReservation"=>$idReservation,"idTarif"=>$idChanTarif,'totalPax'=>$totalPax,'totalAdult'=>$totalAdult,'totalEnfant'=>$totalEnfant,'nuites'=>$nights,'prix'=>$tot,'providerId'=>$providerId);
          if(!$this->ReservationsModel->insertRoomReservation($room,$dates,$idReservation,$providerId,$tot)){
              $results = array('status'=>false,'session'=>true);
              echo json_encode(( $this->utf8ize( $results ) ));
              return null;
          }

        }
        $results = $this->getContentReservation($idReservation);
        echo json_encode(( $this->utf8ize( $results ) ));

    }

  }

  public function updateReservation(){


    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      setlocale(LC_TIME, "fr_FR"); 

      $idReservation = $this->input->post('idReservation');
      
      $reservation = $this->ReservationsModel->getReservation($idReservation);

      $client = $this->ReservationsModel->getReservationClient($reservation->idCardex);

      $clients = $this->ReservationsModel->getRCardex();
      $channels = $this->ClientsModel->getClients();
      $pays = $this->HotelModel->getPays();
      foreach ($channels as $key => $channel) {

         $channels[$key]['tarifs'] = $this->TarifsModel->getTarifsChannel($channel['idChannel']);

      }
      $tarifs = $this->TarifsModel->getTarifUnique();
      $html_reservation = '<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-style:italic;font-size: 28px;color: #011F28;font-weight: 700;">Modifier reservation #'.$reservation->providerId.'</span> </div> <div class="col-1 title-close text-center"> <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-12"> <button onclick="updateReservation('.$reservation->idReservation.');" type="button" style="padding-left: 20px;padding-right: 20px;margin-right: 5px;border-radius: 2px;font-size: 12px;font-weight: 500;;margin-bottom: 10px" class="btn btn-info float-right"> Modifier</button> <button onclick="detailsReservation('.$reservation->idReservation.');" type="button" style="padding-left: 20px;padding-right: 20px;margin-right: 5px;border-radius: 2px;font-size: 12px;font-weight: 500;margin-bottom: 10px" class="btn btn-danger float-right"> Annuler Modification </button> </div> </div> </div><div class="container"> <div class="form-row"> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="control-label" for="mod_checkin">Arrivee</label> <div class="input-group md-form form-sm form-2 pl-0"> <input style="font-size:12px!important;line-height: 1.5;" type="text" class="date-hexa datepicker form-control" id="mod_checkin" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1" onclick="getDatedMod()"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> </div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"> <label class="form-label" for="mod_adult">Adult</label> <select id="mod_adult" class="selectpicker form-control form-input">'; for ($i=1; $i < 60; $i++) {$html_reservation .= '<option value="'.$i.'">'.$i.'</option>'; } $html_reservation .= '</select> </div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="form-label" for="mod_channel">Client</label> <select id="mod_channel" class="selectpicker form-control form-input"> </select> </div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="control-label" for="mod_checkout">Depart</label> <div class="input-group md-form form-sm form-2 pl-0"> <input style="font-size:12px!important;line-height: 1.5;" type="text" class="date-hexa datepicker form-control" id="mod_checkout" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"  onclick="getDatefMod()"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> </div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"> <label class="form-label" for="mod_enfant">Enfant</label> <select id="mod_enfant" class="selectpicker form-control form-input">'; for ($i=0; $i < 40; $i++) {$html_reservation .= '<option value="'.$i.'">'.$i.'</option>'; } $html_reservation .= '</select> </select> </div> </div> <hr> <div class="form-row"> <div class="form-group col-md-4"> <label for="mod_client" class="control-label">Client\Groupe</label> <div class="input-group md-form form-sm form-2 pl-0"> <input data-cli="0" id="mod_client"  class="hexa-autoc form-control"  value="'.$client->nom.'"> </div> </div> <div class="form-group col-md-4"> <label for="mod_tel" class="control-label">Telephone</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="mod_tel"  class="hexa-autoc form-control"  value="'.$client->tel.'"> </div> </div> <div class="form-group col-md-4"> <label for="mod_email" class="control-label">Email</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="mod_email"  class="hexa-autoc form-control" value="'.$client->email.'"> </div> </div> <div class="form-group col-md-4"> <label for="mod_adresse" class="control-label">Adresse</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="mod_adresse"  class="hexa-autoc form-control" value="'.$client->Adresse.'"> </div> </div> <div class="form-group col-md-4"> <label for="mod_ville" class="control-label">Ville</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="mod_ville"  class="hexa-autoc form-control"  value="'.$client->ville.'"> </div> </div> <div class="form-group col-md-4"> <label for="mod_nationalite" class="control-label">Nationalite</label> <div class="input-group md-form form-sm form-2 pl-0"> <select id="mod_nationalite" class="selectpicker form-control form-input"> </select> </div> </div> </div> <hr> <div class="form-row"> <div class="form-group col-md-12"> <label for="mod_notes" class="control-label">Remarques</label> <div class="input-group md-form form-sm form-2 pl-0"> <textarea id="mod_notes" class="form-control">'.$reservation->note.'</textarea> </div> </div> </div> </div>';
      $results = array('status'=>true,'session'=>true,'reservation'=>$html_reservation,'clients'=>$clients,'channels'=>$channels,'pays'=>$pays,'codepays'=>$client->idPays,'codechannel'=>$reservation->channel,'dateCheckin'=>$reservation->dateDu,'dateCheckout'=>$reservation->dateAu);
      echo json_encode(( $this->utf8ize( $results ) ));



    }

  }

  public function newReservationContant(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $clients = $this->ReservationsModel->getRCardex();

      $channels = $this->ClientsModel->getClients();

      $pays = $this->HotelModel->getPays();

      foreach ($channels as $key => $channel) {

         $channels[$key]['tarifs'] = $this->TarifsModel->getTarifsChannel($channel['idChannel']);

      }

      $tarifs = $this->TarifsModel->getTarifUnique();

      $chambres = $this->ChambresModel->getTypesChambres();

      $Aextras = $this->ExtrasModel->getExtras();

      $modePaiements = $this->ReservationsModel->getModePaiements();

      $taxes = $this->HotelModel->getTaxes();

      $html_reservation = '<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-style:italic;font-size: 28px;color: #011F28;font-weight: 700;">Creer une reservation</span> </div> <div class="col-1 title-close text-center"> <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6"> <span style="color:#8A8E94"></span> </div> <div class="col-6"> <button type="button" onclick="insertReservation()" style="border-radius: 2px;font-size: 12px;font-weight: 500;margin-bottom: 10px" class="btn btn-success float-right"> Reserver </button> </div> </div> </div><div class="container"> <div class="form-row"> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="control-label" for="res_checkin">Arrivee</label> <div class="input-group md-form form-sm form-2 pl-0"> <input style="font-size:12px!important;line-height: 1.5;" type="text" class="date-hexa datepicker form-control" id="res_checkin" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> </div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="form-label" for="res_channel">Client</label> <select id="res_channel" class="selectpicker form-control form-input"> </select> </div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"> <label class="form-label" for="res_adult">Adult</label> <select id="res_adult" class="selectpicker form-control form-input"> <option>1</option> <option>2</option> <option>3</option> <option>4</option> <option>5</option> <option>6</option> </select> </div> <div class="form-group col-md-2"> <label for="res_heure" class="control-label">Heure arriveee</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="res_heure"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="control-label" for="res_checkout">Depart</label> <div class="input-group md-form form-sm form-2 pl-0"> <input style="font-size:12px!important;line-height: 1.5;" type="text" class="date-hexa datepicker form-control" id="res_checkout" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> </div> </div> </div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"> <label class="form-label" for="res_pension">Pension</label> <select id="res_pension" class="selectpicker form-control form-input"> </select> </div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"> <label class="form-label" for="res_enfant">Enfant</label> <select id="res_enfant" class="selectpicker form-control form-input"> <option>0</option> <option>1</option> <option>2</option> <option>3</option> <option>4</option> <option>5</option> <option>6</option> </select> </div> </div> <hr> <div class="form-row"> <div class="form-group col-md-4"> <label for="res_client" class="control-label">Client\Groupe</label> <div class="input-group md-form form-sm form-2 pl-0"> <input data-cli="0" id="res_client"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4"> <label for="res_tel" class="control-label">Telephone</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="res_tel"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4"> <label for="res_email" class="control-label">Email</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="res_email"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4"> <label for="res_adresse" class="control-label">Adresse</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="res_adresse"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4"> <label for="res_ville" class="control-label">Ville</label> <div class="input-group md-form form-sm form-2 pl-0"> <input id="res_ville"  class="hexa-autoc form-control"> </div> </div> <div class="form-group col-md-4"> <label for="res_nationalite" class="control-label">Nationalite</label> <div class="input-group md-form form-sm form-2 pl-0"> <select id="res_nationalite" class="selectpicker form-control form-input"> </select> </div> </div> </div> <hr> <div class="form-row"> <div class="form-group col-md-12"> <label for="res_notes" class="control-label">Remarques</label> <div class="input-group md-form form-sm form-2 pl-0"> <textarea id="res_notes" class="form-control"></textarea> </div> </div> </div> </div>';


      $html_chambres = '<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 5px!important;"> <div class="col-11"> <span style="font-style:italic;font-size: 28px;color: #011F28;font-weight: 700;">Ajouter les chambres</span> </div> <div class="col-1 title-close text-center"> <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6"> <span style="color:#8A8E94"></span> </div> <div class="col-6"> <button type="button" style="border-radius: 2px;font-size: 12px;font-weight: 500;margin-bottom: 10px;"  onclick="ajouterChFormNew(this)" class="btn btn-info float-right hexa-hide" id="ajouterRoomBtn"><i class="fa fa-plus"></i> Ajouter une chambre</button> </div> </div> </div><div class="container"><table id="TableRooms" style="margin-bottom: 5px;" class="table hexa-hide"><thead class="hexa-header-reservation"> <th  width="30%">Type</th> <th width="10%">Chambre</th><th width="10%">Etat</th> <th width="30%">Arrivee</th> <th width="10%">Pax</th> <th  width="10%">Actions</th></thead><tbody></tbody><table> <div class="form-row" id="formGroupCh"> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"><label class="control-label" for="res_ch_checkin">Arrivee</label><div class="input-group md-form form-sm form-2 pl-0"><input style="font-size:12px!important;line-height: 1.5;" type="text" class="date-hexa datepicker form-control" id="res_ch_checkin" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i></span></div></div></div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"><label class="form-label" for="res_qte_ch">qte</label><div class="input-group md-form form-sm form-2 pl-0"><input type="text" value="1" id="res_qte_ch"  class="hexa-autoc form-control"></div></div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"><label class="form-label" for="res_ch_typch">Type chambre</label><select style="font-size:12px!important;line-height: 1.5;" id="res_ch_typch" class="selectpicker form-control form-input"></select></div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"><label class="form-label" for="adult_res">Adult</label><select  style="font-size:12px!important;line-height: 1.5;" id="adult_res" class="selectpicker form-control form-input"><option>1</option> <option>2</option> <option>3</option> <option>4</option> <option>5</option> <option>6</option></select></div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"><label class="control-label" for="res_ch_checkout">Depart</label><div class="input-group md-form form-sm form-2 pl-0"> <input type="text"  style="font-size:12px!important;line-height: 1.5;" class="date-hexa datepicker form-control" id="res_ch_checkout" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i></span></div></div></div> <div class="form-group col-md-4" style="margin-bottom: 0 !important;"><label class="form-label" for="res_ch_pension_res">Pension</label><select  style="font-size:12px!important;line-height: 1.5;" id="res_ch_pension_res" class="selectpicker form-control form-input"></select></div> <div class="form-group col-md-2" style="margin-bottom: 0 !important;"><label class="form-label" for="res_ch_chambre_res">Chambre</label><select  style="font-size:12px!important;line-height: 1.5;" id="res_ch_chambre_res" class="selectpicker form-control form-input"><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option></select></div><div class="form-group col-md-2" style="margin-bottom: 0 !important;"><label class="form-label" for="enfant_res">Enfant</label><select  style="font-size:12px!important;line-height: 1.5;" id="enfant_res" class="selectpicker form-control form-input"><option value="0">0</option><option>1</option> <option>2</option> <option>3</option> <option>4</option> <option>5</option> <option>6</option></select></div> <div class="form-group col-md-12 float-right" style="margin-bottom: 0 !important;padding: 5px;"> <button type="button" onclick="ajouterResCh()" class="btn btn-success float-right btn-reservation-modal"> Ajouter </button> </div></div></div></div></div>';

        $html_extra = '<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 5px!important;"> <div class="col-11"> <span style="font-style:italic;font-size: 28px;color: #011F28;font-weight: 700;">Ajouter les Extras</span> </div> <div class="col-1 title-close text-center"> <button  type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6"> <span style="color:#8A8E94"></span> </div> <div class="col-6"> <button type="button" style="border-radius: 2px;font-size: 12px;font-weight: 500;margin-bottom: 10px;visibility:collapse;" class="btn btn-info float-right" id="ajouterExtraBtn" onclick="ajouterEXForm(this);"><i class="fa fa-plus"></i> Ajouter un extra</button> </div> </div> </div><div class="container"><table id="TableExtra" style="margin-bottom:0;border-top: none;visibility:collapse" class="table"><thead style="color:#C5C4C6!important;border-top: none;"><th style="border-top: none;" width="35%">Extra</th><th style="border-top: none;" width="10%">Prix</th><th style="border-top: none;" width="10%" class="text-center">Actions</th></thead><tbody></tbody></table><div class="form-row"><div class="col-3"><select data-container="body" style="font-size:12px!important;line-height: 1.5;" id="mod_res_ch_ext" class="selectpicker form-control form-input">';
        foreach ($Aextras as $key => $extraa) {
          $html_extra .='<option value="'.$extraa['idExtra'].'">'.$extraa['extra'].'</option>';
        }
        $html_extra .='</select></div><div class="col-3"><select id="mod_res_pax_ext" class="selectpicker form-control form-input">'; 
        for ($i=1; $i < 10; $i++) {
            $html_extra .= '<option value="'.$i.'">'.$i.'</option>'; 
        } 
        $html_extra .='</select></div><div class="col-3"><select id="mod_res_dates_ext" class="selectpicker form-control form-input" multiple title="Dates Extra..." multiple></select></div> <div class="form-group col-md-3 float-right" style="margin-bottom: 15px !important;"> <button type="button" class="btn btn-success float-right hexa-btn-top-ajouter-ch" onclick="confirmerExtraReservation()"> Confirmer </button> </div></div></div> ';


          $html_reglment ='<div class="col-12"> <div class="row" style="background-color:#F8FAFF;border-bottom: 1px solid #DEE6F6;margin-bottom: 10px!important;"> <div class="col-11"> <span style="font-style:italic;font-size: 28px;color: #011F28;font-weight: 700;">Ajouter un reglement</span> </div> <div class="col-1 title-close text-center"> <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times-circle btn-closed"></i></button> </div> <div class="col-6"> <span style="color:#8A8E94"></span> </div> <div class="col-6 float-right"> </div> <div class="col-5 float-right" style="padding-bottom: 10px;padding-top: 10px">';
           $html_reglment .='<select class="selectpicker" id="PaimenetMet">';
                            foreach ($modePaiements as $key => $modePaiement) {
                              if($modePaiement['idModePaimenet']!=0){
                                $html_reglment .='<option value="'. $modePaiement['idModePaimenet'].'">'. $modePaiement['modePaiement'].'</option>';
                              }
                            }
           $html_reglment .='</select>';              
        
           $html_reglment .='</div> <div class="col-7" style="padding-bottom: 10px;padding-top: 10px"> <div class="form-row float-right">'; $html_reglment .='<button type="button" class="btn btn-secondary float-right" style="padding-left: 20px;padding-right: 20px;margin-right: 5px;border-radius: 2px;font-size: 12px;font-weight: 500"> <i class="fa fa-bed" style="font-size: 12px"></i> Par Chambre </button> <button type="button" class="btn btn-danger float-right" style="padding-left: 20px;padding-right: 20px;margin-right: 5px;border-radius: 2px;font-size: 12px;font-weight: 500" onclick="reglement(this,)"> <i class="fa fa-credit-card" style="font-size: 12px"></i> Regler la facture </button> </div> </div> </div>';

           //$html_reglment .='</div> </div> </div> </div> <div class="col-12" style="padding-bottom: 10px;"> <div class="row"> <div class="col-6"> <span class="title-lab">Client  <span class="text-labb"> </span></span> <span class="title-lab">Telephone  <span class="text-labb"> </span></span> <span class="title-lab">Email  <span class="text-labb"> </span></span> </div> <div class="col-6"> <span class="title-lab">Pays  <span class="text-labb"> </span></span> <span class="title-lab">Ville  <span class="text-labb"> </span></span> <span class="title-lab">Adresse  <span class="text-labb"> </span></span> </div> </div> </div> ';
            $html_reglment .='<div class="table-responsive"><table id="TableReglement" class="table table-striped"><thead class="hexa-header-reservation"><th>Date</th><th>Prestation</th><th class="text-center">Nbr</th><th style="text-align: right;">prix</th><th style="text-align: right;">Debit</th><th style="text-align: right;">Credit</th></thead><tbody> <tr id="total-table-reg"><td class="hexa-td-reglement">'.date('d/m/Y').'</td><td class="hexa-td-reglement" id="lab-reg">ESPECES</td><td class="hexa-td-reglement"></td><td class="hexa-td-reglement" style="text-align: right;">0.00</td><td class="hexa-td-reglement"></td><td class="hexa-td-reglement" style="text-align: right;" >0.00</td></tr> <tr><td style="font-size:12px">Total</td><td></td><td></td><td></td><td style="font-size:12px;text-align: right;">0.00</td><td style="font-size:12px;text-align: right;">0.00</td></tr><tr><td style="font-size:12px">Reste</td><td></td><td><td></td></td><td  style="font-size:12px;text-align: right;">0.00</td><td style="font-size:12px;text-align: right;">0.00</td></tr><tr><td style="font-size:12px">Payé</td><td></td><td></td><td></td><td style="font-size:12px;text-align: right;">0.00</td><td style="font-size:12px;text-align: right;">0.00</td></tr></tbody></table></div></div></tbody></table></div>';


            $results = array('status'=>true,'session'=>true,'reservation'=>$html_reservation,'chambres'=>$html_chambres,'extra'=>$html_extra,'reglment'=>$html_reglment,'clients'=>$clients,'channels'=>$channels,'tarifs'=>$tarifs,'tchambres'=>$chambres,'pays'=>$pays);
            echo json_encode(( $this->utf8ize( $results ) ));

    }

  }

  public function createRow(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $dateDu = $this->input->post('datDu');
        $dateAu = $this->input->post('dateAu');
        $pension = $this->input->post('pension');
        $typeChambre = $this->input->post('typeChambre');
        $totalAdult = $this->input->post('totalAdult');
        $totalEnfant = $this->input->post('totalEnfant');
        $qte = $this->input->post('qte');
        $dates = $this->TarifsModel->getTarifDate($dateDu,$dateAu,$typeChambre,$pension);
        $tt = $this->TarifsModel->getChannelTarif($typeChambre,$pension);
        $taxes = $this->HotelModel->getTaxes();
        $html_chambres ='';
        $html_reglement ='';

        for ($i=0; $i < $qte; $i++) { 
          if(count($dates)){
            
              $html_chambres .='<tr class="newRoom" data-ch="'.$tt.'" data-checkin="'.$dateDu.'" data-checkout="'.$dateAu.'"><td class="ty-chambre" style="line-height: 1"><span class="text-lab">'.$dates[0]['nomTypeChambres'].'</span><span class="text-labbb">'.$dates[0]['pension'].'</span></td> <td class="ty-chambre" style="line-height: 1"><span class="text-lab">#</span></td><td></td> <td style="line-height: 1" ><span class="text-lab">'.strftime("%d %B", strtotime($dateDu)).' - '.strftime("%d %B %G", strtotime($dateAu)).'</span><span class="text-labbb">2 nuits</span></td><td style="line-height: 1"><span class="text-lab">'.$totalAdult.' Adult</span><span class="text-labbb">'.$totalEnfant.' Enfant</span></td> <td class="text-center"><i style="padding-left: 5px;" class="fa fa-times clickable" ></i></td></tr>'; $total = 0;
                  $html_chambres .='<tr><td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="5"><div class="scrollmenu">';
                  foreach ($dates as $key => $dateR) {
                    $total += $dateR['prix'];
                    $html_chambres .='<div class="text-con" style="width: 100px;"><span class="text-datee text-center">'.strftime("%d/%m/%G", strtotime($dateR['date'])).'</span><input style="width: 80px;background-color: #FFF8F2;border:none" data-date="'.$dateR['date'].'" value="'.number_format($dateR['prix'],2,'.','').'" type="text" class="text-prix text-center"/></div>';
                    $html_reglement.='<tr><td style="font-size:12px">'.strftime("%d/%m/%G", strtotime($dateR['date'])).'</td><td  style="font-size:12px">'.$dateR['nomTypeChambres'].'</td><td class=" text-center" style="font-size:12px">'.$qte.'</td><td style="font-size:12px;text-align: right">'.number_format($dateR['prix'],2,'.','').'</td><td  style="font-size:12px;text-align: right">'.number_format($dateR['prix'],2,'.','').'</td><td></td></tr>';

                    $paxxx = $totalAdult;

                    if(count($taxes)>0){
                          foreach ($taxes as $key => $taxe) {

                            if($taxe['typeTax'] == 1){
                                 if($taxe['parPerson']){
                                    $pax = $paxxx;
                                 }else{
                                    $pax =1;
                                 }

                                 if($taxe['parNuit']){
                                    $nbr = $qte;
                                 }else{
                                    $nbr =1;
                                 }

                              if($taxe['typeValeur'] == 2){

                                $taxValeur = $taxe['valeur'];

                                $valeur = $pax * $nbr * $taxe['valeur'];

                              }else{

                                  $taxValeur =(($taxe['valeur']/100) * ($pp* 1/$reservation->changeRate));

                                  $valeur = $pax * $nbr *(($taxe['valeur']/100) * ($pp* 1/$reservation->changeRate));
                              }


                              $html_reglement .='<tr><td  class="hexa-td-reglement">'.strftime("%d/%m/%G", strtotime($dateR['date'])).'</td><td class="hexa-td-reglement">'.$taxe['tax'].'</td><td class="hexa-td-reglement text-center">'.$paxxx*$qte.'</td><td class="hexa-td-reglement" style="text-align: right;">'.number_format($taxValeur,2).'</td><td class="hexa-td-reglement" style="text-align: right;">'.number_format($valeur,2).'</td><td class="hexa-td-reglement" ></td></tr>';
                              
                            }

                          }

                        }
                  }
                  $html_chambres .='</div></td><td style="background: #177AAF;padding: 0;"><span class="text-center" style="font-size: 14px;display: block;font-weight: 600;color: #fff; font-style: italic;">Total</span><span class="text-center" style="font-size: 14px;display: block;font-weight: 600;color: #fff;font-style: italic;">'.number_format($total ,2,'.','').'</span></td></tr>';
                }
          }
          $results = array('status'=>true,'session'=>true,'chambres'=>$html_chambres,'row_reglement'=>$html_reglement);
          echo json_encode(( $this->utf8ize( $results ) ));


    }

  }

  public function newReservation(){

    $id = $this->session->userdata('id');
    if(!$id){
        $this->load->view('login');
    }else{
      $data['clients'] = $this->ReservationsModel->getCardex();

      $data['channels'] = $this->ClientsModel->getClients();

      $data['pensions'] = $this->PensionsModel->getPensions();

      $data['chambres'] = $this->ChambresModel->getTypesChambres();

      $this->load->view('templates/header');
      $this->load->view('newReservation',$data);
      $this->load->view('templates/footer');
    }

  }

  public function reservationContent(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

       setlocale(LC_TIME, "fr_FR"); 

       $idReservation = $this->input->post('idReservation');

       $results = $this->getContentReservation($idReservation);
       echo json_encode(( $this->utf8ize( $results ) ));

    }

  }


  public function getReservationHR()
  {

    $token = 'pxPam45IjpGGH58AgWLjN1WW1WHDT0mtx1XEVmeM';
    echo $id_HR = '341486717';

    

    $result = $this->curl->simple_get('https://app.hotelrunner.com/api/v2/apps/reservations?token=pxPam45IjpGGH58AgWLjN1WW1WHDT0mtx1XEVmeM&hr_id=341486717');

    var_dump($result);
    die;


    $this->curl->create('https://app.hotelrunner.com/api/v2/apps/reservations?token=pxPam45IjpGGH58AgWLjN1WW1WHDT0mtx1XEVmeM&hr_id=341486717');
    //  Rest Of The Code As In controller_curl.php
    $this->curl->option('connecttimeout', 600);

    // For SSL Sites. Check whether the Host Name you are connecting to is valid
    $this->curl->option('SSL_VERIFYPEER', false);

    //  Ensure that the server is the server you mean to be talking to
    $this->curl->option('SSL_VERIFYHOST', false);

    // Defines the SSL Version to be Used
    $this->curl->option('SSLVERSION', 3);

    //  To Temporarily Store Data Received From Server
    $this->curl->option('buffersize', 10);

    //  To support Different Browsers
    $this->curl->option('useragent', 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8 (.NET CLR 3.5.30729)');

    //  To Receive Data Returned From Server
    $this->curl->option('returntransfer', 1);

    //  To follow The URL Provided For Website
    $this->curl->option('followlocation', 1);

    //  To Retrieve Server Related Data
    $this->curl->option('HEADER', true);

    //  To Set Time For Process Timeout
    $this->curl->option('connecttimeout', 600);





    $data = $this->curl->execute();

    var_dump($data);



    var_dump($this->curl->error());

  }
  public function cancelRoom(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $idReservation = $this->input->post('idReservation');
      $idCR = $this->input->post('idCR');

      if($this->ReservationsModel->caneclRoom($idReservation,$idCR,$id)){

        $results = $this->contentReservationP($idReservation);
        echo json_encode(( $this->utf8ize( $results ) ));

      }else{
        $results = array('status'=>false,'session'=>true);
        echo json_encode(( $this->utf8ize( $results ) ));

      }

    }

  }

  public function updateRoom(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $idDCR = $this->input->post('idDCR');
      $prix = $this->input->post('prix');
      $taux = $this->input->post('taux');
      $pension = $this->input->post('pension');
      $prixChanged = $this->input->post('prixChanged');
      $idReservation = $this->input->post('idReservation');

    
      $nprix = $prix*$taux;


      if($this->ReservationsModel->updateRoom($idDCR,$prix,$pension,$prixChanged,$nprix)){

        $results = $this->getContentReservation($idReservation);
        echo json_encode(( $this->utf8ize( $results ) ));

      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

      }
    }

  }

  public function updateOldReservation(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $json = $this->input->post('json');
      $idReservation = $this->input->post('idReservation');

        $reservation_json = json_decode($json); 


        $adresse = $reservation_json->adresse;
        $ville = $reservation_json->ville;
        $idPays = $reservation_json->nationalite;
        $email = $reservation_json->email;
        $tel = $reservation_json->tel;
        $nom = $reservation_json->res_client;
        $reason = $reservation_json->reason;
        $note = $reservation_json->note;
        $newIdReservation = $this->ReservationsModel->getAndUpdate($idReservation,$reason,$reservation_json->state,$adresse,$ville,$idPays,$email,$tel,$nom,$reservation_json->channel,$reservation_json->channel_display,$reservation_json->checkin_date,$reservation_json->checkout_date,$note);

      if($newIdReservation>0){

        $results = $this->getContentReservation($newIdReservation);
        echo json_encode(( $this->utf8ize( $results ) ));

      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));

      }
    }
  }

  public function addNewReservation(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $json = $this->input->post('json');


        $this->load->helper('string');


        $provider_number =  random_string('numeric', 16);

        $dateReserve = date('Y-m-d H:i:sa');

        $cancel_reason = '';

        // echo $json; die;
        $reservation_json = json_decode($json); 

        $adresse = $reservation_json->adresse;
        $ville = $reservation_json->ville;
        $idPays = $reservation_json->nationalite;
        $email = $reservation_json->email;
        $tel = $reservation_json->tel;
        $nom = $reservation_json->res_client;
        $reason = $reservation_json->reason;
        $note = $reservation_json->note;
        $reservation_json->payment = 'not_provided';


        if($reservation_json->data_cli == 0){

          $idCardex = $this->ReservationsModel->insertCardex($adresse,$ville,$idPays,$email,$tel,$nom);

        }else{

          $idCardex = $reservation_json->data_cli;

        }

          $idResevation = $this->ReservationsModel->insert($provider_number,$provider_number, $reservation_json->channel,$reservation_json->channel_display,$reason,$reservation_json->state,$reservation_json->modified,$nom,$cancel_reason,$reservation_json->sub_total,$reservation_json->extras_total,$reservation_json->adjustments_total,$reservation_json->tax_total,$reservation_json->total,$reservation_json->currency,$note,$reservation_json->checkin_date,$reservation_json->checkout_date,$reservation_json->payment,$reservation_json->paid_amount,$dateReserve,$dateReserve,$idCardex,1,1,'','','PMS');


                if(count($reservation_json->rooms)>0){

                  foreach ($reservation_json->rooms as $key => $room) {

                    $earlier = new DateTime($room->checkin_date);
                    $later = new DateTime($room->checkout_date);

                    $nights = $later->diff($earlier)->format("%a");


                    $idRoomReservation = $this->ReservationsModel->insertRoom($provider_number, $room->price,$room->non_refundable,$room->checkin_date,$room->checkout_date,$nights, $room->rate_code,$room->inv_code,$room->total_guest,$room->total_adult,0,$room->state,$idResevation);

                    if($idRoomReservation){
                      if(count($room->daily_prices)>0){
                        foreach ($room->daily_prices as $key => $daily_prices) {

                          $this->ReservationsModel->insertDay($idRoomReservation, $daily_prices->date,$daily_prices->price,$provider_number,$room->rate_code,$idResevation);

                        }
                      }
                    }

                  }

                }
                print json_encode(array('status'=>true,'session'=>true));
    }
  }

  public function callback(){

    
    $json = ($this->input->post('data')) ? $this->input->post('data') : '' ;

    if($this->LogsModel->insert(1,$json)){

      if($json){

        $token = $this->input->get('token');
        $hr_id = $this->input->get('hr_id');
        $reservation_json = json_decode($json); 


        if(isset($reservation_json->hr_number)){

              $currency = isset($reservation_json->currency) ? $reservation_json->currency : 'EUR' ;

              $taux = $this->ReservationsModel->getDeviseBase($currency,false);

              $reason = isset($reservation_json->reason) ? $reservation_json->reason : '' ;

              $provider_number = isset($reservation_json->provider_number) ? $reservation_json->provider_number : 0 ; 

              $nom = isset($reservation_json->guest) ? $reservation_json->guest : '' ;

              $cancel_reason = isset($reservation_json->cancel_reason) ? $reservation_json->cancel_reason : '' ;
              $note = isset($reservation_json->note) ? $reservation_json->note : '' ;



              $ville = isset($reservation_json->address->city) ? $reservation_json->address->city : '' ;
              $idPays = isset($reservation_json->address->country_code) ? $reservation_json->address->country_code : 'NN' ;
              $tel = isset($reservation_json->address->phone) ? $reservation_json->address->phone : '' ;
              $email = isset($reservation_json->address->email) ? $reservation_json->address->email : '@' ;
              $adresse = isset($reservation_json->address->street) ? $reservation_json->address->street : '' ;
              $adresse .= isset($reservation_json->address->street_2) ? $reservation_json->address->street_2 : '' ;



              $idCardex = $this->ReservationsModel->insertCardex($adresse,$ville,$idPays,$email,$tel,$nom);

              $canceled = ($reservation_json->state == 'canceled') ? 1 : 0;

              $total_guests=isset($reservation_json->total_guests) ? $reservation_json->total_guests : 0 ;
              $total_rooms=isset($reservation_json->total_rooms) ? $reservation_json->total_rooms : 0 ;
              $guest_national_id=isset($reservation_json->guest_national_id) ? $reservation_json->guest_national_id : '' ;
              $message_uid=isset($reservation_json->message_uid) ? $reservation_json->message_uid : '' ;
              $source_display=isset($reservation_json->source_display) ? $reservation_json->source_display : '' ;

              $idReservation = $this->ReservationsModel->insert($reservation_json->hr_number,$provider_number, $reservation_json->channel,$reservation_json->channel_display,$reason,$reservation_json->state,$reservation_json->modified,$nom,$cancel_reason,$reservation_json->sub_total,$reservation_json->extras_total,$reservation_json->adjustments_total,$reservation_json->tax_total,$reservation_json->total,$currency,$note,$reservation_json->checkin_date,$reservation_json->checkout_date,$reservation_json->payment,$reservation_json->paid_amount,$reservation_json->completed_at,$reservation_json->updated_at,$idCardex,$total_guests,$total_rooms,$guest_national_id,$message_uid,$source_display,$taux,$canceled);

            if($idReservation){

              if(count($reservation_json->rooms)>0){

                foreach ($reservation_json->rooms as $key => $room) {


                  $idTarif = $this->TarifsModel->checkTarifChannel($room->rate_code,$room->inv_code);

                  $canceledRoom = ($room->state == 'canceled') ? 1 : 0;

                  $extra_info = isset($room->extra_info) ? $room->extra_info : '' ;

                  $meal_plan = isset($room->meal_plan) ? $room->meal_plan : '' ;

                  $meal_plan_presentation = isset($room->meal_plan_presentation) ? $room->meal_plan_presentation : '' ;

                  $name = isset($room->name) ? $room->name : '' ;

                  $idRoomReservation = $this->ReservationsModel->insertRoom($provider_number, $room->price,$room->non_refundable,$room->checkin_date,$room->checkout_date,$room->nights, $room->rate_code,$room->inv_code,$room->total_guest,$room->total_adult,0,$room->state,$idReservation,$meal_plan,$meal_plan_presentation,$name,$extra_info,$canceledRoom);

                  if($idRoomReservation){

                    if(count($room->child_ages)>0){
                      foreach ($room->child_ages as $key => $child_age) {

                        $this->ReservationsModel->insertEnfant($idRoomReservation,$idReservation,$child_age);

                      }
                    }

                    if(count($room->daily_prices)>0){
                      foreach ($room->daily_prices as $key => $daily_prices) {

                        $this->ReservationsModel->insertDay($idRoomReservation, $daily_prices->date,$daily_prices->price,$provider_number,$idTarif,$idReservation);

                      }
                    }
                    if(count($room->extras)>0){
                      foreach ($room->extras as $key => $extra) {

                        $this->ReservationsModel->insertExtra($extra->name,$extra->price,$idRoomReservation,$idReservation,$extra->code);


                      }
                    }
                  }


                }

              }
              
              if($reason == 'cancel'){
                $this->ReservationsModel->insertActivite(4,0,$idReservation);
              }elseif($reason == 'confirm'){
                $this->ReservationsModel->insertActivite(3,0,$idReservation);
              }elseif($reason == 'modify'){
                $this->ReservationsModel->insertActivite(5,0,$idReservation);
              }
              print json_encode(array('status' => "ok"));
            }
        }

      

    
      }


    }

  }

  public function syncExtra(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
          $extra = $this->input->post('extra');
          $pax = $this->input->post('pax');
          $dates = $this->input->post('dates');
          $prix = $this->input->post('prix');

          $idReservation = $this->input->post('idReservation');
          $idCR = $this->input->post('idCR');
          $idExtraRes = $this->input->post('idExtraRes');

          foreach ($dates as $key => $date) {

            $pricu = $prix / $pax / count($dates);

            $this->ExtrasModel->syncExtra($extra,$pricu,$pax,$date,$idReservation,$idCR,$idExtraRes);

          }

          if($this->ExtrasModel->updateExtraReservation($extra,$idExtraRes)){
            $results = $this->getContentReservation($idReservation);
            echo json_encode(( $this->utf8ize( $results ) ));

          }else{
              $results = array('status'=>false,'session'=>true);
              echo json_encode(( $this->utf8ize( $results ) ));

          }
    }
  }

  public function getCaredexFromLog(){

    $logs = $this->LogsModel->getLogs(1);
    foreach ($logs as $key => $log) {
      $string = $log['request'];

      $string = preg_replace("/[\r\n]+/", " ", $string);
      $json = utf8_encode($string);
      //$json = json_decode($json);

      $reservation_json = json_decode($json); 

      // echo $json = $log['request'].'<br><br><br><span style="color:red">numero : #'.$reservation_json->provider_number.'</span><br><br>';
      // var_dump($reservation_json);
      $providerId =  ($reservation_json->provider_number) ? $reservation_json->provider_number : 0 ;

      $nom = ($reservation_json->guest) ? $reservation_json->guest : '' ;


      $ville = $reservation_json->address->city;
      $idPays = $reservation_json->address->country_code;
      $tel = $reservation_json->address->phone;
      $email = $reservation_json->address->email;
      $adresse = $reservation_json->address->street;
      $adresse .= ($reservation_json->address->street_2) ? $reservation_json->address->street_2 : '' ;
      $idCardex = $this->ReservationsModel->insertCardex($adresse,$ville,$idPays,$email,$tel,$nom);

      $this->ReservationsModel->updateCardexReservation($providerId,$idCardex);
      
    }

  }

  public function setAffectationChambre(){

    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $idReservation = $this->input->post('idReservation');
      $idCh = $this->input->post('idCh');
      $dateDu = $this->input->post('dateDu');
      $dateAu = $this->input->post('dateAu');
      $idRes = $this->input->post('idRes');
      if($this->ReservationsModel->setAffectatinCh($idReservation,$idCh)){
          $results = $this->getContentReservation($idRes);        
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
      }
    }
  }


  public function setReglement(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $idReservation = $this->input->post('idReservation');
      $idCR = $this->input->post('idCR');
      $total = $this->input->post('total');
      $idModePaimenet = $this->input->post('idModePaimenet');
      $reglements = $this->input->post('reglements');
      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture; 

      if($this->ReglementsModel->insert($idReservation,$total,$idModePaimenet,$id,$reglements,$dateCloture)){
          $results = $this->contentReservationP($idReservation);        
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
      }

    }

  }



  public function setCheckinChambre(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{
      $idReservation = $this->input->post('idReservation');
      $idCR = $this->input->post('idCR');

      if($this->ReservationsModel->setCheckin($idCR,$idReservation)){
          $results = $this->getContentReservation($idReservation);        
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
      }
    }



  }

  public function setCheckoutChambre(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{


      $idReservation = $this->input->post('idReservation');
      $idCR = $this->input->post('idCR');
      $model = $this->input->post('model');
      $cloture = $this->HotelModel->getCloture();
      $dateCloture = $cloture->dateCloture; 

      // if($this->ReservationsModel->checkReservationReglement($idReservation)){
        if($this->ReservationsModel->setCheckout($idCR,$idReservation,$dateCloture,$id)){
          if($model){
            $results = $this->getContentReservation($idReservation);  
          }else{
            $results = $this->contentReservationP($idReservation);  
          }   
          echo json_encode(( $this->utf8ize( $results ) ));
        }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
        }
      // }else{
      //   $results = array('status'=>true,'session'=>true,'paid'=>false);
      //   echo json_encode(( $this->utf8ize( $results ) ));  
      // }


    }



  }

  public function setCheckin(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

      $idReservation = $this->input->post('idReservation');

      if($this->ReservationsModel->setCheckin(0,$idReservation,false)){
          $results = $this->getContentReservation($idReservation);        
          echo json_encode(( $this->utf8ize( $results ) ));
      }else{
          $results = array('status'=>false,'session'=>true);
          echo json_encode(( $this->utf8ize( $results ) ));
      }

    }



  }

  public function setCheckout(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $idReservation = $this->input->post('idReservation');
        $cloture = $this->HotelModel->getCloture();
        $dateCloture = $cloture->dateCloture; 

        if($this->ReservationsModel->setCheckout(0,$idReservation,$dateCloture,false)){
            $results = $this->getContentReservation($idReservation);        
            echo json_encode(( $this->utf8ize( $results ) ));
        }else{
            $results = array('status'=>false,'session'=>true);
            echo json_encode(( $this->utf8ize( $results ) ));
        }
    }



  }

  public  function delogerRoom(){
    $id = $this->session->userdata('id');
    if(!$id){
        $results = array('status'=>true,'session'=>false);
        echo json_encode(( $this->utf8ize( $results ) ));
    }else{

        $idReservation = $this->input->post('idReservation');
        $idCR = $this->input->post('idCR');
        $date = $this->input->post('date');
        $checkout = $this->input->post('checkout');
        $ch = $this->input->post('ch');


        $earlier = new DateTime($date);
        $later = new DateTime($checkout);

        $nights = $later->diff($earlier)->format("%a");


        $this->ReservationsModel->getRoomAndInsert($idReservation,$idCR,$date,$checkout,$ch,$nights);




        // $results = array('status'=>true,'session'=>true);
        // echo json_encode(( $this->utf8ize( $results ) ));

        // $idReservation = $this->input->post('idReservation');
        // $cloture = $this->HotelModel->getCloture();
        // $dateCloture = $cloture->dateCloture; 

        // if($this->ReservationsModel->setCheckout(0,$idReservation,$dateCloture,false)){
        //     $results = $this->getContentReservation($idReservation);        
        //     echo json_encode(( $this->utf8ize( $results ) ));
        // }else{
        //     $results = array('status'=>false,'session'=>true);
        //     echo json_encode(( $this->utf8ize( $results ) ));
        // }
    }
  }



  private function calculateTimeAgo($date){

      // Declare timestamps
      $last = new DateTime($date);
      $now = new DateTime( date( 'Y-m-d h:i:s', time() )) ; 

      // Find difference
      $interval = $last->diff($now);

      // Store in variable to be used for calculation etc
      $years = (int)$interval->format('%Y');
      $months = (int)$interval->format('%m');
      $days = (int)$interval->format('%d');
      $hours = (int)$interval->format('%H');
      $minutes = (int)$interval->format('%i');

        if($years > 0)
        {
            $timeAgo =  $years.' Years '.$months.' Months '.$days.' Days '. $hours.' Hours '.$minutes.' minutes ago.' ;
        }
        else if($months > 0)
        {
            $timeAgo =  $months.' Months '.$days.' Days '. $hours.' Hours '.$minutes.' minutes ago.' ;
        }
        else if($days > 0)
        {
            $timeAgo =  $days.' Days '.$hours.' Hours '.$minutes.' minutes ago.' ;
        }
        else if($hours > 0)
        {
            $timeAgo =  $hours.' Hours '.$minutes.' minutes ago.' ;
        }
        else
        {
            $timeAgo =  $minutes.' minutes ago.' ;
        }
  }



  private function utf8ize( $mixed ) {
      if (is_array($mixed)) {
          foreach ($mixed as $key => $value) {
              $mixed[$key] = $this->utf8ize($value);
          }
      } elseif (is_string($mixed)) {
          return mb_convert_encoding($mixed, "UTF-8", "UTF-8");
      }
      return $mixed;
  }

  function getEtatCh($etat)
  {
    switch ($etat) {
        case 'checkout':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Checkout</span>';
            break;
        case 'checkin':
            return '<span style="font-style:italic;font-weight:800;color:#845F03">Checkin</span>';
            break;
        case 'noshow':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Noshow</span>';
            break;
        case 'modify':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Modifié</span>';
            break;
        case 'canceled':
            return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
            break;
        case 'confirm':
            return '<span style="font-style:italic;font-weight:800;color:#2a9d8f">Reservée</span>';
            break;
        case 'confirmed':
            return '<span style="font-style:italic;font-weight:800;color:#2a9d8f">Reservée</span>';
            break;
        case 'cancel':
            return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
            break;
        default:
            return 'N/A';
            break;
    }
  }

  private function getEtat($etat){

      switch ($etat) {
          case 'noshow':
              return '<span style="font-style:italic;font-weight:800">Noshow</span>';
              break;
          case 'checkin':
              return '<span style="font-style:italic;font-weight:800">Checkin</span>';
              break;    
          case 'checkout':
              return '<span style="font-style:italic;font-weight:800">Checkout</span>';
              break;  
          case 'modify':
              return '<span style="font-style:italic;font-weight:800;color:#0096c7">Modifié</span>';
              break; 
          case 'canceled' :
              return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
              break;  
          case 'confirm':
              return '<span style="font-style:italic;font-weight:800;color:#2a9d8f">Reservée</span>';
              break;  
          case 'cancel' :
              return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
              break;                      
          default:

              return 'N/A';
              break;
      }
  }

  private function getEtatList($etat){

      switch ($etat) {
          case 'noshow':
              return 'Noshow';
              break;
          case 'checkin':
              return 'Checkin';
              break;    
          case 'checkout':
              return 'Checkout';
              break;  
          case 'modify':
              return 'Modifiée';
              break; 
          case 'canceled' :
              return 'Annulée';
              break;  
          case 'confirm':
              return 'Reservée';
              break;  
          case 'cancel' :
              return 'Annulée';
              break;                      
          default:

              return 'N/A';
              break;
      }
  }

}