<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Tarifs extends CI_Controller
{
	public function index()
	{
		$id = $this->session->userdata('id');
	    if(!$id){
	      $this->load->view('login');
	    }else{

	      	$cloture = $this->HotelModel->getCloture();
	      	$dateCloture = $cloture->dateCloture; 

	      	$footer['title'] = 'Tarifs';

	      	$header['title'] ="Tarifs";

	      	$header['page'] ="Tarifs";

	      	$header['hotel'] = $this->session->userdata('hotel');

	      	$header['nom'] = $this->session->userdata('nom');

	      	$header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

	      	$data['dateC'] = $dateCloture;
			$data['tarifs'] = $this->TarifsModel->getTarifs();

			$this->load->view('templates/header',$header);
			$this->load->view('tarifs',$data);
			$this->load->view('templates/footer',$footer);

	  	}		
	}


	public function contrats($idTarif = 0){


		$id = $this->session->userdata('id');
	    if(!$id){
	      $this->load->view('login');
	    }else{

	    	if($idTarif == 0){

	    		$this->index();


	    	}else{

		    	$cloture = $this->HotelModel->getCloture();
		      	$dateCloture = $cloture->dateCloture; 

		      	$footer['title'] = 'Tarifs';

		      	$header['title'] ="Tarifs";

		      	$header['page'] ="Tarifs";

		      	$header['hotel'] = $this->session->userdata('hotel');

		      	$header['nom'] = $this->session->userdata('nom');

		      	$header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));

		      	$data['dateC'] = $dateCloture;

		      	$data['tarif'] = $this->TarifsModel->getTarif($idTarif);

		      	if(count($data['tarif'])==0){ $this->index(); return; }

		      	$data['periodes'] = $this->PeriodesModel->getContratPeriode($idTarif);

				$this->load->view('templates/header',$header);
				$this->load->view('contrats',$data);
				$this->load->view('templates/footer',$footer);	
	    	}



	    }
	}


	public function updatePeriode(){

		$idTarif = $this->input->post('idTarif');
		$periode = $this->input->post('periode');
		$saison = $this->input->post('saisons');
		$dateDebut = $this->input->post('dateDebut');
		$dateFin = $this->input->post('dateFin');

		$tarif = $this->TarifsModel->getTarif($idTarif);

		$siasons = $this->SaisonsModel->getSaisons();

		$chambres = $this->ChambresModel->getTypesChambres();

		$pensions = $this->PensionsModel->getPensionsTarifs($idTarif);




		$html ='<div class="row"> <div class="col-4"><span class="title-lab">Saison</span><span class="text-lab"> <select id="saison" class="selectpicker form-control form-input">'; 
		foreach ($siasons as $key => $siason) {
             $html.='<option value="'.$siason['idSaison'].'">'.$siason['saison'].'</option>';
        }

        $html.='</select></span></div> <div class="col-4"> <span class="title-lab">Date debut</span><span class="text-lab"> <div class="input-group md-form form-sm form-2 pl-0"> <input type="text" style="line-height: 1.5;" class="date-hexa datepicker form-control" id="dateD1" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey" aria-hidden="true"></i></span></div> </div> </div> <div class="col-4"> <span class="title-lab">Date fin</span><span class="text-lab"> <div class="input-group md-form form-sm form-2 pl-0"> <input type="text" style="line-height: 1.5;" class="date-hexa datepicker form-control" id="dateF1" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey" aria-hidden="true"></i></span></div> </div> </div> </div> <hr>';
		if(count($chambres)>0){
			$html .='<table id="tablePrix" class="table table-bordered"><thead></thead><tbody><th>Type chambre</th>';
			foreach ($pensions as $key => $pension) {
				$html .='<th class="text-center">'.$pension['codePension'].' ('.$pension['codePassage'].')</th>';
			}
			foreach ($chambres as $key => $chambre) {

				$html .='<tr><td><span class="text-chambre">'.$chambre['nomTypeChambres'].'</span></td>';

				foreach ($pensions as $key => $pension) {

					$period = $this->PeriodesModel->getPeriode($saison,$pension['idDetTar'],$chambre['idTypeChambres'],$dateDebut,$dateFin);

					if(count($period)>0){
						$html .='<td class="text-center"><input data-peroid="'.$period[0]['idPeriode'].'" data-chambre="'.$chambre['idTypeChambres'].'" data-pension="'.$pension['idDetTar'].'" value="'.$period[0]['prix'].'" placeholder="0" type="text" class="text-prix customerIDCell"></td>';
					}else{
						$html .='<td class="text-center"><input data-peroid="0" data-chambre="'.$chambre['idTypeChambres'].'" data-pension="'.$pension['idDetTar'].'" placeholder="0" type="text" class="text-prix customerIDCell"></td>';
					}
	
				}
				$html .='</tr>';
			}
			$html .='</tbody></table>';
		}

		$results = array('status'=>true,'session'=>true,'html'=>$html);
		echo json_encode(( $this->utf8ize( $results ) ));

	}

	public function createPeriode(){


		$idTarif = $this->input->post('idTarif');

		$tarif = $this->TarifsModel->getTarif($idTarif);

		$siasons = $this->SaisonsModel->getSaisons();

		$chambres = $this->ChambresModel->getTypesChambres();

		$pensions = $this->PensionsModel->getPensionsTarifs($idTarif);

		$html ='<div class="row"> <div class="col-4"><span class="title-lab">Saison</span><span class="text-lab"> <select id="saison" class="selectpicker form-control form-input">'; 
		foreach ($siasons as $key => $siason) {
              	$html.='<option value="'.$siason['idSaison'].'">'.$siason['saison'].'</option>';
            }
        $html.='</select></span></div> <div class="col-4"> <span class="title-lab">Date debut</span><span class="text-lab"> <div class="input-group md-form form-sm form-2 pl-0"> <input type="text" style="line-height: 1.5;" class="date-hexa datepicker form-control" id="dateD" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey" aria-hidden="true"></i></span></div> </div> </div> <div class="col-4"> <span class="title-lab">Date fin</span><span class="text-lab"> <div class="input-group md-form form-sm form-2 pl-0"> <input type="text" style="line-height: 1.5;" class="date-hexa datepicker form-control" id="dateF" /> <div class="input-group-append"> <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey" aria-hidden="true"></i></span></div> </div> </div> </div> <hr>';
		if(count($chambres)>0){
			$html .='<table id="tablePrix" class="table table-bordered"><thead></thead><tbody><th>Type chambre</th>';
			foreach ($pensions as $key => $pension) {
				$html .='<th class="text-center">'.$pension['codePension'].' ('.$pension['codePassage'].')</th>';
			}
			foreach ($chambres as $key => $chambre) {

				$html .='<tr><td><span class="text-chambre">'.$chambre['nomTypeChambres'].'</span></td>';

				foreach ($pensions as $key => $pension) {
					$html .='<td class="text-center"><input data-chambre="'.$chambre['idTypeChambres'].'" data-pension="'.$pension['idDetTar'].'" placeholder="0" type="text" class="text-prix customerIDCell"></td>';
				}
				$html .='</tr>';
			}
			$html .='</tbody></table>';
		}

		$results = array('status'=>true,'session'=>true,'html'=>$html);
		echo json_encode(( $this->utf8ize( $results ) ));
	}


	public function createTarif(){
		$id = $this->session->userdata('id');
	    if(!$id){
	      $this->load->view('login');
	    }else{
	    	$cloture = $this->HotelModel->getCloture();
	      	$dateCloture = $cloture->dateCloture; 

	      	$footer['title'] = 'Tarifs';

	      	$header['title'] ="Tarifs";

	      	$header['page'] ="Tarifs";

	      	$header['hotel'] = $this->session->userdata('hotel');

	      	$header['nom'] = $this->session->userdata('nom');

	      	$header['date'] =ucwords(utf8_encode(strftime('%d %b %Y',strtotime($dateCloture))));
			$data['pensions'] = $this->PensionsModel->getPensions();
			$data['passages'] = $this->PensionsModel->getTypesPassage();
			$data['tarifs'] = $this->TarifsModel->getTarifs();
			$this->load->view('templates/header',$header);
			$this->load->view('createTarif',$data);
			$this->load->view('templates/footer',$footer);	
		}

	}

	public function createSaison(){

		$dated = $this->input->post('dated');
		$dated = date("Y-m-d", strtotime($dated));
		$datef = $this->input->post('datef');
		$datef = date("Y-m-d", strtotime($datef));
		$tarif = $this->input->post('tarif');
		$saison = $this->input->post('saison');
		$rates = $this->input->post('rates');

		if(count($rates)>0){
      		$i = 0;
			foreach ($rates as $key => $rate) {
				$date = $dated;				
				$periode = $this->PeriodesModel->insert($rate['idch'],$rate['pens'],$dated,$datef,$saison,$rate['prix'],$tarif); 

				if($periode['status']){

					while (strtotime($date) <= strtotime($datef)) {


		              $insert_data[$i]['idDetailTarif'] = $rate['pens'];
		              $insert_data[$i]['date'] = $date;
		              $insert_data[$i]['prix'] = $rate['prix'];
		              $insert_data[$i]['idTypesChambre'] = $rate['idch'];
		              $i++;
					  $date = date ("Y-m-d", strtotime("+1 day", strtotime($date)));

					}
				}else{
					if($periode['result']){

      					$results = array('status'=>false,'session'=>true,'overlapping'=>false);
      					echo json_encode(( $this->utf8ize( $results ) ));
      					return;
					}else{
						$results = array('status'=>false,'session'=>true,'overlapping'=>true,'rowa'=>$periode['rows']);
      					echo json_encode(( $this->utf8ize( $results ) ));
      					return;
					}
		        }
			}

			if(isset($insert_data)){
	  			if($this->TarifsModel->insertTarifJour($insert_data)){
	          		$results = array('status'=>true,'session'=>true,'overlapping'=>false);
	          		echo json_encode(( $this->utf8ize( $results ) ));
	        	}else{
	          		$results = array('status'=>false,'session'=>true,'overlapping'=>false);
	          		echo json_encode(( $this->utf8ize( $results ) ));      
	        	}
			}else{
      			$results = array('status'=>false,'session'=>true,'overlapping'=>false);
      			echo json_encode(( $this->utf8ize( $results ) ));
			}
		}else{
      		$results = array('status'=>false,'session'=>true,'overlapping'=>false);
      		echo json_encode(( $this->utf8ize( $results ) ));
    	}
	}


	public function insertTarif(){

		$id = $this->session->userdata('id');
	    if(!$id){
	        $results = array('status'=>true,'session'=>false);
        	echo json_encode(( $this->utf8ize( $results ) ));
	    }else{


			$nomtar = $this->input->post('nomtar');
			$ctarif = $this->input->post('ctarif');
			$idtt = $this->input->post('idtt');
			$tpassages = $this->input->post('tpassages');
			$pensions = $this->input->post('pensions');

			if(count($tpassages)==0){				$results = array('status'=>false,'session'=>true);
				echo json_encode(( $this->utf8ize( $results ) ));}

			if(count($pensions)==0){				$results = array('status'=>false,'session'=>true);
				echo json_encode(( $this->utf8ize( $results ) ));}

			if($this->TarifsModel->insertTarif($nomtar,$idtt,$ctarif,$pensions,$tpassages)){

				$results = array('status'=>true,'session'=>true);
				echo json_encode(( $this->utf8ize( $results ) ));	

			}else{
				$results = array('status'=>false,'session'=>true);
				echo json_encode(( $this->utf8ize( $results ) ));		
			}





	    }


	}







	private function utf8ize( $mixed ) {
	    if (is_array($mixed)) {
	        foreach ($mixed as $key => $value) {
	            $mixed[$key] = $this->utf8ize($value);
	        }
	    } elseif (is_string($mixed)) {
	        return mb_convert_encoding($mixed, "UTF-8", "UTF-8");
	    }
	    return $mixed;
	}
}
