<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
// IMPORTANT - Replace the following line with your path to the escpos-php autoload script
require_once APPPATH . 'third_party/autoloader.php';
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\Printer;
class ReceiptPrint {

  private $CI;
  private $connector;
  private $printer;
  private $img_logo; // i add this line


  // TODO: printer settings
  // Make this configurable by printer (32 or 48 probably)
    private $printer_width = 32;
    function __construct()
    {
      $this->CI =& get_instance(); // This allows you to call models or other CI objects with $this->CI->... 
    }
    function connect($ip_address, $port)
    {
      $this->connector = new NetworkPrintConnector($ip_address, $port);
      $this->printer = new Printer($this->connector);
      //$this->img_logo = EscposImage::load(__DIR__ . "assets/images/logo.png", false); // this line give an error image not found
    }
    private function check_connection()
    {
      if (!$this->connector OR !$this->printer OR !is_a($this->printer, 'Mike42\Escpos\Printer')) {
        throw new Exception("Tried to create receipt without being connected to a printer.");
      }
    }
    public function close_after_exception()
    {
      if (isset($this->printer) && is_a($this->printer, 'Mike42\Escpos\Printer')) {
        $this->printer->close();
      }
      $this->connector = null;
      $this->printer = null;
      $this->emc_printer = null;
      }
      // Calls printer->text and adds new line
    private function add_line($text = "", $should_wordwrap = true)
    {
      $text = $should_wordwrap ? wordwrap($text, $this->printer_width) : $text;
      $this->printer->text($text."\n");
    }

   public function addSpaces($string = '', $valid_string_length = 0) {
      if (strlen($string) < $valid_string_length) {
          $spaces = $valid_string_length - strlen($string);
          for ($index1 = 1; $index1 <= $spaces; $index1++) {
              $string = $string . ' ';
          }
      }

        return $string;
    }


     private function printBit()
    {
      $path = APPPATH . '../assets/images/logoCMD.png';
      $tux = EscposImage::load($path, false);
      //$this->printer->bitImage($tux);
      $this->printer->graphics($tux); //Printer::IMG_DOUBLE_WIDTH | Printer::IMG_DOUBLE_HEIGHT
    }

  public function printCommande($details,$utilisateur,$facture){

        $this->printer->initialize();
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        //$this->printBit();
        $this->printer->feed(1);
        $this->printer->selectPrintMode(Printer::MODE_FONT_A);//MODE_FONT_A MODE_FONT_B
        $this->printer->setTextSize(1, 2);
        $this->printer->setEmphasis(false);
        $this->printer->text(date('Y-m-d H:i'));
        $this->printer->feed();
        //$this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->text("Serveur   : ".$utilisateur." \n");
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        $this->printer->text("============================================\n");
        $this->printer->text("Commande #".$facture." \n");
        $this->printer->text("============================================\n");
        $this->printer->feed(1);
        $this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->setTextSize(1, 2);
        foreach ($details as $detail) {
          $this->printer->text($detail->qte." x ".$detail->libelle."\n");
        }
        $this->printer->feed(2);
        $this->printer->cut();
        $this->printer->pulse();
        $this->printer->close();
  }


  public function printAddition($details,$societe,$facture){

        $this->printer->initialize();
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        $this->printBit();
        $this->printer->feed(1);
        $this->printer->selectPrintMode(Printer::MODE_FONT_B);//MODE_FONT_A MODE_FONT_B
        $this->printer->setTextSize(1, 1);
        $this->printer->setEmphasis(false);
        $this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->text($societe->adresseSociete." \n");
        $this->printer->text("Tel: ".$societe->telSociete." \n");
        $this->printer->text("Patente: ".$societe->Patente." -I.F: ".$societe->IFE." \n");
        $this->printer->text("R.C: ".$societe->RC." -I.C.E: ".$societe->ICE." \n");
        $this->printer->feed(1);
        $this->printer->setTextSize(2,2);
        $this->printer->setEmphasis(false);
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);

        $this->printer->text($facture->dateCreation." \n");
        $this->printer->feed(1);
        //$this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->text("Serveur   : ".$facture->nomUtilisateur." \n");
        $this->printer->text("Table     : ".$facture->idTable." \n");
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        $this->printer->text("========================"." \n");
        $this->printer->text("Ticket N".$facture->idFacture." \n");
        $this->printer->text("========================"." \n");
        $this->printer->feed(1);

        $this->printer->setTextSize(2, 1);
        $this->printer->setJustification(Printer::JUSTIFY_LEFT);

        foreach ($details as $detail) {
          $tot = $detail->qte * $detail->prix;

                $qte_lines = str_split($detail->qte, 2);
                foreach ($qte_lines as $k => $l) {
                    $l = trim($l);
                    $qte_lines[$k] = $this->addSpaces($l, 2);
                }

                $name_lines = str_split($detail->libelle, 15);
                foreach ($name_lines as $k => $l) {
                    $l = trim($l);
                    $name_lines[$k] = $this->addSpaces($l, 15);
                }

                $qtyx_price = str_split(number_format($detail->prix,2), 7);
                foreach ($qtyx_price as $k => $l) {
                    $l = trim($l);
                    $qtyx_price[$k] = $this->addSpaces($l, 7);
                }

                $total_price = str_split(number_format($tot,2), 7);
                foreach ($total_price as $k => $l) {
                    $l = trim($l);
                    $total_price[$k] = $this->addSpaces($l, 7);
                }




                $counter = 0;
                $temp = [];
                $temp[] = count($qte_lines);
                $temp[] = count($name_lines);
                $temp[] = count($qtyx_price);
                $temp[] = count($total_price);
                $counter = max($temp);

                for ($i = 0; $i < $counter; $i++) {
                    $line = '';
                    if (isset($qte_lines[$i])) {
                        $line .= ($qte_lines[$i]);
                    }
                    if (isset($name_lines[$i])) {
                        $line .= ($name_lines[$i]);
                    }
                    if (isset($qtyx_price[$i])) {
                        $line .= ($qtyx_price[$i]);
                    }
                    if (isset($total_price[$i])) {
                        $line .= ($total_price[$i]);
                    }
                    $this->printer->text($line . "\n");
                }




          //$this->printer->text($detail->qte." ".$detail->libelle." ".$detail->prix." ".$tot."\n");
        }



        $this->printer->feed();
        //$this->printer->setJustification(Printer::JUSTIFY_LEFT);
        // $this->printer->text("Serveur   : ".$utilisateur." \n");
        // $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        // $this->printer->text("============================================\n");
        // $this->printer->text("Commande #".$facture." \n");
        // $this->printer->text("============================================\n");
        // $this->printer->feed(1);
        // $this->printer->setJustification(Printer::JUSTIFY_LEFT);
        // $this->printer->setTextSize(1, 2);
        // foreach ($details as $detail) {
        //   $this->printer->text($detail->qte." x ".$detail->libelle."\n");
        // }
        $this->printer->feed(2);
        $this->printer->cut();
        $this->printer->pulse();
        $this->printer->close();
  }




    public function printEncaissement($details,$utilisateur,$facture){

        $this->printer->initialize();
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        $this->printBit();
        $this->printer->feed(1);
        $this->printer->selectPrintMode(Printer::MODE_FONT_A);//MODE_FONT_A MODE_FONT_B
        $this->printer->setTextSize(1, 2);
        $this->printer->setEmphasis(false);
        $this->printer->text(date('Y-m-d H:i'));
        $this->printer->feed();
        //$this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->text("Serveur   : ".$utilisateur." \n");
        $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        $this->printer->text("============================================\n");
        $this->printer->text("Commande #".$facture." \n");
        $this->printer->text("============================================\n");
        $this->printer->feed(1);
        $this->printer->setJustification(Printer::JUSTIFY_LEFT);
        $this->printer->setTextSize(1, 2);
        foreach ($details as $detail) {
          $this->printer->text($detail->qte." x ".$detail->libelle."\n");
        }
        $this->printer->feed(2);
        $this->printer->cut();
        $this->printer->pulse();
        $this->printer->close();
  }



    public function print_test_receipt($text,$logo)
    {
        // $this->printer->setJustification(Printer::JUSTIFY_CENTER);
        // $this->printBit($logo);
        // $this->printer->feed();
        // $this->add_line(date('Y-m-d H:i:s'));
        // $this->add_line($text);
        // $this->printer->cut(Printer::CUT_PARTIAL);
        // $this->printer->close();

      /* Information for the receipt */
      $items = array(
          new item("Example item #1", "4.00"),
          new item("Another thing", "3.50"),
          new item("Something else", "1.00"),
          new item("A final item", "4.45"),
      );



      $subtotal = new item('Subtotal', '12.95');
      $tax = new item('A local tax', '1.30');
      $total = new item('Total', '14.25', true);
      /* Date is kept the same for testing */
      // $date = date('l jS \of F Y h:i:s A');
      $date = "Monday 6th of April 2015 02:56:25 PM";

      /* Start the printer */
      $path = APPPATH . '../assets/images/ji.png';
      $logo = EscposImage::load($path, false);

      /* Print top logo */
      $this->printer->setJustification(Printer::JUSTIFY_CENTER);
      $this->printer->graphics($logo);
      $this->printer->feed();
      $this->printer->feed();

      /* Name of shop */
      $this->printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
      $this->printer->text("ExampleMart Ltd.\n");
      $this->printer->selectPrintMode();
      $this->printer->text("Shop No. 42.\n");
      $this->printer->feed();

      /* Title of receipt */
      $this->printer->setEmphasis(true);
      $this->printer->text("SALES INVOICE\n");
      $this->printer->setEmphasis(false);

      /* Items */
      $this->printer->setJustification(Printer::JUSTIFY_LEFT);
      $this->printer->setEmphasis(true);
      $this->printer->text(new item('', '$'));
      $this->printer->setEmphasis(false);
      foreach ($items as $item) {
          $this->printer->text($item);
      }
      $this->printer->setEmphasis(true);
      $this->printer->text($subtotal);
      $this->printer->setEmphasis(false);
      $this->printer->feed();

      /* Tax and total */
      $this->printer->text($tax);
      $this->printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
      $this->printer->text($total);
      $this->printer->selectPrintMode();

      /* Footer */
      $this->printer->feed(2);
      $this->printer->setJustification(Printer::JUSTIFY_CENTER);
      $this->printer->text("Thank you for shopping at ExampleMart\n");
      $this->printer->text("For trading hours, please visit example.com\n");
      $this->printer->feed(2);
      $this->printer->text($date . "\n");

      /* Cut the receipt and open the cash drawer */
      $this->printer->cut();
      $this->printer->pulse();

      $this->printer->close();

  }









}

/* A wrapper to do organise item names & prices into columns */
class item
{
    private $name;
    private $price;
    private $dollarSign;

    public function __construct($name = '', $price = '', $dollarSign = false)
    {
        $this -> name = $name;
        $this -> price = $price;
        $this -> dollarSign = $dollarSign;
    }
    
    public function __toString()
    {
        $rightCols = 10;
        $leftCols = 38;
        if ($this -> dollarSign) {
            $leftCols = $leftCols / 2 - $rightCols / 2;
        }
        $left = str_pad($this -> name, $leftCols) ;
        
        $sign = ($this -> dollarSign ? '$ ' : '');
        $right = str_pad($sign . $this -> price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
}
