<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class ArticlesModel extends CI_Model
{

	public function getArticles()
	{

		$this->db->where('removed',FALSE);
		return $this->db->get('Produits')->result_array();

	}

	public function createClientHistoriques(){

		$q = $this->db->get('Clients');

		$articles = $q->result_array();

		foreach ($articles as $key => $article) {

			$this->db->set('idUtilisateur',1);

			$this->db->set('id',$article['idCli']);

			$this->db->set('type',7);

			$this->db->set('json','{}');

			$this->db->insert('ActivitiesUtilisateur');	

		}

	}


	public function createHistoriques(){

		$q = $this->db->get('Produits');

		$articles = $q->result_array();

		foreach ($articles as $key => $article) {

			$this->db->set('idUtilisateur',1);

			$this->db->set('id',$article['idProduit']);

			$this->db->set('type',5);

			$this->db->set('json','{}');

			$this->db->insert('ActivitiesUtilisateur');	

		}

	}

	public function createTarifsArticles(){

		$q = $this->db->get('Produits');

		$articles = $q->result_array();

		foreach ($articles as $key => $article) {

			$this->db->where('active',1);

			$q1 = $this->db->get('Tarifs');

			$tarifs = $q1->result_array();

			foreach ($tarifs as $key1 => $tarif) {

				$this->db->set('idTarif',$tarif['idTarif']);

				$this->db->set('idProduit',$article['idProduit']);

				$this->db->set('prix',0);

				$this->db->insert('TarifProduit');				
				
			}

		}

	}


	public function createDepotArticle(){

		$q = $this->db->get('Produits');

		$articles = $q->result_array();

		foreach ($articles as $key => $article) {
			
				$this->db->set('idDepot',1);		
				$this->db->set('idProduit',$article['idProduit']);	
				$this->db->set('qte',0);	
				$this->db->set('qteInv',0);	
				$this->db->set('qteInt',0);	
				$this->db->set('qteMin',0);	
				$this->db->set('qteMax',0);	
				$this->db->set('emplacement');
				$this->db->insert('DepotProduit');

		}



	}


	public function getArticle($idArticle = 0)
	{


		$article = $this->db->query("SELECT Produits.urlImg,Unites.unite,Produits.PAHT ,Produits.PVHT ,Produits.idProduit ,Produits.active,Produits.DESIGNAT,Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,FamillesArticles.familleArticle,Produits.dateCreation,

			GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete,':',ProprietesArticle.idPropriete SEPARATOR ';') properties, 

			GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte,':',DepotProduit.qteMin ,':',DepotProduit.qteMax  SEPARATOR ';') stock,

			GROUP_CONCAT(DISTINCT(Tarifs.idTarif),':',Tarifs.tarif,':',TarifProduit.prix SEPARATOR ';') tarifs,

			GROUP_CONCAT(DISTINCT(p.idProduit),':',p.DESIGNAT,':',ProduitsNomenclature.qte,':',u.unite,':',p.PAHT SEPARATOR ';') nomenclature,

			GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

			FROM Produits 
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot
			LEFT JOIN ProduitsNomenclature ON Produits.idProduit = ProduitsNomenclature.idProduit 
			LEFT JOIN Produits p ON p.idProduit = ProduitsNomenclature.idProduitLiee
			LEFT JOIN Unites u ON u.idU = p.idU 
			LEFT JOIN TarifProduit ON Produits.idProduit = TarifProduit.idProduit 
			LEFT JOIN Tarifs ON Tarifs.idTarif = TarifProduit.idTarif   
			LEFT JOIN Unites ON Unites.idU = Produits.idU 
			LEFT JOIN FamillesArticles ON FamillesArticles.idFA = Produits.idFA 


			LEFT JOIN ActivitiesUtilisateur au ON au.id = Produits.idProduit AND au.type IN (5,6,28,29,30)
			LEFT JOIN Activities a ON au.type = a.idActivitie
			LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur 
			WHERE Produits.idProduit = ".$idArticle." GROUP BY Produits.idProduit ORDER BY Produits.dateCreation DESC");

			if($article->num_rows()>0){

				return $article->row();

			}else{
				return null;
			}

	}
	public function setProduitApiC($code,$desgn,$image,$desc,$taille,$json){


		try{

			$url = $image;


			$ext = pathinfo($url, PATHINFO_EXTENSION);

			$filename = substr( base_convert( time(), 10, 36 ) . md5( microtime() ), 0, 16 ).'.' . $ext;
			/* Extract the filename */
			//$filename = substr($url, strrpos($url, '/') + 1);
			/* Save file wherever you want */
			//file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

			//$data = base64_encode(file_get_contents($url));

			file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

			$this->db->where('CODEART',$code);
			$q = $this->db->get('Produits');
			if($q->num_rows() == 0){

				$this->db->trans_start(); 

				$this->db->trans_strict(TRUE); 


				$this->db->set('CODEART',$code);

				$this->db->set('DESIGNAT',$desgn);

				$this->db->set('idFA',26);

				$this->db->set('idTA',1);

				$this->db->set('idM',3);

				$this->db->set('Observat',$desc); 

				$this->db->set('Poids',$taille);

				$this->db->set('urlImg','assets/uploads/'.$filename);  

				$this->db->insert('Produits');

				$id = $this->db->insert_id();

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$tarifs = $this->db->get('Tarifs')->result_array();


				if (count($tarifs)>0) {

					foreach ($tarifs as $key => $tarif) {

						$this->db->set('idTarif',$tarif['idTarif']);	
						$this->db->set('idProduit',$id); 	
						$this->db->set('prix',0); 
		              	$this->db->insert('TarifProduit');

					}			
					
				}

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$depots = $this->db->get('Depots')->result_array();

				if (count($depots)>0) {

					foreach ($depots as $key => $depot) {

						$this->db->set('idDepot',$depot['idD']);	
						$this->db->set('idProduit',$id);	
						$this->db->set('qte',0);	
						$this->db->set('qteInv',0);	
						$this->db->set('qteInt',0);	
						$this->db->set('qteMin',1);	
						$this->db->set('qteMax',99999);
						$this->db->insert('DepotProduit');

					}	
					
				}


				$this->db->set('idUtilisateur',1);

				$this->db->set('id',$id);

				$this->db->set('idDocu','');

				$this->db->set('type',5);

				$this->db->set('json',$json);
				
				$this->db->insert('ActivitiesUtilisateur');

				$this->db->trans_complete();

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    return array("status"=>FALSE);
				}else {
				    $this->db->trans_commit();
				    return array("status"=>TRUE,"id"=>$id);
				}			

			}else{
				return array("status"=>TRUE,"id"=>$q->row()->idProduit);
			}
		}catch(Exception $ex){


			$this->db->trans_rollback();
			return array("status"=>FALSE,"message"=>$ex->getMessage());
		}

	}
	public function setProduitApi($code,$desgn,$image,$desc,$famille,$marque,$json){


		try{


			$url = $image;


			$ext = pathinfo($url, PATHINFO_EXTENSION);

			$filename = substr( base_convert( time(), 10, 36 ) . md5( microtime() ), 0, 16 ).'.' . $ext;
			/* Extract the filename */
			//$filename = substr($url, strrpos($url, '/') + 1);
			/* Save file wherever you want */
			//file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

			//$data = base64_encode(file_get_contents($url));

			file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

			$this->db->where('CODEART',$code);
			$q = $this->db->get('Produits');
			if($q->num_rows() == 0){

				$this->db->trans_start(); 

				$this->db->trans_strict(TRUE); 


				$this->db->set('CODEART',$code);

				$this->db->set('DESIGNAT',$desgn);

				$this->db->set('idFA',$famille);

				$this->db->set('idTA',1);

				$this->db->set('idM',$marque);

				$this->db->set('Observat',$desc); 

				$this->db->set('urlImg','assets/uploads/'.$filename);  

				$this->db->insert('Produits');

				$id = $this->db->insert_id();

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$tarifs = $this->db->get('Tarifs')->result_array();


				if (count($tarifs)>0) {

					foreach ($tarifs as $key => $tarif) {

						$this->db->set('idTarif',$tarif['idTarif']);	
						$this->db->set('idProduit',$id); 	
						$this->db->set('prix',0); 
		              	$this->db->insert('TarifProduit');

					}			
					
				}

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$depots = $this->db->get('Depots')->result_array();

				if (count($depots)>0) {

					foreach ($depots as $key => $depot) {

						$this->db->set('idDepot',$depot['idD']);	
						$this->db->set('idProduit',$id);	
						$this->db->set('qte',0);	
						$this->db->set('qteInv',0);	
						$this->db->set('qteInt',0);	
						$this->db->set('qteMin',1);	
						$this->db->set('qteMax',99999);
						$this->db->insert('DepotProduit');

					}	
					
				}


				$this->db->set('idUtilisateur',1);

				$this->db->set('id',$id);

				$this->db->set('idDocu','');

				$this->db->set('type',5);

				$this->db->set('json',$json);
				
				$this->db->insert('ActivitiesUtilisateur');

				$this->db->trans_complete();

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    return array("status"=>FALSE);
				}else {
				    $this->db->trans_commit();
				    return array("status"=>TRUE,"id"=>$id);
				}			

			}else{
				return array("status"=>TRUE,"id"=>$q->row()->idProduit);
			}
		}catch(Exception $ex){


			$this->db->trans_rollback();
			return array("status"=>FALSE,"message"=>$ex->getMessage());
		}

	}


	public function setCarlube(){


		$data = "data:image/png;base64,".base64_encode(file_get_contents('https://carlube-cdn-a2e2e9cf.cdn.memsites.com//2019/12/under_logo.png'));

		$this->db->set('logo',$data);

		$this->db->update('Marques');
	}

	public function setFamilleMake($string){

		$this->db->where('familleMake',$string);
		$q = $this->db->get('FamillesMake');
		if($q->num_rows() == 0){
			$this->db->set('familleMake',$string);
			$this->db->insert('FamillesMake');
			return $this->db->insert_id();
		}else{
			return $q->row()->idFM;
		}
	}
	public function setMakes($string,$id){

		$this->db->where('make',$string);
		$this->db->where('idFM',$id);
		$q = $this->db->get('Makes');
		if($q->num_rows() == 0){
			$this->db->set('make',$string);
			$this->db->set('idFM',$id);
			$this->db->insert('Makes');
			return $this->db->insert_id();
		}else{
			return $q->row()->idMake;
		}

	}
	public function setModelMakes($string,$id){
		$this->db->where('model',$string);
		$this->db->where('idMake',$id);
		$q = $this->db->get('ModelMakes');
		if($q->num_rows() == 0){
			$this->db->set('model',$string);
			$this->db->set('idMake',$id);
			$this->db->insert('ModelMakes');
			return $this->db->insert_id();
		}else{
			return $q->row()->idMM;
		}
	}
	public function setOptionsMakes($string,$id){
		$this->db->where('optionModel',$string);
		$this->db->where('idMM',$id);
		$q = $this->db->get('OptionsModel');
		if($q->num_rows() == 0){
			$this->db->set('optionModel',$string);
			$this->db->set('idMM',$id);
			$this->db->insert('OptionsModel');
			return $this->db->insert_id();
		}else{
			return $q->row()->idOM;
		}
	}

	public function setProduit($code,$desgn,$taille,$image,$desc,$json){


		try{


			$url = $image;
			/* Extract the filename */
			$filename = substr($url, strrpos($url, '/') + 1);
			/* Save file wherever you want */
			//file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

			//$data = base64_encode(file_get_contents($url));

			$data = "data:image/jpeg;base64,".base64_encode(file_get_contents($url));

			$this->db->where('CODEART',$code);
			$q = $this->db->get('Produits');
			if($q->num_rows() == 0){

				$this->db->trans_start(); 

				$this->db->trans_strict(TRUE); 


				$this->db->set('CODEART',$code);

				$this->db->set('DESIGNAT',$desgn);

				$this->db->set('idFA',1);

				$this->db->set('idTA',1);

				$this->db->set('idM',3);

				$this->db->set('Poids',$taille);  

				$this->db->set('Observat',$desc); 

				$this->db->set('img',$data);  

				$this->db->insert('Produits');

				$id = $this->db->insert_id();

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$tarifs = $this->db->get('Tarifs')->result_array();


				if (count($tarifs)>0) {

					foreach ($tarifs as $key => $tarif) {

						$this->db->set('idTarif',$tarif['idTarif']);	
						$this->db->set('idProduit',$id); 	
						$this->db->set('prix',0); 
		              	$this->db->insert('TarifProduit');

					}			
					
				}

				$this->db->where('active',TRUE);

				$this->db->where('removed',FALSE);

				$depots = $this->db->get('Depots')->result_array();

				if (count($depots)>0) {

					foreach ($depots as $key => $depot) {

						$this->db->set('idDepot',$depot['idD']);	
						$this->db->set('idProduit',$id);	
						$this->db->set('qte',0);	
						$this->db->set('qteInv',0);	
						$this->db->set('qteInt',0);	
						$this->db->set('qteMin',1);	
						$this->db->set('qteMax',99999);
						$this->db->insert('DepotProduit');

					}	
					
				}





				$this->db->set('idUtilisateur',1);

				$this->db->set('id',$id);

				$this->db->set('idDocu','');

				$this->db->set('type',5);

				$this->db->set('json',$json);
				
				$this->db->insert('ActivitiesUtilisateur');

				$this->db->trans_complete();

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    return array("status"=>FALSE);
				}else {
				    $this->db->trans_commit();
				    return array("status"=>TRUE,"id"=>$id);
				}			

			}else{
				return array("status"=>TRUE,"id"=>$q->row()->idProduit);
			}
		}catch(Exception $ex){


			$this->db->trans_rollback();
			return array("status"=>FALSE,"message"=>$ex->getMessage());
		}

	}



	public function setSearch($idFM,$idMake,$idMM,$idOM,$idProduit){

		$this->db->set('idFM',$idFM);
		$this->db->set('idMake',$idMake);
		$this->db->set('idMM',$idMM);
		$this->db->set('idOM',$idOM);
		$this->db->set('idProduit',$idProduit);
		return $this->db->insert('Searchs');
	
	}



	public function getHistorique($ids,$id){

		$this->db->join('Activities','ActivitiesUtilisateur.type = Activities.idActivite');
		$this->db->where('id',$id);
		$this->db->where_in('idActivite',$ids);
		return $this->db->get('ActivitiesUtilisateur');

	}

	public function masquerDepot($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idD',$id);
		return $this->db->update('Depots');
	}


	public function removeDepot($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idD',$id);
		return $this->db->update('Depots');
	}

	public function insertDepot($propierte,$responsable,$tel,$ville,$pays,$adresse,$stockable){

		if($stockable == 1){

			$this->db->set('principal',false);
			$this->db->update('Depots');

		}
		$this->db->set('depot',$propierte);
		$this->db->set('responsable',$responsable);
		$this->db->set('tel',$tel);
		$this->db->set('ville',$ville);
		$this->db->set('pays',$pays);
		$this->db->set('adresse',$adresse);
		$this->db->set('principal',$stockable);
		return $this->db->insert('Depots');
	}

	public function updateDepot($id,$propierte,$responsable,$tel,$ville,$pays,$adresse,$stockable){

		if($stockable == 1){

			$this->db->set('principal',false);
			$this->db->update('Depots');

		}
		$this->db->set('depot',$propierte);
		$this->db->set('responsable',$responsable);
		$this->db->set('tel',$tel);
		$this->db->set('ville',$ville);
		$this->db->set('pays',$pays);
		$this->db->set('adresse',$adresse);
		$this->db->set('principal',$stockable);
		$this->db->where('idD',$id);
		return $this->db->update('Depots');
	}


	public function insertCharges($charge,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$av = json_decode($charge);


		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFCHAR_C.$parametre->row()->NUMCHAR_C.$parametre->row()->SUFFCHAR_C);

		$this->db->set('DATE',$av->date);

		$this->db->set('CODETIER',$av->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',0.00);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$av->nom);

		$this->db->set('ADRESSE',$av->adresse);

		$this->db->set('tel',$av->tel);

		$this->db->set('observations',(isset($av->observations)) ? $av->observations : '');

		$this->db->insert('BonsCharge');



		$id = $this->db->insert_id();


		foreach ($av->articles as $key => $article) {

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('QTE',$article->qte);

			$this->db->set('CODETIER',$av->idClient);

			$this->db->set('DATE',$av->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsCharge');

		}

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFCHAR_C.$parametre->row()->NUMCHAR_C.$parametre->row()->SUFFCHAR_C);

		$this->db->set('type',19);

		$this->db->set('json',$charge);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMCHAR_C = $parametre->row()->NUMCHAR_C+1;

		$size = strlen($parametre->row()->NUMCHAR_C);

		$NUMCHAR_C = str_pad($NUMCHAR_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMCHAR_C',$NUMCHAR_C);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}




	public function updateParametres($parametres,$idUser){

		$param = json_decode($parametres);

		$this->db->set('NUMDEV_C',$param->NUMDEV_C);
		$this->db->set('PREFDEV_C',$param->PREFDEV_C);
		$this->db->set('SUFFDEV_C',$param->SUFFDEV_C);
		$this->db->set('NUMCOM_C',$param->NUMCOM_C);
		$this->db->set('PREFCOM_C',$param->PREFCOM_C);
		$this->db->set('SUFFCOM_C',$param->SUFFCOM_C);
		$this->db->set('NUMLIVR_C',$param->NUMLIVR_C);
		$this->db->set('PREFLIV_C',$param->PREFLIV_C);
		$this->db->set('SUFFLIV_C',$param->SUFFLIV_C);
		$this->db->set('NUMFACT_C',$param->NUMFACT_C);
		$this->db->set('PREFFACT_C',$param->PREFFACT_C);
		$this->db->set('SUFFFACT_C',$param->SUFFFACT_C);
		$this->db->set('NUMFACTINV_C',$param->NUMFACTINV_C);
		$this->db->set('PREFFACTINV_C',$param->PREFFACTINV_C);
		$this->db->set('SUFFFACTINV_C',$param->SUFFFACTINV_C);
		$this->db->set('NUMAV_INV',$param->NUMAV_INV);
		$this->db->set('PREFAV_INV',$param->PREFAV_INV);
		$this->db->set('SUFFAV_INV',$param->SUFFAV_INV);
		$this->db->set('NUMAV_C',$param->NUMAV_C);
		$this->db->set('PREFAV_C',$param->PREFAV_C);
		$this->db->set('SUFFAV_C',$param->SUFFAV_C);
		$this->db->set('NUMSORTIE',$param->NUMSORTIE);
		$this->db->set('PREFSORTIE',$param->PREFSORTIE);
		$this->db->set('SUFFSORTIE',$param->SUFFSORTIE);
		$this->db->set('NUMECHANGE',$param->NUMECHANGE);
		$this->db->set('PREFECHANG',$param->PREFECHANG);
		$this->db->set('SUFFECHANG',$param->SUFFECHANG);
		$this->db->set('NUMBON',$param->NUMBON);
		$this->db->set('PREFBON',$param->PREFBON);
		$this->db->set('SUFFBON',$param->SUFFBON);
		$this->db->set('NUMDEV_F',$param->NUMDEV_F);
		$this->db->set('PREFDEV_F',$param->PREFDEV_F);
		$this->db->set('SUFFDEV_F',$param->SUFFDEV_F);
		$this->db->set('NUMCOM_F',$param->NUMCOM_F);
		$this->db->set('PREFCOM_F',$param->PREFCOM_F);
		$this->db->set('SUFFCOM_F',$param->SUFFCOM_F);
		$this->db->set('NUMLIVR_F',$param->NUMLIVR_F);
		$this->db->set('PREFLIV_F',$param->PREFLIV_F);
		$this->db->set('SUFFLIV_F',$param->SUFFLIV_F);
		$this->db->set('NUMFACT_F',$param->NUMFACT_F);
		$this->db->set('PREFFACT_F',$param->PREFFACT_F);
		$this->db->set('SUFFFACT_F',$param->SUFFFACT_F);
		$this->db->set('NUMAV_F',$param->NUMAV_F);
		$this->db->set('PREFAV_F',$param->PREFAV_F);
		$this->db->set('SUFFAV_F',$param->SUFFAV_F);
		$this->db->set('NUMENTREE',$param->NUMENTREE);
		$this->db->set('PREFENTREE',$param->PREFENTREE);
		$this->db->set('SUFFENTREE',$param->SUFFENTREE);

		$this->db->set('NUMCHAR_C',$param->NUMCHAR_C);
		$this->db->set('PREFCHAR_C',$param->PREFCHAR_C);
		$this->db->set('SUFFCHAR_C',$param->SUFFCHAR_C);

		return $this->db->update('Parametres');
	}


	public function insertAvoir($avoir,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$av = json_decode($avoir);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFAV_C.$parametre->row()->NUMAV_C.$parametre->row()->SUFFAV_C);

		$this->db->set('DATE',$av->date);

		$this->db->set('CODETIER',$av->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$av->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$av->nom);

		$this->db->set('ADRESSE',$av->adresse);

		$this->db->set('tel',$av->tel);

		$this->db->set('observations',$av->observations);

		// $this->db->set('ModePaie',(isset($av->contre)) ? $av->contre : ''); 

		$this->db->set('vehicule',(isset($av->vehicule)) ? $av->vehicule : ''); 

		$this->db->insert('Avoirs');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($av->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$av->idClient);

			$this->db->set('DATE',$av->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsAvoir');

		}

		$totht = $totht-($totht*($av->Remise/100));

		$totttc = $totttc-($totttc*($av->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idAvoir',$id);

		$this->db->update('Avoirs');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFAV_C.$parametre->row()->NUMAV_C.$parametre->row()->SUFFAV_C);

		$this->db->set('type',37);

		$this->db->set('json',$avoir);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMAV_C = $parametre->row()->NUMAV_C+1;

		$size = strlen($parametre->row()->NUMAV_C);

		$NUMAV_C = str_pad($NUMAV_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMAV_C',$NUMAV_C);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}
	public function insertAvoirF($avoir,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$av = json_decode($avoir);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');


		$this->db->set('NUMDOC',$parametre->row()->PREFAV_F.$parametre->row()->NUMAV_F.$parametre->row()->SUFFAV_F);

		$this->db->set('DATE',$av->date);

		$this->db->set('CODETIER',$av->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$av->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$av->nom);

		$this->db->set('ADRESSE',$av->adresse);

		$this->db->set('tel',$av->tel);

		$this->db->set('BC',$av->bonCommande);

		$this->db->set('observations',$av->observations);

		// $this->db->set('ModePaie',(isset($av->contre)) ? $av->contre : ''); 

		$this->db->set('vehicule',(isset($av->vehicule)) ? $av->vehicule : ''); 

		$this->db->insert('AvoirsF');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($av->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$av->idClient);

			$this->db->set('DATE',$av->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsAvoirsF');

		}

		$totht = $totht-($totht*($av->Remise/100));

		$totttc = $totttc-($totttc*($av->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idAvoirF',$id);

		$this->db->update('Avoirs');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFAV_F.$parametre->row()->NUMAV_F.$parametre->row()->SUFFAV_F);

		$this->db->set('type',39);

		$this->db->set('json',$avoir);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMAV_F = $parametre->row()->NUMAV_F+1;

		$size = strlen($parametre->row()->NUMAV_F);

		$NUMAV_F = str_pad($NUMAV_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMAV_F',$NUMAV_F);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}
	public function updateAvoir($avoir,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$av = json_decode($avoir);

		$id = $av->id;

		$this->db->set('DATE',$av->date);

		$this->db->set('CODETIER',$av->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$av->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$av->nom);

		$this->db->set('ADRESSE',$av->adresse);

		$this->db->set('tel',$av->tel);

		// $this->db->set('BC',$av->bonCommande);

		$this->db->set('observations',$av->observations);

		//$this->db->set('ModePaie',(isset($av->contre)) ? $av->contre : ''); 

		$this->db->set('vehicule',(isset($av->vehicule)) ? $av->vehicule : ''); 

		$this->db->where('idAvoir',$id);

		$this->db->update('Avoirs');

		$totht = 0;
		$totttc = 0;

		$this->db->where('NUMDOC',$id);

		$this->db->delete('DetailsAvoir');

		foreach ($av->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$av->idClient);

			$this->db->set('DATE',$av->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsAvoir');

		}

		$totht = $totht-($totht*($av->Remise/100));

		$totttc = $totttc-($totttc*($av->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idAvoir',$id);

		$this->db->update('Avoirs');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$av->numDoc);

		$this->db->set('type',38);

		$this->db->set('json',$avoir);
		
		$this->db->insert('ActivitiesUtilisateur');



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}
	public function updateAvoirF($avoir,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$av = json_decode($avoir);

		$id = $av->id;


		$this->db->set('DATE',$av->date);

		$this->db->set('CODETIER',$av->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$av->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$av->nom);

		$this->db->set('ADRESSE',$av->adresse);

		$this->db->set('tel',$av->tel);

		// $this->db->set('BC',$av->bonCommande);

		$this->db->set('observations',$av->observations);

		//$this->db->set('ModePaie',(isset($av->contre)) ? $av->contre : ''); 

		$this->db->set('vehicule',(isset($av->vehicule)) ? $av->vehicule : ''); 

		$this->db->where('idAvoirF',$id);

		$this->db->update('AvoirsF');

		$totht = 0;
		$totttc = 0;

		$this->db->where('NUMDOC',$id);

		$this->db->delete('DetailsAvoirF');

		foreach ($av->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$av->idClient);

			$this->db->set('DATE',$av->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsAvoirF');

		}

		$totht = $totht-($totht*($av->Remise/100));

		$totttc = $totttc-($totttc*($av->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idAvoirF',$id);

		$this->db->update('AvoirsF');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$av->numDoc);

		$this->db->set('type',40);

		$this->db->set('json',$avoir);
		
		$this->db->insert('ActivitiesUtilisateur');



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function insertDevis($devis,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$devi = json_decode($devis);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFDEV_C.$parametre->row()->NUMDEV_C.$parametre->row()->SUFFDEV_C);

		$this->db->set('DATE',$devi->date);

		$this->db->set('CODETIER',$devi->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$devi->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$devi->nom);

		$this->db->set('ADRESSE',$devi->adresse);

		$this->db->set('tel',$devi->tel);

		$this->db->set('BC',$devi->bonCommande);

		$this->db->set('observations',$devi->observations);

		$this->db->set('ModePaie',(isset($devi->contre)) ? $devi->contre : ''); 

		$this->db->set('vehicule',(isset($devi->vehicule)) ? $devi->vehicule : ''); 

		$this->db->insert('Devies');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($devi->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$devi->idClient);

			$this->db->set('DATE',$devi->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsDevis');

		}

		$totht = $totht-($totht*($devi->Remise/100));

		$totttc = $totttc-($totttc*($devi->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idDevis',$id);

		$this->db->update('Devies');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFDEV_C.$parametre->row()->NUMDEV_C.$parametre->row()->SUFFDEV_C);

		$this->db->set('type',3);

		$this->db->set('json',$devis);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMDEV_C = $parametre->row()->NUMDEV_C+1;

		$size = strlen($parametre->row()->NUMDEV_C);

		$NUMDEV_C = str_pad($NUMDEV_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMDEV_C',$NUMDEV_C);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function updateBonCommande($bonComm,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$devi = json_decode($bonComm);

		$id = $devi->id;

		$this->db->set('DATE',$devi->date);

		$this->db->set('CODETIER',$devi->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$devi->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$devi->nom);

		$this->db->set('ADRESSE',$devi->adresse);

		$this->db->set('tel',$devi->tel);

		$this->db->set('observations',$devi->observations);

		//$this->db->set('BC',$devi->bonCommande);

		$this->db->set('ModePaie',$devi->contre); 

		//$this->db->set('vehicule',$devi->vehicule);

		$this->db->where('idBC',$id);

		$this->db->update('BonsCommande');

		$totht = 0;
		$totttc = 0;

		$this->db->where('NUMDOC',$id);

		$this->db->delete('DetailsBonsCommande');

		foreach ($devi->articles as $key => $article) {

			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$devi->idClient);

			$this->db->set('DATE',$devi->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsCommande');

		}

		$totht = $totht-($totht*($devi->Remise/100));

		$totttc = $totttc-($totttc*($devi->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBC',$id);

		$this->db->update('BonsCommande');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$devi->numDoc);

		$this->db->set('type',14);

		$this->db->set('json',$bonComm);
		
		$this->db->insert('ActivitiesUtilisateur');



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}




	public function updateBonReception($bonReception,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($bonReception);

		$id = $bonLiv->id;

		$this->db->select('DetailsBonsReception.*,BonsReception.CodeDepot');

		$this->db->join('BonsReception','BonsReception.idBR = DetailsBonsReception.NUMDOC');

		$this->db->where('DetailsBonsReception.NUMDOC',$id);

		$dbons = $this->db->get('DetailsBonsReception');

		foreach ($dbons->result() as $dbon) {


			$this->db->set('qte','qte-'.$dbon->QTE,FALSE);

			$this->db->where('idProduit',$dbon->CODEART);

			$this->db->where('idDepot',$dbon->CodeDepot);

			$this->db->update('DepotProduit');

			$this->db->where('idDBR',$dbon->idDBR);

			$this->db->delete('DetailsBonsReception');			

		}

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		// $this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		// $this->db->set('Exp',$bonLiv->expediteur);

		// $this->db->set('chauff',$bonLiv->chauffeur);

		// $this->db->set('superv',$bonLiv->superviseur);  

		// $this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		// $this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->where('idBR',$id);

		$this->db->update('BonsReception');

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {

			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));


			$this->db->set('qte','qte+'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsReception');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));
		
		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBR',$id);

		$this->db->update('BonsReception');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$bonLiv->numDoc);

		$this->db->set('type',17);

		$this->db->set('json',$bonReception);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function updateBonLivraison($bonLivraison,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($bonLivraison);

		$id = $bonLiv->id;

		$this->db->select('detailsBonsLivraison.*,BonsLivraison.CodeDepot');

		$this->db->join('BonsLivraison','BonsLivraison.idBL = detailsBonsLivraison.NUMDOC');

		$this->db->where('detailsBonsLivraison.NUMDOC',$id);

		$dbons = $this->db->get('detailsBonsLivraison');

		foreach ($dbons->result() as $key => $dbon) {


			$this->db->set('qte','qte+'.$dbon->QTE,FALSE);

			$this->db->where('idProduit',$dbon->CODEART);

			$this->db->where('idDepot',$dbon->CodeDepot);

			$this->db->update('DepotProduit');

			$this->db->where('idDBL',$dbon->idDBL);

			$this->db->delete('detailsBonsLivraison');			

		}

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('Nexpedition',(isset($bonLiv->nExpediteur)) ? $bonLiv->nExpediteur : ''); 

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		$this->db->set('Exp',(isset($bonLiv->expediteur)) ? $bonLiv->expediteur : ''); 

		$this->db->set('chauff',(isset($bonLiv->chauffeur)) ? $bonLiv->chauffeur : ''); 

		$this->db->set('superv',(isset($bonLiv->superviseur)) ? $bonLiv->superviseur : ''); 

		$this->db->set('prepa',(isset($bonLiv->preperateur)) ? $bonLiv->preperateur : ''); 

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicule',(isset($bonLiv->vehicule)) ? $bonLiv->vehicule : ''); 

		$this->db->set('observations',$bonLiv->observations);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {

			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));


			$this->db->set('qte','qte-'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('detailsBonsLivraison');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));
		
		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$bonLiv->numDoc);

		$this->db->set('type',2);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function updateDevis($devis,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$devi = json_decode($devis);

		$id = $devi->id;


		$this->db->set('DATE',$devi->date);

		$this->db->set('CODETIER',$devi->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$devi->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$devi->nom);

		$this->db->set('ADRESSE',$devi->adresse);

		$this->db->set('tel',$devi->tel);

		$this->db->set('BC',$devi->bonCommande);

		$this->db->set('observations',$devi->observations);

		$this->db->set('ModePaie',(isset($devi->contre)) ? $devi->contre : ''); 

		$this->db->set('vehicule',(isset($devi->vehicule)) ? $devi->vehicule : ''); 

		$this->db->where('idDevis',$id);

		$this->db->update('Devies');

		$totht = 0;
		$totttc = 0;

		$this->db->where('NUMDOC',$id);

		$this->db->delete('DetailsDevis');

		foreach ($devi->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$devi->idClient);

			$this->db->set('DATE',$devi->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsDevis');

		}

		$totht = $totht-($totht*($devi->Remise/100));

		$totttc = $totttc-($totttc*($devi->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idDevis',$id);

		$this->db->update('Devies');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$devi->numDoc);

		$this->db->set('type',4);

		$this->db->set('json',$devis);
		
		$this->db->insert('ActivitiesUtilisateur');



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function validerBC($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$dd = json_decode($json);

		$codeDepot = '';

		$depotId = 0;

		$this->db->where('principal',TRUE);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;$depotId = $depot->row()->idD;}


		$this->db->select('BonsCommande.*,DetailsBonsCommande.DESIGNAT,DetailsBonsCommande.PUHT,DetailsBonsCommande.PTTC,DetailsBonsCommande.QTE,DetailsBonsCommande.REMISE,DetailsBonsCommande.CODETVA,DetailsBonsCommande.CODEART,DetailsBonsCommande.CODEFAM,DetailsBonsCommande.COMMENT');

		$this->db->join('BonsCommande','DetailsBonsCommande.NUMDOC = BonsCommande.idBC');

		$this->db->where('DetailsBonsCommande.NUMDOC',$dd->id);

		$Devies = $this->db->get('DetailsBonsCommande');

		if ($Devies->num_rows()>0) {

			$articles = array();
			foreach ($Devies->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$devis = json_encode(array('numDoc'=>$detail->NUMDOC,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->ModePaie,'Remise'=>$detail->TAUXREM,'preperateur'=>'','superviseur'=>'','vehicule'=>'','chauffeur'=>'','expediteur'=>'','nExpediteur'=>'','depot'=>$depotId,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($devis);

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFLIV_F.$parametre->row()->NUMLIVR_F.$parametre->row()->SUFFLIV_F);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		// $this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		// $this->db->set('Exp',$bonLiv->expediteur);

		// $this->db->set('chauff',$bonLiv->chauffeur);

		// $this->db->set('superv',$bonLiv->superviseur);  

		// $this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		// $this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('BonsReception');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('qte','qte+'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsReception');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBR',$id);

		$this->db->update('BonsReception');

		$this->db->set('valide',1);

		$this->db->set('BR',$id);

		$this->db->where('idBC',$dd->id);

		$this->db->update('BonsCommande');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFLIV_F.$parametre->row()->NUMLIVR_F.$parametre->row()->SUFFLIV_F);

		$this->db->set('type',15);

		$this->db->set('json',$devis);

		$this->db->insert('ActivitiesUtilisateur');

		$NUMLIVR_F = $parametre->row()->NUMLIVR_F+1;

		$size = strlen($parametre->row()->NUMLIVR_F);

		$NUMLIVR_F = str_pad($NUMLIVR_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMLIVR_F',$NUMLIVR_F);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $id;
		}
	}



	public function insertArticles($articles){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		foreach ($articles as $key => $article) {

			$this->db->set('CODEART',$article["CODEART"]);

			$this->db->set('DESIGNAT',$article["DESIGNAT"]);

			$this->db->set('idFA',$article["idFA"]);

			$this->db->set('idTA',$article["CODETVA"]);

			$this->db->set('idU',$article["CODEUNIT"]);

			$this->db->set('idUA',$article["CODEUNIT"]);

			$this->db->set('STOCKABL',$article["STOCKABLE"]);

			$this->db->set('PAHT',$article["PAHT"]);

			$this->db->set('PVHT',$article["PVHT"]);

			$this->db->set('idTVA',$article["CODETVA"]);

			$this->db->set('NSerie',$article["n_SERIE"]);  

			$this->db->set('Dimension',$article["DIMENSION"]);  

			$this->db->set('idM',$article["idM"]);

			$this->db->insert('Produits');

			$id = $this->db->insert_id();

		}

		

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}




	public function insertArticle($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$article = json_decode($json);

		$type = explode('/', mime_content_type($article->img))[1];

		$data = $article->img;

		if (preg_match('/^data:image\/(\w+);base64,/', $data, $type)) {
		    $data = substr($data, strpos($data, ',') + 1);
		    $type = strtolower($type[1]); // jpg, png, gif

		    if (!in_array($type, [ 'jpg', 'jpeg', 'gif', 'png' ])) {
			    $this->db->trans_rollback();
			    return FALSE;
		    }
		    $data = str_replace( ' ', '+', $data );
		    $data = base64_decode($data);

		    $filename = substr( base_convert( time(), 10, 36 ) . md5( microtime() ), 0, 16 ).'.' . $type;

		    if ($data === false) {
			    $this->db->trans_rollback();
			    return FALSE;
		    }
		} else {
		    $this->db->trans_rollback();
		    return FALSE;
		}

		if (($data = @file_put_contents('assets/uploads/' . $filename, $data)) === false) {
		      // $error = error_get_last();
		      // echo "HTTP request failed. Error was: " . $error['message'];
			$this->db->trans_rollback();
		    return FALSE;
		}



		$this->db->set('CODEART',$article->code);

		$this->db->set('DESIGNAT',$article->desgin);

		$this->db->set('idFA',$article->familleArticle);

		$this->db->set('idTA',$article->typeArticle);

		$this->db->set('idU',$article->uniteVente);

		$this->db->set('idUA',$article->uniteAchat);

		$this->db->set('STOCKABL',$article->stockable);

		$this->db->set('PAHT',$article->prixAchat);

		$this->db->set('PVHT',$article->prixVente);

		$this->db->set('idTVA',$article->tva);

		$this->db->set('idM',$article->marque);

		$this->db->set('Observat',$article->observation); 

		$this->db->set('codeBar',$article->barcode);

		$this->db->set('Pays',$article->pays);

		$this->db->set('Poids',$article->poids);  

		$this->db->set('longeur',$article->longeur);  

		$this->db->set('largeur',$article->largeur);  

		$this->db->set('delaisPrepa',$article->delaisPrepa);

		$this->db->set('garentie',$article->garentie);  

		// $this->db->set('img',$article->img);  

		$this->db->set('urlImg','assets/uploads/'.$filename);   

		$this->db->insert('Produits');

		$id = $this->db->insert_id();

		if (count($article->tarifs)>0) {

			foreach ($article->tarifs as $key => $tarif) {

				$this->db->set('idTarif',$tarif->id);	
				$this->db->set('idProduit',$id); 	
				$this->db->set('prix',$tarif->prix); 
              	$this->db->insert('TarifProduit');

			}			
			
		}

		if (count($article->depots)>0) {

			foreach ($article->depots as $key => $depot) {

				$this->db->set('idDepot',$depot->id);	
				$this->db->set('idProduit',$id);	
				$this->db->set('qte',$depot->qte);	
				$this->db->set('qteInv',0);	
				$this->db->set('qteInt',0);	
				$this->db->set('qteMin',$depot->min);	
				$this->db->set('qteMax',$depot->max);
				$this->db->set('emplacement',isset($depot->emplacement)?$depot->emplacement:'');
				$this->db->insert('DepotProduit');

			}	
			
		}


		if (count($article->nomenclatures)>0) {


			foreach ($article->nomenclatures as $key => $nomenclature) {


				$this->db->set('idProduit',$id);
 				$this->db->set('idProduitLiee',$nomenclature->idProduit); 
				$this->db->set('qte',$nomenclature->qte);
				$this->db->insert('ProduitsNomenclature');
			}
		}

		if (count($article->properties)>0) {

			foreach ($article->properties as $key => $propertie) {

				$this->db->set('idPropriete',$propertie->detail_id);
				$this->db->set('idProduit',$id);
				$this->db->insert('ProprietesArticle');


			}
		}

		

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',5);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function updateArticle($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$article = json_decode($json);

		$id = $article->id;




		$type = explode('/', mime_content_type($article->img))[1];

		$data = $article->img;

		if (preg_match('/^data:image\/(\w+);base64,/', $data, $type)) {
		    $data = substr($data, strpos($data, ',') + 1);
		    $type = strtolower($type[1]); // jpg, png, gif

		    if (!in_array($type, [ 'jpg', 'jpeg', 'gif', 'png' ])) {
			    $this->db->trans_rollback();
			    return FALSE;
		    }
		    $data = str_replace( ' ', '+', $data );
		    $data = base64_decode($data);

		    $filename = substr( base_convert( time(), 10, 36 ) . md5( microtime() ), 0, 16 ).'.' . $type;

		    if ($data === false) {
			    $this->db->trans_rollback();
			    return FALSE;
		    }
		} else {
		    $this->db->trans_rollback();
		    return FALSE;
		}

		if (($data = @file_put_contents('assets/uploads/' . $filename, $data)) === false) {
		      // $error = error_get_last();
		      // echo "HTTP request failed. Error was: " . $error['message'];
			$this->db->trans_rollback();
		    return FALSE;
		}


		$this->db->set('CODEART',$article->code);

		$this->db->set('DESIGNAT',$article->desgin);

		$this->db->set('idFA',$article->familleArticle);

		$this->db->set('idTA',$article->typeArticle);

		$this->db->set('idU',$article->uniteVente);

		$this->db->set('idUA',$article->uniteAchat);

		$this->db->set('STOCKABL',$article->stockable);

		$this->db->set('PAHT',$article->prixAchat);

		$this->db->set('PVHT',$article->prixVente);

		$this->db->set('idTVA',$article->tva);

		$this->db->set('idM',$article->marque);

		$this->db->set('Observat',$article->observation); 

		$this->db->set('codeBar',$article->barcode);

		$this->db->set('Pays',$article->pays);

		$this->db->set('Poids',$article->poids);  

		$this->db->set('longeur',$article->longeur);  

		$this->db->set('largeur',$article->largeur);  

		$this->db->set('delaisPrepa',$article->delaisPrepa);

		$this->db->set('garentie',$article->garentie);  

		//$this->db->set('img',$article->img); 

		$this->db->set('urlImg','assets/uploads/'.$filename);   

		$this->db->where('idProduit',$id);

		$this->db->update('Produits');

		if (count($article->tarifs)>0) {

			foreach ($article->tarifs as $key => $tarif) {
				$this->db->where('idTarif',$tarif->id);	
				$this->db->where('idProduit',$id); 
				$query = $this->db->get('TarifProduit');	
				if($query->num_rows()>0){

					$this->db->where('idTarif',$tarif->id);	
					$this->db->where('idProduit',$id); 	
					$this->db->set('prix',$tarif->prix); 
	              	$this->db->update('TarifProduit');

				}else{

					$this->db->set('idTarif',$tarif->id);	
					$this->db->set('idProduit',$id); 	
					$this->db->set('prix',$tarif->prix); 
	              	$this->db->insert('TarifProduit');					

				}
			}			
		}

		if (count($article->depots)>0) {

			foreach ($article->depots as $key => $depot) {
				$this->db->where('idDepot',$depot->id);
				$this->db->where('idProduit',$id); 
				$query = $this->db->get('DepotProduit');	
				if($query->num_rows()>0){

					$this->db->where('idDepot',$depot->id);	
					$this->db->where('idProduit',$id);	
					$this->db->set('qte',$depot->qte);	
					$this->db->set('qteMin',$depot->min);	
					$this->db->set('qteMax',$depot->max);
					$this->db->set('emplacement',isset($depot->emplacement)?$depot->emplacement:'');
					$this->db->update('DepotProduit');	

				}else{

					$this->db->set('idDepot',$depot->id);	
					$this->db->set('idProduit',$id);	
					$this->db->set('qte',$depot->qte);	
					$this->db->set('qteInv',0);	
					$this->db->set('qteInt',0);	
					$this->db->set('qteMin',$depot->min);	
					$this->db->set('qteMax',$depot->max);
					$this->db->insert('DepotProduit');	

				}

			}	
			
		}
		$this->db->where('idProduit',$id);
		$this->db->delete('ProprietesArticle');

		if (count($article->properties)>0) {

			foreach ($article->properties as $key => $propertie) {

				$this->db->set('idPropriete',$propertie->detail_id);
				$this->db->set('idProduit',$id);
				$this->db->insert('ProprietesArticle');

			}
		}

		$this->db->where('idProduit',$id);
		$this->db->delete('ProduitsNomenclature');

		if (count($article->nomenclatures)>0) {

			foreach ($article->nomenclatures as $key => $nomenclature) {

				$this->db->set('idProduit',$id);
 				$this->db->set('idProduitLiee',$nomenclature->idProduit); 
				$this->db->set('qte',$nomenclature->qte);
				$this->db->insert('ProduitsNomenclature');
			}
		}
		
		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',6);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function setPasswordCommercial($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$commercial = json_decode($json);

		$id = $commercial->id;

		$this->db->where("LOGUSER",$commercial->user);

		$this->db->where("PWD",$commercial->password);

		$this->db->where("idC !=",$id);

		$query = $this->db->get("Commerciaux");

        if($query->num_rows() > 0) { return FALSE;}

		$this->db->set('LOGUSER',$commercial->user);

		$this->db->set('PWD',$commercial->password);

		$this->db->where('idC',$id);

		$this->db->update('Commerciaux');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',36);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}




	public function masquerCommercial($id,$activer,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('active',$activer);

		$this->db->where('idC',$id);

		$this->db->update('Commerciaux');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		if($activer){
			$this->db->set('type',27);
		}else{
			$this->db->set('type',26);
		}

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function removeCommercial($id,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('removed',TRUE);
		$this->db->where('idC',$id);
		$this->db->update('Commerciaux');

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',25);

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertCommercial($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$commercial = json_decode($json);

		$this->db->set('nom',$commercial->nom);
		$this->db->set('tel1',$commercial->tel1);
		$this->db->set('tel2',$commercial->tel2);
		$this->db->set('email',$commercial->email);
		$this->db->set('adresse',$commercial->adresse);
		$this->db->set('codePostal',($commercial->code_postal) ? $commercial->code_postal :'');
		$this->db->set('ville',$commercial->ville);
		$this->db->set('commission',$commercial->comm);
		$this->db->set('objectif',$commercial->objectif);

		$this->db->insert('Commerciaux');

		$id = $this->db->insert_id();

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',31);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function updateCommercial($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$commercial = json_decode($json);

		$id = $commercial->id;

		$this->db->set('nom',$commercial->nom);
		$this->db->set('tel1',$commercial->tel1);
		$this->db->set('tel2',$commercial->tel2);
		$this->db->set('email',$commercial->email);
		$this->db->set('adresse',$commercial->adresse);
		$this->db->set('codePostal',($commercial->code_postal) ? $commercial->code_postal :'');
		$this->db->set('ville',$commercial->ville);
		$this->db->set('commission',$commercial->comm);
		$this->db->set('objectif',$commercial->objectif);

		$this->db->where('idC',$id);

		$this->db->update('Commerciaux');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',32);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertClients($clients){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		foreach ($clients as $key => $client) {
			
			$this->db->set('raisonSociale',$client['raisonSociale']);
			$this->db->set('tel1',$client['tel1']);
			$this->db->set('tel2',$client['tel2']);
			$this->db->set('responsable',$client['responsable']);

			$this->db->set('idFC',$client['idFC']);
	
			$this->db->set('idFiscal',$client['idFiscal']);

			$this->db->set('ICE',$client['ICE']);

			$this->db->set('codePostal',$client['codePostal']);
			$this->db->set('CODEPOSTL',$client['CODEPOSTL']);
			$this->db->set('ville',$client['ville']);	
			$this->db->set('VILLEL',$client['VILLEL']);
			$this->db->set('adresse',$client['adresse']);
			$this->db->set('ADRESSL',$client['ADRESSL']);



			$this->db->insert('Clients');


		}


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function insertClient($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$client = json_decode($json);

		$this->db->set('raisonSociale',$client->raisonsociale);
		$this->db->set('tel1',$client->tel1);
		$this->db->set('tel2',$client->tel2);
		$this->db->set('fax',$client->fax);
		$this->db->set('email',$client->email);
		$this->db->set('responsable',$client->responsable);
		$this->db->set('siteWeb',$client->siteweb);

		$this->db->set('idC',$client->commercial);

		$this->db->set('idFC',$client->famille_client);
		$this->db->set('idR',$client->region);
		$this->db->set('idDP',$client->delais_paie);
		$this->db->set('idMP',$client->mode_paie);

		$this->db->set('Observation',$client->observations);



		$this->db->set('COMPTCPT',$client->compt_comptibilite);
		

		$this->db->set('idFiscal',$client->idFiscal);
		$this->db->set('Patente',$client->patenete);
		$this->db->set('CNSS',$client->cnss);
		$this->db->set('RC',$client->rc);
		$this->db->set('ICE',$client->ice);

		// $this->db->set('compteBloquer',$compteBloquer);
		// $this->db->set('compteDebloquer',$compteDebloquer);

		// $this->db->set('clientAssure',$clientAssure);

		$this->db->set('idTarif',$client->tarif);

		$this->db->set('creditMax',$client->credit_max);
		$this->db->set('Objectif',$client->objectif);
		$this->db->set('idCatCli',$client->categorie);


		$this->db->set('codePostal',$client->fact_codep);
		$this->db->set('CODEPOSTL',$client->liv_codep);
		$this->db->set('ville',$client->fact_ville);	
		$this->db->set('VILLEL',$client->liv_ville);
		$this->db->set('adresse',$client->fact_adresse);
		$this->db->set('ADRESSL',$client->liv_adresse);


		$this->db->set('paysF',$client->fact_pays);
		$this->db->set('paysL',$client->liv_pays);

		$this->db->insert('Clients');

		$id = $this->db->insert_id();

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',7);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function masquerClient($id,$activer,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('active',$activer);
		$this->db->where('idCli',$id);
		$this->db->update('Clients');
		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		if($activer){
			$this->db->set('type',33);
		}else{
			$this->db->set('type',34);
		}


		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function removeClient($id,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('removed',TRUE);
		$this->db->where('idCli',$id);
		$this->db->update('Clients');
		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',35);

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function masquerFournisseur($id,$activer,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('active',$activer);
		$this->db->where('idF',$id);
		$this->db->update('Fournisseurs');
		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		if($activer){
			$this->db->set('type',23);
		}else{
			$this->db->set('type',22);
		}

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function removeFournisseur($id,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('removed',TRUE);
		$this->db->where('idF',$id);
		$this->db->update('Fournisseurs');

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',24);

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}





	public function updateClient($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$client = json_decode($json);

		$id = $client->id;

		$this->db->set('raisonSociale',$client->raisonsociale);
		$this->db->set('tel1',$client->tel1);
		$this->db->set('tel2',$client->tel2);
		$this->db->set('fax',$client->fax);
		$this->db->set('email',$client->email);
		$this->db->set('responsable',$client->responsable);
		$this->db->set('siteWeb',$client->siteweb);

		$this->db->set('idC',$client->commercial);

		$this->db->set('idFC',$client->famille_client);
		$this->db->set('idR',$client->region);
		$this->db->set('idDP',$client->delais_paie);
		$this->db->set('idMP',$client->mode_paie);

		$this->db->set('Observation',$client->observations);
		$this->db->set('idCatCli',$client->categorie);


		$this->db->set('COMPTCPT',$client->compt_comptibilite);
		

		$this->db->set('idFiscal',$client->idFiscal);
		$this->db->set('Patente',$client->patenete);
		$this->db->set('CNSS',$client->cnss);
		$this->db->set('RC',$client->rc);
		$this->db->set('ICE',$client->ice);

		// $this->db->set('compteBloquer',$compteBloquer);
		// $this->db->set('compteDebloquer',$compteDebloquer);

		// $this->db->set('clientAssure',$clientAssure);


		$this->db->set('creditMax',$client->credit_max);
		$this->db->set('Objectif',$client->objectif);


		$this->db->set('codePostal',$client->fact_codep);
		$this->db->set('CODEPOSTL',$client->liv_codep);
		$this->db->set('ville',$client->fact_ville);	
		$this->db->set('VILLEL',$client->liv_ville);
		$this->db->set('adresse',$client->fact_adresse);
		$this->db->set('ADRESSL',$client->liv_adresse);

		$this->db->set('idTarif',$client->tarif);


		$this->db->set('paysF',$client->fact_pays);
		$this->db->set('paysL',$client->liv_pays);

		$this->db->where('idCli',$id);

		$this->db->update('Clients');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',8);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function insertFournisseurs($fournisseurs){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		foreach ($fournisseurs as $key => $fournisseur) {
			
			$this->db->set('raisonSociale',$fournisseur['raisonSociale']);
			$this->db->set('tel1',$fournisseur['tel1']);
			$this->db->set('tel2',$fournisseur['tel2']);
			$this->db->set('fax',$fournisseur['fax']);
			$this->db->set('email',$fournisseur['email']);
			$this->db->set('responsable',$fournisseur['responsable']);
			$this->db->set('siteWeb',$fournisseur['siteWeb']);
			$this->db->set('codePostalF',$fournisseur['codePostalF']);
			$this->db->set('codePostalL',$fournisseur['codePostalL']);
			$this->db->set('villeF',$fournisseur['villeF']);	
			$this->db->set('villeL',$fournisseur['villeL']);
			$this->db->set('adresseF',$fournisseur['adresseF']);
			$this->db->set('adresseL',$fournisseur['adresseL']);

			$this->db->insert('Fournisseurs');

		}

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertFournisseur($json,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$fournisseur = json_decode($json);

		$this->db->set('raisonSociale',$fournisseur->raisonsociale);
		$this->db->set('tel1',$fournisseur->tel1);
		$this->db->set('tel2',$fournisseur->tel2);
		$this->db->set('fax',$fournisseur->fax);
		$this->db->set('email',$fournisseur->email);
		$this->db->set('responsable',$fournisseur->responsable);
		$this->db->set('siteWeb',$fournisseur->siteweb);


		$this->db->set('idFF',$fournisseur->famille_fournisseur);
		$this->db->set('CODEDEL',$fournisseur->delais_paie);

		$this->db->set('COMPTCPT',$fournisseur->compt_comptibilite);
		
		// $this->db->set('idTarif',$fournisseur->tarif);

		$this->db->set('codePostalF',$fournisseur->fact_codep);
		$this->db->set('codePostalL',$fournisseur->liv_codep);
		$this->db->set('villeF',$fournisseur->fact_ville);	
		$this->db->set('villeL',$fournisseur->liv_ville);
		$this->db->set('adresseF',$fournisseur->fact_adresse);
		$this->db->set('adresseL',$fournisseur->liv_adresse);

		$this->db->set('paysF',$fournisseur->fact_pays);
		$this->db->set('paysL',$fournisseur->liv_pays);

		$this->db->insert('Fournisseurs');

		$id = $this->db->insert_id();

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',9);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function updateFournisseur($json,$idUser){
		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$fournisseur = json_decode($json);

		$id = $fournisseur->id;

		$this->db->set('raisonSociale',$fournisseur->raisonsociale);
		$this->db->set('tel1',$fournisseur->tel1);
		$this->db->set('tel2',$fournisseur->tel2);
		$this->db->set('fax',$fournisseur->fax);
		$this->db->set('email',$fournisseur->email);
		$this->db->set('responsable',$fournisseur->responsable);
		$this->db->set('siteWeb',$fournisseur->siteweb);


		$this->db->set('idFF',$fournisseur->famille_fournisseur);
		$this->db->set('CODEDEL',$fournisseur->delais_paie);

		$this->db->set('COMPTCPT',$fournisseur->compt_comptibilite);
		
		// $this->db->set('idTarif',$fournisseur->tarif);

		$this->db->set('codePostalF',$fournisseur->fact_codep);
		$this->db->set('codePostalL',$fournisseur->liv_codep);
		$this->db->set('villeF',$fournisseur->fact_ville);	
		$this->db->set('villeL',$fournisseur->liv_ville);
		$this->db->set('adresseF',$fournisseur->fact_adresse);
		$this->db->set('adresseL',$fournisseur->liv_adresse);

		$this->db->set('paysF',$fournisseur->fact_pays);
		$this->db->set('paysL',$fournisseur->liv_pays);

		$this->db->where('idF',$id);

		$this->db->update('Fournisseurs');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',10);

		$this->db->set('json',$json);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

















































	// public function transferDevis($devis){

	// 	$this->db->trans_start(); 

	// 	$this->db->trans_strict(TRUE); 



	// 	$this->db->set('NUMDOC',);

	// 	$this->db->set('DATE',);

	// 	$this->db->set('CODETIER',);

	// 	$this->db->set('MONTANT',);

	// 	$this->db->set('TAUXREM',);

	// 	$this->db->set('MONTTVAART',);

	// 	$this->db->set('NOMTIER',);

	// 	$this->db->set('ADRESSE',);

	// 	$this->db->set('tel',);

	// 	$this->db->set('BC',);

	// 	$this->db->set('Nexpedition',);

	// 	$this->db->set('Contre',); 

	// 	$this->db->set('Exp',);

	// 	$this->db->set('chauff',);

	// 	$this->db->set('superv',);  

	// 	$this->db->set('prepa',);

	// 	$this->db->set('CodeDepot',);

	// 	$this->db->set('vehicul',);

	// 	$this->db->insert('BonsLivraison');





	// 	$this->db->set('NUMDOC',);

	// 	$this->db->set('CODEART',);

	// 	$this->db->set('PUHT',);

	// 	$this->db->set('PTTC',);

	// 	$this->db->set('QTE',);

	// 	$this->db->set('REMISE',);

	// 	$this->db->set('CODETVA',);

	// 	$this->db->set('CODETIER',);

	// 	$this->db->set('DATE',);

	// 	$this->db->set('DESIGNAT',);

	// 	$this->db->set('CODEFAM',);

	// 	$this->db->set('COMMENT',);

	// 	$this->db->insert('detailsBonsLivraison');



	// 	$this->db->set('idUtilisateur',);

	// 	$this->db->set('idDocu',);

	// 	$this->db->set('type',);

	// 	$this->db->set('json',);
		
	// 	$this->db->insert('ActivitiesUtilisateur');




	// 	$this->db->trans_complete();

	// 	if ($this->db->trans_status() === FALSE) {
	// 	    $this->db->trans_rollback();
	// 	    return FALSE;
	// 	}else {
	// 	    $this->db->trans_commit();
	// 	    return TRUE;
	// 	}



	// }

	public function getProduitsBC($idpp=0){

		$produits = $this->db->query("SELECT DetailsBonsCommande.QTE, DetailsBonsCommande.REMISE,IF(DetailsBonsCommande.CODEART > 0,0,1) selected,Produits.idProduit,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,Produits.PVHT, Produits.DESIGNAT, GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';') properties, GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte,DepotProduit.qte SEPARATOR ';') stock FROM Produits LEFT JOIN DetailsBonsCommande ON DetailsBonsCommande.CODEART = Produits.idProduit AND DetailsBonsCommande.NUMDOC = $idpp LEFT JOIN Marques ON Marques.idM = Produits.idM INNER JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete INNER JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot GROUP BY Produits.idProduit")->result_array();

		return $produits;
	}

	public function getProduitsStockAvoir($idpp=0,$idtarif=0){

		return $this->db->query("
			SELECT DetailsAvoir.QTE, DetailsAvoir.REMISE,IF(DetailsAvoir.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			IFNULL(TarifProduit.prix,Produits.PVHT) PVHT
			, 
			Produits.DESIGNAT, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN DetailsAvoir ON DetailsAvoir.CODEART = Produits.idProduit AND DetailsAvoir.NUMDOC = $idpp 
			LEFT JOIN TarifProduit ON TarifProduit.idProduit = Produits.idProduit AND TarifProduit.idTarif = $idtarif
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot 

			GROUP BY Produits.idProduit")->result_array();

	}

	public function getProduitsStockDevis($idpp=0,$idtarif=0){

		return $this->db->query("
			SELECT DetailsDevis.QTE, DetailsDevis.REMISE,IF(DetailsDevis.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			IFNULL(TarifProduit.prix,Produits.PVHT) PVHT
			, 
			Produits.DESIGNAT, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN DetailsDevis ON DetailsDevis.CODEART = Produits.idProduit AND DetailsDevis.NUMDOC = $idpp 
			LEFT JOIN TarifProduit ON TarifProduit.idProduit = Produits.idProduit AND TarifProduit.idTarif = $idtarif
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot 

			GROUP BY Produits.idProduit")->result_array();

	}

	public function getProduitsFournisseur($idpp=0){

		$produits = $this->db->query("
			SELECT DetailsBonsCommande.QTE, DetailsBonsCommande.REMISE,IF(DetailsBonsCommande.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,Produits.PAHT PVHT,Produits.DESIGNAT,IFNULL(Marques.marque,'') marque, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN DetailsBonsCommande ON DetailsBonsCommande.CODEART = Produits.idProduit AND DetailsBonsCommande.NUMDOC = $idpp 
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot 

			GROUP BY Produits.idProduit")->result_array();

		return $produits;


	}


	public function filtererProduitsStock($idpp=0,$idtarif=0){

		$produits = $this->db->query("
			SELECT detailsBonsLivraison.QTE, detailsBonsLivraison.REMISE,IF(detailsBonsLivraison.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			IFNULL(TarifProduit.prix,Produits.PVHT) PVHT
			, 
			Produits.DESIGNAT, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN detailsBonsLivraison ON detailsBonsLivraison.CODEART = Produits.idProduit AND detailsBonsLivraison.NUMDOC = $idpp 
			LEFT JOIN TarifProduit ON TarifProduit.idProduit = Produits.idProduit AND TarifProduit.idTarif = $idtarif
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot 

			GROUP BY Produits.idProduit LIMIT 50")->result_array();

		return $produits;

	}

	public function getProduitsStock($idpp=0,$idtarif=0,$term = ''){

		$query = "SELECT detailsBonsLivraison.QTE, detailsBonsLivraison.REMISE,IF(detailsBonsLivraison.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			IFNULL(TarifProduit.prix,Produits.PVHT) PVHT, Produits.DESIGNAT, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN detailsBonsLivraison ON detailsBonsLivraison.CODEART = Produits.idProduit AND detailsBonsLivraison.NUMDOC = '$idpp'
			LEFT JOIN TarifProduit ON TarifProduit.idProduit = Produits.idProduit AND TarifProduit.idTarif = '$idtarif'
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot";
			if($term!=''){
				$query .=" WHERE  Produits.DESIGNAT LIKE '%".$term."%' OR Produits.CODEART LIKE '%".$term."%'";
			}
			$query .=" GROUP BY Produits.idProduit LIMIT 50";

		$produits = $this->db->query($query)->result_array();

		return $produits;
	}

	public function getProduitsAFournisseur($idpp=0,$term = ''){

		$query = "SELECT detailsBonsLivraison.QTE, detailsBonsLivraison.REMISE,IF(detailsBonsLivraison.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			Produits.PAHT PVHT, Produits.DESIGNAT, 

			IFNULL(GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';'),'') properties, IFNULL(GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';'),'')  stock 
			FROM Produits 
			LEFT JOIN detailsBonsLivraison ON detailsBonsLivraison.CODEART = Produits.idProduit AND detailsBonsLivraison.NUMDOC = '$idpp'
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot";
			if($term!=''){
				$query .=" WHERE  Produits.DESIGNAT LIKE '%".$term."%' OR Produits.CODEART LIKE '%".$term."%'";
			}
			$query .=" GROUP BY Produits.idProduit LIMIT 50";

		$produits = $this->db->query($query)->result_array();

		return $produits;
	}

	public function getProduitsTarif($idtarif=0){

		$produits = $this->db->query("
			SELECT detailsBonsLivraison.QTE, detailsBonsLivraison.REMISE,IF(detailsBonsLivraison.CODEART > 0,0,1) selected,Produits.idProduit,Produits.removed,Produits.active,Produits.idFA,Produits.idTVA, Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,
			IFNULL(TarifProduit.prix,Produits.PVHT) PVHT
			, Produits.DESIGNAT, GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete SEPARATOR ';') properties, GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte SEPARATOR ';') stock 
			FROM Produits 
			LEFT JOIN TarifProduit ON TarifProduit.idProduit = Produits.idProduit AND TarifProduit.idTarif = $idpp
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			INNER JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			INNER JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot 
			

			GROUP BY Produits.idProduit")->result_array();

		return $produits;
	}
	public function stockArticle(){
		$query = $this->db->get('Produits')->result_array();
		foreach ($query as $key => $q) {


				$this->db->set('idDepot',1);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->set('qte',$q['QTESTOCK1']);
				$this->db->set('qteInv',$q['QTEINV']);
				$this->db->set('qteInt',$q['STOINI']);
				$this->db->insert('DepotProduit');


				$this->db->set('idDepot',2);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->set('qte',$q['QTESTOCK2']);
				$this->db->set('qteInv',$q['QTEINV2']);
				$this->db->set('qteInt',$q['STOINI2']);
				$this->db->insert('DepotProduit');


				$this->db->set('idDepot',3);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->set('qte',$q['QTESTOCK3']);
				$this->db->set('qteInv',$q['QTEINV3']);
				$this->db->set('qteInt',$q['STOINI3']);
				$this->db->insert('DepotProduit');


				$this->db->set('idDepot',4);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->set('qte',$q['QTESTOCK4']);
				$this->db->set('qteInv',$q['QTEINV4']);
				$this->db->set('qteInt',$q['STOINI4']);
				$this->db->insert('DepotProduit');



		}
	}


	public function getProp(){

		$query = $this->db->get('Produits')->result_array();
		foreach ($query as $key => $q) {

			$this->db->where('detailPropriete',$q['Dimension']);
			$queryd = $this->db->get('DetailsPropriete')->result_array();

			if(count($queryd)>0){
				$this->db->set('idPropriete',$queryd[0]['idDProp']);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->insert('ProprietesArticle');
			}

			$this->db->where('detailPropriete',$q['NSerie']);
			$querys = $this->db->get('DetailsPropriete')->result_array();

			if(count($querys)>0){

				$this->db->set('idPropriete',$querys[0]['idDProp']);
				$this->db->set('idProduit',$q['idProduit']);
				$this->db->insert('ProprietesArticle');

			}
			
		}

	}

	public function getBLFacture(){

		$query = $this->db->get('BonsLivraison')->result_array();
		foreach ($query as $key => $q) {




		}


	}



	public function getChauffeurs(){
		$this->db->where('removed',FALSE);
		return $this->db->get('Chauffeurs')->result_array();

	}


	public function insertChauffeur($chauffeur){

		$this->db->set('chauffeur',$chauffeur);
		return $this->db->insert('Chauffeurs');
	}

	public function updateChauffeur($id,$chauffeur){

		$this->db->set('chauffeur',$chauffeur);
		$this->db->where('idChauffeur',$id);
		return $this->db->update('Chauffeurs');
	}

	public function masquerChauffeur($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idChauffeur',$id);
		return $this->db->update('Chauffeurs');
	}


	public function removeChauffeur($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idChauffeur',$id);
		return $this->db->update('Chauffeurs');
	}





	public function getVehicules(){
		$this->db->where('removed',FALSE);
		return $this->db->get('Vehicules')->result_array();

	}

	public function insertVehicule($vehicules){

		$this->db->set('immatriculation',$vehicules);
		return $this->db->insert('Vehicules');
	}

	public function updateVehicule($id,$vehicules){

		$this->db->set('immatriculation',$vehicules);
		$this->db->where('idVehicule',$id);
		return $this->db->update('Vehicules');
	}

	public function masquerVehicule($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idVehicule',$id);
		return $this->db->update('Vehicules');
	}


	public function removeVehicule($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idVehicule',$id);
		return $this->db->update('Vehicules');
	}


	public function getSuperviseurs(){
		$this->db->where('removed',FALSE);
		return $this->db->get('Superviseurs')->result_array();

	}

	public function insertSuperviseur($superviseur){

		$this->db->set('superviseur',$superviseur);
		return $this->db->insert('Superviseurs');
	}

	public function updateSuperviseur($id,$chauffeur){

		$this->db->set('superviseur',$superviseur);
		$this->db->where('idSuperviseur',$id);
		return $this->db->update('Superviseurs');
	}

	public function masquerSuperviseur($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idSuperviseur',$id);
		return $this->db->update('Superviseurs');
	}


	public function removeSuperviseur($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idSuperviseur',$id);
		return $this->db->update('Superviseurs');
	}


	public function getPreparateurs(){
		$this->db->where('removed',FALSE);
		return $this->db->get('Preparateurs')->result_array();

	}

	public function insertPreparateur($preparateur){

		$this->db->set('preparateur',$preparateur);
		return $this->db->insert('Preparateurs');
	}

	public function updatePreparateur($id,$preparateur){

		$this->db->set('preparateur',$preparateur);
		$this->db->where('idPreparateur',$id);
		return $this->db->update('Preparateurs');
	}

	public function masquerPreparateur($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idPreparateur',$id);
		return $this->db->update('Preparateurs');
	}


	public function removePreparateur($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idPreparateur',$id);
		return $this->db->update('Preparateurs');
	}


	public function getExpediteurs(){
		$this->db->where('removed',FALSE);
		return $this->db->get('Expediteurs')->result_array();

	}

	public function insertExpediteur($expediteur){

		$this->db->set('expediteur',$expediteur);
		return $this->db->insert('Expediteurs');
	}

	public function updateExpediteur($id,$expediteur){

		$this->db->set('expediteur',$expediteur);
		$this->db->where('idExpediteur',$id);
		return $this->db->update('Expediteurs');
	}

	public function masquerExpediteur($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idExpediteur',$id);
		return $this->db->update('Expediteurs');
	}


	public function removeExpediteur($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idExpediteur',$id);
		return $this->db->update('Expediteurs');
	}


	public function getContres(){

		return $this->db->get('Contres')->result_array();

	}

	public function getCategoriesClient(){

		return $this->db->get('CategoriesClient')->result_array();

	}

	public function insertBanque($banque){

		$this->db->set('banque',$banque);
		return $this->db->insert('Banques');
	}

	public function updateBanque($id,$banque){

		$this->db->set('banque',$banque);
		$this->db->where('idB',$id);
		return $this->db->update('Banques');
	}

	public function masquerBanque($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idB',$id);
		return $this->db->update('Banques');
	}


	public function removeBanque($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idB',$id);
		return $this->db->update('Banques');
	}

	public function updateUnite($id,$banque){

		$this->db->set('unite',$banque);
		$this->db->where('idU',$id);
		return $this->db->update('Unites');
	}

	public function masquerUnite($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idU',$id);
		return $this->db->update('Unites');
	}


	public function removeUnite($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idU',$id);
		return $this->db->update('Unites');
	}

	public function insertUnite($unite){

		$this->db->set('unite',$unite);
		return $this->db->insert('Unites');
	}


	public function updateTVA($id,$tva,$taux){

		$this->db->set('tva',$tva);
		$this->db->set('taux',$taux);
		$this->db->where('idTVA',$id);
		return $this->db->update('TVA');
	}

	public function masquerTVA($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idTVA',$id);
		return $this->db->update('TVA');
	}


	public function removeTVA($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idTVA',$id);
		return $this->db->update('TVA');
	}

	public function insertTVA($tva,$taux){
		$this->db->set('taux',$taux);
		$this->db->set('tva',$tva);
		return $this->db->insert('TVA');
	}




	public function getBanques(){

		$this->db->where('removed',FALSE);
		return $this->db->get('Banques')->result_array();
		
	}


	public function getBanqueById($id){

		$this->db->where('idR',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Banques')->result_array();
		
	}

	public function getBanqueByCode($code){

		$this->db->where('codeR',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Banques')->result_array();
		
	}



	public function getPays(){

		return $this->db->get('Pays')->result_array();

	}

	public function activerGamme($idGamme,$active){

		$this->db->set('active',$active);
		$this->db->where('idPropriete',$idGamme);
		return $this->db->update('Proprietes');

	}

	public function deleteGamme($idGamme){


		$this->db->set('removed',1);
		$this->db->where('idPropriete',$idGamme);
		return $this->db->update('Proprietes');

	}

	public function updateGamme($idGamme,$gamme,$adefinir){

		$this->db->set('propriete',$gamme);
		$this->db->set('aDefinir',$adefinir);
		$this->db->where('idPropriete',$idGamme);
		return $this->db->update('Proprietes');

	}


	public function getPropierteById($idPropriete){

		$this->db->where('idPropriete',$idPropriete);
		$this->db->order_by('dateCreation');
		return $this->db->get('DetailsPropriete')->result_array();

	}


	public function insertPropierte($detailPropriete,$idPropriete){

		$this->db->set('detailPropriete',$detailPropriete);
		$this->db->set('idPropriete',$idPropriete);
		return $this->db->insert('DetailsPropriete');

	}

	public function insertGamme($gamme,$adefinir){

		$this->db->set('propriete',$gamme);
		$this->db->set('aDefinir',$adefinir);
		return $this->db->insert('Proprietes');

	}
	public function getProprietesDetails(){

		$this->db->where('active',1);
		$this->db->where('removed',0);
		$proprietes = $this->db->get('Proprietes')->result_array();
		foreach ($proprietes as $key => $propriete) {
			if(!$propriete['aDefinir']){

				$this->db->select('DetailsPropriete.*,DetailsPropriete.detailPropriete label');
				$this->db->where('idPropriete',$propriete['idPropriete']);
				$this->db->order_by('dateCreation','DESC');
				$proprietes[$key]['DProperties'] = $this->db->get('DetailsPropriete')->result_array();

			}
		}

		return $proprietes;

	}



	public function getProprietes(){

		//$this->db->where('active',1);
		//$this->db->where('active',1);
		$this->db->where('removed',0);
		$proprietes = $this->db->get('Proprietes')->result_array();
		foreach ($proprietes as $key => $propriete) {
			if(!$propriete['aDefinir']){

				$this->db->select('DetailsPropriete.*,DetailsPropriete.detailPropriete label');
				$this->db->where('idPropriete',$propriete['idPropriete']);
				$this->db->order_by('dateCreation','DESC');
				$proprietes[$key]['DProperties'] = $this->db->get('DetailsPropriete')->result_array();

			}
		}

		return $proprietes;

	}

	public function getPropriete($id){



		$this->db->where('idPropriete',$id);
		return $this->db->get('Proprietes')->result_array();

	}
	public function getTypesArticle(){

		return $this->db->get('TypesArticle')->result_array();
	}


	public function searchArticle($filters){


		$this->db->select('r.*');

		$this->db->where('r.removed',false);

		$this->db->like('r.DESIGNAT',$filters, 'both'); 

		$query1 =$this->db->get_compiled_select('Produits r');


		$this->db->select('r.*');

		$this->db->where('r.removed',false);

		$this->db->like('r.NSerie',$filters, 'both'); 

		$query2 =$this->db->get_compiled_select('Produits r');


		$this->db->select('r.*');

		$this->db->where('r.removed',false);

		$this->db->like('r.Dimension',$filters, 'both'); 

		$query3 =$this->db->get_compiled_select('Produits r');

    	return  $this->db->query($query1." UNION ".$query2." UNION ".$query3.' GROUP BY idProduit ORDER BY dateCreation DESC')->result_array();
	}


	public function getFacture($id){

		$this->db->select('Factures.*,Clients.RC,Clients.ICE,DetailsSortie.DESIGNAT,DetailsSortie.PUHT,DetailsSortie.PTTC,DetailsSortie.QTE,DetailsSortie.REMISE,DetailsSortie.CODETVA,DetailsSortie.CODEART,DetailsSortie.CODEFAM,DetailsSortie.COMMENT');

		$this->db->join('Factures','DetailsSortie.NUMDOC = Factures.idFacture','LEFT');
		$this->db->join('Clients','Clients.idCli = Factures.CODETIER','LEFT');
		$this->db->where('DetailsSortie.NUMDOC',$id);
		return $this->db->get('DetailsSortie')->result_array();

	}





	public function getAvoir($id){

		$this->db->select('Avoirs.*,DetailsAvoir.DESIGNAT,DetailsAvoir.PUHT,DetailsAvoir.PTTC,DetailsAvoir.QTE,DetailsAvoir.REMISE,DetailsAvoir.CODETVA,DetailsAvoir.CODEART,DetailsAvoir.CODEFAM,DetailsAvoir.COMMENT');

		$this->db->join('Avoirs','DetailsAvoir.NUMDOC = Avoirs.idAvoir','LEFT');
		$this->db->where('DetailsAvoir.NUMDOC',$id);
		return $this->db->get('DetailsAvoir')->result_array();

	}

	public function getAvoirF($id){

		$this->db->select('AvoirsF.*,DetailsAvoirF.DESIGNAT,DetailsAvoirF.PUHT,DetailsAvoirF.PTTC,DetailsAvoirF.QTE,DetailsAvoirF.REMISE,DetailsAvoirF.CODETVA,DetailsAvoirF.CODEART,DetailsAvoirF.CODEFAM,DetailsAvoirF.COMMENT');

		$this->db->join('AvoirsF','DetailsAvoirF.NUMDOC = AvoirsF.idAvoirF','LEFT');
		$this->db->where('DetailsAvoirF.NUMDOC',$id);
		return $this->db->get('DetailsAvoirF')->result_array();

	}

	public function getBonLivraison($id){


		$this->db->select('BonsLivraison.*,Clients.RC,Clients.ICE,detailsBonsLivraison.DESIGNAT,detailsBonsLivraison.PUHT,detailsBonsLivraison.PTTC,detailsBonsLivraison.QTE,detailsBonsLivraison.REMISE,detailsBonsLivraison.CODETVA,detailsBonsLivraison.CODEART,detailsBonsLivraison.CODEFAM,detailsBonsLivraison.COMMENT');
		$this->db->join('BonsLivraison','detailsBonsLivraison.NUMDOC = BonsLivraison.idBL','LEFT');
		//$this->db->join('Produits','Produits.CODEART = DetailsSortie.CODEART','LEFT');
		$this->db->join('Clients','Clients.idCli = BonsLivraison.CODETIER','LEFT');
		$this->db->where('detailsBonsLivraison.NUMDOC',$id);
		return $this->db->get('detailsBonsLivraison')->result_array();

	}

	public function getBonReception($id){

		$this->db->select('BonsReception.*,DetailsBonsReception.DESIGNAT,DetailsBonsReception.PUHT,DetailsBonsReception.PTTC,DetailsBonsReception.QTE,DetailsBonsReception.REMISE,DetailsBonsReception.CODETVA,DetailsBonsReception.CODEART,DetailsBonsReception.CODEFAM,DetailsBonsReception.COMMENT');
		$this->db->join('BonsReception','DetailsBonsReception.NUMDOC = BonsReception.idBR','LEFT');
		//$this->db->join('Produits','Produits.CODEART = DetailsSortie.CODEART','LEFT');
		$this->db->where('DetailsBonsReception.NUMDOC',$id);
		return $this->db->get('DetailsBonsReception')->result_array();

	}

	public function getDevisTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('Devies')->result_array();

	}

	public function getBonsLiv(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('BonsLivraison')->result_array();

	}

	public function getFacturesFournisseurTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('FacturesF')->result_array();

	}

	public function getBonsCommandeTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('BonsCommande')->result_array();

	}

	public function getBonsReceptionTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('BonsReception')->result_array();

	}

	public function getFacturesTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('Factures')->result_array();

	}

	public function getAvoirsTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('Avoirs')->result_array();

	}

	public function getAvoirsFournisseurTot(){

		$this->db->select("sum(Montant+MONTTVAART) total,count(*) nbr");
		return $this->db->get('AvoirsF')->result_array();

	}


	public function getBonsReception(){

		$this->db->select('BonsReception.NUMDOC,BonsReception.idBR idBL,BonsReception.DATE ddate,DATE_FORMAT(BonsReception.DATE, "%d/%m/%Y") DATE,FORMAT(BonsReception.MONTANT+BonsReception.MONTTVAART,2) total,BonsReception.CODETIER, BonsReception.NOMTIER,BonsReception.ADRESSE,BonsReception.tel,(CASE BonsReception.fact WHEN "0" THEN "Saisi" WHEN "1" THEN "Facture" END) AS Valide'); 
		$this->db->order_by('BonsReception.idBR','DESC');

		//$this->db->limit(1);
		return $this->db->get('BonsReception')->result_array();

	}

	public function getFacturesFournisseur(){

		$this->db->select('FacturesF.*,Montant total,MONTREGL totalttc,BLRecuAnnul Valide');
		$this->db->order_by('FacturesF.idFactureF','DESC');
		return $this->db->get('FacturesF')->result_array();

	}


	public function getBonsCommande(){
		$this->db->select('BonsCommande.NUMDOC,BonsCommande.idBC idDevis,BonsCommande.DATE ddate,DATE_FORMAT(BonsCommande.DATE, "%d/%m/%Y") DATE,FORMAT(BonsCommande.MONTANT+BonsCommande.MONTTVAART,2) total,BonsCommande.CODETIER, BonsCommande.NOMTIER,BonsCommande.ADRESSE,BonsCommande.tel,(CASE BonsCommande.Valide WHEN "0" THEN "Saisi" WHEN "1" THEN "Confirme" WHEN "2" THEN "Valide" END) AS Valide'); 
		$this->db->order_by('BonsCommande.idBC','DESC');
		return $this->db->get('BonsCommande')->result_array();
	}

	public function getBonsLivraison(){

		$this->db->select('BonsLivraison.dateCreation,BonsLivraison.NUMDOC,BonsLivraison.idBL,BonsLivraison.DATE ddate,DATE_FORMAT(BonsLivraison.DATE, "%d/%m/%Y") DATE,FORMAT(BonsLivraison.MONTANT+BonsLivraison.MONTTVAART,2) total,FORMAT(BonsLivraison.MONTANT,2) totalht,BonsLivraison.CODETIER, BonsLivraison.NOMTIER,BonsLivraison.ADRESSE,BonsLivraison.tel,(CASE BonsLivraison.fact WHEN "0" THEN "Saisi" WHEN "1" THEN "Facture" END) AS Valide'); 
		$this->db->order_by('BonsLivraison.idBL','DESC');

		//$this->db->limit(1);
		return $this->db->get('BonsLivraison')->result_array();
	}



	public function getAvoirs(){

		$this->db->select('Avoirs.NUMDOC,Avoirs.idAvoir,Avoirs.DATE ddate,DATE_FORMAT(Avoirs.DATE, "%d/%m/%Y") DATE,FORMAT(Avoirs.MONTANT+Avoirs.MONTTVAART,2) total,Avoirs.CODETIER,FORMAT(Avoirs.MONTREGL,2) MONTREGL, Avoirs.NOMTIER,Avoirs.ADRESSE,Avoirs.tel,BLRecuAnnul Valide'); 
		$this->db->order_by('Avoirs.idAvoir','DESC');

		//$this->db->limit(1);
		return $this->db->get('Avoirs')->result_array();

	}
	public function getAvoirsFournisseur(){

		$this->db->select('AvoirsF.NUMDOC,AvoirsF.idAvoirF,AvoirsF.DATE ddate,DATE_FORMAT(AvoirsF.DATE, "%d/%m/%Y") DATE,FORMAT(AvoirsF.MONTANT+AvoirsF.MONTTVAART,2) total,AvoirsF.CODETIER,FORMAT(AvoirsF.MONTREGL,2) MONTREGL, AvoirsF.NOMTIER,AvoirsF.ADRESSE,AvoirsF.tel,BLRecuAnnul Valide'); 
		$this->db->order_by('AvoirsF.idAvoirF','DESC');

		//$this->db->limit(1);
		return $this->db->get('AvoirsF')->result_array();

	}

	public function getFactures(){

		$this->db->select('Factures.NUMDOC,Factures.idFacture,Factures.DATE ddate,DATE_FORMAT(Factures.DATE, "%d/%m/%Y") DATE,FORMAT(Factures.MONTANT+Factures.MONTTVAART,2) total,Factures.CODETIER,FORMAT(Factures.MONTREGL,2) MONTREGL, Factures.NOMTIER,Factures.ADRESSE,Factures.tel,BLRecuAnnul Valide,Factures.dateCreation'); 
		$this->db->order_by('Factures.idFacture','DESC');

		//$this->db->limit(1);
		return $this->db->get('Factures')->result_array();

	}

	public function getCharges(){

		$this->db->select('sum(DetailsBonsCharge.QTE) QTE,sum(DetailsBonsCharge.qteVendu) QTEV,BonsCharge.NUMDOC,BonsCharge.idBCharge,BonsCharge.DATE ddate,DATE_FORMAT(BonsCharge.DATE, "%d/%m/%Y") DATE,FORMAT(BonsCharge.MONTANT+BonsCharge.MONTTVAART,2) total,BonsCharge.CODETIER,FORMAT(BonsCharge.MONTREGL,2) MONTREGL, BonsCharge.NOMTIER,BonsCharge.ADRESSE,BonsCharge.tel,BLRecuAnnul Valide'); 

		$this->db->join('DetailsBonsCharge','DetailsBonsCharge.NUMDOC = BonsCharge.idBCharge','LEFT');
		$this->db->group_by('BonsCharge.idBCharge');
		$this->db->order_by('BonsCharge.idBCharge','DESC');

		//$this->db->limit(1);
		return $this->db->get('BonsCharge')->result_array();

	}
	public function getChargesTot(){

		$this->db->select("sum(DetailsBonsCharge.QTE) total,count(*) nbr");
		$this->db->join('DetailsBonsCharge','DetailsBonsCharge.NUMDOC = BonsCharge.idBCharge','LEFT');
		return $this->db->get('BonsCharge')->result_array();

	}


	public function getDevis(){
		$this->db->select('Devies.NUMDOC,Devies.idDevis,Devies.DATE ddate,DATE_FORMAT(Devies.DATE, "%d/%m/%Y") DATE,FORMAT(Devies.MONTANT+Devies.MONTTVAART,2) total,Devies.CODETIER, Devies.NOMTIER,Devies.ADRESSE,Devies.tel,(CASE Devies.Valide WHEN "0" THEN "Saisi" WHEN "1" THEN "Confirme" WHEN "2" THEN "Valide" END) AS Valide'); 
		$this->db->order_by('Devies.idDevis','DESC');
		return $this->db->get('Devies')->result_array();
	}


	public function getDevi($id){
		$this->db->select('Devies.*,DetailsDevis.DESIGNAT,DetailsDevis.PUHT,DetailsDevis.PTTC,DetailsDevis.QTE,DetailsDevis.REMISE,DetailsDevis.CODETVA,DetailsDevis.CODEART,DetailsDevis.CODEFAM,DetailsDevis.COMMENT');
		$this->db->join('Devies','DetailsDevis.NUMDOC = Devies.idDevis','LEFT');
		//$this->db->join('Produits','Produits.CODEART = DetailsDevis.CODEART','LEFT');
		$this->db->where('DetailsDevis.NUMDOC',$id);
		return $this->db->get('DetailsDevis')->result_array();
		echo $this->db->last_query();
	}

	public function getBonCommande($id){
		$this->db->select('BonsCommande.*,DetailsBonsCommande.DESIGNAT,DetailsBonsCommande.PUHT,DetailsBonsCommande.PTTC,DetailsBonsCommande.QTE,DetailsBonsCommande.REMISE,DetailsBonsCommande.CODETVA,DetailsBonsCommande.CODEART,DetailsBonsCommande.CODEFAM,DetailsBonsCommande.COMMENT');
		$this->db->join('BonsCommande','DetailsBonsCommande.NUMDOC = BonsCommande.idBC','LEFT');
		//$this->db->join('Produits','Produits.CODEART = DetailsDevis.CODEART','LEFT');
		$this->db->where('DetailsBonsCommande.NUMDOC',$id);
		return $this->db->get('DetailsBonsCommande')->result_array();
		echo $this->db->last_query();
	}


	public function getBonSorties(){

		
		$this->db->select('BonSorties.*,(SELECT SUM(DetailsDevis.PUHT) FROM DetailsDevis WHERE DetailsDevis.NUMDOC = BonSorties.NUMDOC) total,(SELECT SUM(DetailsDevis.PTTC) FROM DetailsDevis WHERE DetailsDevis.NUMDOC = BonSorties.NUMDOC) totalttc');
		$this->db->order_by('BonSorties.NUMDOC','DESC');
		$this->db->limit(25);
		return $this->db->get('BonSorties')->result_array();
	}


	public function getBonSortie($id){

		$this->db->join('DetailsDevis','BonSorties.NUMDOC = DetailsDevis.NUMDOC','LEFT');
		$this->db->join('Produits','Produits.CODEART = DetailsDevis.CODEART','LEFT');
		$this->db->where('BonSorties.idBonSortie',$id);
		return $this->db->get('BonSorties')->result_array();

		echo $this->db->last_query();


	}

	



	public function getTVAs(){

		$this->db->where('removed',FALSE);
		return $this->db->get('TVA')->result_array();
		
	}

	public function getUnites(){

		$this->db->where('removed',FALSE);
		return $this->db->get('Unites')->result_array();
		
	}



	public function getDepots(){

		$this->db->select('Depots.*,Pays.name_fr name');
		$this->db->join('Pays','Depots.pays = Pays.id','LEFT');
		$this->db->where('Depots.removed',FALSE);
		return $this->db->get('Depots')->result_array();
		
	}

	public function getDepotById($id){

		$this->db->where('idD',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Depots')->result_array();
		
	}

	public function getDepotByCode($code){

		$this->db->where('codeDepot',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Depots')->result_array();
		
	}




	public function getDimensions(){

		// $this->db->where('NSerie',$serie);
		$this->db->group_by('Dimension');
		return $this->db->get('Produits')->result_array();

	}

	public function getSeries(){

		// $this->db->set('Dimension',$famille);
		$this->db->group_by('NSerie');
		return $this->db->get('Produits')->result_array();

	}

	public function insertProduit($code,$famille){

		$this->db->set('CODEART',$code);
		$this->db->set('DESIGNAT',$famille);
		return $this->db->insert('Produits');
	}
	public function updateProduit($id,$code,$famille){

		$this->db->set('CODEART',$code);
		$this->db->set('DESIGNAT',$famille);
		$this->db->where('idProduit',$id);
		return $this->db->update('Produits');
	}

	public function masquerProduit($id,$activer,$idUser){

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		if($activer){
			$this->db->set('type',30);
		}else{
			$this->db->set('type',28);
		}

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->set('active',$activer);
		$this->db->where('idProduit',$id);
		return $this->db->update('Produits');
	}


	public function removeProduit($id,$idUser){

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',29);

		$this->db->set('json','');
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->set('removed',TRUE);
		$this->db->where('idProduit',$id);

		return $this->db->update('Produits');
	}


	public function getFournisseurs(){


		return $this->db->query("SELECT Fournisseurs.*,FamillesFournisseurs.familleFournisseur,

			GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

			FROM Fournisseurs 
			LEFT JOIN FamillesFournisseurs ON FamillesFournisseurs.idFF = Fournisseurs.idFF




			LEFT JOIN ActivitiesUtilisateur au ON au.id = Fournisseurs.idF AND au.type IN (9,10,22,23,24)
			LEFT JOIN Activities a ON au.type = a.idActivitie
			LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur


			WHERE Fournisseurs.removed = false
			GROUP BY Fournisseurs.idF ORDER BY Fournisseurs.dateCreation DESC")->result_array();
		
	}



	public function getClients(){

		return $this->db->query("SELECT Clients.*,FamillesClients.familleClient, CategoriesClient.categorieClient,CategoriesClient.coleur,Commerciaux.nom,ModesPaiements.modePaiement,Tarifs.tarif,
			GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

			FROM Clients 
			LEFT JOIN FamillesClients ON FamillesClients.idFC = Clients.idFC
			LEFT JOIN CategoriesClient ON CategoriesClient.idCatCli = Clients.idCatCli

			LEFT JOIN Commerciaux ON Commerciaux.idC = Clients.idC
			LEFT JOIN ModesPaiements ON ModesPaiements.idMP = Clients.idMP
			LEFT JOIN Tarifs ON Tarifs.idTarif = Clients.idTarif

			LEFT JOIN ActivitiesUtilisateur au ON au.id = Clients.idCli AND au.type IN (7,8,33,34,35)
			LEFT JOIN Activities a ON au.type = a.idActivitie
			LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur

			WHERE Clients.removed = false
			GROUP BY Clients.idCli ORDER BY Clients.dateCreation DESC")->result_array();
		
	}

	public function getClientsDoc(){

		return $this->db->query("SELECT Clients.*,FamillesClients.familleClient, CategoriesClient.categorieClient,CategoriesClient.coleur,Commerciaux.nom,ModesPaiements.modePaiement,Tarifs.tarif,
			GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

			FROM Clients 
			LEFT JOIN FamillesClients ON FamillesClients.idFC = Clients.idFC
			LEFT JOIN CategoriesClient ON CategoriesClient.idCatCli = Clients.idCatCli

			LEFT JOIN Commerciaux ON Commerciaux.idC = Clients.idC
			LEFT JOIN ModesPaiements ON ModesPaiements.idMP = Clients.idMP
			LEFT JOIN Tarifs ON Tarifs.idTarif = Clients.idTarif

			LEFT JOIN ActivitiesUtilisateur au ON au.id = Clients.idCli AND au.type IN (7,8,33,34,35)
			LEFT JOIN Activities a ON au.type = a.idActivitie
			LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur

			WHERE Clients.removed = false
			GROUP BY Clients.idCli ORDER BY Clients.dateCreation DESC")->result_array();
		
	}

	public function getFournisseursDoc(){

		return $this->db->query("SELECT Fournisseurs.*,FamillesFournisseurs.familleFournisseur

			FROM Fournisseurs 
			LEFT JOIN FamillesFournisseurs ON FamillesFournisseurs.idFF = Fournisseurs.idFF

			WHERE Fournisseurs.removed = false
			GROUP BY Fournisseurs.idF ORDER BY Fournisseurs.dateCreation DESC")->result_array();

	}

	public function getProduits(){

		$produits = $this->db->query("SELECT Unites.unite,Produits.PAHT ,Produits.PVHT ,Produits.idProduit ,Produits.active,Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,FamillesArticles.familleArticle,FamillesArticles.idFA,Produits.CODEART

			FROM Produits 
			LEFT JOIN Marques ON Marques.idM = Produits.idM 

			LEFT JOIN Unites ON Unites.idU = Produits.idU 
			LEFT JOIN FamillesArticles ON FamillesArticles.idFA = Produits.idFA 


			WHERE Produits.removed = false
			GROUP BY Produits.idProduit ORDER BY Produits.dateCreation DESC LIMIT 300")->result_array();



		return $produits;
		
	}

	public function filtrerProduits($term = '',$type_id='Tous'){


		$query = "SELECT Unites.unite,Produits.PAHT ,Produits.PVHT ,Produits.idProduit ,Produits.active,Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,FamillesArticles.familleArticle,FamillesArticles.idFA,Produits.CODEART

			FROM Produits 
			LEFT JOIN Marques ON Marques.idM = Produits.idM 

			LEFT JOIN Unites ON Unites.idU = Produits.idU 
			LEFT JOIN FamillesArticles ON FamillesArticles.idFA = Produits.idFA 

			WHERE Produits.removed = FALSE ";

			if($term != ''){
				$query .= " AND (Produits.DESIGNAT LIKE '%".$term."%' OR Produits.CODEART LIKE '%".$term."%')";
			}
			if($type_id!='Tous'){
				$query .= " AND FamillesArticles.idFA = ".$type_id; 
			}
			$query .= " GROUP BY Produits.idProduit ORDER BY Produits.dateCreation DESC LIMIT 300";

		$results = $this->db->query($query);
		$produits = $results->result_array();
		return $produits;
		
	}
	// public function getProduits(){

	// 	$produits = $this->db->query("SELECT '' img,Unites.unite,Produits.PAHT ,Produits.PVHT ,Produits.idProduit ,Produits.active,Produits.DESIGNAT,Produits.DESIGNAT,IFNULL(Marques.marque,'') marque,FamillesArticles.familleArticle,

	// 		GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete,':',ProprietesArticle.idPropriete SEPARATOR ';') properties, 

	// 		GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte,':',DepotProduit.qteMin ,':',DepotProduit.qteMax  SEPARATOR ';') stock,

	// 		GROUP_CONCAT(DISTINCT(Tarifs.idTarif),':',Tarifs.tarif,':',TarifProduit.prix SEPARATOR ';') tarifs,

	// 		GROUP_CONCAT(DISTINCT(p.idProduit),':',p.DESIGNAT,':',ProduitsNomenclature.qte,':',u.unite,':',p.PAHT SEPARATOR ';') nomenclature,

	// 		GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

	// 		FROM Produits 
	// 		LEFT JOIN Marques ON Marques.idM = Produits.idM 
	// 		LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
	// 		LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
	// 		LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
	// 		LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
	// 		LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot
	// 		LEFT JOIN ProduitsNomenclature ON Produits.idProduit = ProduitsNomenclature.idProduit 
	// 		LEFT JOIN Produits p ON p.idProduit = ProduitsNomenclature.idProduitLiee
	// 		LEFT JOIN Unites u ON u.idU = p.idU 
	// 		LEFT JOIN TarifProduit ON Produits.idProduit = TarifProduit.idProduit 
	// 		LEFT JOIN Tarifs ON Tarifs.idTarif = TarifProduit.idTarif   
	// 		LEFT JOIN Unites ON Unites.idU = Produits.idU 
	// 		LEFT JOIN FamillesArticles ON FamillesArticles.idFA = Produits.idFA 


	// 		LEFT JOIN ActivitiesUtilisateur au ON au.id = Produits.idProduit AND au.type IN (5,6,28,29,30)
	// 		LEFT JOIN Activities a ON au.type = a.idActivitie
	// 		LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur


	// 		WHERE Produits.removed = false
	// 		GROUP BY Produits.idProduit ORDER BY Produits.dateCreation DESC")->result_array();



	// 	return $produits;
		
	// }

	public function getProduitById($id){


		$produits = $this->db->query("SELECT Unites.unite,Produits.*,IFNULL(Marques.marque,'') marque,Produits.PVHT, Produits.DESIGNAT, 

			GROUP_CONCAT(DISTINCT(Proprietes.idPropriete),':',DetailsPropriete.detailPropriete,':',ProprietesArticle.idPropriete SEPARATOR ';') properties, 

			GROUP_CONCAT(DISTINCT(Depots.idD),':',Depots.depot,':',DepotProduit.qte,':',DepotProduit.qteMin ,':',DepotProduit.qteMax,':',DepotProduit.emplacement  SEPARATOR ';') stock,

			GROUP_CONCAT(DISTINCT(Tarifs.idTarif),':',Tarifs.tarif,':',TarifProduit.prix SEPARATOR ';') tarifs,

			GROUP_CONCAT(DISTINCT(p.idProduit),':',p.DESIGNAT,':',ProduitsNomenclature.qte,':',u.unite,':',p.PAHT SEPARATOR ';') nomenclature

			FROM Produits 
			LEFT JOIN Marques ON Marques.idM = Produits.idM 
			LEFT JOIN ProprietesArticle ON Produits.idProduit = ProprietesArticle.idProduit 
			LEFT JOIN DetailsPropriete ON DetailsPropriete.idDProp = ProprietesArticle.idPropriete 
			LEFT JOIN Proprietes ON DetailsPropriete.idPropriete = Proprietes.idPropriete 
			LEFT JOIN DepotProduit ON Produits.idProduit = DepotProduit.idProduit 
			LEFT JOIN Depots ON Depots.idD = DepotProduit.idDepot
			LEFT JOIN ProduitsNomenclature ON Produits.idProduit = ProduitsNomenclature.idProduit 
			LEFT JOIN Produits p ON p.idProduit = ProduitsNomenclature.idProduitLiee
			LEFT JOIN Unites u ON u.idU = p.idU 
			LEFT JOIN TarifProduit ON Produits.idProduit = TarifProduit.idProduit 
			LEFT JOIN Tarifs ON Tarifs.idTarif = TarifProduit.idTarif   
			LEFT JOIN Unites ON Unites.idU = Produits.idU 
			WHERE Produits.idProduit = $id AND Produits.removed = false
			GROUP BY Produits.idProduit ORDER BY Produits.dateCreation DESC")->result_array();


		return $produits;


		
	}

	public function getProduitByCode($code){

		$this->db->where('CODEART',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Produits')->result_array();
		
	}







	public function insertTarif($famille){

		$this->db->set('tarif',$famille);
		return $this->db->insert('Tarifs');
	}
	public function updateTarif($id,$famille){

		$this->db->set('tarif',$famille);
		$this->db->where('idTarif',$id);
		return $this->db->update('Tarifs');
	}

	public function masquerTarif($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idTarif',$id);
		return $this->db->update('Tarifs');
	}


	public function removeTarif($id){

		$this->db->set('removed',TRUE);
		$this->db->where('idTarif',$id);
		return $this->db->update('Tarifs');
	}

	public function getTarifs(){

		$this->db->where('removed',FALSE);
		return $this->db->get('Tarifs')->result_array();
		
	}

	public function getTarifById($id){

		$this->db->where('idTarif',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Tarifs')->result_array();
		
	}



	public function insertFamilleArticles($familles){

		foreach ($familles as $key => $famille) {


			$this->db->set('idCA',1);
			$this->db->set('codeFA',$famille["codeFA"]);
			$this->db->set('familleArticle',$famille["familleArticle"]);
			$this->db->insert('FamillesArticles');

		}

		return true;


	}



	public function insertFamilleArticle($famille){

		$this->db->set('familleArticle',$famille);
		return $this->db->insert('FamillesArticles');
	}
	public function updateFamilleArticle($id,$famille){

		$this->db->set('familleArticle',$famille);
		$this->db->where('idFA',$id);
		return $this->db->update('FamillesArticles');
	}

	public function masquerFamilleArticle($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idFA',$id);
		return $this->db->update('FamillesArticles');
	}


	public function removeFamilleArticle($id){

		$this->db->set('removed',TRUE);
		$this->db->where('idFA',$id);
		return $this->db->update('FamillesArticles');
	}

	public function getFamillesArticles(){

		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesArticles')->result_array();
		
	}

	public function getFamilleArticleById($id){

		$this->db->where('idFA',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesArticles')->result_array();
		
	}

	public function getFamilleArticleByCode($code){

		$this->db->where('codeFA',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesArticles')->result_array();
		
	}








	public function insertFamilleClient($famille){

		$this->db->set('familleClient',$famille);
		return $this->db->insert('FamillesClients');
	}

	public function updateFamilleClient($id,$famille){

		$this->db->set('familleClient',$famille);
		$this->db->where('idFC',$id);
		return $this->db->update('FamillesClients');
	}

	public function masquerFamilleClient($id,$active){

		$this->db->set('active',$active);
		$this->db->where('idFC',$id);
		return $this->db->update('FamillesClients');
	}

	public function getFamillesClients(){

		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesClients')->result_array();
		
	}

	public function removeFamilleClient($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idFC',$id);
		return $this->db->update('FamillesClients');
	}


	public function getFamilleClientById($id){

		$this->db->where('idFC',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesClients')->result_array();
		
	}

	public function getFamilleClientByCode($code){

		$this->db->where('codeFC',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesClients')->result_array();
		
	}




	public function insertFamilleFournisseur($famille){

		$this->db->set('familleFournisseur',$famille);
		return $this->db->insert('FamillesFournisseurs');
	}

	public function updateFamilleFournisseur($id,$famille){

		$this->db->set('familleFournisseur',$famille);
		$this->db->where('idFF',$id);
		return $this->db->update('FamillesFournisseurs');
	}

	public function masquerFamilleFournisseur($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idFF',$id);
		return $this->db->update('FamillesFournisseurs');
	}


	public function removeFamilleFournisseur($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idFF',$id);
		return $this->db->update('FamillesFournisseurs');
	}

	public function getFamillesFournisseurs(){

		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesFournisseurs')->result_array();
		
	}


	public function getFamilleFournisseurById($id){

		$this->db->where('idFF',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesFournisseurs')->result_array();
		
	}

	public function getFamilleFournisseurByCode($code){

		$this->db->where('codeFF',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('FamillesFournisseurs')->result_array();
		
	}





	public function insertModePaiement($modePaiement,$numCompte,$codeJournal){

		$this->db->set('modePaiement',$modePaiement);
		$this->db->set('numCompte',$numCompte);
		$this->db->set('codeJournal',$codeJournal);
		return $this->db->insert('ModesPaiements');
	}

	public function updateModePaiement($id,$modePaiement,$numCompte,$codeJournal){

		$this->db->set('modePaiement',$modePaiement);
		$this->db->set('numCompte',$numCompte);
		$this->db->set('codeJournal',$codeJournal);
		$this->db->where('idMP',$id);
		return $this->db->update('ModesPaiements');
	}

	public function masquerModePaiement($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idMP',$id);
		return $this->db->update('ModesPaiements');
	}


	public function removeModePaiement($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idMP',$id);
		return $this->db->update('ModesPaiements');
	}

	public function getModesPaiements(){

		$this->db->where('removed',FALSE);
		return $this->db->get('ModesPaiements')->result_array();
		
	}


	public function getModePaiementById($id){

		$this->db->where('idMP',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('ModesPaiements')->result_array();
		
	}

	public function getModePaiementByCode($code){

		$this->db->where('codeMP',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('ModesPaiements')->result_array();
		
	}






	public function insertDelaisPaiement($code,$delaisPaiement,$taux){

		$this->db->set('codeDP',$code);
		$this->db->set('delaisPaiement',$delaisPaiement);
		$this->db->set('taux',$taux);
		return $this->db->insert('DelaisPaiements');
	}

	public function updateDelaisPaiement($id,$code,$delaisPaiement,$taux){

		$this->db->set('codeDP',$code);
		$this->db->set('delaisPaiement',$delaisPaiement);
		$this->db->set('taux',$taux);
		$this->db->where('idDP',$id);
		return $this->db->update('DelaisPaiements');
	}

	public function masquerDelaisPaiement($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idDP',$id);
		return $this->db->update('DelaisPaiements');
	}


	public function removeDelaisPaiement($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idDP',$id);
		return $this->db->update('DelaisPaiements');
	}

	public function getDelaisPaiements(){

		$this->db->where('removed',FALSE);
		return $this->db->get('DelaisPaiements')->result_array();
		
	}


	public function getDelaisPaiementById($id){

		$this->db->where('idDP',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('DelaisPaiements')->result_array();
		
	}

	public function getDelaisPaiementByCode($code){

		$this->db->where('codeDP',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('DelaisPaiements')->result_array();
		
	}


	public function insertMarques($marques){

		foreach ($marques as $key => $marque) {
			
			$this->db->set('codeM',$marque["CODEMARQ"]);
			$this->db->set('marque',$marque["MARQUE"]);
			$this->db->insert('Marques');
		}

		return true;

		
	}



	public function insertMarque($marque){

		$this->db->set('marque',$marque);
		return $this->db->insert('Marques');
	}

	public function updateMarque($id,$marque){

		$this->db->set('marque',$marque);
		$this->db->where('idM',$id);
		return $this->db->update('Marques');
	}

	public function masquerMarque($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idM',$id);
		return $this->db->update('Marques');
	}


	public function removeMarque($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idM',$id);
		return $this->db->update('Marques');
	}

	public function getMarques(){

		$this->db->where('removed',FALSE);
		return $this->db->get('Marques')->result_array();
		
	}


	public function getMarqueById($id){

		$this->db->where('idM',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Marques')->result_array();
		
	}

	public function getMarqueByCode($code){

		$this->db->where('codeM',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Marques')->result_array();
		
	}







	public function insertRegion($region){

		$this->db->set('region',$region);

		return $this->db->insert('Regions');
	}

	public function updateRegion($id,$region){


		$this->db->set('region',$region);
		$this->db->where('idR',$id);
		return $this->db->update('Regions');
	}

	public function masquerRegion($id,$activer){

		$this->db->set('active',$activer);
		$this->db->where('idR',$id);
		return $this->db->update('Regions');
	}


	public function removeRegion($id){
		$this->db->set('removed',TRUE);
		$this->db->where('idR',$id);
		return $this->db->update('Regions');
	}

	public function getRegions(){

		$this->db->where('removed',FALSE);
		return $this->db->get('Regions')->result_array();
		
	}


	public function getRegionById($id){

		$this->db->where('idR',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Regions')->result_array();
		
	}

	public function getRegionByCode($code){

		$this->db->where('codeR',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Regions')->result_array();
		
	}




	public function getCommerciaux(){


		return $this->db->query("SELECT Commerciaux.*, 

			GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques
			FROM Commerciaux 

			LEFT JOIN ActivitiesUtilisateur au ON au.id = Commerciaux.idC AND au.type IN (31,32,36,27,26,25)
			LEFT JOIN Activities a ON au.type = a.idActivitie
			LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur

			WHERE Commerciaux.removed = false
			GROUP BY Commerciaux.idC ORDER BY Commerciaux.dateCreation DESC")->result_array();
		
	}


	public function getCommercialById($id){

		$this->db->where('idC',$id);
		$this->db->where('removed',FALSE);
		return $this->db->get('Commerciaux')->result_array();
		
	}

	public function getCommercialByCode($code){

		$this->db->where('codeC',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Commerciaux')->result_array();
		
	}





	public function getFournisseurById($id){

		$this->db->select('Fournisseurs.*,FamillesFournisseurs.familleFournisseur');
		$this->db->join('FamillesFournisseurs','Fournisseurs.idFF = FamillesFournisseurs.idFF','LEFT');
		$this->db->where('idF',$id);
		$this->db->where('Fournisseurs.removed',FALSE);
		return $this->db->get('Fournisseurs')->result_array();
		
	}

	public function getFournisseurByCode($code){

		$this->db->select('Fournisseurs.*,FamillesFournisseurs.familleFournisseur');
		$this->db->join('FamillesFournisseurs','Fournisseurs.idFF = FamillesFournisseurs.idFF','LEFT');
		$this->db->where('codeF',$code);
		$this->db->where('Fournisseurs.removed',FALSE);
		return $this->db->get('Fournisseurs')->result_array();
		
	}


	public function getClient($id){

		$this->db->where('Clients.idCli',$id);
		return $this->db->get('Clients')->result_array();
		
	}




	public function getClientById($id){


		$this->db->select('Clients.*,FamillesClients.familleClient');
		$this->db->join('FamillesClients','FamillesClients.idFC = Clients.idFC','LEFT');
		$this->db->where('Clients.idCli',$id);
		$this->db->where('Clients.removed',FALSE);
		return $this->db->get('Clients')->result_array();
		
	}

	public function getClientByCode($code){

		$this->db->where('codeCli',$code);
		$this->db->where('removed',FALSE);
		return $this->db->get('Clients')->result_array();
		
	}

	public function getParametres(){

		return $this->db->get('Parametres')->result_array();
		
	}

	public function getTotalArticles(){

		return $this->db->get('Produits')->num_rows();
	}

	public function getReptureArticles(){

		$this->db->where('DepotProduit.qte<=0');
		$this->db->join('Produits','Produits.idProduit = DepotProduit.idProduit');
		return $this->db->get('DepotProduit')->num_rows();
	}

	public function getStockBasArticles(){

		$this->db->where('DepotProduit.qteMin<=0');
		$this->db->join('Produits','Produits.idProduit = DepotProduit.idProduit');
		return $this->db->get('DepotProduit')->num_rows();
	}

	public function getCAMonths($annee = '2021'){

		$cam =  $this->db->query("select coalesce(sum(e.MONTANT), 0) as expense,coalesce(sum(e.MONTREGL), 0) as reglee, m.month
			from (select '01' as month union all
			      select '02' as month union all
			      select '03' as month union all
			      select '04' as month union all
			      select '05' as month union all
			      select '06' as month union all
			      select '07' as month union all
			      select '08' as month union all
			      select '09' as month union all
			      select '10' as month union all
			      select '11' as month union all
			      select '12' as month
			     ) m left join
			     Factures e
			     on year(e.DATE) = ".$annee." and
			        DATE_FORMAT(e.DATE,'%m') = m.month
			group by m.month;");

		return $cam->result_array();
    }


    public function TopArticles(){
    	$this->db->select('DESIGNAT libellePrestation,(sum(PTTC)*sum(QTE)) total');
		$this->db->join('BonsLivraison','BonsLivraison.idBL = detailsBonsLivraison.NUMDOC');
		$this->db->group_by('CODEART');
		$this->db->order_by('total','DESC');
		$this->db->limit(12);
		return $this->db->get('detailsBonsLivraison')->result_array();
    }

    public function TopClients(){
    	$this->db->select('Clients.raisonSociale nomClient,Clients.idCli idClient,sum(Factures.MONTANT) total,sum(Factures.MONTREGL) totalR,FamillesClients.familleClient');
		$this->db->join('Clients','Clients.idCli = Factures.CODETIER');
		$this->db->join('FamillesClients','Clients.idFC = FamillesClients.idFC','LEFT');
		$this->db->group_by('Clients.idCli');
		$this->db->order_by('total','DESC');
		$this->db->limit(12);
		return $this->db->get('Factures')->result_array();
    }

   public function commerciaux($ca){

    	$this->db->select('Commerciaux.nom,Commerciaux.objectif,sum(Factures.MONTANT) total,sum(Factures.MONTREGL) totalR,(sum(Factures.MONTANT)/'.$ca.')*100 progress');
		$this->db->join('Clients','Clients.idC = Commerciaux.idC');
		$this->db->join('Factures','Clients.idCli = Factures.CODETIER');
		$this->db->group_by('Commerciaux.idC');
		$this->db->order_by('total','DESC');
		return $this->db->get('Commerciaux')->result_array();
    }
}