<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class CategoriesModel extends CI_Model
{
	function getCategories()
	{

		$this->db->select('CategoriesMobile.*');
		$this->db->where('CategoriesMobile.active',TRUE);
		$this->db->join('Categories','Categories.categorieMobile = CategoriesMobile.idCategorieM');
		$this->db->group_by('CategoriesMobile.idCategorieM');
        $query = $this->db->get('CategoriesMobile');
	  	return $query->result_array();
	}

	function getTypes()
	{
        $query = $this->db->get('TypesPrestation');
	  	return $query->result_array();
	}

	function getPOSCategories()
	{
		$this->db->where('active',TRUE);
		$this->db->where('isDisponible ',TRUE);
		
        $query = $this->db->get('Categories');
	  	return $query->result_array();
	}



	function getCategorie($id)
	{

	  	$this->db->select('`c`.*');
	  	$this->db->where("c.idCategorie",$id);
	  	$this->db->where('c.active',TRUE);
	  	
	  	$query = $this->db->get('Categories c');
	  	return $query->result_array();
	}

	public function getPCategorie($id)
	{
	  	$this->db->where("Prestations.idCategorie",$id);
	  	$this->db->where('Prestations.idTypePrestation != ',3);
        $this->db->where('Prestations.idTypePrestation != ',4);
        $this->db->where('Prestations.idTypePrestation != ',6);
        $this->db->where('Prestations.active',1);
        $this->db->where('Prestations.isDisponible',1);
        $this->db->where('Prestations.isTaille',FALSE);
	  	$query = $this->db->get('Prestations');
	  	return $query->result_array();
	}

	function addCategorie($cat)
	{
	  	$data = array("libelleCategorie"=>$cat);
		return $this->db->insert('Categories',$data);
	}

	// function removeCategorie($id){
	// 	return $this->db->delete('Categories', array('idCategorie' => $id));
	// }

	public function removeCategorie($id){
		//return $this->db->delete('Categories', array('idCategorie' => $id));
		$this->db->set('active',FALSE);
        $this->db->where('idCategorie',$id);
		return $this->db->update('Categories');
	}



	function editCategorie($id,$cat)
	{
	  	$this->db->set("libelleCategorie",$cat);
	  	$this->db->where("idCategorie",$id);
	  	return $this->db->update("Categories");
	}

	function getSCategories($keyword){

        $this->db->where('active',TRUE);
		$this->db->order_by('idCategorie', 'DESC');
	    $this->db->like("libelleCategorie", $keyword, 'both');
	    return $this->db->get('Categories')->result_array();
	}

	function removeFormCategorie($id){
		$this->db->where('CategoriesFormules.idPrestation',$id);
		return $this->db->delete('CategoriesFormules');


	}

	function addFormCategorie($id,$items){

		    $ids = array();
	    	foreach ($items as $item) {
	    	   $this->db->where('idCategorie',$item['item_id']);
	    	   $this->db->where('idPrestation',$id);
			   $q = $this->db->get('CategoriesFormules');
			   if ( $q->num_rows() > 0 ) 
			   {
			      $this->db->set('qte',$item['qte']);
			      $this->db->set('idTaille',$item['taille']);
			      $this->db->where('idPrestation',$id);
			      $this->db->where('idCategorie',$q->row()->idCategorie);
			      $this->db->update('CategoriesFormules');
			   } else {
			        $data = array('idPrestation'=>$id,'idCategorie'=>$item['item_id'],'qte'=>$item['qte'],'idTaille'=>$item['taille']);
		            $this->db->insert('CategoriesFormules',$data);
			   }
			   array_push($ids,$item['item_id']);
	    	}
	       $this->db->where('idPrestation',$id);
    	   $this->db->where_not_in('CategoriesFormules.idCategorie',$ids);
		   $qr = $this->db->get('CategoriesFormules');
		   if ( $qr->num_rows() > 0 ) 
		   {
              foreach ($qr->result() as $combo) {
              	  $this->db->where('idPrestation',$id);
              	   $this->db->where('idCategorie',$combo->idCategorie);
				   $this->db->delete('CategoriesFormules');
              }
		   }
	        return true;
	}

	function getFormuleCategories($id){

        $this->db->select('CategoriesFormules.qte,Categories.idCategorie,Categories.libelleCategorie');
        $this->db->join('Categories','CategoriesFormules.idCategorie = Categories.idCategorie');
        $this->db->join('Tailles','Tailles.idTaille = CategoriesFormules.idTaille','LEFT');
		$this->db->where('CategoriesFormules.idPrestation',$id);
		$this->db->where('Categories.active',TRUE);
		$this->db->order_by('CategoriesFormules.dateCreation', 'DESC');
		return $this->db->get('CategoriesFormules')->result_array();

	}

	public function disponible($id){

    	$this->db->where('idCategorie',$id);
    	$this->db->set('isDisponible',TRUE);
    	return $this->db->update('Categories');

    }

    public function indisponible($id){

    	$this->db->where('idCategorie',$id);
    	$this->db->set('isDisponible',FALSE);
    	return $this->db->update('Categories');

    }

}
?>