<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class ChambresModel extends CI_Model
{



    public function updateChambre($idChambre,$typeChMad ,$etage ,$nomCh ,$rooms){

    	$this->db->trans_start();

		$this->db->trans_strict(TRUE);


		$this->db->set('nomChambre',$nomCh);
		$this->db->set('etage',$etage);
		$this->db->where('idChambres',$idChambre);
		$this->db->update('Chambres');

		$this->db->where('idChambres',$idChambre);
		$this->db->delete('ChambresTypesChambre');

		$this->db->set('idChambres',$idChambre);
		$this->db->set('master',1);
		$this->db->set('idTypeChambres',$typeChMad);
		$this->db->insert('ChambresTypesChambre');
		if($rooms){
			if(count($rooms)>0){
				foreach ($rooms as $key => $room) {

					$this->db->set('idChambres',$idChambre);
					$this->db->set('master',0);
					$this->db->set('idTypeChambres',$room['chambre_res_id']);
					$this->db->insert('ChambresTypesChambre');
					
				}			
			}			
		}






		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
    }


	public function getChannelsTypeChambres($idChannel){
		$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelsTypeChambres.idTypesChambre');
		$this->db->where('channel',$idChannel);
		$this->db->order_by('TypesChambres.idTypeChambres');
		return $this->db->get('ChannelsTypeChambres')->result_array();
	}

	public function getAmenities(){

		return $this->db->get('Amenities')->result_array();
	}

	public function getEtages(){
		$this->db->order_by('etage');
		return $this->db->get('Etages')->result_array();
	}

	public function getTypesChambres(){


		$this->db->where('active',TRUE);
		return $this->db->get('TypesChambres')->result_array();
	}

	public function getTypesRoom(){

		return $this->db->get('TypeRoom')->result_array();
	}


	public function getVues(){

		return $this->db->get('Vues')->result_array();
	}

	public function getTypesLits(){

		return $this->db->get('TypesLits')->result_array();
	}

	public function getTypeChambre($idChambre){

		$this->db->where('TypesChambres.idTypeChambres',$idChambre);
		$this->db->limit(1);
		$resTC = $this->db->get('TypesChambres');

		if($resTC->num_rows()>0){

			return $resTC->row();

		}else{
			return null;
		}

	}
	public function insert($tChambre,$nom,$capacite,$description,$surface,$adults,$enfants){

		$this->db->set('idTypeRoom',$tChambre);
		$this->db->set('nomTypeChambres',$nom);
		$this->db->set('capacite',$capacite);
		$this->db->set('description',$description);
		$this->db->set('surface',$surface);
		$this->db->set('adults',$adults);
		$this->db->set('enfants',$enfants);
		$this->db->insert('TypesChambres');
		$idlast = $this->db->insert_id();
		return $idlast;
	
	}

	public function update($idch,$tChambre,$nom,$capacite,$description,$surface,$adults,$enfants){

		
		$this->db->set('idTypeRoom',$tChambre);
		$this->db->set('nomTypeChambres',$nom);
		$this->db->set('capacite',$capacite);
		$this->db->set('description',$description);
		$this->db->set('surface',$surface);
		$this->db->set('adults',$adults);
		$this->db->set('enfants',$enfants);
		$this->db->where('idTypeChambres',$idch);
		return $this->db->update('TypesChambres');

	}


	public function insertHR($nom,$description,$adults=0,$codeChambre,$invCode,$capacite=0,$dispo,$restruction,$prix,$code){

		$this->db->where('invCode',$invCode);
		$this->db->limit(1);
		$resChambre = $this->db->get('TypesChambres');
		if($resChambre->num_rows()>0){
			$idTypeChambres = $resChambre->row()->idTypeChambres;
			$this->db->set('tarif',$nom);
			$this->db->set('availabilityUpdate',$dispo);
			$this->db->set('restrictionsUpdate',$restruction);
			$this->db->set('priceUpdate',$prix);
			$this->db->set('codeTarif',$code);

			if($this->db->insert('Tarifs')){
				$idTarif = $this->db->insert_id();
			}
		}else{
			$this->db->set('codeChambre',$codeChambre);
			$this->db->set('invCode',$invCode);
			$this->db->set('nomTypeChambres',$nom);
			$this->db->set('description',$description);
			$this->db->set('adults',$adults);	
			$this->db->set('capacite',$capacite);
			if($this->db->insert('TypesChambres')){
				$idTypeChambres = $this->db->insert_id();
				$this->db->set('tarif',$nom);
				$this->db->set('availabilityUpdate',$dispo);
				$this->db->set('restrictionsUpdate',$restruction);
				$this->db->set('priceUpdate',$prix);
				$this->db->set('codeTarif',$code);		
				if($this->db->insert('Tarifs')){
					$idTarif = $this->db->insert_id();
				}
			}
			return $idTypeChambres;

		}

	}



	public function createRooms($nom,$capacite,$idTypeRoom){

		for ($i=0; $i < $capacite; $i++) { 
			$this->db->set('nomChambre',$nom.'  '.$i);
			$this->db->set('idTypesChambre',$idTypeRoom);
			$this->db->insert('Chambres');
		}

	}

	public function servicesRoom($services,$idTypeRoom){

		$this->db->where('idTypesChambre',$idTypeRoom);
		if($this->db->delete('ChambreAmenities')){

			foreach ($services as $key => $service) {
				$this->db->set('idAmenity',$service);
				$this->db->set('idTypesChambre',$idTypeRoom);
				$this->db->insert('ChambreAmenities');
			}

		}

	}


	public function imagesRoom($url,$idTypeRoom,$thumbnail){

		$this->db->set('url',$url);
		$this->db->set('thumbnail',$thumbnail);
		$this->db->set('idTypesChambre',$idTypeRoom);
		return $this->db->insert('ChambreImages');
	}

	public function TypeBedsRoom($idTypeLit,$idTypeRoom,$qte){

		$this->db->set('idTypeLit',$idTypeLit);
		$this->db->set('qte',$qte);
		$this->db->set('idTypeChambres',$idTypeRoom);
		return $this->db->insert('ChambreTypesLits');
	}

	public function VuesRoom($idVue,$idTypeRoom){

		$this->db->set('idVue',$idVue);
		$this->db->set('idTypesChambre',$idTypeRoom);
		return $this->db->insert('TypesChambresVues');
	}

	public function getImagesRoom($idTypeRoom){

		$this->db->where('idTypesChambre',$idTypeRoom);
		return $this->db->get('ChambreImages')->result_array();

	}

	public function getVuesRoom($idTypeRoom){

		$this->db->where('idTypesChambre',$idTypeRoom);
		return $this->db->get('TypesChambresVues')->result_array();

	}

	public function getServicesRoom($idTypeRoom){

		$this->db->where('idTypesChambre',$idTypeRoom);
		return $this->db->get('ChambreAmenities')->result_array();

	}

	public function getLitsRoom($idTypeRoom){

		$this->db->where('idTypeChambres',$idTypeRoom);
		return $this->db->get('ChambreTypesLits')->result_array();

	}

	public function getChambre($idChambre){

		$this->db->where('idChambres',$idChambre);
		$chambre = $this->db->get('Chambres')->result_array();

		if(count($chambre)>0){
			$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChambresTypesChambre.idTypeChambres');
			$this->db->where('idChambres',$idChambre);
			$this->db->order_by('master','DESC');
			$chs = $this->db->get('ChambresTypesChambre')->result_array();

			$chambre[0]['chs'] = $chs;

		}

		return $chambre;

	}

	public function getChambres(){

		return $this->db->get('Chambres')->result_array();

	}

	public function getChambresTypeChambreDates($Checkin,$Checkout){



		$this->db->select("Chambres.*,ChambresReservations.providerId,ChambresReservations.dateDu checkin,ChambresReservations.dateAu checkout");
		//$this->db->join('ChambresTypesChambre','ChambresTypesChambre.idChambres = Chambres.idChambres and ChambresTypesChambre.master = 1');

		$this->db->join('ChambresReservations',"ChambresReservations.idChambres = Chambres.idChambres AND isNoshow = 0 AND isCanceled = 0 AND ((ChambresReservations.dateDu > '".$Checkin."' AND ChambresReservations.dateDu < '".$Checkout."' )  OR  (ChambresReservations.dateDu < '".$Checkin."' AND ChambresReservations.dateAu >= '".$Checkin."')) ",'left');



		//$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChambresTypesChambre.idTypeChambres');	
		$this->db->group_by('Chambres.idChambres');
		$this->db->order_by('Chambres.etage','ASC');

		return $this->db->get('Chambres')->result_array();
		   $str = $this->db->last_query();

   

		    echo "<pre>";

		    print_r($str);

		    exit;

	}

	public function getChambresTypeChambre(){

		$this->db->select('Chambres.*,TypesChambres.nomTypeChambres,TypesChambres.idTypeChambres');
		$this->db->join('ChambresTypesChambre','ChambresTypesChambre.idChambres = Chambres.idChambres and ChambresTypesChambre.master = 1');
		$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChambresTypesChambre.idTypeChambres');	
		$this->db->order_by('TypesChambres.idTypeChambres','ASC');
		return $this->db->get('Chambres')->result_array();

	}

	// public function insertHRChambreTarif($insert_data) {


	//     $sql = $this->db->insert_string('ChannelTarifs', $insert_data) . ' ON DUPLICATE KEY UPDATE name=name';
	// 	return $this->db->query($sql);
	// }

	public function insertHRChambreTarif($insert_data){

		return $this->db->insert_on_duplicate_update_batch('ChannelTarifs',$insert_data);
	}

	public function getChambreHR(){

		$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelsTypeChambres.idTypesChambre');

		$this->db->where('TypesChambres.active',true);

		return $this->db->get('ChannelsTypeChambres')->result_array();

	}


	// public function getChambreHR($id){



	// 	return 
	// }

}