<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class ClientsModel extends CI_Model
{

    public function getClient($idClient = 0){

            $this->db->where("BonsLivraison.CODETIER",$idClient);
            $this->db->where("BonsLivraison.fact!=",1);
            $this->db->where("BonsLivraison.MONTREGL",0);
            $bls = $this->db->get("BonsLivraison")->result_array();
            foreach ($bls as $key => $bl) {
                $this->db->where("detailsBonsLivraison.NUMDOC",$bl['idBL']);
                $bls[$key]['details'] = $this->db->get("detailsBonsLivraison")->result_array();
            }

            $this->db->where("Avoirs.CODETIER",$idClient);
            $avoirs = $this->db->get("Avoirs")->result_array();
            foreach ($avoirs as $key => $avoir) {
                $this->db->where("DetailsAvoir.NUMDOC",$avoir['idAvoir']);
                $avoirs[$key]['details'] = $this->db->get("DetailsAvoir")->result_array();
            }

            $this->db->where("Factures.CODETIER",$idClient);
            $this->db->where("Factures.MONTREGL",0);
            $factures = $this->db->get("Factures")->result_array();
            foreach ($factures as $key => $facture) {
                $this->db->where("DetailsSortie.NUMDOC",$facture['idFacture']);
                $factures[$key]['details'] = $this->db->get("DetailsSortie")->result_array();
            }

            $client = $this->db->query("SELECT Clients.idCli,Clients.raisonSociale,Clients.tel1,Clients.tel2 ,CategoriesClient.categorieClient,Clients.adresse,Clients.idFiscal,Clients.RC,Clients.ICE,Clients.dateCreation,FamillesClients.familleClient, ModesPaiements.modePaiement, DelaisPaiements.delaisPaiement, 


                GROUP_CONCAT(DISTINCT(au.idAU),'$',au.dateCreation,'$',a.operation,'$',ua.nomUtilisateur,'$' SEPARATOR 'º') historiques

            FROM Clients 

            LEFT JOIN FamillesClients ON FamillesClients.idFC = Clients.idFC 
            LEFT JOIN CategoriesClient ON CategoriesClient.idCatCli = Clients.idCatCli 
            LEFT JOIN ModesPaiements ON ModesPaiements.idMP = Clients.idMP
            LEFT JOIN DelaisPaiements ON DelaisPaiements.idDP = Clients.idDP
            LEFT JOIN Tarifs ON Tarifs.idTarif = Clients.idTarif
            LEFT JOIN ActivitiesUtilisateur au ON au.id = Clients.idCli AND au.type IN (7,8,33,34,35,51)
            LEFT JOIN Activities a ON au.type = a.idActivitie
            LEFT JOIN Utilisateurs ua ON au.idUtilisateur = ua.idUtilisateur 

            WHERE Clients.idCli = ".$idClient." GROUP BY Clients.idCli ORDER BY Clients.dateCreation DESC");

            if($client->num_rows()>0){

                return array('client' => $client->row(),'bls'=>$bls,'avoirs'=>$avoirs,'factures'=>$factures );

            }else{
                return null;
            }
    }


    public function getClients(){
        return $this->db->query("SELECT Clients.idCli,Clients.raisonSociale,FamillesClients.familleClient, CategoriesClient.categorieClient,CategoriesClient.coleur,SUM((f.MONTANT+f.MONTTVAART)-(f.TAUXREM/100)) MONTANT,SUM(f.MONTREGL) MONTREGL

            FROM Clients 
            LEFT JOIN FamillesClients ON FamillesClients.idFC = Clients.idFC
            LEFT JOIN CategoriesClient ON CategoriesClient.idCatCli = Clients.idCatCli
            LEFT JOIN Factures f ON f.CODETIER = Clients.idCli

            WHERE Clients.removed = false
            GROUP BY Clients.idCli ORDER BY Clients.dateCreation DESC")->result_array();
    }

    public function insertClientEXL($clients){

        foreach ($clients as $client) {

            try{


                //$url = $image;
                /* Extract the filename */
                //$filename = substr($url, strrpos($url, '/') + 1);
                /* Save file wherever you want */
                //file_put_contents('assets/uploads/'.$filename, file_get_contents($url));

                //$data = base64_encode(file_get_contents($url));

                // $data = "data:image/jpeg;base64,".base64_encode(file_get_contents($url));

                $json = json_encode(array('code'=>$client['CODEART'],'DESIGNAT'=>$client['DESIGNAT'],'EANCode'=>$client['EANCode']));


                $data = "data:image/jpeg;base64,".base64_encode(file_get_contents('./assets/img/placeholder.png'));

                $this->db->where('CODEART',$client['CODEART']);
                $q = $this->db->get('Produits');
                if($q->num_rows() == 0){

                    $this->db->trans_start(); 

                    $this->db->trans_strict(TRUE); 


                    $this->db->set('CODEART',$client['CODEART']);

                    $this->db->set('DESIGNAT',$client['DESIGNAT']);

                    $this->db->set('idFA',1);

                    $this->db->set('idTA',1);

                    $this->db->set('idM',4);

                    $this->db->set('EANCode',$client['EANCode']);

                    // $this->db->set('Poids',$taille);  

                    // $this->db->set('Observat',$desc); 

                    $this->db->set('img',$data);  

                    $this->db->insert('Produits');

                    $id = $this->db->insert_id();

                    $this->db->where('active',TRUE);

                    $this->db->where('removed',FALSE);

                    $tarifs = $this->db->get('Tarifs')->result_array();


                    if (count($tarifs)>0) {

                        foreach ($tarifs as $key => $tarif) {

                            $this->db->set('idTarif',$tarif['idTarif']);    
                            $this->db->set('idProduit',$id);    
                            $this->db->set('prix',0); 
                            $this->db->insert('TarifProduit');

                        }           
                        
                    }

                    $this->db->where('active',TRUE);

                    $this->db->where('removed',FALSE);

                    $depots = $this->db->get('Depots')->result_array();

                    if (count($depots)>0) {

                        foreach ($depots as $key => $depot) {

                            $this->db->set('idDepot',$depot['idD']);    
                            $this->db->set('idProduit',$id);    
                            $this->db->set('qte',0);    
                            $this->db->set('qteInv',0); 
                            $this->db->set('qteInt',0); 
                            $this->db->set('qteMin',1); 
                            $this->db->set('qteMax',99999);
                            $this->db->insert('DepotProduit');

                        }   
                        
                    }





                    $this->db->set('idUtilisateur',1);

                    $this->db->set('id',$id);

                    $this->db->set('idDocu','');

                    $this->db->set('type',5);

                    $this->db->set('json',$json);
                    
                    $this->db->insert('ActivitiesUtilisateur');

                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE) {
                        $this->db->trans_rollback();
                       // return array("status"=>FALSE);
                    }else {
                        $this->db->trans_commit();
                       // return array("status"=>TRUE,"id"=>$id);
                    }           

                }else{
                    //return array("status"=>TRUE,"id"=>$q->row()->idProduit);
                }
            }catch(Exception $ex){


                $this->db->trans_rollback();
                //return array("status"=>FALSE,"message"=>$ex->getMessage());
            }

            

        }


    }


}
?>