<?php 

defined('BASEPATH') OR exit('No direct script access allowed');

class FacturesModel extends CI_Model
{

	public function getReglements($dateCaisse='',$dateCaisse1=''){

		$this->db->select('DATE_FORMAT(Reglements.date, "%d/%m/%Y") date, Reglements.idReglement, Clients.raisonSociale, ModesPaiements.modePaiement, Reglements.montant');

		$this->db->join('ModesPaiements','ModesPaiements.idMP = Reglements.idMP');
		$this->db->join('Clients','Clients.idCli = Reglements.idClient');

		$this->db->order_by('Reglements.idReglement','DESC');
		return $this->db->get('Reglements')->result_array();
	}

	public function getReglementDetails($id){

		$this->db->select('DATE_FORMAT(Reglements.date, "%d/%m/%Y") date, Reglements.idReglement, Clients.raisonSociale, ModesPaiements.modePaiement,Reglements.numeroReglement, Reglements.montant,Reglements.idReglement,Reglements.dateCreation,Reglements.idClient'); 

		$this->db->join('ModesPaiements','ModesPaiements.idMP = Reglements.idMP');
		$this->db->join('Clients','Clients.idCli = Reglements.idClient');

		$this->db->where('idReglement',$id);
		$query = $this->db->get('Reglements');
		if($query->num_rows()>0){


			$this->db->select('IFNULL(Factures.idFacture,BonsLivraison.idBL) id,IFNULL(Factures.NUMDOC,BonsLivraison.NUMDOC) NUMDOC, detailsReglement.idReglement,  detailsReglement.typeDocument,IFNULL(Factures.dateCreation,BonsLivraison.dateCreation) dateCreation,IFNULL(Factures.montant,BonsLivraison.montant) montant'); 

			$this->db->where('idReglement',$query->row()->idReglement);

			$this->db->join('Factures','Factures.idFacture = detailsReglement.idFacture AND detailsReglement.typeDocument = 0','LEFT');
			$this->db->join('BonsLivraison','BonsLivraison.idBL = detailsReglement.idFacture AND detailsReglement.typeDocument = 2','LEFT');

			$documents = $this->db->get('detailsReglement');

			$documents_d = array();
			if ($documents->num_rows()>0) {
				
				foreach ($documents->result() as $key => $document) {

					array_push($documents_d,array('id'=>$document->id,'num'=>$document->NUMDOC,'typeDocument'=>$document->typeDocument,'montant'=>$document->montant,"dateCreation"=>$document->dateCreation));

				}
			}

			return array("id"=>$query->row()->idReglement,'num'=>$query->row()->numeroReglement,"idClient"=>$query->row()->idClient ,"montant"=>$query->row()->montant,"client"=>$query->row()->raisonSociale,"dateCreation"=>$query->row()->dateCreation,"documents"=>$documents_d,"historiques"=>[]);


		}else{
			return null;
		}

	}

	public function getReglementsF($dateCaisse='',$dateCaisse1=''){

		$this->db->join('ModesPaiements','ModesPaiements.idMP = Reglements.idMP');
		$this->db->join('Clients','Clients.idCli = Reglements.idClient');

		$this->db->order_by('Reglements.idReglement','DESC');
		return $this->db->get('Reglements')->result_array();
	}


	public function insertActivity($idUser,$id,$idDocu,$type,$json){

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$idDocu);

		$this->db->set('type',$type);

		$this->db->set('json',$json);
		
		return $this->db->insert('ActivitiesUtilisateur');


	}

	public function getFacturesClient($idClient,$regle = false){

		$this->db->select('"Facture" type,"1" idType,Factures.NUMDOC,Factures.idFacture,Factures.DATE ddate,DATE_FORMAT(Factures.DATE, "%d/%m/%Y") DATE,FORMAT(Factures.MONTANT+Factures.MONTTVAART,2) total,Factures.CODETIER,FORMAT(Factures.MONTREGL,2) MONTREGL, Factures.NOMTIER,Factures.ADRESSE,Factures.tel,BLRecuAnnul Valide,Factures.dateCreation'); 
		$this->db->where('FORMAT(Factures.MONTREGL,2) != FORMAT(Factures.MONTANT+Factures.MONTTVAART,2)');
		$this->db->where('Factures.CODETIER',$idClient);
		$this->db->order_by('Factures.idFacture','DESC');
		return $this->db->get('Factures')->result_array();


	}



	public function getAvoirsClient($idClient,$regle = false){

		$this->db->select('Avoirs.NUMDOC,Avoirs.idAvoir,Avoirs.DATE ddate,DATE_FORMAT(Avoirs.DATE, "%d/%m/%Y") DATE,FORMAT(Avoirs.MONTANT,2) total,Avoirs.CODETIER,FORMAT(Avoirs.MONTREGL,2) MONTREGL, Avoirs.NOMTIER,Avoirs.ADRESSE, Avoirs.tel,Avoirs.dateCreation'); 
		$this->db->where('FORMAT(Avoirs.MONTANT,2) != FORMAT(Avoirs.MONTREGL,2)');
		$this->db->where('Avoirs.CODETIER',$idClient);
		$this->db->order_by('Avoirs.idAvoir','DESC');
		return $this->db->get('Avoirs')->result_array();


	}

	public function getBonsLivraisonClient($idClient,$regle = false){

		$this->db->select('"Bon Livraison" type,"2" idType,BonsLivraison.NUMDOC,BonsLivraison.idBL,BonsLivraison.DATE ddate,DATE_FORMAT(BonsLivraison.DATE, "%d/%m/%Y") DATE,FORMAT(BonsLivraison.MONTANT+BonsLivraison.MONTTVAART,2) total,BonsLivraison.CODETIER,FORMAT(BonsLivraison.MONTREGL,2) MONTREGL, BonsLivraison.NOMTIER,BonsLivraison.ADRESSE,BonsLivraison.tel,BonsLivraison.dateCreation'); 
		$this->db->where('FORMAT(BonsLivraison.MONTREGL,2) != FORMAT(BonsLivraison.MONTANT+BonsLivraison.MONTTVAART,2)');
		$this->db->where('BonsLivraison.fact !=',1);
		$this->db->where('BonsLivraison.CODETIER',$idClient);
		$this->db->order_by('BonsLivraison.idBL','DESC');
		return $this->db->get('BonsLivraison')->result_array();


	}

	public function getBonCommande($id){

		$this->db->select('BonsCommande.*,DetailsBonsCommande.DESIGNAT,DetailsBonsCommande.PUHT,DetailsBonsCommande.PTTC,DetailsBonsCommande.QTE,DetailsBonsCommande.REMISE,DetailsBonsCommande.CODETVA,DetailsBonsCommande.CODEART,DetailsBonsCommande.CODEFAM,DetailsBonsCommande.COMMENT');
		$this->db->join('BonsCommande','DetailsBonsCommande.NUMDOC = BonsCommande.idBC','LEFT');
		//$this->db->join('Produits','Produits.CODEART = DetailsDevis.CODEART','LEFT');
		$this->db->where('DetailsBonsCommande.NUMDOC',$id);
		return $this->db->get('DetailsBonsCommande')->result_array();

	}



	public function getFactureDetails($id){

		$this->db->select('Factures.MONTREGL,Factures.MONTTVAART,Factures.dateCreation,Factures.NUMDOC,Factures.idFacture,Factures.DATE ddate,DATE_FORMAT(Factures.DATE, "%d/%m/%Y") DATE,FORMAT(Factures.MONTANT+Factures.MONTTVAART,2) total,FORMAT(Factures.MONTANT,2) totalht,Factures.CODETIER, Factures.NOMTIER,Factures.ADRESSE,Factures.tel'); 

		$this->db->where('idFacture',$id);
		$query = $this->db->get('Factures');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idFacture);
			$details = $this->db->get('DetailsSortie');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDetailSortie,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}
			$historiques_d = array();
			$where_in  = array(21);
			$idDocu = false;
			$this->db->select('ActivitiesUtilisateur.idDocO,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

					$idDocu = $historique->idDocO;

					$where_in  = array(12);
					$this->db->select('ActivitiesUtilisateur.idDocO,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocu',$idDocu);
					$historiques_o = $this->db->get('ActivitiesUtilisateur');

					if ($historiques_o->num_rows()>0) {

						foreach ($historiques_o->result() as $key => $historique_o) {

							$idDocu = $historique_o->idDocO;

							$where_in  = array(11,3);
							$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
							$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
							$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
							$this->db->where_in('type',$where_in);
							$this->db->where('idDocu',$idDocu);
							$historiques_v_o = $this->db->get('ActivitiesUtilisateur');

							if ($historiques_v_o->num_rows()>0) {

								foreach ($historiques_v_o->result() as $key => $historique_v_o) {

									array_push($historiques_d,array('num'=>$historique_v_o->idDocu,'utilisateur'=>$historique_v_o->nomUtilisateur,'activity'=>$historique_v_o->activity,'operation'=>$historique_v_o->operation,'date'=>$historique_v_o->dateCreation));

								}
							}


							array_push($historiques_d,array('num'=>$historique_o->idDocO,'utilisateur'=>$historique_o->nomUtilisateur,'activity'=>$historique_o->activity,'operation'=>$historique_o->operation,'date'=>$historique_o->dateCreation));


						}
					}

					$where_in  = array(1);
					$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocu',$idDocu);
					$historiques_o = $this->db->get('ActivitiesUtilisateur');

					if ($historiques_o->num_rows()>0) {

						foreach ($historiques_o->result() as $key => $historique_o) {



							array_push($historiques_d,array('num'=>$historique_o->idDocu,'utilisateur'=>$historique_o->nomUtilisateur,'activity'=>$historique_o->activity,'operation'=>$historique_o->operation,'date'=>$historique_o->dateCreation));


						}
					}
					array_push($historiques_d,array('num'=>$historique->idDocO,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}

			}

			$where_in  = array(18,45,47);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {
					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}
			

			// return array("id"=>$query->row()->idFacture,"num"=>$query->row()->NUMDOC,"montantRegle"=>$query->row()->MONTREGL ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->MONTANT ,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"date"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

			return array("id"=>$query->row()->idFacture,"num"=>$query->row()->NUMDOC ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"montantRegle"=>$query->row()->MONTREGL,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

		}else{
			return null;
		}

	}
	public function getFactureFournisseurDetails($id){

		$this->db->select('FacturesF.MONTREGL,FacturesF.MONTTVAART,FacturesF.dateCreation,FacturesF.NUMDOC,FacturesF.idFactureF,FacturesF.DATE ddate,DATE_FORMAT(FacturesF.DATE, "%d/%m/%Y") DATE,FORMAT(FacturesF.MONTANT+FacturesF.MONTTVAART,2) total,FORMAT(FacturesF.MONTANT,2) totalht,FacturesF.CODETIER, FacturesF.NOMTIER,FacturesF.ADRESSE,FacturesF.tel'); 

		$this->db->where('idFactureF',$id);
		$query = $this->db->get('FacturesF');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idFactureF);
			$details = $this->db->get('DetailsEntree');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDE,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}
			$historiques_d = array();
			$where_in  = array(21);
			$idDocu = false;
			$this->db->select('ActivitiesUtilisateur.idDocO,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

					$idDocu = $historique->idDocO;

					$where_in  = array(12);
					$this->db->select('ActivitiesUtilisateur.idDocO,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocu',$idDocu);
					$historiques_o = $this->db->get('ActivitiesUtilisateur');

					if ($historiques_o->num_rows()>0) {

						foreach ($historiques_o->result() as $key => $historique_o) {

							$idDocu = $historique_o->idDocO;

							$where_in  = array(11,3);
							$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
							$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
							$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
							$this->db->where_in('type',$where_in);
							$this->db->where('idDocu',$idDocu);
							$historiques_v_o = $this->db->get('ActivitiesUtilisateur');

							if ($historiques_v_o->num_rows()>0) {

								foreach ($historiques_v_o->result() as $key => $historique_v_o) {

									array_push($historiques_d,array('num'=>$historique_v_o->idDocu,'utilisateur'=>$historique_v_o->nomUtilisateur,'activity'=>$historique_v_o->activity,'operation'=>$historique_v_o->operation,'date'=>$historique_v_o->dateCreation));

								}
							}


							array_push($historiques_d,array('num'=>$historique_o->idDocO,'utilisateur'=>$historique_o->nomUtilisateur,'activity'=>$historique_o->activity,'operation'=>$historique_o->operation,'date'=>$historique_o->dateCreation));


						}
					}

					$where_in  = array(1);
					$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocu',$idDocu);
					$historiques_o = $this->db->get('ActivitiesUtilisateur');

					if ($historiques_o->num_rows()>0) {

						foreach ($historiques_o->result() as $key => $historique_o) {



							array_push($historiques_d,array('num'=>$historique_o->idDocu,'utilisateur'=>$historique_o->nomUtilisateur,'activity'=>$historique_o->activity,'operation'=>$historique_o->operation,'date'=>$historique_o->dateCreation));


						}
					}
					array_push($historiques_d,array('num'=>$historique->idDocO,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}

			}

			$where_in  = array(18,45,47);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {
					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}
			

			// return array("id"=>$query->row()->idFacture,"num"=>$query->row()->NUMDOC,"montantRegle"=>$query->row()->MONTREGL ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->MONTANT ,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"date"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

			return array("id"=>$query->row()->idFactureF,"num"=>$query->row()->NUMDOC ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"montantRegle"=>$query->row()->MONTREGL,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

		}else{
			return null;
		}

	}

	public function getBonReceptionDetails($id){

		$this->db->select('BonsReception.MONTREGL,BonsReception.MONTTVAART,BonsReception.dateCreation,BonsReception.NUMDOC,BonsReception.idBR,BonsReception.DATE ddate,DATE_FORMAT(BonsReception.DATE, "%d/%m/%Y") DATE,FORMAT(BonsReception.MONTANT+BonsReception.MONTTVAART,2) total,FORMAT(BonsReception.MONTANT,2) totalht,BonsReception.CODETIER, BonsReception.NOMTIER,BonsReception.ADRESSE,BonsReception.tel, BonsReception.fact'); 

		$this->db->where('idBR',$id);
		$query = $this->db->get('BonsReception');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idBR);
			$details = $this->db->get('DetailsBonsReception');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDBR,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}

			$where_in  = array(12);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			$historiques_d = array();
			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

							$where_in  = array(3);
							$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
							$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
							$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
							$this->db->where_in('type',$where_in);
							$this->db->where('idDocu',$historiques->row()->idDocO);
							$historiques_v_o = $this->db->get('ActivitiesUtilisateur');


							if ($historiques_v_o->num_rows()>0) {

								foreach ($historiques_v_o->result() as $key => $historique_v_o) {

									array_push($historiques_d,array('num'=>$historique_v_o->idDocu,'utilisateur'=>$historique_v_o->nomUtilisateur,'activity'=>$historique_v_o->activity,'operation'=>$historique_v_o->operation,'date'=>$historique_v_o->dateCreation));

								}
							}

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}



			$where_in  = array(16,17,18,43);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				
				foreach ($historiques->result() as $key => $historique) {

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}

			$where_in  = array(21);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocO',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {
					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}



			return array("id"=>$query->row()->idBR,"num"=>$query->row()->NUMDOC,"etat"=>$query->row()->fact ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"montantRegle"=>$query->row()->MONTREGL,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

		}else{
			return null;
		}

	}

	public function getFactureFournisseur($id){

		$this->db->select('FacturesF.*,DetailsEntree.DESIGNAT,DetailsEntree.PUHT,DetailsEntree.PTTC,DetailsEntree.QTE,DetailsEntree.REMISE,DetailsEntree.CODETVA,DetailsEntree.CODEART,DetailsEntree.CODEFAM,DetailsEntree.COMMENT');

		$this->db->join('FacturesF','DetailsEntree.NUMDOC = FacturesF.idFactureF','LEFT');
		$this->db->where('DetailsEntree.NUMDOC',$id);
		return $this->db->get('DetailsEntree')->result_array();


	}

	public function updateBonLivraison($bonLivraison,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($bonLivraison);

		$id = $bonLiv->id;

		$this->db->select('detailsBonsLivraison.*,BonsLivraison.CodeDepot');

		$this->db->join('BonsLivraison','BonsLivraison.idBL = detailsBonsLivraison.NUMDOC');

		$this->db->where('detailsBonsLivraison.NUMDOC',$id);

		$dbons = $this->db->get('detailsBonsLivraison');

		foreach ($dbons->result() as $key => $dbon) {


			$this->db->set('qte','qte+'.$dbon->QTE,FALSE);

			$this->db->where('idProduit',$dbon->CODEART);

			$this->db->where('idDepot',$dbon->CodeDepot);

			$this->db->update('DepotProduit');

			$this->db->where('idDBL',$dbon->idDBL);

			$this->db->delete('detailsBonsLivraison');			

		}

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('Nexpedition',(isset($bonLiv->nExpediteur)) ? $bonLiv->nExpediteur : ''); 

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		$this->db->set('Exp',(isset($bonLiv->expediteur)) ? $bonLiv->expediteur : ''); 

		$this->db->set('chauff',(isset($bonLiv->chauffeur)) ? $bonLiv->chauffeur : ''); 

		$this->db->set('superv',(isset($bonLiv->superviseur)) ? $bonLiv->superviseur : ''); 

		$this->db->set('prepa',(isset($bonLiv->preperateur)) ? $bonLiv->preperateur : ''); 

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicule',(isset($bonLiv->vehicule)) ? $bonLiv->vehicule : ''); 

		$this->db->set('observations',$bonLiv->observations);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');

		$totht = 0;

		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {

			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('qte','qte-'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('detailsBonsLivraison');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));
		
		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');

		$this->db->where('idBL',$id);

		$bonsLivraison = $this->db->get('BonsLivraison')->result_array();

		if(count($bonsLivraison)>0){

			foreach ($bonsLivraison as $key => $document) {

				if($document['fact']==1){

					$this->db->select('DetailsSortie.*,Factures.CodeDepot');

					$this->db->join('Factures','Factures.idFacture = DetailsSortie.NUMDOC');

					$this->db->where('DetailsSortie.NUMDOC',$document['NUMFACT']);

					$dbons = $this->db->get('DetailsSortie');

					foreach ($dbons->result() as $key => $dbon) {

						$this->db->where('idDetailSortie',$dbon->idDetailSortie);

						$this->db->delete('DetailsSortie');			

					}

					$totht = 0;
					$totttc = 0;

					foreach ($bonLiv->articles as $key => $article) {

						$total = $article->prixHT * $article->qte;

						$totht += $total-($total*($article->remise/100));

						$total = $article->prixTTC * $article->qte;

						$totttc += $total-($total*($article->remise/100));


						$this->db->set('NUMDOC',$document['NUMFACT']);

						$this->db->set('CODEART',$article->id);

						$this->db->set('PUHT',$article->prixHT);

						$this->db->set('PTTC',$article->prixTTC);

						$this->db->set('QTE',$article->qte);

						$this->db->set('REMISE',$article->remise);

						$this->db->set('CODETVA',$article->tva);

						$this->db->set('CODETIER',$bonLiv->idClient);

						$this->db->set('DATE',$bonLiv->date);

						$this->db->set('DESIGNAT',$article->label);

						$this->db->set('CODEFAM',$article->famille);

						$this->db->set('COMMENT',$article->commentaire);

						$this->db->insert('DetailsSortie');

					}

					$totht = $totht-($totht*($bonLiv->Remise/100));
					
					$totttc = $totttc-($totttc*($bonLiv->Remise/100));

					$this->db->set('MONTANT',$totht);

					$this->db->set('MONTTVAART',$totttc-$totht);

					$this->db->where('idFacture',$document['NUMFACT']);

					$this->db->update('Factures');

				}
			}
		}


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$bonLiv->numDoc);

		$this->db->set('type',2);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function insertBonReception($bonRece,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($bonRece);

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFLIV_F.$parametre->row()->NUMLIVR_F.$parametre->row()->SUFFLIV_F);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		// $this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		// $this->db->set('Exp',$bonLiv->expediteur);

		// $this->db->set('chauff',$bonLiv->chauffeur);

		// $this->db->set('superv',$bonLiv->superviseur);  

		// $this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		// $this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('BonsReception');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('qte','qte+'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsReception');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBR',$id);

		$this->db->update('BonsReception');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFLIV_F.$parametre->row()->NUMLIVR_F.$parametre->row()->SUFFLIV_F);

		$this->db->set('type',16);

		$this->db->set('json',$bonRece);

		$this->db->insert('ActivitiesUtilisateur');

		$NUMLIVR_F = $parametre->row()->NUMLIVR_F+1;

		$size = strlen($parametre->row()->NUMLIVR_F);

		$NUMLIVR_F = str_pad($NUMLIVR_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMLIVR_F',$NUMLIVR_F);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $id;
		}


	}

	public function validerBonCommande($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$dd = json_decode($json);

		$codeDepot = '';

		$depotId = 0;

		$this->db->where('principal',TRUE);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;$depotId = $depot->row()->idD;}


		$this->db->select('BonsCommande.*,DetailsBonsCommande.DESIGNAT,DetailsBonsCommande.PUHT,DetailsBonsCommande.PTTC,DetailsBonsCommande.QTE,DetailsBonsCommande.REMISE,DetailsBonsCommande.CODETVA,DetailsBonsCommande.CODEART,DetailsBonsCommande.CODEFAM,DetailsBonsCommande.COMMENT');

		$this->db->join('BonsCommande','DetailsBonsCommande.NUMDOC = BonsCommande.idBC');

		$this->db->where('DetailsBonsCommande.NUMDOC',$dd->id);

		$Devies = $this->db->get('DetailsBonsCommande');

		if ($Devies->num_rows()>0) {

			$articles = array();
			foreach ($Devies->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$devis = json_encode(array('numDoc'=>$detail->NUMDOC,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->ModePaie,'Remise'=>$detail->TAUXREM,'preperateur'=>'','superviseur'=>'','vehicule'=>'','chauffeur'=>'','expediteur'=>'','nExpediteur'=>'','depot'=>$depotId,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($devis);

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$numDoc = $parametre->row()->PREFLIV_F.$parametre->row()->NUMLIVR_F.$parametre->row()->SUFFLIV_F;

		$this->db->set('NUMDOC',$numDoc);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('fact',3);

		// $this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		// $this->db->set('Exp',$bonLiv->expediteur);

		// $this->db->set('chauff',$bonLiv->chauffeur);

		// $this->db->set('superv',$bonLiv->superviseur);  

		// $this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		// $this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('BonsReception');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('qte','qte+'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsReception');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBR',$id);

		$this->db->update('BonsReception');

		$this->db->set('valide',1);

		$this->db->set('BR',$id);

		$this->db->where('idBC',$dd->id);

		$this->db->update('BonsCommande');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numDoc);

		$this->db->set('type',15);

		$this->db->set('json',$devis);

		$this->db->insert('ActivitiesUtilisateur');

		$NUMLIVR_F = $parametre->row()->NUMLIVR_F+1;

		$size = strlen($parametre->row()->NUMLIVR_F);

		$NUMLIVR_F = str_pad($NUMLIVR_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMLIVR_F',$NUMLIVR_F);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $numDoc;
		}
	}



	public function getBonLivraisonDetails($id){

		$this->db->select('BonsLivraison.MONTREGL,BonsLivraison.MONTTVAART,BonsLivraison.dateCreation,BonsLivraison.NUMDOC,BonsLivraison.idBL,BonsLivraison.DATE ddate,DATE_FORMAT(BonsLivraison.DATE, "%d/%m/%Y") DATE,FORMAT(BonsLivraison.MONTANT+BonsLivraison.MONTTVAART,2) total,FORMAT(BonsLivraison.MONTANT,2) totalht,BonsLivraison.CODETIER, BonsLivraison.NOMTIER,BonsLivraison.ADRESSE,BonsLivraison.tel, BonsLivraison.fact'); 

		$this->db->where('idBL',$id);
		$query = $this->db->get('BonsLivraison');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idBL);
			$details = $this->db->get('detailsBonsLivraison');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDBL,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}

			$where_in  = array(12);
			$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.idDocO,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			$historiques_d = array();
			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

							$where_in  = array(11,3);
							$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
							$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
							$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
							$this->db->where_in('type',$where_in);
							$this->db->where('idDocu',$historiques->row()->idDocO);
							$historiques_v_o = $this->db->get('ActivitiesUtilisateur');


							if ($historiques_v_o->num_rows()>0) {

								foreach ($historiques_v_o->result() as $key => $historique_v_o) {

									array_push($historiques_d,array('num'=>$historique_v_o->idDocu,'utilisateur'=>$historique_v_o->nomUtilisateur,'activity'=>$historique_v_o->activity,'operation'=>$historique_v_o->operation,'date'=>$historique_v_o->dateCreation));

								}
							}

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}



			$where_in  = array(1,2,18,42);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				
				foreach ($historiques->result() as $key => $historique) {

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}

			$where_in  = array(21);
			$this->db->select('ActivitiesUtilisateur.idDocu,Utilisateurs.nomUtilisateur,Activities.activity,Activities.operation,ActivitiesUtilisateur.dateCreation');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocO',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {
					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}



			return array("id"=>$query->row()->idBL,"num"=>$query->row()->NUMDOC,"etat"=>$query->row()->fact ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"montantRegle"=>$query->row()->MONTREGL,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);

		}else{
			return null;
		}

	}

	public function getBonsCommandeDetails($id){

		$this->db->select('BonsCommande.MONTTVAART,BonsCommande.dateCreation,BonsCommande.NUMDOC,BonsCommande.idBC,BonsCommande.DATE ddate,DATE_FORMAT(BonsCommande.DATE, "%d/%m/%Y") DATE,FORMAT(BonsCommande.MONTANT+BonsCommande.MONTTVAART,2) total,FORMAT(BonsCommande.MONTANT,2) totalht,BonsCommande.CODETIER, BonsCommande.NOMTIER,BonsCommande.ADRESSE,BonsCommande.tel,BonsCommande.Valide'); 

		$this->db->where('idBC',$id);
		$query = $this->db->get('BonsCommande');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idBC);
			$details = $this->db->get('DetailsBonsCommande');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDBC,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}
			$where_in  = array(3,4,11,44);
			$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			$historiques_d = array();
			if ($historiques->num_rows()>0) {

				
				foreach ($historiques->result() as $key => $historique) {

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}
			$where_in  = array(12);
			$idDocu = false;
			$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocO',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

					$idDocu = $historique->idDocu;

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

					$where_in  = array(21);
					$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocO',$idDocu);
					$historiques = $this->db->get('ActivitiesUtilisateur');

					if ($historiques->num_rows()>0) {

						foreach ($historiques->result() as $key => $historique) {
							array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

						}

					}

				}

			}

			return array("id"=>$query->row()->idBC,"num"=>$query->row()->NUMDOC,"etat"=>$query->row()->Valide ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);



		}else{
			return null;
		}

	}


	public function getDevisDetails($id){

		$this->db->select('Devies.MONTTVAART,Devies.dateCreation,Devies.NUMDOC,Devies.idDevis,Devies.DATE ddate,DATE_FORMAT(Devies.DATE, "%d/%m/%Y") DATE,FORMAT(Devies.MONTANT+Devies.MONTTVAART,2) total,FORMAT(Devies.MONTANT,2) totalht,Devies.CODETIER, Devies.NOMTIER,Devies.ADRESSE,Devies.tel,Devies.Valide'); 

		$this->db->where('idDevis',$id);
		$query = $this->db->get('Devies');
		if($query->num_rows()>0){

			$this->db->where('NUMDOC',$query->row()->idDevis);
			$details = $this->db->get('DetailsDevis');

			$details_d = array();
			if ($details->num_rows()>0) {
				
				foreach ($details->result() as $key => $detail) {

					array_push($details_d,array('id'=>$detail->idDetailDevis,'idArticle'=>$detail->CODEART,'designation'=>$detail->DESIGNAT,"prixHT"=>$detail->PUHT ,"prixTTC"=>$detail->PTTC ,"qte"=>$detail->QTE ,"remise"=>$detail->REMISE,'commentaire'=>$detail->COMMENT,'date'=>$detail->dateCreation));

				}
			}
			$where_in  = array(3,4,11,44);
			$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocu',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			$historiques_d = array();
			if ($historiques->num_rows()>0) {

				
				foreach ($historiques->result() as $key => $historique) {

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

				}
			}
			$where_in  = array(12);
			$idDocu = false;
			$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
			$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
			$this->db->where_in('type',$where_in);
			$this->db->where('idDocO',$query->row()->NUMDOC);
			$historiques = $this->db->get('ActivitiesUtilisateur');

			if ($historiques->num_rows()>0) {

				foreach ($historiques->result() as $key => $historique) {

					$idDocu = $historique->idDocu;

					array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

					$where_in  = array(21);
					$this->db->select('ActivitiesUtilisateur.idDocu,ActivitiesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur,Activities.operation,Activities.activity');
					$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitiesUtilisateur.idUtilisateur');
					$this->db->join('Activities','Activities.idActivitie = ActivitiesUtilisateur.type');
					$this->db->where_in('type',$where_in);
					$this->db->where('idDocO',$idDocu);
					$historiques = $this->db->get('ActivitiesUtilisateur');

					if ($historiques->num_rows()>0) {

						foreach ($historiques->result() as $key => $historique) {
							array_push($historiques_d,array('num'=>$historique->idDocu,'utilisateur'=>$historique->nomUtilisateur,'activity'=>$historique->activity,'operation'=>$historique->operation,'date'=>$historique->dateCreation));

						}

					}

				}

			}

			return array("id"=>$query->row()->idDevis,"num"=>$query->row()->NUMDOC,"etat"=>$query->row()->Valide ,"idClient"=>$query->row()->CODETIER ,"montant"=>$query->row()->total,"montantht"=>$query->row()->totalht ,"tva"=>$query->row()->MONTTVAART ,"client"=>$query->row()->NOMTIER ,"adresse"=>$query->row()->ADRESSE ,"tel"=>$query->row()->tel,"dateCreation"=>$query->row()->dateCreation,"details"=>$details_d,"historiques"=>$historiques_d);



		}else{
			return null;
		}

	}


	public function insertAvoir($avoirV,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$avoir = json_decode($avoirV);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		//$this->db->where('idD',$avoir->depot);

		//$this->db->limit(1);

		//$depot = $this->db->get('Depots');

		//if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}

		$this->db->set('NUMDOC',$parametre->row()->PREFAV_C.$parametre->row()->NUMAV_C.$parametre->row()->SUFFAV_C);

		$this->db->set('DATE',$avoir->date);

		$this->db->set('CODETIER',$avoir->idClient);

		$this->db->set('MONTANT',$avoir->total);

		$this->db->set('TAUXREM',0);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('MONTREGL',0.00);

		$this->db->set('NOMTIER',$avoir->nom);

		$this->db->set('ADRESSE',$avoir->adresse);

		$this->db->set('tel',$avoir->tel);

		//$this->db->set('BC',$bonLiv->bonCommande);

		//$this->db->set('Nexpedition',(isset($bonLiv->nExpediteur)) ? $bonLiv->nExpediteur : ''); 

		//$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		// $this->db->set('Exp',(isset($bonLiv->expediteur)) ? $bonLiv->expediteur : ''); 

		// $this->db->set('chauff',(isset($bonLiv->chauffeur)) ? $bonLiv->chauffeur : ''); 

		// $this->db->set('superv',(isset($bonLiv->superviseur)) ? $bonLiv->superviseur : ''); 

		// $this->db->set('prepa',(isset($bonLiv->preperateur)) ? $bonLiv->preperateur : ''); 

		// $this->db->set('CodeDepot',$bonLiv->depot);

		// $this->db->set('vehicule',(isset($bonLiv->vehicule)) ? $bonLiv->vehicule : ''); 

		$this->db->set('observations',$avoir->observations);

		$this->db->insert('Avoirs');

		$id = $this->db->insert_id();

		// foreach ($avoir->factures as $key => $facture) {



		// 	$this->db->set('qte','qte-'.$article->qte,FALSE);

		// 	$this->db->where('idProduit',$article->id);

		// 	$this->db->where('idDepot',$bonLiv->depot);

		// 	$this->db->update('DepotProduit');

		// 	$this->db->set('NUMDOC',$id);

		// 	$this->db->set('CODEART',$article->id);

		// 	$this->db->set('PUHT',$article->prixHT);

		// 	$this->db->set('PTTC',$article->prixTTC);

		// 	$this->db->set('QTE',$article->qte);

		// 	$this->db->set('REMISE',$article->remise);

		// 	$this->db->set('CODETVA',$article->tva);

		// 	$this->db->set('CODETIER',$bonLiv->idClient);

		// 	$this->db->set('DATE',$bonLiv->date);

		// 	$this->db->set('DESIGNAT',$article->label);

		// 	$this->db->set('CODEFAM',$article->famille);

		// 	$this->db->set('COMMENT',$article->commentaire);

		// 	$this->db->insert('detailsBonsLivraison');

		// }

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFAV_C.$parametre->row()->NUMAV_C.$parametre->row()->SUFFAV_C);

		$this->db->set('type',37);

		$this->db->set('json',$avoirV);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMAV_C = $parametre->row()->NUMAV_C+1;

		$size = strlen($parametre->row()->NUMAV_C);

		$NUMAV_C = str_pad($NUMAV_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMAV_C',$NUMAV_C);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}



	public function insertBonLivraison($bonLivraison,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($bonLivraison);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->where('idD',$bonLiv->depot);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}

		$this->db->set('NUMDOC',$parametre->row()->PREFLIV_C.$parametre->row()->NUMLIVR_C.$parametre->row()->SUFFLIV_C.$codeDepot);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('Nexpedition',(isset($bonLiv->nExpediteur)) ? $bonLiv->nExpediteur : ''); 

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		$this->db->set('Exp',(isset($bonLiv->expediteur)) ? $bonLiv->expediteur : ''); 

		$this->db->set('chauff',(isset($bonLiv->chauffeur)) ? $bonLiv->chauffeur : ''); 

		$this->db->set('superv',(isset($bonLiv->superviseur)) ? $bonLiv->superviseur : ''); 

		$this->db->set('prepa',(isset($bonLiv->preperateur)) ? $bonLiv->preperateur : ''); 

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicule',(isset($bonLiv->vehicule)) ? $bonLiv->vehicule : ''); 

		$this->db->set('observations',$bonLiv->observations);

		$this->db->insert('BonsLivraison');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));


			$this->db->set('qte','qte-'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('detailsBonsLivraison');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFLIV_C.$parametre->row()->NUMLIVR_C.$parametre->row()->SUFFLIV_C.$codeDepot);

		$this->db->set('type',1);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMLIVR_C = $parametre->row()->NUMLIVR_C+1;

		$size = strlen($parametre->row()->NUMLIVR_C);

		$NUMLIVR_C = str_pad($NUMLIVR_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMLIVR_C',$NUMLIVR_C);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function reglerFactureFournisseur($reglement,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$regl = json_decode($reglement);

		$this->db->set('idClient',$regl->idClient);

		$this->db->set('montant',$regl->montant);

		$this->db->set('idMP',$regl->modePaie);

		$this->db->set('date',$regl->date);

		$this->db->insert('Reglements');

		$id = $this->db->insert_id();

		$total = $regl->montant;

		foreach ($regl->factures as $key => $facture) {

			$this->db->where('idFactureF',$facture->id);

			$fact = $this->db->get('FacturesF');

			$this->db->set('typeDocument',4); 

			$this->db->set('idReglement',$id); 	

			$this->db->set('idFacture',$facture->id); 

			$this->db->set('solde',$regl->montant); 

			$this->db->set('montant',$regl->montant);	

			$this->db->set('montantRegl',$regl->montant);

			$this->db->insert('detailsReglement');

			$this->db->set('MONTREGL','MONTREGL+'.$regl->montant,FALSE);

			$this->db->where('idFactureF',$facture->id);

			$this->db->update('FacturesF');	


			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$facture->num);

			$this->db->set('type',18);

			$this->db->set('json',json_encode($reglement));
			
			$this->db->insert('ActivitiesUtilisateur');


		}

	
		foreach ($regl->datesEcheance as $key => $dateEcheance) {
			
			$this->db->set('idReglement',$id); 	

			$this->db->set('dateE',$dateEcheance->date); 

			$this->db->set('idBanque',$dateEcheance->banque); 

			$this->db->set('numeroCheque',$dateEcheance->nCheque); 

			$this->db->set('montant',$dateEcheance->montant);  

			$this->db->set('impaie',0); 

			$this->db->set('idClient',$regl->idClient); 

			$this->db->insert('DatesEcheance');

		}


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',18);

		$this->db->set('json',$reglement);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function reglerFacture($reglement,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$regl = json_decode($reglement);

		$this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$numeroDocument = $parametre->row()->PREFRG.$parametre->row()->NUMRG.$parametre->row()->SUFFRG;

		$this->db->set('numeroReglement',$numeroDocument);

		$this->db->set('idClient',$regl->idClient);

		$this->db->set('montant',$regl->montant);

		$this->db->set('idMP',$regl->modePaie);

		$this->db->set('date',$regl->date);

		$this->db->insert('Reglements');

		$id = $this->db->insert_id();

		$total = $regl->montant;

		foreach ($regl->factures as $key => $facture) {

			$this->db->where('idFacture',$facture->id);

			$fact = $this->db->get('Factures');

			$this->db->set('idReglement',$id); 	

			$this->db->set('idFacture',$facture->id); 

			$this->db->set('solde',$regl->montant); 

			$this->db->set('montant',$regl->montant);	

			$this->db->set('montantRegl',$regl->montant);

			$this->db->insert('detailsReglement');


			$this->db->set('MONTREGL','MONTREGL+'.$regl->montant,FALSE);

			$this->db->where('idFacture',$facture->id);

			$this->db->update('Factures');	


			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$facture->num);

			$this->db->set('type',18);

			$this->db->set('json',json_encode($reglement));
			
			$this->db->insert('ActivitiesUtilisateur');


		}

	
		foreach ($regl->datesEcheance as $key => $dateEcheance) {
			
			$this->db->set('idReglement',$id); 	

			$this->db->set('dateE',$dateEcheance->date); 

			$this->db->set('idBanque',$dateEcheance->banque); 

			$this->db->set('numeroCheque',$dateEcheance->nCheque); 

			$this->db->set('montant',$dateEcheance->montant);  

			$this->db->set('impaie',0); 

			$this->db->set('idClient',$regl->idClient); 

			$this->db->insert('DatesEcheance');

		}

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numeroDocument);

		$this->db->set('type',18);

		$this->db->set('json',$reglement);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMRG = $parametre->row()->NUMRG+1;

		$size = strlen($parametre->row()->NUMRG);

		$NUMRG = str_pad($NUMRG, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMRG',$NUMRG);

		if(!$this->db->update('Parametres')){
		    $message = $this->db->error()['message'];
			$this->db->trans_rollback();
			return array('result'=>false,'code'=>'009','message'=>$message);
		}



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function reglerFactures($reglement,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$regl = json_decode($reglement);

		$this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$numeroDocument = $parametre->row()->PREFRG.$parametre->row()->NUMRG.$parametre->row()->SUFFRG;

		$this->db->set('numeroReglement',$numeroDocument);

		$this->db->set('idClient',$regl->idClient);

		$this->db->set('montant',$regl->montant);

		$this->db->set('idMP',$regl->modePaie);

		$this->db->set('date',$regl->date);

		$this->db->insert('Reglements');

		$id = $this->db->insert_id();

		$total = $regl->montant;

		foreach ($regl->factures as $key => $facture) {

			if($facture->type == 1){
				$this->db->where('idFacture',$facture->id);

				$fact = $this->db->get('Factures');

				$this->db->set('idReglement',$id); 	

				$this->db->set('idFacture',$facture->id); 

				$this->db->set('solde',$facture->total); 

				$this->db->set('montant',$facture->total);	

				$this->db->set('montantRegl',$facture->total);

				$this->db->insert('detailsReglement');

				$this->db->set('MONTREGL','MONTREGL+'.$facture->total,FALSE);

				$this->db->where('idFacture',$facture->id);

				$this->db->update('Factures');	

			}else{

				$this->db->where('idBL',$facture->id);

				$fact = $this->db->get('BonsLivraison');

				$this->db->set('idReglement',$id); 	

				$this->db->set('idFacture',$facture->id); 

				$this->db->set('typeDocument',2);	

				$this->db->set('solde',$facture->total); 

				$this->db->set('montant',$facture->total);	

				$this->db->set('montantRegl',$facture->total);

				$this->db->insert('detailsReglement');

				$this->db->set('fact',2);

				$this->db->set('MONTREGL','MONTREGL+'.$facture->total,FALSE);

				$this->db->where('idBL',$facture->id);

				$this->db->update('BonsLivraison');	

			}
			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$facture->num);

			$this->db->set('type',18);

			$this->db->set('json',json_encode($reglement));
			
			$this->db->insert('ActivitiesUtilisateur');


		}

	
		foreach ($regl->datesEcheance as $key => $dateEcheance) {
			
			$this->db->set('idReglement',$id); 	

			$this->db->set('dateE',$dateEcheance->date); 

			$this->db->set('idBanque',$dateEcheance->banque); 

			$this->db->set('numeroCheque',$dateEcheance->nCheque); 

			$this->db->set('montant',$dateEcheance->montant);  

			$this->db->set('impaie',0); 

			$this->db->set('idClient',$regl->idClient); 

			$this->db->insert('DatesEcheance');

		}


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numeroDocument);

		$this->db->set('type',18);

		$this->db->set('json',$reglement);
		
		$this->db->insert('ActivitiesUtilisateur');


		$NUMRG = $parametre->row()->NUMRG+1;

		$size = strlen($parametre->row()->NUMRG);

		$NUMRG = str_pad($NUMRG, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMRG',$NUMRG);

		if(!$this->db->update('Parametres')){
		    $message = $this->db->error()['message'];
			$this->db->trans_rollback();
			return array('result'=>false,'code'=>'009','message'=>$message);
		}



		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function facturerBonReception($idBR,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->select('BonsReception.*,DetailsBonsReception.DESIGNAT,DetailsBonsReception.PUHT,DetailsBonsReception.PTTC,DetailsBonsReception.QTE,DetailsBonsReception.REMISE,DetailsBonsReception.CODETVA,DetailsBonsReception.CODEART,DetailsBonsReception.CODEFAM,DetailsBonsReception.COMMENT');

		$this->db->join('BonsReception','DetailsBonsReception.NUMDOC = BonsReception.idBR');

		$this->db->where('DetailsBonsReception.NUMDOC',$idBR);

		$BonsLivraison = $this->db->get('DetailsBonsReception');

		if ($BonsLivraison->num_rows()>0) {

			$articles = array();
			foreach ($BonsLivraison->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$bonLivraison = json_encode(array('numDoc'=>$detail->NUMDOC,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->Contre,'depot'=>$detail->CodeDepot,'Remise'=>$detail->TAUXREM,'preperateur'=>$detail->prepa,'superviseur'=>$detail->superv,'vehicule'=>$detail->vehicul,'chauffeur'=>$detail->chauff,'expediteur'=>$detail->Exp,'nExpediteur'=>$detail->Nexpedition,'MONTREGL'=>$detail->MONTREGL,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($bonLivraison);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->where('idD',$bonLiv->depot);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}

		$numDoc = $parametre->row()->PREFFACT_F.$parametre->row()->NUMFACT_F.$parametre->row()->SUFFFACT_F.$codeDepot;

		$this->db->set('NUMDOC',$numDoc);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('MONTREGL',$bonLiv->MONTREGL);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',($bonLiv->bonCommande)?$bonLiv->bonCommande:0);

		$this->db->set('BR',$idBR);

		$this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		$this->db->set('Exp',$bonLiv->expediteur);

		$this->db->set('chauff',$bonLiv->chauffeur);

		$this->db->set('superv',$bonLiv->superviseur);  

		$this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('FacturesF');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsEntree');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idFactureF',$id);

		$this->db->update('FacturesF');


		$this->db->set('fact',1);

		$this->db->set('NUMFACT',$id);

		$this->db->where('idBR',$idBR);

		$this->db->update('BonsReception');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$bonLiv->numDoc);

		$this->db->set('type',3);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numDoc);

		$this->db->set('type',4);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMFACT_F = $parametre->row()->NUMFACT_F+1;

		$size = strlen($parametre->row()->NUMFACT_F);

		$NUMFACT_F = str_pad($NUMFACT_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMFACT_F',$NUMFACT_F);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $numDoc;
		}

	}


	public function reglerBonReception($reglement,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$regl = json_decode($reglement);

		$this->db->set('idClient',$regl->idClient);

		$this->db->set('montant',$regl->montant);

		$this->db->set('idMP',$regl->modePaie);

		$this->db->set('date',$regl->date);

		$this->db->insert('Reglements');

		$id = $this->db->insert_id();

		$total = $regl->montant;

		foreach ($regl->factures as $key => $facture) {


			$this->db->where('idBR',$facture->id);

			$fact = $this->db->get('BonsReception');

			if($fact->num_rows()==0){		    
				$this->db->trans_rollback();
			    return FALSE;
			}

			$total = $fact->row()->MONTANT + $fact->row()->MONTTVAART;

			$solde = ($total-$regl->montant);

		
			// $fact->TAUXREM


			$this->db->set('typeDocument',3); 

			$this->db->set('idReglement',$id); 	

			$this->db->set('idFacture',$facture->id); 

			$this->db->set('solde',$solde); 

			$this->db->set('montant',$total);	

			$this->db->set('montantRegl',$regl->montant);

			$this->db->insert('detailsReglement');


			$this->db->set('fact',2);

			$this->db->set('MONTREGL','MONTREGL+'.$regl->montant,FALSE);

			$this->db->where('idBR',$facture->id);

			$this->db->update('BonsReception');	


			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$facture->num);

			$this->db->set('type',18);

			$this->db->set('json',json_encode($reglement));
			
			$this->db->insert('ActivitiesUtilisateur');


		}

	
		foreach ($regl->datesEcheance as $key => $dateEcheance) {
			
			$this->db->set('idReglement',$id); 	

			$this->db->set('dateE',$dateEcheance->date); 

			$this->db->set('idBanque',$dateEcheance->banque); 

			$this->db->set('numeroCheque',$dateEcheance->nCheque); 

			$this->db->set('montant',$dateEcheance->montant);  

			$this->db->set('impaie',0); 

			$this->db->set('idClient',$regl->idClient); 

			$this->db->insert('DatesEcheance');

		}


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',18);

		$this->db->set('json',$reglement);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function reglerBonLivraison($reglement,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$regl = json_decode($reglement);


		$this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$numeroDocument = $parametre->row()->PREFRG.$parametre->row()->NUMRG.$parametre->row()->SUFFRG;

		$this->db->set('numeroReglement',$numeroDocument);

		$this->db->set('idClient',$regl->idClient);

		$this->db->set('montant',$regl->montant);

		$this->db->set('idMP',$regl->modePaie);

		$this->db->set('date',$regl->date);

		$this->db->insert('Reglements');

		$id = $this->db->insert_id();

		$total = $regl->montant;

		foreach ($regl->factures as $key => $facture) {


			$this->db->where('idBL',$facture->id);

			$fact = $this->db->get('BonsLivraison');

			if($fact->num_rows()==0){		    
				$this->db->trans_rollback();
			    return FALSE;
			}

			$total = $fact->row()->MONTANT + $fact->row()->MONTTVAART;

			$solde = ($total-$regl->montant);

		
			// $fact->TAUXREM


			$this->db->set('typeDocument',2); 

			$this->db->set('idReglement',$id); 	

			$this->db->set('idFacture',$facture->id); 

			$this->db->set('solde',$solde); 

			$this->db->set('montant',$total);	

			$this->db->set('montantRegl',$regl->montant);

			$this->db->insert('detailsReglement');


			$this->db->set('fact',2);

			$this->db->set('MONTREGL','MONTREGL+'.$regl->montant,FALSE);

			$this->db->where('idBL',$facture->id);

			$this->db->update('BonsLivraison');	


			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$facture->num);

			$this->db->set('type',18);

			$this->db->set('json',json_encode($reglement));
			
			$this->db->insert('ActivitiesUtilisateur');


		}

	
		foreach ($regl->datesEcheance as $key => $dateEcheance) {
			
			$this->db->set('idReglement',$id); 	

			$this->db->set('dateE',$dateEcheance->date); 

			$this->db->set('idBanque',$dateEcheance->banque); 

			$this->db->set('numeroCheque',$dateEcheance->nCheque); 

			$this->db->set('montant',$dateEcheance->montant);  

			$this->db->set('impaie',0); 

			$this->db->set('idClient',$regl->idClient); 

			$this->db->insert('DatesEcheance');

		}


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numeroDocument);

		$this->db->set('type',18);

		$this->db->set('json',$reglement);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMRG = $parametre->row()->NUMRG+1;

		$size = strlen($parametre->row()->NUMRG);

		$NUMRG = str_pad($NUMRG, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMRG',$NUMRG);

		if(!$this->db->update('Parametres')){
		    $message = $this->db->error()['message'];
			$this->db->trans_rollback();
			return array('result'=>false,'code'=>'009','message'=>$message);
		}

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}
	
	public function validerDevis($json,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$dd = json_decode($json);

		$codeDepot = '';

		$depotId = 0;

		$this->db->where('principal',TRUE);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;$depotId = $depot->row()->idD;}

		$this->db->select('Devies.*,DetailsDevis.DESIGNAT,DetailsDevis.PUHT,DetailsDevis.PTTC,DetailsDevis.QTE,DetailsDevis.REMISE,DetailsDevis.CODETVA,DetailsDevis.CODEART,DetailsDevis.CODEFAM,DetailsDevis.COMMENT');

		$this->db->join('Devies','DetailsDevis.NUMDOC = Devies.idDevis');

		$this->db->where('DetailsDevis.NUMDOC',$dd->id);

		$Devies = $this->db->get('DetailsDevis');

		if ($Devies->num_rows()>0) {

			$articles = array();
			foreach ($Devies->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$devis = json_encode(array('numDoc'=>$detail->NUMDOC,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->ModePaie,'Remise'=>$detail->TAUXREM,'preperateur'=>'','superviseur'=>'','vehicule'=>'','chauffeur'=>'','expediteur'=>'','nExpediteur'=>'','depot'=>$depotId,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($devis);

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$numDoc = $parametre->row()->PREFLIV_C.$parametre->row()->NUMLIVR_C.$parametre->row()->SUFFLIV_C;

		$this->db->set('NUMDOC',$numDoc);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('fact',3);  

		$this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',$bonLiv->contre); 

		$this->db->set('Exp',$bonLiv->expediteur);

		$this->db->set('chauff',$bonLiv->chauffeur);

		$this->db->set('superv',$bonLiv->superviseur);  

		$this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('BonsLivraison');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('qte','qte-'.$article->qte,FALSE);

			$this->db->where('idProduit',$article->id);

			$this->db->where('idDepot',$bonLiv->depot);

			$this->db->update('DepotProduit');

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('detailsBonsLivraison');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBL',$id);

		$this->db->update('BonsLivraison');

		$this->db->set('valide',2);

		$this->db->set('BL',$id);

		$this->db->where('idDevis',$dd->id);

		$this->db->update('Devies');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$numDoc);

		$this->db->set('type',12);

		$this->db->set('idDocO',$bonLiv->numDoc);

		$this->db->set('json',$devis);

		$this->db->insert('ActivitiesUtilisateur');

		$NUMLIVR_C = $parametre->row()->NUMLIVR_C+1;

		$size = strlen($parametre->row()->NUMLIVR_C);

		$NUMLIVR_C = str_pad($NUMLIVR_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMLIVR_C',$NUMLIVR_C);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $numDoc;
		}
	}


	public function confirmerDevis($devis,$idUser){


    	$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$devi = json_decode($devis);

		$id = $devi->id;

		$this->db->set('valide',$devi->valide);

		$this->db->where('idDevis',$id);

		$this->db->update('Devies');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$devi->numDoc);

		$this->db->set('type',11);

		$this->db->set('json',$devis);
		
		$this->db->insert('ActivitiesUtilisateur');


    	$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

    }


    public function annulerFacture($id,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 


		$this->db->set('fact',0);

		$this->db->where('NUMFACT',$id);

		$this->db->update('BonsLivraison');


		$this->db->where('MONTREGL',0);

		$this->db->set('isAnnuler',true);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');


		$this->db->where('typeDocument',2);

		$this->db->where('idFacture',$id);

		$detailsReglement = $this->db->get('detailsReglement');

		if(count($detailsReglement)>0){

			foreach ($detailsReglement as $key => $detailsReglement) {

				$this->db->where('MONTREGL',0);

				$this->db->where('idReglement',$detailsReglement['idReglement']);

				$this->db->delete('Reglements');
				
			}
		}

		$BonsLivraison = $this->db->get('BonsLivraison');

		if ($BonsLivraison->num_rows()>0) {

			$articles = array();
			foreach ($BonsLivraison->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$bonLivraison = json_encode(array('numDoc'=>$detail->NUMDOC,'montantRegle'=>$detail->MONTREGL,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->Contre,'depot'=>$detail->CodeDepot,'Remise'=>$detail->TAUXREM,'preperateur'=>$detail->prepa,'superviseur'=>$detail->superv,'vehicule'=>$detail->vehicul,'chauffeur'=>$detail->chauff,'expediteur'=>$detail->Exp,'nExpediteur'=>$detail->Nexpedition,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($bonLivraison);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->where('idD',$bonLiv->depot);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}
		
		$parametre = $this->db->get('Parametres');

		$numDoc = $parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot;

		$this->db->set('NUMDOC',$numDoc);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('MONTREGL',$bonLiv->montantRegle);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('BL',$idBL);

		$this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',$bonLiv->contre); 

		$this->db->set('Exp',$bonLiv->expediteur);

		$this->db->set('chauff',$bonLiv->chauffeur);

		$this->db->set('superv',$bonLiv->superviseur);  

		$this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('Factures');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsSortie');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');

		$this->db->set('fact',1);

		$this->db->set('NUMFACT',$id);

		$this->db->where('idBL',$idBL);

		$this->db->update('BonsLivraison');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot);

		$this->db->set('type',21);

		$this->db->set('idDocO',$bonLiv->numDoc);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMFACT_C = $parametre->row()->NUMFACT_C+1;

		$size = strlen($parametre->row()->NUMFACT_C);

		$NUMFACT_C = str_pad($NUMFACT_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMFACT_C',$NUMFACT_C);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $numDoc;
		}

	}




	public function facturerBonLivraison($idBL,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->select('BonsLivraison.*,detailsBonsLivraison.DESIGNAT,detailsBonsLivraison.PUHT,detailsBonsLivraison.PTTC,detailsBonsLivraison.QTE,detailsBonsLivraison.REMISE,detailsBonsLivraison.CODETVA,detailsBonsLivraison.CODEART,detailsBonsLivraison.CODEFAM,detailsBonsLivraison.COMMENT');

		$this->db->join('detailsBonsLivraison','detailsBonsLivraison.NUMDOC = BonsLivraison.idBL');

		$this->db->where('BonsLivraison.idBL',$idBL);

		$BonsLivraison = $this->db->get('BonsLivraison');

		if ($BonsLivraison->num_rows()>0) {

			$articles = array();
			foreach ($BonsLivraison->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}
			$bonLivraison = json_encode(array('numDoc'=>$detail->NUMDOC,'montantRegle'=>$detail->MONTREGL,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->Contre,'depot'=>$detail->CodeDepot,'Remise'=>$detail->TAUXREM,'preperateur'=>$detail->prepa,'superviseur'=>$detail->superv,'vehicule'=>$detail->vehicul,'chauffeur'=>$detail->chauff,'expediteur'=>$detail->Exp,'nExpediteur'=>$detail->Nexpedition,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($bonLivraison);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->where('idD',$bonLiv->depot);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}
		
		$parametre = $this->db->get('Parametres');

		$numDoc = $parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot;

		$this->db->set('NUMDOC',$numDoc);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('MONTREGL',$bonLiv->montantRegle);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('BL',$idBL);

		$this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',$bonLiv->contre); 

		$this->db->set('Exp',$bonLiv->expediteur);

		$this->db->set('chauff',$bonLiv->chauffeur);

		$this->db->set('superv',$bonLiv->superviseur);  

		$this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('Factures');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsSortie');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');

		$this->db->set('fact',1);

		$this->db->set('NUMFACT',$id);

		$this->db->where('idBL',$idBL);

		$this->db->update('BonsLivraison');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot);

		$this->db->set('type',21);

		$this->db->set('idDocO',$bonLiv->numDoc);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMFACT_C = $parametre->row()->NUMFACT_C+1;

		$size = strlen($parametre->row()->NUMFACT_C);

		$NUMFACT_C = str_pad($NUMFACT_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMFACT_C',$NUMFACT_C);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $numDoc;
		}

	}

	public function facturerGroupeBonLivraison($idBLs,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->select('BonsLivraison.*,detailsBonsLivraison.DESIGNAT,detailsBonsLivraison.PUHT,detailsBonsLivraison.PTTC,detailsBonsLivraison.QTE,detailsBonsLivraison.REMISE,detailsBonsLivraison.CODETVA,detailsBonsLivraison.CODEART,detailsBonsLivraison.CODEFAM,detailsBonsLivraison.COMMENT');

		$this->db->join('detailsBonsLivraison','detailsBonsLivraison.NUMDOC = BonsLivraison.idBL');

		$this->db->where_in('BonsLivraison.idBL',$idBLs);

		$this->db->order_by('BonsLivraison.CODETIER');

		$BonsLivraison = $this->db->get('BonsLivraison');

		if ($BonsLivraison->num_rows()>0) {

			$articles = array();
			foreach ($BonsLivraison->result() as $key => $detail) {

				array_push($articles,array('id'=>$detail->CODEART,'label'=>$detail->DESIGNAT,'prixHT'=>$detail->PUHT,'prixTTC'=>$detail->PTTC,'qte'=>$detail->QTE,'remise'=>$detail->REMISE,'famille'=>$detail->CODEFAM,'tva'=>$detail->CODETVA,'commentaire'=>$detail->COMMENT));

			}

			$bonLivraison = json_encode(array('numDoc'=>$detail->NUMDOC,'montantRegle'=>$detail->MONTREGL,'date'=>$detail->DATE,'nom'=>$detail->NOMTIER,'tel'=>$detail->tel,'adresse'=>$detail->ADRESSE,'idClient'=>$detail->CODETIER,'bonCommande'=>$detail->BC,'contre'=>$detail->Contre,'depot'=>$detail->CodeDepot,'Remise'=>$detail->TAUXREM,'preperateur'=>$detail->prepa,'superviseur'=>$detail->superv,'vehicule'=>$detail->vehicul,'chauffeur'=>$detail->chauff,'expediteur'=>$detail->Exp,'nExpediteur'=>$detail->Nexpedition,'articles'=>$articles));

		}else{
			return FALSE;
		}

		$bonLiv = json_decode($bonLivraison);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');


		$this->db->where('idD',$bonLiv->depot);

		$this->db->limit(1);

		$depot = $this->db->get('Depots');

		if($depot->num_rows()>0){ $codeDepot = '/'.$depot->row()->codeDepot;}
		
		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot);

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('MONTREGL',$bonLiv->montantRegle);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('BC',$bonLiv->bonCommande);

		$this->db->set('BL','');

		$this->db->set('Nexpedition',$bonLiv->nExpediteur);

		$this->db->set('Contre',$bonLiv->contre); 

		$this->db->set('Exp',$bonLiv->expediteur);

		$this->db->set('chauff',$bonLiv->chauffeur);

		$this->db->set('superv',$bonLiv->superviseur);  

		$this->db->set('prepa',$bonLiv->preperateur);

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicul',$bonLiv->vehicule);

		$this->db->insert('Factures');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsSortie');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));

		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');

		foreach ($idBLs as $key => $idBL) {
			
			$this->db->set('fact',1);

			$this->db->set('NUMFACT',$id);

			$this->db->where('idBL',$idBL);

			$this->db->update('BonsLivraison');


			$this->db->set('idUtilisateur',$idUser);

			$this->db->set('id',$id);

			$this->db->set('idDocu',$parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot);

			$this->db->set('type',21);

			$this->db->set('idDocO',$idBL);

			$this->db->set('json',$bonLivraison);
			
			$this->db->insert('ActivitiesUtilisateur');

		}

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFFACT_C.$parametre->row()->NUMFACT_C.$parametre->row()->SUFFFACT_C.$codeDepot);

		$this->db->set('type',21);

		$this->db->set('idDocO',$bonLiv->numDoc);

		$this->db->set('json',$bonLivraison);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMFACT_C = $parametre->row()->NUMFACT_C+1;

		$size = strlen($parametre->row()->NUMFACT_C);

		$NUMFACT_C = str_pad($NUMFACT_C, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMFACT_C',$NUMFACT_C);

		$this->db->update('Parametres');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return $id;
		}

	}

	public function updateFacture($facture,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$bonLiv = json_decode($facture);

		$id = $bonLiv->id;

		$this->db->select('DetailsSortie.*,Factures.CodeDepot');

		$this->db->join('Factures','Factures.idFacture = DetailsSortie.NUMDOC');

		$this->db->where('DetailsSortie.NUMDOC',$id);

		$dbons = $this->db->get('DetailsSortie');

		foreach ($dbons->result() as $key => $dbon) {

			$this->db->where('idDetailSortie',$dbon->idDetailSortie);

			$this->db->delete('DetailsSortie');			

		}

		$this->db->set('DATE',$bonLiv->date);

		$this->db->set('CODETIER',$bonLiv->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$bonLiv->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$bonLiv->nom);

		$this->db->set('ADRESSE',$bonLiv->adresse);

		$this->db->set('tel',$bonLiv->tel);

		$this->db->set('Nexpedition',(isset($bonLiv->nExpediteur)) ? $bonLiv->nExpediteur : ''); 

		$this->db->set('Contre',(isset($bonLiv->contre)) ? $bonLiv->contre : 0); 

		$this->db->set('Exp',(isset($bonLiv->expediteur)) ? $bonLiv->expediteur : ''); 

		$this->db->set('chauff',(isset($bonLiv->chauffeur)) ? $bonLiv->chauffeur : ''); 

		$this->db->set('superv',(isset($bonLiv->superviseur)) ? $bonLiv->superviseur : ''); 

		$this->db->set('prepa',(isset($bonLiv->preperateur)) ? $bonLiv->preperateur : ''); 

		$this->db->set('CodeDepot',$bonLiv->depot);

		$this->db->set('vehicule',(isset($bonLiv->vehicule)) ? $bonLiv->vehicule : ''); 

		$this->db->set('observations',$bonLiv->observations);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');

		$totht = 0;
		$totttc = 0;

		foreach ($bonLiv->articles as $key => $article) {

			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));


			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$bonLiv->idClient);

			$this->db->set('DATE',$bonLiv->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsSortie');

		}

		$totht = $totht-($totht*($bonLiv->Remise/100));
		
		$totttc = $totttc-($totttc*($bonLiv->Remise/100));

		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idFacture',$id);

		$this->db->update('Factures');

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$bonLiv->numDoc);

		$this->db->set('type',47);

		$this->db->set('json',$facture);
		
		$this->db->insert('ActivitiesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertBonCommande($bonComm,$idUser){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$devi = json_decode($bonComm);

		$codeDepot = '';

        $this->db->order_by('idParametrage','DESC');

		$this->db->limit(1);

		$parametre = $this->db->get('Parametres');

		$this->db->set('NUMDOC',$parametre->row()->PREFCOM_F.$parametre->row()->NUMCOM_F.$parametre->row()->SUFFCOM_F);

		$this->db->set('DATE',$devi->date);

		$this->db->set('CODETIER',$devi->idClient);

		$this->db->set('MONTANT',0.00);

		$this->db->set('TAUXREM',$devi->Remise);

		$this->db->set('MONTTVAART',0.00);

		$this->db->set('NOMTIER',$devi->nom);

		$this->db->set('ADRESSE',$devi->adresse);

		$this->db->set('tel',$devi->tel);

		$this->db->set('ModePaie',(isset($devi->contre))?$devi->contre:''); 

		$this->db->set('observations',$devi->observations);

		$this->db->insert('BonsCommande');

		$id = $this->db->insert_id();

		$totht = 0;
		$totttc = 0;

		foreach ($devi->articles as $key => $article) {


			$total = $article->prixHT * $article->qte;

			$totht += $total-($total*($article->remise/100));

			$total = $article->prixTTC * $article->qte;

			$totttc += $total-($total*($article->remise/100));

			$this->db->set('NUMDOC',$id);

			$this->db->set('CODEART',$article->id);

			$this->db->set('PUHT',$article->prixHT);

			$this->db->set('PTTC',$article->prixTTC);

			$this->db->set('QTE',$article->qte);

			$this->db->set('REMISE',$article->remise);

			$this->db->set('CODETVA',$article->tva);

			$this->db->set('CODETIER',$devi->idClient);

			$this->db->set('DATE',$devi->date);

			$this->db->set('DESIGNAT',$article->label);

			$this->db->set('CODEFAM',$article->famille);

			$this->db->set('COMMENT',$article->commentaire);

			$this->db->insert('DetailsBonsCommande');

		}

		$totht = $totht-($totht*($devi->Remise/100));

		$totttc = $totttc-($totttc*($devi->Remise/100));

		
		$this->db->set('MONTANT',$totht);

		$this->db->set('MONTTVAART',$totttc-$totht);

		$this->db->where('idBC',$id);

		$this->db->update('BonsCommande');


		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu',$parametre->row()->PREFDEV_C.$parametre->row()->NUMCOM_F.$parametre->row()->SUFFDEV_C);

		$this->db->set('type',13);

		$this->db->set('json',$bonComm);
		
		$this->db->insert('ActivitiesUtilisateur');

		$NUMCOM_F = $parametre->row()->NUMCOM_F+1;

		$size = strlen($parametre->row()->NUMCOM_F);

		$NUMCOM_F = str_pad($NUMCOM_F, $size, "0", STR_PAD_LEFT);

		$this->db->set('NUMCOM_F',$NUMCOM_F);

		$this->db->update('Parametres');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function getDevis($dateCaisse='',$dateCaisse1=''){


		$this->db->select('Devies.NUMDOC,Devies.idDevis,Devies.DATE ddate,DATE_FORMAT(Devies.DATE, "%d/%m/%Y") DATE,FORMAT(Devies.MONTANT+Devies.MONTTVAART,2) total,Devies.CODETIER, Devies.NOMTIER,Devies.ADRESSE,Devies.tel,(CASE Devies.Valide WHEN "0" THEN "Saisi" WHEN "1" THEN "Confirme" WHEN "2" THEN "Valide" END) AS Valide'); 
		$this->db->order_by('Devies.idDevis','DESC');
		return $this->db->get('Devies')->result_array();

	}

	public function getAvoirs($dateCaisse='',$dateCaisse1=''){

		$this->db->select('Avoirs.NUMDOC,Avoirs.idAvoir,Avoirs.DATE ddate,DATE_FORMAT(Avoirs.DATE, "%d/%m/%Y") DATE,FORMAT(Avoirs.MONTANT+Avoirs.MONTTVAART,2) total,Avoirs.CODETIER,FORMAT(Avoirs.MONTREGL,2) MONTREGL, Avoirs.NOMTIER,Avoirs.ADRESSE,Avoirs.tel,BLRecuAnnul Valide,Avoirs.dateCreation'); 
		$this->db->order_by('Avoirs.idAvoir','DESC');
		return $this->db->get('Avoirs')->result_array();

	}



	public function getBonsLivraison($dateCaisse='',$dateCaisse1=''){

		$this->db->select('BonsLivraison.dateCreation,BonsLivraison.NUMDOC,BonsLivraison.idBL,BonsLivraison.DATE ddate,DATE_FORMAT(BonsLivraison.DATE, "%d/%m/%Y") DATE,FORMAT(BonsLivraison.MONTANT+BonsLivraison.MONTTVAART,2) total,FORMAT(BonsLivraison.MONTANT,2) totalht,BonsLivraison.CODETIER, BonsLivraison.NOMTIER,BonsLivraison.ADRESSE,BonsLivraison.tel,(CASE BonsLivraison.fact WHEN "0" THEN "Saisi" WHEN "1" THEN "Facture" WHEN "2" THEN "Regle" WHEN "3" THEN "Transfert" END) AS Valide'); 
		$this->db->order_by('BonsLivraison.idBL','DESC');
		return $this->db->get('BonsLivraison')->result_array();

	}

	public function getBonsCommande($dateCaisse='',$dateCaisse1=''){

		$this->db->select('BonsCommande.NUMDOC,BonsCommande.idBC,BonsCommande.DATE ddate,DATE_FORMAT(BonsCommande.DATE, "%d/%m/%Y") DATE,FORMAT(BonsCommande.MONTANT+BonsCommande.MONTTVAART,2) total,BonsCommande.CODETIER, BonsCommande.NOMTIER,BonsCommande.ADRESSE,BonsCommande.tel,(CASE BonsCommande.Valide WHEN "0" THEN "Saisi" WHEN "1" THEN "Confirme" WHEN "2" THEN "Valide" END) AS Valide'); 

		$this->db->order_by('BonsCommande.idBC','DESC');
		return $this->db->get('BonsCommande')->result_array();

	}


	public function getBonsReception($dateCaisse='',$dateCaisse1=''){

		$this->db->select('BonsReception.dateCreation,BonsReception.NUMDOC,BonsReception.idBR,BonsReception.DATE ddate,DATE_FORMAT(BonsReception.DATE, "%d/%m/%Y") DATE,FORMAT(BonsReception.MONTANT+BonsReception.MONTTVAART,2) total,FORMAT(BonsReception.MONTANT,2) totalht,BonsReception.CODETIER, BonsReception.NOMTIER,BonsReception.ADRESSE,BonsReception.tel,(CASE BonsReception.fact WHEN "0" THEN "Saisi" WHEN "1" THEN "Facture" WHEN "2" THEN "Regle" WHEN "3" THEN "Transfert" END) AS Valide'); 

		$this->db->order_by('BonsReception.idBR','DESC');
		return $this->db->get('BonsReception')->result_array();

	}

	public function getFactures($dateCaisse='',$dateCaisse1=''){

		$this->db->select('Factures.NUMDOC,Factures.idFacture,Factures.DATE ddate,DATE_FORMAT(Factures.DATE, "%d/%m/%Y") DATE,FORMAT(Factures.MONTANT+Factures.MONTTVAART,2) total,Factures.CODETIER,FORMAT(Factures.MONTREGL,2) MONTREGL, Factures.NOMTIER,Factures.ADRESSE,Factures.tel,BLRecuAnnul Valide,Factures.dateCreation'); 
		$this->db->order_by('Factures.idFacture','DESC');

		return $this->db->get('Factures')->result_array();

	}

	public function getFacturesFournisseur($dateCaisse='',$dateCaisse1=''){

		$this->db->select('FacturesF.NUMDOC,FacturesF.idFactureF,FacturesF.DATE ddate,DATE_FORMAT(FacturesF.DATE, "%d/%m/%Y") DATE,FORMAT(FacturesF.MONTANT+FacturesF.MONTTVAART,2) total,FacturesF.CODETIER,FORMAT(FacturesF.MONTREGL,2) MONTREGL, FacturesF.NOMTIER,FacturesF.ADRESSE,FacturesF.tel,BLRecuAnnul Valide,FacturesF.dateCreation'); 
		$this->db->order_by('FacturesF.idFactureF','DESC');

		return $this->db->get('FacturesF')->result_array();

	}


}
?>