<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class HotelModel extends CI_Model
{

	public function getHotel(){
		$this->db->order_by('dateCreation','DESC');
		$this->db->limit(1);
		return $this->db->get('Hotel')->row();
	}


	public function getCloture(){
        $this->db->order_by('idCloture','DESC');
        $this->db->limit(1); 
		return $this->db->get('Clotures')->row();

	}
	public function setCloture($date){

		$date = date ("Y-m-d", strtotime ($date ."+1 days"));
		$this->db->set('dateCloture',$date); 
		return $this->db->insert('Clotures');

	}
	public function getPays(){
		$this->db->order_by('name_fr','ASC');
		return $this->db->get('Pays')->result_array();
	}

	public function getDevises(){
		return $this->db->get('Devises')->result_array();
	}

	public function getTypesEtablissements(){
		return $this->db->get('TypesEtablissements')->result_array();
	}

	public function getTaxes(){
		return $this->db->get('Taxes')->result_array();
	}

	public function getTaxe($idTax){
		$this->db->where('idTax',$idTax);
		return $this->db->get('Taxes')->result_array();
	}

	public function getDatesChambreRes($date){

		$this->db->select('DatesChambreRes.*,r.*,ChambresReservations.isCheckin as isRoomCheckin,ChambresReservations.isCheckout as isRoomCheckout,ChambresReservations.dateAu as dateAu,,Pensions.codePension,Pensions.idPension,TypesChambres.nomTypeChambres,DatesChambreRes.prix as prixday');
		$this->db->join('ChambresReservations','ChambresReservations.idCR = DatesChambreRes.idCR');	
		$this->db->join('Reservations r','r.idReservation = DatesChambreRes.idReservation');
		
		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = DatesChambreRes.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('r.isCanceled',false);
		$this->db->where('r.isArchive',false);
		$this->db->where('ChambresReservations.isCanceled',false);
		$this->db->where('DatesChambreRes.date',$date);
		return $this->db->get('DatesChambreRes')->result_array();

	}

	public function getCheckoutChambreRes($date){

		$this->db->select('r.*,ChambresReservations.isCheckin as isRoomCheckin,ChambresReservations.isCheckout as isRoomCheckout,ChambresReservations.dateAu as dateAu,r.client');
		$this->db->join('Reservations r','r.idReservation = ChambresReservations.idReservation');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('r.isCanceled',false);
		$this->db->where('r.isArchive',false);
		$this->db->where('ChambresReservations.isCanceled',false);
		$this->db->where('ChambresReservations.isCheckin',true);
		$this->db->where('ChambresReservations.isCheckout',false);
		$this->db->where('ChambresReservations.dateAu',$date);

		return $this->db->get('ChambresReservations')->result_array();

	}

	public function getCheckinChambreRes($date){

		$this->db->select('r.*,ChambresReservations.isCheckin as isRoomCheckin,ChambresReservations.isCheckout as isRoomCheckout,ChambresReservations.dateAu as dateAu,r.client');
		$this->db->join('Reservations r','r.idReservation = ChambresReservations.idReservation');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('r.isCanceled',false);
		$this->db->where('r.isArchive',false);
		$this->db->where('ChambresReservations.isCanceled',false);
		$this->db->where('ChambresReservations.isCheckin',false);

		$this->db->where('ChambresReservations.dateDu',$date);

		return $this->db->get('ChambresReservations')->result_array();

	}

	public function getExtraResDates($idCR,$date){

		$this->db->join('ExtrasReservation','ExtrasReservation.idExtraRes = ExtraResDates.idExtraRes');	
		$this->db->where('ExtrasReservation.isCanceled',false);
		$this->db->where('ExtraResDates.idCR',$idCR);
		$this->db->where('ExtraResDates.date',$date);
		return $this->db->get('ExtraResDates')->result_array();

	}

	public function cloturer($date,$idUtilisateur = 1){


		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE);

		$this->db->where('isCanceled',FALSE);
		$this->db->where('isArchive',FALSE);
		$this->db->where('dateDu<=',$date);
		$this->db->where('dateAu>',$date);
		$qReservations = $this->db->get('Reservations');

		if($qReservations->num_rows()>0){
			foreach ($qReservations->result() as $key => $reservation) {

				$this->db->select('ChambresReservations.idCR,Extras.idExtra,DatesChambreRes.prix,DatesChambreRes.date,ChambresReservations.isCheckin,ChambresReservations.totalAdult,Extras.idPension');
				$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR');
				$this->db->join('ChannelTarifs','DatesChambreRes.idTarif = ChannelTarifs.idChannelTarif');
				$this->db->join('DetailsTarif','ChannelTarifs.idDetTar = DetailsTarif.idDetTar');
				$this->db->join('Extras','Extras.idPension = DetailsTarif.idPension AND Extras.idDeduction > 0');
				$this->db->where('ChambresReservations.idReservation',$reservation->idReservation);
				$this->db->where('ChambresReservations.isCanceled',FALSE);
				$this->db->where('DatesChambreRes.date',$date);
				$qDateReservations = $this->db->get('ChambresReservations');
				if($qDateReservations->num_rows()>0){
					foreach ($qDateReservations->result() as $key => $dateReservation) {

						if(!$dateReservation->isCheckin){

							$this->db->set('isNoshow',true);
							$this->db->where('idCR',$dateReservation->idCR);
							if($this->db->update('ChambresReservations')){
								$this->db->where('idReservation',$reservation->idReservation);
								$this->db->where('isNoshow',false);
								$query = $this->db->get('ChambresReservations');
								if($query->num_rows()==0){
									$this->db->set('isNoshow',true);
									$this->db->where('idReservation',$reservation->idReservation);
									$this->db->update('Reservations');
								}
							}

						}else{
							$pax = 0;
							$this->db->set('idReservation',$reservation->idReservation);
							$this->db->set('idCR',$dateReservation->idCR);
							$this->db->set('idExtra',$dateReservation->idExtra);
							$this->db->set('prix',$dateReservation->prix);
							$this->db->set('qte',1);
							$this->db->set('type',1);
							$this->db->set('date',$dateReservation->date);
							$this->db->insert('DetailsFacture');

							if($dateReservation->idPension>0){

								$this->db->where('typeTax',1);
								$this->db->where('idDeduction>',0);
								$this->db->join('Extras','Extras.idTaxe = Taxes.idTax','LEFT');
								$qTaxes = $this->db->get('Taxes');
								if($qTaxes->num_rows()>0){
									foreach ($qTaxes->result() as $key => $taxe) {

		                                if($taxe->parPerson){
		                                    $pax += $dateReservation->totalAdult;
		                                    $this->db->where('idCR',$dateReservation->idCR);
		                                    $qEnfants = $this->db->get('ReservationEnfants');
		                                    if($qEnfants->num_rows()>0){
												foreach ($qEnfants->result() as $key => $enfant) {	
													if($enfant->age>12){
														$pax += $dateReservation->totalAdult;
													}
												}
											}
		                                }else{
		                                    $pax =1;
		                                }

			                            if($taxe->typeValeur == 2){

			                                $taxValeur = $taxe->valeur;

			                                $valeur = $taxe->valeur * $reservation->changeRate;

			                            }else{

			                                $taxValeur =(($taxe->valeur/100) * $dateReservation->prix);

			                                $valeur = (($taxe->valeur/100) * $dateReservation->prix) * $reservation->changeRate;
			                            }


										$this->db->set('idReservation',$reservation->idReservation);
										$this->db->set('idCR',$dateReservation->idCR);
										$this->db->set('idExtra',$taxe->idExtra);
										$this->db->set('prix',$valeur);
										$this->db->set('qte',$pax);
										$this->db->set('type',1);
										$this->db->set('date',$dateReservation->date);
										$this->db->insert('DetailsFacture');

									}
								}

							}


						}

					}
				}

				$this->db->select('ExtraResDates.idCR,ExtraResDates.idExtra,ExtraResDates.prix,ExtraResDates.date,ExtrasReservation.idExtraRes,ExtraResDates.pax');
				$this->db->join('ExtraResDates','ExtraResDates.idExtraRes = ExtrasReservation.idExtraRes');
				$this->db->where('ExtrasReservation.idReservation',$reservation->idReservation);
				$this->db->where('ExtrasReservation.isCanceled',FALSE);
				$this->db->where('ExtraResDates.date',$date);
				$qExtraReservations = $this->db->get('ExtrasReservation');
				if($qExtraReservations->num_rows()>0){
					foreach ($qExtraReservations->result() as $key => $dateExtra) {

						$this->db->set('idReservation',$reservation->idReservation);
						$this->db->set('idCR',$dateExtra->idCR);
						$this->db->set('idExtraRes',$dateExtra->idExtraRes);
						$this->db->set('idExtra',$dateExtra->idExtra);
						$this->db->set('prix',$dateExtra->prix);
						$this->db->set('qte',$dateExtra->pax);
						$this->db->set('type',2);
						$this->db->set('date',$dateExtra->date);
						$this->db->insert('DetailsFacture');

					}
				}
			}

		}


	
		$date = date ("Y-m-d", strtotime ($date ."+1 days"));
		$this->db->set('dateCloture',$date); 
		$this->db->insert('Clotures');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function getDepartements(){

		return $this->db->get('Departements')->result_array();
	}


}