<?php 

defined('BASEPATH') OR exit('No direct script access allowed');

class PartenairesModel extends CI_Model
{

	public function getPartenaires(){
		$this->db->where('active',TRUE);
		return $this->db->get('Partenaires')->result_array();
	}

	public function insert($nom,$tel,$adresse,$quar){

		$data = array('partenaire'=>$nom,'tel'=>$tel,'adresse'=>$adresse);
		if($this->db->insert('Partenaires',$data)){
			$idPartenaire = $this->db->insert_id();
			$data = array('nomClient'=>$nom,'isPartenaire'=>TRUE,'idPartenaire'=>$idPartenaire);
			if($this->db->insert('Clients',$data)){
				$idClient = $this->db->insert_id();
					if (!empty($tel)) {

						$dataTele = array('idClient'=>$idClient,'Telephone'=>$tel);
			    		$this->db->insert('Telephones',$dataTele);	
					}
					if (!empty($adresse)) {
						$dataAdresse = array('idClient'=>$idClient,'Adresse'=>$adresse,'idQ'=>$quar);
			    		$this->db->insert('Adresses',$dataAdresse);
					}
	        	
			}
			return true;
		}else{
			return false;
		}





	}

	public function delete($isPartenaire){
        $this->db->set('active',FALSE);
        $this->db->where('idPartenaire',$isPartenaire);
		return $this->db->update('Partenaires');
	}

	public function update($isPartenaire,$nom,$tel,$adresse){

		$this->db->set('partenaire',$nom);
		$this->db->set('tel',$tel);
		$this->db->set('adresse',$adresse);
        $this->db->where('idPartenaire',$isPartenaire);
		return $this->db->update('Partenaires');
	}


	public function getPartenairePrestation($id){
         
        $this->db->select('Prestations.idPrestation,Prestations.libellePrestation,Prestations.prix,CartePartenaire.prixPartemaire');
		$this->db->join('TypesPrestation','TypesPrestation.idTypePrestation = Prestations.idTypePrestation');
		$this->db->join('CartePartenaire','`CartePartenaire`.`idPrestation` = `Prestations`.`idPrestation` AND `CartePartenaire`.`idPartenaire` = '.$id,'LEFT');
		$this->db->where('Prestations.idTypePrestation != ',3);
		$this->db->where('Prestations.idTypePrestation != ',4);
		$this->db->where('Prestations.idTypePrestation != ',5);
		$this->db->where('Prestations.idTypePrestation != ',6);
		$this->db->where('Prestations.active',1);
		$this->db->order_by('Prestations.idPrestation');
		return $this->db->get('Prestations')->result_array();
	}


	public function insertCarte($idPartenaire,$items){
        $this->db->where('idPartenaire',$idPartenaire);
		if($this->db->delete('CartePartenaire')){
			foreach ($items as $item) {
				$this->db->select('PrestationTailles.idTPrestation as idtp,PrestationTailles.idPrestation as idp,Prestations.isTaille');
				$this->db->join('PrestationTailles','PrestationTailles.idTPrestation = Prestations.idPrestation');
				$this->db->where('Prestations.idPrestation',$item['idPresta']);
				$qp = $this->db->get('Prestations');
				if ($qp->num_rows()>0) {
					if ($qp->row()->isTaille) {
						$data = array('idPartenaire'=>$idPartenaire,'idPrestation'=>$qp->row()->idp,'prixPartemaire'=>-1);
				        if($this->db->insert('CartePartenaire',$data)){
				         	$data = array('idPartenaire'=>$idPartenaire,'idPrestation'=>$item['idPresta'],'prixPartemaire'=>$item['prix']);
					        if(!$this->db->insert('CartePartenaire',$data)){
					         	return false;
					        }
				        }	
					}else{
						$data = array('idPartenaire'=>$idPartenaire,'idPrestation'=>$item['idPresta'],'prixPartemaire'=>$item['prix']);
				        if(!$this->db->insert('CartePartenaire',$data)){
				         	return false;
				        }
					}
				}else{
						$data = array('idPartenaire'=>$idPartenaire,'idPrestation'=>$item['idPresta'],'prixPartemaire'=>$item['prix']);
				        if(!$this->db->insert('CartePartenaire',$data)){
				         	return false;
				        }

				}

		        
			}
		}else{
			return false;
		}
		return true;

	}


	public function getCartePartenaire($idPartenaire){

		$this->db->where('idPartenaire',$idPartenaire);
		return $this->db->get('CartePartenaire')->result_array();


	}








}