<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class PeriodesModel extends CI_Model
{


	public function getPeriode($saison,$idDetTar,$idTypeCh,$dateD,$dateF){

		$this->db->where('Periodes.idTypesChambre',$idTypeCh);

		$this->db->where('Periodes.idDetTar',$idDetTar);

		$this->db->where('Periodes.dateDebut',$dateD);

		$this->db->where('Periodes.dateFin',$dateF);

		$this->db->where('Periodes.idSaison',$saison);

		$this->db->limit(1);

        return $this->db->get('Periodes')->result_array();

    }

    public function getPeriodes(){

        return $this->db->get('Periodes')->result_array();
    }

    public function getContratPeriode($idTarif){

		$this->db->select('Tarifs.codeTarif,Tarifs.idTarif,Tarifs.tarif,TypesPassage.typePassage,Pensions.pension,Periodes.dateDebut,Periodes.dateFin,TypesChambres.nomTypeChambres,Saisons.saison,Periodes.prix,Periodes.dateCreation,Pensions.codePension,TypesPassage.codePassage,Periodes.idPeriode,Saisons.idSaison');

		$this->db->join('DetailsTarif','DetailsTarif.idTarif = Tarifs.idTarif','LEFT');
		$this->db->join('TypesPassage','DetailsTarif.idTypePassage = TypesPassage.idTypePassage','LEFT');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');
		$this->db->join('Periodes','Periodes.idDetTar = DetailsTarif.idDetTar','LEFT');
		$this->db->join('TypesChambres','Periodes.idTypesChambre = TypesChambres.idTypeChambres','LEFT');
		$this->db->join('Saisons','Periodes.idSaison = Saisons.idSaison','LEFT');
		$this->db->where('Tarifs.idTarif',$idTarif);
		$this->db->group_by('Saisons.idSaison,Periodes.dateDebut,Periodes.dateFin');
		$this->db->order_by('Periodes.dateCreation');
        return $this->db->get('Tarifs')->result_array();
    }

    public function insert($isCh,$idDetTar,$dateDebut,$dateFin,$idSaison,$prix,$idTarif){


		$this->db->where('idSaison',$idSaison);
		$this->db->where('idDetTar',$idDetTar);
		$this->db->where('idTypesChambre',$isCh);
		$this->db->where('dateFin >=',$dateDebut);
		$this->db->where('dateDebut <=', $dateFin);
    	$query_result = $this->db->get('Periodes');
    	if($query_result->num_rows()>0){

    		return array('status'=>false,'result'=>false,"rows"=>$query_result->result_array());

    	}else{

			$periode = array('idTypesChambre'=>$isCh,'idDetTar'=>$idDetTar,'idSaison'=>$idSaison,'dateDebut'=>$dateDebut,'dateFin'=>$dateFin,'prix'=>$prix);
			$sql = $this->db->insert_string('Periodes', $periode).' ON DUPLICATE KEY UPDATE prix='.$prix;
			if($this->db->query($sql)){
				$this->db->where('idSaison',$idSaison);
				$this->db->where('idDetTar',$idDetTar);
				$this->db->where('idTypesChambre',$isCh);
				$this->db->where('dateDebut',$dateDebut);
				$this->db->where('dateFin',$dateFin);


				$qDetailsTarif = $this->db->get('Periodes');
		        if($qDetailsTarif->num_rows()>0){

		        	return array('status'=>true,'result'=>true,'idTarif'=>$qDetailsTarif->row()->idPeriode);
		        }else{
		        	return array('status'=>false,'result'=>true);
		        }
			}else{

				return array('status'=>false,'result'=>true);

			}
    	}

    }

}
?>