<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class PrintJobsModel extends CI_Model
{

	public function getPrintJobs(){

		$this->db->where('etat',1);
		$qTickets = $this->db->get('PrintJobs');
		if ($qTickets->num_rows() > 0) {
			foreach ($qTickets->result() as $ticket) {
				$this->db->set('etat',2);
				$this->db->where('idPrintJ',$ticket->idPrintJ);
				$this->db->update('PrintJobs');
				if ($ticket->type == 1) {
					return $this->getTicketCommande($ticket->idFacture,$ticket->idPrintJ,$ticket->ajout);
				}else if ($ticket->type == 2) {
                    return $this->getTicketEncaissement($ticket->idFacture,$ticket->idPrintJ);
				}else if($ticket->type == 3){
					return $this->getTicketAddition($ticket->idFacture,$ticket->idPrintJ);
				}else if($ticket->type == 4){
					return $this->getTicketPartenaire($ticket->idFacture,$ticket->idPart,$ticket->idPrintJ);
				}else if($ticket->type == 5){
                    return $this->getTicketClient($ticket->json,$ticket->idPrintJ);
				}        
			}
		}else{
            
		}
	}


	private function getTicketClient($json,$idpj){

		    return $json;

	}


	private function getTicketCommande($iddf,$idpj,$ajout){
		$Commande=array();
        $this->db->distinct();
		$this->db->select('Prestations.idImprimante,Imprimantes.ip,Imprimantes.port,Imprimantes.libelleImprimante');
		$this->db->from('DetailsFactures');
		$this->db->join('Prestations','Prestations.idPrestation = DetailsFactures.idPrestation');
		$this->db->join('Imprimantes','Prestations.idImprimante = Imprimantes.idImprimante');
		$this->db->where('DetailsFactures.idFacture',$iddf);
		$this->db->where('DetailsFactures.qteCommandee <>',0);
	    $qImps = $this->db->get();
	    $Imprimantes = array();
		foreach ($qImps->result() as $imprimant) {
			$this->db->select('DetailsFactures.idDetailFacture,DetailsFactures.prix,DetailsFactures.qteCommandee,Prestations.libellePrestation,Utilisateurs.nomUtilisateur,Tables.libelleTable,Prestations.idTypePrestation');
			$this->db->from('DetailsFactures');
			$this->db->join('Prestations','Prestations.idPrestation = DetailsFactures.idPrestation');
			$this->db->join('Factures','Factures.idFacture = DetailsFactures.idFacture');
			$this->db->join('Tables','Factures.idTable = Tables.idTable');
			$this->db->join('Utilisateurs','Factures.idUtilisateur = Utilisateurs.idUtilisateur');
			$this->db->where('DetailsFactures.idFacture',$iddf);
			$this->db->where('Prestations.idImprimante',$imprimant->idImprimante);
			$this->db->where('DetailsFactures.qteCommandee <>',0);



			$qDFI = $this->db->get();
			$details = array();

			if($qDFI->num_rows()>0){

				foreach ($qDFI->result() as $detail) {


								if($detail->idTypePrestation == 2){
									$this->db->select('Prestations.libellePrestation,DetailFactureAccom.qte');
									$this->db->join('DetailsAccopagnemenet','DetailFactureAccom.idDetailAccom = DetailsAccopagnemenet.idDetAccomp');
									$this->db->join('Prestations','Prestations.idPrestation = DetailsAccopagnemenet.idPrestation');
									$this->db->where('DetailFactureAccom.idDetailFacture',$detail->idDetailFacture);
									$qDFA = $this->db->get('DetailFactureAccom');
									$attributs = array();
									foreach ($qDFA->result() as $attribut) {
					                    array_push($attributs,array('libelle' => $attribut->libellePrestation,'qte' => $attribut->qte));
									}
				                    $this->db->select('Prestations.libellePrestation');
				                    $this->db->where('idDetailFacture',$detail->idDetailFacture);
				                    $this->db->join('Prestations','Prestations.idPrestation = DatFactureFormule.idPrestation');
									$gdf = $this->db->get('DatFactureFormule');
									if ($gdf->num_rows()>0) {
										array_push($details,array('Table'=> $detail->libelleTable,'libelle' => $detail->libellePrestation,'qte' => $detail->qteCommandee,'prix' => $detail->prix,'attributs' => $attributs));
										foreach ($gdf->result() as $formuleDetail) {
											array_push($details,array('Table'=> $detail->libelleTable,'libelle' => $formuleDetail->libellePrestation,'qte' => 'Formule','prix' => $detail->prix,'attributs' => $attributs));
										}	
									}
									








								}else{
									$this->db->select('Prestations.libellePrestation,DetailFactureAccom.qte,Prestations.idTypePrestation');
									$this->db->join('DetailsAccopagnemenet','DetailFactureAccom.idDetailAccom = DetailsAccopagnemenet.idDetAccomp');
									$this->db->join('Prestations','Prestations.idPrestation = DetailsAccopagnemenet.idPrestation');
									$this->db->where('DetailFactureAccom.idDetailFacture',$detail->idDetailFacture);
									$qDFA = $this->db->get('DetailFactureAccom');
									$attributs = array();
									foreach ($qDFA->result() as $attribut) {
					                    array_push($attributs,array('libelle' => $attribut->libellePrestation,'qte' => $attribut->qte));
									}
									array_push($details,array('Table'=> $detail->libelleTable,'libelle' => $detail->libellePrestation,'qte' => $detail->qteCommandee,'prix' => $detail->prix,'attributs' => $attributs));
								}










								
							}
			}
			





			array_push($Imprimantes,array('Ajout'=>$ajout,'PrintJob'=>$idpj,'Type' => 1,'IdFacture' => $iddf,'NomU' => $qDFI->row()->nomUtilisateur,'Id' => $imprimant->idImprimante,'Ip' => $imprimant->ip,'Port' => $imprimant->port,"Details"=>$details));	
		}
		$Commande = array("Commandes"=>$Imprimantes);
		return json_encode($Commande,TRUE);
	}

	private function getTicketPartenaire($iddf,$idPartenaire,$idpj){

			$Imprimantes = array();
			$this->db->where('idPartenaire',$idPartenaire);
		    $qSO = $this->db->get('Partenaires');
		    $societe = array();
			foreach ($qSO->result() as $soci) {
                array_push($societe,array('nom' => $soci->partenaire,'Tel' => $soci->tel,'adresse' => $soci->adresse));
			}
			$this->db->select('Factures.*,Tables.libelleTable,Utilisateurs.nomUtilisateur,l.nomUtilisateur as livruer,Clients.nomClient,Factures.idTelephone,Factures.idAdresse');
			$this->db->join('Tables','Tables.idTable = Factures.idTable');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = Factures.idUtilisateur');
			$this->db->join('Utilisateurs l','l.idUtilisateur = Factures.idLivreur');
			$this->db->join('Clients','Clients.idClient = Factures.idClient');
            $qF = $this->db->where('idFacture',$iddf);
			$qF = $this->db->get('Factures');
		    $facture = array();
			foreach ($qF->result() as $fact) {

				$this->db->where('idTele',$fact->idTelephone);
				$qT = $this->db->get('Telephones');
				$this->db->where('idAdresse',$fact->idAdresse);
				$qA = $this->db->get('Adresses');

                array_push($facture,array('serveur' => $fact->nomUtilisateur,'nomUser' => $fact->nomUtilisateur,'numtable' => $fact->libelleTable,'numfact'=>$fact->idFacture,'payer'=>$fact->montant,'montantR'=>$fact->montantReglement,'Livreur'=>$fact->livruer,'Client'=>$fact->nomClient,'CAdresse'=>$qA->row()->Adresse,'CTel'=>$qT->row()->Telephone));
			}

			$this->db->select('DetailsFactures.idDetailFacture,CartePartenaire.prixPartemaire,DetailsFactures.qte,Prestations.libellePrestation,Utilisateurs.nomUtilisateur');
			$this->db->from('DetailsFactures');
			
			$this->db->join('Prestations','Prestations.idPrestation = DetailsFactures.idPrestation');
			$this->db->join('CartePartenaire','`CartePartenaire`.`idPrestation` = `Prestations`.`idPrestation` AND `CartePartenaire`.`idPartenaire` = '.$idPartenaire);
			$this->db->join('Factures','Factures.idFacture = DetailsFactures.idFacture');
			$this->db->join('Utilisateurs','Factures.idUtilisateur = Utilisateurs.idUtilisateur');
			$this->db->where('DetailsFactures.idFacture',$iddf);
			$this->db->where('DetailsFactures.isAnnulee',FALSE);
			$qDFI = $this->db->get();
			$details = array();
			foreach ($qDFI->result() as $detail) {

				array_push($details,array('libelle' => $detail->libellePrestation,'qte' => $detail->qte,'prix' => $detail->prixPartemaire));
				
			}
			array_push($Imprimantes,array('Societe'=>$societe,'facture'=>$facture,'PrintJob'=>$idpj,'Type' => 3,'IdFacture' => $iddf,'NomU' => 'admin','Id' => 1,'Ip' => '10.0.2.200','Port' => 9100,"Details"=>$details,));	
		$Commande = array("Commandes"=>$Imprimantes);
		return json_encode($Commande,TRUE);
	}



	private function getTicketAddition($iddf,$idpj){

			$Imprimantes = array();
		    $qSO = $this->db->get('Societe');
		    $societe = array();
			foreach ($qSO->result() as $soci) {
                array_push($societe,array('nom' => $soci->nomSociete,'Tel' => $soci->telSociete,'adresse' => $soci->adresseSociete));
			}
			$this->db->select('Factures.*,Tables.libelleTable,Utilisateurs.nomUtilisateur,l.nomUtilisateur as livruer,Clients.nomClient,Factures.idTelephone,Factures.idAdresse');
			$this->db->join('Tables','Tables.idTable = Factures.idTable');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = Factures.idUtilisateur');
			$this->db->join('Utilisateurs l','l.idUtilisateur = Factures.idLivreur','LEFT');
			$this->db->join('Clients','Clients.idClient = Factures.idClient');
            $qF = $this->db->where('idFacture',$iddf);
			$qF = $this->db->get('Factures');
		    $facture = array();
			foreach ($qF->result() as $fact) {

				$this->db->where('idTele',$fact->idTelephone);
				$qT = $this->db->get('Telephones');
				$this->db->where('idAdresse',$fact->idAdresse);
				$qA = $this->db->get('Adresses');

                array_push($facture,array('serveur' => $fact->nomUtilisateur,'nomUser' => $fact->nomUtilisateur,'numtable' => $fact->libelleTable,'numfact'=>$fact->idFacture,'payer'=>$fact->montant,'montantR'=>$fact->montantReglement,'Livreur'=>$fact->livruer,'Client'=>$fact->nomClient,'CAdresse'=>$qA->row()->Adresse,'CTel'=>$qT->row()->Telephone));
			}

			$this->db->select('DetailsFactures.idDetailFacture,DetailsFactures.prix,DetailsFactures.qte,Prestations.libellePrestation,Utilisateurs.nomUtilisateur,DetailsFactures.qteAnnulee');
			$this->db->from('DetailsFactures');
			$this->db->join('Prestations','Prestations.idPrestation = DetailsFactures.idPrestation');
			$this->db->join('Factures','Factures.idFacture = DetailsFactures.idFacture');
			$this->db->join('Utilisateurs','Factures.idUtilisateur = Utilisateurs.idUtilisateur');
			$this->db->where('DetailsFactures.idFacture',$iddf);
			$this->db->where('DetailsFactures.isAnnulee',FALSE);
			$qDFI = $this->db->get();
			$details = array();
			foreach ($qDFI->result() as $detail) {
                $qqte = $detail->qte + $detail->qteAnnulee;
				array_push($details,array('libelle' => $detail->libellePrestation,'qte' => $qqte,'prix' => $detail->prix));
				
			}
			array_push($Imprimantes,array('Societe'=>$societe,'facture'=>$facture,'PrintJob'=>$idpj,'Type' => 3,'IdFacture' => $iddf,'NomU' => 'admin','Id' => 1,'Ip' => '10.0.2.200','Port' => 9100,"Details"=>$details,));	
		$Commande = array("Commandes"=>$Imprimantes);
		return json_encode($Commande,TRUE);
	}

		private function getTicketEncaissement($iddf,$idpj){

			$Imprimantes = array();
		    $qSO = $this->db->get('Societe');
		    $societe = array();
			foreach ($qSO->result() as $soci) {
                array_push($societe,array('nom' => $soci->nomSociete,'Tel' => $soci->telSociete,'adresse' => $soci->adresseSociete));
			}
			$this->db->select('Factures.*,Tables.libelleTable,Utilisateurs.nomUtilisateur,l.nomUtilisateur as livruer,Clients.nomClient,Factures.idTelephone,Factures.idAdresse');
			$this->db->join('Tables','Tables.idTable = Factures.idTable');
			$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = Factures.idUtilisateur');
			$this->db->join('Utilisateurs l','l.idUtilisateur = Factures.idLivreur');
			$this->db->join('Clients','Clients.idClient = Factures.idClient');
            $qF = $this->db->where('idFacture',$iddf);
			$qF = $this->db->get('Factures');
		    $facture = array();
			foreach ($qF->result() as $fact) {

				$this->db->where('idTele',$fact->idTelephone);
				$qT = $this->db->get('Telephones');
				if ($qT->num_rows()>0) {
					$tel = $qT->row()->Telephone;
				}else{
                    $tel = "";
				}
				$this->db->where('idAdresse',$fact->idAdresse);
				$qA = $this->db->get('Adresses');
				if ($qA->num_rows()>0) {
					$adresse= $qA->row()->Adresse;
				}else{
					$adresse = "";
				}

                array_push($facture,array('serveur' => $fact->nomUtilisateur,'nomUser' => $fact->nomUtilisateur,'numtable' => $fact->libelleTable,'numfact'=>$fact->idFacture,'payer'=>$fact->montant,'montantR'=>$fact->montantReglement,'Livreur'=>$fact->livruer,'Client'=>$fact->nomClient,'CAdresse'=>$adresse,'CTel'=>$tel));
			}
			$this->db->select('DetailsFactures.idDetailFacture,DetailsFactures.prix,DetailsFactures.qte,Prestations.libellePrestation,Utilisateurs.nomUtilisateur');
			$this->db->from('DetailsFactures');
			$this->db->join('Prestations','Prestations.idPrestation = DetailsFactures.idPrestation');
			$this->db->join('Factures','Factures.idFacture = DetailsFactures.idFacture');
			$this->db->join('Utilisateurs','Factures.idUtilisateur = Utilisateurs.idUtilisateur');
			$this->db->where('DetailsFactures.idFacture',$iddf);
			$this->db->where('DetailsFactures.isAnnulee',FALSE);
			$qDFI = $this->db->get();
			$details = array();
			foreach ($qDFI->result() as $detail) {
				array_push($details,array('libelle' => $detail->libellePrestation,'qte' => $detail->qte,'prix' => $detail->prix));	
			}
			$reglements = array();
			$this->db->join('ModePaiements','ModePaiements.idMP = Reglements.idMP');
            $this->db->where('idFacture',$iddf);
            $this->db->order_by('dateCreation','DESC');
			$qRg = $this->db->get('Reglements');
			if ($qRg->num_rows()>0) {
				foreach ($qRg->result() as $reglement) {
					if ($reglement->idMP == 4) {
						$montantReg =0;
					}else{
						$montantReg =$reglement->montantReg;
					}
					array_push($reglements,array('montantReg'=>$montantReg,'libelleMP'=>$reglement->libelleMP));
				}
			}

			array_push($Imprimantes,array('Reglements'=>$reglements,'Societe'=>$societe,'facture'=>$facture,'PrintJob'=>$idpj,'Type' => 2,'IdFacture' => $iddf,'NomU' => 'admin','Id' => 1,'Ip' => '10.0.2.200','Port' => 9100,"Details"=>$details,));	
		$Commande = array("Commandes"=>$Imprimantes);
		return json_encode($Commande,TRUE);
	}



	public function updateQteComm($idjob,$id)
	{
		$this->db->set('etat',3);
		$this->db->where('idPrintJ',$idjob);
		if ($this->db->update('PrintJobs')) {
			$this->db->set('qteCommandee', '0');
			$this->db->where('idFacture', $id);
			return $this->db->update('DetailsFactures'); 
		}
	} 

	public function createPrintJob($idf)
	{
		$this->db->where('idFacture',$idf);
		$qF = $this->db->get('Factures');
		if($qF->row()->isPrint == 0){

			$this->db->where('DetailsFactures.idFacture',$idf);
			$this->db->where('DetailsFactures.qteCommandee <>',0);
			$qQte = $this->db->get('DetailsFactures');
			if($qQte->num_rows()>0){
				$data = array('etat'=>1,'idFacture'=>$idf,'type'=>1);
				if($this->db->insert('PrintJobs',$data)){
					$this->db->set('isPrint',TRUE);
					$this->db->where('idFacture',$idf);
					$this->db->update('Factures');
					return 'Created';
				}
			}else{
				return 'Empty';
			}

		}else{
			$this->db->where('DetailsFactures.idFacture',$idf);
			$this->db->where('DetailsFactures.qteCommandee <>',0);
			$qQte = $this->db->get('DetailsFactures');
			if($qQte->num_rows()>0){
				$data = array('etat'=>1,'idFacture'=>$idf,'type'=>1,'ajout'=>1);
				if($this->db->insert('PrintJobs',$data)){
					return 'Created';
				}
			}else{
				return 'Empty';
			}
		}
	} 




	public function createPrintJobMOBILE($idf)
	{
		$this->db->where('idFacture',$idf);
		$qF = $this->db->get('Factures');
		if($qF->row()->isPrint == 0){
			$this->db->where('DetailsFactures.idFacture',$idf);
			$this->db->where('DetailsFactures.qteCommandee <>',0);
			$qQte = $this->db->get('DetailsFactures');
			if($qQte->num_rows()>0){
				$check_num = 0;
				$data = array('etat'=>1,'idFacture'=>$idf,'type'=>1);
				if($this->db->insert('PrintJobs',$data)){
					$this->db->set('isPrint',TRUE);
					$this->db->where('idFacture',$idf);
					if($this->db->update('Factures')){
						while($check_num == 0){
							$this->db->where('DetailsFactures.idFacture',$idf);
				            $this->db->where('DetailsFactures.qteCommandee <>',0);
				            $qQte = $this->db->get('DetailsFactures');
				            $check_num = $qQte->num_rows();
						}
					}
					return 'Created';
				}
			}else{
				return 'Empty';
			}

		}else{
			$this->db->where('DetailsFactures.idFacture',$idf);
			$this->db->where('DetailsFactures.qteCommandee <>',0);
			$qQte = $this->db->get('DetailsFactures');
			if($qQte->num_rows()>0){
				$check_num = 0;
				$data = array('etat'=>1,'idFacture'=>$idf,'type'=>1,'ajout'=>1);
				if($this->db->insert('PrintJobs',$data)){
					while($check_num == 0){
						$this->db->where('DetailsFactures.idFacture',$idf);
			            $this->db->where('DetailsFactures.qteCommandee <>',0);
			            $qQte = $this->db->get('DetailsFactures');
			            $check_num = $qQte->num_rows();
					}
					return 'Created';
				}
			}else{
				return 'Empty';
			}
		}
	} 








	public function createPrintJob1($idf)
	{
			$data = array('etat'=>1,'idFacture'=>$idf,'type'=>2);
			if($this->db->insert('PrintJobs',$data)){
				return 'Created';
			}
	} 


	public function createPrintJob2($idf)
	{
			$data = array('etat'=>1,'idFacture'=>$idf,'type'=>3);
			if($this->db->insert('PrintJobs',$data)){
				return 'Created';
			}
	} 

		public function createPrintJob3($idf,$idPartenaire)
	{
			$data = array('etat'=>1,'idFacture'=>$idf,'type'=>3);
			if($this->db->insert('PrintJobs',$data)){
				$data = array('etat'=>1,'idFacture'=>$idf,'type'=>4,'idPart'=>$idPartenaire);
				if($this->db->insert('PrintJobs',$data)){
					return 'Created';
				}
				
			}
	} 


}