<?php 

defined('BASEPATH') OR exit('No direct script access allowed');

class ReglementsModel extends CI_Model
{

	public function updateFacture($idReservation,$idFacture,$date,$idUtilisateur,$reglements,$ice,$nom){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$total = 0;

		$this->db->where('idReservation',$idReservation);
		$qReservation = $this->db->get('Reservations');
		if($qReservation->num_rows()==0){ return FALSE; }
		$reservation = $qReservation->row();

		// $this->db->where('typeTax',1);
		// $qtaxes = $this->db->get('Taxes');


					$this->db->where('idFactureP',$idFacture);
					$qCReservations = $this->db->get('ChambresReservations');
					if($qCReservations->num_rows()>0){
						foreach ($qCReservations->result() as $key => $chambre) {
							$this->db->select('sum(prix) prix');
							$this->db->where('idCR',$chambre->idCR);
							$qrix = $this->db->get('DatesChambreRes');
							if($qrix->num_rows()>0){
								$total += $qrix->row()->prix;
							}
						}
					}
		$this->db->where('idFactureP',$idFacture);
		$this->db->set('idFactureP',0);
		$this->db->update('ChambresReservations');

					$this->db->where('taxIdFactureP',$idFacture);
					$qCReservations = $this->db->get('ChambresReservations');
					if($qCReservations->num_rows()>0){
						foreach ($qCReservations->result() as $key => $chambre) {
							$sj_pax = $chambre->totalAdult;
							$sj_nuits = $chambre->nuites;
							$this->db->where('idCR',$chambre->idCR); 
							$qchilds = $this->db->get('ReservationEnfants');
							if($qchilds->num_rows()>0){
								foreach ($qchilds->result() as $key => $child_age) {
									if($child_age->age >12 ){
										$sj_pax += 1;
									}
								}
							}
							$total += (11 * $sj_pax * $sj_nuits)*$reservation->changeRate; 
						}
					}
		$this->db->where('taxIdFactureP',$idFacture);
		$this->db->set('taxIdFactureP',0);
		$this->db->update('ChambresReservations');


		$this->db->where('idFactureP',$idFacture);
		$qEReservations = $this->db->get('ExtrasReservation');
		if($qEReservations->num_rows()>0){
			foreach ($qEReservations->result() as $key => $extra) {

				$total += $extra->prix;

			}
		}

		$this->db->where('idFactureP',$idFacture);
		$this->db->set('idFactureP',0);
		$this->db->update('ExtrasReservation');	


		$this->db->set('total','total-'.$total,FALSE);
	    $this->db->where('idFacture',$idFacture);
		$this->db->update('FacturesP');	

	

		if(!isset($reglements)){ 
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				return FALSE;
			} 
			else {
				$this->db->trans_commit();
				return TRUE;
			}	

		}

		$total = 0;

		foreach ($reglements as $key => $reg) {

			if ($reg['type'] == 1) {

					$totalAfter = 0;
					$this->db->where('idCR',$reg['idType']);
					$qCReservations = $this->db->get('ChambresReservations');
					if($qCReservations->num_rows()>0){
						foreach ($qCReservations->result() as $key => $chambre) {
							$sj_pax = $chambre->totalAdult;
							$sj_nuits = $chambre->nuites;
						}
					}
					$this->db->select('sum(prix) prix');
					$this->db->where('idCR',$reg['idType']);
					$qrix = $this->db->get('DatesChambreRes');
					if($qrix->num_rows()>0){
						$totalAfter += $qrix->row()->prix;
					}

					$this->db->where('idCR',$reg['idType']); 
					$qchilds = $this->db->get('ReservationEnfants');
					if($qchilds->num_rows()>0){
						foreach ($qchilds->result() as $key => $child_age) {

							if($child_age->age >12 ){
									$sj_pax += 1;
							}
						}
					}
					$taxSejour = (11 * $sj_pax * $sj_nuits)*$reservation->changeRate; 
					if($reg['methode'] == 1){
						if($reg['tax'] == 1){
							$total += $taxSejour;
						}else{
							$total += $totalAfter;
						}
					}
					if($reg['tax'] == 1){
							$this->db->set('taxIdFactureP',$idFacture);
							$this->db->where('isNoshow',FALSE);
							$this->db->where('isCanceled',FALSE);
							$this->db->where('idCR',$reg['idType']);
					       	$this->db->update('ChambresReservations');
					}else{
							$this->db->set('idFactureP',$idFacture);
							$this->db->where('isNoshow',FALSE);
							$this->db->where('isCanceled',FALSE);
							$this->db->where('idCR',$reg['idType']);
					       	$this->db->update('ChambresReservations');
					}

			}else{



				$this->db->where('idExtraRes',$reg['idType']);
				$qEReservations = $this->db->get('ExtrasReservation');
				if($qEReservations->num_rows()>0){
					foreach ($qEReservations->result() as $key => $extra) {
						$total += $extra->prix;
					}
				}

				//echo $idFacture; print FALSE;

				$this->db->set('idFactureP',$idFacture);
				$this->db->where('idExtraRes',$reg['idType']);
				$this->db->update('ExtrasReservation');	

				//echo $this->db->last_query();

			}				

		}


		$this->db->set('nom',$nom);
		$this->db->set('ice',$ice);
		$this->db->set('total','total+'.$total,FALSE);
	    $this->db->where('idFacture',$idFacture);
		$this->db->update('FacturesP');	


	    $this->db->set('idATA',13);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifie une facture {{idFacture:'.$idFacture.'}}');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return FALSE;
		} 
		else {
			$this->db->trans_commit();
			return TRUE;
		}	

	}

	public function getFactureChambre($idcr,$sj_pax,$sj_nuits,$changeRate){

		$totalAfter = 0;
		$sj_pax = $sj_pax;
		$this->db->select('sum(prix) prix');
		$this->db->where('idCR',$idcr);
		$qrix = $this->db->get('DatesChambreRes');
		if($qrix->num_rows()>0){
			$totalAfter += $qrix->row()->prix;
		}
		$this->db->where('idCR',$idcr); 
		$qchilds = $this->db->get('ReservationEnfants');
		if($qchilds->num_rows()>0){
			foreach ($qchilds->result() as $key => $child_age) {

				if($child_age->age >12 ){
					$sj_pax += 1;
				}
			}
		}
		$taxSejour = (11 * $sj_pax * $sj_nuits)*$changeRate; 

		return array('taxSejour'=>$taxSejour,'totalAfter'=>$totalAfter,'sj_pax'=>$sj_pax);
	}

	public function supprimerFacture($idFacture,$idReservation,$idUtilisateur){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 


        $this->db->where('idFacture',$idFacture);
		$qRegle = $this->db->get('Reglements');

		if($qRegle->num_rows()>0){return FALSE;}



		$this->db->set('idFactureP',0);
		$this->db->where('idFactureP',$idFacture);
		$this->db->update('ChambresReservations');

		$this->db->set('taxIdFactureP',0);
		$this->db->where('taxIdFactureP',$idFacture);
		$this->db->update('ChambresReservations');


		$this->db->set('idFactureP',0);
		$this->db->where('idFactureP',$idFacture);
		$this->db->update('ExtrasReservation');


		$this->db->where('idFacture',$idFacture);
		$this->db->delete('FacturesP');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function insert($idReservation,$idUtilisateur,$total,$date,$idFacture,$idModePaimenet){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->where('idReservation',$idReservation);
		$qReservation = $this->db->get('Reservations');

		if($qReservation->num_rows()==0){ return FALSE;}

		$this->db->where('idFacture',$idFacture);
		$qFactures = $this->db->get('FacturesP');

		if($qFactures->num_rows()==0){ return FALSE;}

		$totalResa = $total * $qReservation->row()->changeRate;

		$total = (number_format($totalResa,2) == number_format($qFactures->row()->total,2)) ? $qFactures->row()->total : $totalResa;

		if(number_format($totalResa,2) == number_format($qFactures->row()->total,2)){

			$this->db->set('totalRegle','prix',FALSE); 	
			$this->db->where('idFactureP',$idFacture); 
			$this->db->update('ChambresReservations');

			$this->db->set('totalRegle','prix',FALSE); 	
			$this->db->where('idFactureP',$idFacture); 
			$this->db->update('ExtrasReservation');

		}

		$this->db->set('date',$date); 	
		$this->db->set('idFacture',$idFacture); 		
		$this->db->set('total',$total); 	
		$this->db->set('idModePaimenet',$idModePaimenet); 
		$this->db->insert('Reglements');

		$this->db->set('totalRegle','totalRegle +'.$total,FALSE); 	
		$this->db->where('idFacture',$idFacture); 
		$this->db->update('FacturesP');

		$this->db->set('totalPaye','totalPaye +'.$total,FALSE); 	
		$this->db->where('idReservation',$idReservation); 
		$this->db->update('Reservations');

		$this->db->set('idATA',9);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a regler la facture{{idFacture:'.$idFacture.'}} montant {{montant:'.$total.'}}');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete(); 

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
		
	}

	public function supprimerReglement($idReglement,$idReservation,$idUtilisateur){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->where('idReglement',$idReglement);
		$qReglement = $this->db->get('Reglements');

		if($qReglement->num_rows()==0){ return FALSE;}

		$this->db->set('totalRegle','totalRegle - '.$qReglement->row()->total,FALSE);
		$this->db->where('idFacture',$qReglement->row()->idFacture);
		$this->db->update('FacturesP');

		$this->db->set('totalPaye','totalPaye - '.$qReglement->row()->total,FALSE);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->where('idReglement',$idReglement);
		$this->db->delete('Reglements');


		$this->db->set('totalRegle',0); 	
		$this->db->where('idFactureP',$qReglement->row()->idFacture); 
		$this->db->update('ChambresReservations');

		$this->db->set('totalRegle',0); 	
		$this->db->where('idFactureP',$qReglement->row()->idFacture); 
		$this->db->update('ExtrasReservation');


		$this->db->set('idATA',16);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a supprimer le reglement {{idReglement:'.$idReglement.'}}');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function getFactures(){

		$this->db->join('Reservations','Reservations.idReservation = Factures.idReservation');
		return $this->db->get('Factures')->result_array();

	}

	public function getReglements($idFacture){

		$this->db->select("ChambresReservations.idCR idType, '1' type");
		$this->db->where('ChambresReservations.idFactureP',$idFacture);
		$query1 =$this->db->get_compiled_select('ChambresReservations');

		$this->db->select("ChambresReservations.idCR idType, '3' type");
		$this->db->where('ChambresReservations.taxIdFactureP',$idFacture);
		$query2 =$this->db->get_compiled_select('ChambresReservations');

		$this->db->select("ExtrasReservation.idExtraRes idType,'2' type");
		$this->db->where('ExtrasReservation.idFactureP',$idFacture);
		$query3 =$this->db->get_compiled_select('ExtrasReservation');

    	return $this->db->query($query1." UNION ".$query2." UNION ".$query3)->result_array();
    	echo $this->db->last_query();

	}


	public function getReglement($idReservation){

		$this->db->join('ModePaiements','ModePaiements.idModePaimenet = Reglements.idModePaimenet');
		$this->db->where('idReservation',$idReservation);
		
		return $this->db->get('Reglements')->result_array();

	}

	public function getReglementsFacture($idFacture){

		$this->db->where('idFacture',$idFacture);	
		return $this->db->get('Reglements')->result_array();

	}


	public function createFacture($idReservation,$date,$idUtilisateur,$reglements,$ice,$nom){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$total = 0;

		$this->db->where('idReservation',$idReservation);
		$qReservation = $this->db->get('Reservations');
		if($qReservation->num_rows()==0){ return FALSE; }
			$reservation = $qReservation->row();

			$this->db->where('typeTax',1);
			$qtaxes = $this->db->get('Taxes');

			if(count($reglements) == 0){ return FALSE; }

			foreach ($reglements as $key => $reg) {

				if ($reg['type'] == 1) {
					$totalAfter = 0;
					$this->db->where('idCR',$reg['idType']);
					$qCReservations = $this->db->get('ChambresReservations');
					if($qCReservations->num_rows()>0){
						foreach ($qCReservations->result() as $key => $chambre) {
							$sj_pax = $chambre->totalAdult;
							$sj_nuits = $chambre->nuites;
						}
					}
					$this->db->select('sum(prix) prix');
					$this->db->where('idCR',$reg['idType']);
					$qrix = $this->db->get('DatesChambreRes');
					if($qrix->num_rows()>0){
						$totalAfter += $qrix->row()->prix;
					}

					$this->db->where('idCR',$reg['idType']); 
					$qchilds = $this->db->get('ReservationEnfants');
					if($qchilds->num_rows()>0){
						foreach ($qchilds->result() as $key => $child_age) {

							if($child_age->age >12 ){
									$sj_pax += 1;
							}
						}
					}
					$taxSejour = (11 * $sj_pax * $sj_nuits)*$reservation->changeRate; 
					if($reg['methode'] == 1){
						if($reg['tax'] == 1){
							$total += $taxSejour;
						}else{
							$total += $totalAfter;
						}
					}
				}else{
					if($reg['methode'] == 1){
						$this->db->where('idExtraRes',$reg['idType']);
						$qEReservations = $this->db->get('ExtrasReservation');
						if($qEReservations->num_rows()>0){
							foreach ($qEReservations->result() as $key => $extra) {
								$total += $extra->prix;
							}
						}
					}		
				}
			}
			$this->db->set('total',$total);
			$this->db->set('nom',$nom);
			$this->db->set('ice',$ice);
			$this->db->set('dateFacture',$date);
	        $this->db->set('idReservation',$idReservation);
			$this->db->insert('FacturesP');	

			$idFature = $this->db->insert_id();
			foreach ($reglements as $key => $reg) {

				if ($reg['type'] == 1) {
					if($reg['methode'] == 1){

						if($reg['tax'] == 1){
							$this->db->set('taxIdFactureP',$idFature);
							$this->db->where('isNoshow',FALSE);
							$this->db->where('isCanceled',FALSE);
							$this->db->where('idCR',$reg['idType']);
					       	$this->db->update('ChambresReservations');
						}else{
							$this->db->set('idFactureP',$idFature);
							$this->db->where('isNoshow',FALSE);
							$this->db->where('isCanceled',FALSE);
							$this->db->where('idCR',$reg['idType']);
					       	$this->db->update('ChambresReservations');
						}
					}
				}else{
					if($reg['methode'] == 1){

				       	$this->db->set('idFactureP',$idFature);
						$this->db->where('isCanceled',FALSE);
						$this->db->where('idExtraRes',$reg['idType']);
				       	$this->db->update('ExtrasReservation');	
					}
				}				

			}

	       	$this->db->set('idATA',13);
			$this->db->set('idUtilisateur',$idUtilisateur);
			$this->db->set('id',$idReservation);
			$this->db->set('description',' a creer une facture {{idFacture:'.$idFature.'}}');
			$this->db->insert('ActivitesUtilisateur');

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    return FALSE;
			} 
			else {
			    $this->db->trans_commit();
			    return TRUE;
			}			
	}

	public function createFactureMaster($idReservation,$date,$idUtilisateur,$ice,$nom){

		$this->db->trans_start(); 
		$this->db->trans_strict(TRUE); 

		$total = 0;

		$this->db->where('idReservation',$idReservation);
		$qReservation = $this->db->get('Reservations');
		if($qReservation->num_rows()>0){
			$reservation = $qReservation->row();

			$this->db->where('typeTax',1);
			$qtaxes = $this->db->get('Taxes');

			$this->db->where('idFactureP',0);
			$this->db->where('idReservation',$idReservation);
			$qCReservations = $this->db->get('ChambresReservations');
			if($qCReservations->num_rows()>0){
				foreach ($qCReservations->result() as $key => $chambre) {

					$total += $chambre->prix;

				}
			}

			$this->db->where('idFactureP',0);
			$this->db->where('idReservation',$idReservation);
			$qEReservations = $this->db->get('ExtrasReservation');
			if($qEReservations->num_rows()>0){
				foreach ($qEReservations->result() as $key => $extra) {
					$total += $extra->prix;
				}
			}

			$totalAfter = 0;
			$sj_pax = 0;
			$sj_nuits = 0;

			$this->db->where('idReservation',$idReservation);
			$this->db->where('isCanceled',false);
			$this->db->where('isNoshow',false);
			$queryCR = $this->db->get('ChambresReservations');
			if($queryCR->num_rows()>0){

				foreach ($queryCR->result() as $key => $cr) {
					$sj_pax +=$cr->totalAdult;
					$sj_nuits +=$cr->nuites;

					$this->db->select('sum(prix) prix');
					$this->db->where('idCR',$cr->idCR);
					$qrix = $this->db->get('DatesChambreRes');
					if($qrix->num_rows()>0){
						 $totalAfter += $qrix->row()->prix;
					}

					$this->db->where('idCR',$cr->idCR); 
					$qchilds = $this->db->get('ReservationEnfants');
					if($qchilds->num_rows()>0){
						foreach ($qchilds->result() as $key => $child_age) {

							if($child_age->age >12 ){
								$sj_pax += 1;
							}
						}
					}			

				}
			}

			$this->db->where('idReservation',$idReservation);
			$this->db->where('isCanceled',false);
			$queryEx = $this->db->get('ExtrasReservation');
			if($queryEx->num_rows()>0){
				foreach ($queryEx->result() as $key => $extra) {

					$totalAfter += $extra->prix;

				}
			}
			$taxSejour = (11 * $sj_pax * $sj_nuits)*$qReservation->row()->changeRate;	

			$TotalTTC = $taxSejour+$totalAfter;

			$this->db->set('total',$TotalTTC);
			$this->db->set('nom',$nom);
			$this->db->set('ice',$ice);
			$this->db->set('dateFacture',$date);
	        $this->db->set('idReservation',$idReservation);
			$this->db->insert('FacturesP');	

			$idFature = $this->db->insert_id();

			$this->db->set('idFactureP',$idFature);
			$this->db->set('taxIdFactureP',$idFature);
			$this->db->where('isNoshow',FALSE);
			$this->db->where('isCanceled',FALSE);
			$this->db->where('idFactureP',0);
			$this->db->where('idReservation',$idReservation);
	       	$this->db->update('ChambresReservations');

	       	$this->db->set('idFactureP',$idFature);
			$this->db->where('isCanceled',FALSE);
			$this->db->where('idFactureP',0);
			$this->db->where('idReservation',$idReservation);
	       	$this->db->update('ExtrasReservation');

	       	$this->db->set('idATA',13);
			$this->db->set('idUtilisateur',$idUtilisateur);
			$this->db->set('id',$idReservation);
			$this->db->set('description',' a creer une facture {{idFacture:'.$idFature.'}}');
			$this->db->insert('ActivitesUtilisateur');

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    return FALSE;
			} 
			else {
			    $this->db->trans_commit();
			    return TRUE;
			}			

		}else{
			return FALSE;
		}

	}

}