<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class ReservationsModel extends CI_Model
{


	public function rapportModesPaiements(){

		$this->db->select('ModePaiements.*,IFNULL(SUM(Reglements.total),0) tot');
		$this->db->join('Reglements','Reglements.idModePaimenet = ModePaiements.idModePaimenet','LEFT');
		$this->db->where('ModePaiements.idModePaimenet !=',0);
		$this->db->group_by('ModePaiements.idModePaimenet');
		$this->db->order_by('tot','DESC');
		return $this->db->get('ModePaiements')->result_array();

	}

	public function getReservationEnfant($idCR){
		$sj_pax = 0;
		$this->db->where('idCR',$idCR); 
		$qchilds = $this->db->get('ReservationEnfants');
		if($qchilds->num_rows()>0){
			foreach ($qchilds->result() as $key => $child_age) {

				if($child_age->age >12 ){

					$sj_pax += 1;

				}
			}
		}	
		return $sj_pax;
	}

	public function rapportFactureInstance(){



		$this->db->join('Reservations','Reservations.idReservation = FacturesP.idReservation');
		$this->db->where('FacturesP.totalRegle != FacturesP.total');
		return $this->db->get('FacturesP')->result_array();

	}

	public function rapportClientsParChambre($date){

		$this->db->select('ChambresReservations.idReservation,Chambres.nomChambre,ChambresReservations.dateDu,ChambresReservations.dateAu,TypesChambres.nomTypeChambres,TypesChambres.nomTypeChambres,Reservations.channel,Reservations.client,Pensions.codePension,DatesChambreRes.prix,Reservations.changeRate');

		$this->db->join('ChambresReservations','DatesChambreRes.idCR = ChambresReservations.idCR AND ChambresReservations.isCanceled = 0 AND ChambresReservations.isCanceled = 0');

		$this->db->join('Reservations','Reservations.idReservation = ChambresReservations.idReservation');

		$this->db->join('Chambres',"Chambres.idChambres = ChambresReservations.idChambres");

		$this->db->join('ChambresTypesChambre',"Chambres.idChambres = ChambresTypesChambre.idChambres AND master = 1");

		$this->db->join('TypesChambres',"ChambresTypesChambre.idTypeChambres = TypesChambres.idTypeChambres");

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('DatesChambreRes.date=',$date);

		$this->db->order_by('Chambres.nomChambre');

		return $this->db->get('DatesChambreRes')->result_array();

	}


	public function getFactureDetailsProv($idFacture=15){


		$this->db->join('Reservations','Reservations.idReservation = FacturesP.idReservation');
		$this->db->where('idFacture',$idFacture);
		$qFacture = $this->db->get('FacturesP')->result_array();

		foreach ($qFacture as $key => $facture) {

			$this->db->select('DatesChambreRes.prix,DatesChambreRes.date,CONCAT(TypesChambres.nomTypeChambres," + ",Pensions.codePension) extra,"1" type,ChambresReservations.idCR id,ChambresReservations.totalAdult pax,ChambresReservations.taxIdFactureP,idFactureP,nuites');
			$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');
			$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelTarifs.idTypeChambres','LEFT');
			$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR','LEFT');
			$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');
			$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');
			$this->db->where('idFactureP',$idFacture);
			$this->db->or_where('taxIdFactureP',$idFacture);

			$query1 = $this->db->get_compiled_select('ChambresReservations');


			$this->db->select('ExtraResDates.prix,ExtraResDates.date,Extras.extra,"2" type,ExtrasReservation.idExtraRes id,ExtraResDates.pax,ExtraResDates.pax,idFactureP,ExtraResDates.pax');
			$this->db->join('Extras','Extras.idExtra = ExtrasReservation.idExtra');

			$this->db->join('ExtraResDates','ExtraResDates.idExtraRes = ExtrasReservation.idExtraRes','LEFT');

			$this->db->where('idFactureP',$idFacture);

			$query2 =$this->db->get_compiled_select('ExtrasReservation');

    	  	$details = $this->db->query($query1." UNION ".$query2.' ORDER BY date')->result_array();

    	  	// echo $this->db->last_query();
    	  	// die;



			$qFacture[$key]['details'] = $details;

		}
		return $qFacture;

	}

	public function getFactureDetails($idFacture=51){


		$this->db->join('Reservations','Reservations.idReservation = Factures.idReservation');
		$this->db->where('idFacture',$idFacture);
		$qFacture = $this->db->get('Factures')->result_array();

		foreach ($qFacture as $key => $facture) {



			$this->db->select('DetailsFacture.*,IF(Extras.idPension = 0,Extras.extra,CONCAT(TypesChambres.nomTypeChambres," + ",Pensions.codePension)) extra');	
			$this->db->join('Extras','Extras.idExtra = DetailsFacture.idExtra');	
			$this->db->join('ChambresReservations','ChambresReservations.idCR = DetailsFacture.idCR','LEFT');
			$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');
			$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelTarifs.idTypeChambres','LEFT');
			$this->db->join('Pensions','Pensions.idPension = Extras.idPension','LEFT');
			$this->db->where('idFacture',$idFacture);	

			$this->db->order_by('date');
			$details = $this->db->get('DetailsFacture')->result_array();

			$qFacture[$key]['details'] = $details;



		}
		return $qFacture;

	}

	public function getChambresLibreType($idCR){

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif');
		$this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelTarifs.idTypeChambres');
		$this->db->where('ChambresReservations.idCR',$idCR);
		$qRess = $this->db->get('ChambresReservations');
		//echo $str = $this->db->last_query();

		if($qRess->num_rows()==0){ return FALSE;}

		$dated = $qRess->row()->dateDu;
		$datef = $qRess->row()->dateAu;
		$idTypeChambre = $qRess->row()->idTypeChambres;

		$this->db->select('Chambres.idChambres,DateAu checkout,dateDu,ChambresTypesChambre.idTypeChambres,Chambres.nomChambre,ChambresReservations.providerId,TypesChambres.codeChambre,ChambresReservations.idReservation');

		$this->db->join('ChambresTypesChambre',"Chambres.idChambres = ChambresTypesChambre.idChambres");

		$this->db->join('TypesChambres',"ChambresTypesChambre.idTypeChambres = TypesChambres.idTypeChambres");

		$this->db->join('ChambresReservations',"Chambres.idChambres = ChambresReservations.idChambres AND DateAu > '".$dated."' AND dateDu <= '".$datef."'",'LEFT');

		$this->db->group_by('Chambres.idChambres');

		return $this->db->get('Chambres')->result_array();

		echo $str = $this->db->last_query();
	}

	public function getChambresDelogerType($idCR){

		$this->db->where('ChambresReservations.idCR',$idCR);
		$qRess = $this->db->get('ChambresReservations');
		//echo $str = $this->db->last_query();

		if($qRess->num_rows()==0){ return FALSE;}

		$dated = $qRess->row()->dateDu;
		$datef = $qRess->row()->dateAu;


		$this->db->select('Chambres.idChambres,DateAu checkout,dateDu,ChambresTypesChambre.idTypeChambres,Chambres.nomChambre,ChambresReservations.providerId,TypesChambres.codeChambre,ChambresReservations.idReservation');

		$this->db->join('ChambresTypesChambre',"Chambres.idChambres = ChambresTypesChambre.idChambres AND master = 1");

		$this->db->join('TypesChambres',"ChambresTypesChambre.idTypeChambres = TypesChambres.idTypeChambres");

		$this->db->join('ChambresReservations',"Chambres.idChambres = ChambresReservations.idChambres AND DateAu > '".$dated."' AND dateDu <= '".$datef."'",'LEFT');

		$this->db->group_by('Chambres.idChambres');
		
		return $this->db->get('Chambres')->result_array();
		echo $str = $this->db->last_query();
	}


	public function modifierReglement($idReglement,$idReservation,$idUtilisateur,$prix,$mdp){

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->where('idReglement',$idReglement);
		$qReglement = $this->db->get('Reglements');

		if($qReglement->num_rows()==0){ return FALSE;}

		$pp = $qReglement->row()->total - $prix ;

		$this->db->set('totalRegle','totalRegle - '.$pp,FALSE);
		$this->db->where('idFacture',$qReglement->row()->idFacture);
		$this->db->update('FacturesP');

		

		$this->db->set('totalPaye','totalPaye - '.$pp,FALSE);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');


		$this->db->set('idModePaimenet',$mdp);
		$this->db->set('total',$prix);
		$this->db->where('idReglement',$idReglement);
		$this->db->update('Reglements');

		$this->db->set('idATA',17);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifier le reglement {{idReglement:'.$idReglement.'}}');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}



	public function getFacture($idFacture){


		$this->db->select("FacturesP.idFacture,IFNULL(Reglements.date,'-') date,IFNULL(Reglements.total,0) total,Reglements.idReglement,IFNULL(idModePaimenet,444) idModePaimenet,FacturesP.idReservation,FacturesP.nom,FacturesP.total totalFacture,FacturesP.totalRegle,FacturesP.ice");

		$this->db->join('Reglements','Reglements.idFacture = FacturesP.idFacture','LEFT');
		$this->db->where('FacturesP.idFacture',$idFacture);
		return $this->db->get('FacturesP')->result_array();

	}

	public function rapportJournalier($dated,$datef){

		$this->db->select('IFNULL(SUM(DetailsFacture.qte),0) tot,SUM(DetailsFacture.prix*(1/IFNULL(Reservations.changeRate,1))) totn,Extras.extra');


		$this->db->join('DetailsFacture',"Extras.idExtra = DetailsFacture.idExtra",'LEFT');
		$this->db->join('Reservations','Reservations.idReservation = DetailsFacture.idReservation','LEFT');


        $this->db->where('Extras.idDeduction>0');
        $this->db->group_by('Extras.idExtra');
		return $this->db->get('Extras')->result_array();

	}
	public function rapportJournalierD($dated,$datef){

		$this->db->select('IFNULL(SUM(DetailsFacture.qte),0)  tot,SUM(DetailsFacture.prix*(1/IFNULL(Reservations.changeRate,1))) totn,Extras.extra');

		$this->db->join('DetailsFacture',"Extras.idExtra = DetailsFacture.idExtra",'LEFT');
		$this->db->join('Reservations','Reservations.idReservation = DetailsFacture.idReservation','LEFT');

        $this->db->where('Extras.idDeduction',0);
        $this->db->group_by('Extras.idExtra');
		return $this->db->get('Extras')->result_array();

	}

	public function isertRoomToReservation($idReservation,$etat,$etatReservation,$isModified,$sousTotal,$Total,$dateDu,$dateAu,$updatedAt,$dates,$adult,$child,$totalch,$nights,$idChanTarif,$client,$isCheckin,$prix,$idChambres,$providerId,$checkin_date,$checkout_date,$total_guests,$total_rooms,$idUtilisateur,$canceled=false){

		$this->db->trans_start(); # Starting Transaction

		$this->db->trans_strict(TRUE);


		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return FALSE; }

		$totpax = $adult + $child;
		$etat = 'confirm';
		$extra_info = '';
		$meal_plan = '';
		$meal_plan_presentation = '';
		$remboursable = 1;

		$this->db->set('idReservation',$idReservation);
		$this->db->set('providerId',$providerId);
		$this->db->set('prix',$prix);
		$this->db->set('remboursable',$remboursable);
		$this->db->set('dateDu',$checkin_date);
		$this->db->set('dateAu',$checkout_date);
		$this->db->set('nuites',$nights);
		$this->db->set('idTarif',$idChanTarif);
		$this->db->set('idChambre',$idChanTarif);
		$this->db->set('totalPax',$totpax);
		$this->db->set('totalAdult',$adult);
		$this->db->set('totalEnfant',$child);
		$this->db->set('etat',$etat);
		$this->db->set('extraInfo',$extra_info);
		$this->db->set('meal_plan',$meal_plan);
		$this->db->set('meal_plan_presentation',$meal_plan_presentation);
		$this->db->set('name',$client);
		$this->db->set('isCheckin',$isCheckin);
		$this->db->set('idChambres',$idChambres);
		$this->db->set('isCanceled',$canceled);

		$this->db->insert('ChambresReservations');

		$idCR = $this->db->insert_id();
		foreach ($dates as $key => $date) {

			$this->db->set('idReservation',$idReservation);
			$this->db->set('providerId',$providerId);
			$this->db->set('idCR',$idCR);
			$this->db->set('date',$date['date']);
			$this->db->set('prix',$date['prix']);
			$this->db->set('idTarif',$idChanTarif);

			$this->db->insert('DatesChambreRes');
		}

		$taxSejour = (11 * $adult * $nights)*$reservation->row()->changeRate;	

		$TotalTTC = $taxSejour+$prix;

		$this->db->set('Total','Total+'.$TotalTTC,FALSE);
		$this->db->set('sousTotal','sousTotal+'.$TotalTTC,FALSE);
		$this->db->set('taxTotal','taxTotal+'.$taxSejour,FALSE);
		$this->db->set('totalHT','totalHT+'.$prix,FALSE);


		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);

		
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('isCheckout',false);
		$this->db->set('isCheckin',false);

		$this->db->set('total_guests',$total_guests);
		$this->db->set('total_rooms',$total_rooms);


		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('isRead',0);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');




		$this->db->set('idATA',15);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a ajouter la chambre {{idCR:'.$idCR.'}}');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function getFacturesRegele($idReservation){

		$this->db->select('sum(FacturesP.totalRegle) totreg');
		$this->db->where('FacturesP.idReservation',$idReservation);
		$qTotalR = $this->db->get('FacturesP');
		return ($qTotalR->num_rows()>0) ? $qTotalR->row()->totreg: 0;

	}


	public function getFactures($idReservation){

		$this->db->select('FacturesP.*');

		// $this->db->join('Reglements','Reglements.idFacture = Factures.idFacture','LEFT');
		// $this->db->join('ModePaiements','Reglements.idModePaimenet = ModePaiements.idModePaimenet','LEFT');
		$this->db->where('FacturesP.idReservation',$idReservation);
		return $this->db->get('FacturesP')->result_array();
	}

	public function getReglements($idFacture){

		$this->db->join('ModePaiements','Reglements.idModePaimenet = ModePaiements.idModePaimenet','LEFT');
		$this->db->where('Reglements.idFacture',$idFacture);
		return  $this->db->get('Reglements')->result_array();

	}

	public function checkReservationReglement($idReservation){


		$this->db->where('idReservation',$idReservation);
		$qResa = $this->db->get('Reservations');
		//var_dump(number_format($qResa->row()->Total,2),number_format($qResa->row()->totalPaye,2));
		if(number_format($qResa->row()->totalHT+$qResa->row()->taxTotal,2) == number_format($qResa->row()->totalPaye,2)){
			return true;
		}else{
			return false;
		}

	}


	public function setCheckout($idCR,$idReservation,$date,$idUtilisateur,$type = true){


		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 


		$this->db->where('idCR',$idCR);
		$qChambre = $this->db->get('ChambresReservations');

		if($qChambre->num_rows() == 0){ return FALSE;}

		$this->db->set('isCheckout',true);
		if($type){
			$this->db->where('idCR',$idCR);
		}else{
			$this->db->where('idReservation',$idReservation);
		}
		$this->db->update('ChambresReservations');

		$this->db->where('idReservation',$idReservation);
		$qFactureP = $this->db->get('FacturesP');
		if($qFactureP->num_rows() == 0){ return FALSE;}
		foreach ($qFactureP->result() as $key => $facture) {

			$this->db->set('idReservation',$facture->idReservation);
			$this->db->set('ice',$facture->ice);
			$this->db->set('nom',$facture->nom);
			$this->db->set('total',$facture->total);
			$this->db->set('totalRegle',$facture->totalRegle);
			$this->db->set('dateFacture',$facture->dateFacture);
			$this->db->insert('Factures');


			$idFacture = $this->db->insert_id();

			$this->db->where('idFacture',$facture->idFacture);
			$this->db->set('idFacture',$idFacture);
			$this->db->update('Reglements');



			$this->db->where('idFactureP',$facture->idFacture);
			$rchambres = $this->db->get('ChambresReservations');
			if($rchambres->num_rows() > 0){
				foreach ($rchambres->result() as $key => $ch) {

					$this->db->where('idCR',$ch->idCR);
					$this->db->set('idFacture',$idFacture);
					$this->db->update('DetailsFacture');

				}
			}

			$this->db->where('idFactureP',$facture->idFacture);
			$rextras = $this->db->get('ExtrasReservation');
			if($rextras->num_rows() > 0){
				foreach ($rextras->result() as $key => $ex) {

					$this->db->where('idExtraRes',$ex->idExtraRes);
					$this->db->set('idFacture',$idFacture);
					$this->db->update('DetailsFacture');
				}

			}
		}

		$this->db->where('idReservation',$idReservation);
		$this->db->where('isCheckout',false);
		$rCheckout = $this->db->get('ChambresReservations');
		if($rCheckout->num_rows()==0){
			$this->db->set('isCheckout',true);
			$this->db->where('idReservation',$idReservation);
			$this->db->update('Reservations');			

		}

		if($type){
			$this->db->set('idATA',11);		
			$this->db->set('id',$idReservation);
		}else{
			$this->db->set('idATA',12);		
			$this->db->set('id',$idReservation);
		}
		$this->db->set('description',' a checkout la chambre {{idCR:'.$idCR.'}}.');	
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete();
		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function cancel($idReservation,$updatedAt,$idUtilisateur,$raison=''){

		$this->db->trans_start(); # Starting Transaction

		$this->db->trans_strict(TRUE);

		$this->db->set('etat','cancel');
		$this->db->set('etatReservation','canceled');

		$this->db->set('sousTotal',0);
		$this->db->set('Total',0);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('raisonAnnulation',$raison);
		$this->db->set('isCanceled',true);
		$this->db->set('isRead',0);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');
			
		$this->db->set('prix',0);
		$this->db->set('etat','cancel');
		$this->db->set('isCanceled',true);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('ChambresReservations');


		$this->db->set('idATA',5);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a annuler la reservation {{idReservation:'.$idReservation.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete(); # Completing transaction

		if ($this->db->trans_status() === FALSE) {
		    # Something went wrong.
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    # Everything is Perfect. 
		    # Committing data to the database.
		    $this->db->trans_commit();
		    return TRUE;
		}
	}
	
	public function updateReservation($idReservation,$etat,$etatReservation,$isModified,$sousTotal,$total,$dateDu,$dateAu,$updatedAt,$rooms,$client ,$data_cli ,$tel ,$email ,$adresse ,$ville ,$idPays ,$note,$idUtilisateur,$canceled=false){

		$this->db->trans_start(); # Starting Transaction

		$this->db->trans_strict(TRUE);

		if($data_cli == 0){

				$this->db->set('nom',$client);
				$this->db->set('Adresse',$adresse);
				$this->db->set('ville',$ville);
				$this->db->set('idPays',$idPays);
				$this->db->set('tel',$tel);
				$this->db->set('email',$email);
				$this->db->insert('Cardex');
				$idCardex = $this->db->insert_id();



		}else{

				$idCardex =$data_cli;
				$this->db->set('Adresse',$adresse);
				$this->db->set('ville',$ville);
				$this->db->set('idPays',$idPays);
				$this->db->set('tel',$tel);
				$this->db->set('email',$email);
				$this->db->where('idCardex',$idCardex);
				$this->db->update('Cardex');		
		}



		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('client',$client);
		if(count($rooms)>0){
			$this->db->set('sousTotal',$sousTotal);
			$this->db->set('Total',$total);
		}
		$this->db->set('note',$note);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('idCardex',$idCardex);
		$this->db->set('isRead',0);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');


		// $this->db->where('idCR',$idCR);
		// $this->db->delete('ChambresReservations');

		if(count($rooms)>0){
			$this->db->where('idReservation',$idReservation);
			$this->db->set('isCanceled',false);
			$this->db->delete('DatesChambreRes');
			foreach ($rooms as $key => $room) {
			

				$totpax = $room['adult'] + $room['child'];
				$etat = 'modify';

				$this->db->set('prix',$room['totalch']);
				$this->db->set('dateDu',$room['dateDu']);
				$this->db->set('dateAu',$room['dateAu']);
				$this->db->set('nuites',$room['nights']);
				$this->db->set('idTarif',$room['idChannelTarif']);
				$this->db->set('idChambre',$room['idChannelTarif']);
				$this->db->set('totalPax',$totpax);
				$this->db->set('totalAdult',$room['adult']);
				$this->db->set('totalEnfant',$room['child']);
				$this->db->set('etat',$etat);

				$this->db->where('idCR',$room['idCR']);

				$this->db->update('ChambresReservations');
				
					foreach ($room['dates'] as $key => $date) {

						$this->db->set('idReservation',$idReservation);
						$this->db->set('providerId',$room['providerId']);
						$this->db->set('idCR',$room['idCR']);
						$this->db->set('date',$date['date']);
						$this->db->set('prix',$date['prix']);
						$this->db->set('idTarif',$room['idChannelTarif']);
						$this->db->insert('DatesChambreRes');
				    }
			}

		}

		$this->db->set('idATA',4);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifier la reservation {{idReservation:'.$idReservation.'}}.');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete(); # Completing transaction

		if ($this->db->trans_status() === FALSE) {
		    # Something went wrong.
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    # Everything is Perfect. 
		    # Committing data to the database.
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function getSearchReservations($filters){

		// $this->db->select('r.*');

		// $this->db->where('r.isArchive',false);

		// $this->db->like('r.providerId',$filters, 'both'); 
		// $this->db->order_by('r.updatedAt','DESC');

		// return $this->db->get('Reservations r')->result_array();
		// echo $this->db->last_query(); die;




		$this->db->select('r.*');

		$this->db->where('r.isArchive',false);

		$this->db->like('r.providerId',$filters, 'both'); 

		$query1 =$this->db->get_compiled_select('Reservations r');


		$this->db->select('r.*');

		$this->db->where('r.isArchive',false);

		$this->db->like('r.client',$filters, 'both'); 

		$query2 =$this->db->get_compiled_select('Reservations r');



    	return  $this->db->query($query1." UNION ".$query2.' GROUP BY providerId ORDER BY updatedAt DESC')->result_array();


	}


	public function caneclRoom($idReservation,$idCR,$idUtilisateur){


		$this->db->trans_start(); # Starting Transaction

		$this->db->trans_strict(TRUE);

		// $this->db->where('idReservation',$idReservation);
		// $this->db->limit(1);
		// $resarvation = $this->db->get('Reservations');

		$this->db->where('idCR',$idCR);
		$this->db->limit(1);
		$queryy = $this->db->get('ChambresReservations');
		if($queryy->num_rows()==0){ return false; }

		// $prix =  $queryy->row()->prix;

		$prix =  $queryy->row()->prix;
		$totalPax =  $queryy->row()->totalPax;

		$this->db->where('idCR',$idCR);
		$this->db->set('etat','canceled');
		$this->db->set('prix',0);
		$this->db->set('isCanceled',true);
		$this->db->update('ChambresReservations');

		$this->db->where('idReservation',$idReservation);
		$this->db->where('isCanceled',false);
		$this->db->where('isNoshow',false);
		$query = $this->db->get('ChambresReservations');
		if($query->num_rows()==0){

			$this->db->set('etatReservation','canceled');
			$this->db->set('etat','cancel');
			$this->db->set('Total',0);
			$this->db->set('sousTotal',0);
			$this->db->set('isCanceled',true);
			$this->db->set('isRead',0);
			$this->db->where('idReservation',$idReservation);
			$this->db->update('Reservations');

		}else{

			$this->db->set('Total','Total-'.$prix,FALSE);
			$this->db->set('sousTotal','sousTotal-'.$prix,FALSE);
			$this->db->set('total_rooms','total_rooms-1',FALSE);
			$this->db->set('total_guests','total_guests-'.$totalPax,FALSE);
			$this->db->set('isRead',0);
			$this->db->where('idReservation',$idReservation);
			$this->db->update('Reservations');

		}

		$this->db->set('idATA',5);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a annuler la chambre {{idCR:'.$idCR.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete(); # Completing transaction

		if ($this->db->trans_status() === FALSE) {
		    # Something went wrong.
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    # Everything is Perfect. 
		    # Committing data to the database.
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function updateRoomDate($idReservation,$idCR,$etat,$etatReservation,$isModified,$sousTotal,$Total,$dateDu,$dateAu,$updatedAt,$client,$rooms,$checkin,$checkout,$idUtilisateur,$canceled=false){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return FALSE; }

		$this->db->where('idCR',$idCR);
		$chambresReservations = $this->db->get('ChambresReservations');

		if($chambresReservations->num_rows()==0){ return FALSE; }

        $this->db->select('sum(prix) prix,idTarif');
		$this->db->where('idCR',$idCR);
		$qPrix = $this->db->get('DatesChambreRes');

		if($qPrix->num_rows()==0){ return FALSE; }

		if($qPrix->num_rows()>0){
			 $oPrix = $qPrix->row()->prix;
		}else{
			 $oPrix = 0;
		}

		$this->db->where('date<',$checkin);
		$this->db->where('idCR',$idCR);
		$this->db->delete('DatesChambreRes');

		$this->db->where('date>=',$checkout);
		$this->db->where('idCR',$idCR);
		$this->db->delete('DatesChambreRes');


		foreach ($rooms as $key => $room) {

			$totpax = $room['adult'] + $room['child'];
			$etat = 'modify';

			$this->db->set('prix',$room['prix']);
			$this->db->set('dateDu',$checkin);
			$this->db->set('dateAu',$checkout);
			$this->db->set('nuites',$room['nights']);
			$this->db->set('idTarif',$room['idChanTarif']);
			$this->db->set('idChambre',$room['idChanTarif']);
			$this->db->set('totalPax',$totpax);
			$this->db->set('totalAdult',$room['adult']);
			$this->db->set('totalEnfant',$room['child']);
			$this->db->set('etat',$etat);

			$this->db->where('idCR',$idCR);

			$this->db->update('ChambresReservations');

			// $idCR = $this->db->insert_id();
			foreach ($room['dates'] as $key => $date) {

				$this->db->where('date',$date['date']);
				$this->db->where('idCR',$idCR);
				$qDates = $this->db->get('DatesChambreRes');

				if($qDates->num_rows()==0){

					$this->db->set('idReservation',$idReservation);
					$this->db->set('providerId',$room['providerId']);
					$this->db->set('idCR',$idCR);
					$this->db->set('date',$date['date']);
					$this->db->set('prix',$date['prix']);
					$this->db->set('idTarif',$room['idChanTarif']);
					$this->db->insert('DatesChambreRes');

				}

		    }
		}

		$this->db->select('sum(prix) prix');
		$this->db->where('idCR',$idCR);
		$qPPrix = $this->db->get('DatesChambreRes');
		if($qPPrix->num_rows()==0){ return FALSE; }
		if($qPPrix->num_rows()>0){
			 $mPrix = $qPPrix->row()->prix;
		}else{
			 $mPrix = 0;
		}
		$pp = $oPrix - $mPrix ;

		$totalAfter = 0;
		$sj_pax = 0;
		$sj_nuits = 0;

		$taxSejour = 0;

		$this->db->where('idReservation',$idReservation);
		$this->db->where('isCanceled',false);
		$this->db->where('isNoshow',false);
		$queryCR = $this->db->get('ChambresReservations');
		if($queryCR->num_rows()>0){

			foreach ($queryCR->result() as $key => $cr) {


				$sj_pax =$cr->totalAdult;
				$sj_nuits =$cr->nuites;

				$this->db->select('sum(prix) prix');
				$this->db->where('idCR',$cr->idCR);
				$qrix = $this->db->get('DatesChambreRes');
				if($qrix->num_rows()>0){
					 $totalAfter += $qrix->row()->prix;
				}

				$this->db->where('idCR',$cr->idCR); 
				$qchilds = $this->db->get('ReservationEnfants');
				if($qchilds->num_rows()>0){
					foreach ($qchilds->result() as $key => $child_age) {

						if($child_age->age >12 ){
							$sj_pax += 1;
						}

					}
				}	
				$taxSejour += (11 * $sj_pax * $sj_nuits)*$reservation->row()->changeRate;	

			}


		}

		

		$this->db->where('idReservation',$idReservation);
		$this->db->where('isCanceled',false);
		$queryEx = $this->db->get('ExtrasReservation');
		if($queryEx->num_rows()>0){
			foreach ($queryEx->result() as $key => $extra) {

				$totalAfter += $extra->prix;

			}
		}

		

		$TotalTTC = $taxSejour+$totalAfter;


		// var_dump($TotalTTC,$taxSejour,$totalAfter);
		// return FALSE;


		$this->db->set('Total',$TotalTTC);
		$this->db->set('taxTotal',$taxSejour);
		$this->db->set('totalHT',$totalAfter);

		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('isRead',0);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

	

		if($chambresReservations->row()->idFactureP>0){

			$this->db->set('total','total - '.$pp,false);
			$this->db->where('idFacture',$chambresReservations->row()->idFactureP);
			$this->db->update('FacturesP');

		}

		$this->db->set('idATA',14);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifier la chambre {{idCR:'.$idCR.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete(); # Completing transaction

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertExtraReservationRoom($idReservation,$idCR,$idExtra,$personnes,$prix,$dates,$updatedAt,$idUtilisateur){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return false; }

		$this->db->where('idExtra',$idExtra);
		$extra = $this->db->get('Extras');

		if($extra->num_rows()==0){ return false; }

		if($extra->row()->idDeduction == 0){

			$prix = $prix * -1;

		}

		$newpp  = $prix * $reservation->row()->changeRate;

		$total = $newpp * count($dates) * $personnes;

		$this->db->set('idExtra',$idExtra);
		$this->db->set('idReservation',$idReservation);
		$this->db->set('idCR',$idCR);
		$this->db->set('prix',$total);

		$this->db->insert('ExtrasReservation');

		$idExtraRes = $this->db->insert_id();

		foreach ($dates as $key => $date) {

			$this->db->set('idExtra',$idExtra);
			$this->db->set('idReservation',$idReservation);
			$this->db->set('idCR',$idCR);
			$this->db->set('date',$date);
			$this->db->set('pax',$personnes);
			$this->db->set('prix',$newpp);
			$this->db->set('idExtraRes',$idExtraRes);
			$this->db->insert('ExtraResDates');	
			
		}

		$this->db->set('extraTotal','extraTotal + '.$total,false);

		$this->db->set('totalHT','totalHT + '.$total,false);
		$this->db->set('Total','Total +'.$total,false);
		$this->db->set('updatedAt',$updatedAt);

		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->set('idATA',10);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a ajouter extra sur chambre {{idCR:'.$idCR.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function insertExtraReservation($idReservation,$idExtra,$personnes,$prix,$dates,$updatedAt,$idUtilisateur){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return false; }

		$this->db->where('idExtra',$idExtra);
		$extra = $this->db->get('Extras');

		if($extra->num_rows()==0){ return false; }

		if($extra->row()->idDeduction == 0){

			$prix = $prix * -1;
			
		}

		$newpp  = $prix * $reservation->row()->changeRate;

		$total = $newpp * count($dates) * $personnes;

		$this->db->set('idExtra',$idExtra);
		$this->db->set('idReservation',$idReservation);
		$this->db->set('prix',$total);
		$this->db->set('isReservation',true);

		$this->db->insert('ExtrasReservation');

		$idExtraRes = $this->db->insert_id();

		foreach ($dates as $key => $date) {

			$this->db->set('idExtra',$idExtra);
			$this->db->set('idReservation',$idReservation);
			$this->db->set('date',$date);
			$this->db->set('pax',$personnes);
			$this->db->set('prix',$newpp);
			$this->db->set('idExtraRes',$idExtraRes);

			$this->db->insert('ExtraResDates');	
			
		}

		$this->db->set('extraTotal','extraTotal + '.$total,false);

		$this->db->set('totalHT','totalHT + '.$total,false);
		$this->db->set('Total','Total + '.$total,false);
		$this->db->set('updatedAt',$updatedAt);

		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->set('idATA',10);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a ajouter extra sur reservation {{idReservation:'.$idReservation.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function insertExtraRoomReservation($idReservation,$idCR,$idExtra,$personnes,$prix,$dates,$updatedAt){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return false; }


		$newpp  = $prix * $reservation->row()->changeRate;

		$total = $newpp * count($dates) * $personnes;


		$this->db->set('idExtra',$idExtra);
		$this->db->set('idReservation',$idReservation);
		$this->db->set('prix',$total);
		$this->db->set('idCR',$idCR);

		$this->db->insert('ExtrasReservation');

		$idExtraRes = $this->db->insert_id();

		foreach ($dates as $key => $date) {

			$this->db->set('idExtra',$idExtra);
			$this->db->set('idReservation',$idReservation);
			$this->db->set('date',$date);
			$this->db->set('pax',$personnes);
			$this->db->set('prix',$prix);
			$this->db->set('idExtraRes',$idExtraRes);

			$this->db->insert('ExtraResDates');	
			
		}

		$this->db->set('totalHT','totalHT + '.$total,false);
		$this->db->set('Total','Total + '.$total,false);
		$this->db->set('updatedAt',$updatedAt);

		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}

	}

	public function insertReservationHR($hr_number,$providerId, $channel,$channelDisplay,$etat,$etatReservation,$isModified, $client,$raisonAnnulation = '',$sousTotal,$extraTotal,$adjustmentsTotal,$taxTotal,$Total, $devise, $note,$dateDu,$dateAu, $paiement,$totalPaye,$completedAt,$updatedAt,$idCardex,$total_guests,$total_rooms,$guest_national_id='',$message_uid='',$source_display='',$taux=1,$canceled=false,$rooms){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('hr_number',$hr_number);
		$this->db->set('isArchive',true);
		$this->db->update('Reservations');

		if($etat == 'cancel'){
			$idATA =4;
		}elseif($etat == 'confirm'){
			$idATA =3;
		}elseif($etat == 'modify'){
			$idATA = 5;
		}

		$sj_total = 0;
		$sj_pax = 0;
		$sj_nuits = 0;

		$this->db->set('hr_number',$hr_number);
		$this->db->set('providerId',$providerId);
		$this->db->set('channel',$channel);
		$this->db->set('channelDisplay',$channelDisplay);
		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('client',$client);
		$this->db->set('raisonAnnulation',$raisonAnnulation);
		$this->db->set('sousTotal',$sousTotal);
		$this->db->set('adjustmentsTotal',$adjustmentsTotal);
		$this->db->set('taxTotal',$taxTotal);
		$this->db->set('extraTotal',$extraTotal);
		$this->db->set('Total',$Total);
		$this->db->set('devise',$devise);
		$this->db->set('note',$note);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('paiement',$paiement);
		$this->db->set('totalPaye',$totalPaye);
		$this->db->set('completedAt',$completedAt);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('idCardex',$idCardex);
		$this->db->set('changeRate',$taux);
		$this->db->set('total_guests',$total_guests);
		$this->db->set('total_rooms',$total_rooms);
		$this->db->set('guest_national_id',$guest_national_id);
		$this->db->set('message_uid',$message_uid); 
		$this->db->set('source_display',$source_display); 
		$this->db->set('isCanceled',$canceled);
		$this->db->insert('Reservations');

		$idReservation = $this->db->insert_id();

		$this->db->set('idATA',$idATA);
		$this->db->set('idUtilisateur',0);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a enregistre la reservation online {{idReservation:'.$idReservation.'}}');
		$this->db->insert('ActivitesUtilisateur');

		if(count($rooms)>0){

			foreach ($rooms as $key => $room) {

				$this->db->where('idChannelTarif',$room->rate_code);
				$qCTarif = $this->db->get('ChannelTarifs');
				if($qCTarif->num_rows()>0){

					$idTarif = $qCTarif->row()->idChannelTarif;

				}else{

					$this->db->set('idChannelTarif',$room->rate_code);
					$this->db->set('idChannelChambre',$room->inv_code);
					$this->db->insert('ChannelTarifs');
					$idlast = $this->db->insert_id();
					$idTarif = $idlast;	
					
				}

				$canceledRoom = ($room->state == 'canceled') ? 1 : 0;

				$extra_info = isset($room->extra_info) ? $room->extra_info : '' ;

				$meal_plan = isset($room->meal_plan) ? $room->meal_plan : '' ;

				$meal_plan_presentation = isset($room->meal_plan_presentation) ? $room->meal_plan_presentation : '' ;

				$name = isset($room->name) ? $room->name : '' ;

				$total_child = count($room->child_ages);

				$sj_pax += $room->total_adult;
				$sj_nuits += $room->nights;

				$this->db->set('idReservation',$idReservation);
				$this->db->set('providerId',$providerId);
				$this->db->set('prix',$room->price);
				$this->db->set('remboursable',$room->non_refundable);
				$this->db->set('dateDu',$room->checkin_date);
				$this->db->set('dateAu',$room->checkout_date);
				$this->db->set('nuites',$room->nights);
				$this->db->set('idTarif',$idTarif);
				$this->db->set('idChambre',$room->inv_code);
				$this->db->set('totalPax',$room->total_guest);
				$this->db->set('totalAdult',$room->total_adult);
				$this->db->set('totalEnfant',$total_child);
				$this->db->set('etat',$room->state);
				$this->db->set('extraInfo',$extra_info);
				$this->db->set('meal_plan',$meal_plan);
				$this->db->set('meal_plan_presentation',$meal_plan_presentation);
				$this->db->set('name',$name);
				$this->db->set('isCanceled',$canceledRoom);

				$this->db->insert('ChambresReservations');
				$idCR = $this->db->insert_id();

				if(count($room->child_ages)>0){
					foreach ($room->child_ages as $key => $child_age) {

						if($child_age >12 ){
							$sj_pax += 1;
						}

						$this->db->set('idReservation',$idReservation);
						$this->db->set('idCR',$idCR); 
						$this->db->set('age',$child_age);
						$this->db->insert('ReservationEnfants');

					}
				}
				if(count($room->daily_prices)>0){
					foreach ($room->daily_prices as $key => $daily_prices) {

						$this->db->set('idReservation',$idReservation);
						$this->db->set('providerId',$providerId);
						$this->db->set('idCR',$idCR);
						$this->db->set('date',$daily_prices->date);
						$this->db->set('prix',$daily_prices->price);
						$this->db->set('idTarif',$idTarif);
						$this->db->insert('DatesChambreRes');

						$sj_total += $daily_prices->price;

					}
				}
				if(count($room->extras)>0){
					foreach ($room->extras as $key => $extra) {

						$this->db->set('idReservation',$idReservation);
						$this->db->set('idCR',$idCR);
						$this->db->set('extraReservation',$extra->name);
						$this->db->set('prix',$extra->price);
						$this->db->set('codeExtra',$extra->code);

						$this->db->insert('ExtrasReservation');

						$sj_total += $extra->price;

					}
				}


			}

			$taxSejour = (11 * $sj_pax * $sj_nuits)*$taux;

			$this->db->set('taxTotal',$taxSejour);
			$this->db->set('totalHT',$sj_total);
			$this->db->where('idReservation',$idReservation);
			$this->db->update('Reservations');
		}

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function insertReservation($hr_number,$providerId, $channel,$channelDisplay,$etat,$etatReservation,$isModified, $client,$raisonAnnulation = '',$sousTotal,$extraTotal,$adjustmentsTotal,$taxTotal,$Total, $devise, $note,$dateDu,$dateAu, $paiement,$totalPaye,$completedAt,$updatedAt,$idCardex,$total_guests,$total_rooms,$guest_national_id,$message_uid,$source_display,$rooms,$tel,$adresse,$ville,$idPays,$email,$idUtilisateur=0,$taux=1,$canceled=false){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('LOWER(nom)',strtolower($client));
		$rCardex = $this->db->get('Cardex');
		if($rCardex->num_rows()>0){

			$idCardex = $rCardex->row()->idCardex;

		}else{

			$this->db->set('nom',$client);
			$this->db->set('Adresse',$adresse);
			$this->db->set('ville',$ville);
			$this->db->set('idPays',$idPays);
			$this->db->set('tel',$tel);
			$this->db->set('email',$email);
			$this->db->insert('Cardex');
			$idCardex = $this->db->insert_id();

		}

		$sj_total = 0;
		$sj_pax = 0;
		$sj_nuits = 0;

		$this->db->set('hr_number',$hr_number);
		$this->db->set('providerId',$providerId);
		$this->db->set('channel',$channel);
		$this->db->set('channelDisplay',$channelDisplay);
		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('client',$client);
		$this->db->set('raisonAnnulation',$raisonAnnulation);
		$this->db->set('sousTotal',$sousTotal);
		$this->db->set('adjustmentsTotal',$adjustmentsTotal);
		$this->db->set('taxTotal',$taxTotal);
		$this->db->set('extraTotal',$extraTotal);
		$this->db->set('Total',$Total);
		$this->db->set('devise',$devise);
		$this->db->set('note',$note);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('paiement',$paiement);
		$this->db->set('totalPaye',$totalPaye);
		$this->db->set('completedAt',$completedAt);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('idCardex',$idCardex);
		$this->db->set('changeRate',$taux);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('total_guests',$total_guests);
		$this->db->set('total_rooms',$total_rooms);
		$this->db->set('guest_national_id',$guest_national_id);
		$this->db->set('message_uid',$message_uid); 
		$this->db->set('source_display',$source_display); 
		$this->db->set('isCanceled',$canceled);

		$this->db->insert('Reservations');

		$idReservation = $this->db->insert_id();

		foreach ($rooms as $key => $room) {

			$totpax = $room['adult_res'] + $room['child_res'];
			$etat = 'confirm';
			$extra_info = '';
			$meal_plan = '';
			$meal_plan_presentation = '';
			$remboursable = 1;

			$sj_pax += $room['adult_res'];
			$sj_nuits += $room['nights'];

			$taxSejourRoom = (11 * $room['adult_res'] * $room['nights'])*$taux;

			$totRoom = $room['totalch'] + $taxSejourRoom;

			$this->db->set('idReservation',$idReservation);
			$this->db->set('providerId',$providerId);
			$this->db->set('prix',$totRoom);
			$this->db->set('remboursable',$remboursable);
			$this->db->set('dateDu',$dateDu);
			$this->db->set('dateAu',$dateAu);
			$this->db->set('nuites',$room['nights']);
			$this->db->set('idTarif',$room['idChanTarif']);
			$this->db->set('idChambre',$room['idChanTarif']);
			$this->db->set('totalPax',$totpax);
			$this->db->set('totalAdult',$room['adult_res']);
			$this->db->set('totalEnfant',$room['child_res']);
			$this->db->set('etat',$etat);
			$this->db->set('extraInfo',$extra_info);
			$this->db->set('meal_plan',$meal_plan);
			$this->db->set('meal_plan_presentation',$meal_plan_presentation);
			$this->db->set('name',$client);
			$this->db->set('isCanceled',$canceled);

			$this->db->insert('ChambresReservations');

			$idCR = $this->db->insert_id();
			foreach ($room['dates'] as $key => $date) {

				$this->db->set('idReservation',$idReservation);
				$this->db->set('providerId',$providerId);
				$this->db->set('idCR',$idCR);
				$this->db->set('date',$date['date']);
				$this->db->set('prix',$date['prix']);
				$this->db->set('idTarif',$room['idChanTarif']);

				$this->db->insert('DatesChambreRes');

		    }

		}


		$taxSejour = (11 * $sj_pax * $sj_nuits)*$taux;
		$tot = $Total+$taxSejour;

		$this->db->set('taxTotal',$taxSejour);
		$this->db->set('totalHT',$Total);
		$this->db->set('Total',$tot);
		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');


		$this->db->set('idATA',3);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a cree la reservation {{idReservation:'.$idReservation.'}}.');
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete(); 

		if ($this->db->trans_status() === FALSE) {

		    $this->db->trans_rollback();
		    return array('status'=>FALSE);
		}else {
		    $this->db->trans_commit();
		    return array('status'=>TRUE,'idReservation'=>$idReservation);
		}

	}


	public function setEditRoomPension($idReservation,$idCR,$date,$idPen,$prix,$updatedAt,$idUtilisateur){
		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return FALSE; }

		$this->db->where('idCR',$idCR);
		$chambresReservations = $this->db->get('ChambresReservations');

		if($chambresReservations->num_rows()==0){ return FALSE; }

        $this->db->select('sum(prix) prix,idTarif');
		$this->db->where('idCR',$idCR);
		$qPrix = $this->db->get('DatesChambreRes');

		if($qPrix->num_rows()==0){ return FALSE; }

		if($qPrix->num_rows()>0){
			 $oPrix = $qPrix->row()->prix;
		}else{
			 $oPrix = 0;
		}
		$idTarifChannel = $qPrix->row()->idTarif;


		$this->db->select('ChannelTarifs.idTypeChambres,DetailsTarif.idTarif,DetailsTarif.idTypePassage');
		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');
		$this->db->where('ChannelTarifs.idChannelTarif',$idTarifChannel);
		$this->db->limit(1);
		$qActual = $this->db->get('ChannelTarifs');
		if($qActual->num_rows()==0){ return FALSE; }


		$idTarif = $qActual->row()->idTarif;
		$idTypePassage = $qActual->row()->idTypePassage;
		$idTypeChambres = $qActual->row()->idTypeChambres;

		$this->db->select('ChannelTarifs.idChannelTarif');
		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar');
		$this->db->where('DetailsTarif.idPension',$idPen);
		$this->db->where('DetailsTarif.idTarif',$idTarif);
		$this->db->where('DetailsTarif.idTypePassage',$idTypePassage);
		$this->db->where('ChannelTarifs.idTypeChambres',$idTypeChambres);
		$this->db->limit(1);
		$qTarif = $this->db->get('ChannelTarifs');
		if($qTarif->num_rows()==0){ return FALSE; }

		$newidTarif = $qTarif->row()->idChannelTarif;
		$newpp  = $prix * $reservation->row()->changeRate;

		$this->db->set('prix',$newpp);
		$this->db->set('idTarif',$newidTarif);
        $this->db->where('idCR',$idCR);
        $this->db->where('date',$date);
		$this->db->update('DatesChambreRes');


		$this->db->select('sum(prix) prix');
		$this->db->where('idCR',$idCR);

		$qPPrix = $this->db->get('DatesChambreRes');
		if($qPPrix->num_rows()==0){ return FALSE; }
		if($qPPrix->num_rows()>0){
			 $mPrix = $qPPrix->row()->prix;
		}else{
			 $mPrix = 0;
		}

		$this->db->set('prix',$mPrix);
		$this->db->where('idCR',$idCR);
		$this->db->update('ChambresReservations');

		$pp = $oPrix - $mPrix ;

		if($chambresReservations->row()->idFactureP>0){

			$this->db->set('total','total - '.$pp,false);
			$this->db->where('idFacture',$chambresReservations->row()->idFactureP);
			$this->db->update('FacturesP');

		}

		$this->db->set('Total','Total - '.$pp,false);
		$this->db->set('isModified',true);
		$this->db->set('etat','modify');
		$this->db->set('updatedAt',$updatedAt);

		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->set('idATA',14);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifier prix de la chambre {{idCR:'.$idCR.'}}.');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function seteditRoomPensionDate($idReservation,$idCR,$date,$idPen,$prix,$updatedAt,$idUtilisateur){
		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idReservation',$idReservation);
		$reservation = $this->db->get('Reservations');

		if($reservation->num_rows()==0){ return FALSE; }

		$this->db->where('idCR',$idCR);
		$chambresReservations = $this->db->get('ChambresReservations');

		if($chambresReservations->num_rows()==0){ return FALSE; }

        $this->db->select('sum(prix) prix,idTarif');
		$this->db->where('idCR',$idCR);
		$qPrix = $this->db->get('DatesChambreRes');

		if($qPrix->num_rows()==0){ return FALSE; }

		if($qPrix->num_rows()>0){
			 $oPrix = $qPrix->row()->prix;
		}else{
			 $oPrix = 0;
		}
		$idTarifChannel = $qPrix->row()->idTarif;

		$this->db->select('ChannelTarifs.idTypeChambres,DetailsTarif.idTarif,DetailsTarif.idTypePassage');
		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');
		$this->db->where('ChannelTarifs.idChannelTarif',$idTarifChannel);
		$this->db->limit(1);
		$qActual = $this->db->get('ChannelTarifs');
		if($qActual->num_rows()==0){ return FALSE; }

		


		$idTarif = $qActual->row()->idTarif;
		$idTypePassage = $qActual->row()->idTypePassage;
		$idTypeChambres = $qActual->row()->idTypeChambres;



		$this->db->select('ChannelTarifs.idChannelTarif');
		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar');
		$this->db->where('DetailsTarif.idPension',$idPen);
		$this->db->where('DetailsTarif.idTarif',$idTarif);
		$this->db->where('DetailsTarif.idTypePassage',$idTypePassage);
		$this->db->where('ChannelTarifs.idTypeChambres',$idTypeChambres);
		$this->db->limit(1);
		$qTarif = $this->db->get('ChannelTarifs');
		if($qTarif->num_rows()==0){ return FALSE; }

		
		$newidTarif = $qTarif->row()->idChannelTarif;
		$newpp  = $prix * $reservation->row()->changeRate;

		$this->db->set('prix',$newpp);
		$this->db->set('idTarif',$newidTarif);
        $this->db->where('idCR',$idCR);
        $this->db->where('date>=',$date);
		$this->db->update('DatesChambreRes');

		$this->db->select('sum(prix) prix');
		$this->db->where('idCR',$idCR);
		$qPPrix = $this->db->get('DatesChambreRes');



		if($qPPrix->num_rows()==0){ return FALSE; }
		if($qPPrix->num_rows()>0){
			 $mPrix = $qPPrix->row()->prix;
		}else{
			 $mPrix = 0;
		}

		$this->db->set('prix',$mPrix);
		$this->db->where('idCR',$idCR);
		$this->db->update('ChambresReservations');

		$pp = $oPrix - $mPrix ;


		if($chambresReservations->row()->idFactureP>0){

			$this->db->set('total','total - '.$pp,false);
			$this->db->where('idFacture',$chambresReservations->row()->idFactureP);
			$this->db->update('FacturesP');

		}


		$this->db->set('Total','Total - '.$pp,false);
		$this->db->set('isModified',true);
		$this->db->set('etat','modify');
		$this->db->set('updatedAt',$updatedAt);

		$this->db->where('idReservation',$idReservation);
		$this->db->update('Reservations');

		$this->db->set('idATA',14);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$idReservation);
		$this->db->set('description',' a modifier prix de la chambre {{idCR:'.$idCR.'}}.');
		$this->db->insert('ActivitesUtilisateur');


		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function getCMSReservation($idReservation){


		$this->db->select('p1.*');
		//$this->db->group_by('providerId');
		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		$this->db->where('p2.providerId');
		$this->db->where('p1.providerId',$idReservation);
		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();
	}


	public function insertActivite($idATA,$idUtilisateur,$id){

		$this->db->set('idATA',$idATA);
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->set('id',$id);
		return $this->db->insert('ActivitesUtilisateur');
	}



	public function setDelogerRoom($idReservation,$idCR,$checkin,$roomN,$idUtilisateur){
		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->where('idCR',$idCR);
		$this->db->limit(1);
		$RQchambresReservations = $this->db->get('ChambresReservations');
		if($RQchambresReservations->num_rows()>0){
			$room = $RQchambresReservations->row();
			$earlier = new DateTime($checkin);
        	$later = new DateTime($room->dateAu);
        	$nuites = $later->diff($earlier)->format("%a");

        	if($checkin == $room->dateDu){

				$this->db->set('idChambres',$roomN);
				$this->db->where('idCR',$idCR);
				$this->db->update('ChambresReservations');

        	}else{

				$this->db->select('sum(prix) prix,date');
				$this->db->where('idCR',$idCR);
				$this->db->where('date>=',$checkin);
				$this->db->where('date<=',$room->dateAu);
				$qPrix = $this->db->get('DatesChambreRes');
				if($qPrix->num_rows()>0){
					$mPrix = $qPrix->row()->prix;
				}else{
					$mPrix = 0;
				}

				$earlier = new DateTime($room->dateDu);
	        	$later = new DateTime($checkin);
	        	$oldNuites = $later->diff($earlier)->format("%a");

				$this->db->set('dateAu',$checkin);
				$this->db->set('isCheckout',true);
				$this->db->set('prix','prix-'.$mPrix,false);
				$this->db->set('nuites',$oldNuites);

				$this->db->where('idCR',$idCR);
				$this->db->update('ChambresReservations');

				$this->db->set('idReservation',$idReservation);
				$this->db->set('providerId',$room->providerId);
				$this->db->set('prix',$mPrix);
				$this->db->set('remboursable',$room->remboursable);
				$this->db->set('dateDu',$checkin);
				$this->db->set('dateAu',$room->dateAu);
				$this->db->set('nuites',$nuites);
				$this->db->set('isCheckout',false);
				$this->db->set('isCheckin',true);
				$this->db->set('idTarif',$room->idTarif);
				$this->db->set('idChambre',$room->idChambre);
				$this->db->set('totalPax',$room->totalPax);
				$this->db->set('totalAdult',$room->totalAdult);
				$this->db->set('totalEnfant',$room->totalEnfant);
				$this->db->set('etat',$room->etat);
				$this->db->set('extraInfo',$room->extraInfo);
				$this->db->set('meal_plan',$room->meal_plan);
				$this->db->set('meal_plan_presentation',$room->meal_plan_presentation);
				$this->db->set('name',$room->name);
				$this->db->set('idFactureP',$room->idFactureP);
				$this->db->set('isCanceled',false);
				$this->db->set('idChambres',$roomN);
				$this->db->insert('ChambresReservations');

				$newidCR = $this->db->insert_id();

				$this->db->set('idCR',$newidCR);
				$this->db->where('date>=',$checkin);
				$this->db->where('date<=',$room->dateAu);
				$this->db->where('idCR',$room->idCR);
				$this->db->update('DatesChambreRes');

			}
			if(!isset($newidCR)){
				$newidCR = $idCR;
			}

			$this->db->set('idATA',6);
			$this->db->set('idUtilisateur',$idUtilisateur);
			$this->db->set('id',$idReservation);
			$this->db->set('description',' a deloger la chambre{{idCR:'.$idCR.'}} {{idChambre:'.$room->idChambres.'}} vers la chambre{{idCR:'.$newidCR.'}} {{idChambre:'.$roomN.'}}.');
			$this->db->insert('ActivitesUtilisateur');
		}
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}


	public function setCheckinAffectation($idReservation,$idCR,$idChambre,$idUtilisateur,$type = true){

		$this->db->trans_start();

		$this->db->trans_strict(TRUE);

		$this->db->set('isCheckin',true);
		$this->db->set('idChambres',$idChambre);
		if($type){
			$this->db->where('idCR',$idCR);	

		}else{
			$this->db->where('idReservation',$idReservation);
		}
		$this->db->update('ChambresReservations');

		

		$this->db->where('idReservation',$idReservation);
		$this->db->where('isCheckin',false);
		$rCheckout = $this->db->get('ChambresReservations');
		if($rCheckout->num_rows()==0){

			$this->db->set('isCheckin',true);
			$this->db->where('idReservation',$idReservation);
			$this->db->update('Reservations');
		}
		if($type){
			$this->db->set('idATA',7);		
			$this->db->set('id',$idReservation);
		}else{
			$this->db->set('idATA',8);		
			$this->db->set('id',$idReservation);
		}
		$this->db->set('description',' a affecter la chambre {{idChambre:'.$idChambre.'}} et checkin{{idCR:'.$idCR.'}} le client.');	
		$this->db->set('idUtilisateur',$idUtilisateur);
		$this->db->insert('ActivitesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

	public function getActiviteReservation($idReservation){

		$this->db->select('ActivitesUtilisateur.id,ActivitesUtilisateur.idATA,Utilisateurs.idUtilisateur,ActivitesUtilisateur.description,ActivitesUtilisateur.dateCreation,Utilisateurs.nomUtilisateur');

		$this->db->where('id',$idReservation);

		$this->db->join('Reservations','Reservations.idReservation = ActivitesUtilisateur.id');
		$this->db->join('Utilisateurs','Utilisateurs.idUtilisateur = ActivitesUtilisateur.idUtilisateur');
		$this->db->join('ActivitesTypeActivite','ActivitesTypeActivite.idATA = ActivitesUtilisateur.idATA');
		return $this->db->get('ActivitesUtilisateur')->result_array();

	}

	public function insert($hr_number,$providerId, $channel,$channelDisplay,$etat,$etatReservation,$isModified, $client,$raisonAnnulation = '',$sousTotal,$extraTotal,$adjustmentsTotal,$taxTotal,$Total, $devise, $note,$dateDu,$dateAu, $paiement,$totalPaye,$completedAt,$updatedAt,$idCardex,$total_guests,$total_rooms,$guest_national_id='',$message_uid='',$source_display='',$taux=1,$canceled=false){

		$this->db->set('hr_number',$hr_number);
		$this->db->set('providerId',$providerId);
		$this->db->set('channel',$channel);
		$this->db->set('channelDisplay',$channelDisplay);
		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('client',$client);
		$this->db->set('raisonAnnulation',$raisonAnnulation);
		$this->db->set('sousTotal',$sousTotal);
		$this->db->set('adjustmentsTotal',$adjustmentsTotal);
		$this->db->set('taxTotal',$taxTotal);
		$this->db->set('extraTotal',$extraTotal);
		$this->db->set('Total',$Total);
		$this->db->set('devise',$devise);
		$this->db->set('note',$note);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('paiement',$paiement);
		$this->db->set('totalPaye',$totalPaye);
		$this->db->set('completedAt',$completedAt);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->set('idCardex',$idCardex);
		$this->db->set('changeRate',$taux);
		$this->db->set('total_guests',$total_guests);
		$this->db->set('total_rooms',$total_rooms);
		$this->db->set('guest_national_id',$guest_national_id);
		$this->db->set('message_uid',$message_uid); 
		$this->db->set('source_display',$source_display); 
		$this->db->set('isCanceled',$canceled);


		if($this->db->insert('Reservations')){
			return $this->db->insert_id();
		}else{
			return false;
		}
	}

	public function getAndUpdate($idReservation,$etat,$etatReservation,$adresse,$ville,$idPays,$email,$tel,$nom,$channel,$channelDisplay,$dateDu,$dateAu,$note){


		$this->db->where('idReservation',$idReservation);
		$this->db->limit(1);
		$RQreservation = $this->db->get('Reservations');
		if($RQreservation->num_rows()>0){

			$dateReserve = date('Y-m-d H:i:sa');

			$reservation = $RQreservation->row();

			if($this->updateCardex($reservation->idCardex,$adresse,$ville,$idPays,$email,$tel,$nom)){

				$newIdReservation = $this->insert($reservation->hr_number,$reservation->providerId,$channel,$channelDisplay,$etat,$etatReservation,1,$nom,$reservation->raisonAnnulation,$reservation->sousTotal,$reservation->extraTotal,$reservation->adjustmentsTotal,$reservation->taxTotal,$reservation->Total,$reservation->devise,$note,$dateDu,$dateAu, $reservation->paiement,$reservation->totalPaye,$reservation->completedAt,$dateReserve,$reservation->idCardex,$reservation->total_guests,$reservation->total_rooms);

				$this->db->set('idReservation',$newIdReservation);
				$this->db->where('idReservation',$reservation->idReservation);
				if($this->db->update('ChambresReservations')){
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('DatesChambreRes')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('ExtrasReservation')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('ReservationEnfants')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('Reglements')){
						return -1;
					}
					return $newIdReservation;
				}else{
					return -1;
				}


			}else{
				return -1;
			}

		}else{
			return -1;
		}


	}

	public function getRoomAndInsert($idReservation,$idCR,$checkin,$checkout,$roomN,$nuites){
		$this->db->where('idCR',$idCR);
		$this->db->limit(1);
		$RQchambresReservations = $this->db->get('ChambresReservations');
		if($RQchambresReservations->num_rows()>0){
			$room = $RQchambresReservations->row();

			if($this->updateRoomCheckout($idCR,$checkout,true)){

				$newidCR = $this->insertRoomD($room->providerId, $room->prix,$room->remboursable,$checkin,$room->dateAu,$nuites, $room->idTarif,$roomN,$room->totalPax,$room->totalAdult,0,$room->etat,$idReservation);


					$this->db->set('idCR',$newidCR);
					$this->db->where('date>=',$checkin);
					$this->db->where('date<=',$room->dateAu);
					$this->db->where('idCR',$room->idCR);
					if(!$this->db->update('DatesChambreRes')){
						return -1;
					}
					// $this->db->set('idCR',$newidCR);
					// $this->db->where('date>=',$checkin);
					// $this->db->where('date<=',$room->dateAu);
					// $this->db->where('idCR',$room->idCR);
					// if(!$this->db->update('ExtrasReservation')){
					// 	return -1;
					// }
					return $newidCR;
			}else{
				return -1;
			}





		}else{
			return -1;
		}


	}

	public function getRoomReservationALL($idReservation){

		$this->db->select('TypesChambres.idTypeChambres,ChannelTarifs.idDetTar,Reservations.dateDu,Reservations.dateAu,Reservations.client,ChambresReservations.totalAdult as adult,ChambresReservations.totalEnfant as child,ChambresReservations.isCheckin,ChambresReservations.prix,Reservations.Total,Reservations.sousTotal,ChambresReservations.idChambres,ChambresReservations.providerId,Reservations.total_guests,Reservations.total_rooms,ChambresReservations.dateDu dateDuR,ChambresReservations.dateAu dateAuR,ChambresReservations.idCR');

		$this->db->join('Reservations','Reservations.idReservation = ChambresReservations.idReservation','LEFT');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('Reservations.idReservation',$idReservation);

		$this->db->where('ChambresReservations.isCanceled',False);


		return $this->db->get('ChambresReservations')->result_array();		
		var_dump($this->db->get('ChambresReservations')->result_array());
	}


	public function getAndInsert($idReservation,$cancel,$raisonAnnulation,$etat,$etatReservation){


		$this->db->where('idReservation',$idReservation);
		$this->db->order_by('updatedAt','DESC');
		$this->db->limit(1);
		$RQreservation = $this->db->get('Reservations');

		if($RQreservation->num_rows()>0){

			$dateReserve = date('Y-m-d H:i:sa');

			$reservation = $RQreservation->row();

			$newIdReservation =  $this->insert($reservation->hr_number,$reservation->providerId,$reservation->channel,$reservation->channelDisplay,$etat,$etatReservation,$reservation->isModified,$reservation->client,$raisonAnnulation,$reservation->sousTotal,$reservation->extraTotal,$reservation->adjustmentsTotal,$reservation->taxTotal,$reservation->Total,$reservation->devise,$reservation->note,$reservation->dateDu,$reservation->dateAu, $reservation->paiement,$reservation->totalPaye,$dateReserve,$dateReserve,$reservation->idCardex,$reservation->total_guests,$reservation->total_rooms,$reservation->guest_national_id,$reservation->message_uid,$reservation->source_display,$reservation->changeRate,1);
			$this->db->set('idReservation',$newIdReservation);
			$this->db->set('etat','canceled');
			$this->db->set('isCanceled',true);
			$this->db->where('idReservation',$reservation->idReservation);				
			


				if($this->db->update('ChambresReservations')){
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('DatesChambreRes')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('ExtrasReservation')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('ReservationEnfants')){
						return -1;
					}
					$this->db->set('idReservation',$newIdReservation);
					$this->db->where('idReservation',$reservation->idReservation);
					if(!$this->db->update('Reglements')){
						return -1;
					}
					return $newIdReservation;





				}else{
					return -1;
				}


		}else{
			return false;
		}

	}

	public function update($hr_number,$providerId,$channel,$channelDisplay,$etat,$etatReservation,$isModified, $client,$raisonAnnulation,$sousTotal,$extraTotal,$adjustmentsTotal,$taxTotal,$Total, $devise, $note,$dateDu,$dateAu, $paiement,$totalPaye,$completedAt,$updatedAt){

		$this->db->where('providerId',$providerId);
		$this->db->delete('DatesChambreRes');

		$this->db->where('providerId',$providerId);
		$this->db->delete('ChambresReservations');

		$this->db->set('hr_number',$hr_number);
		$this->db->set('channel',$channel);
		$this->db->set('channelDisplay',$channelDisplay);
		$this->db->set('etat',$etat);
		$this->db->set('etatReservation',$etatReservation);
		$this->db->set('isModified',$isModified);
		$this->db->set('client',$client);
		$this->db->set('raisonAnnulation',$raisonAnnulation);
		$this->db->set('sousTotal',$sousTotal);
		$this->db->set('adjustmentsTotal',$adjustmentsTotal);
		$this->db->set('taxTotal',$taxTotal);
		$this->db->set('Total',$Total);
		$this->db->set('devise',$devise);
		$this->db->set('note',$note);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('paiement',$paiement);
		$this->db->set('totalPaye',$totalPaye);
		$this->db->set('completedAt',$completedAt);
		$this->db->set('updatedAt',$updatedAt);
		$this->db->where('providerId',$providerId);
		return $this->db->update('Reservations');
	}

	public function updateRoomCheckout($idCR,$checkout,$isCheckout){

		$this->db->set('dateAu',$dateAu);
		$this->db->set('isCheckout',$isCheckout);
		$this->db->where('idCR',$idCR);

		return $this->db->update('ChambresReservations');
	}

	public function insertRoom($providerId, $prix,$remboursable,$dateDu,$dateAu,$nuites, $idTarif, $idChambre,$totalPax,$totalAdult,$totalEnfant = 0,$etat,$idReservation,$meal_plan='',$meal_plan_presentation='',$name='',$extra_info='',$canceled=false){

		$this->db->set('idReservation',$idReservation);
		$this->db->set('providerId',$providerId);
		$this->db->set('prix',$prix);
		$this->db->set('remboursable',$remboursable);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('nuites',$nuites);
		$this->db->set('idTarif',$idTarif);
		$this->db->set('idChambre',$idChambre);
		$this->db->set('totalPax',$totalPax);
		$this->db->set('totalAdult',$totalAdult);
		$this->db->set('totalEnfant',$totalEnfant);
		$this->db->set('etat',$etat);
		$this->db->set('extraInfo',$extra_info);
		$this->db->set('meal_plan',$meal_plan);
		$this->db->set('meal_plan_presentation',$meal_plan_presentation);
		$this->db->set('name',$name);
		$this->db->set('isCanceled',$canceled);

		if($this->db->insert('ChambresReservations')){
			return $this->db->insert_id();
		}else{
			return false;
		}
	}

	public function insertRoomD($providerId, $prix,$remboursable,$dateDu,$dateAu,$nuites, $idTarif, $idChambre,$totalPax,$totalAdult,$totalEnfant = 0,$etat,$idReservation,$idch){

		$this->db->set('idReservation',$idReservation);
		$this->db->set('providerId',$providerId);
		$this->db->set('prix',$prix);
		$this->db->set('remboursable',$remboursable);
		$this->db->set('dateDu',$dateDu);
		$this->db->set('dateAu',$dateAu);
		$this->db->set('nuites',$nuites);
		$this->db->set('idTarif',$idTarif);
		$this->db->set('idChambre',$idChambre);
		$this->db->set('totalPax',$totalPax);
		$this->db->set('totalAdult',$totalAdult);
		$this->db->set('totalEnfant',$totalEnfant);
		$this->db->set('etat',$etat);
		$this->db->set('extraInfo',$extra_info);
		$this->db->set('meal_plan',$meal_plan);
		$this->db->set('meal_plan_presentation',$meal_plan_presentation);
		$this->db->set('name',$name);
		$this->db->set('isCanceled',$canceled);
		$this->db->set('idChambres',$idch);


		if($this->db->insert('ChambresReservations')){
			return $this->db->insert_id();
		}else{
			return false;
		}
	}



	public function insertEnfant($idCR,$idReservation,$age){

		$this->db->set('idReservation',$idReservation);
		$this->db->set('idCR',$idCR); 
		$this->db->set('age',$age);
		if($this->db->insert('ReservationEnfants')){
			return $this->db->insert_id();
		}else{
			return false;
		}
	}


	public function insertExtra($extra,$prix,$idCR,$idReservation,$code){

		$this->db->set('idReservation',$idReservation);
		$this->db->set('extraReservation',$extra);
		$this->db->set('prix',$prix);
		$this->db->set('idCR',$idCR);
		$this->db->set('codeExtra',$code);

		if($this->db->insert('ExtrasReservation')){
			return $this->db->insert_id();
		}else{
			return false;
		}
	}


	public function updateCardex($idCardex,$adresse,$ville,$idPays,$email,$tel,$nom){
			$this->db->set('nom',$nom);
			$this->db->set('Adresse',$adresse);
			$this->db->set('ville',$ville);
			$this->db->set('idPays',$idPays);
			$this->db->set('tel',$tel);
			$this->db->set('email',$email);
			$this->db->where('idCardex',$idCardex);
			return $this->db->update('Cardex');

	}

	public function insertCardex($adresse,$ville,$idPays,$email,$tel,$nom){

		$this->db->where('LOWER(nom)',strtolower($nom));
		$rCardex = $this->db->get('Cardex');
		if($rCardex->num_rows()>0){

			return $rCardex->row()->idCardex;

		}else{

			$this->db->set('nom',$nom);
			$this->db->set('Adresse',$adresse);
			$this->db->set('ville',$ville);
			$this->db->set('idPays',$idPays);
			$this->db->set('tel',$tel);
			$this->db->set('email',$email);

			if($this->db->insert('Cardex')){
				return $this->db->insert_id();
			}else{
				return false;
			}

		}
	}

	public function checkIdReservation($idReservation){

        $this->db->where('providerId',$idReservation);
        $qReser = $this->db->get('Reservations');
        return $qReser->num_rows();
	}



	public function insertDay($idCR, $date,$prix,$providerId,$idTarif,$idReservation){

		$this->db->set('idReservation',$idReservation);
		$this->db->set('providerId',$providerId);
		$this->db->set('idCR',$idCR);
		$this->db->set('date',$date);
		$this->db->set('prix',$prix);
		$this->db->set('idTarif',$idTarif);

		return $this->db->insert('DatesChambreRes');
	}

	public function getReservations(){


		// $this->db->select('p1.*');
		// //$this->db->group_by('providerId');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->order_by('updatedAt','DESC');
		$this->db->limit(50);
		return $this->db->get('Reservations p1')->result_array();
		echo $this->db->last_query(); die;

	}


	public function getReservationsInhouse($dated,$datef){


		// $this->db->select('p1.*');
		// //$this->db->group_by('providerId');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');

		$this->db->select('r.*');

		$this->db->join('ChambresReservations',"r.idReservation = ChambresReservations.idReservation");

		$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR AND ChambresReservations.isCanceled = 0 AND ChambresReservations.isCanceled = 0');

		$this->db->where('DatesChambreRes.date>=',$dated);
		$this->db->where('DatesChambreRes.date<=',$datef);


		$this->db->where('r.isArchive',false);

		$this->db->where('r.isNoshow',false);
		
		$this->db->group_by('r.idReservation');
		$this->db->order_by('r.updatedAt','DESC');
		return $this->db->get('Reservations r')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsAnnulee($dated,$datef){


		// $this->db->select('p1.*');
		// //$this->db->group_by('providerId');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');

		$this->db->where('p1.dateAu>=',$dated);
		$this->db->where('p1.dateDu<=',$datef);
		$this->db->where('p1.isCanceled',true);

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsCheckIN($dated,$datef){


		// $this->db->select('p1.*');
		// //$this->db->group_by('providerId');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');

		$this->db->where('p1.dateDu>=',$dated);
		$this->db->where('p1.dateDu<=',$datef);
		$this->db->where('p1.isCanceled',false);

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();






		$this->db->select('r.*');

		$this->db->join('ChambresReservations',"r.idReservation = ChambresReservations.idReservation");

		$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR AND ChambresReservations.isCanceled = 0 AND ChambresReservations.isCanceled = 0');

		$this->db->where('DatesChambreRes.date>=',$dated);
		$this->db->where('DatesChambreRes.date<=',$datef);

		$this->db->where('r.isArchive',false);
		$this->db->where('p1.isCanceled',false);
		$this->db->where('r.isNoshow',false);
		
		$this->db->group_by('r.idReservation');
		$this->db->order_by('r.updatedAt','DESC');
		return $this->db->get('Reservations r')->result_array();
		echo $this->db->last_query(); die;
	}

	public function getReservationsCheckOUT($dated,$datef){

		$this->db->select('r.*');

		$this->db->join('ChambresReservations',"r.idReservation = ChambresReservations.idReservation");

		$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR AND ChambresReservations.isCanceled = 0 AND ChambresReservations.isCanceled = 0');


		$this->db->where('r.dateAu>=',$dated);
		$this->db->where('r.dateAu<=',$datef);

		$this->db->where('r.isArchive',false);
		$this->db->where('r.isNoshow',false);

		$this->db->group_by('r.idReservation');

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations r')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsNoCheckIN($dated,$datef){


		$this->db->select('p1.*');
		//$this->db->group_by('providerId');
		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		$this->db->where('p2.providerId');

		$this->db->where('p1.dateDu>=',$dated);
		$this->db->where('p1.dateDu<=',$datef);
		$this->db->where('p1.isCheckin',false);
		$this->db->where('p1.isCanceled',false);

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsNotCheckOUT($dated,$datef){


		$this->db->select('p1.*');
		//$this->db->group_by('providerId');
		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		$this->db->where('p2.providerId');

		$this->db->where('p1.dateAu>=',$dated);
		$this->db->where('p1.dateAu<=',$datef);
		$this->db->where('p1.isCheckout',false);
		$this->db->where('p1.isCanceled',false);

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsNoShow($dated,$datef){


		$this->db->select('p1.*');
		//$this->db->group_by('providerId');
		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		$this->db->where('p2.providerId');

		$this->db->where('p1.dateAu>=',$dated);
		$this->db->where('p1.dateDu<=',$datef);
		$this->db->where('p1.isNoshow',true);

		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();
		echo $this->db->last_query(); die;

	}

	public function getReservationsALL($dated,$datef){


		// $this->db->select('p1.*');
		//$this->db->group_by('providerId');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');

		// $this->db->where('dateAu>=',$dated);
		// $this->db->where('dateDu<=',$datef);
		// $this->db->where('isArchive',false);

		// $this->db->order_by('updatedAt','DESC');
		// return $this->db->get('Reservations')->result_array();
		// echo $this->db->last_query(); die;

		$this->db->select('r.*');

		$this->db->join('ChambresReservations',"r.idReservation = ChambresReservations.idReservation");

		$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR');

		$this->db->where('DatesChambreRes.date>=',$dated);
		$this->db->where('DatesChambreRes.date<=',$datef);

		$this->db->where('r.isArchive',false);
		
		$this->db->group_by('r.idReservation');
		$this->db->order_by('r.updatedAt','DESC');
		return $this->db->get('Reservations r')->result_array();

	}

	public function getCMSReservations(){

		$this->db->where('isRead',FALSE);
		$this->db->order_by('dateCreation','DESC');
		return $this->db->get('Reservations')->result_array();
	}

	public function getReservationRooms($idReservation){

		$this->db->where('ChambresReservations.idReservation',$idReservation);
		$this->db->join('DatesChambreRes','DatesChambreRes.idReservation = ChambresReservations.idReservation');
		$this->db->order_by('DatesChambreRes.date','DESC');
		return $this->db->get('ChambresReservations')->result_array();
	}


	public function setIsRead($idReservation,$isRead = true){

		$this->db->set('isRead',$isRead);
		$this->db->where('idReservation',$idReservation);
		return $this->db->update('Reservations');
	}

	public function getReservationRoomsCMS($idReservation,$order = false){


		// $this->db->select('ChambresReservations.etat,ChambresReservations.totalPax,TypesChambres.codeChambre,ChambresReservations.totalEnfant,ChambresReservations.totalAdult,Pensions.codePension,DatesChambreRes.prix,DatesChambreRes.date');

		// $this->db->where('ChambresReservations.idReservation',$idReservation);

		// $this->db->join('DatesChambreRes','DatesChambreRes.idReservation = ChambresReservations.idReservation','LEFT');

		// $this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		// $this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		// $this->db->join('TypesChambres','TypesChambres.idTypeChambres = ChannelTarifs.idTypeChambres','LEFT');

		// $this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->select('ChambresReservations.etat,ChambresReservations.totalPax,TypesChambres.codeChambre,ChambresReservations.totalEnfant,ChambresReservations.totalAdult,Pensions.codePension,DatesChambreRes.prix,DatesChambreRes.date');

		// $this->db->join('ChannelsTypeChambres','ChambresReservations.idChambre = ChannelsTypeChambres.idChannelChambre','LEFT');

		$this->db->join('DatesChambreRes','DatesChambreRes.idCR = ChambresReservations.idCR','LEFT');

		$this->db->join('Chambres','Chambres.idChambres = ChambresReservations.idChambres','LEFT');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('ChambresReservations.idReservation',$idReservation);

		$this->db->order_by('DatesChambreRes.date','ASC');

		return $this->db->get('ChambresReservations')->result_array();
	}

	public function updateCardexReservation($providerId,$idCardex){


		$this->db->set('idCardex',$idCardex);
		$this->db->where('providerId',$providerId);
		
		return $this->db->update('Reservations');

	}

	public function getReservation($idReservation){

		$this->db->select('Reservations.*,Channels.commission,Channels.allTaxesIncluded');

		$this->db->where('idReservation',$idReservation);
		$this->db->join('Channels','Channels.channel = Reservations.channel','LEFT');
		$this->db->group_by('providerId');
		$this->db->order_by('dateCreation','DESC');
		$qReser = $this->db->get('Reservations');
        if($qReser->num_rows()>0){
        	return $qReser->row();

        }else{
        	return null;
        }
	}

	public function getReservationClient($idCardex){

		$this->db->where('idCardex',$idCardex);
		$qCardex = $this->db->get('Cardex');
        if($qCardex->num_rows()>0){
        	return $qCardex->row();

        }else{
        	return null;
        }
	}

	public function getDatesChambreRes($idCR){

		$this->db->select('DatesChambreRes.*,Pensions.codePension,Pensions.idPension');


		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = DatesChambreRes.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('DatesChambreRes.idCR',$idCR);


		$this->db->order_by('DatesChambreRes.date');

		return $this->db->get('DatesChambreRes')->result_array();

	}

	public function getDatesChambreResReg($idCR){

		$this->db->select('DatesChambreRes.*,Pensions.codePension,Pensions.idPension');

		$this->db->join('ChambresReservations','DatesChambreRes.idCR = ChambresReservations.idCR','LEFT');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = DatesChambreRes.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('DatesChambreRes.idCR',$idCR);

		$this->db->where('ChambresReservations.isCanceled',false);

		$this->db->order_by('DatesChambreRes.date');

		return $this->db->get('DatesChambreRes')->result_array();

	}

	public function getExtraChambre($idReservation){

		$this->db->select('IFNULL(extra,extraReservation) as extraReservation,ExtrasReservation.isReservation,ExtrasReservation.prix,idExtraRes,ExtrasReservation.idExtra,ExtrasReservation.totalRegle,Extras.idDeduction,ExtrasReservation.idFactureP');

		$this->db->join('Extras','Extras.idExtra = ExtrasReservation.idExtra','LEFT');

		$this->db->where('ExtrasReservation.idReservation',$idReservation);

		return $this->db->get('ExtrasReservation')->result_array();
	}

	public function getDatesExtraChambre($idExtraRes){

		$this->db->where('idExtraRes',$idExtraRes);

		return $this->db->get('ExtraResDates')->result_array();
	}

	public function getExtraReservation($idReservation){



		$this->db->join('ExtrasReservation','ExtrasReservation.idExtraRes = ExtraResDates.idExtraRes');


		$this->db->where('ExtrasReservation.idReservation',$idReservation);

		return $this->db->get('ExtraResDates')->result_array();
	}

	public function getEnfantReservation($idCR){

		$this->db->where('ReservationEnfants.idCR',$idCR);

		return $this->db->get('ReservationEnfants')->result_array();
	}

	public function getExtraChambreR($idCR){

		$this->db->where('ExtrasReservation.idCR',$idCR);

		return $this->db->get('ExtrasReservation')->result_array();
	}

	public function getReservationRoom($idCR){


		$this->db->select('TypesChambres.adults,Pensions.codePension,Pensions.pension,TypesChambres.nomTypeChambres,ChambresReservations.prix,ChambresReservations.totalAdult,ChambresReservations.totalEnfant,ChambresReservations.dateDu,ChambresReservations.dateAu,ChambresReservations.idCR,ChambresReservations.etat,ChambresReservations.idChambres,TypesChambres.idTypeChambres,ChambresReservations.nuites,ChambresReservations.isCheckout,ChambresReservations.isCheckin,Chambres.nomChambre,ChambresReservations.isCanceled,ChambresReservations.isNoshow, ChambresReservations.totalRegle, ChambresReservations.idFactureP,Reservations.channel');

		$this->db->join('Reservations','Reservations.idReservation = ChambresReservations.idReservation');

		$this->db->join('Chambres','Chambres.idChambres = ChambresReservations.idChambres','LEFT');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');
		
		$this->db->where('ChambresReservations.idCR',$idCR);

		$this->db->limit(1);

		return $this->db->get('ChambresReservations')->result_array();
	}

	public function getReservationRoomsL($idReservation){


		$this->db->select('TypesChambres.adults,Pensions.codePension,Pensions.pension,TypesChambres.nomTypeChambres,ChambresReservations.prix,ChambresReservations.totalAdult,ChambresReservations.totalEnfant,ChambresReservations.dateDu,ChambresReservations.dateAu,ChambresReservations.idCR,ChambresReservations.etat,ChambresReservations.idChambres,TypesChambres.idTypeChambres,ChambresReservations.nuites,ChambresReservations.isCheckout,ChambresReservations.isCheckin,Chambres.nomChambre,ChambresReservations.isCanceled,ChambresReservations.isNoshow,ChambresReservations.totalRegle,ChambresReservations.idFactureP,ChambresReservations.taxIdFactureP');

		// $this->db->join('ChannelsTypeChambres','ChambresReservations.idChambre = ChannelsTypeChambres.idChannelChambre','LEFT');

		$this->db->join('Chambres','Chambres.idChambres = ChambresReservations.idChambres','LEFT');
		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');
		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');
		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');
		$this->db->where('ChambresReservations.idReservation',$idReservation);

		return $this->db->get('ChambresReservations')->result_array();
	}

	public function getReservationRoomsR($idReservation){

		$this->db->select('TypesChambres.adults,count(*) qte,Pensions.codePension,Pensions.pension,TypesChambres.nomTypeChambres,ChambresReservations.prix,ChambresReservations.totalAdult,ChambresReservations.totalEnfant,ChambresReservations.dateDu,ChambresReservations.dateAu,ChambresReservations.idCR,ChambresReservations.idChambres,ChambresReservations.nuites,ChambresReservations.isCheckout,ChambresReservations.isCheckin,ChambresReservations.isCanceled,ChambresReservations.isNoshow');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('ChambresReservations.idReservation',$idReservation);

		$this->db->group_by('DetailsTarif.idPension,ChannelTarifs.idTypeChambres,ChambresReservations.idChambres');

		$this->db->order_by('ChambresReservations.dateDu','ASC');

		return $this->db->get('ChambresReservations')->result_array();
	}


	public function getRoomReservation($dated,$datef){

		$this->db->select('Chambres.idChambres,Chambres.nomChambre,TypesChambres.idTypeChambres,TypesChambres.nomTypeChambres,TypesChambres.capacite');

		$this->db->join('ChambresTypesChambre','Chambres.idChambres = ChambresTypesChambre.idChambres AND master = 1');

		$this->db->join('TypesChambres','ChambresTypesChambre.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->order_by('TypesChambres.codeChambre,Chambres.idChambres');

		return  $this->db->get('Chambres')->result_array();

		echo $str = $this->db->last_query();die;

		$this->db->select('p1.*');
		//$this->db->group_by('providerId');
		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		$this->db->where('p2.providerId');
		$this->db->order_by('updatedAt','DESC');
		return $this->db->get('Reservations p1')->result_array();

	}

	public function getRoomReservationsAll(){

		$this->db->select('ChambresReservations.*,p1.channel,p1.client,TypesChambres.idTypeChambres');


		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('Reservations p1',"p1.idReservation = ChambresReservations.idReservation AND p1.etat != 'cancel'",'LEFT');

		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		
		$this->db->where('ChambresReservations.isCanceled',false);
		$this->db->where('ChambresReservations.isNoshow',false);

		$this->db->where('p2.providerId');

		$this->db->order_by('ChambresReservations.idChambres','DESC');
		$this->db->order_by('ChambresReservations.dateDu','ASC');


		return $this->db->get('ChambresReservations')->result_array();

		echo $str = $this->db->last_query();die;



// SELECT * FROM events WHERE (end_date >= $start_select AND start_date <= $end_select);


	}

	public function getRoomReservationDates($dated,$datef){

		$this->db->select('ChambresReservations.*,p1.channel,p1.client,TypesChambres.idTypeChambres');


		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('Reservations p1',"p1.idReservation = ChambresReservations.idReservation AND p1.etat != 'cancel'",'LEFT');

		$this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');

		$this->db->where('ChambresReservations.dateAu>=',$dated);
		$this->db->where('ChambresReservations.dateDu<=',$datef);
		
		$this->db->where('ChambresReservations.isCanceled',false);
		$this->db->where('ChambresReservations.isNoshow',false);

		$this->db->where('p2.providerId');

		$this->db->order_by('ChambresReservations.idChambres','DESC');
		$this->db->order_by('ChambresReservations.dateDu','ASC');


		return $this->db->get('ChambresReservations')->result_array();

		echo $str = $this->db->last_query();die;



// SELECT * FROM events WHERE (end_date >= $start_select AND start_date <= $end_select);


	}




	public function getRoomReservationS($dated,$datef){

		$this->db->select('ChambresReservations.dateDu,ChambresReservations.dateAu,Reservations.client,ChambresReservations.idReservation,ChambresReservations.providerId,Reservations.etat,ChambresReservations.idChambre,ChambresReservations.idCR');

		$this->db->where("(ChambresReservations.dateDu BETWEEN '".$dated."' AND '".$datef."' OR ChambresReservations.dateAu BETWEEN '".$dated."' AND '".$datef."')");

		$this->db->join('Reservations','Reservations.idReservation = ChambresReservations.idReservation','LEFT');
		$this->db->group_by('ChambresReservations.providerId,ChambresReservations.idChambre');
		$this->db->order_by('ChambresReservations.dateDu,ChambresReservations.dateCreation,Reservations.dateCreation');
		return $this->db->get('ChambresReservations')->result_array();

		echo $str = $this->db->last_query();die;

	}

	public function checkRoomReservation($dated,$datef,$idChambre,$idCR){


		$this->db->join('ChannelsTypeChambres','Chambres.idTypesChambre= ChannelsTypeChambres.idTypesChambre');
		$this->db->where('ChannelsTypeChambres.idChannelChambre',$idChambre);
		$this->db->order_by('nomChambre');
		$resQR = $this->db->get('Chambres');
		if($resQR->num_rows()>0){
			foreach ($resQR->result() as $row) {

				$idChambres = $row->idChambres;
				$this->db->where("ChambresReservations.dateDu BETWEEN '".$dated."' AND '".$datef."'");
				$this->db->where('ChambresReservations.idChambres', $idChambres);		
				$this->db->or_where("ChambresReservations.dateAu BETWEEN '".$dated."' AND '".$datef."'");
				$this->db->where('ChambresReservations.idChambres', $idChambres);
				$this->db->group_by('ChambresReservations.idChambre,ChambresReservations.idReservation');
				$resQRR =  $this->db->get('ChambresReservations');
				if($resQRR->num_rows()==0){

					$this->db->set('ChambresReservations.idChambres',$idChambres);
					$this->db->where('ChambresReservations.idCR',$idCR);
					$this->db->update('ChambresReservations');

					echo 'Chambre nom : '.$idChambres;
					break;

				}
			}
		}

		$this->db->where("ChambresReservations.dateDu BETWEEN '".$dated."' AND '".$datef."'");
		$this->db->where('ChambresReservations.idChambre', $idChambre);		
		$this->db->or_where("ChambresReservations.dateAu BETWEEN '".$dated."' AND '".$datef."'");
		$this->db->where('ChambresReservations.idChambre', $idChambre);
		$this->db->group_by('ChambresReservations.providerId,ChambresReservations.idChambre');
		$www = $this->db->get('ChambresReservations')->result_array();
		// echo $str = $this->db->last_query();
		return $www;

	}



	public function getPays($alpha){


		$this->db->where('alpha_2',strtolower($alpha));
		$qPays = $this->db->get('Pays');
        if($qPays->num_rows()>0){
			return $qPays->row()->name_fr;
        }else{
			return 'N/A';
        }	
	}


	public function getArrivesDate($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));

		$this->db->select('count(*) as Arrives');
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isCanceled',$annulation);
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.dateDu',$date);
		$this->db->where('r.isArchive',false);
		$rs = $this->db->get('ChambresReservations');
		if($rs->num_rows()>0){
           return $rs->row()->Arrives;
		}else{
			return 0;
		}

	}

	public function getCheckinDate($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));
		$this->db->select('count(*) as checkins');
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isCheckin',TRUE);
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.isCanceled',$annulation);	
		$this->db->where('ChambresReservations.dateDu',$date);
		$this->db->where('r.isArchive',false);
		$rs = $this->db->get('ChambresReservations');
		$count = $rs->num_rows();
		if($rs->num_rows()>0){
           return $rs->row()->checkins;
		}else{
			return 0;
		}
		//var_dump($count);

	}



	public function getDepartsDate($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));

		$this->db->select('count(*) as Departs');
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.isCanceled',$annulation);
		$this->db->where('ChambresReservations.dateAu',$date);
		$this->db->where('r.isArchive',false);
		$rs = $this->db->get('ChambresReservations');
		if($rs->num_rows()>0){
           return $rs->row()->Departs;
		}else{
			return 0;
		}

	}

	public function getCheckoutDate($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));
		$this->db->select('count(*) as checkouts');
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isCheckout',TRUE);
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.isCanceled',$annulation);
		$this->db->where('ChambresReservations.dateAu',$date);
		$this->db->where('r.isArchive',false);
		$rs = $this->db->get('ChambresReservations');
		$count = $rs->num_rows();
		if($rs->num_rows()>0){
           return $rs->row()->checkouts;
		}else{
			return 0;
		}
		//var_dump($count);
	}

	public function getNombresChambre(){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));
		$this->db->select('nombreChambre');
		$rs = $this->db->get('Hotel');
		$count = $rs->num_rows();
		if($rs->num_rows()>0){
           return $rs->row()->nombreChambre;
		}else{
			return 0;
		}
		//var_dump($count);
	}

	public function getTauxOccupationDate($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));
		$this->db->select('count(*) as occu');
		$this->db->join('ChambresReservations','DatesChambreRes.idCR = ChambresReservations.idCR');
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.isCanceled',$annulation);
		$this->db->where('DatesChambreRes.date',$date);
		$this->db->where('r.isArchive',false);

		$rs = $this->db->get('DatesChambreRes');
		// foreach ($rs as $key => $rss) {
		// 	echo $rss['dateAu'].' ( '.$rss['dateDu'].'<br>';
		// }
		// die;
		$count = $rs->num_rows();
		if($rs->num_rows()>0){
           return $rs->row()->occu;
		}else{
			return 0;
		}
		//var_dump($count);
	}

	public function getTotalRevenue($date,$annulation){

		//$date = date('Y-m-d', strtotime($date. ' + 1 days'));
		// $this->db->select('SUM(DatesChambreRes.prix)/count(*) as total');
		$this->db->select('SUM(DatesChambreRes.prix * (1/r.changeRate))/count(*) as total');
		$this->db->join('ChambresReservations','DatesChambreRes.idCR = ChambresReservations.idCR');
		
		$this->db->join('Reservations r',"r.idReservation = ChambresReservations.idReservation",'LEFT');
		// $this->db->join('Reservations p2','(p1.providerId = p2.providerId AND p1.updatedAt < p2.updatedAt)','LEFT');
		// $this->db->where('p2.providerId');
		$this->db->where('ChambresReservations.isNoshow',false);
		$this->db->where('ChambresReservations.isCanceled',$annulation);
		$this->db->where('DatesChambreRes.date',$date);
		$this->db->where('r.isArchive',false);
		$rs = $this->db->get('DatesChambreRes');
		// foreach ($rs->result() as $key => $rss) {
		// 	echo $rss->prix.' ( '.$rss->prix.'<br>';
		// }
		// die;
		$count = $rs->num_rows();
		if($rs->num_rows()>0){
           return $rs->row()->total;
		}else{
			return 0;
		}

		//var_dump($count);
	}


	public function getTauxOccupationYear($year,$annulation){



		return $this->db->query("SELECT h.hr, Count(cr.idCR) as nbrs,SUM(cr.prix*(1/r.changeRate)) as CA,Month(cr.dateDu) as Month FROM (SELECT 1 as hr UNION all SELECT 2 as hr UNION all SELECT 3 as hr UNION all SELECT 4 as hr UNION all SELECT 5 as hr UNION all SELECT 6 as hr UNION all SELECT 7 as hr UNION all SELECT 8 as hr UNION all SELECT 9 as hr UNION all SELECT 10 as hr UNION all SELECT 11 as hr UNION all SELECT 12 as hr) h left join ChambresReservations cr ON h.hr = Month(cr.dateDu) AND cr.dateDu BETWEEN '".$year."-01-01' AND '".$year."-12-31' AND cr.isCanceled = false AND cr.isNoshow = false
			left join Reservations r on r.idReservation = cr.idReservation AND r.isArchive = 0

		 GROUP BY h.hr ORDER BY h.hr")->result_array();

	}

	public function setCheckin($idCR,$idReservation,$type = true){

		$this->db->set('isCheckin',true);
		if($type){
			$this->db->where('idCR',$idCR);
		}else{
			$this->db->where('idReservation',$idReservation);
		}
		if($this->db->update('ChambresReservations')){

			$this->db->where('idReservation',$idReservation);
			$this->db->where('isCheckin',false);
			$rCheckout = $this->db->get('ChambresReservations');
			if($rCheckout->num_rows()==0){

				$this->db->set('isCheckin',true);
				$this->db->where('idReservation',$idReservation);
				return $this->db->update('Reservations');

			}
		}
		return false;

	}



	public function setCancel($idReservation){

		$this->db->set('isCanceled',true);

		$this->db->where('idReservation',$idReservation);
		return $this->db->update('ChambresReservations');
		
	}

	// public function setNoshow($idReservation){

	// 	$this->db->set('isNoshow',true);

	// 	$this->db->where('idReservation',$idReservation);
	// 	return $this->db->update('ChambresReservations');
		
	// }

	public function setAffectatinCh($idReservation,$idCh){

		$this->db->set('idChambres',$idCh);
		$this->db->where('idCR',$idReservation);
		return $this->db->update('ChambresReservations');
		echo $this->db->error();
		
	}

	public function getReservationFromLog($month){

		// $this->db->where('MONTH(dateCreation)',$month);
		$this->db->order_by('idLog');
		return $this->db->get('Logs')->result_array();

	}


	public function getDeviseBase($devise,$auto = true){

		$this->db->where('devise',$devise);
		$this->db->limit(1);
		$rqDevise = $this->db->get('Devises');
		if($rqDevise->num_rows()>0){
			if($auto){
				return $rqDevise->row()->taux;
			}else{
				return $rqDevise->row()->tauxManuel;
			}
		}else{
			return 1;
		}

	}


	public function getCardex(){
		return $this->db->get('Cardex')->result_array();
	}

	public function getChambresLibre($dated,$datef,$idTypeChambre){
		$this->db->select('Chambres.idChambres,DateAu,dateDu,ChambresTypesChambre.idTypeChambres,Chambres.nomChambre');

		$this->db->join('ChambresTypesChambre',"Chambres.idChambres = ChambresTypesChambre.idChambres");
		$this->db->join('ChambresReservations',"Chambres.idChambres = ChambresReservations.idChambres AND DateAu > '".$dated."' AND dateDu < '".$datef."'",'LEFT');
		$this->db->where('ChambresTypesChambre.idTypeChambres',$idTypeChambre);
		$this->db->where('ChambresReservations.dateDu');
		return $this->db->get('Chambres')->result_array();
		echo $str = $this->db->last_query();

	}

	public function getTousChambresLibre($dated,$datef){
		$this->db->select('Chambres.idChambres,DateAu,dateDu,ChambresTypesChambre.idTypeChambres,Chambres.nomChambre,');

		$this->db->join('ChambresTypesChambre',"Chambres.idChambres = ChambresTypesChambre.idChambres");
		$this->db->join('ChambresReservations',"Chambres.idChambres = ChambresReservations.idChambres AND DateAu > '".$dated."' AND dateDu < '".$datef."'",'LEFT');
		$this->db->where('ChambresReservations.dateDu');
		return $this->db->get('Chambres')->result_array();
		echo $str = $this->db->last_query();

	}

	public function getRCardex(){
		$this->db->select('Cardex.nom as value,Cardex.nom as label,Cardex.Adresse,Cardex.ville,Cardex.idPays,Cardex.tel,Cardex.email,Pays.alpha_2 as pays,Cardex.idCardex as id');
		$this->db->join('Pays','Pays.alpha_2=Cardex.idPays','LEFT');
		return $this->db->get('Cardex')->result_array();
	}

	public function getModePaiements(){

		$this->db->where('idModePaimenet !=',0);
		return $this->db->get('ModePaiements')->result_array();

	}

	public function updateRoom($idDCR,$prix,$pension,$prixChanged,$nprix){

		$diff = 0;

		$this->db->select('Reservations.Total,ChambresReservations.prix,Reservations.sousTotal,ChambresReservations.idCR,DetailsTarif.idTypePassage,DetailsTarif.idTarif,Reservations.idReservation,DatesChambreRes.prix as dprix');

		$this->db->where('idDCR',$idDCR)
		->join('ChannelTarifs','ChannelTarifs.idChannelTarif = DatesChambreRes.idTarif','LEFT')
		->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT')
		->join('ChambresReservations','ChambresReservations.idCR = DatesChambreRes.idCR','LEFT')
		->join('Reservations','Reservations.idReservation = DatesChambreRes.idReservation','LEFT')
		->limit(1);
		$query = $this->db->get('DatesChambreRes');
		
		if($query->num_rows()>0){

			$total = $query->row()->Total;
			$prixCR = $query->row()->prix;
			$sousTotal = $query->row()->sousTotal;
			$idCR = $query->row()->idCR;
			$idReservation = $query->row()->idReservation;
			$prixCR = $query->row()->prix;
			$dprix = $query->row()->dprix;


			$this->db->join('ChannelTarifs','DetailsTarif.idDetTar = ChannelTarifs.idDetTar')
			->where('idTypePassage',$query->row()->idTypePassage)
			->where('idTarif',$query->row()->idTarif)
			->where('idPension',$pension);

			$query2 = $this->db->get('DetailsTarif');

			if($query2->num_rows()>0){

				$idTarif =  $query2->row()->idChannelTarif;

			}else{
				return false;
			}

		}else{
			return false;
		}


		$this->db->where('idDCR',$idDCR);
		if($prix != $prixChanged){
			$this->db->set('prix',$nprix);

			$diff = $nprix - $dprix;

		}
		
		$this->db->set('idTarif',$idTarif);
		if($this->db->update('DatesChambreRes')){


			if($prix != $prixChanged){

				$total += $diff;
				$prixCR += $diff;
				$sousTotal += $diff;

				$this->db->set('Total',$total);
				$this->db->set('sousTotal',$sousTotal);
				$this->db->where('idReservation',$idReservation);
				$this->db->update('Reservations');


				$this->db->set('prix',$sousTotal);
				$this->db->where('idCR',$idCR);
				$this->db->update('ChambresReservations');

			}

			return true;

		}else{
			return false;
		}

	}




	public function setNoshow($idCR,$idReservation){

		$this->db->set('isNoshow',true);
		$this->db->where('idCR',$idCR);
		if($this->db->update('ChambresReservations')){
			$this->db->where('idReservation',$idReservation);
			$this->db->where('isNoshow',false);
			$query = $this->db->get('ChambresReservations');
			if($query->num_rows()==0){
				$this->db->set('isNoshow',true);
				$this->db->where('idReservation',$idReservation);
				return $this->db->update('Reservations');
			}
			return true;
		}
		return false;

	}

	public function insertDetailFacture($idReservation,$idCR,$prix,$idExtra,$date){

		$this->db->set('prix',$prix);
		$this->db->set('idReservation',$idReservation);
		$this->db->set('idCR',$idCR);
		$this->db->set('idExtra',$idExtra);
		$this->db->set('date',$date);
		return $this->db->insert('DetailsFacture');
	}

	public function insertRoomReservation($room,$dates,$idReservation,$providerId,$total){


		$this->db->trans_start(); # Starting Transaction

		$this->db->trans_strict(TRUE); # 

		$this->db->insert('ChambresReservations', $room); 

		$idCR = $this->db->insert_id();

		foreach ($dates as $key => $date) {

			$datesChambreRes = array("prix"=>$date['prix'],"date"=>$date['date'],"idCR"=>$idCR,"idTarif"=>$date['idChannelTarif'],"idReservation"=>$idReservation,"providerId"=>$providerId);

			$this->db->insert('DatesChambreRes', $datesChambreRes); 
		}

		# Updating data
		$this->db->where('idReservation', $idReservation);

		$this->db->set('etat', 'modify');
		$this->db->set('isModified', true);
		$this->db->set('sousTotal', 'sousTotal+(changeRate * '.$total.')',False);
		$this->db->set('Total', 'Total+(changeRate * '.$total.')',False);

		$this->db->update('Reservations'); 

		$this->db->trans_complete(); # Completing transaction

		/*Optional*/

		if ($this->db->trans_status() === FALSE) {
		    # Something went wrong.
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    # Everything is Perfect. 
		    # Committing data to the database.
		    $this->db->trans_commit();
		    return TRUE;
		}

	}


	public function getReservationD($idReservation){


		$this->db->select('Reservations.dateDu,Reservations.dateAu,Reservations.client,Reservations.Total,Reservations.sousTotal,Reservations.providerId,Reservations.total_guests,Reservations.total_rooms,Reservations.changeRate');

		$this->db->where('Reservations.idReservation',$idReservation);

		$this->db->limit(1);

		return $this->db->get('Reservations')->result_array();
		var_dump($this->db->error());
	}
	public function getRoomReservationD($idCR){

		$this->db->select('TypesChambres.idTypeChambres,ChannelTarifs.idDetTar,Reservations.dateDu,Reservations.dateAu,Reservations.client,ChambresReservations.totalAdult as adult,ChambresReservations.totalEnfant as child,ChambresReservations.isCheckin,ChambresReservations.prix,Reservations.Total,Reservations.sousTotal,ChambresReservations.idChambres,ChambresReservations.providerId,Reservations.total_guests,Reservations.total_rooms,ChambresReservations.dateDu dateDuR,ChambresReservations.dateAu dateAuR,Reservations.changeRate');

		$this->db->join('Reservations','Reservations.idReservation = ChambresReservations.idReservation','LEFT');

		$this->db->join('ChannelTarifs','ChannelTarifs.idChannelTarif = ChambresReservations.idTarif','LEFT');

		$this->db->join('TypesChambres','ChannelTarifs.idTypeChambres = TypesChambres.idTypeChambres','LEFT');

		$this->db->join('DetailsTarif','DetailsTarif.idDetTar = ChannelTarifs.idDetTar','LEFT');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension','LEFT');

		$this->db->where('ChambresReservations.idCR',$idCR);

		$this->db->where('ChambresReservations.isCanceled',False);

		$this->db->limit(1);

		return $this->db->get('ChambresReservations')->result_array();
	}

}


