<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class StocksModel extends CI_Model
{

	public function getInventaires(){


		$this->db->select('Inventaires.idInventaire,IFNULL(FamillesArticles.familleArticle,"Tous") as familleArticle,Depots.depot,(CASE Inventaires.etat WHEN "0" THEN "Cree" WHEN "1" THEN "Encours" WHEN "2" THEN "Valide" END) AS etat,Inventaires.date');

		$this->db->join('FamillesArticles','FamillesArticles.idFA = Inventaires.idFamilleArticle','LEFT');

		$this->db->join('Depots','Depots.idD = Inventaires.idDepot');

		$this->db->order_by('Inventaires.idInventaire','DESC');

		return $this->db->get('Inventaires')->result_array();


	}

	public function getDetailsInventaire($idInventaire){

		$this->db->join('Produits','Produits.idProduit = DetailsInventaire.idProduit');

		$this->db->where('DetailsInventaire.idInventaire',$idInventaire);

		$this->db->order_by('Produits.DESIGNAT','ASC');

		return $this->db->get('DetailsInventaire')->result_array();

	}

	public function insertInventaire($inventaire,$idUser){

		$invent = json_decode($inventaire);

		$this->db->trans_start(); 

		$this->db->trans_strict(TRUE); 

		$this->db->set('idDepot',$invent->idDepot);

		$this->db->set('idFamilleArticle',$invent->idFamilleArticle);

		$this->db->set('date',$invent->date);

		$this->db->set('description',(isset($invent->description))?$invent->description:'');

		$this->db->insert('Inventaires'); 

		$id = $this->db->insert_id();

		$this->db->select('Produits.idProduit,DepotProduit.qte');

		$this->db->join('DepotProduit','DepotProduit.idProduit = Produits.idProduit AND DepotProduit.idDepot = '.$invent->idDepot);

		$articles = $this->db->get('Produits');

		if($articles->num_rows()>0){

			foreach ($articles->result() as $key => $article) {

				$this->db->set('idInventaire',$id);

				$this->db->set('idProduit',$article->idProduit);

				$this->db->set('qte',$article->qte);

				$this->db->set('qteInv',0);

				$this->db->set('ecart',0);

				$this->db->set('justification','');

				$this->db->insert('DetailsInventaire'); 
	
			}

		}

		$this->db->set('idUtilisateur',$idUser);

		$this->db->set('id',$id);

		$this->db->set('idDocu','');

		$this->db->set('type',50);

		$this->db->set('idDocO','');

		$this->db->set('json',$inventaire);
		
		$this->db->insert('ActivitiesUtilisateur');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		}else {
		    $this->db->trans_commit();
		    return TRUE;
		}
	}

}
?>