<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class TarifsModel extends CI_Model
{




	public function insertTarif($nomTarif,$idtt,$ctarif,$pensions,$tpassages){

		$this->db->trans_start();
		$this->db->trans_strict(TRUE);

		$this->db->set('tarif',$nomTarif);
		$this->db->set('idTT',$idtt);
		$this->db->set('codeTarif',$ctarif);
		$this->db->insert('Tarifs');
		$idTar = $this->db->insert_id();

		$this->db->where('active',TRUE);
		$chambres = $this->db->get('TypesChambres')->result_array();

		foreach ($pensions as $key => $pension) {


			foreach ($tpassages as $key => $tpassage) {

			    $this->db->set('idTarif',$idTar);
			    $this->db->set('idPension',$pension);
			    $this->db->set('idTypePassage',$tpassage);
			    $this->db->insert('DetailsTarif');
			    $idDetTar = $this->db->insert_id();

				foreach ($chambres as $key => $chambre) {

					$this->db->set('idTypeChambres',$chambre['idTypeChambres']);
				    $this->db->set('idDetTar',$idDetTar);

					$this->db->set('idChannelChambre','HEXA:'.$chambre['idTypeChambres']);
				    $this->db->set('idChannelTarif',$idDetTar.':HEXA:'.$chambre['idTypeChambres']);

					$this->db->set('availabilityUpdate',false);
				    $this->db->set('restrictionsUpdate',false);
				    $this->db->set('priceUpdate',false);

				    $this->db->set('isOnline',false);

					$this->db->insert('ChannelTarifs');

				}

			}							
		}
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
		    $this->db->trans_rollback();
		    return FALSE;
		} 
		else {
		    $this->db->trans_commit();
		    return TRUE;
		}


			
	}




	public function getDatesPrixTarif($idDetTar,$idCh,$dated,$datef){



		$this->db->select('DetTarJour.date,DetTarJour.prix,ChannelTarifs.idChannelTarif');
		$this->db->join('ChannelTarifs','ChannelTarifs.idDetTar = DetTarJour.idDetailTarif AND ChannelTarifs.idTypeChambres = DetTarJour.idTypesChambre');
		$this->db->where('DetTarJour.idTypesChambre',$idCh);
		$this->db->where('DetTarJour.idDetailTarif',$idDetTar);
		$this->db->where('DetTarJour.date>=',$dated);
		$this->db->where('DetTarJour.date<',$datef);
		$this->db->group_by('DetTarJour.date');
		return $this->db->get('DetTarJour')->result_array();
		echo $this->db->last_query();

	}

	public function updateDisponibilite($disponibilite,$date,$idCh){

		$this->db->set('disponibilite',$disponibilite);
		$this->db->set('synchronise',false);
        $this->db->where('date',$date);
        $this->db->where('idTypesChambre',$idCh);
		return $this->db->update('DetTarJour');

	}

	public function updatePrix($prix,$date,$idCh,$idTar){

		$this->db->set('prix',$prix);
        $this->db->where('date',$date);
        $this->db->where('idTypesChambre',$idCh);
        $this->db->where('idDetailTarif',$idTar);
		return $this->db->update('DetTarJour');

	}

	public function getTarifs(){

		$this->db->select('TypesTarifs.typeTarif,Tarifs.dateCreation,Tarifs.idTarif,Tarifs.codeTarif,Tarifs.tarif');
		$this->db->join('TypesTarifs','TypesTarifs.idTT = Tarifs.idTT','LEFT');
		$this->db->where('Tarifs.active',TRUE);
		return $this->db->get('Tarifs')->result_array();
	}


	public function getTarif($idTarif){

		$this->db->where('Tarifs.idTarif',$idTarif);
		$this->db->where('Tarifs.active',TRUE);
		return $this->db->get('Tarifs')->result_array();
	}

	public function getTarifDate($dated,$datef,$idch,$idtarif){

		$this->db->select('DetTarJour.date,TypesChambres.nomTypeChambres,Pensions.pension,DetTarJour.prix');

		$this->db->where('date>=',$dated);
		$this->db->where('date<',$datef);
		$this->db->where('idTypesChambre',$idch);
		$this->db->where('idDetailTarif',$idtarif);
		$this->db->join('DetailsTarif','DetTarJour.idDetailTarif = DetailsTarif.idDetTar');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');
		$this->db->join('TypesChambres','DetTarJour.idTypesChambre = TypesChambres.idTypeChambres');
		return $this->db->get('DetTarJour')->result_array();
		echo $this->db->last_query();

	}

	public function getTarifChannelCode($codeChannel){


		$this->db->join('Tarifs','Tarifs.idTarif = TarifsChannel.idTarif');

		$this->db->join('DetailsTarif','DetailsTarif.idTarif = TarifsChannel.idTarif');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');

		$this->db->join('TypesPassage','DetailsTarif.idTypePassage = TypesPassage.idTypePassage');

		$this->db->join('Channels','Channels.idChannel = TarifsChannel.idChannel');

		$this->db->where('Channels.channel',$codeChannel);

		return $this->db->get('TarifsChannel')->result_array();

	}


	public function getTarifChannel($idChannel){


		$this->db->join('Tarifs','Tarifs.idTarif = TarifsChannel.idTarif');

		$this->db->join('DetailsTarif','DetailsTarif.idTarif = TarifsChannel.idTarif');

		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');

		$this->db->join('TypesPassage','DetailsTarif.idTypePassage = TypesPassage.idTypePassage');

		$this->db->where('TarifsChannel.idChannel',$idChannel);

		return $this->db->get('TarifsChannel')->result_array();

	}


	public function insert($nomTarif,$typeTarif,$codeTarif){

		$this->db->set('tarif',$nomTarif);
		$this->db->set('idTT',$typeTarif);
		$this->db->set('codeTarif',$codeTarif);
		$this->db->insert('Tarifs');
		$idlast = $this->db->insert_id();
		return $idlast;	

	}

	 public function insertTarifChambres($idTypeChambres,$idDetTar,$idChannelChambres,$idChannelTarif){


	 	$this->db->set('idTypeChambres',$idTypeChambres);
    	$this->db->set('idDetTar',$idDetTar);

	 	$this->db->set('idChannelChambre',$idChannelChambres);
    	$this->db->set('idChannelTarif',$idChannelTarif);

		$this->db->set('availabilityUpdate',false);
    	$this->db->set('restrictionsUpdate',false);
    	$this->db->set('priceUpdate',false);

    	$this->db->set('isOnline',false);

	 	return $this->db->insert('ChannelTarifs');


    }


    public function insertTarifPension($idTarif,$idPension,$idTypePassage){

    	$this->db->set('idTarif',$idTarif);
    	$this->db->set('idPension',$idPension);
    	$this->db->set('idTypePassage',$idTypePassage);
    	$this->db->insert('DetailsTarif');
    	$idlast = $this->db->insert_id();
		return $idlast;	

    }

	public function insertTarifJourf($insert_data) {


	    $sql = $this->db->insert_string('DetTarJour', $insert_data) . ' ON DUPLICATE KEY UPDATE prix=prix+1';
		return $this->db->query($sql);
	}


	public function insertTarifJour($insert_data){

		return $this->db->insert_on_duplicate_update_batch('DetTarJour',$insert_data);
	}




	public function checkTarifChannel($idTarif,$idChambre){

		$this->db->where('idChannelTarif',$idTarif);
		$qCTarif = $this->db->get('ChannelTarifs');
		if($qCTarif->num_rows()>0){

			return $qCTarif->row()->idChannelTarif;

		}else{

			$this->db->set('idChannelTarif',$idTarif);
			$this->db->set('idChannelChambre',$idChambre);
			if($this->db->insert('ChannelTarifs')){
				$idlast = $this->db->insert_id();
				return $idlast;	
			}
		}
		return null;

	}

	public function getChannelTarif($typeChambre,$pension){

		$this->db->where('idDetTar',$pension);
		$this->db->where('idTypeChambres',$typeChambre);
		$this->db->limit(1);
		$qCTarif = $this->db->get('ChannelTarifs');
		if($qCTarif->num_rows()>0){
			return $qCTarif->row()->idChannelTarif;
		}
		return null;


	}

	public function getTarifAll(){



		$this->db->join('DetailsTarif','Tarifs.idTarif = DetailsTarif.idTarif');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');
		$this->db->join('TypesPassage','DetailsTarif.idTypePassage = TypesPassage.idTypePassage');
		$this->db->order_by('Tarifs.tarif');
		$this->db->where('Tarifs.active',TRUE);

		return $this->db->get('Tarifs')->result_array();


	}



	public function getTarifsChannel($idChannel){

		$this->db->select('Tarifs.idTarif,Tarifs.tarif,Pensions.codePension,DetailsTarif.remboursale,DetailsTarif.idDetTar,Tarifs.codeTarif');

		$this->db->join('Tarifs','Tarifs.idTarif = TarifsChannel.idTarif');
		$this->db->join('DetailsTarif','Tarifs.idTarif = DetailsTarif.idTarif');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');
		$this->db->where('TarifsChannel.idChannel',$idChannel);
		$this->db->order_by('Tarifs.idTarif');
		return $this->db->get('TarifsChannel')->result_array();

	}

	public function getTarifUnique(){
		$this->db->select('DetailsTarif.idDetTar,Tarifs.idTarif,Tarifs.tarif,Pensions.codePension,DetailsTarif.remboursale,Pensions.pension');

		$this->db->join('DetailsTarif','Tarifs.idTarif = DetailsTarif.idTarif');
		$this->db->join('Pensions','DetailsTarif.idPension = Pensions.idPension');

		$this->db->where('Tarifs.active',true);

		$this->db->group_by('DetailsTarif.idDetTar');

		return $this->db->get('Tarifs')->result_array();

	}
}