<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class UstensilesModel extends CI_Model
{

	public function getUstensiles(){
		$this->db->where('active',TRUE);
		return $this->db->get('Ustensiles')->result_array();
	}

	public function insert($usten,$qte){
		$data = array('ustensile'=>$usten,'qte'=>$qte);
		return $this->db->insert('Ustensiles',$data);
	}

	public function update($usten,$qte,$id){
		$this->db->set('ustensile',$usten);
		$this->db->set('qte',$qte);
		$this->db->where('idUstensile',$id);
		return $this->db->update('Ustensiles');
	}
	public function delete($id){
		$this->db->set('active',FALSE);
		$this->db->where('idUstensile',$id);
		return $this->db->update('Ustensiles');
	}

	public function getUstensile($id){
		$this->db->where('idUstensile',$id);
		return $this->db->get('Ustensiles')->row();
	}

	public function getFactureUstensiles($id){
		$this->db->select('Ustensiles.ustensile,FactureUstensiles.qte,Ustensiles.idUstensile');
		$this->db->join('Ustensiles','Ustensiles.idUstensile = FactureUstensiles.idUstensile');
		$this->db->where('FactureUstensiles.idFacture',$id);
		return $this->db->get('FactureUstensiles')->result_array();
	}

	public function addUstensiles($items,$idFacture){
		foreach ($items as $item) {
			$data = array('idUstensile'=>$item['id'],'qte'=>$item['qte'],'idFacture'=>$idFacture);
			$this->db->insert('FactureUstensiles',$data);
		}
		echo 'true';
	}

	public function removeUstensiles($idFacture){
		$this->db->where('idFacture',$idFacture);
		return $this->db->delete('FactureUstensiles');
	}

	public function getFacturesU(){

		$this->db->select('Factures.idFacture,Ustensiles.ustensile,FactureUstensiles.qte,Clients.nomClient,Factures.dateCreation,FactureUstensiles.idFU');
		$this->db->join('FactureUstensiles','Factures.idFacture = FactureUstensiles.idFacture');
		$this->db->join('Ustensiles','Ustensiles.idUstensile = FactureUstensiles.idUstensile');
		$this->db->join('Clients','Clients.idClient = Factures.idClient','LEFT');
		$this->db->where('FactureUstensiles.recuperer',FALSE);
		$this->db->order_by('Factures.dateCreation','ASC');
		return $this->db->get('Factures')->result_array();
	}

	public function setRecuperer($id){

		$this->db->set('recuperer',TRUE);
		$this->db->where('idFU',$id);
		return $this->db->update('FactureUstensiles');

	}



}