<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard with Custom Borders</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body {
      font-family: 'Montserrat', sans-serif;
      background-color: #f5f7fa; /* Light background */
    }

    .dashboard-header {
      margin-bottom: 30px;
    }

    .dashboard-header p {
      font-size: 0.8rem;
      font-weight: 500;
      color: #6c757d;
      margin: 0;
    }

    .dashboard-header h1 {
      font-size: 1.8rem;
      font-weight: 600;
      margin: 5px 0;
    }

    .card:hover {
      box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2); /* Slightly larger shadow on hover */
    }

    .card p {
      font-size: 0.75rem;
      font-weight: 500;
      text-transform: uppercase;
      margin: 0;
      color: #6c757d;
    }

    .card h2 {
      font-size: 1.8rem;
      font-weight: 600;
      margin: 5px 0;
    }

    .card span {
      font-size: 0.9rem;
      font-weight: 500;
    }

    .chart-container {
      margin-top: 15px;
      width: 100%; /* Ensure full width */
      height: 90px; /* Adjust height of charts */
    }

    canvas {
      width: 100% !important; /* Force canvas to occupy full width */
      height: 100% !important; /* Ensure proper height scaling */
    }
    .card {
      --tblr-card-spacer-y: 1rem; /* Vertical padding inside the card */
      --tblr-card-spacer-x: 1.25rem; /* Horizontal padding inside the card */
      --tblr-card-border-width: 1px; /* Thin border for a clean look */
      --tblr-card-border-color: rgba(229, 232, 235, 1); /* Light gray border */
      --tblr-card-border-radius: 10px; /* Rounded corners */
      --tblr-card-box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Subtle shadow */
      --tblr-card-bg: #ffffff; /* Pure white background */
      --tblr-card-height: auto; /* Adjust card height automatically based on content */
      position: relative;
      display: flex;
      flex-direction: column;
      min-width: 0;
      height: var(--tblr-card-height);
      color: var(--tblr-body-color, #495057); /* Default text color */
      word-wrap: break-word;
      background-color: var(--tblr-card-bg);
      background-clip: border-box;
      border: var(--tblr-card-border-width) solid var(--tblr-card-border-color);
      border-radius: var(--tblr-card-border-radius);
      box-shadow: var(--tblr-card-box-shadow);
      transition: box-shadow 0.3s ease; /* Smooth hover effect */
    }

    .card:hover {
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* Slightly larger shadow on hover */
    }
  </style>
</head>
<body>
  <div class="container mt-5">
    <!-- Header -->
    <div class="dashboard-header">
      <p>Overview</p>
      <h1>Dashboard</h1>
    </div>

    <!-- Main Cards -->
    <div class="row mb-4">
      <!-- Card 1: Line Chart -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="card">
          <p>Sales</p>
          <h2>75%</h2>
          <span class="text-success">7% <i class="bi bi-arrow-up"></i></span>
          <div class="chart-container">
            <canvas id="lineChart"></canvas>
          </div>
        </div>
      </div>

      <!-- Card 2: Bar Chart -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="card">
          <p>Revenue</p>
          <h2>$4,300</h2>
          <span class="text-success">8% <i class="bi bi-arrow-up"></i></span>
          <div class="chart-container">
            <canvas id="barChart"></canvas>
          </div>
        </div>
      </div>

      <!-- Card 3: Dashed Line Chart -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="card">
          <p>New Clients</p>
          <h2>6,782</h2>
          <span class="text-warning">0% <i class="bi bi-dash"></i></span>
          <div class="chart-container">
            <canvas id="dashedLineChart"></canvas>
          </div>
        </div>
      </div>

      <!-- Card 4: Grouped Bar Chart -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="card">
          <p>Active Users</p>
          <h2>2,986</h2>
          <span class="text-success">4% <i class="bi bi-arrow-up"></i></span>
          <div class="chart-container">
            <canvas id="groupedBarChart"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Chart.js Data -->
  <script>
    function createChart(chartId, type, data, color) {
      const ctx = document.getElementById(chartId).getContext('2d');
      new Chart(ctx, {
        type: type,
        data: {
          labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
          datasets: [{
            data: data,
            borderColor: color,
            backgroundColor: `${color}22`,
            fill: true,
            tension: 0.4,
          }]
        },
        options: {
          plugins: { legend: { display: false } },
          scales: { x: { display: false }, y: { display: false } },
          elements: { point: { radius: 0 } },
        }
      });
    }

    createChart('lineChart', 'line', [5, 10, 15, 10, 20, 15, 25], '#007bff');
    createChart('barChart', 'bar', [10, 15, 12, 20, 18, 25, 30], '#28a745');
    createChart('dashedLineChart', 'line', [12, 14, 10, 18, 16, 20, 22], '#ffc107');
    createChart('groupedBarChart', 'bar', [20, 25, 15, 30, 25, 35, 40], '#6c757d');
  </script>
</body>
</html>