<?php
  defined('BASEPATH') OR exit('No direct script access allowed'); 
?>
<style type="text/css">
  
.list-inline-item:not(:last-child) {
    margin-right: 0; 
}
i.action{
  -webkit-text-stroke: 0.8px #011F28 !important;
}
i.clickable {
    -webkit-text-stroke: 1px #011F28 !important;
}
.operationCh:hover{
  transform: scale(1.2);
  cursor: pointer;
}
</style>
<div id="content-wrapper">
  <div class="container-fluid">
        <!-- DataTables Example -->
        <div class="card mb-3">
          <div class="card-header bg-white" >
            <div class="col-12">
              <div class="row h-100">
                <div class="title-header col-12 col-md-8 my-auto p-0">
                  Debiteurs
                </div>
                <div class="col-6  col-md-4 my-auto p-0">
                  <div class="dropdown">
                    <button class="btn float-right btn-hexa-more" id="dropdownMenuMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-ellipsis-h"></i></button>
                  </div>
                  <button class="btn float-right btn-hexa-ajouter" onclick="newReservationPage();" ><i style="font-size:20px" class="fa fa-plus d-block d-sm-none"></i><span class="d-none d-sm-block">Ajouter un reglement</span></button>
                </div>

              </div>
            </div>

           </div>
          <div class="card-body">
                <div class="form-row">
                  <div class="form-group col-md-2">
                        <select id="filtres" class="selectpicker form-control form-input">
                          <option value="1">Toutes</option>
                          <option value="2">Non reglées</option>
                          <option value="3">Reglées</option>
                        </select>
                  </div>
                  <div class="form-group col-md-2">
                    <div class="input-group md-form form-sm form-2 pl-0">
                          <input type="text" class="date-hexa datepicker form-control " id="dateD" data-date-format="YYYY-MM-DD"/>
                          <div class="input-group-append">
                            <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey"
                                aria-hidden="true"></i>
                            </span>
                          </div>
                    </div>
                  </div>
                  <div class="form-group col-md-2">
                  <div class="input-group md-form form-sm form-2 pl-0">
                      <input type="text" class="date-hexa datepicker form-control" id="dateF" data-date-format="YYYY-MM-DD" />
                      <div class="input-group-append">
                        <span class="input-group-text lime lighten-2" id="basic-text1"><i class="fas fa-calendar-alt text-grey"
                            aria-hidden="true"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-md-2">
                    <div class="input-group md-form form-sm form-2 pl-0">
                      <button class="btn float-right btn-hexa-ajouter btn-block btn-filter" onclick="filtrer(this)">  Filtrer</button>
                    </div>
                  </div>
<!--                   <div class="form-group col-md-1">
                    <div class="input-group md-form form-sm form-2 pl-0">
                      <button class="btn float-right btn-hexa-ajouter btn-block btn-filter">  <i class="fa fa-print"></i></button>
                    </div>
                  </div> -->
              </div>


            <div class="table-responsive">
              <table id="dataTable" class="table table-bordered" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Nª facture</th>
                    <th class="text-center">Date</th>
                    <th class="text-center">Client</th>
                    <th class="text-center">Occupant</th>
                    <th class="text-center">Arrive</th>
                    <th class="text-center">Depart</th>
                    <th class="text-center">Montant</th>
                    <th class="text-center">Regle</th>
                    <th class="text-center">Solde</th>
                    <th class="text-center">Actions</th>
                  </tr>
                </thead>
                <tbody>
                   <?php foreach ($factures as $key => $facture): ?>
                    <tr>
                        <td class="align-middle"  style="font-style: italic;font-weight: 600">

                          #<?php echo $facture['idFacture'] ?>

                        </td>
                        <td class="text-center align-middle" style="font-style: italic;font-weight: 600">
                          <?php 
                            $dateAu = new DateTime($facture['dateFacture']);
                            echo $dateAu->format('d/m/Y'); 
                          ?>
                        </td>
                        <td class="align-middle" style="font-style: italic;font-weight: 600"><?php echo $facture['channel'] ?></td>
                        <td class="align-middle">
                          <span class="channel" ><?php echo $facture['client'] ?></span>
                        </td>
                        <td class="text-center align-middle" style="font-style: italic;font-weight: 600">
                          <?php 

                            $dateDu = new DateTime($facture['dateDu']);
                            echo $dateDu->format('d/m/Y'); 

                          ?>
                            
                        </td>
                        <td class="text-center align-middle" style="font-style: italic;font-weight: 600">
                          <?php 
                            $dateAu = new DateTime($facture['dateAu']);
                            echo $dateAu->format('d/m/Y'); 
                          ?>
                        </td>
                        <td class="text-center align-middle"><?php echo number_format($facture['total'] * 1/$facture['changeRate'],2) ?></td>
                        <td class="text-center align-middle"><?php echo number_format($facture['totalRegle'] * 1/$facture['changeRate'],2) ?></td>
                        <td class="text-center align-middle"><?php echo number_format($facture['totalPaye'] * 1/$facture['changeRate'],2) ?></td>

                        <td class="text-center align-middle">
                          <ul class="list-inline">
                            <li class="list-inline-item">
                              <span data-toggle="tooltip" data-placement="top" title="Regler Facture" onclick="" class="fa-stack operationCh">
                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                <i class="fa fa-check fa-stack-1x fa-inverse action" style="font-size: 15px"></i>
                              </span>
                            </li>
                            <li class="list-inline-item">
                              <span data-toggle="tooltip" data-placement="top" title="Modifier Facture" onclick="" class="fa-stack operationCh">
                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                              </span>
                            </li>
                            <li class="list-inline-item">
                              <span data-toggle="tooltip" data-placement="top" title="Imprimer Facture" onclick="" class="fa-stack operationCh">
                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                <i class="fa fa-print fa-stack-1x fa-inverse action" style="font-size: 14px"></i>
                              </span>
                            </li>                          
                          </ul>
                          
                        </td>
                    </tr>
                  <?php endforeach ?> 
                </tbody>
              </table>
            </div>
          </div>

          <?php 
            $dt = new DateTime("now", new DateTimeZone('Africa/Casablanca'));
            $time =  $dt->format('H:i');
          ?>
          <div class="card-footer small text-muted">Mise a jour <?php setlocale(LC_TIME, "fr_FR"); echo 'Le '.strftime("%A %d %B %G  ").$time; ?></div>
        </div>
      </div>
      <!-- /.container-fluid -->
</div>




<script type="text/javascript">

  var tarifs = [];
  var ajaxReq = 'ToCancelPrevReq';
  $(document).ready(function() {

          var fromTimeInput = $('#dateD');
          var toTimeInput = $('#dateF');
          var fromTime = fromTimeInput.val();
          var toTime = toTimeInput.val();

          fromTimeInput.datepicker({
              keyboardNavigation : false,
              forceParse : false,
              endDate: toTime,
              autoclose: true, 
              language: 'fr',
              format: 'dd M yyyy',
              todayHighlight:true
          });
          toTimeInput.datepicker({
              keyboardNavigation : false,
              forceParse : false,
              startDate: fromTime,
              autoclose: true, 
              language: 'fr',
              format: 'dd M yyyy',
              todayHighlight:true
          });
          var ttoday = new Date('<?php echo $dateC ?>');


          fromTimeInput.datepicker('setDate', ttoday);
          fromTimeInput.datepicker('update');
          ttoday.setDate(ttoday.getDate() + 1);
          toTimeInput.datepicker('setDate', ttoday);  
          toTimeInput.datepicker('update');
                  
          fromTimeInput.on("changeDate", function (e) {
              toTimeInput.datepicker('setStartDate', e.date);
          });
          toTimeInput.on("changeDate", function (e) {
              fromTimeInput.datepicker('setEndDate', e.date);
          });



          oTable = $('#dataTable').DataTable({
                  fixedHeader: true,
                  bFilter: true,
                  dom: 'T<"clear">lfrtip',
                      "order": [[ 2, "desc" ]],
                      "lengthMenu": false,
                      "lengthChange": false,
                      "language": {
                            "sProcessing":     "Traitement en cours...",
                            "sSearch":         "",
                            "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
                            "sInfo":           "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
                            "sInfoEmpty":      "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
                            "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
                            "sInfoPostFix":    "",
                            "sLoadingRecords": "Chargement en cours...",
                            "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
                            "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
                            "oPaginate": {
                                "sFirst":      "Premier",
                                "sPrevious":   '<i class="fa fa-caret-left"></i>',
                                "sNext":       '<i class="fa fa-caret-right"></i>',
                                "sLast":       "Dernier"
                            },
                            "oAria": {
                                "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                                "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
                            },
                            "select": {
                                    "rows": {
                                        _: "%d lignes séléctionnées",
                                        0: "Aucune ligne séléctionnée",
                                        1: "1 ligne séléctionnée"
                                    } 
                            }
                        },
                       "pageLength": 35,
                       aoColumns: [
                         { mData: 'param1' },
                         { mData: 'param2' },
                         { mData: 'param3' },
                         { mData: 'param4' },
                         { mData: 'param5' },
                         { mData: 'param6' },
                         { mData: 'param7' },
                         { mData: 'param8' },
                         { mData: 'param9' },
                         { mData: 'param10' }
                      ],
                        "columnDefs": [
                          { "orderable": false, "targets": [-1, 1] },
                          { "searchable": false, "targets": [-1, 1] },
                          { "className": "align-middle text-center", "targets": [ ,3,4,5,6,7,8,9] },
                          { "className": "align-middle", "targets": [ 0,1,2 ] }
                        ],
                       "info":     false,
                  "responsive": true
                });

              // $('#myInputTextField').keyup(function(){
              //       oTable.search($(this).val()).draw() ;
              // }) 
         });


    function filtrer(elem = null){

        dateObject = $("#dateD").datepicker("getDate");
        dated = $.datepicker.formatDate('yy-mm-dd', dateObject);
        dateObject = $("#dateF").datepicker("getDate");
        datea = $.datepicker.formatDate('yy-mm-dd', dateObject);

        filtres = $('#filtres').val();
        $.ajax({
           url:'<?=base_url()?>Reservations/filtrerReservations',
           method: 'post',
           dataType: 'json',
           data: {dated:dated,datea:datea,filtres:filtres},

           beforeSend: function(){
              $(elem).html('<i class="fa fa-circle-notch fa-spin"></i>');
              $(elem).attr("disabled","disabled");
              $('#dataTable').css({'opacity':'0.4'});
           },
           success: function(data){
                if (data == '') {

                }else if (!data.session) {
                  window.location.replace("login");
                }else if (!data.status) {
                  
                }else{


                      
                  $('#dataTable').css({'opacity':'1'});
                  $(elem).html('Filtrer');
                  $(elem).removeAttr("disabled");   
                  var myTable = $('#dataTable').DataTable();
                  myTable.clear().rows.add(data.data).draw();

                  $('#imprimerList').attr('href','<?php echo base_url() ?>Reservations/printListReservation/'+filtres+'/'+dated+'/'+datea+'/');
                }
           },
              error: function (event, jqXHR, ajaxSettings, thrownError)
              {
                  $('#dataTable').css({'opacity':'1'});
                  $(elem).html('Filtrer');
                  $(elem).removeAttr("disabled");   
                  showErrorToast(ajaxSettings,thrownError,event,jqXHR);
              }
        });
    }

  function showErrorToast(ajaxSettings,thrownError,event,jqXHR){

    error = '';
    if(ajaxSettings){
                      error = ajaxSettings;
    }else if(thrownError){
                      error = thrownError;
    }else if(event){
                      error = event;
    }else if(jqXHR){
                      error = jqXHR;
    }

    $.toast({ heading: 'Error', icon: 'error', text : error, showHideTransition : 'slide', allowToastClose : true, hideAfter : 5000,stack : 5, textAlign : 'left',position : 'bottom-right'})
  }

  function newReservationPage(){

    window.location.href = '<?php echo base_url() ?>addReglement'
  }


</script>

<?php 

function getEtatList($etat){

    switch ($etat) {
        case 'noshow':
            return 'Noshow';
            break;
        case 'checkin':
            return 'Checkin';
            break;    
        case 'checkout':
            return 'Checkout';
            break;  
        case 'modify':
            return 'Modifiée';
            break; 
        case 'canceled' :
            return 'Annulée';
            break;  
        case 'confirm':
            return 'Reservée';
            break;  
        case 'cancel' :
            return 'Annulée';
            break;                      
        default:

            return 'N/A';
            break;
    }
}

?>