<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>
<style type="text/css">
.tab-pane {
    border-left: 1px solid #dee2e6;
    border-right: 1px solid #dee2e6;
    border-bottom: 1px solid #dee2e6;
}

input {
    font-size: 14px !important;
    border-radius: 2px !important;

}

textarea {
    font-size: 14px !important;
    border-radius: 2px !important;
}

::placeholder {
    /* Chrome, Firefox, Opera, Safari 10.1+ */
    color: #93AAAF !important;
    opacity: 1;
    /* Firefox */
}

:-ms-input-placeholder {
    /* Internet Explorer 10-11 */
    color: #93AAAF !important;
}

::-ms-input-placeholder {
    /* Microsoft Edge */
    color: #93AAAF !important;
}

.bootstrap-select .btn {
    background-color: #fff;
    border-color: #D3DEDC;
    color: #00B0EB;
    font-size: 14px !important;
    border-radius: 0.15rem !important;

}

.filter-option {
    color: #1D515C;
}


.card-body {

    padding: 0;
}

.nav-tabs .nav-link {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
}

.action-text {
    color: #00B0EB;
    font-size: 14px !important;
    text-decoration: underline;
    cursor: pointer;
    font-style: italic;
}

.delete-text {
    color: #C0392B;
    font-size: 14px !important;
    text-decoration: underline;
    cursor: pointer
}


label {
    margin-bottom: 0.2rem;
    font-size: 12px !important;
    color: #7D9AA0;
    font-style: italic;
    font-weight: 700;
}

.bootstrap-select .dropdown-menu {
    font-size: 14px !important;
    background-color: #fff !important;
    color: #021F29 !important;
    border: 1px solid #ced4da !important;
    padding: 0 !important;
    border-radius: 2px !important;
}

.inner .dropdown-item {
    padding: 0.5rem 1rem !important;
    font-size: 14px !important;
    color: #7E959C !important;
}

.inner .dropdown-item.active {

    color: #fff !important;
    background-color: #032C3B;
    font-weight: 600;
}

.form-group {
    margin-bottom: 0.75rem !important;
    border-radius: 2px !important;


}

.ui-widget-content {
    border: 1px solid #ced4da !important;
    font-size: 14px !important;
    background-color: #fff !important;
    border-radius: 2px !important;

}
#overlay,#overlay1,#overlay2 {
    position: absolute;
    display: none;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ffffff;
    z-index: 20000;
    cursor: pointer;
}

#center_middle,#center_middle1 {
    margin: 0;
    position: absolute;

    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}
.spinner {
        width: 100px;
        height: 100px;
        display: inline-block;
        border-width: 4px;
         border-color: #CAD6D4;
        border-top-color: #021F29;
        animation: spin 3s infinite linear;
        border-radius: 100%;
        border-style: solid;
}
#nav-ch,#nav-res,#nav-ex,#nav-rg,#nav-hs{

    min-height: 50vh;

}
.text-spinner{
    display: block;
    font-weight: 600!important;
    font-style: italic;
    text-align: center;
    font-size: 12px!important;
}
.text-remar{

  margin-bottom: 10px
}

.hexa-box{
    padding: 8px 2px;
    width:100%;
    margin: 2px;
    border-radius: 4px;
    transition: transform .05s;
   
}
.hexa-box-open:hover,.hexa-box-checkout:hover{
    cursor:pointer;
    transform: scale(1.04);
    border: 2px solid #89693c!important;
    color: #89693c!important;
}

.hexa-box-open{
    background: #c7efcf;
    border: 2px solid #377771;
    color: #377771;
}

.hexa-box-checkin{
    background: #fef0db;
    border: 2px solid #89693c;
    color: #89693c;
}
.hexa-box-checkout{
    background: rgba(253, 197, 208, 0.7);
    border: 2px solid #a93e53;
    color: #a93e53;
}
span.hexa-item{
    font-style: italic;
    font-weight: 800;
    display:block;
    width:100%;
    font-size: 50%;
    white-space: nowrap;
}
span.hexa-item:empty:before {
  content: "\200b";
}
.form-controll {
    display: block;
    width: 100%;
    line-height: 1.5;
}
.hexa-nav{padding: 0.75rem 1.25rem!important; font-size: 16px!important; font-style: italic!important; } 
.operationCh{font-size: 14px;cursor: pointer}
.nav-tabs .tab-app.active{background-color:#F8FAFF!important;border-top: 3px solid #1CA4D9 !important;border-bottom:1px solid #F8FAFF!important}
.bootstrap-select .dropdown-menu{min-width:100%!important;max-width:100%!important}
.hexa-item-m{font-style: italic;font-weight: 800;display:block;width:100%;white-space: nowrap;text-overflow: ellipsis;}
.hexa-item-s{font-style: italic;font-weight: 800;display:block;width:100%;font-size: 50%}
.hexa-item-c{font-style: italic;font-weight: 800;display:block;width:100%;font-size: 50%}
#reglemnt-res{color: #1D515C!important;font-style: italic!important;font-weight: 600!important}
.text-labbbb {background: #B68C23; padding: 0.5px 2px; border-radius: 2px; color: white; font-size: 8px; font-style: italic; font-weight: 800; text-transform: capitalize; border: 1px solid #3D2F0A; } .hexa_input_reg{color: #1D515C!important;font-style: italic!important;font-weight: 600!important}
.hexa_row_reg{border-bottom:1px solid #dee2e6!important;color: #1D515C!important;font-style: italic!important;font-weight: 600!important;font-size: 14px;}
.hexa_row_reg_des{border-bottom:1px solid #dee2e6!important;color: #1D515C!important;font-style: italic!important;font-weight: 600!important;font-size: 14px;}

.hexa_row_reg .fa-circle{font-size: 18px;color: #1D515C}
.hexa_row_reg_active{font-weight: 800!important;background:#B1E7D0!important;}
.hexa_row_reg_active .fa-circle:before {content: "\f058";}
.hexa_row_reg:hover{cursor: pointer;font-weight: 800!important;background:#E0F5EC;}
.hexa_row_reg:hover .fa-circle:before {content: "\f058";}
#hexa-text-regl{font-size: 28px;color: #011F28;font-weight: 700;font-style:italic}
#mod_notes{font-style: italic;font-size: 70% !important;}
.text-lab{font-style: italic;font-weight: 700;}

.active-reg{font-weight: 800!important;background:#e1fff2!important;}

.active-reg .fa-square:before {content: "\f14a";}
.hexa-text-paye{font-size: 22px;color: #011F28;font-weight: 700;font-style:italic;padding-right: 6px;}
.hexa-tot-payee{font-size: 28px;color: #011F28;font-weight: 700;font-style:italic}
.body-content{
    min-height: 40vh;
}
.hexa-lock{
    -webkit-text-stroke: 1px #011F28 !important;
    color: #adb5bd;
    font-size: 20px;
    padding: 10px;
    vertical-align: bottom;
}
</style>
<div id="content-wrapper">
    <div class="container-fluid">
        <div class="card mb-3">
            <div class="card-header bg-white">
                <div class="col-12">
                    <div class="row h-100">
                        <div class="title-header col-12 col-md-4 my-auto p-0">
                            Reservation#<?php echo $reservation->providerId ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <nav>
                    <div class="nav nav-tabs bg-white" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link active tab-app hexa-nav" id="nav-res-tab" data-toggle="tab" href="#nav-res" role="tab" aria-controls="nav-res" aria-selected="true" >Reservation</a>
                        <a class="nav-item nav-link tab-app hexa-nav" id="nav-ch-tab" data-toggle="tab" href="#nav-ch" role="tab" aria-controls="nav-ch" aria-selected="false">Chambres</a>
                        <a class="nav-item nav-link tab-app hexa-nav" id="nav-ex-tab" data-toggle="tab" href="#nav-ex" role="tab" aria-controls="nav-ex" aria-selected="false">Extras</a>
                        <a class="nav-item nav-link tab-app hexa-nav" id="nav-rg-tab" data-toggle="tab" href="#nav-rg" role="tab" aria-controls="nav-rg" aria-selected="false">Facturation</a>
                        <a class="nav-item nav-link tab-app hexa-nav" id="nav-hs-tab" data-toggle="tab" href="#nav-hs" role="tab" aria-controls="nav-hs" aria-selected="false">Historique</a>
                    </div>
                </nav>

                <div class="tab-content bg-white position-relative" id="nav-tabContent">
                    <div id="overlay">
                        <div class="conatiner">
                            <div id="center_middle" class="text-center">

                                <span class="spinner"></span>
                                <span class="text-spinner">Enregistrement en cours ...</span>
                                            
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade show active" id="nav-res" role="tabpanel" aria-labelledby="nav-res-tab">
                        <div id="content-reservation">
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> 
                                        <span class="hexa-providerId">#<?php echo $reservation->idReservation ?><i class="fa fa-lock hexa-lock"></i></span> 
                                    </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right hexa-total-resa"><?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?></span>  </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            <?php echo $reservation->channelDisplay ?></span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right"> | Reste : <?php echo number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '') ?></span><span style="font-style:italic" class="float-right"> Payé : <?php echo number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '') ?>  </span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25">
                                        <span class="hexa-date-modi">Dernière modification <?php echo $updatedAt; ?></span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOp" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">
                                            <?php if (!$reservation->isCanceled  && !$reservation->isNoshow && !$reservation->isCheckin): ?>
                                                <?php if (!$reservation->isCheckout): ?>
                                                <button type="button" onclick="editReservationP(this,<?php echo $reservation->idReservation ?>,'<?php echo $reservation->dateDu ?>','<?php echo $reservation->dateAu ?>','<?php echo $codePays ?>')" class="btn btn-info float-right btn-reservation-modal"><i class="fa fa-pen" style="font-size: 12px"></i> Modifier</button>

                                                <button type="button" onclick="cancelReservationP('<?php echo $reservation->idReservation ?>')" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-times" style="font-size: 12px"></i> Annuler</button>

                                                <?php endif?>
                                            <?php endif?>
                                            <a target=”_blank” href="<?php echo base_url() ?>imprimer/<?php echo $reservation->idReservation ?>">
                                                <button type="button" class="btn btn-secondary float-right btn-reservation-modal">
                                                <i class="fa fa-print" style="font-size: 10px"></i> Imprimer </button></a>
                                        </div>
                                    </div>
                                </div>
                            </div> 

                            <div class="body-content">
                                
                                <div id="body-reservation" >
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Etat <span class="text-labb"><?php echo getEtat($reservation->etat) ?></span></span> 
                                                <span class="title-lab">Arrivee <span class="text-labb">
                                                        <?php echo utf8_encode(strftime("%d %B %G", strtotime($reservation->dateDu))) ?></span></span> 
                                                <span class="title-lab">Depart <span class="text-labb">
                                                        <?php echo utf8_encode(strftime("%d %B %G", strtotime($reservation->dateAu))) ?></span></span> 
                                                <span class="title-lab">Nombre de chambre <span class="text-labb">
                                                        <?php echo $reservation->total_rooms ?></span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Source <span class="text-labb">
                                                        <?php echo $reservation->channelDisplay ?></span></span> 
                                                <span class="title-lab">Référence <span class="text-labb">#<?php echo $reservation->providerId ?></span></span> 
                                                <span class="title-lab">Type <span class="text-labb"><?php echo $channel[0]['typeClient'] ?></span></span> 
                                                <span class="title-lab">Nombre de pax <span class="text-labb">
                                                        <?php echo $reservation->total_guests ?></span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-6"> 
                                                <span class="title-lab">Client <span class="text-labb">
                                                        <?php echo $client->nom ?></span></span> 
                                                <span class="title-lab">Telephone <span class="text-labb">
                                                        <?php echo $client->tel ?></span></span> 
                                                <span class="title-lab">Email <span class="text-labb">
                                                        <?php echo $client->email ?></span></span> 
                                            </div>
                                            <div class="col-6"> 
                                                <span class="title-lab">Pays <span class="text-labb">
                                                        <?php echo $pays ?></span></span> 
                                                <span class="title-lab">Ville <span class="text-labb">
                                                        <?php echo $client->ville ?></span></span> 
                                                <span class="title-lab">Adresse <span class="text-labb">
                                                        <?php echo $client->Adresse ?></span></span> 
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-12"> 
                                                <span class="title-lab">Remarques</span>
                                                <p class="text-remar">
                                                    <?php echo $reservation->note ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="hexa-hide" id="ReservationEditor">
                                    <div class="col-12">
                                       <div class="form-group row">
                                        <label for="mod_checkin" class="col-sm-1 col-form-label form-input">Arrivee </label>

                                                <div class="col-sm-3 input-group  md-form form-sm form-2">
                                                    <input type="text" class="date-hexa datepicker form-control" id="mod_checkin" <?php if ($dateAu || $dateDu): ?>disabled <?php endif ?>/> 
                                                    <div class="input-group-append"> 
                                                        <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> 
                                                    </div> 
                                                </div> 
                                
                                                <label for="mod_checkout" class="col-sm-1 col-form-label  form-input">Depart </label>
                                                    <div class="col-sm-3 input-group  md-form form-sm form-2">
                                                        <input type="text" class="date-hexa datepicker form-control" id="mod_checkout" <?php if ($dateAu || $dateDu): ?>disabled <?php endif ?> /> 
                                                        <div class="input-group-append"> 
                                                            <span class="input-group-text lime lighten-2" id="basic-text1"> <i class="fas fa-calendar-alt text-grey"aria-hidden="true"></i> </span> 
                                                        </div> 
                                                    </div> 
                                                <label for="mod_channnel" class="col-sm-1 col-form-label form-input">Client</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input id="mod_channnel"  class="hexa-autoc form-control"  value="<?php echo $reservation->channel ?>" disabled> 
                                                </div> 

                                        </div>

                                        <hr>

                                        <div class="form-group row">
           
                                            <label for="mod_client" class="col-sm-1 col-form-label form-input">Client\Groupe</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input data-cli="<?php echo $client->idCardex ?>" id="mod_client"  class="hexa-autoc form-control"  value="<?php echo $client->nom ?>"> 
                                                </div> 

                                                <label for="mod_tel" class="col-sm-1 col-form-label form-input">Tel</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_tel"  class="hexa-autoc form-control"  value="<?php echo $client->tel ?>"> 
                                                </div>
                                                <label for="mod_email" class="col-sm-1 col-form-label form-input">Email</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_email"  class="hexa-autoc form-control" value="<?php echo $client->email ?>"> 
                                                </div>
                                        </div>

                                        <div class="form-group row">
           
                                                <label for="mod_adresse" class="col-sm-1 col-form-label form-input">Adresse</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2"> 
                                                    <input id="mod_adresse"  class="hexa-autoc form-control" value="<?php echo $client->Adresse ?>">
                                                </div> 

                                                <label for="mod_ville" class="col-sm-1 col-form-label form-input">Ville</label>
                                                <div class="col-sm-3 input-group  md-form form-sm form-2">  
                                                    <input id="mod_ville"  class="hexa-autoc form-control"  value="<?php $client->ville?>"> 
                                                </div>
                                                <label for="mod_nationalite" class="col-sm-1 col-form-label form-input">Nationalite</label>
                                                <div class="col-sm-3 input-group md-form form-sm form-2">  
                                                    <select data-size="6" id="mod_nationalite" class="selectpicker form-control form-input"> </select>
                                                </div>
                                        </div>

                                        <hr>

                                        <div class="form-group row">
                                            <label for="mod_notes" class="col-sm-1 col-form-label form-input">Remarques</label>
                                            <div class="col-sm-11 input-group  md-form form-sm form-2">  
                                                <textarea id="mod_notes" class="form-control"><?php echo $reservation->note ?></textarea>
                                            </div>  
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <button onclick="updateReservationP(<?php echo $reservation->idReservation ?>);" type="button" class="btn btn-success float-right hexa-btn-op-mod"> Modifier</button>

                                                <button onclick="anuulerModification();" type="button" class="btn btn-info float-left hexa-btn-op-retour"> Retour </button>
                                             </div>
                                         </div>
                                    </div>
                                </div>
                                <div  class="hexa-hide" id="ReservationConfirmCancel">
                                        <div class="col-12">
                                            <div class="form-row"> 
                                                <div class="form-group col-md-12"> 
                                                    <label for="ann_raison_annulation" class="control-label">Raison d'annulation</label> 
                                                    <div class="input-group md-form form-sm form-2 pl-0"> 
                                                        <textarea id="ann_raison_annulation" class="form-control"></textarea> 
                                                    </div> 
                                                </div> 
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <button type="button" onclick="confirmerAnnulationResa(<?php echo $reservation->idReservation ?>)" class="btn btn-danger hexa-btn-op-confirmer float-right">Confirmer l'annulation </button>
                                                    <button type="button" onclick="retourAnnulation()" class="btn btn-info hexa-btn-op-retour float-left">Retour </button> 
                                                 </div>
                                            </div>
                                        </div>
                                </div>

                            </div>
                        </div> 
                    </div>

                    <div class="tab-pane fade" id="nav-ch" role="tabpanel" aria-labelledby="nav-ch-tab">
                        <div id="content-chambres">
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#<?php echo $reservation->idReservation ?><i class="fa fa-lock hexa-lock"></i></span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right hexa-tot-payee"><?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?></span>  
                                    </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            <?php echo $reservation->channelDisplay ?></span> </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : <?php echo number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '') ?></span>
                                        <span style="font-style:italic" class="float-right">Payé : <?php echo number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '') ?></span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  <?php echo $updatedAt; ?></span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOpR"  style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row  float-right">

                                            <?php if ((!$reservation->isCanceled) && (!$reservation->isNoshow) && (!$closed)): ?>
                                                <?php if (!$reservation->isCheckout): ?>

                                                    <button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChForm(this,<?php echo $reservation->idReservation ?>)"><i class="fa fa-plus hexa-fs10"></i> Ajouter une chambre</button>
                                                <?php endif?>
                                            <?php endif?>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="body-content col-12  position-relative">
                                <div class="row hexa-hide" id="affecterRoom" >

                                    
                                </div>

                                <table id="TableRooms" width="100%" class="table">
                                        <thead class="hexa-header-reservation">
                                            <th width="35%">Type</th>
                                            <th class="text-center" width="10%">Chambre</th>
                                            <th class="text-center" width="10%">Etat</th>
                                            <th width="15%">Arrivee</th>
                                            <th width="10%">Pax</th>
                                            <th class="text-center" width="10%">Actions</th>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($chambres as $indexCh => $chambre): $ch_number = '#'; ?>
                                            <tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab">
                                                    <?php echo $chambre['nomTypeChambres'] ?></span><span class="text-labbb">
                                                    <?php echo $chambre['pension'] ?></span></td>
                                                <td class="ty-chambre text-center hexa-td">

                                                    <?php if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])): ?>
                                                      <?php if ($chambre['idChambres'] == 0): ?>
                                                        <span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;"><?php echo $ch_number ?></span>
                                                      <?php else: ?>
                                                          <span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;"><?php $ch_number = $chambre['nomChambre'] ?><?php echo $ch_number ?></span>
                                                      <?php endif ?>
                                                    <?php else: ?>
                                                        <span class="text-lab text-center" style="padding-top:11px;padding-bottom:11px;"><?php echo $ch_number ?></span>
                                                    <?php endif ?>   
                                                </td>

                                                <td class="ty-chambre text-center hexa-td">
                                                    <span class="text-lab ">

                                                          <?php if ($chambre['isNoshow']): ?>
                                                            <?php $ett =  getEtat('noshow') ?>
                                                          <?php elseif($chambre['isCheckout']): ?>
                                                            <?php $ett =  getEtat('checkout') ?>
                                                          <?php elseif($chambre['isCheckin']): ?>
                                                            <?php $ett =  getEtat('checkin') ?>
                                                          <?php else: ?>
                                                            <?php $ett =  getEtat($chambre['etat']) ?>
                                                          <?php endif ?>
                                                          <?php echo $ett ?>
                                                    </span>
                                                </td>
                                                <td class="hexa-td"><span class="text-lab">
                                                        <?php echo utf8_encode(strftime("%d %b", strtotime($chambre['dateDu']))) . ' - ' . utf8_encode(strftime("%d %b %G", strtotime($chambre['dateAu']))) ?></span><span class="text-labbb">
                                                        <?php echo $chambre['nuites'] ?> nuits</span></td>
                                                <td class="hexa-td">
                                                    <span class="text-lab"><?php echo $chambre['totalAdult'] ?> Adult</span>
                                                    <span class="text-labbb"><?php echo $chambre['totalEnfant'] ?> Enfant</span>
                                                </td>
                                                <td class="text-center hexa-td">
                                                    <?php if ((!$reservation->isCanceled) && (!$chambre['isCanceled']) && (!$chambre['isNoshow'])): ?>
                                                        <?php if (!$chambre['isCheckin']): ?>
                                                            <?php if ($chambre['dateDu'] == $dateCloture): ?>
                                                                <span data-toggle="tooltip" data-placement="top" title="Check in" onclick="checkinRoomP(this,<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh">
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-arrow-down fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span> 
                                                            <?php endif ?>
                                                            <span data-toggle="tooltip" data-placement="top" title="Modifier" onclick="editRoomReservationP(this,<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action"  style="font-size: 11px"></i>
                                                            </span>
                                                            <span data-toggle="tooltip" data-placement="top" title="Annuler chambre" onclick="cancelRoomP(<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh">
                                                                <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                <i class="fa fa-times fa-stack-1x fa-inverse action" style="font-size: 14px"></i>
                                                            </span>
                                                        <?php elseif(!$chambre['isCheckout']): ?>
                                                            <?php if($dateCloture < $chambre['dateAu']): ?>
                                                                <span data-toggle="tooltip" data-placement="top" title="Deloger chambre" onclick="delogerRoomP(this,<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh">
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-exchange-alt fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span>
                                                            <?php endif?>
                                                            <span data-toggle="tooltip" data-placement="top" title="Modifier chambre" onclick="editRoomReservationP(this,<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh">
                                                              <i class="fas fa-square fa-stack-2x clickable"></i>
                                                              <i class="fa fa-pen fa-stack-1x fa-inverse action" style="font-size: 11px"></i>
                                                            </span>
                                                            <?php if ($chambre['prix'] == $chambre['totalRegle']): ?>
                                                                <span data-toggle="tooltip" data-placement="top" title="Checkout" onclick="checkoutP(this,<?php echo $reservation->idReservation ?>,<?php echo $chambre['idCR'] ?>)" class="fa-stack operationCh" >
                                                                    <i class="fas fa-square fa-stack-2x clickable"></i>
                                                                    <i class="fa fa-arrow-up fa-stack-1x fa-inverse action" style="font-size: 12px"></i>
                                                                </span>
                                                            <?php endif ?>
                                                            

                                                        <?php endif?>

                                                    <?php endif?>
                                                </td>
                                            </tr>
                                            <?php if (count($chambre['dates']) > 0 && !$chambre['isCheckout']): ?>
                                            <tr>
                                                <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="5">
                                                    <div class="scrollmenu">
                                                        <?php $chtotal = 0; foreach ($chambre['dates'] as $key => $dateR): ?>
                                                        <?php if ($dateR['date'] < $dateCloture || $chambre['isCanceled'] || $reservation->isCanceled || $reservation->isNoshow  || $chambre['isNoshow']): ?>
                                                            <div class="text-con old-room" style="width: 100px;"><span class="text-datee text-center" style="color:#948994!important">
                                                                    <?php echo strftime("%d/%m/%G", strtotime($dateR['date'])) ?></span>
                                                                <span class="text-prix text-center">
                                                                    <?php echo $dateR['codePension']; ?></span>
                                                                <span class="text-prix text-center">
                                                                    <?php echo number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '') ?></span></div>
                                                        <?php else: ?>
                                                            <div onclick="editRoomDatePension(<?php echo $dateR['idDCR'] ?>,<?php echo $dateR['idCR'] ?>,<?php echo $reservation->idReservation ?>,<?php echo $dateR['idPension'] ?>,<?php echo number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '') ?>,'<?php echo $dateR['date']?>','<?php echo $chambre['nomTypeChambres'] ?>', '<?php echo $chambre['pension'] ?>', '<?php echo $ch_number ?>', '<?php echo htmlspecialchars($ett) ?>', '<?php echo strftime("%d %b", strtotime($chambre['dateDu'])) . ' - ' . strftime("%d %b %G", strtotime($chambre['dateAu'])) ?>', '<?php echo $chambre['nuites'] ?> nuits', '<?php echo $chambre['totalAdult'] ?> Adult', '<?php echo $chambre['totalEnfant'] ?> Enfant')" class="text-con" style="width: 100px;"><span class="text-datee text-center">
                                                                    <?php echo strftime("%d/%m/%G", strtotime($dateR['date'])) ?></span>
                                                                    <span class="text-prix text-center">
                                                                    <?php echo $dateR['codePension']; ?></span>
                                                                    <span class="text-prix text-center">
                                                                    <?php echo number_format($dateR['prix'] * 1 / $reservation->changeRate, 2, '.', '') ?></span></div>
                                                        <?php endif?>
                                                        <?php $chtotal += $dateR['prix'];?>
                                                        <?php endforeach?>
                                                    </div>
                                                </td>
                                                <td class="hexa-ch-total-td">
                                                    <span class="text-center hexa-ch-total">Total
                                                    </span>
                                                    <span class="text-center hexa-ch-total">
                                                        <?php echo number_format($chtotal * 1 / $reservation->changeRate, 2, '.', '') ?>
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php endif?>
                                            <?php endforeach?>

                                        </tbody>
                                </table>

                                <div class="form-row hexa-hide" id="formGroupCh"></div>

                                <div class="form-row hexa-hide" id="RoomEditor"></div>

                                
                                <div class="row hexa-hide" id="delogerRoom"></div> 
                                <div class="row hexa-hide" id="editChambrePension">
                                    <div class="col-12">
                                            <table width="100%" class="table">
                                                <thead class="hexa-header-reservation">
                                                    <th width="35%">Type</th>
                                                    <th class="text-center" width="10%">Chambre</th>
                                                    <th class="text-center" width="10%">Etat</th>
                                                    <th width="15%">Arrivee</th>
                                                    <th width="10%">Pax</th>
                                                    <th class="text-center" width="10%">Actions</th>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td class="ty-chambre hexa-td"><span class="text-lab" id="txt_ch_mod"></span><span class="text-labbb" id="txt_pen_mod"></span></td>
                                                        <td class="ty-chambre text-center hexa-td" id="txt_ch_sel_mod"></td>
                                                        <td class="ty-chambre text-center hexa-td">
                                                            <span class="text-lab" id="txt_ch_etat_mod">
                                                            </span>
                                                        </td>

                                                        <td class="hexa-td"><span class="text-lab" id="txt_ch_dates_mod"></span><span class="text-labbb" id="txt_ch_nuit_mod"></span></td>
                                                        <td class="hexa-td">
                                                            <span class="text-lab" id="txt_ch_adult_mod"></span>
                                                            <span class="text-labbb" id="txt_ch_child_mod"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="6" style="background:#F6FAFB;">
                                                            <div id="room-pension-content" class="row" style="padding-top:15px;padding-bottom:15px">
                                                            </div>
                                                        </td>
                                                    
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <div class="form-row"> 
                                                <div class="form-group col-md-12">
                                                    <button type="button" onclick="appliquerEditRoomSejour()" class="btn btn-success btn-reservation-modal float-right">Appliquer sur le sejour</button>
                                                    <button type="button" onclick="appliquerEditRoom()" class="btn btn-success btn-reservation-modal float-right">Appliquer</button>
                                                    <button type="button" onclick="retourEditRoomDatePension()" class="btn btn-info btn-reservation-modal float-left">Retour </button> 
                                                </div>
                                            </div>
                                    </div>
                                </div>
                            
                            </div>

                        </div>
                    </div>


                    <div class="tab-pane fade" id="nav-ex" role="tabpanel" aria-labelledby="nav-ex-tab">
                        <div id="content-extras">
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#<?php echo $reservation->idReservation ?><i class="fa fa-lock hexa-lock"></i></span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right hexa-tot-payee"><?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?></span>  
                                    </div>
                                    <div class="col-6">
                                        <span style="color:#8A8E94;font-style:italic">
                                            <?php echo $reservation->channelDisplay ?></span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : <?php echo number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '') ?></span><span style="font-style:italic" class="float-right"> Payé : <?php echo number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '') ?></span> 
                                    </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  <?php echo $updatedAt; ?></span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOpEx" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">
                                        <?php if (!$reservation->isCanceled  && !$reservation->isNoshow && !$reservation->isCheckout): ?>
                                                <?php if (count($chambres)>0): ?>
                                                    <button type="button" id="btn-ajouterchch" class="btn btn-secondary float-right btn-reservation-modal" onclick="ajouterChExFormRoom(this,<?php echo $reservation->idReservation ?>,<?php echo $chambres[0]['idCR'] ?>)"><i class="fa fa-plus hexa-fs10"></i> Extra chambre</button>
                                                <?php endif ?>
                                            <button type="button" id="btn-ajouterchch" class="btn btn-info float-right btn-reservation-modal" onclick="ajouterChExForm(this,<?php echo $reservation->idReservation ?>)"><i class="fa fa-plus hexa-fs10"></i> Extra reservation</button>

                                        <?php endif?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="body-content col-12">
                                
                                <?php if (count($extras)>0): ?>
                            
                                <table id="TableExtra" width="100%" class="table" style="overflow: hidden !important">
                                    <thead class="hexa-header-reservation">
                                        <th width="30%">Extra</th>
                                        <th class="text-center" width="10%">Type</th>
                                        <th class="text-center" width="10%">Personnes</th>
                                        <th class="text-center" width="10%">Dates</th>
                                        <th class="text-center" width="20%">Total</th>
                                        <th class="text-center" width="10%">Actions</th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($extras as $key => $extra): ?>
                                            <tr>
                                                <td class="ty-chambre hexa-td"><span class="text-lab"><?php echo $extra['extraReservation'] ?></span><span class="text-labbbb"><?php echo $type = ($extra['idDeduction']) ? 'Prestation' : 'Deduction' ; ?></span>
                                                </td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab"><?php echo $retVal = ($extra['isReservation']) ? 'Reservation' : 'Chambre'; ?></span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab"><?php echo $pax = (count($extra['dates'])>0) ? $extra['dates'][0]['pax'] : 'N/A' ?></span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab"><?php echo $date = (count($extra['dates'])>0) ? $extra['dates'][0]['date'] : 'N/A' ?></span></td>
                                                <td class="ty-chambre hexa-td text-center"><span class="text-lab"><?php echo number_format($extra['prix']* 1 / $reservation->changeRate, 2, '.', '') ?></span></td>
                                                <td></td>

                                            </tr>
                                            <?php if (count($extra['dates']) > 1): ?>

                                                <tr>
                                                   <td style="background:#F6FAFB;padding: 0.05rem 0;" colspan="5">
                                                        <div class="scrollmenu">
                                                            <?php $extotal = 0; foreach ($extra['dates'] as $key => $dateE): $extotal+=$dateE['prix']; ?>

                                                                <div class="text-con old-room" style="width: 100px;background-color: #BBDDC1 !important;border: 1px solid #366D41;"><span class="text-datee text-center" style="color:#366D41!important">
                                                                        <?php echo strftime("%d/%m/%G", strtotime($dateE['date'])) ?></span>
                                                                    <span class="text-prix text-center">
                                                                        <?php echo number_format($dateE['prix'] * 1 / $reservation->changeRate, 2, '.', '') ?></span>
                                                                </div>

                                                            <?php endforeach ?>

                                                        </div>  
                                                    </td>
                                                    <td class="hexa-ch-total-td">
                                                        <span class="text-center hexa-ch-total">Total
                                                        </span>
                                                        <span class="text-center hexa-ch-total">
                                                            <?php echo number_format($extotal * 1 / $reservation->changeRate, 2, '.', '') ?>
                                                        </span>
                                                    </td>
                                                </tr>

                                                
                                            <?php endif ?>
                                            
                                        <?php endforeach ?>
                                    </tbody>
                                </table>
                                <?php endif ?>
                                <div id="formReservationEx" class="hexa-hide"></div>

                            </div>


                        </div>    
                    </div>

                    <div class="tab-pane fade" id="nav-rg" role="tabpanel" aria-labelledby="nav-rg-tab">
                        <div id="content-reglment">
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#<?php echo $reservation->idReservation ?><i class="fa fa-lock hexa-lock"></i></span> </div>

                                    <div class="col-6 float-right">
                                        <span class="float-right hexa-tot-payee" ><?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?></span>  
                                    </div>
                                    <div class="col-6"><span style="color:#8A8E94;font-style:italic">
                                            <?php echo $reservation->channelDisplay ?></span> 
                                    </div>
                                    <div class="col-6 float-right">
                                        <span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : <?php echo number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '') ?></span><span style="font-style:italic" class="float-right"> Payé : <?php echo number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '') ?></span> 
                                    </div>

                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  <?php echo $updatedAt; ?></span>
                                    </div>

                                    <div class="col-12 col-md-6" id="buttonGroupOpFact" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">

                                             <?php if (!$reservation->isCanceled): ?>
                                                <?php if (!$reservation->isCheckout): ?>
                                                    <?php if (number_format($reservation->totalHT + $reservation->taxTotal,2) != number_format($totalRegle,2)): ?>
                                                        <?php if ($factureChambre || $factureExtra): ?>
                                                            <button type="button" onclick="createFacture(this,<?php echo $reservation->idReservation ?>)" class="btn btn-danger float-right btn-reservation-modal"><i class="fa fa-plus hexa-fs10" style="font-size: 12px"></i> Ajouter une facture</button>
                                                        <?php endif?>
                                                    <?php else: ?>
                                                        <span class="hexa-text-paye">Reglée</span>
                                                    <?php endif ?>
                                                
                                                <?php endif?>
                                            <?php endif?>

                                        </div>
                                    </div>
                                </div>
                            </div> 

                            <div class="body-content col-12 position-relative">
                                <div id="payFacture"></div>
                                <?php if (count($factures)>0): ?>

                                <table id="TableFactures" width="100%" class="table" style="margin-bottom: 0!important;">
                                            <thead class="hexa-header-reservation">
                                                <th>Facture</th> 
                                                <th class="text-center">Date</th>
                                                <th class="text-center">Payé</th> 
                                                <th class="text-center">Reste</th> 
                                                <th class="text-center">Total</th> 
                                                <th class="text-center">Actions</th> 
                                            </thead>
                                            <tbody>
                                            <?php foreach ($factures as $inde => $facture):  ?>


                                                <tr>
                                                    <td class="ty-chambre hexa-td" width="25%"><span class="text-lab"><?php echo $facture['nom'] ?></span></td>
                                                    <td class="ty-chambre hexa-td text-center" width="15%"><span class="text-lab"><?php echo strftime("%d/%m/%G", strtotime($facture['dateFacture'])) ?></span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab"><?php echo number_format($facture['totalRegle'] * 1/$reservation->changeRate ,2,'.','') ?></span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab"><?php echo number_format(($facture['total']-$facture['totalRegle']) * 1/$reservation->changeRate ,2,'.','') ?></span></td>
                                                    <td class="ty-chambre hexa-td text-right" width="10%"><span class="text-lab"><?php echo number_format($facture['total'] * 1/$reservation->changeRate ,2,'.','') ?></span></td>
                                                                
                                                    <td class="ty-chambre hexa-td text-center">
                                                    <?php if ($facture['total'] != $facture['totalRegle']): ?>
                                                        <span data-toggle="tooltip" data-placement="top" title="Regler la facture"  class="fa-stack operationCh" onclick="payFactureText(<?php echo $reservation->idReservation ?>,<?php echo $facture['idFacture'] ?>,'<?php echo number_format(($facture['total']-$facture['totalRegle'])  * 1/$reservation->changeRate ,2,'.','') ?>')" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-check fa-stack-1x fa-inverse " style="font-size: 12px"></i>
                                                        </span>
                                                    <?php endif ?>
                                                    <?php if (count($facture['modePaiement'])>0): ?>
                                                        <span data-toggle="tooltip" data-placement="top" title="Modifier reglement" onclick="modifierFacture(<?php echo $facture['idFacture'] ?>);"  class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-dollar-sign fa-stack-1x fa-inverse " style="font-size: 12px"></i>
                                                        </span> 
                                                    <?php endif ?>
                                                        <span data-toggle="tooltip" data-placement="top" title="Details Facture"  class="fa-stack operationCh" onclick="editFacture(<?php echo $reservation->idReservation ?>,<?php echo $facture['idFacture'] ?>)" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-receipt fa-stack-1x fa-inverse " style="font-size: 12px"></i>
                                                        </span>
                                                        <a href="<?php echo base_url() ?>facture/<?php echo $facture['idFacture'] ?>" target="_blank">
                                                        <span data-toggle="tooltip" data-placement="top" title="Imprimer Facture" class="fa-stack operationCh" >
                                                            <i class="fas fa-square fa-stack-2x clickable"></i>
                                                            <i class="fa fa-print fa-stack-1x fa-inverse " style="font-size: 12px"></i>
                                                        </span></a>
                                                    </td>
                                                </tr>                           
                                                <?php endforeach ?>
                                            </tbody>    
                                </table>  
                                <?php endif ?>   
                                <div id="createFacture" class="hexa-hide">

                                        <?php if ($factureChambre || $factureExtra): ?>
                                           <div class="row"> 
                                                
                                                <div class="col-12"  style="margin-bottom: 0.75rem !important">
                                                    <span style="font-style:italic;font-size:130%;font-weight:800">Cree une Facture </span> 
                                                </div>
                                                <div class="col-12">

                                                <div class="form-group row"> 

                                                    <label for="cr_fac_ice" class="col-sm-1 col-form-label form-input">ICE</label> 

                                                    <div class="col-sm-3 input-group md-form form-sm form-2"> 

                                                    <input id="cr_fac_ice"  class="hexa-autoc form-control" style="font-style:italic;font-weight:800;font-size:14px;text-align:center" placeholder="Modifier ICE sur facture..." > 

                                                    </div> 

                                                     <label for="cr_fac_nom" class="col-sm-1 col-form-label form-input">Nom sur facture</label> 


                                                    <div class="col-sm-3 input-group md-form form-sm form-2"> 

                                                    <input id="cr_fac_nom"  class="hexa-autoc form-control" style="font-style:italic;font-weight:800;font-size:14px;text-align:center" placeholder="Modifier nom sur facture..." value="<?php echo $reservation->client ?>"> 

                                                    </div> 

                                                    <label for="cr_fac_tot" class="col-sm-1 col-form-label form-input">Total</label> 

                                                    <div class="col-sm-3 input-group md-form form-sm form-2"> 

                                                    <input id="cr_fac_tot"  class="hexa-autoc form-control" value="<?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?>" style="font-style:italic;font-weight:800;font-size:14px;text-align:center" value="0" disabled> 

                                                    </div> 

                                                </div>

                                                <table id="TableRegll" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0.5rem!important;">
                                                    <tr onclick="factureMAster(this,'<?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?>')" class="hexa_row_reg active-reg" style="background: #F6FAFB;"><td width="5%"><i class="fa fa-check-square"></i></td><td colspan="4">Facture Master</td></tr>
                                                </table> 

                                                <table id="TableRegl" width="100%" class="table" style="overflow: hidden !important;margin-bottom: 0.75rem!important;">
                                                        <thead class="hexa-header-reservation">
                                                           <th></th> 
                                                           <th>Prestation</th> 
                                                           <th>Date</th>
                                                           <th class="text-center">Total</th> 
                                                           <th class="text-center">Etat</th> 
                                                        </thead>
                                                        <tbody>
                                                
                                                <?php if (count($chambres)>0): ?> 
                                                    <?php if ($factureChambre): ?>  
                                                            <?php foreach ($chambres as $indexCh => $chambre):  ?>
                                                                <?php if ($chambre['idFactureP']==0): ?>
                                                                    <tr onclick="selectRoom(this,<?php echo $chambre['idCR'] ?>,<?php echo $chambre['prix'] ?>)" class="hexa_row_reg" >
                                                                        <td width="5%"><i class="far fa-square"></i></td>
                                                                        <td width="35%"><?php echo $chambre['nomTypeChambres'] ?></td>
                                                                        <td width="15%"><?php echo strftime("%d/%m/%G", strtotime($dateCloture)) ?></td>
                                                                        <td width="10%" class="text-right"><?php echo number_format($chambre['prix'] * 1/$reservation->changeRate ,2,'.','') ?></td>


                                                                        <td width="10%" class="text-center"><span style="color:#f94144;font-weight: 700!important;">Non réglé</span></td>
                                                                    </tr> 
                                                                <?php endif ?>                          
                                                            <?php endforeach ?>
                                                    <?php endif ?>
                                                <?php endif ?> 
                                                <?php if (count($extras)>0): ?>
                                                    <?php if ($factureExtra): ?>                                               
                                                        <?php foreach ($extras as $indexCh => $extra):  ?>
                                                            <?php if ($extra['idFactureP']==0): ?>
                                                                <tr onclick="selectExtra(this,<?php echo $extra['idExtraRes'] ?>,<?php echo $extra['prix'] ?>)" class="hexa_row_reg">
                                                                    <td width="5%"><i class="far fa-square"></i></td>
                                                                    <td width="35%"><?php echo $extra['extraReservation'] ?></td>
                                                                    <td width="15%"><?php echo strftime("%d/%m/%G", strtotime($dateCloture)) ?></td>
                                                                    <td class="text-right" width="10%"><?php echo number_format($extra['prix'] * 1/$reservation->changeRate ,2,'.','') ?></td>
                                                                    <td class="text-center" width="10%"><span style="color:#f94144;font-weight: 700!important;">Non réglé</span></td>
                                                                </tr>   
                                                            <?php endif ?>
                                                               
                                                        <?php endforeach ?>

                                                    <?php endif ?> 
                                                <?php endif ?> 
                                                     </tbody>      
                                                </table>
                                                </div>
                                                  <div class="col-12">

                                                    <button type="button" onclick="retourCreatFacture()" class="btn btn-info hexa-btn-op-mod">Retour </button>

                                                    <button type="button" onclick="ajouterFacture(<?php echo $reservation->idReservation ?>)" class="btn btn-success hexa-btn-op-mod float-right">Ajouter </button> 

                                                  </div>
 
                                          </div>
                                          <?php endif ?>




                                    
                                </div>    
                            </div>

                        </div> 
                    </div>

                    <div class="tab-pane fade" id="nav-hs" role="tabpanel" aria-labelledby="nav-hs-tab">
                        <div id="content-historque">
                            <div class="col-12 hexa-header-resa">
                                <div class="row hexa-row-reservation">
                                    <div class="col-6"> <span class="hexa-providerId">#<?php echo $reservation->idReservation ?><i class="fa fa-lock hexa-lock"></i></span> </div>

                                    <div class="col-6 float-right"><span class="float-right hexa-tot-payee" ><?php echo number_format(($reservation->totalHT + $reservation->taxTotal) * 1 / $reservation->changeRate, 2, '.', '') ?></span>  </div>
                                    <div class="col-6"><span style="color:#8A8E94;font-style:italic">
                                            <?php echo $reservation->channelDisplay ?></span> </div>
                                    <div class="col-6 float-right"><span class="float-right" style="padding-left:5px;font-style:italic"> | Reste : <?php echo number_format((($reservation->totalHT + $reservation->taxTotal) - $totalRegle) * 1 / $reservation->changeRate, 2, '.', '') ?></span><span style="font-style:italic" class="float-right"> Payé : <?php echo number_format($totalRegle * 1 / $reservation->changeRate, 2, '.', '') ?></span> </div>
                                    <div class="col-12 col-md-6 float-right hexa-margin-25"><span class="hexa-date-modi">Dernière modification  <?php echo $updatedAt; ?></span>
                                    </div>
                                    <div class="col-12 col-md-6" id="buttonGroupOp" style="padding-bottom: 10px;padding-top: 10px">
                                        <div class="form-row float-right">
                                        </div>
                                    </div>
                                </div>
                            </div> 
                        

                            <div class="body-content">
                                <div class="col-12">
                                    <div class="timeline block mb-4">
                                        <?php foreach ($activites as $key => $activity): 
                                                $text = $activity['nomUtilisateur'].' '.$activity['description'];

                                                $date = new DateTime($activity['dateCreation']);
                                                $date->setTimezone(new DateTimeZone('Africa/Casablanca')); 
                                                setlocale(LC_TIME, "fr_FR");
                                                $dateC =  utf8_encode(strftime("%d %B %G",strtotime($date->format('d-m-Y')))).' '.$date->format('H:i'); 
                                            ?>

                                            <div class="tl-item">
                                                <div class="tl-dot b-primary"></div>
                                                <div class="tl-content">
                                                    <div class="hexa-text-tl"><?php echo $text; ?></div>
                                                    <div class="tl-date text-muted mt-1"><?php echo $dateC ?></div>
                                                </div>
                                            </div>  
                                        <?php endforeach ?>
                                    </div>         
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
                <?php $dt   = new DateTime("now", new DateTimeZone('Africa/Casablanca')); $time = $dt->format('H:i'); ?> 
            <div class="card-footer small text-muted">Mise a jour <?php setlocale(LC_TIME, "fr_FR"); echo 'Le ' . utf8_encode(strftime("%A %d %B %G  ")) . $time;?> 
            </div>
        </div>
        <!-- /.card mb-3 -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-wrapper -->



<script type="text/javascript">

    clis = [];
    chans = [];
    pays = [];
    mpai = [];

    $(document).ready(function() {
        <?php foreach ($clients as $key => $client): ?>
             clis.push({"label":"<?php echo $client['nom'] ?>", "tel":"<?php echo $client['tel'] ?>", "email":"<?php echo $client['email'] ?>", "Adresse":"<?php echo $client['Adresse'] ?>", "ville":"<?php echo $client['ville'] ?>", "id":"<?php echo $client['idCardex'] ?>", "pays":"<?php echo $client['idPays'] ?>"});
        <?php endforeach?>

        <?php foreach ($payys as $key => $pay): ?>
            pays.push({"name_fr":"<?php echo $pay['name_fr'] ?>","alpha_2":"<?php echo $pay['alpha_2'] ?>"});
        <?php endforeach?>

        <?php foreach ($modePaiements as $key => $modePaiement): ?>
            mpai.push({"idModePaimenet":"<?php echo $modePaiement['idModePaimenet'] ?>","modePaiement":"<?php echo $modePaiement['modePaiement'] ?>"});
        <?php endforeach?>
    });



    function editReservationP(elem,idReservation,dateDu,dateAu,codePays){

        $('#ReservationEditor').removeClass('hexa-hide');
        $('#body-reservation').addClass('hexa-hide');
        $('#buttonGroupOp').addClass('hexa-hide');

        $.each(pays, function(number, pay) {
            $('#mod_nationalite').append($('<option>').text(pay.name_fr).attr('value', pay.alpha_2));
        });
        $('.selectpicker').selectpicker('refresh');

        $('#mod_nationalite').val(codePays);

        $('.selectpicker').selectpicker('refresh');

        var fromTimeInput = $('#mod_checkin');
        var toTimeInput = $('#mod_checkout');
        var fromTime = fromTimeInput.val();
        var toTime = toTimeInput.val();
        var date_checkin = new Date(dateDu);
        var date_checkout = new Date(dateAu);
        fromTimeInput.datepicker({
                        keyboardNavigation : false,
                        forceParse : false,
                        endDate: toTime,
                        startDate: date_checkin,
                        autoclose: true,
                        language: 'fr',
                        format: 'dd M yyyy',
                        todayHighlight:true
        });
        toTimeInput.datepicker({
                        keyboardNavigation : false,
                        forceParse : false,
                        startDate: date_checkin,
                        autoclose: true,
                        language: 'fr',
                        format: 'dd M yyyy',
                        todayHighlight:true
        });

        fromTimeInput.datepicker('update', date_checkin);
        toTimeInput.datepicker('update', date_checkout);
        $( "#mod_client" ).autocomplete({
                        source: function(request, response) {
                            var results = $.ui.autocomplete.filter(clis, request.term);

                            response(results.slice(0, 10));
                        },
                        select: function (event, ui) {
                         // Set selection
                         $('#mod_client').val(ui.item.label);
                         $('#res_tel').val(ui.item.tel);
                         //$('#res_nationalite').val(ui.item.pays);
                         $('#mod_email').val(ui.item.email);
                         $('#mod_adresse').val(ui.item.Adresse);
                         $('#mod_ville').val(ui.item.ville);
                         $('#mod_client').attr('data-cli',ui.item.id);
                         $('#mod_nationalite').val(ui.item.pays);
                          $('.selectpicker').selectpicker('refresh')
                         return false;
                        }
        });

        $('#mod_client').on('input', function() {
            $('#mod_client').attr('data-cli',0);
        }); 

    }






                                        

    function editRoomDatePension(idDCR,idCR,idReservation,idPen,prix,date,ch,pen,chsel,etat,dates,nuits,adult,enfants){



        $('#txt_ch_mod').html(ch);
        $('#txt_pen_mod').html(pen);
        $('#txt_ch_sel_mod').html(chsel);
        $('#txt_ch_etat_mod').html(etat);
        $('#txt_ch_dates_mod').html(dates);
        $('#txt_ch_nuit_mod').html(nuits);
        $('#txt_ch_adult_mod').html(adult);
        $('#txt_ch_child_mod').html(enfants);

        
        var date_text = new Date(date);
        date_text = ((date_text.getDate() > 9) ? date_text.getDate() : ('0' + date_text.getDate())) + '/' +((date_text.getMonth() > 8) ? (date_text.getMonth() + 1) : ('0' + (date_text.getMonth() + 1))) + '/' +  date_text.getFullYear();
        html = '';

        er_date = date_text;
        er_idReservation = idReservation;
        er_idCR = idCR;
        er_idPen = idPen;
        er_prix = prix;
        <?php foreach ($pensions as $key => $pension): ?>


            if (idPen == <?php echo $pension['idPension'] ?>) {

                html += '<div class="col-2 text-center text-con-sel mx-auto onclickSelect" > <div style="width: 100%;"> <span class="hexa-date-choice text-datee-choice text-center">'+date_text+'</span> <span class="hexa-prix-choice text-prix-choice text-center"><?php echo $pension['codePension'] ?></span> <div class="prix-zone"><input id="er_prix" class=" text-prix-choice text-center hexa-prix-choice form-control text-prix-vall" placeholder="0" value="'+prix+'" type="text" /> </div></div> </div>';


            }else{


                html += '<div class="col-2 text-center text-con-sel old-sel mx-auto onclickSelect" onclick="selectRoomDatePension(this,'+prix+','+'<?php echo $pension['idPension'] ?>'+')" > <div   style="width: 100%;"> <span class="text-datee-choice-sel text-center hexa-date-choice">'+date_text+'</span> <span class="hexa-prix-choice text-prix-choice-sel text-center"><?php echo $pension['codePension'] ?></span> <div class="prix-zone"><span class="text-prix-choice-sel hexa-prix-choice text-center form-control text-prix-vall">'+prix+'</span> </div></div> </div>'; 
            }
            
        <?php endforeach ?>


        $('#room-pension-content').html(html);


        $('#editChambrePension').removeClass('hexa-hide');
        $('#buttonGroupOpR').addClass('hexa-hide');
        $('#TableRooms').addClass('hexa-hide');

    }





</script>
<?php
function getEtat($etat)
{
    switch ($etat) {
        case 'noshow':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Noshow</span>';
            break;
        case 'checkin':
            return '<span style="font-style:italic;font-weight:800;color:#845F03">Checkin</span>';
            break;
        case 'checkout':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Checkout</span>';
            break;
        case 'modify':
            return '<span style="font-style:italic;font-weight:800;color:#0096c7">Modifié</span>';
            break;
        case 'canceled':
            return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
            break;
        case 'confirm':
            return '<span style="font-style:italic;font-weight:800;color:#2a9d8f">Reservée</span>';
            break;
        case 'confirmed':
            return '<span style="font-style:italic;font-weight:800;color:#2a9d8f">Reservée</span>';
            break;
        case 'cancel':
            return '<span style="font-style:italic;font-weight:800;color:#e63946">Annulée</span>';
            break;
        default:
            return 'N/A';
            break;
    }
}


?>