 <div id="content-wrapper">
      <div class="container-fluid">
        <!-- DataTables Example -->
        <div class="card mb-3">
          <div class="card-header bg-white" >
            <div class="col-12">
              <div class="row h-100">
                <div class="title-header col-5 my-auto p-0">
                  Liste Pensions
                </div>
                <div class="col-7 my-auto p-0">
                  <button class="btn float-right btn-hexa-more"><i class="fa fa-ellipsis-h"></i></button>
                  <button class="btn float-right btn-hexa-ajouter" onclick="createPension();" >Ajouter une Pension</button>
                </div>
              </div>
            </div>

           </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Code</th>
                    <th class="text-center">Pension</th>
                    <th class="text-center">Prix</th>
                    <th class="text-center">Date Creation</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($pensions as $key => $pension): ?>
                    <tr>
                      <td><?php echo $pension['codePension']?></td>
                      <td><?php echo $pension['pension'] ?></td>
                      <td class="text-center"><?php echo $pension['prix'] ?></td>
                      <td class="text-center"><?php echo $pension['dateCreation'] ?></td>
                      <td class="text-center">
                        <ul class="list-inline">
                          <li class="actions list-inline-item"><i class="fa fa-eye"></i></li>
                          <li class="actions list-inline-item"><i class="fa fa-pen"></i></li>
                          <li class="actions list-inline-item"><i class="fa fa-trash"></i></li>
                        </ul>
                      </td>
                    </tr>
                  <?php endforeach ?>
                </tbody>
              </table>
            </div>
          </div>
          <div class="card-footer small text-muted">Mise a jour <?php echo date('y-m-d'); ?></div>
        </div>
      </div>
      <!-- /.container-fluid -->
</div>
      <script type="text/javascript">


        $(document).ready(function() {


                oTable = $('#dataTable').DataTable({
                  fixedHeader: true,
                  bFilter: true,
                  dom: 'T<"clear">lfrtip',
                      "lengthMenu": false,
                      "lengthChange": false,
                      "language": {
                            "sProcessing":     "Traitement en cours...",
                            "sSearch":         "",
                            "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
                            "sInfo":           "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
                            "sInfoEmpty":      "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
                            "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
                            "sInfoPostFix":    "",
                            "sLoadingRecords": "Chargement en cours...",
                            "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
                            "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
                            "oPaginate": {
                                "sFirst":      "Premier",
                                "sPrevious":   '<i class="fa fa-caret-left"></i>',
                                "sNext":       '<i class="fa fa-caret-right"></i>',
                                "sLast":       "Dernier"
                            },
                            "oAria": {
                                "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                                "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
                            },
                            "select": {
                                    "rows": {
                                        _: "%d lignes séléctionnées",
                                        0: "Aucune ligne séléctionnée",
                                        1: "1 ligne séléctionnée"
                                    } 
                            }
                        },
                       "pageLength": 35,
                       "info":     false,
                  "responsive": true
                });

              $('#myInputTextField').keyup(function(){
                    oTable.search($(this).val()).draw() ;
              })
         });






        function createChambre(){

          window.location.href = '<?php echo base_url() ?>createClient'

        }


      </script>