var fs = require('fs');
var casper = require('casper').create({
    viewportSize: {width: 1280, height: 1800}
});

var width = 1280;
var height = 1280;
var url = casper.cli.args[0];
casper.start(url, function(){
    width = this.evaluate(function(){
        return document.body.clientWidth;
    });
    height = this.evaluate(function(){
        return document.body.clientHeight;
    });
}).viewport(width, height).then(function(){
    this.capture("rh1.hclever.com.png");
    fs.write('rh1.hclever.com.html', this.getPageContent(), { mode: 'w'});  
}).run();


