var fs = require('fs');
var word = "";

var casper = require('casper').create({
  pageSettings: {
    userAgent: "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/535.1 (KHTML, like Gecko) "
  },
  viewport: {
    width: 1920,
    height: 1080
  },
  waitTimeout: 80000
});
casper.options.viewportSize = {width: 1920, height: 1080};

casper.on('error', function(msg) {
    this.capture('error.png');
    this.die(msg);
});

var category = casper.cli.args[0];
var make = casper.cli.args[1];
var model = casper.cli.args[2];
var type = casper.cli.args[3];
var text_category1 = 'text_category';
var text_make1 = 'text_make';
var text_model1 = 'selected_model';
var text_type1 = 'text_type';

casper.start('https://www.carlube.co.uk/categories-2/', function() {

  casper.wait(2000, function() {
    // this.captureSelector('carlube.com.png','body');
    // fs.write('carlube.com.html', this.getPageContent(), { mode: 'w'});
  });

  casper.wait(2000, function() {
    var found = this.evaluate(function(selector, valueToMatch){
        var select = document.querySelector(selector);
        select.selectedIndex = valueToMatch;

        var evt = document.createEvent("UIEvents");
        evt.initUIEvent("change", true, true);
        select.dispatchEvent(evt);

        return select.length-1;

    }, '.vrm-lookup-vehicle-category', category);

    if((found)<category){

      this.echo("category");
      this.exit();
    }

    // this.capture('vrm-lookup-vehicle-category.png');
  });
  casper.wait(2000, function() {
      var found = this.evaluate(function(selector, valueToMatch){
        var select = document.querySelector(selector);
        select.selectedIndex = valueToMatch;

        var evt = document.createEvent("UIEvents");
        evt.initUIEvent("change", true, true);
        select.dispatchEvent(evt);

        return select.length-1;

    }, '.vrm-lookup-make', make);

      if((found)<make){
        this.echo("make");
        this.exit();
      }
      // this.capture('vrm-lookup-make.png');
  });
  casper.wait(2000, function() {
      var found = this.evaluate(function(selector, valueToMatch){
        var select = document.querySelector(selector);
        select.selectedIndex = valueToMatch;

        var evt = document.createEvent("UIEvents");
        evt.initUIEvent("change", true, true);
        select.dispatchEvent(evt);

        return select.length-1;

    }, '.vrm-lookup-model', model);

      if((found)<model){
        this.echo("model");
        this.exit();
      }

      // this.capture('vrm-lookup-model.png');
  });
  casper.wait(2000, function() {


    var text_category = "";
    // selected_make = document.querySelector('.vrm-lookup-make');
    // var text_make = selected_make.options[make].text;
    // selected_model = document.querySelector('.vrm-lookup-model');
    // var text_model = selected_model.options[model].text;
    // selected_type = document.querySelector('.vrm-lookup-type');
    // var text_type = selected_type.options[type].text;

    var found = this.evaluate(function(selector, valueToMatch){

        text_category = document.querySelector('.vrm-lookup-vehicle-category').options[1].text;
        text_make = document.querySelector('.vrm-lookup-make').options[1].text;
        selected_model = document.querySelector('.vrm-lookup-model').options[1].text;
        text_type = document.querySelector('.vrm-lookup-type').options[1].text;

        var select = document.querySelector(selector);
        select.selectedIndex = valueToMatch;

        var evt = document.createEvent("UIEvents");
        evt.initUIEvent("change", true, true);
        select.dispatchEvent(evt);

        return { 'found':select.length-1,'text_category':text_category,'text_make':text_make,'selected_model':selected_model,'text_type':text_type };

    }, '.vrm-lookup-type', type);


      if((found['found'])<type){
        this.echo("type");
        this.exit();
      }
      text_category1 = found['text_category'];
      text_make1 = found['text_make'];
      text_model1 = found['selected_model'];
      text_type1 = found['text_type'];

      // this.capture('vrm-lookup-type.png');
  });
    casper.wait(2000, function() {
  })
  casper.then(function(){

    var html = this.evaluate(function(text_category,make,model,type){

    htmls = [];
   
    name = '';
    img = '';

    //var text_category = document.querySelector('.vrm-lookup-vehicle-category').options[category].text;
    // selected_make = document.querySelector('.vrm-lookup-make');
    // var text_make = selected_make.options[make].text;
    // selected_model = document.querySelector('.vrm-lookup-model');
    // var text_model = selected_model.options[model].text;
    // selected_type = document.querySelector('.vrm-lookup-type');
    // var text_type = selected_type.options[type].text;



    var sections = document.querySelectorAll('.elementor-widget-wrap .elementor-section-wrap');
    var d = 0;

    var articles = [];

    [].forEach.call(sections, function(section) {

        if(d>0){

         table = section.querySelector('table.data_table');

         name = section.querySelector('h1.ae-element-post-title').innerHTML;

         desc = section.querySelector('.dc-has-condition').innerHTML;

         img = section.querySelector('.elementor-column-wrap .elementor-widget-image img').src;


          for (var i = 1; i < table.rows.length; i++) {
            if (table.rows[i].cells.length) {
              var code = (table.rows[i].cells[0].textContent.trim());
              var taille = (table.rows[i].cells[1].textContent.trim());

             name =  name.replace(/<\/?[^>]+(>|$)/g, "");
             desc =  desc.replace(/<\/?[^>]+(>|$)/g, "");
             desc =  desc.replace(/\\t|\\n|\\(?=")/g, "");

              article = { 'desig':name+' '+taille,'image':img,'code':code,'taille':taille,'desc':desc,'category':text_category,'make':make,'model':model,'type':type };

              articles.push(article);                  
            }
          }

        }

        d++;
      
    }); 

    return JSON.stringify(articles); 

  },text_category1,text_make1,text_model1,text_type1);
  this.echo(html);
  // this.capture('vrm-lookupcategory-'+category+'-'+make+'-'+model+'-'+type+'.png'); 
});



}, function() {   
});
casper.run();

